"""AI Role model with shared CRUD operations."""
from datetime import datetime
from typing import Optional, List
from pydantic import BaseModel as CollectionTypes
from xqzhqdodft.database import db, BaseSchema


class AiRole(CollectionTypes):
    """AI Role schema - shared between ai and edge."""
    title: str
    text: str
    model: str
    temperature: float
    tools: List[str] = []
    date_updated: Optional[datetime] = None
    date_created: Optional[datetime] = None


class AiRoles(BaseSchema):
    """AI Role model with CRUD operations."""
    
    def __init__(self):
        super().__init__(db.get_collection('aiRoles'))
        self.schema = AiRole


ai_roles = AiRoles()
