"""Sprint model with shared CRUD operations."""
from datetime import datetime
from typing import List, Optional, Any
from pydantic import BaseModel as CollectionTypes
from xqzhqdodft.database import db, BaseSchema


class Sprint(CollectionTypes):
    """Sprint schema - shared between ai and edge."""
    id: Optional[str] = None
    user_id: str
    title: str
    project: str
    stage: int = 0
    tasks: List[Any] = []
    complete: bool = False
    text: str = ""
    content: Optional[Any] = None
    ai: Optional[Any] = None
    date_updated: str
    date_created: str


class Sprints(BaseSchema):
    """Sprint model with CRUD operations."""
    
    def __init__(self):
        super().__init__(db.get_collection('planSprints'))
        self.schema = Sprint


sprints = Sprints()
