"""Task model with shared CRUD operations."""
from datetime import date, datetime
from typing import List, Optional, Any
from pydantic import BaseModel as CollectionTypes
from xqzhqdodft.database import db, BaseSchema


class PlanTask(CollectionTypes):
    """Task schema - shared between ai and edge."""
    id: Optional[str] = None
    user_id: str
    title: str
    path: str
    text: str = ""
    output_path: Optional[str] = None
    priority: int = 3
    date: Optional[date] = None
    content: Optional[Any] = None
    ai_logs: Optional[Any] = None
    files: List[Any] = []
    complete: bool = False
    active: bool = True
    date_updated: Optional[str] = None
    date_created: Optional[str] = None


class PlanTasks(BaseSchema):
    """Task model with CRUD operations."""
    
    def __init__(self):
        super().__init__(db.get_collection('tasks'))
        self.schema = PlanTask


plan_tasks = PlanTasks()
