"""User model with shared CRUD operations."""
from datetime import datetime
from typing import Optional
from pydantic import BaseModel as CollectionTypes
from xqzhqdodft.database import db, BaseSchema


class User(CollectionTypes):
    """User schema - shared between ai and edge."""
    id: str
    email: str
    name: str
    picture: Optional[str] = None
    google_id: Optional[str] = None
    password_hash: Optional[str] = None
    last_login: Optional[datetime] = None
    active: bool = True
    date_updated: Optional[datetime] = None
    date_created: Optional[datetime] = None


class Users(BaseSchema):
    """User model with CRUD operations."""
    
    def __init__(self):
        super().__init__(db.get_collection('users'))
        self.schema = User


users = Users()
