def find_duplicate_lines(input_path, output_path):
    with open(input_path, 'r') as infile:
        lines = infile.readlines()
    seen = set()
    duplicates = set()
    for line in lines:
        line = line.rstrip('\n')
        if line in seen:
            duplicates.add(line)
        else:
            seen.add(line)
    with open(output_path, 'w') as outfile:
        for dup in duplicates:
            outfile.write(dup + '\n')

# Example usage:
find_duplicate_lines('input.txt', 'duplicates.txt')