# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from ..core.api_error import ApiError
from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.http_response import AsyncHttpResponse, HttpResponse
from ..core.pydantic_utilities import parse_obj_as
from ..core.request_options import RequestOptions
from ..types.bi_information_response import BiInformationResponse
from ..types.spans_count_response import SpansCountResponse
from ..types.trace_count_response import TraceCountResponse


class RawSystemUsageClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def get_dataset_bi_info(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[BiInformationResponse]:
        """
        Get datasets information for BI events per user per workspace

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[BiInformationResponse]
            Datasets BiInformationResponse resource
        """
        _response = self._client_wrapper.httpx_client.request(
            "v1/internal/usage/bi-datasets",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    BiInformationResponse,
                    parse_obj_as(
                        type_=BiInformationResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get_experiment_bi_info(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[BiInformationResponse]:
        """
        Get experiments information for BI events per user per workspace

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[BiInformationResponse]
            Experiments BiInformationResponse resource
        """
        _response = self._client_wrapper.httpx_client.request(
            "v1/internal/usage/bi-experiments",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    BiInformationResponse,
                    parse_obj_as(
                        type_=BiInformationResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get_spans_bi_info(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[BiInformationResponse]:
        """
        Get spans information for BI events per user per workspace

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[BiInformationResponse]
            Spans BiInformationResponse resource
        """
        _response = self._client_wrapper.httpx_client.request(
            "v1/internal/usage/bi-spans",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    BiInformationResponse,
                    parse_obj_as(
                        type_=BiInformationResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get_spans_count_for_workspaces(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[SpansCountResponse]:
        """
        Get spans count on previous day for all available workspaces

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[SpansCountResponse]
            SpanCountResponse resource
        """
        _response = self._client_wrapper.httpx_client.request(
            "v1/internal/usage/workspace-span-counts",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    SpansCountResponse,
                    parse_obj_as(
                        type_=SpansCountResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get_traces_bi_info(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[BiInformationResponse]:
        """
        Get traces information for BI events per user per workspace

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[BiInformationResponse]
            Traces BiInformationResponse resource
        """
        _response = self._client_wrapper.httpx_client.request(
            "v1/internal/usage/bi-traces",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    BiInformationResponse,
                    parse_obj_as(
                        type_=BiInformationResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get_traces_count_for_workspaces(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[TraceCountResponse]:
        """
        Get traces count on previous day for all available workspaces

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[TraceCountResponse]
            TraceCountResponse resource
        """
        _response = self._client_wrapper.httpx_client.request(
            "v1/internal/usage/workspace-trace-counts",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    TraceCountResponse,
                    parse_obj_as(
                        type_=TraceCountResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawSystemUsageClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def get_dataset_bi_info(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[BiInformationResponse]:
        """
        Get datasets information for BI events per user per workspace

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[BiInformationResponse]
            Datasets BiInformationResponse resource
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v1/internal/usage/bi-datasets",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    BiInformationResponse,
                    parse_obj_as(
                        type_=BiInformationResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get_experiment_bi_info(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[BiInformationResponse]:
        """
        Get experiments information for BI events per user per workspace

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[BiInformationResponse]
            Experiments BiInformationResponse resource
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v1/internal/usage/bi-experiments",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    BiInformationResponse,
                    parse_obj_as(
                        type_=BiInformationResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get_spans_bi_info(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[BiInformationResponse]:
        """
        Get spans information for BI events per user per workspace

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[BiInformationResponse]
            Spans BiInformationResponse resource
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v1/internal/usage/bi-spans",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    BiInformationResponse,
                    parse_obj_as(
                        type_=BiInformationResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get_spans_count_for_workspaces(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[SpansCountResponse]:
        """
        Get spans count on previous day for all available workspaces

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[SpansCountResponse]
            SpanCountResponse resource
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v1/internal/usage/workspace-span-counts",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    SpansCountResponse,
                    parse_obj_as(
                        type_=SpansCountResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get_traces_bi_info(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[BiInformationResponse]:
        """
        Get traces information for BI events per user per workspace

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[BiInformationResponse]
            Traces BiInformationResponse resource
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v1/internal/usage/bi-traces",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    BiInformationResponse,
                    parse_obj_as(
                        type_=BiInformationResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get_traces_count_for_workspaces(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[TraceCountResponse]:
        """
        Get traces count on previous day for all available workspaces

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[TraceCountResponse]
            TraceCountResponse resource
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v1/internal/usage/workspace-trace-counts",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    TraceCountResponse,
                    parse_obj_as(
                        type_=TraceCountResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
