"""Add user default project [1f1105204aaf].

Revision ID: 1f1105204aaf
Revises: 0.80.0
Create Date: 2025-03-25 11:11:13.480745

"""

import sqlalchemy as sa
import sqlmodel
from alembic import op

# revision identifiers, used by Alembic.
revision = "1f1105204aaf"
down_revision = "0.80.0"
branch_labels = None
depends_on = None


def upgrade() -> None:
    """Upgrade database schema and/or data, creating a new revision."""
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("user", schema=None) as batch_op:
        batch_op.add_column(
            sa.Column(
                "default_project_id",
                sqlmodel.sql.sqltypes.GUID(),
                nullable=True,
            )
        )
        batch_op.create_foreign_key(
            "fk_user_default_project_id_project",
            "project",
            ["default_project_id"],
            ["id"],
            ondelete="SET NULL",
        )

    # ### end Alembic commands ###


def downgrade() -> None:
    """Downgrade database schema and/or data back to the previous revision."""
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("user", schema=None) as batch_op:
        batch_op.drop_constraint(
            "fk_user_default_project_id_project", type_="foreignkey"
        )
        batch_op.drop_column("default_project_id")

    # ### end Alembic commands ###
