"""rename model_version to model [4d688d8f7aff].

Revision ID: 4d688d8f7aff
Revises: 0.54.1
Create Date: 2024-01-12 09:14:02.480376

"""

import sqlalchemy as sa
from alembic import op
from sqlmodel import Session

# revision identifiers, used by Alembic.
revision = "4d688d8f7aff"
down_revision = "0.54.1"
branch_labels = None
depends_on = None


update_stmts = [
    sa.text(
        """
        UPDATE pipeline_deployment
        SET pipeline_configuration = REPLACE(
            pipeline_configuration,
            :source_field,
            :target_field
        )
        WHERE pipeline_configuration IS NOT NULL
        """
    ),
    sa.text(
        """
        UPDATE pipeline_deployment
        SET step_configurations = REPLACE(
            step_configurations,
            :source_field,
            :target_field
        )
        WHERE step_configurations IS NOT NULL
        """
    ),
    sa.text(
        """
        UPDATE step_run
        SET step_configuration = REPLACE(
            step_configuration,
            :source_field,
            :target_field
        )
        WHERE step_configuration IS NOT NULL
        """
    ),
]


def upgrade() -> None:
    """Upgrade database schema and/or data, creating a new revision."""
    # ### commands auto generated by Alembic - please adjust! ###
    connection = op.get_bind()
    session = Session(bind=connection)

    for source_field, target_field in [
        ('"model_version"', '"model"'),
    ]:
        for update_stmt in update_stmts:
            session.execute(
                update_stmt,
                params=dict(
                    source_field=source_field,
                    target_field=target_field,
                ),
            )
    # ### end Alembic commands ###


def downgrade() -> None:
    """Downgrade database schema and/or data back to the previous revision."""
    # ### commands auto generated by Alembic - please adjust! ###
    connection = op.get_bind()
    session = Session(bind=connection)

    for source_field, target_field in [
        ('"model"', '"model_version"'),
    ]:
        for update_stmt in update_stmts:
            session.execute(
                update_stmt,
                params=dict(
                    source_field=source_field,
                    target_field=target_field,
                ),
            )

    # ### end Alembic commands ###
