"""

Revision ID: 79bc71ec6f9e
Revises: 6d252e23f543
Create Date: 2025-08-02 15:07:58.266933

"""

from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import sqlite

# revision identifiers, used by Alembic.
revision: str = "79bc71ec6f9e"
down_revision: Union[str, None] = "6d252e23f543"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###

    with op.batch_alter_table("analysis", schema=None) as batch_op:
        batch_op.add_column(sa.Column("max_year_loss", sa.Float(), nullable=True))
        batch_op.create_index(
            "ix_analysis_max_year_loss", ["max_year_loss"], unique=False
        )
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("analysis", schema=None) as batch_op:
        batch_op.drop_index("ix_analysis_max_year_loss")
        batch_op.drop_column("max_year_loss")

    # ### end Alembic commands ###
