"""

Revision ID: d663166c531d
Revises: fc191121f522
Create Date: 2025-07-09 17:44:25.728075

"""

from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import sqlite

# revision identifiers, used by Alembic.
revision: str = "d663166c531d"
down_revision: Union[str, None] = "fc191121f522"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("analysis", schema=None) as batch_op:
        batch_op.add_column(
            sa.Column("median_weekly_growth", sa.Float(), nullable=True)
        )
        batch_op.add_column(
            sa.Column("median_monthly_growth", sa.Float(), nullable=True)
        )
        batch_op.add_column(
            sa.Column("median_yearly_growth", sa.Float(), nullable=True)
        )
        batch_op.create_index(
            "ix_analysis_median_monthly_growth", ["median_monthly_growth"], unique=False
        )
        batch_op.create_index(
            "ix_analysis_median_weekly_growth", ["median_weekly_growth"], unique=False
        )
        batch_op.create_index(
            "ix_analysis_median_yearly_growth", ["median_yearly_growth"], unique=False
        )

    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("analysis", schema=None) as batch_op:
        batch_op.drop_index("ix_analysis_median_yearly_growth")
        batch_op.drop_index("ix_analysis_median_weekly_growth")
        batch_op.drop_index("ix_analysis_median_monthly_growth")
        batch_op.drop_column("median_yearly_growth")
        batch_op.drop_column("median_monthly_growth")
        batch_op.drop_column("median_weekly_growth")
    # ### end Alembic commands ###
