"""

Revision ID: ee5baabb35f8
Revises: 08ac1116e055
Create Date: 2025-07-02 05:16:42.862366

"""

from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import sqlite

# revision identifiers, used by Alembic.
revision: str = "ee5baabb35f8"
down_revision: Union[str, None] = "08ac1116e055"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("analysis", schema=None) as batch_op:
        batch_op.add_column(
            sa.Column("adosc_crosses_above_0", sa.Date(), nullable=True)
        )
        batch_op.add_column(
            sa.Column("positive_adosc_20_day_breakout", sa.Date(), nullable=True)
        )
        batch_op.create_index(
            "ix_analysis_adosc_crosses_above_0", ["adosc_crosses_above_0"], unique=False
        )
        batch_op.create_index(
            "ix_analysis_positive_adosc_20_day_breakout",
            ["positive_adosc_20_day_breakout"],
            unique=False,
        )

    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("analysis", schema=None) as batch_op:
        batch_op.drop_index("ix_analysis_positive_adosc_20_day_breakout")
        batch_op.drop_index("ix_analysis_adosc_crosses_above_0")
        batch_op.drop_column("positive_adosc_20_day_breakout")
        batch_op.drop_column("adosc_crosses_above_0")

    # ### end Alembic commands ###
