__all__ = [
    "EXTRACTORS",
]
base_import: str = "wisent.core.contrastive_pairs.lm_eval_pairs.lm_task_extractors."
EXTRACTORS: dict[str, str] = {
    # key → "module_path:ClassName" (supports dotted attr path after ':')
    "arc_challenge": f"{base_import}arc_challenge:Arc_ChallengeExtractor",
    "arc_easy": f"{base_import}arc_easy:Arc_EasyExtractor",
    "arithmetic": f"{base_import}arithmetic:ArithmeticExtractor",
    "asdiv": f"{base_import}asdiv:ASDivExtractor",
    "boolq": f"{base_import}boolq:BoolQExtractor",
    "cb": f"{base_import}cb:CBExtractor",
    "copa": f"{base_import}copa:COPAExtractor",
    "coqa": f"{base_import}coqa:CoQAExtractor",
    "drop": f"{base_import}drop:DROPExtractor",
    "gsm8k": f"{base_import}gsm8k:GSM8KExtractor",
    "headqa": f"{base_import}headqa:HeadQAExtractor",
    "hellaswag": f"{base_import}hellaswag:HellaSwagExtractor",
    "logiqa": f"{base_import}logiqa:LogiQAExtractor",
    "logiqa2": f"{base_import}logiqa2:LogiQA2Extractor",
    "mc_taco": f"{base_import}mc-taco:MCTACOExtractor",
    "medqa": f"{base_import}medqa:MedQAExtractor",
    "mrpc": f"{base_import}mrpc:MRPCExtractor",
    "multirc": f"{base_import}multirc:MultiRCExtractor",
    "mutual": f"{base_import}mutual:MutualExtractor",
    "openbookqa": f"{base_import}openbookqa:OpenBookQAExtractor",
    "pawsx": f"{base_import}pawsx:PAWSXExtractor",
    "piqa": f"{base_import}piqa:PIQAExtractor",
    "prost": f"{base_import}prost:PROSTExtractor",
    "pubmedqa": f"{base_import}pubmedqa:PubMedQAExtractor",
    "qa4mre": f"{base_import}qa4mre:QA4MREExtractor",
    "qasper": f"{base_import}qasper:QASPERExtractor",
    "qnli": f"{base_import}qnli:QNLIExtractor",
    "qqp": f"{base_import}qqp:QQPExtractor",
    "race": f"{base_import}race:RaceExtractor",
    "record": f"{base_import}record:ReCoRDExtractor",
    "rte": f"{base_import}rte:RTEExtractor",
    "sciq": f"{base_import}sciq:SciQExtractor",
    "social_iqa": f"{base_import}social_iqa:Social_IQAExtractor",
    "squad2": f"{base_import}squad2:SQuAD2Extractor",
    "sst2": f"{base_import}sst2:SST2Extractor",
    "swag": f"{base_import}swag:SWAGExtractor",
    "triviaqa": f"{base_import}triviaqa:TriviaQAExtractor",
    "truthfulqa_gen": f"{base_import}truthfulqa_gen:TruthfulQA_GenExtractor",
    "truthfulqa_mc1": f"{base_import}truthfulqa_mc1:TruthfulQA_MC1Extractor",
    "truthfulqa_mc2": f"{base_import}truthfulqa_mc2:TruthfulQA_MC2Extractor",
    "webqs": f"{base_import}webqs:WebQuestionsExtractor",
    "wic": f"{base_import}wic:WiCExtractor",
    "winogrande": f"{base_import}winogrande:WinograndeExtractor",
    "wnli": f"{base_import}wnli:WNLIExtractor",
    "wsc": f"{base_import}wsc:WSCExtractor",
    "xnli": f"{base_import}xnli:XNLIExtractor",
    "xstorycloze": f"{base_import}xstorycloze:XStoryClozeExtractor",
    "xwinograd": f"{base_import}xwinograd:XWinogradExtractor",
    "livecodebench": f"{base_import}livecodebench:LiveCodeBenchExtractor",
}
