# almanac
A simple fastapi application that services registered agents information

The `agentverse_client.almanac` package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- Package version: 1.0.0
- Generator version: 7.11.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python 3.8+

## Installation & Usage

This python library package is generated without supporting files like setup.py or requirements files

In this README.md we will cover the **async** version of this client, in case you are looking for the **sync** version,
please, check the following [README.md](https://github.com/fetchai/api-clients/blob/main/agentverse-client/agentverse_client/almanac_README.md).

To be able to use it, you will need these dependencies in your own package that uses this library:

* urllib3 >= 1.25.3, < 3.0.0
* python-dateutil >= 2.8.2
* aiohttp >= 3.8.4
* aiohttp-retry >= 2.8.3
* pydantic >= 2
* typing-extensions >= 4.7.1


## Getting Started

In your own code, to use this library to connect and interact with almanac,
you can run the following:

```python

import asyncio
from agentverse_client.almanac.aio import AlmanacApi, Configuration, ApiClient, ApiException
from pprint import pprint

async def main():
    # Defining the host is optional and defaults to https://agentverse.ai
    # See configuration.py for a list of all supported configuration parameters.
    configuration = Configuration(host="https://staging.agentverse.ai")

    # Enter a context with an instance of the API client
    async with (ApiClient(configuration) as api_client):
        # Create an instance of the API class
        api_instance = AlmanacApi(api_client)

        try:
            # Register Agent
            api_response = await api_instance.get_recently_registered_agents()
            print("The response of AlmanacApi->get_recently_registered_agents:\n")
            pprint(api_response)
        except ApiException as e:
            print("Exception when calling AlmanacApi->get_recently_registered_agents: %s\n" % e)

if __name__ == "__main__":
    asyncio.run(main())
```

## Documentation for API Endpoints

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AlmanacApi* | [**register_agent**](https://github.com/fetchai/api-clients/blob/main/agentverse-client/agentverse_client/almanac/aio/docs/AlmanacApi.md#register_agent) | **POST** /v1/almanac/agents | Register Agent
*AlmanacApi* | [**get_agent**](https://github.com/fetchai/api-clients/blob/main/agentverse-client/agentverse_client/almanac/aio/docs/AlmanacApi.md#get_agent) | **GET** /v1/almanac/agents/{address} | Get Specific Agent
*AlmanacApi* | [**get_agents_by_domain**](https://github.com/fetchai/api-clients/blob/main/agentverse-client/agentverse_client/almanac/aio/docs/AlmanacApi.md#get_agents_by_domain) | **GET** /v1/almanac/search/agents-by-domain/{domain_name} | Get Agents By Domain
*AlmanacApi* | [**get_domain_details**](https://github.com/fetchai/api-clients/blob/main/agentverse-client/agentverse_client/almanac/aio/docs/AlmanacApi.md#get_domain_details) | **GET** /v1/almanac/search/domain_details/{domain_name} | Get Domain Details
*AlmanacApi* | [**get_domain_record**](https://github.com/fetchai/api-clients/blob/main/agentverse-client/agentverse_client/almanac/aio/docs/AlmanacApi.md#get_domain_record) | **GET** /v1/almanac/domains/{domain} | Get Domain Record
*AlmanacApi* | [**get_domains**](https://github.com/fetchai/api-clients/blob/main/agentverse-client/agentverse_client/almanac/aio/docs/AlmanacApi.md#get_domains) | **GET** /v1/almanac/search/domains/{address} | Get Domains
*AlmanacApi* | [**get_recently_registered_agents**](https://github.com/fetchai/api-clients/blob/main/agentverse-client/agentverse_client/almanac/aio/docs/AlmanacApi.md#get_recently_registered_agents) | **GET** /v1/almanac/recent | Get Recently Registered Agents
*AlmanacApi* | [**register_agents_batch_v1_almanac_agents_batch_post**](https://github.com/fetchai/api-clients/blob/main/agentverse-client/agentverse_client/almanac/aio/docs/AlmanacApi.md#register_agents_batch_v1_almanac_agents_batch_post) | **POST** /v1/almanac/agents/batch | Register Agents Batch
*AlmanacApi* | [**search_agents**](https://github.com/fetchai/api-clients/blob/main/agentverse-client/agentverse_client/almanac/aio/docs/AlmanacApi.md#search_agents) | **POST** /v1/almanac/search | Search Agents
*AlmanacApi* | [**search_available_agent_name**](https://github.com/fetchai/api-clients/blob/main/agentverse-client/agentverse_client/almanac/aio/docs/AlmanacApi.md#search_available_agent_name) | **GET** /v1/almanac/search/available_name | Search Available Agent Name
*AlmanacApi* | [**update_agent_status**](https://github.com/fetchai/api-clients/blob/main/agentverse-client/agentverse_client/almanac/aio/docs/AlmanacApi.md#update_agent_status) | **POST** /v1/almanac/agents/{agent_address}/status | Update Agent Status


## Documentation For Models

 - [AddressPrefix](https://github.com/fetchai/api-clients/blob/main/agentverse-client/agentverse_client/almanac/aio/docs/AddressPrefix.md)
 - [Agent](https://github.com/fetchai/api-clients/blob/main/agentverse-client/agentverse_client/almanac/aio/docs/Agent.md)
 - [AgentEndpoint](https://github.com/fetchai/api-clients/blob/main/agentverse-client/agentverse_client/almanac/aio/docs/AgentEndpoint.md)
 - [AgentNameAvailability](https://github.com/fetchai/api-clients/blob/main/agentverse-client/agentverse_client/almanac/aio/docs/AgentNameAvailability.md)
 - [AgentNameAvailabilityStatus](https://github.com/fetchai/api-clients/blob/main/agentverse-client/agentverse_client/almanac/aio/docs/AgentNameAvailabilityStatus.md)
 - [AgentNetwork](https://github.com/fetchai/api-clients/blob/main/agentverse-client/agentverse_client/almanac/aio/docs/AgentNetwork.md)
 - [AgentRecord](https://github.com/fetchai/api-clients/blob/main/agentverse-client/agentverse_client/almanac/aio/docs/AgentRecord.md)
 - [AgentRegistrationAttestation](https://github.com/fetchai/api-clients/blob/main/agentverse-client/agentverse_client/almanac/aio/docs/AgentRegistrationAttestation.md)
 - [AgentRegistrationAttestationBatch](https://github.com/fetchai/api-clients/blob/main/agentverse-client/agentverse_client/almanac/aio/docs/AgentRegistrationAttestationBatch.md)
 - [AgentRegistrationAttestationMetadataValue](https://github.com/fetchai/api-clients/blob/main/agentverse-client/agentverse_client/almanac/aio/docs/AgentRegistrationAttestationMetadataValue.md)
 - [AgentSearch](https://github.com/fetchai/api-clients/blob/main/agentverse-client/agentverse_client/almanac/aio/docs/AgentSearch.md)
 - [AgentStatus](https://github.com/fetchai/api-clients/blob/main/agentverse-client/agentverse_client/almanac/aio/docs/AgentStatus.md)
 - [AgentStatusFilter](https://github.com/fetchai/api-clients/blob/main/agentverse-client/agentverse_client/almanac/aio/docs/AgentStatusFilter.md)
 - [AgentStatusUpdate](https://github.com/fetchai/api-clients/blob/main/agentverse-client/agentverse_client/almanac/aio/docs/AgentStatusUpdate.md)
 - [AgentType](https://github.com/fetchai/api-clients/blob/main/agentverse-client/agentverse_client/almanac/aio/docs/AgentType.md)
 - [DeveloperCategory](https://github.com/fetchai/api-clients/blob/main/agentverse-client/agentverse_client/almanac/aio/docs/DeveloperCategory.md)
 - [DomainDetails](https://github.com/fetchai/api-clients/blob/main/agentverse-client/agentverse_client/almanac/aio/docs/DomainDetails.md)
 - [DomainRecord](https://github.com/fetchai/api-clients/blob/main/agentverse-client/agentverse_client/almanac/aio/docs/DomainRecord.md)
 - [EndpointInput](https://github.com/fetchai/api-clients/blob/main/agentverse-client/agentverse_client/almanac/aio/docs/EndpointInput.md)
 - [EndpointOutput](https://github.com/fetchai/api-clients/blob/main/agentverse-client/agentverse_client/almanac/aio/docs/EndpointOutput.md)
 - [HTTPValidationError](https://github.com/fetchai/api-clients/blob/main/agentverse-client/agentverse_client/almanac/aio/docs/HTTPValidationError.md)
 - [Interaction](https://github.com/fetchai/api-clients/blob/main/agentverse-client/agentverse_client/almanac/aio/docs/Interaction.md)
 - [InteractionType](https://github.com/fetchai/api-clients/blob/main/agentverse-client/agentverse_client/almanac/aio/docs/InteractionType.md)
 - [LocationInner](https://github.com/fetchai/api-clients/blob/main/agentverse-client/agentverse_client/almanac/aio/docs/LocationInner.md)
 - [Manifest](https://github.com/fetchai/api-clients/blob/main/agentverse-client/agentverse_client/almanac/aio/docs/Manifest.md)
 - [Metadata](https://github.com/fetchai/api-clients/blob/main/agentverse-client/agentverse_client/almanac/aio/docs/Metadata.md)
 - [Model](https://github.com/fetchai/api-clients/blob/main/agentverse-client/agentverse_client/almanac/aio/docs/Model.md)
 - [ResolvedProtocolDigest](https://github.com/fetchai/api-clients/blob/main/agentverse-client/agentverse_client/almanac/aio/docs/ResolvedProtocolDigest.md)
 - [ResponseSearchAgents](https://github.com/fetchai/api-clients/blob/main/agentverse-client/agentverse_client/almanac/aio/docs/ResponseSearchAgents.md)
 - [ServiceRecord](https://github.com/fetchai/api-clients/blob/main/agentverse-client/agentverse_client/almanac/aio/docs/ServiceRecord.md)
 - [SortAgents](https://github.com/fetchai/api-clients/blob/main/agentverse-client/agentverse_client/almanac/aio/docs/SortAgents.md)
 - [ValidationError](https://github.com/fetchai/api-clients/blob/main/agentverse-client/agentverse_client/almanac/aio/docs/ValidationError.md)
 - [WithPaginationListAgent](https://github.com/fetchai/api-clients/blob/main/agentverse-client/agentverse_client/almanac/aio/docs/WithPaginationListAgent.md)


<a id="documentation-for-authorization"></a>
## Documentation For Authorization

Endpoints do not require authorization.
