# coding: utf-8

"""
    FastAPI

    A simple fastapi application that services registered agents information

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from agentverse_client.almanac.models.interaction import Interaction
from agentverse_client.almanac.models.metadata import Metadata
from agentverse_client.almanac.models.model import Model
from typing import Optional, Set
from typing_extensions import Self

class Manifest(BaseModel):
    """
    Manifest
    """ # noqa: E501
    version: Annotated[str, Field(strict=True)] = Field(description="Semantic version of the manifest")
    metadata: Metadata
    models: List[Model] = Field(description="List of included models")
    interactions: List[Interaction] = Field(description="Defined interactions between models")
    nodes: Optional[List[Dict[str, Any]]] = None
    edges: Optional[List[Dict[str, Any]]] = None
    __properties: ClassVar[List[str]] = ["version", "metadata", "models", "interactions", "nodes", "edges"]

    @field_validator('version')
    def version_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^[0-9]+\.[0-9]+(?:\.[0-9]+)?$", value):
            raise ValueError(r"must validate the regular expression /^[0-9]+\.[0-9]+(?:\.[0-9]+)?$/")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Manifest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of metadata
        if self.metadata:
            _dict['metadata'] = self.metadata.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in models (list)
        _items = []
        if self.models:
            for _item_models in self.models:
                if _item_models:
                    _items.append(_item_models.to_dict())
            _dict['models'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in interactions (list)
        _items = []
        if self.interactions:
            for _item_interactions in self.interactions:
                if _item_interactions:
                    _items.append(_item_interactions.to_dict())
            _dict['interactions'] = _items
        # set to None if nodes (nullable) is None
        # and model_fields_set contains the field
        if self.nodes is None and "nodes" in self.model_fields_set:
            _dict['nodes'] = None

        # set to None if edges (nullable) is None
        # and model_fields_set contains the field
        if self.edges is None and "edges" in self.model_fields_set:
            _dict['edges'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Manifest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "version": obj.get("version"),
            "metadata": Metadata.from_dict(obj["metadata"]) if obj.get("metadata") is not None else None,
            "models": [Model.from_dict(_item) for _item in obj["models"]] if obj.get("models") is not None else None,
            "interactions": [Interaction.from_dict(_item) for _item in obj["interactions"]] if obj.get("interactions") is not None else None,
            "nodes": obj.get("nodes"),
            "edges": obj.get("edges")
        })
        return _obj


