# coding: utf-8

"""
    Agent Hosting API

      ## Overview  The Agent Hosting API helps users deploy agents to the cloud  ## Authentication  The entire API requires that the user authenticate with the ecosystem first before accessing the api 

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from agentverse_client.hosting.aio.models.supported_package import SupportedPackage
from typing import Optional, Set
from typing_extensions import Self

class Packages(BaseModel):
    """
    Packages
    """ # noqa: E501
    packages: List[SupportedPackage] = Field(description="List of supported packages.")
    fayer_packages: Optional[List[SupportedPackage]] = None
    __properties: ClassVar[List[str]] = ["packages", "fayer_packages"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Packages from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in packages (list)
        _items = []
        if self.packages:
            for _item_packages in self.packages:
                if _item_packages:
                    _items.append(_item_packages.to_dict())
            _dict['packages'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in fayer_packages (list)
        _items = []
        if self.fayer_packages:
            for _item_fayer_packages in self.fayer_packages:
                if _item_fayer_packages:
                    _items.append(_item_fayer_packages.to_dict())
            _dict['fayer_packages'] = _items
        # set to None if fayer_packages (nullable) is None
        # and model_fields_set contains the field
        if self.fayer_packages is None and "fayer_packages" in self.model_fields_set:
            _dict['fayer_packages'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Packages from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "packages": [SupportedPackage.from_dict(_item) for _item in obj["packages"]] if obj.get("packages") is not None else None,
            "fayer_packages": [SupportedPackage.from_dict(_item) for _item in obj["fayer_packages"]] if obj.get("fayer_packages") is not None else None
        })
        return _obj


