# coding: utf-8

"""
    FastAPI

    An API for our smart search engine that provides the agent that best fits your needs.

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from agentverse_client.search.aio.models.agent_category import AgentCategory
from agentverse_client.search.aio.models.agent_geo_location import AgentGeoLocation
from agentverse_client.search.aio.models.agent_metadata_value import AgentMetadataValue
from agentverse_client.search.aio.models.agent_type import AgentType
from agentverse_client.search.aio.models.net_protocol import NetProtocol
from agentverse_client.search.aio.models.protocol import Protocol
from agentverse_client.search.aio.models.status_type import StatusType
from typing import Optional, Set
from typing_extensions import Self

class Agent(BaseModel):
    """
    Agent
    """ # noqa: E501
    address: StrictStr = Field(description="the address of the agent (this should be used as the id of the agent)")
    prefix: NetProtocol = Field(description="In which net it is running (mainnet or test-net)")
    name: StrictStr = Field(description="the public name of the agent")
    description: StrictStr = Field(description="the short description of the agent")
    readme: StrictStr = Field(description="the contents of the readme file")
    protocols: List[Protocol] = Field(description="the list of protocols supported by the agent")
    avatar_href: Optional[StrictStr] = None
    total_interactions: StrictInt = Field(description="the total interactions for this agent")
    recent_interactions: StrictInt = Field(description="the number of interactions in the last 90 days")
    rating: Optional[Union[StrictFloat, StrictInt]] = None
    status: StatusType = Field(description="the status if the agent")
    type: AgentType = Field(description="the type of agent")
    featured: Optional[StrictBool] = Field(default=False, description="signaled if the agent is featured or not")
    category: AgentCategory = Field(description="the creator of the agent")
    system_wide_tags: List[StrictStr] = Field(description="the system-wide tags assigned to the agent")
    geo_location: Optional[AgentGeoLocation] = None
    domain: Optional[StrictStr] = None
    metadata: Optional[Dict[str, AgentMetadataValue]] = None
    last_updated: datetime = Field(description="the time at which the agent was last updated at")
    created_at: datetime = Field(description="the time at which the agent was first visible or created")
    recent_success_rate: Optional[Union[StrictFloat, StrictInt]] = None
    __properties: ClassVar[List[str]] = ["address", "prefix", "name", "description", "readme", "protocols", "avatar_href", "total_interactions", "recent_interactions", "rating", "status", "type", "featured", "category", "system_wide_tags", "geo_location", "domain", "metadata", "last_updated", "created_at", "recent_success_rate"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Agent from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in protocols (list)
        _items = []
        if self.protocols:
            for _item_protocols in self.protocols:
                if _item_protocols:
                    _items.append(_item_protocols.to_dict())
            _dict['protocols'] = _items
        # override the default output from pydantic by calling `to_dict()` of geo_location
        if self.geo_location:
            _dict['geo_location'] = self.geo_location.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each value in metadata (dict)
        _field_dict = {}
        if self.metadata:
            for _key_metadata in self.metadata:
                if self.metadata[_key_metadata]:
                    _field_dict[_key_metadata] = self.metadata[_key_metadata].to_dict()
            _dict['metadata'] = _field_dict
        # set to None if avatar_href (nullable) is None
        # and model_fields_set contains the field
        if self.avatar_href is None and "avatar_href" in self.model_fields_set:
            _dict['avatar_href'] = None

        # set to None if rating (nullable) is None
        # and model_fields_set contains the field
        if self.rating is None and "rating" in self.model_fields_set:
            _dict['rating'] = None

        # set to None if geo_location (nullable) is None
        # and model_fields_set contains the field
        if self.geo_location is None and "geo_location" in self.model_fields_set:
            _dict['geo_location'] = None

        # set to None if domain (nullable) is None
        # and model_fields_set contains the field
        if self.domain is None and "domain" in self.model_fields_set:
            _dict['domain'] = None

        # set to None if metadata (nullable) is None
        # and model_fields_set contains the field
        if self.metadata is None and "metadata" in self.model_fields_set:
            _dict['metadata'] = None

        # set to None if recent_success_rate (nullable) is None
        # and model_fields_set contains the field
        if self.recent_success_rate is None and "recent_success_rate" in self.model_fields_set:
            _dict['recent_success_rate'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Agent from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "address": obj.get("address"),
            "prefix": obj.get("prefix"),
            "name": obj.get("name"),
            "description": obj.get("description"),
            "readme": obj.get("readme"),
            "protocols": [Protocol.from_dict(_item) for _item in obj["protocols"]] if obj.get("protocols") is not None else None,
            "avatar_href": obj.get("avatar_href"),
            "total_interactions": obj.get("total_interactions"),
            "recent_interactions": obj.get("recent_interactions"),
            "rating": obj.get("rating"),
            "status": obj.get("status"),
            "type": obj.get("type"),
            "featured": obj.get("featured") if obj.get("featured") is not None else False,
            "category": obj.get("category"),
            "system_wide_tags": obj.get("system_wide_tags"),
            "geo_location": AgentGeoLocation.from_dict(obj["geo_location"]) if obj.get("geo_location") is not None else None,
            "domain": obj.get("domain"),
            "metadata": dict(
                (_k, AgentMetadataValue.from_dict(_v))
                for _k, _v in obj["metadata"].items()
            )
            if obj.get("metadata") is not None
            else None,
            "last_updated": obj.get("last_updated"),
            "created_at": obj.get("created_at"),
            "recent_success_rate": obj.get("recent_success_rate")
        })
        return _obj


