# coding: utf-8

"""
    FastAPI

    An API for our smart search engine that provides the agent that best fits your needs.

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from agentverse_client.search.aio.models.agent_category import AgentCategory
from agentverse_client.search.aio.models.agent_type import AgentType
from agentverse_client.search.aio.models.interactions_threshold import InteractionsThreshold
from agentverse_client.search.aio.models.status_type import StatusType
from typing import Optional, Set
from typing_extensions import Self

class AgentFilters(BaseModel):
    """
    The set of filters that should be applied to the agent search entries
    """ # noqa: E501
    state: Optional[List[StatusType]] = Field(default=None, description="The state of the agent, i.e. is it alive or not")
    category: Optional[List[AgentCategory]] = Field(default=None, description="The category of the creator of the agent")
    agent_type: Optional[List[AgentType]] = Field(default=None, description="The category of how the agent is hosted")
    protocol_digest: Optional[List[StrictStr]] = Field(default=None, description="The digest(s) of the protocol(s) that belong(s) to the agent")
    has_location: Optional[StrictBool] = Field(default=False, description="If set to True, it will filter for agents that have a geo location specified")
    has_readme: Optional[StrictBool] = Field(default=False, description="If set to True, it will filter for agents that have a non-empty readme")
    n_interactions: Optional[InteractionsThreshold] = None
    tags: Optional[List[StrictStr]] = Field(default=None, description="The tag(s) associated to the agent")
    __properties: ClassVar[List[str]] = ["state", "category", "agent_type", "protocol_digest", "has_location", "has_readme", "n_interactions", "tags"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AgentFilters from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if n_interactions (nullable) is None
        # and model_fields_set contains the field
        if self.n_interactions is None and "n_interactions" in self.model_fields_set:
            _dict['n_interactions'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AgentFilters from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "state": obj.get("state"),
            "category": obj.get("category"),
            "agent_type": obj.get("agent_type"),
            "protocol_digest": obj.get("protocol_digest"),
            "has_location": obj.get("has_location") if obj.get("has_location") is not None else False,
            "has_readme": obj.get("has_readme") if obj.get("has_readme") is not None else False,
            "n_interactions": obj.get("n_interactions"),
            "tags": obj.get("tags")
        })
        return _obj


