# coding: utf-8

"""
    FastAPI

    An API for our smart search engine that provides the agent that best fits your needs.

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from agentverse_client.search.models.agent_contract import AgentContract
from typing import Optional, Set
from typing_extensions import Self

class AgentAsi1InteractionDetailed(BaseModel):
    """
    AgentAsi1InteractionDetailed
    """ # noqa: E501
    address: Annotated[str, Field(strict=True)] = Field(description="The address of the agent")
    contract: Optional[AgentContract] = Field(default=None, description="The Almanac contract where the agent is registered")
    success: StrictBool = Field(description="Denotes if agent execution by ASI1 was successful or not.")
    request: StrictStr = Field(description="Message sent to the agent.")
    response: StrictStr = Field(description="Response received from the agent.")
    from_verifier: StrictBool = Field(description="Denotes if the interaction came from the verifier agent. By default it's False - means it is an actual ASI1-agent interaction.")
    timestamp: StrictStr
    __properties: ClassVar[List[str]] = ["address", "contract", "success", "request", "response", "from_verifier", "timestamp"]

    @field_validator('address')
    def address_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^agent1[qpzry9x8gf2tvdw0s3jn54khce6mua7l]{59}$", value):
            raise ValueError(r"must validate the regular expression /^agent1[qpzry9x8gf2tvdw0s3jn54khce6mua7l]{59}$/")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AgentAsi1InteractionDetailed from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AgentAsi1InteractionDetailed from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "address": obj.get("address"),
            "contract": obj.get("contract"),
            "success": obj.get("success"),
            "request": obj.get("request"),
            "response": obj.get("response"),
            "from_verifier": obj.get("from_verifier"),
            "timestamp": obj.get("timestamp")
        })
        return _obj


