# coding: utf-8

"""
    FastAPI

    An API for our smart search engine that provides the agent that best fits your needs.

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing_extensions import Annotated
from agentverse_client.search.models.agent_contract import AgentContract
from typing import Optional, Set
from typing_extensions import Self

class AgentInsightsResponse(BaseModel):
    """
    AgentInsightsResponse
    """ # noqa: E501
    address: Annotated[str, Field(strict=True)] = Field(description="The address of the agent")
    contract: Optional[AgentContract] = Field(default=None, description="The Almanac contract where the agent is registered")
    asi1_total_interactions: StrictInt = Field(description="The total number of interactions with ASI:One.")
    asi1_total_success_interactions: StrictInt = Field(description="The total number of interactions with ASI:One that were deemed successful.")
    asi1_recent_interactions: StrictInt = Field(description="The number of interactions with ASI:One in the last 30 days.")
    asi1_recent_success_interactions: StrictInt = Field(description="The number of interactions with ASI:One in the last 30 days that were deemed successful.")
    verifier_total_interactions: StrictInt = Field(description="The total number of interactions with the verifier agent.")
    verifier_total_success_interactions: StrictInt = Field(description="The total number of interactions with the verifier agent that were deemed successful.")
    verifier_recent_interactions: StrictInt = Field(description="The number of interactions with the verifier agent in the last 30 days.")
    verifier_recent_success_interactions: StrictInt = Field(description="The number of interactions with the verifier agent in the last 30 days that were deemed successful.")
    readme_uniqueness_score: Optional[Union[Annotated[float, Field(le=1.0, strict=True, ge=0.0)], Annotated[int, Field(le=1, strict=True, ge=0)]]] = None
    readme_quality_score: Optional[Union[Annotated[float, Field(le=1.0, strict=True, ge=0.0)], Annotated[int, Field(le=1, strict=True, ge=0)]]] = None
    interactions_score: Optional[Union[Annotated[float, Field(le=1.0, strict=True, ge=0.0)], Annotated[int, Field(le=1, strict=True, ge=0)]]] = None
    rating: Union[Annotated[float, Field(le=5.0, strict=True, ge=0.0)], Annotated[int, Field(le=5, strict=True, ge=0)]] = Field(description="A score from 0 to 5, representing the rating of the agent. It takes different factors into account.")
    __properties: ClassVar[List[str]] = ["address", "contract", "asi1_total_interactions", "asi1_total_success_interactions", "asi1_recent_interactions", "asi1_recent_success_interactions", "verifier_total_interactions", "verifier_total_success_interactions", "verifier_recent_interactions", "verifier_recent_success_interactions", "readme_uniqueness_score", "readme_quality_score", "interactions_score", "rating"]

    @field_validator('address')
    def address_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^agent1[qpzry9x8gf2tvdw0s3jn54khce6mua7l]{59}$", value):
            raise ValueError(r"must validate the regular expression /^agent1[qpzry9x8gf2tvdw0s3jn54khce6mua7l]{59}$/")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AgentInsightsResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if readme_uniqueness_score (nullable) is None
        # and model_fields_set contains the field
        if self.readme_uniqueness_score is None and "readme_uniqueness_score" in self.model_fields_set:
            _dict['readme_uniqueness_score'] = None

        # set to None if readme_quality_score (nullable) is None
        # and model_fields_set contains the field
        if self.readme_quality_score is None and "readme_quality_score" in self.model_fields_set:
            _dict['readme_quality_score'] = None

        # set to None if interactions_score (nullable) is None
        # and model_fields_set contains the field
        if self.interactions_score is None and "interactions_score" in self.model_fields_set:
            _dict['interactions_score'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AgentInsightsResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "address": obj.get("address"),
            "contract": obj.get("contract"),
            "asi1_total_interactions": obj.get("asi1_total_interactions"),
            "asi1_total_success_interactions": obj.get("asi1_total_success_interactions"),
            "asi1_recent_interactions": obj.get("asi1_recent_interactions"),
            "asi1_recent_success_interactions": obj.get("asi1_recent_success_interactions"),
            "verifier_total_interactions": obj.get("verifier_total_interactions"),
            "verifier_total_success_interactions": obj.get("verifier_total_success_interactions"),
            "verifier_recent_interactions": obj.get("verifier_recent_interactions"),
            "verifier_recent_success_interactions": obj.get("verifier_recent_success_interactions"),
            "readme_uniqueness_score": obj.get("readme_uniqueness_score"),
            "readme_quality_score": obj.get("readme_quality_score"),
            "interactions_score": obj.get("interactions_score"),
            "rating": obj.get("rating")
        })
        return _obj


