# coding: utf-8

"""
    Storage API

     The storage service is an Agentverse service that makes it easier for users and agents to transfer assets.  For this initial use case, we will not be support the agent to agent use case.  In this way, users of Agentverse can create assets and set permissions for these assets to other users.  Importantly only the User ↔ [Agent] interactions are supported.  The user is always in control and must always create the asset which can the agents are interacting with.  This is an ephemeral storage engine, and is only expected to be used for short periods of time. 

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class AssetDownload(BaseModel):
    """
    AssetDownload
    """ # noqa: E501
    asset_id: StrictStr = Field(description="Unique identifier of the asset.")
    contents: Optional[StrictStr] = None
    mime_type: StrictStr = Field(description="MIME type of the asset (e.g., 'application/pdf').")
    expires_at: datetime = Field(description="Datetime when the asset will expire.")
    reference: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["asset_id", "contents", "mime_type", "expires_at", "reference"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AssetDownload from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if contents (nullable) is None
        # and model_fields_set contains the field
        if self.contents is None and "contents" in self.model_fields_set:
            _dict['contents'] = None

        # set to None if reference (nullable) is None
        # and model_fields_set contains the field
        if self.reference is None and "reference" in self.model_fields_set:
            _dict['reference'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AssetDownload from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "asset_id": obj.get("asset_id"),
            "contents": obj.get("contents"),
            "mime_type": obj.get("mime_type"),
            "expires_at": obj.get("expires_at"),
            "reference": obj.get("reference")
        })
        return _obj


