# coding: utf-8

"""
    Storage API

     The storage service is an Agentverse service that makes it easier for users and agents to transfer assets.  For this initial use case, we will not be support the agent to agent use case.  In this way, users of Agentverse can create assets and set permissions for these assets to other users.  Importantly only the User ↔ [Agent] interactions are supported.  The user is always in control and must always create the asset which can the agents are interacting with.  This is an ephemeral storage engine, and is only expected to be used for short periods of time. 

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List
from agentverse_client.storage.aio.models.pagination import Pagination
from agentverse_client.storage.aio.models.permission import Permission
from typing import Optional, Set
from typing_extensions import Self

class PermissionList(BaseModel):
    """
    PermissionList
    """ # noqa: E501
    items: List[Permission] = Field(description="List of permission entries.")
    pagination: Pagination
    __properties: ClassVar[List[str]] = ["items", "pagination"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PermissionList from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in items (list)
        _items = []
        if self.items:
            for _item_items in self.items:
                if _item_items:
                    _items.append(_item_items.to_dict())
            _dict['items'] = _items
        # override the default output from pydantic by calling `to_dict()` of pagination
        if self.pagination:
            _dict['pagination'] = self.pagination.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PermissionList from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "items": [Permission.from_dict(_item) for _item in obj["items"]] if obj.get("items") is not None else None,
            "pagination": Pagination.from_dict(obj["pagination"]) if obj.get("pagination") is not None else None
        })
        return _obj


