# Generated by Django 5.1.4 on 2025-05-28 06:56

import django.db.models.deletion
import django.utils.timezone
import taggit.managers
import utilities.json
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('dcim', '0200_populate_mac_addresses'),
        ('extras', '0122_charfield_null_choices'),
        ('taggit', '0006_rename_taggeditem_content_type_object_id_taggit_tagg_content_8fc721_idx'),
        ('virtualization', '0048_populate_mac_addresses'),
    ]

    operations = [
        migrations.CreateModel(
            name='LicenseType',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False)),
                ('created', models.DateTimeField(auto_now_add=True, null=True)),
                ('last_updated', models.DateTimeField(auto_now=True, null=True)),
                ('custom_field_data', models.JSONField(blank=True, default=dict, encoder=utilities.json.CustomFieldJSONEncoder)),
                ('name', models.CharField(max_length=255)),
                ('slug', models.SlugField(unique=True)),
                ('product_code', models.CharField(blank=True, max_length=255, null=True)),
                ('ean_code', models.CharField(blank=True, max_length=255, null=True)),
                ('volume_type', models.CharField(max_length=20)),
                ('volume_relation', models.CharField(blank=True, max_length=20, null=True)),
                ('license_model', models.CharField(default='base', max_length=20)),
                ('purchase_model', models.CharField(blank=True, max_length=20, null=True)),
                ('description', models.CharField(blank=True, max_length=255, null=True)),
                ('comments', models.TextField(blank=True, null=True)),
                ('base_license', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='expansions', to='netbox_license.licensetype')),
                ('manufacturer', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='license_types', to='dcim.manufacturer')),
                ('tags', taggit.managers.TaggableManager(through='extras.TaggedItem', to='extras.Tag')),
            ],
            options={
                'verbose_name': 'License Type',
                'verbose_name_plural': 'License Types',
            },
        ),
        migrations.CreateModel(
            name='License',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False)),
                ('created', models.DateTimeField(auto_now_add=True, null=True)),
                ('last_updated', models.DateTimeField(auto_now=True, null=True)),
                ('custom_field_data', models.JSONField(blank=True, default=dict, encoder=utilities.json.CustomFieldJSONEncoder)),
                ('license_key', models.CharField(max_length=255, unique=True)),
                ('serial_number', models.CharField(blank=True, max_length=255, null=True)),
                ('description', models.CharField(blank=True, max_length=255, null=True)),
                ('comments', models.TextField(blank=True, null=True)),
                ('purchase_date', models.DateField(blank=True, null=True)),
                ('expiry_date', models.DateField(blank=True, null=True)),
                ('volume_limit', models.PositiveIntegerField(blank=True, null=True)),
                ('manufacturer', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='lm_licenses', to='dcim.manufacturer')),
                ('parent_license', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='sub_licenses', to='netbox_license.license')),
                ('tags', taggit.managers.TaggableManager(through='taggit.TaggedItem', to='taggit.Tag')),
                ('license_type', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='licenses', to='netbox_license.licensetype')),
            ],
            options={
                'verbose_name': 'Licenses',
                'verbose_name_plural': 'Licenses',
            },
        ),
        migrations.CreateModel(
            name='LicenseAssignment',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False)),
                ('created', models.DateTimeField(auto_now_add=True, null=True)),
                ('last_updated', models.DateTimeField(auto_now=True, null=True)),
                ('custom_field_data', models.JSONField(blank=True, default=dict, encoder=utilities.json.CustomFieldJSONEncoder)),
                ('volume', models.PositiveIntegerField(default=1)),
                ('assigned_to', models.DateTimeField(default=django.utils.timezone.now)),
                ('description', models.CharField(blank=True, max_length=255, null=True)),
                ('comments', models.TextField(blank=True, null=True)),
                ('device', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='license_assignments', to='dcim.device')),
                ('device_manufacturer', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='device_license_assignments', to='dcim.manufacturer')),
                ('license', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='assignments', to='netbox_license.license')),
                ('manufacturer', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='lm_assignments', to='dcim.manufacturer')),
                ('tags', taggit.managers.TaggableManager(through='taggit.TaggedItem', to='taggit.Tag')),
                ('virtual_machine', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='license_assignments', to='virtualization.virtualmachine')),
            ],
            options={
                'verbose_name': 'License Assignments',
                'verbose_name_plural': 'License Assignments',
                'constraints': [models.CheckConstraint(condition=models.Q(('device__isnull', False), ('virtual_machine__isnull', False), _connector='OR'), name='licenseassign_either_device_or_vm_required'), models.CheckConstraint(condition=models.Q(('device__isnull', False), ('virtual_machine__isnull', False), _negated=True), name='licenseassign_only_one_target_allowed')],
            },
        ),
    ]
