# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ProjectArgs', 'Project']

@pulumi.input_type
class ProjectArgs:
    def __init__(__self__, *,
                 ai_services_hub_id: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 friendly_name: Optional[pulumi.Input[_builtins.str]] = None,
                 high_business_impact_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 identity: Optional[pulumi.Input['ProjectIdentityArgs']] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 primary_user_assigned_identity: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a Project resource.
        :param pulumi.Input[_builtins.str] ai_services_hub_id: The AI Foundry ID under which this Project should be created. Changing this forces a new AI Foundry Project to be created.
        :param pulumi.Input[_builtins.str] description: The description of this AI Foundry Project.
        :param pulumi.Input[_builtins.str] friendly_name: The display name of this AI Foundry Project.
        :param pulumi.Input[_builtins.bool] high_business_impact_enabled: Whether High Business Impact (HBI) should be enabled or not. Enabling this setting will reduce diagnostic data collected by the service. Changing this forces a new AI Foundry Project to be created. Defaults to `false`.
        :param pulumi.Input['ProjectIdentityArgs'] identity: A `identity` block as defined below.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the AI Foundry Project should exist. Changing this forces a new AI Foundry Project to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this AI Foundry Project. Changing this forces a new AI Foundry Project to be created.
        :param pulumi.Input[_builtins.str] primary_user_assigned_identity: The user assigned identity ID that represents the AI Foundry Hub identity. This must be set when enabling encryption with a user assigned identity.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the AI Foundry Project.
        """
        pulumi.set(__self__, "ai_services_hub_id", ai_services_hub_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if friendly_name is not None:
            pulumi.set(__self__, "friendly_name", friendly_name)
        if high_business_impact_enabled is not None:
            pulumi.set(__self__, "high_business_impact_enabled", high_business_impact_enabled)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if primary_user_assigned_identity is not None:
            pulumi.set(__self__, "primary_user_assigned_identity", primary_user_assigned_identity)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="aiServicesHubId")
    def ai_services_hub_id(self) -> pulumi.Input[_builtins.str]:
        """
        The AI Foundry ID under which this Project should be created. Changing this forces a new AI Foundry Project to be created.
        """
        return pulumi.get(self, "ai_services_hub_id")

    @ai_services_hub_id.setter
    def ai_services_hub_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "ai_services_hub_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of this AI Foundry Project.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The display name of this AI Foundry Project.
        """
        return pulumi.get(self, "friendly_name")

    @friendly_name.setter
    def friendly_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "friendly_name", value)

    @_builtins.property
    @pulumi.getter(name="highBusinessImpactEnabled")
    def high_business_impact_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether High Business Impact (HBI) should be enabled or not. Enabling this setting will reduce diagnostic data collected by the service. Changing this forces a new AI Foundry Project to be created. Defaults to `false`.
        """
        return pulumi.get(self, "high_business_impact_enabled")

    @high_business_impact_enabled.setter
    def high_business_impact_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "high_business_impact_enabled", value)

    @_builtins.property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['ProjectIdentityArgs']]:
        """
        A `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['ProjectIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Azure Region where the AI Foundry Project should exist. Changing this forces a new AI Foundry Project to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this AI Foundry Project. Changing this forces a new AI Foundry Project to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="primaryUserAssignedIdentity")
    def primary_user_assigned_identity(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The user assigned identity ID that represents the AI Foundry Hub identity. This must be set when enabling encryption with a user assigned identity.
        """
        return pulumi.get(self, "primary_user_assigned_identity")

    @primary_user_assigned_identity.setter
    def primary_user_assigned_identity(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "primary_user_assigned_identity", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the AI Foundry Project.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _ProjectState:
    def __init__(__self__, *,
                 ai_services_hub_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 friendly_name: Optional[pulumi.Input[_builtins.str]] = None,
                 high_business_impact_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 identity: Optional[pulumi.Input['ProjectIdentityArgs']] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 primary_user_assigned_identity: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering Project resources.
        :param pulumi.Input[_builtins.str] ai_services_hub_id: The AI Foundry ID under which this Project should be created. Changing this forces a new AI Foundry Project to be created.
        :param pulumi.Input[_builtins.str] description: The description of this AI Foundry Project.
        :param pulumi.Input[_builtins.str] friendly_name: The display name of this AI Foundry Project.
        :param pulumi.Input[_builtins.bool] high_business_impact_enabled: Whether High Business Impact (HBI) should be enabled or not. Enabling this setting will reduce diagnostic data collected by the service. Changing this forces a new AI Foundry Project to be created. Defaults to `false`.
        :param pulumi.Input['ProjectIdentityArgs'] identity: A `identity` block as defined below.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the AI Foundry Project should exist. Changing this forces a new AI Foundry Project to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this AI Foundry Project. Changing this forces a new AI Foundry Project to be created.
        :param pulumi.Input[_builtins.str] primary_user_assigned_identity: The user assigned identity ID that represents the AI Foundry Hub identity. This must be set when enabling encryption with a user assigned identity.
        :param pulumi.Input[_builtins.str] project_id: The immutable project ID associated with this AI Foundry Project.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the AI Foundry Project.
        """
        if ai_services_hub_id is not None:
            pulumi.set(__self__, "ai_services_hub_id", ai_services_hub_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if friendly_name is not None:
            pulumi.set(__self__, "friendly_name", friendly_name)
        if high_business_impact_enabled is not None:
            pulumi.set(__self__, "high_business_impact_enabled", high_business_impact_enabled)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if primary_user_assigned_identity is not None:
            pulumi.set(__self__, "primary_user_assigned_identity", primary_user_assigned_identity)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="aiServicesHubId")
    def ai_services_hub_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The AI Foundry ID under which this Project should be created. Changing this forces a new AI Foundry Project to be created.
        """
        return pulumi.get(self, "ai_services_hub_id")

    @ai_services_hub_id.setter
    def ai_services_hub_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ai_services_hub_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of this AI Foundry Project.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The display name of this AI Foundry Project.
        """
        return pulumi.get(self, "friendly_name")

    @friendly_name.setter
    def friendly_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "friendly_name", value)

    @_builtins.property
    @pulumi.getter(name="highBusinessImpactEnabled")
    def high_business_impact_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether High Business Impact (HBI) should be enabled or not. Enabling this setting will reduce diagnostic data collected by the service. Changing this forces a new AI Foundry Project to be created. Defaults to `false`.
        """
        return pulumi.get(self, "high_business_impact_enabled")

    @high_business_impact_enabled.setter
    def high_business_impact_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "high_business_impact_enabled", value)

    @_builtins.property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['ProjectIdentityArgs']]:
        """
        A `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['ProjectIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Azure Region where the AI Foundry Project should exist. Changing this forces a new AI Foundry Project to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this AI Foundry Project. Changing this forces a new AI Foundry Project to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="primaryUserAssignedIdentity")
    def primary_user_assigned_identity(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The user assigned identity ID that represents the AI Foundry Hub identity. This must be set when enabling encryption with a user assigned identity.
        """
        return pulumi.get(self, "primary_user_assigned_identity")

    @primary_user_assigned_identity.setter
    def primary_user_assigned_identity(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "primary_user_assigned_identity", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The immutable project ID associated with this AI Foundry Project.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the AI Foundry Project.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("azure:aifoundry/project:Project")
class Project(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ai_services_hub_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 friendly_name: Optional[pulumi.Input[_builtins.str]] = None,
                 high_business_impact_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 identity: Optional[pulumi.Input[Union['ProjectIdentityArgs', 'ProjectIdentityArgsDict']]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 primary_user_assigned_identity: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Manages an AI Foundry Project.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        current = azure.core.get_client_config()
        example = azure.core.ResourceGroup("example",
            name="example",
            location="westeurope")
        example_key_vault = azure.keyvault.KeyVault("example",
            name="examplekv",
            location=example.location,
            resource_group_name=example.name,
            tenant_id=current.tenant_id,
            sku_name="standard",
            purge_protection_enabled=True)
        example_access_policy = azure.keyvault.AccessPolicy("example",
            key_vault_id=example_key_vault.id,
            tenant_id=current.tenant_id,
            object_id=current.object_id,
            key_permissions=[
                "Create",
                "Get",
                "Delete",
                "Purge",
                "GetRotationPolicy",
            ])
        example_account = azure.storage.Account("example",
            name="examplesa",
            location=example.location,
            resource_group_name=example.name,
            account_tier="Standard",
            account_replication_type="LRS")
        example_ai_services = azure.cognitive.AIServices("example",
            name="exampleaiservices",
            location=example.location,
            resource_group_name=example.name,
            sku_name="S0")
        example_hub = azure.aifoundry.Hub("example",
            name="exampleaihub",
            location=example_ai_services.location,
            resource_group_name=example.name,
            storage_account_id=example_account.id,
            key_vault_id=example_key_vault.id,
            identity={
                "type": "SystemAssigned",
            })
        example_project = azure.aifoundry.Project("example",
            name="example",
            location=example_hub.location,
            ai_services_hub_id=example_hub.id)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.MachineLearningServices` - 2025-06-01

        ## Import

        AI Foundry Projects can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:aifoundry/project:Project example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.MachineLearningServices/workspaces/project1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] ai_services_hub_id: The AI Foundry ID under which this Project should be created. Changing this forces a new AI Foundry Project to be created.
        :param pulumi.Input[_builtins.str] description: The description of this AI Foundry Project.
        :param pulumi.Input[_builtins.str] friendly_name: The display name of this AI Foundry Project.
        :param pulumi.Input[_builtins.bool] high_business_impact_enabled: Whether High Business Impact (HBI) should be enabled or not. Enabling this setting will reduce diagnostic data collected by the service. Changing this forces a new AI Foundry Project to be created. Defaults to `false`.
        :param pulumi.Input[Union['ProjectIdentityArgs', 'ProjectIdentityArgsDict']] identity: A `identity` block as defined below.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the AI Foundry Project should exist. Changing this forces a new AI Foundry Project to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this AI Foundry Project. Changing this forces a new AI Foundry Project to be created.
        :param pulumi.Input[_builtins.str] primary_user_assigned_identity: The user assigned identity ID that represents the AI Foundry Hub identity. This must be set when enabling encryption with a user assigned identity.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the AI Foundry Project.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ProjectArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an AI Foundry Project.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        current = azure.core.get_client_config()
        example = azure.core.ResourceGroup("example",
            name="example",
            location="westeurope")
        example_key_vault = azure.keyvault.KeyVault("example",
            name="examplekv",
            location=example.location,
            resource_group_name=example.name,
            tenant_id=current.tenant_id,
            sku_name="standard",
            purge_protection_enabled=True)
        example_access_policy = azure.keyvault.AccessPolicy("example",
            key_vault_id=example_key_vault.id,
            tenant_id=current.tenant_id,
            object_id=current.object_id,
            key_permissions=[
                "Create",
                "Get",
                "Delete",
                "Purge",
                "GetRotationPolicy",
            ])
        example_account = azure.storage.Account("example",
            name="examplesa",
            location=example.location,
            resource_group_name=example.name,
            account_tier="Standard",
            account_replication_type="LRS")
        example_ai_services = azure.cognitive.AIServices("example",
            name="exampleaiservices",
            location=example.location,
            resource_group_name=example.name,
            sku_name="S0")
        example_hub = azure.aifoundry.Hub("example",
            name="exampleaihub",
            location=example_ai_services.location,
            resource_group_name=example.name,
            storage_account_id=example_account.id,
            key_vault_id=example_key_vault.id,
            identity={
                "type": "SystemAssigned",
            })
        example_project = azure.aifoundry.Project("example",
            name="example",
            location=example_hub.location,
            ai_services_hub_id=example_hub.id)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.MachineLearningServices` - 2025-06-01

        ## Import

        AI Foundry Projects can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:aifoundry/project:Project example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.MachineLearningServices/workspaces/project1
        ```

        :param str resource_name: The name of the resource.
        :param ProjectArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProjectArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ai_services_hub_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 friendly_name: Optional[pulumi.Input[_builtins.str]] = None,
                 high_business_impact_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 identity: Optional[pulumi.Input[Union['ProjectIdentityArgs', 'ProjectIdentityArgsDict']]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 primary_user_assigned_identity: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProjectArgs.__new__(ProjectArgs)

            if ai_services_hub_id is None and not opts.urn:
                raise TypeError("Missing required property 'ai_services_hub_id'")
            __props__.__dict__["ai_services_hub_id"] = ai_services_hub_id
            __props__.__dict__["description"] = description
            __props__.__dict__["friendly_name"] = friendly_name
            __props__.__dict__["high_business_impact_enabled"] = high_business_impact_enabled
            __props__.__dict__["identity"] = identity
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            __props__.__dict__["primary_user_assigned_identity"] = primary_user_assigned_identity
            __props__.__dict__["tags"] = tags
            __props__.__dict__["project_id"] = None
        super(Project, __self__).__init__(
            'azure:aifoundry/project:Project',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            ai_services_hub_id: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            friendly_name: Optional[pulumi.Input[_builtins.str]] = None,
            high_business_impact_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            identity: Optional[pulumi.Input[Union['ProjectIdentityArgs', 'ProjectIdentityArgsDict']]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            primary_user_assigned_identity: Optional[pulumi.Input[_builtins.str]] = None,
            project_id: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None) -> 'Project':
        """
        Get an existing Project resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] ai_services_hub_id: The AI Foundry ID under which this Project should be created. Changing this forces a new AI Foundry Project to be created.
        :param pulumi.Input[_builtins.str] description: The description of this AI Foundry Project.
        :param pulumi.Input[_builtins.str] friendly_name: The display name of this AI Foundry Project.
        :param pulumi.Input[_builtins.bool] high_business_impact_enabled: Whether High Business Impact (HBI) should be enabled or not. Enabling this setting will reduce diagnostic data collected by the service. Changing this forces a new AI Foundry Project to be created. Defaults to `false`.
        :param pulumi.Input[Union['ProjectIdentityArgs', 'ProjectIdentityArgsDict']] identity: A `identity` block as defined below.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the AI Foundry Project should exist. Changing this forces a new AI Foundry Project to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this AI Foundry Project. Changing this forces a new AI Foundry Project to be created.
        :param pulumi.Input[_builtins.str] primary_user_assigned_identity: The user assigned identity ID that represents the AI Foundry Hub identity. This must be set when enabling encryption with a user assigned identity.
        :param pulumi.Input[_builtins.str] project_id: The immutable project ID associated with this AI Foundry Project.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the AI Foundry Project.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ProjectState.__new__(_ProjectState)

        __props__.__dict__["ai_services_hub_id"] = ai_services_hub_id
        __props__.__dict__["description"] = description
        __props__.__dict__["friendly_name"] = friendly_name
        __props__.__dict__["high_business_impact_enabled"] = high_business_impact_enabled
        __props__.__dict__["identity"] = identity
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["primary_user_assigned_identity"] = primary_user_assigned_identity
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["tags"] = tags
        return Project(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="aiServicesHubId")
    def ai_services_hub_id(self) -> pulumi.Output[_builtins.str]:
        """
        The AI Foundry ID under which this Project should be created. Changing this forces a new AI Foundry Project to be created.
        """
        return pulumi.get(self, "ai_services_hub_id")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of this AI Foundry Project.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The display name of this AI Foundry Project.
        """
        return pulumi.get(self, "friendly_name")

    @_builtins.property
    @pulumi.getter(name="highBusinessImpactEnabled")
    def high_business_impact_enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether High Business Impact (HBI) should be enabled or not. Enabling this setting will reduce diagnostic data collected by the service. Changing this forces a new AI Foundry Project to be created. Defaults to `false`.
        """
        return pulumi.get(self, "high_business_impact_enabled")

    @_builtins.property
    @pulumi.getter
    def identity(self) -> pulumi.Output[Optional['outputs.ProjectIdentity']]:
        """
        A `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        The Azure Region where the AI Foundry Project should exist. Changing this forces a new AI Foundry Project to be created.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name which should be used for this AI Foundry Project. Changing this forces a new AI Foundry Project to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="primaryUserAssignedIdentity")
    def primary_user_assigned_identity(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The user assigned identity ID that represents the AI Foundry Hub identity. This must be set when enabling encryption with a user assigned identity.
        """
        return pulumi.get(self, "primary_user_assigned_identity")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[_builtins.str]:
        """
        The immutable project ID associated with this AI Foundry Project.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags which should be assigned to the AI Foundry Project.
        """
        return pulumi.get(self, "tags")

