# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetGatewayResult',
    'AwaitableGetGatewayResult',
    'get_gateway',
    'get_gateway_output',
]

@pulumi.output_type
class GetGatewayResult:
    """
    A collection of values returned by getGateway.
    """
    def __init__(__self__, api_management_id=None, description=None, id=None, location_datas=None, name=None):
        if api_management_id and not isinstance(api_management_id, str):
            raise TypeError("Expected argument 'api_management_id' to be a str")
        pulumi.set(__self__, "api_management_id", api_management_id)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if location_datas and not isinstance(location_datas, list):
            raise TypeError("Expected argument 'location_datas' to be a list")
        pulumi.set(__self__, "location_datas", location_datas)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="apiManagementId")
    def api_management_id(self) -> _builtins.str:
        return pulumi.get(self, "api_management_id")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description of the API Management Gateway.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="locationDatas")
    def location_datas(self) -> Sequence['outputs.GetGatewayLocationDataResult']:
        """
        A `location_data` block as documented below.
        """
        return pulumi.get(self, "location_datas")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        A canonical name for the geographic or physical location.
        """
        return pulumi.get(self, "name")


class AwaitableGetGatewayResult(GetGatewayResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetGatewayResult(
            api_management_id=self.api_management_id,
            description=self.description,
            id=self.id,
            location_datas=self.location_datas,
            name=self.name)


def get_gateway(api_management_id: Optional[_builtins.str] = None,
                name: Optional[_builtins.str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetGatewayResult:
    """
    Use this data source to access information about an existing API Management Gateway.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.apimanagement.get_service(name="example-apim",
        resource_group_name="example-rg")
    example_get_gateway = azure.apimanagement.get_gateway(name="example-api-gateway",
        api_management_id=example.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.ApiManagement` - 2022-08-01


    :param _builtins.str api_management_id: The ID of the API Management Service in which the Gateway exists.
    :param _builtins.str name: The name of the API Management Gateway.
    """
    __args__ = dict()
    __args__['apiManagementId'] = api_management_id
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:apimanagement/getGateway:getGateway', __args__, opts=opts, typ=GetGatewayResult).value

    return AwaitableGetGatewayResult(
        api_management_id=pulumi.get(__ret__, 'api_management_id'),
        description=pulumi.get(__ret__, 'description'),
        id=pulumi.get(__ret__, 'id'),
        location_datas=pulumi.get(__ret__, 'location_datas'),
        name=pulumi.get(__ret__, 'name'))
def get_gateway_output(api_management_id: Optional[pulumi.Input[_builtins.str]] = None,
                       name: Optional[pulumi.Input[_builtins.str]] = None,
                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetGatewayResult]:
    """
    Use this data source to access information about an existing API Management Gateway.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.apimanagement.get_service(name="example-apim",
        resource_group_name="example-rg")
    example_get_gateway = azure.apimanagement.get_gateway(name="example-api-gateway",
        api_management_id=example.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.ApiManagement` - 2022-08-01


    :param _builtins.str api_management_id: The ID of the API Management Service in which the Gateway exists.
    :param _builtins.str name: The name of the API Management Gateway.
    """
    __args__ = dict()
    __args__['apiManagementId'] = api_management_id
    __args__['name'] = name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:apimanagement/getGateway:getGateway', __args__, opts=opts, typ=GetGatewayResult)
    return __ret__.apply(lambda __response__: GetGatewayResult(
        api_management_id=pulumi.get(__response__, 'api_management_id'),
        description=pulumi.get(__response__, 'description'),
        id=pulumi.get(__response__, 'id'),
        location_datas=pulumi.get(__response__, 'location_datas'),
        name=pulumi.get(__response__, 'name')))
