# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['LoggerArgs', 'Logger']

@pulumi.input_type
class LoggerArgs:
    def __init__(__self__, *,
                 api_management_name: pulumi.Input[_builtins.str],
                 resource_group_name: pulumi.Input[_builtins.str],
                 application_insights: Optional[pulumi.Input['LoggerApplicationInsightsArgs']] = None,
                 buffered: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 eventhub: Optional[pulumi.Input['LoggerEventhubArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Logger resource.
        :param pulumi.Input[_builtins.str] api_management_name: The name of the API Management Service. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group in which the API Management Service exists. Changing this forces a new resource to be created.
        :param pulumi.Input['LoggerApplicationInsightsArgs'] application_insights: An `application_insights` block as documented below. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] buffered: Specifies whether records should be buffered in the Logger prior to publishing. Defaults to `true`.
        :param pulumi.Input[_builtins.str] description: A description of this Logger.
        :param pulumi.Input['LoggerEventhubArgs'] eventhub: An `eventhub` block as documented below. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name of this Logger, which must be unique within the API Management Service. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_id: The target resource id which will be linked in the API-Management portal page. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "api_management_name", api_management_name)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if application_insights is not None:
            pulumi.set(__self__, "application_insights", application_insights)
        if buffered is not None:
            pulumi.set(__self__, "buffered", buffered)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if eventhub is not None:
            pulumi.set(__self__, "eventhub", eventhub)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)

    @_builtins.property
    @pulumi.getter(name="apiManagementName")
    def api_management_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the API Management Service. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "api_management_name")

    @api_management_name.setter
    def api_management_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "api_management_name", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the Resource Group in which the API Management Service exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="applicationInsights")
    def application_insights(self) -> Optional[pulumi.Input['LoggerApplicationInsightsArgs']]:
        """
        An `application_insights` block as documented below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "application_insights")

    @application_insights.setter
    def application_insights(self, value: Optional[pulumi.Input['LoggerApplicationInsightsArgs']]):
        pulumi.set(self, "application_insights", value)

    @_builtins.property
    @pulumi.getter
    def buffered(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether records should be buffered in the Logger prior to publishing. Defaults to `true`.
        """
        return pulumi.get(self, "buffered")

    @buffered.setter
    def buffered(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "buffered", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A description of this Logger.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def eventhub(self) -> Optional[pulumi.Input['LoggerEventhubArgs']]:
        """
        An `eventhub` block as documented below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "eventhub")

    @eventhub.setter
    def eventhub(self, value: Optional[pulumi.Input['LoggerEventhubArgs']]):
        pulumi.set(self, "eventhub", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of this Logger, which must be unique within the API Management Service. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The target resource id which will be linked in the API-Management portal page. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_id", value)


@pulumi.input_type
class _LoggerState:
    def __init__(__self__, *,
                 api_management_name: Optional[pulumi.Input[_builtins.str]] = None,
                 application_insights: Optional[pulumi.Input['LoggerApplicationInsightsArgs']] = None,
                 buffered: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 eventhub: Optional[pulumi.Input['LoggerEventhubArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Logger resources.
        :param pulumi.Input[_builtins.str] api_management_name: The name of the API Management Service. Changing this forces a new resource to be created.
        :param pulumi.Input['LoggerApplicationInsightsArgs'] application_insights: An `application_insights` block as documented below. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] buffered: Specifies whether records should be buffered in the Logger prior to publishing. Defaults to `true`.
        :param pulumi.Input[_builtins.str] description: A description of this Logger.
        :param pulumi.Input['LoggerEventhubArgs'] eventhub: An `eventhub` block as documented below. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name of this Logger, which must be unique within the API Management Service. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group in which the API Management Service exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_id: The target resource id which will be linked in the API-Management portal page. Changing this forces a new resource to be created.
        """
        if api_management_name is not None:
            pulumi.set(__self__, "api_management_name", api_management_name)
        if application_insights is not None:
            pulumi.set(__self__, "application_insights", application_insights)
        if buffered is not None:
            pulumi.set(__self__, "buffered", buffered)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if eventhub is not None:
            pulumi.set(__self__, "eventhub", eventhub)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)

    @_builtins.property
    @pulumi.getter(name="apiManagementName")
    def api_management_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the API Management Service. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "api_management_name")

    @api_management_name.setter
    def api_management_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "api_management_name", value)

    @_builtins.property
    @pulumi.getter(name="applicationInsights")
    def application_insights(self) -> Optional[pulumi.Input['LoggerApplicationInsightsArgs']]:
        """
        An `application_insights` block as documented below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "application_insights")

    @application_insights.setter
    def application_insights(self, value: Optional[pulumi.Input['LoggerApplicationInsightsArgs']]):
        pulumi.set(self, "application_insights", value)

    @_builtins.property
    @pulumi.getter
    def buffered(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether records should be buffered in the Logger prior to publishing. Defaults to `true`.
        """
        return pulumi.get(self, "buffered")

    @buffered.setter
    def buffered(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "buffered", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A description of this Logger.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def eventhub(self) -> Optional[pulumi.Input['LoggerEventhubArgs']]:
        """
        An `eventhub` block as documented below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "eventhub")

    @eventhub.setter
    def eventhub(self, value: Optional[pulumi.Input['LoggerEventhubArgs']]):
        pulumi.set(self, "eventhub", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of this Logger, which must be unique within the API Management Service. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Resource Group in which the API Management Service exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The target resource id which will be linked in the API-Management portal page. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_id", value)


@pulumi.type_token("azure:apimanagement/logger:Logger")
class Logger(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_management_name: Optional[pulumi.Input[_builtins.str]] = None,
                 application_insights: Optional[pulumi.Input[Union['LoggerApplicationInsightsArgs', 'LoggerApplicationInsightsArgsDict']]] = None,
                 buffered: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 eventhub: Optional[pulumi.Input[Union['LoggerEventhubArgs', 'LoggerEventhubArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a Logger within an API Management Service.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_insights = azure.appinsights.Insights("example",
            name="example-appinsights",
            location=example.location,
            resource_group_name=example.name,
            application_type="other")
        example_service = azure.apimanagement.Service("example",
            name="example-apim",
            location=example.location,
            resource_group_name=example.name,
            publisher_name="My Company",
            publisher_email="company@exmaple.com",
            sku_name="Developer_1")
        example_logger = azure.apimanagement.Logger("example",
            name="example-logger",
            api_management_name=example_service.name,
            resource_group_name=example.name,
            resource_id=example_insights.id,
            application_insights={
                "instrumentation_key": example_insights.instrumentation_key,
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.ApiManagement` - 2022-08-01

        ## Import

        API Management Loggers can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:apimanagement/logger:Logger example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/example-rg/providers/Microsoft.ApiManagement/service/example-apim/loggers/example-logger
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] api_management_name: The name of the API Management Service. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['LoggerApplicationInsightsArgs', 'LoggerApplicationInsightsArgsDict']] application_insights: An `application_insights` block as documented below. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] buffered: Specifies whether records should be buffered in the Logger prior to publishing. Defaults to `true`.
        :param pulumi.Input[_builtins.str] description: A description of this Logger.
        :param pulumi.Input[Union['LoggerEventhubArgs', 'LoggerEventhubArgsDict']] eventhub: An `eventhub` block as documented below. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name of this Logger, which must be unique within the API Management Service. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group in which the API Management Service exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_id: The target resource id which will be linked in the API-Management portal page. Changing this forces a new resource to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LoggerArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Logger within an API Management Service.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_insights = azure.appinsights.Insights("example",
            name="example-appinsights",
            location=example.location,
            resource_group_name=example.name,
            application_type="other")
        example_service = azure.apimanagement.Service("example",
            name="example-apim",
            location=example.location,
            resource_group_name=example.name,
            publisher_name="My Company",
            publisher_email="company@exmaple.com",
            sku_name="Developer_1")
        example_logger = azure.apimanagement.Logger("example",
            name="example-logger",
            api_management_name=example_service.name,
            resource_group_name=example.name,
            resource_id=example_insights.id,
            application_insights={
                "instrumentation_key": example_insights.instrumentation_key,
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.ApiManagement` - 2022-08-01

        ## Import

        API Management Loggers can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:apimanagement/logger:Logger example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/example-rg/providers/Microsoft.ApiManagement/service/example-apim/loggers/example-logger
        ```

        :param str resource_name: The name of the resource.
        :param LoggerArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LoggerArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_management_name: Optional[pulumi.Input[_builtins.str]] = None,
                 application_insights: Optional[pulumi.Input[Union['LoggerApplicationInsightsArgs', 'LoggerApplicationInsightsArgsDict']]] = None,
                 buffered: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 eventhub: Optional[pulumi.Input[Union['LoggerEventhubArgs', 'LoggerEventhubArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LoggerArgs.__new__(LoggerArgs)

            if api_management_name is None and not opts.urn:
                raise TypeError("Missing required property 'api_management_name'")
            __props__.__dict__["api_management_name"] = api_management_name
            __props__.__dict__["application_insights"] = application_insights
            __props__.__dict__["buffered"] = buffered
            __props__.__dict__["description"] = description
            __props__.__dict__["eventhub"] = eventhub
            __props__.__dict__["name"] = name
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["resource_id"] = resource_id
        super(Logger, __self__).__init__(
            'azure:apimanagement/logger:Logger',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            api_management_name: Optional[pulumi.Input[_builtins.str]] = None,
            application_insights: Optional[pulumi.Input[Union['LoggerApplicationInsightsArgs', 'LoggerApplicationInsightsArgsDict']]] = None,
            buffered: Optional[pulumi.Input[_builtins.bool]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            eventhub: Optional[pulumi.Input[Union['LoggerEventhubArgs', 'LoggerEventhubArgsDict']]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            resource_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'Logger':
        """
        Get an existing Logger resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] api_management_name: The name of the API Management Service. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['LoggerApplicationInsightsArgs', 'LoggerApplicationInsightsArgsDict']] application_insights: An `application_insights` block as documented below. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] buffered: Specifies whether records should be buffered in the Logger prior to publishing. Defaults to `true`.
        :param pulumi.Input[_builtins.str] description: A description of this Logger.
        :param pulumi.Input[Union['LoggerEventhubArgs', 'LoggerEventhubArgsDict']] eventhub: An `eventhub` block as documented below. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name of this Logger, which must be unique within the API Management Service. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group in which the API Management Service exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_id: The target resource id which will be linked in the API-Management portal page. Changing this forces a new resource to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LoggerState.__new__(_LoggerState)

        __props__.__dict__["api_management_name"] = api_management_name
        __props__.__dict__["application_insights"] = application_insights
        __props__.__dict__["buffered"] = buffered
        __props__.__dict__["description"] = description
        __props__.__dict__["eventhub"] = eventhub
        __props__.__dict__["name"] = name
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["resource_id"] = resource_id
        return Logger(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="apiManagementName")
    def api_management_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the API Management Service. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "api_management_name")

    @_builtins.property
    @pulumi.getter(name="applicationInsights")
    def application_insights(self) -> pulumi.Output[Optional['outputs.LoggerApplicationInsights']]:
        """
        An `application_insights` block as documented below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "application_insights")

    @_builtins.property
    @pulumi.getter
    def buffered(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether records should be buffered in the Logger prior to publishing. Defaults to `true`.
        """
        return pulumi.get(self, "buffered")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        A description of this Logger.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def eventhub(self) -> pulumi.Output[Optional['outputs.LoggerEventhub']]:
        """
        An `eventhub` block as documented below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "eventhub")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of this Logger, which must be unique within the API Management Service. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Resource Group in which the API Management Service exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The target resource id which will be linked in the API-Management portal page. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_id")

