# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['LicationLoadBalancerSecurityPolicyArgs', 'LicationLoadBalancerSecurityPolicy']

@pulumi.input_type
class LicationLoadBalancerSecurityPolicyArgs:
    def __init__(__self__, *,
                 application_load_balancer_id: pulumi.Input[_builtins.str],
                 web_application_firewall_policy_id: pulumi.Input[_builtins.str],
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a LicationLoadBalancerSecurityPolicy resource.
        :param pulumi.Input[_builtins.str] application_load_balancer_id: The ID of the Application Load Balancer. Changing this forces a new Application Gateway for Containers Security Policy to be created.
        :param pulumi.Input[_builtins.str] web_application_firewall_policy_id: The ID of the Web Application Firewall Policy. Changing this forces a new Application Load Balancer Security Policy to be created.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Application Load Balancer Security Policy should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Application Load Balancer Security Policy. Changing this forces a new Application Load Balancer Security Policy to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Application Load Balancer Security Policy.
        """
        pulumi.set(__self__, "application_load_balancer_id", application_load_balancer_id)
        pulumi.set(__self__, "web_application_firewall_policy_id", web_application_firewall_policy_id)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="applicationLoadBalancerId")
    def application_load_balancer_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Application Load Balancer. Changing this forces a new Application Gateway for Containers Security Policy to be created.
        """
        return pulumi.get(self, "application_load_balancer_id")

    @application_load_balancer_id.setter
    def application_load_balancer_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "application_load_balancer_id", value)

    @_builtins.property
    @pulumi.getter(name="webApplicationFirewallPolicyId")
    def web_application_firewall_policy_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Web Application Firewall Policy. Changing this forces a new Application Load Balancer Security Policy to be created.
        """
        return pulumi.get(self, "web_application_firewall_policy_id")

    @web_application_firewall_policy_id.setter
    def web_application_firewall_policy_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "web_application_firewall_policy_id", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Azure Region where the Application Load Balancer Security Policy should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Application Load Balancer Security Policy. Changing this forces a new Application Load Balancer Security Policy to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the Application Load Balancer Security Policy.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _LicationLoadBalancerSecurityPolicyState:
    def __init__(__self__, *,
                 application_load_balancer_id: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 web_application_firewall_policy_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering LicationLoadBalancerSecurityPolicy resources.
        :param pulumi.Input[_builtins.str] application_load_balancer_id: The ID of the Application Load Balancer. Changing this forces a new Application Gateway for Containers Security Policy to be created.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Application Load Balancer Security Policy should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Application Load Balancer Security Policy. Changing this forces a new Application Load Balancer Security Policy to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Application Load Balancer Security Policy.
        :param pulumi.Input[_builtins.str] web_application_firewall_policy_id: The ID of the Web Application Firewall Policy. Changing this forces a new Application Load Balancer Security Policy to be created.
        """
        if application_load_balancer_id is not None:
            pulumi.set(__self__, "application_load_balancer_id", application_load_balancer_id)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if web_application_firewall_policy_id is not None:
            pulumi.set(__self__, "web_application_firewall_policy_id", web_application_firewall_policy_id)

    @_builtins.property
    @pulumi.getter(name="applicationLoadBalancerId")
    def application_load_balancer_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Application Load Balancer. Changing this forces a new Application Gateway for Containers Security Policy to be created.
        """
        return pulumi.get(self, "application_load_balancer_id")

    @application_load_balancer_id.setter
    def application_load_balancer_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "application_load_balancer_id", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Azure Region where the Application Load Balancer Security Policy should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Application Load Balancer Security Policy. Changing this forces a new Application Load Balancer Security Policy to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the Application Load Balancer Security Policy.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="webApplicationFirewallPolicyId")
    def web_application_firewall_policy_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Web Application Firewall Policy. Changing this forces a new Application Load Balancer Security Policy to be created.
        """
        return pulumi.get(self, "web_application_firewall_policy_id")

    @web_application_firewall_policy_id.setter
    def web_application_firewall_policy_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "web_application_firewall_policy_id", value)


@pulumi.type_token("azure:appconfiguration/licationLoadBalancerSecurityPolicy:LicationLoadBalancerSecurityPolicy")
class LicationLoadBalancerSecurityPolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_load_balancer_id: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 web_application_firewall_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages an Application Load Balancer Security Policy.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-rg",
            location="West Europe")
        example_lication_load_balancer = azure.appconfiguration.LicationLoadBalancer("example",
            name="example-alb",
            location=example.location,
            resource_group_name=example.name)
        example_policy = azure.waf.Policy("example",
            name="example-wafpolicy",
            resource_group_name=example.name,
            location=example.location,
            managed_rules={
                "managed_rule_sets": [{
                    "type": "Microsoft_DefaultRuleSet",
                    "version": "2.1",
                }],
            },
            policy_settings={
                "enabled": True,
                "mode": "Detection",
            })
        example_lication_load_balancer_security_policy = azure.appconfiguration.LicationLoadBalancerSecurityPolicy("example",
            name="example-albsp",
            application_load_balancer_id=example_lication_load_balancer.id,
            location=example.location,
            web_application_firewall_policy_id=example_policy.id)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.ServiceNetworking` - 2025-01-01

        ## Import

        Application Load Balancer Security Policy can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:appconfiguration/licationLoadBalancerSecurityPolicy:LicationLoadBalancerSecurityPolicy example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.ServiceNetworking/trafficControllers/alb/securityPolicies/sp1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] application_load_balancer_id: The ID of the Application Load Balancer. Changing this forces a new Application Gateway for Containers Security Policy to be created.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Application Load Balancer Security Policy should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Application Load Balancer Security Policy. Changing this forces a new Application Load Balancer Security Policy to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Application Load Balancer Security Policy.
        :param pulumi.Input[_builtins.str] web_application_firewall_policy_id: The ID of the Web Application Firewall Policy. Changing this forces a new Application Load Balancer Security Policy to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LicationLoadBalancerSecurityPolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an Application Load Balancer Security Policy.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-rg",
            location="West Europe")
        example_lication_load_balancer = azure.appconfiguration.LicationLoadBalancer("example",
            name="example-alb",
            location=example.location,
            resource_group_name=example.name)
        example_policy = azure.waf.Policy("example",
            name="example-wafpolicy",
            resource_group_name=example.name,
            location=example.location,
            managed_rules={
                "managed_rule_sets": [{
                    "type": "Microsoft_DefaultRuleSet",
                    "version": "2.1",
                }],
            },
            policy_settings={
                "enabled": True,
                "mode": "Detection",
            })
        example_lication_load_balancer_security_policy = azure.appconfiguration.LicationLoadBalancerSecurityPolicy("example",
            name="example-albsp",
            application_load_balancer_id=example_lication_load_balancer.id,
            location=example.location,
            web_application_firewall_policy_id=example_policy.id)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.ServiceNetworking` - 2025-01-01

        ## Import

        Application Load Balancer Security Policy can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:appconfiguration/licationLoadBalancerSecurityPolicy:LicationLoadBalancerSecurityPolicy example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.ServiceNetworking/trafficControllers/alb/securityPolicies/sp1
        ```

        :param str resource_name: The name of the resource.
        :param LicationLoadBalancerSecurityPolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LicationLoadBalancerSecurityPolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_load_balancer_id: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 web_application_firewall_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LicationLoadBalancerSecurityPolicyArgs.__new__(LicationLoadBalancerSecurityPolicyArgs)

            if application_load_balancer_id is None and not opts.urn:
                raise TypeError("Missing required property 'application_load_balancer_id'")
            __props__.__dict__["application_load_balancer_id"] = application_load_balancer_id
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            __props__.__dict__["tags"] = tags
            if web_application_firewall_policy_id is None and not opts.urn:
                raise TypeError("Missing required property 'web_application_firewall_policy_id'")
            __props__.__dict__["web_application_firewall_policy_id"] = web_application_firewall_policy_id
        super(LicationLoadBalancerSecurityPolicy, __self__).__init__(
            'azure:appconfiguration/licationLoadBalancerSecurityPolicy:LicationLoadBalancerSecurityPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            application_load_balancer_id: Optional[pulumi.Input[_builtins.str]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            web_application_firewall_policy_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'LicationLoadBalancerSecurityPolicy':
        """
        Get an existing LicationLoadBalancerSecurityPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] application_load_balancer_id: The ID of the Application Load Balancer. Changing this forces a new Application Gateway for Containers Security Policy to be created.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Application Load Balancer Security Policy should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Application Load Balancer Security Policy. Changing this forces a new Application Load Balancer Security Policy to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Application Load Balancer Security Policy.
        :param pulumi.Input[_builtins.str] web_application_firewall_policy_id: The ID of the Web Application Firewall Policy. Changing this forces a new Application Load Balancer Security Policy to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LicationLoadBalancerSecurityPolicyState.__new__(_LicationLoadBalancerSecurityPolicyState)

        __props__.__dict__["application_load_balancer_id"] = application_load_balancer_id
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["tags"] = tags
        __props__.__dict__["web_application_firewall_policy_id"] = web_application_firewall_policy_id
        return LicationLoadBalancerSecurityPolicy(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="applicationLoadBalancerId")
    def application_load_balancer_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Application Load Balancer. Changing this forces a new Application Gateway for Containers Security Policy to be created.
        """
        return pulumi.get(self, "application_load_balancer_id")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        The Azure Region where the Application Load Balancer Security Policy should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name which should be used for this Application Load Balancer Security Policy. Changing this forces a new Application Load Balancer Security Policy to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags which should be assigned to the Application Load Balancer Security Policy.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="webApplicationFirewallPolicyId")
    def web_application_firewall_policy_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Web Application Firewall Policy. Changing this forces a new Application Load Balancer Security Policy to be created.
        """
        return pulumi.get(self, "web_application_firewall_policy_id")

