# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['StaticWebAppCustomDomainArgs', 'StaticWebAppCustomDomain']

@pulumi.input_type
class StaticWebAppCustomDomainArgs:
    def __init__(__self__, *,
                 domain_name: pulumi.Input[_builtins.str],
                 static_web_app_id: pulumi.Input[_builtins.str],
                 validation_type: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a StaticWebAppCustomDomain resource.
        :param pulumi.Input[_builtins.str] domain_name: The Domain Name which should be associated with this Static Site. Changing this forces a new Static Site Custom Domain to be created.
        :param pulumi.Input[_builtins.str] static_web_app_id: The ID of the Static Site. Changing this forces a new Static Site Custom Domain to be created.
        """
        pulumi.set(__self__, "domain_name", domain_name)
        pulumi.set(__self__, "static_web_app_id", static_web_app_id)
        pulumi.set(__self__, "validation_type", validation_type)

    @_builtins.property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> pulumi.Input[_builtins.str]:
        """
        The Domain Name which should be associated with this Static Site. Changing this forces a new Static Site Custom Domain to be created.
        """
        return pulumi.get(self, "domain_name")

    @domain_name.setter
    def domain_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "domain_name", value)

    @_builtins.property
    @pulumi.getter(name="staticWebAppId")
    def static_web_app_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Static Site. Changing this forces a new Static Site Custom Domain to be created.
        """
        return pulumi.get(self, "static_web_app_id")

    @static_web_app_id.setter
    def static_web_app_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "static_web_app_id", value)

    @_builtins.property
    @pulumi.getter(name="validationType")
    def validation_type(self) -> pulumi.Input[_builtins.str]:
        return pulumi.get(self, "validation_type")

    @validation_type.setter
    def validation_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "validation_type", value)


@pulumi.input_type
class _StaticWebAppCustomDomainState:
    def __init__(__self__, *,
                 domain_name: Optional[pulumi.Input[_builtins.str]] = None,
                 static_web_app_id: Optional[pulumi.Input[_builtins.str]] = None,
                 validation_token: Optional[pulumi.Input[_builtins.str]] = None,
                 validation_type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering StaticWebAppCustomDomain resources.
        :param pulumi.Input[_builtins.str] domain_name: The Domain Name which should be associated with this Static Site. Changing this forces a new Static Site Custom Domain to be created.
        :param pulumi.Input[_builtins.str] static_web_app_id: The ID of the Static Site. Changing this forces a new Static Site Custom Domain to be created.
        :param pulumi.Input[_builtins.str] validation_token: Token to be used with `dns-txt-token` validation.
        """
        if domain_name is not None:
            pulumi.set(__self__, "domain_name", domain_name)
        if static_web_app_id is not None:
            pulumi.set(__self__, "static_web_app_id", static_web_app_id)
        if validation_token is not None:
            pulumi.set(__self__, "validation_token", validation_token)
        if validation_type is not None:
            pulumi.set(__self__, "validation_type", validation_type)

    @_builtins.property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Domain Name which should be associated with this Static Site. Changing this forces a new Static Site Custom Domain to be created.
        """
        return pulumi.get(self, "domain_name")

    @domain_name.setter
    def domain_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "domain_name", value)

    @_builtins.property
    @pulumi.getter(name="staticWebAppId")
    def static_web_app_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Static Site. Changing this forces a new Static Site Custom Domain to be created.
        """
        return pulumi.get(self, "static_web_app_id")

    @static_web_app_id.setter
    def static_web_app_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "static_web_app_id", value)

    @_builtins.property
    @pulumi.getter(name="validationToken")
    def validation_token(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Token to be used with `dns-txt-token` validation.
        """
        return pulumi.get(self, "validation_token")

    @validation_token.setter
    def validation_token(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "validation_token", value)

    @_builtins.property
    @pulumi.getter(name="validationType")
    def validation_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "validation_type")

    @validation_type.setter
    def validation_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "validation_type", value)


@pulumi.type_token("azure:appservice/staticWebAppCustomDomain:StaticWebAppCustomDomain")
class StaticWebAppCustomDomain(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 domain_name: Optional[pulumi.Input[_builtins.str]] = None,
                 static_web_app_id: Optional[pulumi.Input[_builtins.str]] = None,
                 validation_type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ### CNAME validation

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_static_web_app = azure.appservice.StaticWebApp("example",
            name="example",
            resource_group_name=example.name,
            location=example.location)
        example_c_name_record = azure.dns.CNameRecord("example",
            name="my-domain",
            zone_name="contoso.com",
            resource_group_name=example.name,
            ttl=300,
            record=example_static_web_app.default_host_name)
        example_static_web_app_custom_domain = azure.appservice.StaticWebAppCustomDomain("example",
            static_web_app_id=example_static_web_app.id,
            domain_name=pulumi.Output.all(
                name=example_c_name_record.name,
                zone_name=example_c_name_record.zone_name
        ).apply(lambda resolved_outputs: f"{resolved_outputs['name']}.{resolved_outputs['zone_name']}")
        ,
            validation_type="cname-delegation")
        ```

        ### TXT validation

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_static_web_app = azure.appservice.StaticWebApp("example",
            name="example",
            resource_group_name=example.name,
            location=example.location)
        example_static_web_app_custom_domain = azure.appservice.StaticWebAppCustomDomain("example",
            static_web_app_id=example_static_web_app.id,
            domain_name="my-domain.contoso.com",
            validation_type="dns-txt-token")
        example_txt_record = azure.dns.TxtRecord("example",
            name="_dnsauth.my-domain",
            zone_name="contoso.com",
            resource_group_name=example.name,
            ttl=300,
            records=[{
                "value": example_static_web_app_custom_domain.validation_token,
            }])
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Web` - 2023-01-01

        ## Import

        Static Site Custom Domains can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:appservice/staticWebAppCustomDomain:StaticWebAppCustomDomain example /subscriptions/12345678-1234-9876-4563-123456789012/resourceGroups/group1/providers/Microsoft.Web/staticSites/my-static-site1/customDomains/name.contoso.com
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] domain_name: The Domain Name which should be associated with this Static Site. Changing this forces a new Static Site Custom Domain to be created.
        :param pulumi.Input[_builtins.str] static_web_app_id: The ID of the Static Site. Changing this forces a new Static Site Custom Domain to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: StaticWebAppCustomDomainArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ### CNAME validation

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_static_web_app = azure.appservice.StaticWebApp("example",
            name="example",
            resource_group_name=example.name,
            location=example.location)
        example_c_name_record = azure.dns.CNameRecord("example",
            name="my-domain",
            zone_name="contoso.com",
            resource_group_name=example.name,
            ttl=300,
            record=example_static_web_app.default_host_name)
        example_static_web_app_custom_domain = azure.appservice.StaticWebAppCustomDomain("example",
            static_web_app_id=example_static_web_app.id,
            domain_name=pulumi.Output.all(
                name=example_c_name_record.name,
                zone_name=example_c_name_record.zone_name
        ).apply(lambda resolved_outputs: f"{resolved_outputs['name']}.{resolved_outputs['zone_name']}")
        ,
            validation_type="cname-delegation")
        ```

        ### TXT validation

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_static_web_app = azure.appservice.StaticWebApp("example",
            name="example",
            resource_group_name=example.name,
            location=example.location)
        example_static_web_app_custom_domain = azure.appservice.StaticWebAppCustomDomain("example",
            static_web_app_id=example_static_web_app.id,
            domain_name="my-domain.contoso.com",
            validation_type="dns-txt-token")
        example_txt_record = azure.dns.TxtRecord("example",
            name="_dnsauth.my-domain",
            zone_name="contoso.com",
            resource_group_name=example.name,
            ttl=300,
            records=[{
                "value": example_static_web_app_custom_domain.validation_token,
            }])
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Web` - 2023-01-01

        ## Import

        Static Site Custom Domains can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:appservice/staticWebAppCustomDomain:StaticWebAppCustomDomain example /subscriptions/12345678-1234-9876-4563-123456789012/resourceGroups/group1/providers/Microsoft.Web/staticSites/my-static-site1/customDomains/name.contoso.com
        ```

        :param str resource_name: The name of the resource.
        :param StaticWebAppCustomDomainArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(StaticWebAppCustomDomainArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 domain_name: Optional[pulumi.Input[_builtins.str]] = None,
                 static_web_app_id: Optional[pulumi.Input[_builtins.str]] = None,
                 validation_type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = StaticWebAppCustomDomainArgs.__new__(StaticWebAppCustomDomainArgs)

            if domain_name is None and not opts.urn:
                raise TypeError("Missing required property 'domain_name'")
            __props__.__dict__["domain_name"] = domain_name
            if static_web_app_id is None and not opts.urn:
                raise TypeError("Missing required property 'static_web_app_id'")
            __props__.__dict__["static_web_app_id"] = static_web_app_id
            if validation_type is None and not opts.urn:
                raise TypeError("Missing required property 'validation_type'")
            __props__.__dict__["validation_type"] = validation_type
            __props__.__dict__["validation_token"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["validationToken"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(StaticWebAppCustomDomain, __self__).__init__(
            'azure:appservice/staticWebAppCustomDomain:StaticWebAppCustomDomain',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            domain_name: Optional[pulumi.Input[_builtins.str]] = None,
            static_web_app_id: Optional[pulumi.Input[_builtins.str]] = None,
            validation_token: Optional[pulumi.Input[_builtins.str]] = None,
            validation_type: Optional[pulumi.Input[_builtins.str]] = None) -> 'StaticWebAppCustomDomain':
        """
        Get an existing StaticWebAppCustomDomain resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] domain_name: The Domain Name which should be associated with this Static Site. Changing this forces a new Static Site Custom Domain to be created.
        :param pulumi.Input[_builtins.str] static_web_app_id: The ID of the Static Site. Changing this forces a new Static Site Custom Domain to be created.
        :param pulumi.Input[_builtins.str] validation_token: Token to be used with `dns-txt-token` validation.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _StaticWebAppCustomDomainState.__new__(_StaticWebAppCustomDomainState)

        __props__.__dict__["domain_name"] = domain_name
        __props__.__dict__["static_web_app_id"] = static_web_app_id
        __props__.__dict__["validation_token"] = validation_token
        __props__.__dict__["validation_type"] = validation_type
        return StaticWebAppCustomDomain(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> pulumi.Output[_builtins.str]:
        """
        The Domain Name which should be associated with this Static Site. Changing this forces a new Static Site Custom Domain to be created.
        """
        return pulumi.get(self, "domain_name")

    @_builtins.property
    @pulumi.getter(name="staticWebAppId")
    def static_web_app_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Static Site. Changing this forces a new Static Site Custom Domain to be created.
        """
        return pulumi.get(self, "static_web_app_id")

    @_builtins.property
    @pulumi.getter(name="validationToken")
    def validation_token(self) -> pulumi.Output[_builtins.str]:
        """
        Token to be used with `dns-txt-token` validation.
        """
        return pulumi.get(self, "validation_token")

    @_builtins.property
    @pulumi.getter(name="validationType")
    def validation_type(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "validation_type")

