# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'AccountEncryptionArgs',
    'AccountEncryptionArgsDict',
    'AccountIdentityArgs',
    'AccountIdentityArgsDict',
    'AccountPrivateEndpointConnectionArgs',
    'AccountPrivateEndpointConnectionArgsDict',
    'ConnectionTypeFieldArgs',
    'ConnectionTypeFieldArgsDict',
    'ModuleModuleLinkArgs',
    'ModuleModuleLinkArgsDict',
    'ModuleModuleLinkHashArgs',
    'ModuleModuleLinkHashArgsDict',
    'Powershell72ModuleModuleLinkArgs',
    'Powershell72ModuleModuleLinkArgsDict',
    'Powershell72ModuleModuleLinkHashArgs',
    'Powershell72ModuleModuleLinkHashArgsDict',
    'RunBookDraftArgs',
    'RunBookDraftArgsDict',
    'RunBookDraftContentLinkArgs',
    'RunBookDraftContentLinkArgsDict',
    'RunBookDraftContentLinkHashArgs',
    'RunBookDraftContentLinkHashArgsDict',
    'RunBookDraftParameterArgs',
    'RunBookDraftParameterArgsDict',
    'RunBookJobScheduleArgs',
    'RunBookJobScheduleArgsDict',
    'RunBookPublishContentLinkArgs',
    'RunBookPublishContentLinkArgsDict',
    'RunBookPublishContentLinkHashArgs',
    'RunBookPublishContentLinkHashArgsDict',
    'ScheduleMonthlyOccurrenceArgs',
    'ScheduleMonthlyOccurrenceArgsDict',
    'SoftwareUpdateConfigurationLinuxArgs',
    'SoftwareUpdateConfigurationLinuxArgsDict',
    'SoftwareUpdateConfigurationPostTaskArgs',
    'SoftwareUpdateConfigurationPostTaskArgsDict',
    'SoftwareUpdateConfigurationPreTaskArgs',
    'SoftwareUpdateConfigurationPreTaskArgsDict',
    'SoftwareUpdateConfigurationScheduleArgs',
    'SoftwareUpdateConfigurationScheduleArgsDict',
    'SoftwareUpdateConfigurationScheduleMonthlyOccurrenceArgs',
    'SoftwareUpdateConfigurationScheduleMonthlyOccurrenceArgsDict',
    'SoftwareUpdateConfigurationTargetArgs',
    'SoftwareUpdateConfigurationTargetArgsDict',
    'SoftwareUpdateConfigurationTargetAzureQueryArgs',
    'SoftwareUpdateConfigurationTargetAzureQueryArgsDict',
    'SoftwareUpdateConfigurationTargetAzureQueryTagArgs',
    'SoftwareUpdateConfigurationTargetAzureQueryTagArgsDict',
    'SoftwareUpdateConfigurationTargetNonAzureQueryArgs',
    'SoftwareUpdateConfigurationTargetNonAzureQueryArgsDict',
    'SoftwareUpdateConfigurationWindowsArgs',
    'SoftwareUpdateConfigurationWindowsArgsDict',
    'SourceControlSecurityArgs',
    'SourceControlSecurityArgsDict',
]

MYPY = False

if not MYPY:
    class AccountEncryptionArgsDict(TypedDict):
        key_vault_key_id: pulumi.Input[_builtins.str]
        """
        The ID of the Key Vault Key which should be used to Encrypt the data in this Automation Account.
        """
        key_source: NotRequired[pulumi.Input[_builtins.str]]
        user_assigned_identity_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The User Assigned Managed Identity ID to be used for accessing the Customer Managed Key for encryption.
        """
elif False:
    AccountEncryptionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AccountEncryptionArgs:
    def __init__(__self__, *,
                 key_vault_key_id: pulumi.Input[_builtins.str],
                 key_source: Optional[pulumi.Input[_builtins.str]] = None,
                 user_assigned_identity_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] key_vault_key_id: The ID of the Key Vault Key which should be used to Encrypt the data in this Automation Account.
        :param pulumi.Input[_builtins.str] user_assigned_identity_id: The User Assigned Managed Identity ID to be used for accessing the Customer Managed Key for encryption.
        """
        pulumi.set(__self__, "key_vault_key_id", key_vault_key_id)
        if key_source is not None:
            warnings.warn("""`encryption.key_source` has been deprecated and will be removed in v5.0 of the AzureRM Provider. To disable encryption, omit the `encryption` block""", DeprecationWarning)
            pulumi.log.warn("""key_source is deprecated: `encryption.key_source` has been deprecated and will be removed in v5.0 of the AzureRM Provider. To disable encryption, omit the `encryption` block""")
        if key_source is not None:
            pulumi.set(__self__, "key_source", key_source)
        if user_assigned_identity_id is not None:
            pulumi.set(__self__, "user_assigned_identity_id", user_assigned_identity_id)

    @_builtins.property
    @pulumi.getter(name="keyVaultKeyId")
    def key_vault_key_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Key Vault Key which should be used to Encrypt the data in this Automation Account.
        """
        return pulumi.get(self, "key_vault_key_id")

    @key_vault_key_id.setter
    def key_vault_key_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "key_vault_key_id", value)

    @_builtins.property
    @pulumi.getter(name="keySource")
    @_utilities.deprecated("""`encryption.key_source` has been deprecated and will be removed in v5.0 of the AzureRM Provider. To disable encryption, omit the `encryption` block""")
    def key_source(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "key_source")

    @key_source.setter
    def key_source(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_source", value)

    @_builtins.property
    @pulumi.getter(name="userAssignedIdentityId")
    def user_assigned_identity_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The User Assigned Managed Identity ID to be used for accessing the Customer Managed Key for encryption.
        """
        return pulumi.get(self, "user_assigned_identity_id")

    @user_assigned_identity_id.setter
    def user_assigned_identity_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_assigned_identity_id", value)


if not MYPY:
    class AccountIdentityArgsDict(TypedDict):
        type: pulumi.Input[_builtins.str]
        """
        The type of identity used for this Automation Account. Possible values are `SystemAssigned`, `UserAssigned` and `SystemAssigned, UserAssigned`.
        """
        identity_ids: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        The ID of the User Assigned Identity which should be assigned to this Automation Account.

        > **Note:** `identity_ids` is required when `type` is set to `UserAssigned` or `SystemAssigned, UserAssigned`.
        """
        principal_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The Principal ID associated with this Managed Service Identity.
        """
        tenant_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The Tenant ID associated with this Managed Service Identity.
        """
elif False:
    AccountIdentityArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AccountIdentityArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[_builtins.str],
                 identity_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 principal_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] type: The type of identity used for this Automation Account. Possible values are `SystemAssigned`, `UserAssigned` and `SystemAssigned, UserAssigned`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] identity_ids: The ID of the User Assigned Identity which should be assigned to this Automation Account.
               
               > **Note:** `identity_ids` is required when `type` is set to `UserAssigned` or `SystemAssigned, UserAssigned`.
        :param pulumi.Input[_builtins.str] principal_id: The Principal ID associated with this Managed Service Identity.
        :param pulumi.Input[_builtins.str] tenant_id: The Tenant ID associated with this Managed Service Identity.
        """
        pulumi.set(__self__, "type", type)
        if identity_ids is not None:
            pulumi.set(__self__, "identity_ids", identity_ids)
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        The type of identity used for this Automation Account. Possible values are `SystemAssigned`, `UserAssigned` and `SystemAssigned, UserAssigned`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="identityIds")
    def identity_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The ID of the User Assigned Identity which should be assigned to this Automation Account.

        > **Note:** `identity_ids` is required when `type` is set to `UserAssigned` or `SystemAssigned, UserAssigned`.
        """
        return pulumi.get(self, "identity_ids")

    @identity_ids.setter
    def identity_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "identity_ids", value)

    @_builtins.property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Principal ID associated with this Managed Service Identity.
        """
        return pulumi.get(self, "principal_id")

    @principal_id.setter
    def principal_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "principal_id", value)

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Tenant ID associated with this Managed Service Identity.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tenant_id", value)


if not MYPY:
    class AccountPrivateEndpointConnectionArgsDict(TypedDict):
        id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The ID of the Automation Account.
        """
        name: NotRequired[pulumi.Input[_builtins.str]]
        """
        Specifies the name of the Automation Account. Changing this forces a new resource to be created.
        """
elif False:
    AccountPrivateEndpointConnectionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AccountPrivateEndpointConnectionArgs:
    def __init__(__self__, *,
                 id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] id: The ID of the Automation Account.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Automation Account. Changing this forces a new resource to be created.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Automation Account.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the Automation Account. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


if not MYPY:
    class ConnectionTypeFieldArgsDict(TypedDict):
        name: pulumi.Input[_builtins.str]
        """
        The name which should be used for this connection field definition.
        """
        type: pulumi.Input[_builtins.str]
        """
        The type of the connection field definition.
        """
        is_encrypted: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Whether to set the isEncrypted flag of the connection field definition.
        """
        is_optional: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Whether to set the isOptional flag of the connection field definition.
        """
elif False:
    ConnectionTypeFieldArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ConnectionTypeFieldArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[_builtins.str],
                 type: pulumi.Input[_builtins.str],
                 is_encrypted: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_optional: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        :param pulumi.Input[_builtins.str] name: The name which should be used for this connection field definition.
        :param pulumi.Input[_builtins.str] type: The type of the connection field definition.
        :param pulumi.Input[_builtins.bool] is_encrypted: Whether to set the isEncrypted flag of the connection field definition.
        :param pulumi.Input[_builtins.bool] is_optional: Whether to set the isOptional flag of the connection field definition.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)
        if is_encrypted is not None:
            pulumi.set(__self__, "is_encrypted", is_encrypted)
        if is_optional is not None:
            pulumi.set(__self__, "is_optional", is_optional)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        The name which should be used for this connection field definition.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        The type of the connection field definition.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="isEncrypted")
    def is_encrypted(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to set the isEncrypted flag of the connection field definition.
        """
        return pulumi.get(self, "is_encrypted")

    @is_encrypted.setter
    def is_encrypted(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_encrypted", value)

    @_builtins.property
    @pulumi.getter(name="isOptional")
    def is_optional(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to set the isOptional flag of the connection field definition.
        """
        return pulumi.get(self, "is_optional")

    @is_optional.setter
    def is_optional(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_optional", value)


if not MYPY:
    class ModuleModuleLinkArgsDict(TypedDict):
        uri: pulumi.Input[_builtins.str]
        """
        The URI of the module content (zip or nupkg).
        """
        hash: NotRequired[pulumi.Input['ModuleModuleLinkHashArgsDict']]
        """
        A `hash` block as defined below.
        """
elif False:
    ModuleModuleLinkArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ModuleModuleLinkArgs:
    def __init__(__self__, *,
                 uri: pulumi.Input[_builtins.str],
                 hash: Optional[pulumi.Input['ModuleModuleLinkHashArgs']] = None):
        """
        :param pulumi.Input[_builtins.str] uri: The URI of the module content (zip or nupkg).
        :param pulumi.Input['ModuleModuleLinkHashArgs'] hash: A `hash` block as defined below.
        """
        pulumi.set(__self__, "uri", uri)
        if hash is not None:
            pulumi.set(__self__, "hash", hash)

    @_builtins.property
    @pulumi.getter
    def uri(self) -> pulumi.Input[_builtins.str]:
        """
        The URI of the module content (zip or nupkg).
        """
        return pulumi.get(self, "uri")

    @uri.setter
    def uri(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "uri", value)

    @_builtins.property
    @pulumi.getter
    def hash(self) -> Optional[pulumi.Input['ModuleModuleLinkHashArgs']]:
        """
        A `hash` block as defined below.
        """
        return pulumi.get(self, "hash")

    @hash.setter
    def hash(self, value: Optional[pulumi.Input['ModuleModuleLinkHashArgs']]):
        pulumi.set(self, "hash", value)


if not MYPY:
    class ModuleModuleLinkHashArgsDict(TypedDict):
        algorithm: pulumi.Input[_builtins.str]
        """
        Specifies the algorithm used for the hash content.
        """
        value: pulumi.Input[_builtins.str]
        """
        The hash value of the content.
        """
elif False:
    ModuleModuleLinkHashArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ModuleModuleLinkHashArgs:
    def __init__(__self__, *,
                 algorithm: pulumi.Input[_builtins.str],
                 value: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[_builtins.str] algorithm: Specifies the algorithm used for the hash content.
        :param pulumi.Input[_builtins.str] value: The hash value of the content.
        """
        pulumi.set(__self__, "algorithm", algorithm)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def algorithm(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the algorithm used for the hash content.
        """
        return pulumi.get(self, "algorithm")

    @algorithm.setter
    def algorithm(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "algorithm", value)

    @_builtins.property
    @pulumi.getter
    def value(self) -> pulumi.Input[_builtins.str]:
        """
        The hash value of the content.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "value", value)


if not MYPY:
    class Powershell72ModuleModuleLinkArgsDict(TypedDict):
        uri: pulumi.Input[_builtins.str]
        """
        The URI of the module content (zip or nupkg).
        """
        hash: NotRequired[pulumi.Input['Powershell72ModuleModuleLinkHashArgsDict']]
        """
        A `hash` block as defined below.
        """
elif False:
    Powershell72ModuleModuleLinkArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class Powershell72ModuleModuleLinkArgs:
    def __init__(__self__, *,
                 uri: pulumi.Input[_builtins.str],
                 hash: Optional[pulumi.Input['Powershell72ModuleModuleLinkHashArgs']] = None):
        """
        :param pulumi.Input[_builtins.str] uri: The URI of the module content (zip or nupkg).
        :param pulumi.Input['Powershell72ModuleModuleLinkHashArgs'] hash: A `hash` block as defined below.
        """
        pulumi.set(__self__, "uri", uri)
        if hash is not None:
            pulumi.set(__self__, "hash", hash)

    @_builtins.property
    @pulumi.getter
    def uri(self) -> pulumi.Input[_builtins.str]:
        """
        The URI of the module content (zip or nupkg).
        """
        return pulumi.get(self, "uri")

    @uri.setter
    def uri(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "uri", value)

    @_builtins.property
    @pulumi.getter
    def hash(self) -> Optional[pulumi.Input['Powershell72ModuleModuleLinkHashArgs']]:
        """
        A `hash` block as defined below.
        """
        return pulumi.get(self, "hash")

    @hash.setter
    def hash(self, value: Optional[pulumi.Input['Powershell72ModuleModuleLinkHashArgs']]):
        pulumi.set(self, "hash", value)


if not MYPY:
    class Powershell72ModuleModuleLinkHashArgsDict(TypedDict):
        algorithm: pulumi.Input[_builtins.str]
        """
        Specifies the algorithm used for the hash content.
        """
        value: pulumi.Input[_builtins.str]
        """
        The hash value of the content.
        """
elif False:
    Powershell72ModuleModuleLinkHashArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class Powershell72ModuleModuleLinkHashArgs:
    def __init__(__self__, *,
                 algorithm: pulumi.Input[_builtins.str],
                 value: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[_builtins.str] algorithm: Specifies the algorithm used for the hash content.
        :param pulumi.Input[_builtins.str] value: The hash value of the content.
        """
        pulumi.set(__self__, "algorithm", algorithm)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def algorithm(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the algorithm used for the hash content.
        """
        return pulumi.get(self, "algorithm")

    @algorithm.setter
    def algorithm(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "algorithm", value)

    @_builtins.property
    @pulumi.getter
    def value(self) -> pulumi.Input[_builtins.str]:
        """
        The hash value of the content.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "value", value)


if not MYPY:
    class RunBookDraftArgsDict(TypedDict):
        content_link: NotRequired[pulumi.Input['RunBookDraftContentLinkArgsDict']]
        """
        A `publish_content_link` block as defined above.
        """
        creation_time: NotRequired[pulumi.Input[_builtins.str]]
        edit_mode_enabled: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Whether the draft in edit mode.
        """
        last_modified_time: NotRequired[pulumi.Input[_builtins.str]]
        output_types: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        Specifies the output types of the runbook.
        """
        parameters: NotRequired[pulumi.Input[Sequence[pulumi.Input['RunBookDraftParameterArgsDict']]]]
        """
        A list of `parameters` block as defined below.
        """
elif False:
    RunBookDraftArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RunBookDraftArgs:
    def __init__(__self__, *,
                 content_link: Optional[pulumi.Input['RunBookDraftContentLinkArgs']] = None,
                 creation_time: Optional[pulumi.Input[_builtins.str]] = None,
                 edit_mode_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 last_modified_time: Optional[pulumi.Input[_builtins.str]] = None,
                 output_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 parameters: Optional[pulumi.Input[Sequence[pulumi.Input['RunBookDraftParameterArgs']]]] = None):
        """
        :param pulumi.Input['RunBookDraftContentLinkArgs'] content_link: A `publish_content_link` block as defined above.
        :param pulumi.Input[_builtins.bool] edit_mode_enabled: Whether the draft in edit mode.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] output_types: Specifies the output types of the runbook.
        :param pulumi.Input[Sequence[pulumi.Input['RunBookDraftParameterArgs']]] parameters: A list of `parameters` block as defined below.
        """
        if content_link is not None:
            pulumi.set(__self__, "content_link", content_link)
        if creation_time is not None:
            pulumi.set(__self__, "creation_time", creation_time)
        if edit_mode_enabled is not None:
            pulumi.set(__self__, "edit_mode_enabled", edit_mode_enabled)
        if last_modified_time is not None:
            pulumi.set(__self__, "last_modified_time", last_modified_time)
        if output_types is not None:
            pulumi.set(__self__, "output_types", output_types)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)

    @_builtins.property
    @pulumi.getter(name="contentLink")
    def content_link(self) -> Optional[pulumi.Input['RunBookDraftContentLinkArgs']]:
        """
        A `publish_content_link` block as defined above.
        """
        return pulumi.get(self, "content_link")

    @content_link.setter
    def content_link(self, value: Optional[pulumi.Input['RunBookDraftContentLinkArgs']]):
        pulumi.set(self, "content_link", value)

    @_builtins.property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "creation_time")

    @creation_time.setter
    def creation_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "creation_time", value)

    @_builtins.property
    @pulumi.getter(name="editModeEnabled")
    def edit_mode_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the draft in edit mode.
        """
        return pulumi.get(self, "edit_mode_enabled")

    @edit_mode_enabled.setter
    def edit_mode_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "edit_mode_enabled", value)

    @_builtins.property
    @pulumi.getter(name="lastModifiedTime")
    def last_modified_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "last_modified_time")

    @last_modified_time.setter
    def last_modified_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "last_modified_time", value)

    @_builtins.property
    @pulumi.getter(name="outputTypes")
    def output_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies the output types of the runbook.
        """
        return pulumi.get(self, "output_types")

    @output_types.setter
    def output_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "output_types", value)

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RunBookDraftParameterArgs']]]]:
        """
        A list of `parameters` block as defined below.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RunBookDraftParameterArgs']]]]):
        pulumi.set(self, "parameters", value)


if not MYPY:
    class RunBookDraftContentLinkArgsDict(TypedDict):
        uri: pulumi.Input[_builtins.str]
        """
        The URI of the runbook content.
        """
        hash: NotRequired[pulumi.Input['RunBookDraftContentLinkHashArgsDict']]
        """
        A `hash` block as defined below.
        """
        version: NotRequired[pulumi.Input[_builtins.str]]
        """
        Specifies the version of the content
        """
elif False:
    RunBookDraftContentLinkArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RunBookDraftContentLinkArgs:
    def __init__(__self__, *,
                 uri: pulumi.Input[_builtins.str],
                 hash: Optional[pulumi.Input['RunBookDraftContentLinkHashArgs']] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] uri: The URI of the runbook content.
        :param pulumi.Input['RunBookDraftContentLinkHashArgs'] hash: A `hash` block as defined below.
        :param pulumi.Input[_builtins.str] version: Specifies the version of the content
        """
        pulumi.set(__self__, "uri", uri)
        if hash is not None:
            pulumi.set(__self__, "hash", hash)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter
    def uri(self) -> pulumi.Input[_builtins.str]:
        """
        The URI of the runbook content.
        """
        return pulumi.get(self, "uri")

    @uri.setter
    def uri(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "uri", value)

    @_builtins.property
    @pulumi.getter
    def hash(self) -> Optional[pulumi.Input['RunBookDraftContentLinkHashArgs']]:
        """
        A `hash` block as defined below.
        """
        return pulumi.get(self, "hash")

    @hash.setter
    def hash(self, value: Optional[pulumi.Input['RunBookDraftContentLinkHashArgs']]):
        pulumi.set(self, "hash", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the version of the content
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "version", value)


if not MYPY:
    class RunBookDraftContentLinkHashArgsDict(TypedDict):
        algorithm: pulumi.Input[_builtins.str]
        """
        Specifies the hash algorithm used to hash the content.
        """
        value: pulumi.Input[_builtins.str]
        """
        Specifies the expected hash value of the content.
        """
elif False:
    RunBookDraftContentLinkHashArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RunBookDraftContentLinkHashArgs:
    def __init__(__self__, *,
                 algorithm: pulumi.Input[_builtins.str],
                 value: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[_builtins.str] algorithm: Specifies the hash algorithm used to hash the content.
        :param pulumi.Input[_builtins.str] value: Specifies the expected hash value of the content.
        """
        pulumi.set(__self__, "algorithm", algorithm)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def algorithm(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the hash algorithm used to hash the content.
        """
        return pulumi.get(self, "algorithm")

    @algorithm.setter
    def algorithm(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "algorithm", value)

    @_builtins.property
    @pulumi.getter
    def value(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the expected hash value of the content.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "value", value)


if not MYPY:
    class RunBookDraftParameterArgsDict(TypedDict):
        key: pulumi.Input[_builtins.str]
        """
        The name of the parameter.
        """
        type: pulumi.Input[_builtins.str]
        """
        Specifies the type of this parameter.
        """
        default_value: NotRequired[pulumi.Input[_builtins.str]]
        """
        Specifies the default value of the parameter.
        """
        mandatory: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Whether this parameter is mandatory.
        """
        position: NotRequired[pulumi.Input[_builtins.int]]
        """
        Specifies the position of the parameter.
        """
elif False:
    RunBookDraftParameterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RunBookDraftParameterArgs:
    def __init__(__self__, *,
                 key: pulumi.Input[_builtins.str],
                 type: pulumi.Input[_builtins.str],
                 default_value: Optional[pulumi.Input[_builtins.str]] = None,
                 mandatory: Optional[pulumi.Input[_builtins.bool]] = None,
                 position: Optional[pulumi.Input[_builtins.int]] = None):
        """
        :param pulumi.Input[_builtins.str] key: The name of the parameter.
        :param pulumi.Input[_builtins.str] type: Specifies the type of this parameter.
        :param pulumi.Input[_builtins.str] default_value: Specifies the default value of the parameter.
        :param pulumi.Input[_builtins.bool] mandatory: Whether this parameter is mandatory.
        :param pulumi.Input[_builtins.int] position: Specifies the position of the parameter.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "type", type)
        if default_value is not None:
            pulumi.set(__self__, "default_value", default_value)
        if mandatory is not None:
            pulumi.set(__self__, "mandatory", mandatory)
        if position is not None:
            pulumi.set(__self__, "position", position)

    @_builtins.property
    @pulumi.getter
    def key(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the parameter.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "key", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the type of this parameter.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="defaultValue")
    def default_value(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the default value of the parameter.
        """
        return pulumi.get(self, "default_value")

    @default_value.setter
    def default_value(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_value", value)

    @_builtins.property
    @pulumi.getter
    def mandatory(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether this parameter is mandatory.
        """
        return pulumi.get(self, "mandatory")

    @mandatory.setter
    def mandatory(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "mandatory", value)

    @_builtins.property
    @pulumi.getter
    def position(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the position of the parameter.
        """
        return pulumi.get(self, "position")

    @position.setter
    def position(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "position", value)


if not MYPY:
    class RunBookJobScheduleArgsDict(TypedDict):
        schedule_name: pulumi.Input[_builtins.str]
        """
        The name of the Schedule.
        """
        job_schedule_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The UUID of automation runbook job schedule ID.
        """
        parameters: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]
        """
        A map of key/value pairs corresponding to the arguments that can be passed to the Runbook.

        > **Note:** The parameter keys/names must strictly be in lowercase, even if this is not the case in the runbook. This is due to a limitation in Azure Automation where the parameter names are normalized. The values specified don't have this limitation.
        """
        run_on: NotRequired[pulumi.Input[_builtins.str]]
        """
        Name of a Hybrid Worker Group the Runbook will be executed on.
        """
elif False:
    RunBookJobScheduleArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RunBookJobScheduleArgs:
    def __init__(__self__, *,
                 schedule_name: pulumi.Input[_builtins.str],
                 job_schedule_id: Optional[pulumi.Input[_builtins.str]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 run_on: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] schedule_name: The name of the Schedule.
        :param pulumi.Input[_builtins.str] job_schedule_id: The UUID of automation runbook job schedule ID.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] parameters: A map of key/value pairs corresponding to the arguments that can be passed to the Runbook.
               
               > **Note:** The parameter keys/names must strictly be in lowercase, even if this is not the case in the runbook. This is due to a limitation in Azure Automation where the parameter names are normalized. The values specified don't have this limitation.
        :param pulumi.Input[_builtins.str] run_on: Name of a Hybrid Worker Group the Runbook will be executed on.
        """
        pulumi.set(__self__, "schedule_name", schedule_name)
        if job_schedule_id is not None:
            pulumi.set(__self__, "job_schedule_id", job_schedule_id)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if run_on is not None:
            pulumi.set(__self__, "run_on", run_on)

    @_builtins.property
    @pulumi.getter(name="scheduleName")
    def schedule_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the Schedule.
        """
        return pulumi.get(self, "schedule_name")

    @schedule_name.setter
    def schedule_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "schedule_name", value)

    @_builtins.property
    @pulumi.getter(name="jobScheduleId")
    def job_schedule_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The UUID of automation runbook job schedule ID.
        """
        return pulumi.get(self, "job_schedule_id")

    @job_schedule_id.setter
    def job_schedule_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "job_schedule_id", value)

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of key/value pairs corresponding to the arguments that can be passed to the Runbook.

        > **Note:** The parameter keys/names must strictly be in lowercase, even if this is not the case in the runbook. This is due to a limitation in Azure Automation where the parameter names are normalized. The values specified don't have this limitation.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "parameters", value)

    @_builtins.property
    @pulumi.getter(name="runOn")
    def run_on(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of a Hybrid Worker Group the Runbook will be executed on.
        """
        return pulumi.get(self, "run_on")

    @run_on.setter
    def run_on(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "run_on", value)


if not MYPY:
    class RunBookPublishContentLinkArgsDict(TypedDict):
        uri: pulumi.Input[_builtins.str]
        """
        The URI of the runbook content.
        """
        hash: NotRequired[pulumi.Input['RunBookPublishContentLinkHashArgsDict']]
        """
        A `hash` block as defined below.
        """
        version: NotRequired[pulumi.Input[_builtins.str]]
        """
        Specifies the version of the content
        """
elif False:
    RunBookPublishContentLinkArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RunBookPublishContentLinkArgs:
    def __init__(__self__, *,
                 uri: pulumi.Input[_builtins.str],
                 hash: Optional[pulumi.Input['RunBookPublishContentLinkHashArgs']] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] uri: The URI of the runbook content.
        :param pulumi.Input['RunBookPublishContentLinkHashArgs'] hash: A `hash` block as defined below.
        :param pulumi.Input[_builtins.str] version: Specifies the version of the content
        """
        pulumi.set(__self__, "uri", uri)
        if hash is not None:
            pulumi.set(__self__, "hash", hash)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter
    def uri(self) -> pulumi.Input[_builtins.str]:
        """
        The URI of the runbook content.
        """
        return pulumi.get(self, "uri")

    @uri.setter
    def uri(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "uri", value)

    @_builtins.property
    @pulumi.getter
    def hash(self) -> Optional[pulumi.Input['RunBookPublishContentLinkHashArgs']]:
        """
        A `hash` block as defined below.
        """
        return pulumi.get(self, "hash")

    @hash.setter
    def hash(self, value: Optional[pulumi.Input['RunBookPublishContentLinkHashArgs']]):
        pulumi.set(self, "hash", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the version of the content
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "version", value)


if not MYPY:
    class RunBookPublishContentLinkHashArgsDict(TypedDict):
        algorithm: pulumi.Input[_builtins.str]
        """
        Specifies the hash algorithm used to hash the content.
        """
        value: pulumi.Input[_builtins.str]
        """
        Specifies the expected hash value of the content.
        """
elif False:
    RunBookPublishContentLinkHashArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RunBookPublishContentLinkHashArgs:
    def __init__(__self__, *,
                 algorithm: pulumi.Input[_builtins.str],
                 value: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[_builtins.str] algorithm: Specifies the hash algorithm used to hash the content.
        :param pulumi.Input[_builtins.str] value: Specifies the expected hash value of the content.
        """
        pulumi.set(__self__, "algorithm", algorithm)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def algorithm(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the hash algorithm used to hash the content.
        """
        return pulumi.get(self, "algorithm")

    @algorithm.setter
    def algorithm(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "algorithm", value)

    @_builtins.property
    @pulumi.getter
    def value(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the expected hash value of the content.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "value", value)


if not MYPY:
    class ScheduleMonthlyOccurrenceArgsDict(TypedDict):
        day: pulumi.Input[_builtins.str]
        """
        Day of the occurrence. Must be one of `Monday`, `Tuesday`, `Wednesday`, `Thursday`, `Friday`, `Saturday`, `Sunday`.
        """
        occurrence: pulumi.Input[_builtins.int]
        """
        Occurrence of the week within the month. Must be between `1` and `5`. `-1` for last week within the month.
        """
elif False:
    ScheduleMonthlyOccurrenceArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ScheduleMonthlyOccurrenceArgs:
    def __init__(__self__, *,
                 day: pulumi.Input[_builtins.str],
                 occurrence: pulumi.Input[_builtins.int]):
        """
        :param pulumi.Input[_builtins.str] day: Day of the occurrence. Must be one of `Monday`, `Tuesday`, `Wednesday`, `Thursday`, `Friday`, `Saturday`, `Sunday`.
        :param pulumi.Input[_builtins.int] occurrence: Occurrence of the week within the month. Must be between `1` and `5`. `-1` for last week within the month.
        """
        pulumi.set(__self__, "day", day)
        pulumi.set(__self__, "occurrence", occurrence)

    @_builtins.property
    @pulumi.getter
    def day(self) -> pulumi.Input[_builtins.str]:
        """
        Day of the occurrence. Must be one of `Monday`, `Tuesday`, `Wednesday`, `Thursday`, `Friday`, `Saturday`, `Sunday`.
        """
        return pulumi.get(self, "day")

    @day.setter
    def day(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "day", value)

    @_builtins.property
    @pulumi.getter
    def occurrence(self) -> pulumi.Input[_builtins.int]:
        """
        Occurrence of the week within the month. Must be between `1` and `5`. `-1` for last week within the month.
        """
        return pulumi.get(self, "occurrence")

    @occurrence.setter
    def occurrence(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "occurrence", value)


if not MYPY:
    class SoftwareUpdateConfigurationLinuxArgsDict(TypedDict):
        classifications_includeds: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]
        """
        Specifies the list of update classifications included in the Software Update Configuration. Possible values are `Unclassified`, `Critical`, `Security` and `Other`.
        """
        excluded_packages: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        Specifies a list of packages to excluded from the Software Update Configuration.
        """
        included_packages: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        Specifies a list of packages to included from the Software Update Configuration.
        """
        reboot: NotRequired[pulumi.Input[_builtins.str]]
        """
        Specifies the reboot settings after software update, possible values are `IfRequired`, `Never`, `RebootOnly` and `Always`. Defaults to `IfRequired`.
        """
elif False:
    SoftwareUpdateConfigurationLinuxArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SoftwareUpdateConfigurationLinuxArgs:
    def __init__(__self__, *,
                 classifications_includeds: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 excluded_packages: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 included_packages: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 reboot: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] classifications_includeds: Specifies the list of update classifications included in the Software Update Configuration. Possible values are `Unclassified`, `Critical`, `Security` and `Other`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] excluded_packages: Specifies a list of packages to excluded from the Software Update Configuration.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] included_packages: Specifies a list of packages to included from the Software Update Configuration.
        :param pulumi.Input[_builtins.str] reboot: Specifies the reboot settings after software update, possible values are `IfRequired`, `Never`, `RebootOnly` and `Always`. Defaults to `IfRequired`.
        """
        pulumi.set(__self__, "classifications_includeds", classifications_includeds)
        if excluded_packages is not None:
            pulumi.set(__self__, "excluded_packages", excluded_packages)
        if included_packages is not None:
            pulumi.set(__self__, "included_packages", included_packages)
        if reboot is not None:
            pulumi.set(__self__, "reboot", reboot)

    @_builtins.property
    @pulumi.getter(name="classificationsIncludeds")
    def classifications_includeds(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        Specifies the list of update classifications included in the Software Update Configuration. Possible values are `Unclassified`, `Critical`, `Security` and `Other`.
        """
        return pulumi.get(self, "classifications_includeds")

    @classifications_includeds.setter
    def classifications_includeds(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "classifications_includeds", value)

    @_builtins.property
    @pulumi.getter(name="excludedPackages")
    def excluded_packages(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies a list of packages to excluded from the Software Update Configuration.
        """
        return pulumi.get(self, "excluded_packages")

    @excluded_packages.setter
    def excluded_packages(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "excluded_packages", value)

    @_builtins.property
    @pulumi.getter(name="includedPackages")
    def included_packages(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies a list of packages to included from the Software Update Configuration.
        """
        return pulumi.get(self, "included_packages")

    @included_packages.setter
    def included_packages(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "included_packages", value)

    @_builtins.property
    @pulumi.getter
    def reboot(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the reboot settings after software update, possible values are `IfRequired`, `Never`, `RebootOnly` and `Always`. Defaults to `IfRequired`.
        """
        return pulumi.get(self, "reboot")

    @reboot.setter
    def reboot(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "reboot", value)


if not MYPY:
    class SoftwareUpdateConfigurationPostTaskArgsDict(TypedDict):
        parameters: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]
        """
        Specifies a map of parameters for the task.
        """
        source: NotRequired[pulumi.Input[_builtins.str]]
        """
        The name of the runbook for the post task.
        """
elif False:
    SoftwareUpdateConfigurationPostTaskArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SoftwareUpdateConfigurationPostTaskArgs:
    def __init__(__self__, *,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 source: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] parameters: Specifies a map of parameters for the task.
        :param pulumi.Input[_builtins.str] source: The name of the runbook for the post task.
        """
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if source is not None:
            pulumi.set(__self__, "source", source)

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Specifies a map of parameters for the task.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "parameters", value)

    @_builtins.property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the runbook for the post task.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source", value)


if not MYPY:
    class SoftwareUpdateConfigurationPreTaskArgsDict(TypedDict):
        parameters: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]
        """
        Specifies a map of parameters for the task.
        """
        source: NotRequired[pulumi.Input[_builtins.str]]
        """
        The name of the runbook for the pre task.
        """
elif False:
    SoftwareUpdateConfigurationPreTaskArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SoftwareUpdateConfigurationPreTaskArgs:
    def __init__(__self__, *,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 source: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] parameters: Specifies a map of parameters for the task.
        :param pulumi.Input[_builtins.str] source: The name of the runbook for the pre task.
        """
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if source is not None:
            pulumi.set(__self__, "source", source)

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Specifies a map of parameters for the task.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "parameters", value)

    @_builtins.property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the runbook for the pre task.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source", value)


if not MYPY:
    class SoftwareUpdateConfigurationScheduleArgsDict(TypedDict):
        frequency: pulumi.Input[_builtins.str]
        """
        The frequency of the schedule. - can be either `OneTime`, `Day`, `Hour`, `Week`, or `Month`.
        """
        advanced_month_days: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]]
        """
        List of days of the month that the job should execute on. Must be between `1` and `31`. `-1` for last day of the month. Only valid when frequency is `Month`.
        """
        advanced_week_days: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        List of days of the week that the job should execute on. Only valid when frequency is `Week`. Possible values include `Monday`, `Tuesday`, `Wednesday`, `Thursday`, `Friday`, `Saturday`, and `Sunday`.
        """
        creation_time: NotRequired[pulumi.Input[_builtins.str]]
        description: NotRequired[pulumi.Input[_builtins.str]]
        """
        A description for this Schedule.
        """
        expiry_time: NotRequired[pulumi.Input[_builtins.str]]
        """
        The end time of the schedule.
        """
        expiry_time_offset_minutes: NotRequired[pulumi.Input[_builtins.float]]
        interval: NotRequired[pulumi.Input[_builtins.int]]
        """
        The number of `frequency`s between runs. Only valid when frequency is `Day`, `Hour`, `Week`, or `Month`.
        """
        is_enabled: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Whether the schedule is enabled. Defaults to `true`.
        """
        last_modified_time: NotRequired[pulumi.Input[_builtins.str]]
        monthly_occurrence: NotRequired[pulumi.Input['SoftwareUpdateConfigurationScheduleMonthlyOccurrenceArgsDict']]
        """
        List of `monthly_occurrence` blocks as defined below to specifies occurrences of days within a month. Only valid when frequency is `Month`. The `monthly_occurrence` block supports fields as defined below.
        """
        next_run: NotRequired[pulumi.Input[_builtins.str]]
        next_run_offset_minutes: NotRequired[pulumi.Input[_builtins.float]]
        start_time: NotRequired[pulumi.Input[_builtins.str]]
        """
        Start time of the schedule. Must be at least five minutes in the future. Defaults to seven minutes in the future from the time the resource is created.
        """
        start_time_offset_minutes: NotRequired[pulumi.Input[_builtins.float]]
        time_zone: NotRequired[pulumi.Input[_builtins.str]]
        """
        The timezone of the start time. Defaults to `Etc/UTC`. For possible values see: <https://docs.microsoft.com/en-us/rest/api/maps/timezone/gettimezoneenumwindows>
        """
elif False:
    SoftwareUpdateConfigurationScheduleArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SoftwareUpdateConfigurationScheduleArgs:
    def __init__(__self__, *,
                 frequency: pulumi.Input[_builtins.str],
                 advanced_month_days: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]] = None,
                 advanced_week_days: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 creation_time: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 expiry_time: Optional[pulumi.Input[_builtins.str]] = None,
                 expiry_time_offset_minutes: Optional[pulumi.Input[_builtins.float]] = None,
                 interval: Optional[pulumi.Input[_builtins.int]] = None,
                 is_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 last_modified_time: Optional[pulumi.Input[_builtins.str]] = None,
                 monthly_occurrence: Optional[pulumi.Input['SoftwareUpdateConfigurationScheduleMonthlyOccurrenceArgs']] = None,
                 next_run: Optional[pulumi.Input[_builtins.str]] = None,
                 next_run_offset_minutes: Optional[pulumi.Input[_builtins.float]] = None,
                 start_time: Optional[pulumi.Input[_builtins.str]] = None,
                 start_time_offset_minutes: Optional[pulumi.Input[_builtins.float]] = None,
                 time_zone: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] frequency: The frequency of the schedule. - can be either `OneTime`, `Day`, `Hour`, `Week`, or `Month`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.int]]] advanced_month_days: List of days of the month that the job should execute on. Must be between `1` and `31`. `-1` for last day of the month. Only valid when frequency is `Month`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] advanced_week_days: List of days of the week that the job should execute on. Only valid when frequency is `Week`. Possible values include `Monday`, `Tuesday`, `Wednesday`, `Thursday`, `Friday`, `Saturday`, and `Sunday`.
        :param pulumi.Input[_builtins.str] description: A description for this Schedule.
        :param pulumi.Input[_builtins.str] expiry_time: The end time of the schedule.
        :param pulumi.Input[_builtins.int] interval: The number of `frequency`s between runs. Only valid when frequency is `Day`, `Hour`, `Week`, or `Month`.
        :param pulumi.Input[_builtins.bool] is_enabled: Whether the schedule is enabled. Defaults to `true`.
        :param pulumi.Input['SoftwareUpdateConfigurationScheduleMonthlyOccurrenceArgs'] monthly_occurrence: List of `monthly_occurrence` blocks as defined below to specifies occurrences of days within a month. Only valid when frequency is `Month`. The `monthly_occurrence` block supports fields as defined below.
        :param pulumi.Input[_builtins.str] start_time: Start time of the schedule. Must be at least five minutes in the future. Defaults to seven minutes in the future from the time the resource is created.
        :param pulumi.Input[_builtins.str] time_zone: The timezone of the start time. Defaults to `Etc/UTC`. For possible values see: <https://docs.microsoft.com/en-us/rest/api/maps/timezone/gettimezoneenumwindows>
        """
        pulumi.set(__self__, "frequency", frequency)
        if advanced_month_days is not None:
            pulumi.set(__self__, "advanced_month_days", advanced_month_days)
        if advanced_week_days is not None:
            pulumi.set(__self__, "advanced_week_days", advanced_week_days)
        if creation_time is not None:
            pulumi.set(__self__, "creation_time", creation_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if expiry_time is not None:
            pulumi.set(__self__, "expiry_time", expiry_time)
        if expiry_time_offset_minutes is not None:
            pulumi.set(__self__, "expiry_time_offset_minutes", expiry_time_offset_minutes)
        if interval is not None:
            pulumi.set(__self__, "interval", interval)
        if is_enabled is not None:
            pulumi.set(__self__, "is_enabled", is_enabled)
        if last_modified_time is not None:
            pulumi.set(__self__, "last_modified_time", last_modified_time)
        if monthly_occurrence is not None:
            pulumi.set(__self__, "monthly_occurrence", monthly_occurrence)
        if next_run is not None:
            pulumi.set(__self__, "next_run", next_run)
        if next_run_offset_minutes is not None:
            pulumi.set(__self__, "next_run_offset_minutes", next_run_offset_minutes)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)
        if start_time_offset_minutes is not None:
            pulumi.set(__self__, "start_time_offset_minutes", start_time_offset_minutes)
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)

    @_builtins.property
    @pulumi.getter
    def frequency(self) -> pulumi.Input[_builtins.str]:
        """
        The frequency of the schedule. - can be either `OneTime`, `Day`, `Hour`, `Week`, or `Month`.
        """
        return pulumi.get(self, "frequency")

    @frequency.setter
    def frequency(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "frequency", value)

    @_builtins.property
    @pulumi.getter(name="advancedMonthDays")
    def advanced_month_days(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]]:
        """
        List of days of the month that the job should execute on. Must be between `1` and `31`. `-1` for last day of the month. Only valid when frequency is `Month`.
        """
        return pulumi.get(self, "advanced_month_days")

    @advanced_month_days.setter
    def advanced_month_days(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]]):
        pulumi.set(self, "advanced_month_days", value)

    @_builtins.property
    @pulumi.getter(name="advancedWeekDays")
    def advanced_week_days(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of days of the week that the job should execute on. Only valid when frequency is `Week`. Possible values include `Monday`, `Tuesday`, `Wednesday`, `Thursday`, `Friday`, `Saturday`, and `Sunday`.
        """
        return pulumi.get(self, "advanced_week_days")

    @advanced_week_days.setter
    def advanced_week_days(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "advanced_week_days", value)

    @_builtins.property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "creation_time")

    @creation_time.setter
    def creation_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "creation_time", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A description for this Schedule.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="expiryTime")
    def expiry_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The end time of the schedule.
        """
        return pulumi.get(self, "expiry_time")

    @expiry_time.setter
    def expiry_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "expiry_time", value)

    @_builtins.property
    @pulumi.getter(name="expiryTimeOffsetMinutes")
    def expiry_time_offset_minutes(self) -> Optional[pulumi.Input[_builtins.float]]:
        return pulumi.get(self, "expiry_time_offset_minutes")

    @expiry_time_offset_minutes.setter
    def expiry_time_offset_minutes(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "expiry_time_offset_minutes", value)

    @_builtins.property
    @pulumi.getter
    def interval(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of `frequency`s between runs. Only valid when frequency is `Day`, `Hour`, `Week`, or `Month`.
        """
        return pulumi.get(self, "interval")

    @interval.setter
    def interval(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "interval", value)

    @_builtins.property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the schedule is enabled. Defaults to `true`.
        """
        return pulumi.get(self, "is_enabled")

    @is_enabled.setter
    def is_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_enabled", value)

    @_builtins.property
    @pulumi.getter(name="lastModifiedTime")
    def last_modified_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "last_modified_time")

    @last_modified_time.setter
    def last_modified_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "last_modified_time", value)

    @_builtins.property
    @pulumi.getter(name="monthlyOccurrence")
    def monthly_occurrence(self) -> Optional[pulumi.Input['SoftwareUpdateConfigurationScheduleMonthlyOccurrenceArgs']]:
        """
        List of `monthly_occurrence` blocks as defined below to specifies occurrences of days within a month. Only valid when frequency is `Month`. The `monthly_occurrence` block supports fields as defined below.
        """
        return pulumi.get(self, "monthly_occurrence")

    @monthly_occurrence.setter
    def monthly_occurrence(self, value: Optional[pulumi.Input['SoftwareUpdateConfigurationScheduleMonthlyOccurrenceArgs']]):
        pulumi.set(self, "monthly_occurrence", value)

    @_builtins.property
    @pulumi.getter(name="nextRun")
    def next_run(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "next_run")

    @next_run.setter
    def next_run(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "next_run", value)

    @_builtins.property
    @pulumi.getter(name="nextRunOffsetMinutes")
    def next_run_offset_minutes(self) -> Optional[pulumi.Input[_builtins.float]]:
        return pulumi.get(self, "next_run_offset_minutes")

    @next_run_offset_minutes.setter
    def next_run_offset_minutes(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "next_run_offset_minutes", value)

    @_builtins.property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Start time of the schedule. Must be at least five minutes in the future. Defaults to seven minutes in the future from the time the resource is created.
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "start_time", value)

    @_builtins.property
    @pulumi.getter(name="startTimeOffsetMinutes")
    def start_time_offset_minutes(self) -> Optional[pulumi.Input[_builtins.float]]:
        return pulumi.get(self, "start_time_offset_minutes")

    @start_time_offset_minutes.setter
    def start_time_offset_minutes(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "start_time_offset_minutes", value)

    @_builtins.property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The timezone of the start time. Defaults to `Etc/UTC`. For possible values see: <https://docs.microsoft.com/en-us/rest/api/maps/timezone/gettimezoneenumwindows>
        """
        return pulumi.get(self, "time_zone")

    @time_zone.setter
    def time_zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_zone", value)


if not MYPY:
    class SoftwareUpdateConfigurationScheduleMonthlyOccurrenceArgsDict(TypedDict):
        day: pulumi.Input[_builtins.str]
        """
        Day of the occurrence. Must be one of `Monday`, `Tuesday`, `Wednesday`, `Thursday`, `Friday`, `Saturday`, `Sunday`.
        """
        occurrence: pulumi.Input[_builtins.int]
        """
        Occurrence of the week within the month. Must be between `1` and `4`. `-1` for last week within the month.
        """
elif False:
    SoftwareUpdateConfigurationScheduleMonthlyOccurrenceArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SoftwareUpdateConfigurationScheduleMonthlyOccurrenceArgs:
    def __init__(__self__, *,
                 day: pulumi.Input[_builtins.str],
                 occurrence: pulumi.Input[_builtins.int]):
        """
        :param pulumi.Input[_builtins.str] day: Day of the occurrence. Must be one of `Monday`, `Tuesday`, `Wednesday`, `Thursday`, `Friday`, `Saturday`, `Sunday`.
        :param pulumi.Input[_builtins.int] occurrence: Occurrence of the week within the month. Must be between `1` and `4`. `-1` for last week within the month.
        """
        pulumi.set(__self__, "day", day)
        pulumi.set(__self__, "occurrence", occurrence)

    @_builtins.property
    @pulumi.getter
    def day(self) -> pulumi.Input[_builtins.str]:
        """
        Day of the occurrence. Must be one of `Monday`, `Tuesday`, `Wednesday`, `Thursday`, `Friday`, `Saturday`, `Sunday`.
        """
        return pulumi.get(self, "day")

    @day.setter
    def day(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "day", value)

    @_builtins.property
    @pulumi.getter
    def occurrence(self) -> pulumi.Input[_builtins.int]:
        """
        Occurrence of the week within the month. Must be between `1` and `4`. `-1` for last week within the month.
        """
        return pulumi.get(self, "occurrence")

    @occurrence.setter
    def occurrence(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "occurrence", value)


if not MYPY:
    class SoftwareUpdateConfigurationTargetArgsDict(TypedDict):
        azure_queries: NotRequired[pulumi.Input[Sequence[pulumi.Input['SoftwareUpdateConfigurationTargetAzureQueryArgsDict']]]]
        """
        One or more `azure_query` blocks as defined above.
        """
        non_azure_queries: NotRequired[pulumi.Input[Sequence[pulumi.Input['SoftwareUpdateConfigurationTargetNonAzureQueryArgsDict']]]]
        """
        One or more `non_azure_query` blocks as defined above.
        """
elif False:
    SoftwareUpdateConfigurationTargetArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SoftwareUpdateConfigurationTargetArgs:
    def __init__(__self__, *,
                 azure_queries: Optional[pulumi.Input[Sequence[pulumi.Input['SoftwareUpdateConfigurationTargetAzureQueryArgs']]]] = None,
                 non_azure_queries: Optional[pulumi.Input[Sequence[pulumi.Input['SoftwareUpdateConfigurationTargetNonAzureQueryArgs']]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['SoftwareUpdateConfigurationTargetAzureQueryArgs']]] azure_queries: One or more `azure_query` blocks as defined above.
        :param pulumi.Input[Sequence[pulumi.Input['SoftwareUpdateConfigurationTargetNonAzureQueryArgs']]] non_azure_queries: One or more `non_azure_query` blocks as defined above.
        """
        if azure_queries is not None:
            pulumi.set(__self__, "azure_queries", azure_queries)
        if non_azure_queries is not None:
            pulumi.set(__self__, "non_azure_queries", non_azure_queries)

    @_builtins.property
    @pulumi.getter(name="azureQueries")
    def azure_queries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SoftwareUpdateConfigurationTargetAzureQueryArgs']]]]:
        """
        One or more `azure_query` blocks as defined above.
        """
        return pulumi.get(self, "azure_queries")

    @azure_queries.setter
    def azure_queries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SoftwareUpdateConfigurationTargetAzureQueryArgs']]]]):
        pulumi.set(self, "azure_queries", value)

    @_builtins.property
    @pulumi.getter(name="nonAzureQueries")
    def non_azure_queries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SoftwareUpdateConfigurationTargetNonAzureQueryArgs']]]]:
        """
        One or more `non_azure_query` blocks as defined above.
        """
        return pulumi.get(self, "non_azure_queries")

    @non_azure_queries.setter
    def non_azure_queries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SoftwareUpdateConfigurationTargetNonAzureQueryArgs']]]]):
        pulumi.set(self, "non_azure_queries", value)


if not MYPY:
    class SoftwareUpdateConfigurationTargetAzureQueryArgsDict(TypedDict):
        locations: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        Specifies a list of locations to scope the query to.
        """
        scopes: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        Specifies a list of Subscription or Resource Group ARM Ids to query.
        """
        tag_filter: NotRequired[pulumi.Input[_builtins.str]]
        """
        Specifies how the specified tags to filter VMs. Possible values are `Any` and `All`.
        """
        tags: NotRequired[pulumi.Input[Sequence[pulumi.Input['SoftwareUpdateConfigurationTargetAzureQueryTagArgsDict']]]]
        """
        A mapping of tags used for query filter. One or more `tags` block as defined below.
        """
elif False:
    SoftwareUpdateConfigurationTargetAzureQueryArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SoftwareUpdateConfigurationTargetAzureQueryArgs:
    def __init__(__self__, *,
                 locations: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 scopes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tag_filter: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['SoftwareUpdateConfigurationTargetAzureQueryTagArgs']]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] locations: Specifies a list of locations to scope the query to.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] scopes: Specifies a list of Subscription or Resource Group ARM Ids to query.
        :param pulumi.Input[_builtins.str] tag_filter: Specifies how the specified tags to filter VMs. Possible values are `Any` and `All`.
        :param pulumi.Input[Sequence[pulumi.Input['SoftwareUpdateConfigurationTargetAzureQueryTagArgs']]] tags: A mapping of tags used for query filter. One or more `tags` block as defined below.
        """
        if locations is not None:
            pulumi.set(__self__, "locations", locations)
        if scopes is not None:
            pulumi.set(__self__, "scopes", scopes)
        if tag_filter is not None:
            pulumi.set(__self__, "tag_filter", tag_filter)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def locations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies a list of locations to scope the query to.
        """
        return pulumi.get(self, "locations")

    @locations.setter
    def locations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "locations", value)

    @_builtins.property
    @pulumi.getter
    def scopes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies a list of Subscription or Resource Group ARM Ids to query.
        """
        return pulumi.get(self, "scopes")

    @scopes.setter
    def scopes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "scopes", value)

    @_builtins.property
    @pulumi.getter(name="tagFilter")
    def tag_filter(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies how the specified tags to filter VMs. Possible values are `Any` and `All`.
        """
        return pulumi.get(self, "tag_filter")

    @tag_filter.setter
    def tag_filter(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tag_filter", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SoftwareUpdateConfigurationTargetAzureQueryTagArgs']]]]:
        """
        A mapping of tags used for query filter. One or more `tags` block as defined below.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SoftwareUpdateConfigurationTargetAzureQueryTagArgs']]]]):
        pulumi.set(self, "tags", value)


if not MYPY:
    class SoftwareUpdateConfigurationTargetAzureQueryTagArgsDict(TypedDict):
        tag: pulumi.Input[_builtins.str]
        """
        Specifies the name of the tag to filter.
        """
        values: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]
        """
        Specifies a list of values for this tag key.
        """
elif False:
    SoftwareUpdateConfigurationTargetAzureQueryTagArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SoftwareUpdateConfigurationTargetAzureQueryTagArgs:
    def __init__(__self__, *,
                 tag: pulumi.Input[_builtins.str],
                 values: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        """
        :param pulumi.Input[_builtins.str] tag: Specifies the name of the tag to filter.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] values: Specifies a list of values for this tag key.
        """
        pulumi.set(__self__, "tag", tag)
        pulumi.set(__self__, "values", values)

    @_builtins.property
    @pulumi.getter
    def tag(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the name of the tag to filter.
        """
        return pulumi.get(self, "tag")

    @tag.setter
    def tag(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "tag", value)

    @_builtins.property
    @pulumi.getter
    def values(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        Specifies a list of values for this tag key.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "values", value)


if not MYPY:
    class SoftwareUpdateConfigurationTargetNonAzureQueryArgsDict(TypedDict):
        function_alias: NotRequired[pulumi.Input[_builtins.str]]
        """
        Specifies the Log Analytics save search name.
        """
        workspace_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The workspace id for Log Analytics in which the saved search in.
        """
elif False:
    SoftwareUpdateConfigurationTargetNonAzureQueryArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SoftwareUpdateConfigurationTargetNonAzureQueryArgs:
    def __init__(__self__, *,
                 function_alias: Optional[pulumi.Input[_builtins.str]] = None,
                 workspace_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] function_alias: Specifies the Log Analytics save search name.
        :param pulumi.Input[_builtins.str] workspace_id: The workspace id for Log Analytics in which the saved search in.
        """
        if function_alias is not None:
            pulumi.set(__self__, "function_alias", function_alias)
        if workspace_id is not None:
            pulumi.set(__self__, "workspace_id", workspace_id)

    @_builtins.property
    @pulumi.getter(name="functionAlias")
    def function_alias(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the Log Analytics save search name.
        """
        return pulumi.get(self, "function_alias")

    @function_alias.setter
    def function_alias(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "function_alias", value)

    @_builtins.property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The workspace id for Log Analytics in which the saved search in.
        """
        return pulumi.get(self, "workspace_id")

    @workspace_id.setter
    def workspace_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "workspace_id", value)


if not MYPY:
    class SoftwareUpdateConfigurationWindowsArgsDict(TypedDict):
        classifications_includeds: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]
        """
        Specifies the list of update classification. Possible values are `Unclassified`, `Critical`, `Security`, `UpdateRollup`, `FeaturePack`, `ServicePack`, `Definition`, `Tools` and `Updates`.
        """
        excluded_knowledge_base_numbers: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        Specifies a list of knowledge base numbers excluded.
        """
        included_knowledge_base_numbers: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        Specifies a list of knowledge base numbers included.
        """
        reboot: NotRequired[pulumi.Input[_builtins.str]]
        """
        Specifies the reboot settings after software update, possible values are `IfRequired`, `Never`, `RebootOnly` and `Always`. Defaults to `IfRequired`.
        """
elif False:
    SoftwareUpdateConfigurationWindowsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SoftwareUpdateConfigurationWindowsArgs:
    def __init__(__self__, *,
                 classifications_includeds: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 excluded_knowledge_base_numbers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 included_knowledge_base_numbers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 reboot: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] classifications_includeds: Specifies the list of update classification. Possible values are `Unclassified`, `Critical`, `Security`, `UpdateRollup`, `FeaturePack`, `ServicePack`, `Definition`, `Tools` and `Updates`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] excluded_knowledge_base_numbers: Specifies a list of knowledge base numbers excluded.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] included_knowledge_base_numbers: Specifies a list of knowledge base numbers included.
        :param pulumi.Input[_builtins.str] reboot: Specifies the reboot settings after software update, possible values are `IfRequired`, `Never`, `RebootOnly` and `Always`. Defaults to `IfRequired`.
        """
        pulumi.set(__self__, "classifications_includeds", classifications_includeds)
        if excluded_knowledge_base_numbers is not None:
            pulumi.set(__self__, "excluded_knowledge_base_numbers", excluded_knowledge_base_numbers)
        if included_knowledge_base_numbers is not None:
            pulumi.set(__self__, "included_knowledge_base_numbers", included_knowledge_base_numbers)
        if reboot is not None:
            pulumi.set(__self__, "reboot", reboot)

    @_builtins.property
    @pulumi.getter(name="classificationsIncludeds")
    def classifications_includeds(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        Specifies the list of update classification. Possible values are `Unclassified`, `Critical`, `Security`, `UpdateRollup`, `FeaturePack`, `ServicePack`, `Definition`, `Tools` and `Updates`.
        """
        return pulumi.get(self, "classifications_includeds")

    @classifications_includeds.setter
    def classifications_includeds(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "classifications_includeds", value)

    @_builtins.property
    @pulumi.getter(name="excludedKnowledgeBaseNumbers")
    def excluded_knowledge_base_numbers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies a list of knowledge base numbers excluded.
        """
        return pulumi.get(self, "excluded_knowledge_base_numbers")

    @excluded_knowledge_base_numbers.setter
    def excluded_knowledge_base_numbers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "excluded_knowledge_base_numbers", value)

    @_builtins.property
    @pulumi.getter(name="includedKnowledgeBaseNumbers")
    def included_knowledge_base_numbers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies a list of knowledge base numbers included.
        """
        return pulumi.get(self, "included_knowledge_base_numbers")

    @included_knowledge_base_numbers.setter
    def included_knowledge_base_numbers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "included_knowledge_base_numbers", value)

    @_builtins.property
    @pulumi.getter
    def reboot(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the reboot settings after software update, possible values are `IfRequired`, `Never`, `RebootOnly` and `Always`. Defaults to `IfRequired`.
        """
        return pulumi.get(self, "reboot")

    @reboot.setter
    def reboot(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "reboot", value)


if not MYPY:
    class SourceControlSecurityArgsDict(TypedDict):
        token: pulumi.Input[_builtins.str]
        """
        The access token of specified repo.
        """
        token_type: pulumi.Input[_builtins.str]
        """
        Specify the token type, possible values are `PersonalAccessToken` and `Oauth`.
        """
        refresh_token: NotRequired[pulumi.Input[_builtins.str]]
        """
        The refresh token of specified rpeo.
        """
elif False:
    SourceControlSecurityArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SourceControlSecurityArgs:
    def __init__(__self__, *,
                 token: pulumi.Input[_builtins.str],
                 token_type: pulumi.Input[_builtins.str],
                 refresh_token: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] token: The access token of specified repo.
        :param pulumi.Input[_builtins.str] token_type: Specify the token type, possible values are `PersonalAccessToken` and `Oauth`.
        :param pulumi.Input[_builtins.str] refresh_token: The refresh token of specified rpeo.
        """
        pulumi.set(__self__, "token", token)
        pulumi.set(__self__, "token_type", token_type)
        if refresh_token is not None:
            pulumi.set(__self__, "refresh_token", refresh_token)

    @_builtins.property
    @pulumi.getter
    def token(self) -> pulumi.Input[_builtins.str]:
        """
        The access token of specified repo.
        """
        return pulumi.get(self, "token")

    @token.setter
    def token(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "token", value)

    @_builtins.property
    @pulumi.getter(name="tokenType")
    def token_type(self) -> pulumi.Input[_builtins.str]:
        """
        Specify the token type, possible values are `PersonalAccessToken` and `Oauth`.
        """
        return pulumi.get(self, "token_type")

    @token_type.setter
    def token_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "token_type", value)

    @_builtins.property
    @pulumi.getter(name="refreshToken")
    def refresh_token(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The refresh token of specified rpeo.
        """
        return pulumi.get(self, "refresh_token")

    @refresh_token.setter
    def refresh_token(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "refresh_token", value)


