# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['PoolArgs', 'Pool']

@pulumi.input_type
class PoolArgs:
    def __init__(__self__, *,
                 account_name: pulumi.Input[_builtins.str],
                 node_agent_sku_id: pulumi.Input[_builtins.str],
                 resource_group_name: pulumi.Input[_builtins.str],
                 storage_image_reference: pulumi.Input['PoolStorageImageReferenceArgs'],
                 vm_size: pulumi.Input[_builtins.str],
                 auto_scale: Optional[pulumi.Input['PoolAutoScaleArgs']] = None,
                 certificates: Optional[pulumi.Input[Sequence[pulumi.Input['PoolCertificateArgs']]]] = None,
                 container_configuration: Optional[pulumi.Input['PoolContainerConfigurationArgs']] = None,
                 data_disks: Optional[pulumi.Input[Sequence[pulumi.Input['PoolDataDiskArgs']]]] = None,
                 disk_encryptions: Optional[pulumi.Input[Sequence[pulumi.Input['PoolDiskEncryptionArgs']]]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 extensions: Optional[pulumi.Input[Sequence[pulumi.Input['PoolExtensionArgs']]]] = None,
                 fixed_scale: Optional[pulumi.Input['PoolFixedScaleArgs']] = None,
                 identity: Optional[pulumi.Input['PoolIdentityArgs']] = None,
                 inter_node_communication: Optional[pulumi.Input[_builtins.str]] = None,
                 license_type: Optional[pulumi.Input[_builtins.str]] = None,
                 max_tasks_per_node: Optional[pulumi.Input[_builtins.int]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 mounts: Optional[pulumi.Input[Sequence[pulumi.Input['PoolMountArgs']]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_configuration: Optional[pulumi.Input['PoolNetworkConfigurationArgs']] = None,
                 node_placements: Optional[pulumi.Input[Sequence[pulumi.Input['PoolNodePlacementArgs']]]] = None,
                 os_disk_placement: Optional[pulumi.Input[_builtins.str]] = None,
                 security_profile: Optional[pulumi.Input['PoolSecurityProfileArgs']] = None,
                 start_task: Optional[pulumi.Input['PoolStartTaskArgs']] = None,
                 stop_pending_resize_operation: Optional[pulumi.Input[_builtins.bool]] = None,
                 target_node_communication_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 task_scheduling_policies: Optional[pulumi.Input[Sequence[pulumi.Input['PoolTaskSchedulingPolicyArgs']]]] = None,
                 user_accounts: Optional[pulumi.Input[Sequence[pulumi.Input['PoolUserAccountArgs']]]] = None,
                 windows: Optional[pulumi.Input[Sequence[pulumi.Input['PoolWindowArgs']]]] = None):
        """
        The set of arguments for constructing a Pool resource.
        :param pulumi.Input[_builtins.str] account_name: Specifies the name of the Batch account in which the pool will be created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] node_agent_sku_id: Specifies the SKU of the node agents that will be created in the Batch pool. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which to create the Batch pool. Changing this forces a new resource to be created.
        :param pulumi.Input['PoolStorageImageReferenceArgs'] storage_image_reference: A `storage_image_reference` block for the virtual machines that will compose the Batch pool as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] vm_size: Specifies the size of the VM created in the Batch pool. Changing this forces a new resource to be created.
        :param pulumi.Input['PoolAutoScaleArgs'] auto_scale: A `auto_scale` block that describes the scale settings when using auto scale as defined below.
        :param pulumi.Input[Sequence[pulumi.Input['PoolCertificateArgs']]] certificates: One or more `certificate` blocks that describe the certificates to be installed on each compute node in the pool as defined below.
        :param pulumi.Input['PoolContainerConfigurationArgs'] container_configuration: The container configuration used in the pool's VMs. One `container_configuration` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input['PoolDataDiskArgs']]] data_disks: A `data_disks` block describes the data disk settings as defined below.
        :param pulumi.Input[Sequence[pulumi.Input['PoolDiskEncryptionArgs']]] disk_encryptions: A `disk_encryption` block, as defined below, describes the disk encryption configuration applied on compute nodes in the pool. Disk encryption configuration is not supported on Linux pool created with Virtual Machine Image or Shared Image Gallery Image.
        :param pulumi.Input[_builtins.str] display_name: Specifies the display name of the Batch pool. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input['PoolExtensionArgs']]] extensions: An `extensions` block as defined below.
        :param pulumi.Input['PoolFixedScaleArgs'] fixed_scale: A `fixed_scale` block that describes the scale settings when using fixed scale as defined below.
        :param pulumi.Input['PoolIdentityArgs'] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.str] inter_node_communication: Whether the pool permits direct communication between nodes. This imposes restrictions on which nodes can be assigned to the pool. Enabling this value can reduce the chance of the requested number of nodes to be allocated in the pool. Values allowed are `Disabled` and `Enabled`. Defaults to `Enabled`.
        :param pulumi.Input[_builtins.str] license_type: The type of on-premises license to be used when deploying the operating system. This only applies to images that contain the Windows operating system, and should only be used when you hold valid on-premises licenses for the nodes which will be deployed. If omitted, no on-premises licensing discount is applied. Values are: "Windows_Server" - The on-premises license is for Windows Server. "Windows_Client" - The on-premises license is for Windows Client.
        :param pulumi.Input[_builtins.int] max_tasks_per_node: Specifies the maximum number of tasks that can run concurrently on a single compute node in the pool. Defaults to `1`. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] metadata: A map of custom batch pool metadata.
        :param pulumi.Input[Sequence[pulumi.Input['PoolMountArgs']]] mounts: A `mount` block defined as below.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Batch pool. Changing this forces a new resource to be created.
        :param pulumi.Input['PoolNetworkConfigurationArgs'] network_configuration: A `network_configuration` block that describes the network configurations for the Batch pool as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input['PoolNodePlacementArgs']]] node_placements: A `node_placement` block that describes the placement policy for allocating nodes in the pool as defined below.
        :param pulumi.Input[_builtins.str] os_disk_placement: Specifies the ephemeral disk placement for operating system disk for all VMs in the pool. This property can be used by user in the request to choose which location the operating system should be in. e.g., cache disk space for Ephemeral OS disk provisioning. For more information on Ephemeral OS disk size requirements, please refer to Ephemeral OS disk size requirements for Windows VMs at <https://docs.microsoft.com/en-us/azure/virtual-machines/windows/ephemeral-os-disks#size-requirements> and Linux VMs at <https://docs.microsoft.com/en-us/azure/virtual-machines/linux/ephemeral-os-disks#size-requirements>. The only possible value is `CacheDisk`.
        :param pulumi.Input['PoolSecurityProfileArgs'] security_profile: A `security_profile` block that describes the security settings for the Batch pool as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input['PoolStartTaskArgs'] start_task: A `start_task` block that describes the start task settings for the Batch pool as defined below.
        :param pulumi.Input[_builtins.bool] stop_pending_resize_operation: Whether to stop if there is a pending resize operation on this pool.
        :param pulumi.Input[_builtins.str] target_node_communication_mode: The desired node communication mode for the pool. Possible values are `Classic`, `Default` and `Simplified`.
        :param pulumi.Input[Sequence[pulumi.Input['PoolTaskSchedulingPolicyArgs']]] task_scheduling_policies: A `task_scheduling_policy` block that describes how tasks are distributed across compute nodes in a pool as defined below. If not specified, the default is spread as defined below.
        :param pulumi.Input[Sequence[pulumi.Input['PoolUserAccountArgs']]] user_accounts: A `user_accounts` block that describes the list of user accounts to be created on each node in the pool as defined below.
        :param pulumi.Input[Sequence[pulumi.Input['PoolWindowArgs']]] windows: A `windows` block that describes the Windows configuration in the pool as defined below.
               
               > **Note:** For Windows compute nodes, the Batch service installs the certificates to the specified certificate store and location. For Linux compute nodes, the certificates are stored in a directory inside the task working directory and an environment variable `AZ_BATCH_CERTIFICATES_DIR` is supplied to the task to query for this location. For certificates with visibility of `remoteUser`, a `certs` directory is created in the user's home directory (e.g., `/home/{user-name}/certs`) and certificates are placed in that directory.
               
               > **Note:** `fixed_scale` and `auto_scale` blocks cannot be used both at the same time.
        """
        pulumi.set(__self__, "account_name", account_name)
        pulumi.set(__self__, "node_agent_sku_id", node_agent_sku_id)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "storage_image_reference", storage_image_reference)
        pulumi.set(__self__, "vm_size", vm_size)
        if auto_scale is not None:
            pulumi.set(__self__, "auto_scale", auto_scale)
        if certificates is not None:
            pulumi.set(__self__, "certificates", certificates)
        if container_configuration is not None:
            pulumi.set(__self__, "container_configuration", container_configuration)
        if data_disks is not None:
            pulumi.set(__self__, "data_disks", data_disks)
        if disk_encryptions is not None:
            pulumi.set(__self__, "disk_encryptions", disk_encryptions)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if extensions is not None:
            pulumi.set(__self__, "extensions", extensions)
        if fixed_scale is not None:
            pulumi.set(__self__, "fixed_scale", fixed_scale)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if inter_node_communication is not None:
            pulumi.set(__self__, "inter_node_communication", inter_node_communication)
        if license_type is not None:
            pulumi.set(__self__, "license_type", license_type)
        if max_tasks_per_node is not None:
            pulumi.set(__self__, "max_tasks_per_node", max_tasks_per_node)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if mounts is not None:
            pulumi.set(__self__, "mounts", mounts)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_configuration is not None:
            pulumi.set(__self__, "network_configuration", network_configuration)
        if node_placements is not None:
            pulumi.set(__self__, "node_placements", node_placements)
        if os_disk_placement is not None:
            pulumi.set(__self__, "os_disk_placement", os_disk_placement)
        if security_profile is not None:
            pulumi.set(__self__, "security_profile", security_profile)
        if start_task is not None:
            pulumi.set(__self__, "start_task", start_task)
        if stop_pending_resize_operation is not None:
            pulumi.set(__self__, "stop_pending_resize_operation", stop_pending_resize_operation)
        if target_node_communication_mode is not None:
            pulumi.set(__self__, "target_node_communication_mode", target_node_communication_mode)
        if task_scheduling_policies is not None:
            pulumi.set(__self__, "task_scheduling_policies", task_scheduling_policies)
        if user_accounts is not None:
            pulumi.set(__self__, "user_accounts", user_accounts)
        if windows is not None:
            pulumi.set(__self__, "windows", windows)

    @_builtins.property
    @pulumi.getter(name="accountName")
    def account_name(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the name of the Batch account in which the pool will be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "account_name")

    @account_name.setter
    def account_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "account_name", value)

    @_builtins.property
    @pulumi.getter(name="nodeAgentSkuId")
    def node_agent_sku_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the SKU of the node agents that will be created in the Batch pool. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "node_agent_sku_id")

    @node_agent_sku_id.setter
    def node_agent_sku_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "node_agent_sku_id", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the resource group in which to create the Batch pool. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="storageImageReference")
    def storage_image_reference(self) -> pulumi.Input['PoolStorageImageReferenceArgs']:
        """
        A `storage_image_reference` block for the virtual machines that will compose the Batch pool as defined below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "storage_image_reference")

    @storage_image_reference.setter
    def storage_image_reference(self, value: pulumi.Input['PoolStorageImageReferenceArgs']):
        pulumi.set(self, "storage_image_reference", value)

    @_builtins.property
    @pulumi.getter(name="vmSize")
    def vm_size(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the size of the VM created in the Batch pool. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "vm_size")

    @vm_size.setter
    def vm_size(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "vm_size", value)

    @_builtins.property
    @pulumi.getter(name="autoScale")
    def auto_scale(self) -> Optional[pulumi.Input['PoolAutoScaleArgs']]:
        """
        A `auto_scale` block that describes the scale settings when using auto scale as defined below.
        """
        return pulumi.get(self, "auto_scale")

    @auto_scale.setter
    def auto_scale(self, value: Optional[pulumi.Input['PoolAutoScaleArgs']]):
        pulumi.set(self, "auto_scale", value)

    @_builtins.property
    @pulumi.getter
    def certificates(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PoolCertificateArgs']]]]:
        """
        One or more `certificate` blocks that describe the certificates to be installed on each compute node in the pool as defined below.
        """
        return pulumi.get(self, "certificates")

    @certificates.setter
    def certificates(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PoolCertificateArgs']]]]):
        pulumi.set(self, "certificates", value)

    @_builtins.property
    @pulumi.getter(name="containerConfiguration")
    def container_configuration(self) -> Optional[pulumi.Input['PoolContainerConfigurationArgs']]:
        """
        The container configuration used in the pool's VMs. One `container_configuration` block as defined below.
        """
        return pulumi.get(self, "container_configuration")

    @container_configuration.setter
    def container_configuration(self, value: Optional[pulumi.Input['PoolContainerConfigurationArgs']]):
        pulumi.set(self, "container_configuration", value)

    @_builtins.property
    @pulumi.getter(name="dataDisks")
    def data_disks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PoolDataDiskArgs']]]]:
        """
        A `data_disks` block describes the data disk settings as defined below.
        """
        return pulumi.get(self, "data_disks")

    @data_disks.setter
    def data_disks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PoolDataDiskArgs']]]]):
        pulumi.set(self, "data_disks", value)

    @_builtins.property
    @pulumi.getter(name="diskEncryptions")
    def disk_encryptions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PoolDiskEncryptionArgs']]]]:
        """
        A `disk_encryption` block, as defined below, describes the disk encryption configuration applied on compute nodes in the pool. Disk encryption configuration is not supported on Linux pool created with Virtual Machine Image or Shared Image Gallery Image.
        """
        return pulumi.get(self, "disk_encryptions")

    @disk_encryptions.setter
    def disk_encryptions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PoolDiskEncryptionArgs']]]]):
        pulumi.set(self, "disk_encryptions", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the display name of the Batch pool. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter
    def extensions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PoolExtensionArgs']]]]:
        """
        An `extensions` block as defined below.
        """
        return pulumi.get(self, "extensions")

    @extensions.setter
    def extensions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PoolExtensionArgs']]]]):
        pulumi.set(self, "extensions", value)

    @_builtins.property
    @pulumi.getter(name="fixedScale")
    def fixed_scale(self) -> Optional[pulumi.Input['PoolFixedScaleArgs']]:
        """
        A `fixed_scale` block that describes the scale settings when using fixed scale as defined below.
        """
        return pulumi.get(self, "fixed_scale")

    @fixed_scale.setter
    def fixed_scale(self, value: Optional[pulumi.Input['PoolFixedScaleArgs']]):
        pulumi.set(self, "fixed_scale", value)

    @_builtins.property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['PoolIdentityArgs']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['PoolIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @_builtins.property
    @pulumi.getter(name="interNodeCommunication")
    def inter_node_communication(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether the pool permits direct communication between nodes. This imposes restrictions on which nodes can be assigned to the pool. Enabling this value can reduce the chance of the requested number of nodes to be allocated in the pool. Values allowed are `Disabled` and `Enabled`. Defaults to `Enabled`.
        """
        return pulumi.get(self, "inter_node_communication")

    @inter_node_communication.setter
    def inter_node_communication(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "inter_node_communication", value)

    @_builtins.property
    @pulumi.getter(name="licenseType")
    def license_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of on-premises license to be used when deploying the operating system. This only applies to images that contain the Windows operating system, and should only be used when you hold valid on-premises licenses for the nodes which will be deployed. If omitted, no on-premises licensing discount is applied. Values are: "Windows_Server" - The on-premises license is for Windows Server. "Windows_Client" - The on-premises license is for Windows Client.
        """
        return pulumi.get(self, "license_type")

    @license_type.setter
    def license_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "license_type", value)

    @_builtins.property
    @pulumi.getter(name="maxTasksPerNode")
    def max_tasks_per_node(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the maximum number of tasks that can run concurrently on a single compute node in the pool. Defaults to `1`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "max_tasks_per_node")

    @max_tasks_per_node.setter
    def max_tasks_per_node(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_tasks_per_node", value)

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of custom batch pool metadata.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "metadata", value)

    @_builtins.property
    @pulumi.getter
    def mounts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PoolMountArgs']]]]:
        """
        A `mount` block defined as below.
        """
        return pulumi.get(self, "mounts")

    @mounts.setter
    def mounts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PoolMountArgs']]]]):
        pulumi.set(self, "mounts", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the Batch pool. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="networkConfiguration")
    def network_configuration(self) -> Optional[pulumi.Input['PoolNetworkConfigurationArgs']]:
        """
        A `network_configuration` block that describes the network configurations for the Batch pool as defined below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "network_configuration")

    @network_configuration.setter
    def network_configuration(self, value: Optional[pulumi.Input['PoolNetworkConfigurationArgs']]):
        pulumi.set(self, "network_configuration", value)

    @_builtins.property
    @pulumi.getter(name="nodePlacements")
    def node_placements(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PoolNodePlacementArgs']]]]:
        """
        A `node_placement` block that describes the placement policy for allocating nodes in the pool as defined below.
        """
        return pulumi.get(self, "node_placements")

    @node_placements.setter
    def node_placements(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PoolNodePlacementArgs']]]]):
        pulumi.set(self, "node_placements", value)

    @_builtins.property
    @pulumi.getter(name="osDiskPlacement")
    def os_disk_placement(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ephemeral disk placement for operating system disk for all VMs in the pool. This property can be used by user in the request to choose which location the operating system should be in. e.g., cache disk space for Ephemeral OS disk provisioning. For more information on Ephemeral OS disk size requirements, please refer to Ephemeral OS disk size requirements for Windows VMs at <https://docs.microsoft.com/en-us/azure/virtual-machines/windows/ephemeral-os-disks#size-requirements> and Linux VMs at <https://docs.microsoft.com/en-us/azure/virtual-machines/linux/ephemeral-os-disks#size-requirements>. The only possible value is `CacheDisk`.
        """
        return pulumi.get(self, "os_disk_placement")

    @os_disk_placement.setter
    def os_disk_placement(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "os_disk_placement", value)

    @_builtins.property
    @pulumi.getter(name="securityProfile")
    def security_profile(self) -> Optional[pulumi.Input['PoolSecurityProfileArgs']]:
        """
        A `security_profile` block that describes the security settings for the Batch pool as defined below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "security_profile")

    @security_profile.setter
    def security_profile(self, value: Optional[pulumi.Input['PoolSecurityProfileArgs']]):
        pulumi.set(self, "security_profile", value)

    @_builtins.property
    @pulumi.getter(name="startTask")
    def start_task(self) -> Optional[pulumi.Input['PoolStartTaskArgs']]:
        """
        A `start_task` block that describes the start task settings for the Batch pool as defined below.
        """
        return pulumi.get(self, "start_task")

    @start_task.setter
    def start_task(self, value: Optional[pulumi.Input['PoolStartTaskArgs']]):
        pulumi.set(self, "start_task", value)

    @_builtins.property
    @pulumi.getter(name="stopPendingResizeOperation")
    def stop_pending_resize_operation(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to stop if there is a pending resize operation on this pool.
        """
        return pulumi.get(self, "stop_pending_resize_operation")

    @stop_pending_resize_operation.setter
    def stop_pending_resize_operation(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "stop_pending_resize_operation", value)

    @_builtins.property
    @pulumi.getter(name="targetNodeCommunicationMode")
    def target_node_communication_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The desired node communication mode for the pool. Possible values are `Classic`, `Default` and `Simplified`.
        """
        return pulumi.get(self, "target_node_communication_mode")

    @target_node_communication_mode.setter
    def target_node_communication_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target_node_communication_mode", value)

    @_builtins.property
    @pulumi.getter(name="taskSchedulingPolicies")
    def task_scheduling_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PoolTaskSchedulingPolicyArgs']]]]:
        """
        A `task_scheduling_policy` block that describes how tasks are distributed across compute nodes in a pool as defined below. If not specified, the default is spread as defined below.
        """
        return pulumi.get(self, "task_scheduling_policies")

    @task_scheduling_policies.setter
    def task_scheduling_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PoolTaskSchedulingPolicyArgs']]]]):
        pulumi.set(self, "task_scheduling_policies", value)

    @_builtins.property
    @pulumi.getter(name="userAccounts")
    def user_accounts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PoolUserAccountArgs']]]]:
        """
        A `user_accounts` block that describes the list of user accounts to be created on each node in the pool as defined below.
        """
        return pulumi.get(self, "user_accounts")

    @user_accounts.setter
    def user_accounts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PoolUserAccountArgs']]]]):
        pulumi.set(self, "user_accounts", value)

    @_builtins.property
    @pulumi.getter
    def windows(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PoolWindowArgs']]]]:
        """
        A `windows` block that describes the Windows configuration in the pool as defined below.

        > **Note:** For Windows compute nodes, the Batch service installs the certificates to the specified certificate store and location. For Linux compute nodes, the certificates are stored in a directory inside the task working directory and an environment variable `AZ_BATCH_CERTIFICATES_DIR` is supplied to the task to query for this location. For certificates with visibility of `remoteUser`, a `certs` directory is created in the user's home directory (e.g., `/home/{user-name}/certs`) and certificates are placed in that directory.

        > **Note:** `fixed_scale` and `auto_scale` blocks cannot be used both at the same time.
        """
        return pulumi.get(self, "windows")

    @windows.setter
    def windows(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PoolWindowArgs']]]]):
        pulumi.set(self, "windows", value)


@pulumi.input_type
class _PoolState:
    def __init__(__self__, *,
                 account_name: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_scale: Optional[pulumi.Input['PoolAutoScaleArgs']] = None,
                 certificates: Optional[pulumi.Input[Sequence[pulumi.Input['PoolCertificateArgs']]]] = None,
                 container_configuration: Optional[pulumi.Input['PoolContainerConfigurationArgs']] = None,
                 data_disks: Optional[pulumi.Input[Sequence[pulumi.Input['PoolDataDiskArgs']]]] = None,
                 disk_encryptions: Optional[pulumi.Input[Sequence[pulumi.Input['PoolDiskEncryptionArgs']]]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 extensions: Optional[pulumi.Input[Sequence[pulumi.Input['PoolExtensionArgs']]]] = None,
                 fixed_scale: Optional[pulumi.Input['PoolFixedScaleArgs']] = None,
                 identity: Optional[pulumi.Input['PoolIdentityArgs']] = None,
                 inter_node_communication: Optional[pulumi.Input[_builtins.str]] = None,
                 license_type: Optional[pulumi.Input[_builtins.str]] = None,
                 max_tasks_per_node: Optional[pulumi.Input[_builtins.int]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 mounts: Optional[pulumi.Input[Sequence[pulumi.Input['PoolMountArgs']]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_configuration: Optional[pulumi.Input['PoolNetworkConfigurationArgs']] = None,
                 node_agent_sku_id: Optional[pulumi.Input[_builtins.str]] = None,
                 node_placements: Optional[pulumi.Input[Sequence[pulumi.Input['PoolNodePlacementArgs']]]] = None,
                 os_disk_placement: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 security_profile: Optional[pulumi.Input['PoolSecurityProfileArgs']] = None,
                 start_task: Optional[pulumi.Input['PoolStartTaskArgs']] = None,
                 stop_pending_resize_operation: Optional[pulumi.Input[_builtins.bool]] = None,
                 storage_image_reference: Optional[pulumi.Input['PoolStorageImageReferenceArgs']] = None,
                 target_node_communication_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 task_scheduling_policies: Optional[pulumi.Input[Sequence[pulumi.Input['PoolTaskSchedulingPolicyArgs']]]] = None,
                 user_accounts: Optional[pulumi.Input[Sequence[pulumi.Input['PoolUserAccountArgs']]]] = None,
                 vm_size: Optional[pulumi.Input[_builtins.str]] = None,
                 windows: Optional[pulumi.Input[Sequence[pulumi.Input['PoolWindowArgs']]]] = None):
        """
        Input properties used for looking up and filtering Pool resources.
        :param pulumi.Input[_builtins.str] account_name: Specifies the name of the Batch account in which the pool will be created. Changing this forces a new resource to be created.
        :param pulumi.Input['PoolAutoScaleArgs'] auto_scale: A `auto_scale` block that describes the scale settings when using auto scale as defined below.
        :param pulumi.Input[Sequence[pulumi.Input['PoolCertificateArgs']]] certificates: One or more `certificate` blocks that describe the certificates to be installed on each compute node in the pool as defined below.
        :param pulumi.Input['PoolContainerConfigurationArgs'] container_configuration: The container configuration used in the pool's VMs. One `container_configuration` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input['PoolDataDiskArgs']]] data_disks: A `data_disks` block describes the data disk settings as defined below.
        :param pulumi.Input[Sequence[pulumi.Input['PoolDiskEncryptionArgs']]] disk_encryptions: A `disk_encryption` block, as defined below, describes the disk encryption configuration applied on compute nodes in the pool. Disk encryption configuration is not supported on Linux pool created with Virtual Machine Image or Shared Image Gallery Image.
        :param pulumi.Input[_builtins.str] display_name: Specifies the display name of the Batch pool. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input['PoolExtensionArgs']]] extensions: An `extensions` block as defined below.
        :param pulumi.Input['PoolFixedScaleArgs'] fixed_scale: A `fixed_scale` block that describes the scale settings when using fixed scale as defined below.
        :param pulumi.Input['PoolIdentityArgs'] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.str] inter_node_communication: Whether the pool permits direct communication between nodes. This imposes restrictions on which nodes can be assigned to the pool. Enabling this value can reduce the chance of the requested number of nodes to be allocated in the pool. Values allowed are `Disabled` and `Enabled`. Defaults to `Enabled`.
        :param pulumi.Input[_builtins.str] license_type: The type of on-premises license to be used when deploying the operating system. This only applies to images that contain the Windows operating system, and should only be used when you hold valid on-premises licenses for the nodes which will be deployed. If omitted, no on-premises licensing discount is applied. Values are: "Windows_Server" - The on-premises license is for Windows Server. "Windows_Client" - The on-premises license is for Windows Client.
        :param pulumi.Input[_builtins.int] max_tasks_per_node: Specifies the maximum number of tasks that can run concurrently on a single compute node in the pool. Defaults to `1`. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] metadata: A map of custom batch pool metadata.
        :param pulumi.Input[Sequence[pulumi.Input['PoolMountArgs']]] mounts: A `mount` block defined as below.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Batch pool. Changing this forces a new resource to be created.
        :param pulumi.Input['PoolNetworkConfigurationArgs'] network_configuration: A `network_configuration` block that describes the network configurations for the Batch pool as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] node_agent_sku_id: Specifies the SKU of the node agents that will be created in the Batch pool. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input['PoolNodePlacementArgs']]] node_placements: A `node_placement` block that describes the placement policy for allocating nodes in the pool as defined below.
        :param pulumi.Input[_builtins.str] os_disk_placement: Specifies the ephemeral disk placement for operating system disk for all VMs in the pool. This property can be used by user in the request to choose which location the operating system should be in. e.g., cache disk space for Ephemeral OS disk provisioning. For more information on Ephemeral OS disk size requirements, please refer to Ephemeral OS disk size requirements for Windows VMs at <https://docs.microsoft.com/en-us/azure/virtual-machines/windows/ephemeral-os-disks#size-requirements> and Linux VMs at <https://docs.microsoft.com/en-us/azure/virtual-machines/linux/ephemeral-os-disks#size-requirements>. The only possible value is `CacheDisk`.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which to create the Batch pool. Changing this forces a new resource to be created.
        :param pulumi.Input['PoolSecurityProfileArgs'] security_profile: A `security_profile` block that describes the security settings for the Batch pool as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input['PoolStartTaskArgs'] start_task: A `start_task` block that describes the start task settings for the Batch pool as defined below.
        :param pulumi.Input[_builtins.bool] stop_pending_resize_operation: Whether to stop if there is a pending resize operation on this pool.
        :param pulumi.Input['PoolStorageImageReferenceArgs'] storage_image_reference: A `storage_image_reference` block for the virtual machines that will compose the Batch pool as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] target_node_communication_mode: The desired node communication mode for the pool. Possible values are `Classic`, `Default` and `Simplified`.
        :param pulumi.Input[Sequence[pulumi.Input['PoolTaskSchedulingPolicyArgs']]] task_scheduling_policies: A `task_scheduling_policy` block that describes how tasks are distributed across compute nodes in a pool as defined below. If not specified, the default is spread as defined below.
        :param pulumi.Input[Sequence[pulumi.Input['PoolUserAccountArgs']]] user_accounts: A `user_accounts` block that describes the list of user accounts to be created on each node in the pool as defined below.
        :param pulumi.Input[_builtins.str] vm_size: Specifies the size of the VM created in the Batch pool. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input['PoolWindowArgs']]] windows: A `windows` block that describes the Windows configuration in the pool as defined below.
               
               > **Note:** For Windows compute nodes, the Batch service installs the certificates to the specified certificate store and location. For Linux compute nodes, the certificates are stored in a directory inside the task working directory and an environment variable `AZ_BATCH_CERTIFICATES_DIR` is supplied to the task to query for this location. For certificates with visibility of `remoteUser`, a `certs` directory is created in the user's home directory (e.g., `/home/{user-name}/certs`) and certificates are placed in that directory.
               
               > **Note:** `fixed_scale` and `auto_scale` blocks cannot be used both at the same time.
        """
        if account_name is not None:
            pulumi.set(__self__, "account_name", account_name)
        if auto_scale is not None:
            pulumi.set(__self__, "auto_scale", auto_scale)
        if certificates is not None:
            pulumi.set(__self__, "certificates", certificates)
        if container_configuration is not None:
            pulumi.set(__self__, "container_configuration", container_configuration)
        if data_disks is not None:
            pulumi.set(__self__, "data_disks", data_disks)
        if disk_encryptions is not None:
            pulumi.set(__self__, "disk_encryptions", disk_encryptions)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if extensions is not None:
            pulumi.set(__self__, "extensions", extensions)
        if fixed_scale is not None:
            pulumi.set(__self__, "fixed_scale", fixed_scale)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if inter_node_communication is not None:
            pulumi.set(__self__, "inter_node_communication", inter_node_communication)
        if license_type is not None:
            pulumi.set(__self__, "license_type", license_type)
        if max_tasks_per_node is not None:
            pulumi.set(__self__, "max_tasks_per_node", max_tasks_per_node)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if mounts is not None:
            pulumi.set(__self__, "mounts", mounts)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_configuration is not None:
            pulumi.set(__self__, "network_configuration", network_configuration)
        if node_agent_sku_id is not None:
            pulumi.set(__self__, "node_agent_sku_id", node_agent_sku_id)
        if node_placements is not None:
            pulumi.set(__self__, "node_placements", node_placements)
        if os_disk_placement is not None:
            pulumi.set(__self__, "os_disk_placement", os_disk_placement)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if security_profile is not None:
            pulumi.set(__self__, "security_profile", security_profile)
        if start_task is not None:
            pulumi.set(__self__, "start_task", start_task)
        if stop_pending_resize_operation is not None:
            pulumi.set(__self__, "stop_pending_resize_operation", stop_pending_resize_operation)
        if storage_image_reference is not None:
            pulumi.set(__self__, "storage_image_reference", storage_image_reference)
        if target_node_communication_mode is not None:
            pulumi.set(__self__, "target_node_communication_mode", target_node_communication_mode)
        if task_scheduling_policies is not None:
            pulumi.set(__self__, "task_scheduling_policies", task_scheduling_policies)
        if user_accounts is not None:
            pulumi.set(__self__, "user_accounts", user_accounts)
        if vm_size is not None:
            pulumi.set(__self__, "vm_size", vm_size)
        if windows is not None:
            pulumi.set(__self__, "windows", windows)

    @_builtins.property
    @pulumi.getter(name="accountName")
    def account_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the Batch account in which the pool will be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "account_name")

    @account_name.setter
    def account_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_name", value)

    @_builtins.property
    @pulumi.getter(name="autoScale")
    def auto_scale(self) -> Optional[pulumi.Input['PoolAutoScaleArgs']]:
        """
        A `auto_scale` block that describes the scale settings when using auto scale as defined below.
        """
        return pulumi.get(self, "auto_scale")

    @auto_scale.setter
    def auto_scale(self, value: Optional[pulumi.Input['PoolAutoScaleArgs']]):
        pulumi.set(self, "auto_scale", value)

    @_builtins.property
    @pulumi.getter
    def certificates(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PoolCertificateArgs']]]]:
        """
        One or more `certificate` blocks that describe the certificates to be installed on each compute node in the pool as defined below.
        """
        return pulumi.get(self, "certificates")

    @certificates.setter
    def certificates(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PoolCertificateArgs']]]]):
        pulumi.set(self, "certificates", value)

    @_builtins.property
    @pulumi.getter(name="containerConfiguration")
    def container_configuration(self) -> Optional[pulumi.Input['PoolContainerConfigurationArgs']]:
        """
        The container configuration used in the pool's VMs. One `container_configuration` block as defined below.
        """
        return pulumi.get(self, "container_configuration")

    @container_configuration.setter
    def container_configuration(self, value: Optional[pulumi.Input['PoolContainerConfigurationArgs']]):
        pulumi.set(self, "container_configuration", value)

    @_builtins.property
    @pulumi.getter(name="dataDisks")
    def data_disks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PoolDataDiskArgs']]]]:
        """
        A `data_disks` block describes the data disk settings as defined below.
        """
        return pulumi.get(self, "data_disks")

    @data_disks.setter
    def data_disks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PoolDataDiskArgs']]]]):
        pulumi.set(self, "data_disks", value)

    @_builtins.property
    @pulumi.getter(name="diskEncryptions")
    def disk_encryptions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PoolDiskEncryptionArgs']]]]:
        """
        A `disk_encryption` block, as defined below, describes the disk encryption configuration applied on compute nodes in the pool. Disk encryption configuration is not supported on Linux pool created with Virtual Machine Image or Shared Image Gallery Image.
        """
        return pulumi.get(self, "disk_encryptions")

    @disk_encryptions.setter
    def disk_encryptions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PoolDiskEncryptionArgs']]]]):
        pulumi.set(self, "disk_encryptions", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the display name of the Batch pool. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter
    def extensions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PoolExtensionArgs']]]]:
        """
        An `extensions` block as defined below.
        """
        return pulumi.get(self, "extensions")

    @extensions.setter
    def extensions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PoolExtensionArgs']]]]):
        pulumi.set(self, "extensions", value)

    @_builtins.property
    @pulumi.getter(name="fixedScale")
    def fixed_scale(self) -> Optional[pulumi.Input['PoolFixedScaleArgs']]:
        """
        A `fixed_scale` block that describes the scale settings when using fixed scale as defined below.
        """
        return pulumi.get(self, "fixed_scale")

    @fixed_scale.setter
    def fixed_scale(self, value: Optional[pulumi.Input['PoolFixedScaleArgs']]):
        pulumi.set(self, "fixed_scale", value)

    @_builtins.property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['PoolIdentityArgs']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['PoolIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @_builtins.property
    @pulumi.getter(name="interNodeCommunication")
    def inter_node_communication(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether the pool permits direct communication between nodes. This imposes restrictions on which nodes can be assigned to the pool. Enabling this value can reduce the chance of the requested number of nodes to be allocated in the pool. Values allowed are `Disabled` and `Enabled`. Defaults to `Enabled`.
        """
        return pulumi.get(self, "inter_node_communication")

    @inter_node_communication.setter
    def inter_node_communication(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "inter_node_communication", value)

    @_builtins.property
    @pulumi.getter(name="licenseType")
    def license_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of on-premises license to be used when deploying the operating system. This only applies to images that contain the Windows operating system, and should only be used when you hold valid on-premises licenses for the nodes which will be deployed. If omitted, no on-premises licensing discount is applied. Values are: "Windows_Server" - The on-premises license is for Windows Server. "Windows_Client" - The on-premises license is for Windows Client.
        """
        return pulumi.get(self, "license_type")

    @license_type.setter
    def license_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "license_type", value)

    @_builtins.property
    @pulumi.getter(name="maxTasksPerNode")
    def max_tasks_per_node(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the maximum number of tasks that can run concurrently on a single compute node in the pool. Defaults to `1`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "max_tasks_per_node")

    @max_tasks_per_node.setter
    def max_tasks_per_node(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_tasks_per_node", value)

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of custom batch pool metadata.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "metadata", value)

    @_builtins.property
    @pulumi.getter
    def mounts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PoolMountArgs']]]]:
        """
        A `mount` block defined as below.
        """
        return pulumi.get(self, "mounts")

    @mounts.setter
    def mounts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PoolMountArgs']]]]):
        pulumi.set(self, "mounts", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the Batch pool. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="networkConfiguration")
    def network_configuration(self) -> Optional[pulumi.Input['PoolNetworkConfigurationArgs']]:
        """
        A `network_configuration` block that describes the network configurations for the Batch pool as defined below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "network_configuration")

    @network_configuration.setter
    def network_configuration(self, value: Optional[pulumi.Input['PoolNetworkConfigurationArgs']]):
        pulumi.set(self, "network_configuration", value)

    @_builtins.property
    @pulumi.getter(name="nodeAgentSkuId")
    def node_agent_sku_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the SKU of the node agents that will be created in the Batch pool. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "node_agent_sku_id")

    @node_agent_sku_id.setter
    def node_agent_sku_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "node_agent_sku_id", value)

    @_builtins.property
    @pulumi.getter(name="nodePlacements")
    def node_placements(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PoolNodePlacementArgs']]]]:
        """
        A `node_placement` block that describes the placement policy for allocating nodes in the pool as defined below.
        """
        return pulumi.get(self, "node_placements")

    @node_placements.setter
    def node_placements(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PoolNodePlacementArgs']]]]):
        pulumi.set(self, "node_placements", value)

    @_builtins.property
    @pulumi.getter(name="osDiskPlacement")
    def os_disk_placement(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ephemeral disk placement for operating system disk for all VMs in the pool. This property can be used by user in the request to choose which location the operating system should be in. e.g., cache disk space for Ephemeral OS disk provisioning. For more information on Ephemeral OS disk size requirements, please refer to Ephemeral OS disk size requirements for Windows VMs at <https://docs.microsoft.com/en-us/azure/virtual-machines/windows/ephemeral-os-disks#size-requirements> and Linux VMs at <https://docs.microsoft.com/en-us/azure/virtual-machines/linux/ephemeral-os-disks#size-requirements>. The only possible value is `CacheDisk`.
        """
        return pulumi.get(self, "os_disk_placement")

    @os_disk_placement.setter
    def os_disk_placement(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "os_disk_placement", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the resource group in which to create the Batch pool. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="securityProfile")
    def security_profile(self) -> Optional[pulumi.Input['PoolSecurityProfileArgs']]:
        """
        A `security_profile` block that describes the security settings for the Batch pool as defined below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "security_profile")

    @security_profile.setter
    def security_profile(self, value: Optional[pulumi.Input['PoolSecurityProfileArgs']]):
        pulumi.set(self, "security_profile", value)

    @_builtins.property
    @pulumi.getter(name="startTask")
    def start_task(self) -> Optional[pulumi.Input['PoolStartTaskArgs']]:
        """
        A `start_task` block that describes the start task settings for the Batch pool as defined below.
        """
        return pulumi.get(self, "start_task")

    @start_task.setter
    def start_task(self, value: Optional[pulumi.Input['PoolStartTaskArgs']]):
        pulumi.set(self, "start_task", value)

    @_builtins.property
    @pulumi.getter(name="stopPendingResizeOperation")
    def stop_pending_resize_operation(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to stop if there is a pending resize operation on this pool.
        """
        return pulumi.get(self, "stop_pending_resize_operation")

    @stop_pending_resize_operation.setter
    def stop_pending_resize_operation(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "stop_pending_resize_operation", value)

    @_builtins.property
    @pulumi.getter(name="storageImageReference")
    def storage_image_reference(self) -> Optional[pulumi.Input['PoolStorageImageReferenceArgs']]:
        """
        A `storage_image_reference` block for the virtual machines that will compose the Batch pool as defined below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "storage_image_reference")

    @storage_image_reference.setter
    def storage_image_reference(self, value: Optional[pulumi.Input['PoolStorageImageReferenceArgs']]):
        pulumi.set(self, "storage_image_reference", value)

    @_builtins.property
    @pulumi.getter(name="targetNodeCommunicationMode")
    def target_node_communication_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The desired node communication mode for the pool. Possible values are `Classic`, `Default` and `Simplified`.
        """
        return pulumi.get(self, "target_node_communication_mode")

    @target_node_communication_mode.setter
    def target_node_communication_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target_node_communication_mode", value)

    @_builtins.property
    @pulumi.getter(name="taskSchedulingPolicies")
    def task_scheduling_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PoolTaskSchedulingPolicyArgs']]]]:
        """
        A `task_scheduling_policy` block that describes how tasks are distributed across compute nodes in a pool as defined below. If not specified, the default is spread as defined below.
        """
        return pulumi.get(self, "task_scheduling_policies")

    @task_scheduling_policies.setter
    def task_scheduling_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PoolTaskSchedulingPolicyArgs']]]]):
        pulumi.set(self, "task_scheduling_policies", value)

    @_builtins.property
    @pulumi.getter(name="userAccounts")
    def user_accounts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PoolUserAccountArgs']]]]:
        """
        A `user_accounts` block that describes the list of user accounts to be created on each node in the pool as defined below.
        """
        return pulumi.get(self, "user_accounts")

    @user_accounts.setter
    def user_accounts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PoolUserAccountArgs']]]]):
        pulumi.set(self, "user_accounts", value)

    @_builtins.property
    @pulumi.getter(name="vmSize")
    def vm_size(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the size of the VM created in the Batch pool. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "vm_size")

    @vm_size.setter
    def vm_size(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vm_size", value)

    @_builtins.property
    @pulumi.getter
    def windows(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PoolWindowArgs']]]]:
        """
        A `windows` block that describes the Windows configuration in the pool as defined below.

        > **Note:** For Windows compute nodes, the Batch service installs the certificates to the specified certificate store and location. For Linux compute nodes, the certificates are stored in a directory inside the task working directory and an environment variable `AZ_BATCH_CERTIFICATES_DIR` is supplied to the task to query for this location. For certificates with visibility of `remoteUser`, a `certs` directory is created in the user's home directory (e.g., `/home/{user-name}/certs`) and certificates are placed in that directory.

        > **Note:** `fixed_scale` and `auto_scale` blocks cannot be used both at the same time.
        """
        return pulumi.get(self, "windows")

    @windows.setter
    def windows(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PoolWindowArgs']]]]):
        pulumi.set(self, "windows", value)


@pulumi.type_token("azure:batch/pool:Pool")
class Pool(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_name: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_scale: Optional[pulumi.Input[Union['PoolAutoScaleArgs', 'PoolAutoScaleArgsDict']]] = None,
                 certificates: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PoolCertificateArgs', 'PoolCertificateArgsDict']]]]] = None,
                 container_configuration: Optional[pulumi.Input[Union['PoolContainerConfigurationArgs', 'PoolContainerConfigurationArgsDict']]] = None,
                 data_disks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PoolDataDiskArgs', 'PoolDataDiskArgsDict']]]]] = None,
                 disk_encryptions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PoolDiskEncryptionArgs', 'PoolDiskEncryptionArgsDict']]]]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 extensions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PoolExtensionArgs', 'PoolExtensionArgsDict']]]]] = None,
                 fixed_scale: Optional[pulumi.Input[Union['PoolFixedScaleArgs', 'PoolFixedScaleArgsDict']]] = None,
                 identity: Optional[pulumi.Input[Union['PoolIdentityArgs', 'PoolIdentityArgsDict']]] = None,
                 inter_node_communication: Optional[pulumi.Input[_builtins.str]] = None,
                 license_type: Optional[pulumi.Input[_builtins.str]] = None,
                 max_tasks_per_node: Optional[pulumi.Input[_builtins.int]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 mounts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PoolMountArgs', 'PoolMountArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_configuration: Optional[pulumi.Input[Union['PoolNetworkConfigurationArgs', 'PoolNetworkConfigurationArgsDict']]] = None,
                 node_agent_sku_id: Optional[pulumi.Input[_builtins.str]] = None,
                 node_placements: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PoolNodePlacementArgs', 'PoolNodePlacementArgsDict']]]]] = None,
                 os_disk_placement: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 security_profile: Optional[pulumi.Input[Union['PoolSecurityProfileArgs', 'PoolSecurityProfileArgsDict']]] = None,
                 start_task: Optional[pulumi.Input[Union['PoolStartTaskArgs', 'PoolStartTaskArgsDict']]] = None,
                 stop_pending_resize_operation: Optional[pulumi.Input[_builtins.bool]] = None,
                 storage_image_reference: Optional[pulumi.Input[Union['PoolStorageImageReferenceArgs', 'PoolStorageImageReferenceArgsDict']]] = None,
                 target_node_communication_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 task_scheduling_policies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PoolTaskSchedulingPolicyArgs', 'PoolTaskSchedulingPolicyArgsDict']]]]] = None,
                 user_accounts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PoolUserAccountArgs', 'PoolUserAccountArgsDict']]]]] = None,
                 vm_size: Optional[pulumi.Input[_builtins.str]] = None,
                 windows: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PoolWindowArgs', 'PoolWindowArgsDict']]]]] = None,
                 __props__=None):
        """
        Manages an Azure Batch pool.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure
        import pulumi_std as std

        example = azure.core.ResourceGroup("example",
            name="testaccbatch",
            location="West Europe")
        example_account = azure.storage.Account("example",
            name="testaccsa",
            resource_group_name=example.name,
            location=example.location,
            account_tier="Standard",
            account_replication_type="LRS")
        example_account2 = azure.batch.Account("example",
            name="testaccbatch",
            resource_group_name=example.name,
            location=example.location,
            pool_allocation_mode="BatchService",
            storage_account_id=example_account.id,
            storage_account_authentication_mode="StorageKeys",
            tags={
                "env": "test",
            })
        example_certificate = azure.batch.Certificate("example",
            resource_group_name=example.name,
            account_name=example_account2.name,
            certificate=std.filebase64(input="certificate.cer").result,
            format="Cer",
            thumbprint="312d31a79fa0cef49c00f769afc2b73e9f4edf34",
            thumbprint_algorithm="SHA1")
        example_pool = azure.batch.Pool("example",
            name="testaccpool",
            resource_group_name=example.name,
            account_name=example_account2.name,
            display_name="Test Acc Pool Auto",
            vm_size="STANDARD_A1_V2",
            node_agent_sku_id="batch.node.ubuntu 20.04",
            auto_scale={
                "evaluation_interval": "PT15M",
                "formula": \"\"\"      startingNumberOfVMs = 1;
              maxNumberofVMs = 25;
              pendingTaskSamplePercent = $PendingTasks.GetSamplePercent(180 * TimeInterval_Second);
              pendingTaskSamples = pendingTaskSamplePercent < 70 ? startingNumberOfVMs : avg($PendingTasks.GetSample(180 *   TimeInterval_Second));
              $TargetDedicatedNodes=min(maxNumberofVMs, pendingTaskSamples);
        \"\"\",
            },
            storage_image_reference={
                "publisher": "microsoft-azure-batch",
                "offer": "ubuntu-server-container",
                "sku": "20-04-lts",
                "version": "latest",
            },
            container_configuration={
                "type": "DockerCompatible",
                "container_registries": [{
                    "registry_server": "docker.io",
                    "user_name": "login",
                    "password": "apassword",
                }],
            },
            start_task={
                "command_line": "echo 'Hello World from $env'",
                "task_retry_maximum": 1,
                "wait_for_success": True,
                "common_environment_properties": {
                    "env": "TEST",
                },
                "user_identity": {
                    "auto_user": {
                        "elevation_level": "NonAdmin",
                        "scope": "Task",
                    },
                },
            },
            certificates=[{
                "id": example_certificate.id,
                "store_location": "CurrentUser",
                "visibilities": ["StartTask"],
            }])
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Batch` - 2024-07-01

        ## Import

        Batch Pools can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:batch/pool:Pool example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myGroup1/providers/Microsoft.Batch/batchAccounts/myBatchAccount1/pools/myBatchPool1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_name: Specifies the name of the Batch account in which the pool will be created. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['PoolAutoScaleArgs', 'PoolAutoScaleArgsDict']] auto_scale: A `auto_scale` block that describes the scale settings when using auto scale as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['PoolCertificateArgs', 'PoolCertificateArgsDict']]]] certificates: One or more `certificate` blocks that describe the certificates to be installed on each compute node in the pool as defined below.
        :param pulumi.Input[Union['PoolContainerConfigurationArgs', 'PoolContainerConfigurationArgsDict']] container_configuration: The container configuration used in the pool's VMs. One `container_configuration` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['PoolDataDiskArgs', 'PoolDataDiskArgsDict']]]] data_disks: A `data_disks` block describes the data disk settings as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['PoolDiskEncryptionArgs', 'PoolDiskEncryptionArgsDict']]]] disk_encryptions: A `disk_encryption` block, as defined below, describes the disk encryption configuration applied on compute nodes in the pool. Disk encryption configuration is not supported on Linux pool created with Virtual Machine Image or Shared Image Gallery Image.
        :param pulumi.Input[_builtins.str] display_name: Specifies the display name of the Batch pool. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[Union['PoolExtensionArgs', 'PoolExtensionArgsDict']]]] extensions: An `extensions` block as defined below.
        :param pulumi.Input[Union['PoolFixedScaleArgs', 'PoolFixedScaleArgsDict']] fixed_scale: A `fixed_scale` block that describes the scale settings when using fixed scale as defined below.
        :param pulumi.Input[Union['PoolIdentityArgs', 'PoolIdentityArgsDict']] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.str] inter_node_communication: Whether the pool permits direct communication between nodes. This imposes restrictions on which nodes can be assigned to the pool. Enabling this value can reduce the chance of the requested number of nodes to be allocated in the pool. Values allowed are `Disabled` and `Enabled`. Defaults to `Enabled`.
        :param pulumi.Input[_builtins.str] license_type: The type of on-premises license to be used when deploying the operating system. This only applies to images that contain the Windows operating system, and should only be used when you hold valid on-premises licenses for the nodes which will be deployed. If omitted, no on-premises licensing discount is applied. Values are: "Windows_Server" - The on-premises license is for Windows Server. "Windows_Client" - The on-premises license is for Windows Client.
        :param pulumi.Input[_builtins.int] max_tasks_per_node: Specifies the maximum number of tasks that can run concurrently on a single compute node in the pool. Defaults to `1`. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] metadata: A map of custom batch pool metadata.
        :param pulumi.Input[Sequence[pulumi.Input[Union['PoolMountArgs', 'PoolMountArgsDict']]]] mounts: A `mount` block defined as below.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Batch pool. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['PoolNetworkConfigurationArgs', 'PoolNetworkConfigurationArgsDict']] network_configuration: A `network_configuration` block that describes the network configurations for the Batch pool as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] node_agent_sku_id: Specifies the SKU of the node agents that will be created in the Batch pool. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[Union['PoolNodePlacementArgs', 'PoolNodePlacementArgsDict']]]] node_placements: A `node_placement` block that describes the placement policy for allocating nodes in the pool as defined below.
        :param pulumi.Input[_builtins.str] os_disk_placement: Specifies the ephemeral disk placement for operating system disk for all VMs in the pool. This property can be used by user in the request to choose which location the operating system should be in. e.g., cache disk space for Ephemeral OS disk provisioning. For more information on Ephemeral OS disk size requirements, please refer to Ephemeral OS disk size requirements for Windows VMs at <https://docs.microsoft.com/en-us/azure/virtual-machines/windows/ephemeral-os-disks#size-requirements> and Linux VMs at <https://docs.microsoft.com/en-us/azure/virtual-machines/linux/ephemeral-os-disks#size-requirements>. The only possible value is `CacheDisk`.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which to create the Batch pool. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['PoolSecurityProfileArgs', 'PoolSecurityProfileArgsDict']] security_profile: A `security_profile` block that describes the security settings for the Batch pool as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['PoolStartTaskArgs', 'PoolStartTaskArgsDict']] start_task: A `start_task` block that describes the start task settings for the Batch pool as defined below.
        :param pulumi.Input[_builtins.bool] stop_pending_resize_operation: Whether to stop if there is a pending resize operation on this pool.
        :param pulumi.Input[Union['PoolStorageImageReferenceArgs', 'PoolStorageImageReferenceArgsDict']] storage_image_reference: A `storage_image_reference` block for the virtual machines that will compose the Batch pool as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] target_node_communication_mode: The desired node communication mode for the pool. Possible values are `Classic`, `Default` and `Simplified`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['PoolTaskSchedulingPolicyArgs', 'PoolTaskSchedulingPolicyArgsDict']]]] task_scheduling_policies: A `task_scheduling_policy` block that describes how tasks are distributed across compute nodes in a pool as defined below. If not specified, the default is spread as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['PoolUserAccountArgs', 'PoolUserAccountArgsDict']]]] user_accounts: A `user_accounts` block that describes the list of user accounts to be created on each node in the pool as defined below.
        :param pulumi.Input[_builtins.str] vm_size: Specifies the size of the VM created in the Batch pool. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[Union['PoolWindowArgs', 'PoolWindowArgsDict']]]] windows: A `windows` block that describes the Windows configuration in the pool as defined below.
               
               > **Note:** For Windows compute nodes, the Batch service installs the certificates to the specified certificate store and location. For Linux compute nodes, the certificates are stored in a directory inside the task working directory and an environment variable `AZ_BATCH_CERTIFICATES_DIR` is supplied to the task to query for this location. For certificates with visibility of `remoteUser`, a `certs` directory is created in the user's home directory (e.g., `/home/{user-name}/certs`) and certificates are placed in that directory.
               
               > **Note:** `fixed_scale` and `auto_scale` blocks cannot be used both at the same time.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PoolArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an Azure Batch pool.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure
        import pulumi_std as std

        example = azure.core.ResourceGroup("example",
            name="testaccbatch",
            location="West Europe")
        example_account = azure.storage.Account("example",
            name="testaccsa",
            resource_group_name=example.name,
            location=example.location,
            account_tier="Standard",
            account_replication_type="LRS")
        example_account2 = azure.batch.Account("example",
            name="testaccbatch",
            resource_group_name=example.name,
            location=example.location,
            pool_allocation_mode="BatchService",
            storage_account_id=example_account.id,
            storage_account_authentication_mode="StorageKeys",
            tags={
                "env": "test",
            })
        example_certificate = azure.batch.Certificate("example",
            resource_group_name=example.name,
            account_name=example_account2.name,
            certificate=std.filebase64(input="certificate.cer").result,
            format="Cer",
            thumbprint="312d31a79fa0cef49c00f769afc2b73e9f4edf34",
            thumbprint_algorithm="SHA1")
        example_pool = azure.batch.Pool("example",
            name="testaccpool",
            resource_group_name=example.name,
            account_name=example_account2.name,
            display_name="Test Acc Pool Auto",
            vm_size="STANDARD_A1_V2",
            node_agent_sku_id="batch.node.ubuntu 20.04",
            auto_scale={
                "evaluation_interval": "PT15M",
                "formula": \"\"\"      startingNumberOfVMs = 1;
              maxNumberofVMs = 25;
              pendingTaskSamplePercent = $PendingTasks.GetSamplePercent(180 * TimeInterval_Second);
              pendingTaskSamples = pendingTaskSamplePercent < 70 ? startingNumberOfVMs : avg($PendingTasks.GetSample(180 *   TimeInterval_Second));
              $TargetDedicatedNodes=min(maxNumberofVMs, pendingTaskSamples);
        \"\"\",
            },
            storage_image_reference={
                "publisher": "microsoft-azure-batch",
                "offer": "ubuntu-server-container",
                "sku": "20-04-lts",
                "version": "latest",
            },
            container_configuration={
                "type": "DockerCompatible",
                "container_registries": [{
                    "registry_server": "docker.io",
                    "user_name": "login",
                    "password": "apassword",
                }],
            },
            start_task={
                "command_line": "echo 'Hello World from $env'",
                "task_retry_maximum": 1,
                "wait_for_success": True,
                "common_environment_properties": {
                    "env": "TEST",
                },
                "user_identity": {
                    "auto_user": {
                        "elevation_level": "NonAdmin",
                        "scope": "Task",
                    },
                },
            },
            certificates=[{
                "id": example_certificate.id,
                "store_location": "CurrentUser",
                "visibilities": ["StartTask"],
            }])
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Batch` - 2024-07-01

        ## Import

        Batch Pools can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:batch/pool:Pool example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myGroup1/providers/Microsoft.Batch/batchAccounts/myBatchAccount1/pools/myBatchPool1
        ```

        :param str resource_name: The name of the resource.
        :param PoolArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PoolArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_name: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_scale: Optional[pulumi.Input[Union['PoolAutoScaleArgs', 'PoolAutoScaleArgsDict']]] = None,
                 certificates: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PoolCertificateArgs', 'PoolCertificateArgsDict']]]]] = None,
                 container_configuration: Optional[pulumi.Input[Union['PoolContainerConfigurationArgs', 'PoolContainerConfigurationArgsDict']]] = None,
                 data_disks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PoolDataDiskArgs', 'PoolDataDiskArgsDict']]]]] = None,
                 disk_encryptions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PoolDiskEncryptionArgs', 'PoolDiskEncryptionArgsDict']]]]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 extensions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PoolExtensionArgs', 'PoolExtensionArgsDict']]]]] = None,
                 fixed_scale: Optional[pulumi.Input[Union['PoolFixedScaleArgs', 'PoolFixedScaleArgsDict']]] = None,
                 identity: Optional[pulumi.Input[Union['PoolIdentityArgs', 'PoolIdentityArgsDict']]] = None,
                 inter_node_communication: Optional[pulumi.Input[_builtins.str]] = None,
                 license_type: Optional[pulumi.Input[_builtins.str]] = None,
                 max_tasks_per_node: Optional[pulumi.Input[_builtins.int]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 mounts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PoolMountArgs', 'PoolMountArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_configuration: Optional[pulumi.Input[Union['PoolNetworkConfigurationArgs', 'PoolNetworkConfigurationArgsDict']]] = None,
                 node_agent_sku_id: Optional[pulumi.Input[_builtins.str]] = None,
                 node_placements: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PoolNodePlacementArgs', 'PoolNodePlacementArgsDict']]]]] = None,
                 os_disk_placement: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 security_profile: Optional[pulumi.Input[Union['PoolSecurityProfileArgs', 'PoolSecurityProfileArgsDict']]] = None,
                 start_task: Optional[pulumi.Input[Union['PoolStartTaskArgs', 'PoolStartTaskArgsDict']]] = None,
                 stop_pending_resize_operation: Optional[pulumi.Input[_builtins.bool]] = None,
                 storage_image_reference: Optional[pulumi.Input[Union['PoolStorageImageReferenceArgs', 'PoolStorageImageReferenceArgsDict']]] = None,
                 target_node_communication_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 task_scheduling_policies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PoolTaskSchedulingPolicyArgs', 'PoolTaskSchedulingPolicyArgsDict']]]]] = None,
                 user_accounts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PoolUserAccountArgs', 'PoolUserAccountArgsDict']]]]] = None,
                 vm_size: Optional[pulumi.Input[_builtins.str]] = None,
                 windows: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PoolWindowArgs', 'PoolWindowArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PoolArgs.__new__(PoolArgs)

            if account_name is None and not opts.urn:
                raise TypeError("Missing required property 'account_name'")
            __props__.__dict__["account_name"] = account_name
            __props__.__dict__["auto_scale"] = auto_scale
            __props__.__dict__["certificates"] = certificates
            __props__.__dict__["container_configuration"] = container_configuration
            __props__.__dict__["data_disks"] = data_disks
            __props__.__dict__["disk_encryptions"] = disk_encryptions
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["extensions"] = extensions
            __props__.__dict__["fixed_scale"] = fixed_scale
            __props__.__dict__["identity"] = identity
            __props__.__dict__["inter_node_communication"] = inter_node_communication
            __props__.__dict__["license_type"] = license_type
            __props__.__dict__["max_tasks_per_node"] = max_tasks_per_node
            __props__.__dict__["metadata"] = metadata
            __props__.__dict__["mounts"] = mounts
            __props__.__dict__["name"] = name
            __props__.__dict__["network_configuration"] = network_configuration
            if node_agent_sku_id is None and not opts.urn:
                raise TypeError("Missing required property 'node_agent_sku_id'")
            __props__.__dict__["node_agent_sku_id"] = node_agent_sku_id
            __props__.__dict__["node_placements"] = node_placements
            __props__.__dict__["os_disk_placement"] = os_disk_placement
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["security_profile"] = security_profile
            __props__.__dict__["start_task"] = start_task
            __props__.__dict__["stop_pending_resize_operation"] = stop_pending_resize_operation
            if storage_image_reference is None and not opts.urn:
                raise TypeError("Missing required property 'storage_image_reference'")
            __props__.__dict__["storage_image_reference"] = storage_image_reference
            __props__.__dict__["target_node_communication_mode"] = target_node_communication_mode
            __props__.__dict__["task_scheduling_policies"] = task_scheduling_policies
            __props__.__dict__["user_accounts"] = user_accounts
            if vm_size is None and not opts.urn:
                raise TypeError("Missing required property 'vm_size'")
            __props__.__dict__["vm_size"] = vm_size
            __props__.__dict__["windows"] = windows
        super(Pool, __self__).__init__(
            'azure:batch/pool:Pool',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_name: Optional[pulumi.Input[_builtins.str]] = None,
            auto_scale: Optional[pulumi.Input[Union['PoolAutoScaleArgs', 'PoolAutoScaleArgsDict']]] = None,
            certificates: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PoolCertificateArgs', 'PoolCertificateArgsDict']]]]] = None,
            container_configuration: Optional[pulumi.Input[Union['PoolContainerConfigurationArgs', 'PoolContainerConfigurationArgsDict']]] = None,
            data_disks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PoolDataDiskArgs', 'PoolDataDiskArgsDict']]]]] = None,
            disk_encryptions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PoolDiskEncryptionArgs', 'PoolDiskEncryptionArgsDict']]]]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            extensions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PoolExtensionArgs', 'PoolExtensionArgsDict']]]]] = None,
            fixed_scale: Optional[pulumi.Input[Union['PoolFixedScaleArgs', 'PoolFixedScaleArgsDict']]] = None,
            identity: Optional[pulumi.Input[Union['PoolIdentityArgs', 'PoolIdentityArgsDict']]] = None,
            inter_node_communication: Optional[pulumi.Input[_builtins.str]] = None,
            license_type: Optional[pulumi.Input[_builtins.str]] = None,
            max_tasks_per_node: Optional[pulumi.Input[_builtins.int]] = None,
            metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            mounts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PoolMountArgs', 'PoolMountArgsDict']]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            network_configuration: Optional[pulumi.Input[Union['PoolNetworkConfigurationArgs', 'PoolNetworkConfigurationArgsDict']]] = None,
            node_agent_sku_id: Optional[pulumi.Input[_builtins.str]] = None,
            node_placements: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PoolNodePlacementArgs', 'PoolNodePlacementArgsDict']]]]] = None,
            os_disk_placement: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            security_profile: Optional[pulumi.Input[Union['PoolSecurityProfileArgs', 'PoolSecurityProfileArgsDict']]] = None,
            start_task: Optional[pulumi.Input[Union['PoolStartTaskArgs', 'PoolStartTaskArgsDict']]] = None,
            stop_pending_resize_operation: Optional[pulumi.Input[_builtins.bool]] = None,
            storage_image_reference: Optional[pulumi.Input[Union['PoolStorageImageReferenceArgs', 'PoolStorageImageReferenceArgsDict']]] = None,
            target_node_communication_mode: Optional[pulumi.Input[_builtins.str]] = None,
            task_scheduling_policies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PoolTaskSchedulingPolicyArgs', 'PoolTaskSchedulingPolicyArgsDict']]]]] = None,
            user_accounts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PoolUserAccountArgs', 'PoolUserAccountArgsDict']]]]] = None,
            vm_size: Optional[pulumi.Input[_builtins.str]] = None,
            windows: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PoolWindowArgs', 'PoolWindowArgsDict']]]]] = None) -> 'Pool':
        """
        Get an existing Pool resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_name: Specifies the name of the Batch account in which the pool will be created. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['PoolAutoScaleArgs', 'PoolAutoScaleArgsDict']] auto_scale: A `auto_scale` block that describes the scale settings when using auto scale as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['PoolCertificateArgs', 'PoolCertificateArgsDict']]]] certificates: One or more `certificate` blocks that describe the certificates to be installed on each compute node in the pool as defined below.
        :param pulumi.Input[Union['PoolContainerConfigurationArgs', 'PoolContainerConfigurationArgsDict']] container_configuration: The container configuration used in the pool's VMs. One `container_configuration` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['PoolDataDiskArgs', 'PoolDataDiskArgsDict']]]] data_disks: A `data_disks` block describes the data disk settings as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['PoolDiskEncryptionArgs', 'PoolDiskEncryptionArgsDict']]]] disk_encryptions: A `disk_encryption` block, as defined below, describes the disk encryption configuration applied on compute nodes in the pool. Disk encryption configuration is not supported on Linux pool created with Virtual Machine Image or Shared Image Gallery Image.
        :param pulumi.Input[_builtins.str] display_name: Specifies the display name of the Batch pool. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[Union['PoolExtensionArgs', 'PoolExtensionArgsDict']]]] extensions: An `extensions` block as defined below.
        :param pulumi.Input[Union['PoolFixedScaleArgs', 'PoolFixedScaleArgsDict']] fixed_scale: A `fixed_scale` block that describes the scale settings when using fixed scale as defined below.
        :param pulumi.Input[Union['PoolIdentityArgs', 'PoolIdentityArgsDict']] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.str] inter_node_communication: Whether the pool permits direct communication between nodes. This imposes restrictions on which nodes can be assigned to the pool. Enabling this value can reduce the chance of the requested number of nodes to be allocated in the pool. Values allowed are `Disabled` and `Enabled`. Defaults to `Enabled`.
        :param pulumi.Input[_builtins.str] license_type: The type of on-premises license to be used when deploying the operating system. This only applies to images that contain the Windows operating system, and should only be used when you hold valid on-premises licenses for the nodes which will be deployed. If omitted, no on-premises licensing discount is applied. Values are: "Windows_Server" - The on-premises license is for Windows Server. "Windows_Client" - The on-premises license is for Windows Client.
        :param pulumi.Input[_builtins.int] max_tasks_per_node: Specifies the maximum number of tasks that can run concurrently on a single compute node in the pool. Defaults to `1`. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] metadata: A map of custom batch pool metadata.
        :param pulumi.Input[Sequence[pulumi.Input[Union['PoolMountArgs', 'PoolMountArgsDict']]]] mounts: A `mount` block defined as below.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Batch pool. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['PoolNetworkConfigurationArgs', 'PoolNetworkConfigurationArgsDict']] network_configuration: A `network_configuration` block that describes the network configurations for the Batch pool as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] node_agent_sku_id: Specifies the SKU of the node agents that will be created in the Batch pool. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[Union['PoolNodePlacementArgs', 'PoolNodePlacementArgsDict']]]] node_placements: A `node_placement` block that describes the placement policy for allocating nodes in the pool as defined below.
        :param pulumi.Input[_builtins.str] os_disk_placement: Specifies the ephemeral disk placement for operating system disk for all VMs in the pool. This property can be used by user in the request to choose which location the operating system should be in. e.g., cache disk space for Ephemeral OS disk provisioning. For more information on Ephemeral OS disk size requirements, please refer to Ephemeral OS disk size requirements for Windows VMs at <https://docs.microsoft.com/en-us/azure/virtual-machines/windows/ephemeral-os-disks#size-requirements> and Linux VMs at <https://docs.microsoft.com/en-us/azure/virtual-machines/linux/ephemeral-os-disks#size-requirements>. The only possible value is `CacheDisk`.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which to create the Batch pool. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['PoolSecurityProfileArgs', 'PoolSecurityProfileArgsDict']] security_profile: A `security_profile` block that describes the security settings for the Batch pool as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['PoolStartTaskArgs', 'PoolStartTaskArgsDict']] start_task: A `start_task` block that describes the start task settings for the Batch pool as defined below.
        :param pulumi.Input[_builtins.bool] stop_pending_resize_operation: Whether to stop if there is a pending resize operation on this pool.
        :param pulumi.Input[Union['PoolStorageImageReferenceArgs', 'PoolStorageImageReferenceArgsDict']] storage_image_reference: A `storage_image_reference` block for the virtual machines that will compose the Batch pool as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] target_node_communication_mode: The desired node communication mode for the pool. Possible values are `Classic`, `Default` and `Simplified`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['PoolTaskSchedulingPolicyArgs', 'PoolTaskSchedulingPolicyArgsDict']]]] task_scheduling_policies: A `task_scheduling_policy` block that describes how tasks are distributed across compute nodes in a pool as defined below. If not specified, the default is spread as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['PoolUserAccountArgs', 'PoolUserAccountArgsDict']]]] user_accounts: A `user_accounts` block that describes the list of user accounts to be created on each node in the pool as defined below.
        :param pulumi.Input[_builtins.str] vm_size: Specifies the size of the VM created in the Batch pool. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[Union['PoolWindowArgs', 'PoolWindowArgsDict']]]] windows: A `windows` block that describes the Windows configuration in the pool as defined below.
               
               > **Note:** For Windows compute nodes, the Batch service installs the certificates to the specified certificate store and location. For Linux compute nodes, the certificates are stored in a directory inside the task working directory and an environment variable `AZ_BATCH_CERTIFICATES_DIR` is supplied to the task to query for this location. For certificates with visibility of `remoteUser`, a `certs` directory is created in the user's home directory (e.g., `/home/{user-name}/certs`) and certificates are placed in that directory.
               
               > **Note:** `fixed_scale` and `auto_scale` blocks cannot be used both at the same time.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PoolState.__new__(_PoolState)

        __props__.__dict__["account_name"] = account_name
        __props__.__dict__["auto_scale"] = auto_scale
        __props__.__dict__["certificates"] = certificates
        __props__.__dict__["container_configuration"] = container_configuration
        __props__.__dict__["data_disks"] = data_disks
        __props__.__dict__["disk_encryptions"] = disk_encryptions
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["extensions"] = extensions
        __props__.__dict__["fixed_scale"] = fixed_scale
        __props__.__dict__["identity"] = identity
        __props__.__dict__["inter_node_communication"] = inter_node_communication
        __props__.__dict__["license_type"] = license_type
        __props__.__dict__["max_tasks_per_node"] = max_tasks_per_node
        __props__.__dict__["metadata"] = metadata
        __props__.__dict__["mounts"] = mounts
        __props__.__dict__["name"] = name
        __props__.__dict__["network_configuration"] = network_configuration
        __props__.__dict__["node_agent_sku_id"] = node_agent_sku_id
        __props__.__dict__["node_placements"] = node_placements
        __props__.__dict__["os_disk_placement"] = os_disk_placement
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["security_profile"] = security_profile
        __props__.__dict__["start_task"] = start_task
        __props__.__dict__["stop_pending_resize_operation"] = stop_pending_resize_operation
        __props__.__dict__["storage_image_reference"] = storage_image_reference
        __props__.__dict__["target_node_communication_mode"] = target_node_communication_mode
        __props__.__dict__["task_scheduling_policies"] = task_scheduling_policies
        __props__.__dict__["user_accounts"] = user_accounts
        __props__.__dict__["vm_size"] = vm_size
        __props__.__dict__["windows"] = windows
        return Pool(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accountName")
    def account_name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of the Batch account in which the pool will be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "account_name")

    @_builtins.property
    @pulumi.getter(name="autoScale")
    def auto_scale(self) -> pulumi.Output[Optional['outputs.PoolAutoScale']]:
        """
        A `auto_scale` block that describes the scale settings when using auto scale as defined below.
        """
        return pulumi.get(self, "auto_scale")

    @_builtins.property
    @pulumi.getter
    def certificates(self) -> pulumi.Output[Optional[Sequence['outputs.PoolCertificate']]]:
        """
        One or more `certificate` blocks that describe the certificates to be installed on each compute node in the pool as defined below.
        """
        return pulumi.get(self, "certificates")

    @_builtins.property
    @pulumi.getter(name="containerConfiguration")
    def container_configuration(self) -> pulumi.Output[Optional['outputs.PoolContainerConfiguration']]:
        """
        The container configuration used in the pool's VMs. One `container_configuration` block as defined below.
        """
        return pulumi.get(self, "container_configuration")

    @_builtins.property
    @pulumi.getter(name="dataDisks")
    def data_disks(self) -> pulumi.Output[Optional[Sequence['outputs.PoolDataDisk']]]:
        """
        A `data_disks` block describes the data disk settings as defined below.
        """
        return pulumi.get(self, "data_disks")

    @_builtins.property
    @pulumi.getter(name="diskEncryptions")
    def disk_encryptions(self) -> pulumi.Output[Optional[Sequence['outputs.PoolDiskEncryption']]]:
        """
        A `disk_encryption` block, as defined below, describes the disk encryption configuration applied on compute nodes in the pool. Disk encryption configuration is not supported on Linux pool created with Virtual Machine Image or Shared Image Gallery Image.
        """
        return pulumi.get(self, "disk_encryptions")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the display name of the Batch pool. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def extensions(self) -> pulumi.Output[Optional[Sequence['outputs.PoolExtension']]]:
        """
        An `extensions` block as defined below.
        """
        return pulumi.get(self, "extensions")

    @_builtins.property
    @pulumi.getter(name="fixedScale")
    def fixed_scale(self) -> pulumi.Output[Optional['outputs.PoolFixedScale']]:
        """
        A `fixed_scale` block that describes the scale settings when using fixed scale as defined below.
        """
        return pulumi.get(self, "fixed_scale")

    @_builtins.property
    @pulumi.getter
    def identity(self) -> pulumi.Output[Optional['outputs.PoolIdentity']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @_builtins.property
    @pulumi.getter(name="interNodeCommunication")
    def inter_node_communication(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Whether the pool permits direct communication between nodes. This imposes restrictions on which nodes can be assigned to the pool. Enabling this value can reduce the chance of the requested number of nodes to be allocated in the pool. Values allowed are `Disabled` and `Enabled`. Defaults to `Enabled`.
        """
        return pulumi.get(self, "inter_node_communication")

    @_builtins.property
    @pulumi.getter(name="licenseType")
    def license_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The type of on-premises license to be used when deploying the operating system. This only applies to images that contain the Windows operating system, and should only be used when you hold valid on-premises licenses for the nodes which will be deployed. If omitted, no on-premises licensing discount is applied. Values are: "Windows_Server" - The on-premises license is for Windows Server. "Windows_Client" - The on-premises license is for Windows Client.
        """
        return pulumi.get(self, "license_type")

    @_builtins.property
    @pulumi.getter(name="maxTasksPerNode")
    def max_tasks_per_node(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Specifies the maximum number of tasks that can run concurrently on a single compute node in the pool. Defaults to `1`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "max_tasks_per_node")

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A map of custom batch pool metadata.
        """
        return pulumi.get(self, "metadata")

    @_builtins.property
    @pulumi.getter
    def mounts(self) -> pulumi.Output[Optional[Sequence['outputs.PoolMount']]]:
        """
        A `mount` block defined as below.
        """
        return pulumi.get(self, "mounts")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of the Batch pool. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="networkConfiguration")
    def network_configuration(self) -> pulumi.Output[Optional['outputs.PoolNetworkConfiguration']]:
        """
        A `network_configuration` block that describes the network configurations for the Batch pool as defined below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "network_configuration")

    @_builtins.property
    @pulumi.getter(name="nodeAgentSkuId")
    def node_agent_sku_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the SKU of the node agents that will be created in the Batch pool. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "node_agent_sku_id")

    @_builtins.property
    @pulumi.getter(name="nodePlacements")
    def node_placements(self) -> pulumi.Output[Optional[Sequence['outputs.PoolNodePlacement']]]:
        """
        A `node_placement` block that describes the placement policy for allocating nodes in the pool as defined below.
        """
        return pulumi.get(self, "node_placements")

    @_builtins.property
    @pulumi.getter(name="osDiskPlacement")
    def os_disk_placement(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the ephemeral disk placement for operating system disk for all VMs in the pool. This property can be used by user in the request to choose which location the operating system should be in. e.g., cache disk space for Ephemeral OS disk provisioning. For more information on Ephemeral OS disk size requirements, please refer to Ephemeral OS disk size requirements for Windows VMs at <https://docs.microsoft.com/en-us/azure/virtual-machines/windows/ephemeral-os-disks#size-requirements> and Linux VMs at <https://docs.microsoft.com/en-us/azure/virtual-machines/linux/ephemeral-os-disks#size-requirements>. The only possible value is `CacheDisk`.
        """
        return pulumi.get(self, "os_disk_placement")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the resource group in which to create the Batch pool. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter(name="securityProfile")
    def security_profile(self) -> pulumi.Output[Optional['outputs.PoolSecurityProfile']]:
        """
        A `security_profile` block that describes the security settings for the Batch pool as defined below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "security_profile")

    @_builtins.property
    @pulumi.getter(name="startTask")
    def start_task(self) -> pulumi.Output[Optional['outputs.PoolStartTask']]:
        """
        A `start_task` block that describes the start task settings for the Batch pool as defined below.
        """
        return pulumi.get(self, "start_task")

    @_builtins.property
    @pulumi.getter(name="stopPendingResizeOperation")
    def stop_pending_resize_operation(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to stop if there is a pending resize operation on this pool.
        """
        return pulumi.get(self, "stop_pending_resize_operation")

    @_builtins.property
    @pulumi.getter(name="storageImageReference")
    def storage_image_reference(self) -> pulumi.Output['outputs.PoolStorageImageReference']:
        """
        A `storage_image_reference` block for the virtual machines that will compose the Batch pool as defined below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "storage_image_reference")

    @_builtins.property
    @pulumi.getter(name="targetNodeCommunicationMode")
    def target_node_communication_mode(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The desired node communication mode for the pool. Possible values are `Classic`, `Default` and `Simplified`.
        """
        return pulumi.get(self, "target_node_communication_mode")

    @_builtins.property
    @pulumi.getter(name="taskSchedulingPolicies")
    def task_scheduling_policies(self) -> pulumi.Output[Sequence['outputs.PoolTaskSchedulingPolicy']]:
        """
        A `task_scheduling_policy` block that describes how tasks are distributed across compute nodes in a pool as defined below. If not specified, the default is spread as defined below.
        """
        return pulumi.get(self, "task_scheduling_policies")

    @_builtins.property
    @pulumi.getter(name="userAccounts")
    def user_accounts(self) -> pulumi.Output[Optional[Sequence['outputs.PoolUserAccount']]]:
        """
        A `user_accounts` block that describes the list of user accounts to be created on each node in the pool as defined below.
        """
        return pulumi.get(self, "user_accounts")

    @_builtins.property
    @pulumi.getter(name="vmSize")
    def vm_size(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the size of the VM created in the Batch pool. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "vm_size")

    @_builtins.property
    @pulumi.getter
    def windows(self) -> pulumi.Output[Optional[Sequence['outputs.PoolWindow']]]:
        """
        A `windows` block that describes the Windows configuration in the pool as defined below.

        > **Note:** For Windows compute nodes, the Batch service installs the certificates to the specified certificate store and location. For Linux compute nodes, the certificates are stored in a directory inside the task working directory and an environment variable `AZ_BATCH_CERTIFICATES_DIR` is supplied to the task to query for this location. For certificates with visibility of `remoteUser`, a `certs` directory is created in the user's home directory (e.g., `/home/{user-name}/certs`) and certificates are placed in that directory.

        > **Note:** `fixed_scale` and `auto_scale` blocks cannot be used both at the same time.
        """
        return pulumi.get(self, "windows")

