# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetPublishedVersionResult',
    'AwaitableGetPublishedVersionResult',
    'get_published_version',
    'get_published_version_output',
]

@pulumi.output_type
class GetPublishedVersionResult:
    """
    A collection of values returned by getPublishedVersion.
    """
    def __init__(__self__, blueprint_name=None, description=None, display_name=None, id=None, last_modified=None, scope_id=None, target_scope=None, time_created=None, type=None, version=None):
        if blueprint_name and not isinstance(blueprint_name, str):
            raise TypeError("Expected argument 'blueprint_name' to be a str")
        pulumi.set(__self__, "blueprint_name", blueprint_name)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if last_modified and not isinstance(last_modified, str):
            raise TypeError("Expected argument 'last_modified' to be a str")
        pulumi.set(__self__, "last_modified", last_modified)
        if scope_id and not isinstance(scope_id, str):
            raise TypeError("Expected argument 'scope_id' to be a str")
        pulumi.set(__self__, "scope_id", scope_id)
        if target_scope and not isinstance(target_scope, str):
            raise TypeError("Expected argument 'target_scope' to be a str")
        pulumi.set(__self__, "target_scope", target_scope)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if version and not isinstance(version, str):
            raise TypeError("Expected argument 'version' to be a str")
        pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter(name="blueprintName")
    def blueprint_name(self) -> _builtins.str:
        return pulumi.get(self, "blueprint_name")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description of the Blueprint Published Version
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        The display name of the Blueprint Published Version
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="lastModified")
    def last_modified(self) -> _builtins.str:
        return pulumi.get(self, "last_modified")

    @_builtins.property
    @pulumi.getter(name="scopeId")
    def scope_id(self) -> _builtins.str:
        return pulumi.get(self, "scope_id")

    @_builtins.property
    @pulumi.getter(name="targetScope")
    def target_scope(self) -> _builtins.str:
        """
        The target scope
        """
        return pulumi.get(self, "target_scope")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of the Blueprint
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def version(self) -> _builtins.str:
        return pulumi.get(self, "version")


class AwaitableGetPublishedVersionResult(GetPublishedVersionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPublishedVersionResult(
            blueprint_name=self.blueprint_name,
            description=self.description,
            display_name=self.display_name,
            id=self.id,
            last_modified=self.last_modified,
            scope_id=self.scope_id,
            target_scope=self.target_scope,
            time_created=self.time_created,
            type=self.type,
            version=self.version)


def get_published_version(blueprint_name: Optional[_builtins.str] = None,
                          scope_id: Optional[_builtins.str] = None,
                          version: Optional[_builtins.str] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPublishedVersionResult:
    """
    Use this data source to access information about an existing Blueprint Published Version

    > **Note:** Azure Blueprints are in Preview and potentially subject to breaking change without notice.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    current = azure.core.get_subscription()
    test = azure.blueprint.get_published_version(scope_id=current.id,
        blueprint_name="exampleBluePrint",
        version="dev_v2.3")
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.Blueprint` - 2018-11-01-preview


    :param _builtins.str blueprint_name: The name of the Blueprint Definition
    :param _builtins.str scope_id: The ID of the Management Group / Subscription where this Blueprint Definition is stored.
    :param _builtins.str version: The Version name of the Published Version of the Blueprint Definition
    """
    __args__ = dict()
    __args__['blueprintName'] = blueprint_name
    __args__['scopeId'] = scope_id
    __args__['version'] = version
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:blueprint/getPublishedVersion:getPublishedVersion', __args__, opts=opts, typ=GetPublishedVersionResult).value

    return AwaitableGetPublishedVersionResult(
        blueprint_name=pulumi.get(__ret__, 'blueprint_name'),
        description=pulumi.get(__ret__, 'description'),
        display_name=pulumi.get(__ret__, 'display_name'),
        id=pulumi.get(__ret__, 'id'),
        last_modified=pulumi.get(__ret__, 'last_modified'),
        scope_id=pulumi.get(__ret__, 'scope_id'),
        target_scope=pulumi.get(__ret__, 'target_scope'),
        time_created=pulumi.get(__ret__, 'time_created'),
        type=pulumi.get(__ret__, 'type'),
        version=pulumi.get(__ret__, 'version'))
def get_published_version_output(blueprint_name: Optional[pulumi.Input[_builtins.str]] = None,
                                 scope_id: Optional[pulumi.Input[_builtins.str]] = None,
                                 version: Optional[pulumi.Input[_builtins.str]] = None,
                                 opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetPublishedVersionResult]:
    """
    Use this data source to access information about an existing Blueprint Published Version

    > **Note:** Azure Blueprints are in Preview and potentially subject to breaking change without notice.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    current = azure.core.get_subscription()
    test = azure.blueprint.get_published_version(scope_id=current.id,
        blueprint_name="exampleBluePrint",
        version="dev_v2.3")
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.Blueprint` - 2018-11-01-preview


    :param _builtins.str blueprint_name: The name of the Blueprint Definition
    :param _builtins.str scope_id: The ID of the Management Group / Subscription where this Blueprint Definition is stored.
    :param _builtins.str version: The Version name of the Published Version of the Blueprint Definition
    """
    __args__ = dict()
    __args__['blueprintName'] = blueprint_name
    __args__['scopeId'] = scope_id
    __args__['version'] = version
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:blueprint/getPublishedVersion:getPublishedVersion', __args__, opts=opts, typ=GetPublishedVersionResult)
    return __ret__.apply(lambda __response__: GetPublishedVersionResult(
        blueprint_name=pulumi.get(__response__, 'blueprint_name'),
        description=pulumi.get(__response__, 'description'),
        display_name=pulumi.get(__response__, 'display_name'),
        id=pulumi.get(__response__, 'id'),
        last_modified=pulumi.get(__response__, 'last_modified'),
        scope_id=pulumi.get(__response__, 'scope_id'),
        target_scope=pulumi.get(__response__, 'target_scope'),
        time_created=pulumi.get(__response__, 'time_created'),
        type=pulumi.get(__response__, 'type'),
        version=pulumi.get(__response__, 'version')))
