# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'ExperimentIdentity',
    'ExperimentSelector',
    'ExperimentStep',
    'ExperimentStepBranch',
    'ExperimentStepBranchAction',
]

@pulumi.output_type
class ExperimentIdentity(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "identityIds":
            suggest = "identity_ids"
        elif key == "principalId":
            suggest = "principal_id"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ExperimentIdentity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ExperimentIdentity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ExperimentIdentity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: _builtins.str,
                 identity_ids: Optional[Sequence[_builtins.str]] = None,
                 principal_id: Optional[_builtins.str] = None,
                 tenant_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str type: The Type of Managed Identity which should be added to this Policy Definition. Possible values are `SystemAssigned` and `UserAssigned`.
        :param Sequence[_builtins.str] identity_ids: A list of User Managed Identity IDs which should be assigned to the Policy Definition.
               
               > **Note:** This is required when `type` is set to `UserAssigned`.
        :param _builtins.str principal_id: The Principal ID associated with this Managed Service Identity.
        :param _builtins.str tenant_id: The Tenant ID associated with this Managed Service Identity.
        """
        pulumi.set(__self__, "type", type)
        if identity_ids is not None:
            pulumi.set(__self__, "identity_ids", identity_ids)
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The Type of Managed Identity which should be added to this Policy Definition. Possible values are `SystemAssigned` and `UserAssigned`.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="identityIds")
    def identity_ids(self) -> Optional[Sequence[_builtins.str]]:
        """
        A list of User Managed Identity IDs which should be assigned to the Policy Definition.

        > **Note:** This is required when `type` is set to `UserAssigned`.
        """
        return pulumi.get(self, "identity_ids")

    @_builtins.property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[_builtins.str]:
        """
        The Principal ID associated with this Managed Service Identity.
        """
        return pulumi.get(self, "principal_id")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[_builtins.str]:
        """
        The Tenant ID associated with this Managed Service Identity.
        """
        return pulumi.get(self, "tenant_id")


@pulumi.output_type
class ExperimentSelector(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "chaosStudioTargetIds":
            suggest = "chaos_studio_target_ids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ExperimentSelector. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ExperimentSelector.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ExperimentSelector.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 chaos_studio_target_ids: Sequence[_builtins.str],
                 name: _builtins.str):
        """
        :param Sequence[_builtins.str] chaos_studio_target_ids: A list of Chaos Studio Target IDs that should be part of this Selector.
        :param _builtins.str name: The name of this Selector.
        """
        pulumi.set(__self__, "chaos_studio_target_ids", chaos_studio_target_ids)
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="chaosStudioTargetIds")
    def chaos_studio_target_ids(self) -> Sequence[_builtins.str]:
        """
        A list of Chaos Studio Target IDs that should be part of this Selector.
        """
        return pulumi.get(self, "chaos_studio_target_ids")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of this Selector.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class ExperimentStep(dict):
    def __init__(__self__, *,
                 branches: Sequence['outputs.ExperimentStepBranch'],
                 name: _builtins.str):
        """
        :param Sequence['ExperimentStepBranchArgs'] branches: One or more `branch` blocks as defined above.
        :param _builtins.str name: The name of the Step.
        """
        pulumi.set(__self__, "branches", branches)
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def branches(self) -> Sequence['outputs.ExperimentStepBranch']:
        """
        One or more `branch` blocks as defined above.
        """
        return pulumi.get(self, "branches")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the Step.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class ExperimentStepBranch(dict):
    def __init__(__self__, *,
                 actions: Sequence['outputs.ExperimentStepBranchAction'],
                 name: _builtins.str):
        """
        :param Sequence['ExperimentStepBranchActionArgs'] actions: One or more `actions` blocks as defined above.
        :param _builtins.str name: The name of the branch.
        """
        pulumi.set(__self__, "actions", actions)
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def actions(self) -> Sequence['outputs.ExperimentStepBranchAction']:
        """
        One or more `actions` blocks as defined above.
        """
        return pulumi.get(self, "actions")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the branch.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class ExperimentStepBranchAction(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "actionType":
            suggest = "action_type"
        elif key == "selectorName":
            suggest = "selector_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ExperimentStepBranchAction. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ExperimentStepBranchAction.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ExperimentStepBranchAction.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action_type: _builtins.str,
                 duration: Optional[_builtins.str] = None,
                 parameters: Optional[Mapping[str, _builtins.str]] = None,
                 selector_name: Optional[_builtins.str] = None,
                 urn: Optional[_builtins.str] = None):
        """
        :param _builtins.str action_type: The type of action that should be added to the experiment. Possible values are `continuous`, `delay` and `discrete`.
        :param _builtins.str duration: An ISO8601 formatted string specifying the duration for a `delay` or `continuous` action.
        :param Mapping[str, _builtins.str] parameters: A key-value map of additional parameters to configure the action. The values that are accepted by this depend on the `urn` i.e. the capability/fault that is applied. Possible parameter values can be found in this [documentation](https://learn.microsoft.com/azure/chaos-studio/chaos-studio-fault-library)
        :param _builtins.str selector_name: The name of the Selector to which this action should apply to. This must be specified if the `action_type` is `continuous` or `discrete`.
        :param _builtins.str urn: The Unique Resource Name of the action, this value is provided by the `chaosstudio.Capability` resource e.g. `azurerm_chaos_studio_capability.example.urn`. This must be specified if the `action_type` is `continuous` or `discrete`.
        """
        pulumi.set(__self__, "action_type", action_type)
        if duration is not None:
            pulumi.set(__self__, "duration", duration)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if selector_name is not None:
            pulumi.set(__self__, "selector_name", selector_name)
        if urn is not None:
            pulumi.set(__self__, "urn", urn)

    @_builtins.property
    @pulumi.getter(name="actionType")
    def action_type(self) -> _builtins.str:
        """
        The type of action that should be added to the experiment. Possible values are `continuous`, `delay` and `discrete`.
        """
        return pulumi.get(self, "action_type")

    @_builtins.property
    @pulumi.getter
    def duration(self) -> Optional[_builtins.str]:
        """
        An ISO8601 formatted string specifying the duration for a `delay` or `continuous` action.
        """
        return pulumi.get(self, "duration")

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        A key-value map of additional parameters to configure the action. The values that are accepted by this depend on the `urn` i.e. the capability/fault that is applied. Possible parameter values can be found in this [documentation](https://learn.microsoft.com/azure/chaos-studio/chaos-studio-fault-library)
        """
        return pulumi.get(self, "parameters")

    @_builtins.property
    @pulumi.getter(name="selectorName")
    def selector_name(self) -> Optional[_builtins.str]:
        """
        The name of the Selector to which this action should apply to. This must be specified if the `action_type` is `continuous` or `discrete`.
        """
        return pulumi.get(self, "selector_name")

    @_builtins.property
    @pulumi.getter
    def urn(self) -> Optional[_builtins.str]:
        """
        The Unique Resource Name of the action, this value is provided by the `chaosstudio.Capability` resource e.g. `azurerm_chaos_studio_capability.example.urn`. This must be specified if the `action_type` is `continuous` or `discrete`.
        """
        return pulumi.get(self, "urn")


