# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['EmailServiceDomainSenderUsernameArgs', 'EmailServiceDomainSenderUsername']

@pulumi.input_type
class EmailServiceDomainSenderUsernameArgs:
    def __init__(__self__, *,
                 email_service_domain_id: pulumi.Input[_builtins.str],
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a EmailServiceDomainSenderUsername resource.
        :param pulumi.Input[_builtins.str] email_service_domain_id: The ID of the Email Communication Service Domain resource. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] display_name: The display name for the Email Communication Service Domain Sender Username resource.
        :param pulumi.Input[_builtins.str] name: The name of the Email Communication Service Domain Sender Username resource. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "email_service_domain_id", email_service_domain_id)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="emailServiceDomainId")
    def email_service_domain_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Email Communication Service Domain resource. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "email_service_domain_id")

    @email_service_domain_id.setter
    def email_service_domain_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "email_service_domain_id", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The display name for the Email Communication Service Domain Sender Username resource.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Email Communication Service Domain Sender Username resource. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _EmailServiceDomainSenderUsernameState:
    def __init__(__self__, *,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 email_service_domain_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering EmailServiceDomainSenderUsername resources.
        :param pulumi.Input[_builtins.str] display_name: The display name for the Email Communication Service Domain Sender Username resource.
        :param pulumi.Input[_builtins.str] email_service_domain_id: The ID of the Email Communication Service Domain resource. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name of the Email Communication Service Domain Sender Username resource. Changing this forces a new resource to be created.
        """
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if email_service_domain_id is not None:
            pulumi.set(__self__, "email_service_domain_id", email_service_domain_id)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The display name for the Email Communication Service Domain Sender Username resource.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="emailServiceDomainId")
    def email_service_domain_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Email Communication Service Domain resource. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "email_service_domain_id")

    @email_service_domain_id.setter
    def email_service_domain_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "email_service_domain_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Email Communication Service Domain Sender Username resource. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.type_token("azure:communication/emailServiceDomainSenderUsername:EmailServiceDomainSenderUsername")
class EmailServiceDomainSenderUsername(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 email_service_domain_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages an Email Communication Service Domain Sender Username.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_email_service = azure.communication.EmailService("example",
            name="example-emailcommunicationservice",
            resource_group_name=example.name,
            data_location="United States")
        example_email_service_domain = azure.communication.EmailServiceDomain("example",
            name="AzureManagedDomain",
            email_service_id=example_email_service.id,
            domain_management="AzureManaged")
        example_email_service_domain_sender_username = azure.communication.EmailServiceDomainSenderUsername("example",
            name="example-su",
            email_service_domain_id=example_email_service_domain.id)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Communication` - 2023-03-31

        ## Import

        Communication Service Domain Sender Usernames can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:communication/emailServiceDomainSenderUsername:EmailServiceDomainSenderUsername example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.Communication/emailServices/service1/domains/domain1/senderUsernames/username1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] display_name: The display name for the Email Communication Service Domain Sender Username resource.
        :param pulumi.Input[_builtins.str] email_service_domain_id: The ID of the Email Communication Service Domain resource. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name of the Email Communication Service Domain Sender Username resource. Changing this forces a new resource to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EmailServiceDomainSenderUsernameArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an Email Communication Service Domain Sender Username.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_email_service = azure.communication.EmailService("example",
            name="example-emailcommunicationservice",
            resource_group_name=example.name,
            data_location="United States")
        example_email_service_domain = azure.communication.EmailServiceDomain("example",
            name="AzureManagedDomain",
            email_service_id=example_email_service.id,
            domain_management="AzureManaged")
        example_email_service_domain_sender_username = azure.communication.EmailServiceDomainSenderUsername("example",
            name="example-su",
            email_service_domain_id=example_email_service_domain.id)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Communication` - 2023-03-31

        ## Import

        Communication Service Domain Sender Usernames can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:communication/emailServiceDomainSenderUsername:EmailServiceDomainSenderUsername example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.Communication/emailServices/service1/domains/domain1/senderUsernames/username1
        ```

        :param str resource_name: The name of the resource.
        :param EmailServiceDomainSenderUsernameArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EmailServiceDomainSenderUsernameArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 email_service_domain_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EmailServiceDomainSenderUsernameArgs.__new__(EmailServiceDomainSenderUsernameArgs)

            __props__.__dict__["display_name"] = display_name
            if email_service_domain_id is None and not opts.urn:
                raise TypeError("Missing required property 'email_service_domain_id'")
            __props__.__dict__["email_service_domain_id"] = email_service_domain_id
            __props__.__dict__["name"] = name
        super(EmailServiceDomainSenderUsername, __self__).__init__(
            'azure:communication/emailServiceDomainSenderUsername:EmailServiceDomainSenderUsername',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            email_service_domain_id: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None) -> 'EmailServiceDomainSenderUsername':
        """
        Get an existing EmailServiceDomainSenderUsername resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] display_name: The display name for the Email Communication Service Domain Sender Username resource.
        :param pulumi.Input[_builtins.str] email_service_domain_id: The ID of the Email Communication Service Domain resource. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name of the Email Communication Service Domain Sender Username resource. Changing this forces a new resource to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EmailServiceDomainSenderUsernameState.__new__(_EmailServiceDomainSenderUsernameState)

        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["email_service_domain_id"] = email_service_domain_id
        __props__.__dict__["name"] = name
        return EmailServiceDomainSenderUsername(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The display name for the Email Communication Service Domain Sender Username resource.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="emailServiceDomainId")
    def email_service_domain_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Email Communication Service Domain resource. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "email_service_domain_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Email Communication Service Domain Sender Username resource. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

