# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetManagedDisksResult',
    'AwaitableGetManagedDisksResult',
    'get_managed_disks',
    'get_managed_disks_output',
]

@pulumi.output_type
class GetManagedDisksResult:
    """
    A collection of values returned by getManagedDisks.
    """
    def __init__(__self__, disks=None, id=None, resource_group_name=None):
        if disks and not isinstance(disks, list):
            raise TypeError("Expected argument 'disks' to be a list")
        pulumi.set(__self__, "disks", disks)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if resource_group_name and not isinstance(resource_group_name, str):
            raise TypeError("Expected argument 'resource_group_name' to be a str")
        pulumi.set(__self__, "resource_group_name", resource_group_name)

    @_builtins.property
    @pulumi.getter
    def disks(self) -> Sequence['outputs.GetManagedDisksDiskResult']:
        """
        a `disk` block as detailed below.
        """
        return pulumi.get(self, "disks")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> _builtins.str:
        return pulumi.get(self, "resource_group_name")


class AwaitableGetManagedDisksResult(GetManagedDisksResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetManagedDisksResult(
            disks=self.disks,
            id=self.id,
            resource_group_name=self.resource_group_name)


def get_managed_disks(resource_group_name: Optional[_builtins.str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetManagedDisksResult:
    """
    Use this data source to access information about an existing Managed Disk.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    existing = azure.compute.get_managed_disks(resource_group_name="example-resources")
    pulumi.export("firstDiskId", existing_azurerm_managed_disk["disk"][0]["id"])
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.Compute` - 2023-04-02


    :param _builtins.str resource_group_name: Specifies the name of the Resource Group where this Managed Disk exists.
    """
    __args__ = dict()
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:compute/getManagedDisks:getManagedDisks', __args__, opts=opts, typ=GetManagedDisksResult).value

    return AwaitableGetManagedDisksResult(
        disks=pulumi.get(__ret__, 'disks'),
        id=pulumi.get(__ret__, 'id'),
        resource_group_name=pulumi.get(__ret__, 'resource_group_name'))
def get_managed_disks_output(resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetManagedDisksResult]:
    """
    Use this data source to access information about an existing Managed Disk.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    existing = azure.compute.get_managed_disks(resource_group_name="example-resources")
    pulumi.export("firstDiskId", existing_azurerm_managed_disk["disk"][0]["id"])
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.Compute` - 2023-04-02


    :param _builtins.str resource_group_name: Specifies the name of the Resource Group where this Managed Disk exists.
    """
    __args__ = dict()
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:compute/getManagedDisks:getManagedDisks', __args__, opts=opts, typ=GetManagedDisksResult)
    return __ret__.apply(lambda __response__: GetManagedDisksResult(
        disks=pulumi.get(__response__, 'disks'),
        id=pulumi.get(__response__, 'id'),
        resource_group_name=pulumi.get(__response__, 'resource_group_name')))
