# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetVirtualMachineResult',
    'AwaitableGetVirtualMachineResult',
    'get_virtual_machine',
    'get_virtual_machine_output',
]

@pulumi.output_type
class GetVirtualMachineResult:
    """
    A collection of values returned by getVirtualMachine.
    """
    def __init__(__self__, id=None, identities=None, location=None, name=None, power_state=None, private_ip_address=None, private_ip_addresses=None, public_ip_address=None, public_ip_addresses=None, resource_group_name=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if identities and not isinstance(identities, list):
            raise TypeError("Expected argument 'identities' to be a list")
        pulumi.set(__self__, "identities", identities)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if power_state and not isinstance(power_state, str):
            raise TypeError("Expected argument 'power_state' to be a str")
        pulumi.set(__self__, "power_state", power_state)
        if private_ip_address and not isinstance(private_ip_address, str):
            raise TypeError("Expected argument 'private_ip_address' to be a str")
        pulumi.set(__self__, "private_ip_address", private_ip_address)
        if private_ip_addresses and not isinstance(private_ip_addresses, list):
            raise TypeError("Expected argument 'private_ip_addresses' to be a list")
        pulumi.set(__self__, "private_ip_addresses", private_ip_addresses)
        if public_ip_address and not isinstance(public_ip_address, str):
            raise TypeError("Expected argument 'public_ip_address' to be a str")
        pulumi.set(__self__, "public_ip_address", public_ip_address)
        if public_ip_addresses and not isinstance(public_ip_addresses, list):
            raise TypeError("Expected argument 'public_ip_addresses' to be a list")
        pulumi.set(__self__, "public_ip_addresses", public_ip_addresses)
        if resource_group_name and not isinstance(resource_group_name, str):
            raise TypeError("Expected argument 'resource_group_name' to be a str")
        pulumi.set(__self__, "resource_group_name", resource_group_name)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def identities(self) -> Sequence['outputs.GetVirtualMachineIdentityResult']:
        """
        A `identity` block as defined below.
        """
        return pulumi.get(self, "identities")

    @_builtins.property
    @pulumi.getter
    def location(self) -> _builtins.str:
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="powerState")
    def power_state(self) -> _builtins.str:
        """
        The power state of the virtual machine.
        """
        return pulumi.get(self, "power_state")

    @_builtins.property
    @pulumi.getter(name="privateIpAddress")
    def private_ip_address(self) -> _builtins.str:
        """
        The Primary Private IP Address assigned to this Virtual Machine.
        """
        return pulumi.get(self, "private_ip_address")

    @_builtins.property
    @pulumi.getter(name="privateIpAddresses")
    def private_ip_addresses(self) -> Sequence[_builtins.str]:
        """
        A list of Private IP Addresses assigned to this Virtual Machine.
        """
        return pulumi.get(self, "private_ip_addresses")

    @_builtins.property
    @pulumi.getter(name="publicIpAddress")
    def public_ip_address(self) -> _builtins.str:
        """
        The Primary Public IP Address assigned to this Virtual Machine.
        """
        return pulumi.get(self, "public_ip_address")

    @_builtins.property
    @pulumi.getter(name="publicIpAddresses")
    def public_ip_addresses(self) -> Sequence[_builtins.str]:
        """
        A list of the Public IP Addresses assigned to this Virtual Machine.
        """
        return pulumi.get(self, "public_ip_addresses")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> _builtins.str:
        return pulumi.get(self, "resource_group_name")


class AwaitableGetVirtualMachineResult(GetVirtualMachineResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetVirtualMachineResult(
            id=self.id,
            identities=self.identities,
            location=self.location,
            name=self.name,
            power_state=self.power_state,
            private_ip_address=self.private_ip_address,
            private_ip_addresses=self.private_ip_addresses,
            public_ip_address=self.public_ip_address,
            public_ip_addresses=self.public_ip_addresses,
            resource_group_name=self.resource_group_name)


def get_virtual_machine(name: Optional[_builtins.str] = None,
                        resource_group_name: Optional[_builtins.str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetVirtualMachineResult:
    """
    Use this data source to access information about an existing Virtual Machine.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.compute.get_virtual_machine(name="production",
        resource_group_name="networking")
    pulumi.export("virtualMachineId", example.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.Compute` - 2024-03-01


    :param _builtins.str name: Specifies the name of the Virtual Machine.
    :param _builtins.str resource_group_name: Specifies the name of the resource group the Virtual Machine is located in.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:compute/getVirtualMachine:getVirtualMachine', __args__, opts=opts, typ=GetVirtualMachineResult).value

    return AwaitableGetVirtualMachineResult(
        id=pulumi.get(__ret__, 'id'),
        identities=pulumi.get(__ret__, 'identities'),
        location=pulumi.get(__ret__, 'location'),
        name=pulumi.get(__ret__, 'name'),
        power_state=pulumi.get(__ret__, 'power_state'),
        private_ip_address=pulumi.get(__ret__, 'private_ip_address'),
        private_ip_addresses=pulumi.get(__ret__, 'private_ip_addresses'),
        public_ip_address=pulumi.get(__ret__, 'public_ip_address'),
        public_ip_addresses=pulumi.get(__ret__, 'public_ip_addresses'),
        resource_group_name=pulumi.get(__ret__, 'resource_group_name'))
def get_virtual_machine_output(name: Optional[pulumi.Input[_builtins.str]] = None,
                               resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                               opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetVirtualMachineResult]:
    """
    Use this data source to access information about an existing Virtual Machine.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.compute.get_virtual_machine(name="production",
        resource_group_name="networking")
    pulumi.export("virtualMachineId", example.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.Compute` - 2024-03-01


    :param _builtins.str name: Specifies the name of the Virtual Machine.
    :param _builtins.str resource_group_name: Specifies the name of the resource group the Virtual Machine is located in.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:compute/getVirtualMachine:getVirtualMachine', __args__, opts=opts, typ=GetVirtualMachineResult)
    return __ret__.apply(lambda __response__: GetVirtualMachineResult(
        id=pulumi.get(__response__, 'id'),
        identities=pulumi.get(__response__, 'identities'),
        location=pulumi.get(__response__, 'location'),
        name=pulumi.get(__response__, 'name'),
        power_state=pulumi.get(__response__, 'power_state'),
        private_ip_address=pulumi.get(__response__, 'private_ip_address'),
        private_ip_addresses=pulumi.get(__response__, 'private_ip_addresses'),
        public_ip_address=pulumi.get(__response__, 'public_ip_address'),
        public_ip_addresses=pulumi.get(__response__, 'public_ip_addresses'),
        resource_group_name=pulumi.get(__response__, 'resource_group_name')))
