# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['LinuxVirtualMachineScaleSetArgs', 'LinuxVirtualMachineScaleSet']

@pulumi.input_type
class LinuxVirtualMachineScaleSetArgs:
    def __init__(__self__, *,
                 admin_username: pulumi.Input[_builtins.str],
                 network_interfaces: pulumi.Input[Sequence[pulumi.Input['LinuxVirtualMachineScaleSetNetworkInterfaceArgs']]],
                 os_disk: pulumi.Input['LinuxVirtualMachineScaleSetOsDiskArgs'],
                 resource_group_name: pulumi.Input[_builtins.str],
                 sku: pulumi.Input[_builtins.str],
                 additional_capabilities: Optional[pulumi.Input['LinuxVirtualMachineScaleSetAdditionalCapabilitiesArgs']] = None,
                 admin_password: Optional[pulumi.Input[_builtins.str]] = None,
                 admin_ssh_keys: Optional[pulumi.Input[Sequence[pulumi.Input['LinuxVirtualMachineScaleSetAdminSshKeyArgs']]]] = None,
                 automatic_instance_repair: Optional[pulumi.Input['LinuxVirtualMachineScaleSetAutomaticInstanceRepairArgs']] = None,
                 automatic_os_upgrade_policy: Optional[pulumi.Input['LinuxVirtualMachineScaleSetAutomaticOsUpgradePolicyArgs']] = None,
                 boot_diagnostics: Optional[pulumi.Input['LinuxVirtualMachineScaleSetBootDiagnosticsArgs']] = None,
                 capacity_reservation_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 computer_name_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_data: Optional[pulumi.Input[_builtins.str]] = None,
                 data_disks: Optional[pulumi.Input[Sequence[pulumi.Input['LinuxVirtualMachineScaleSetDataDiskArgs']]]] = None,
                 disable_password_authentication: Optional[pulumi.Input[_builtins.bool]] = None,
                 do_not_run_extensions_on_overprovisioned_machines: Optional[pulumi.Input[_builtins.bool]] = None,
                 edge_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 encryption_at_host_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 eviction_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 extension_operations_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 extensions: Optional[pulumi.Input[Sequence[pulumi.Input['LinuxVirtualMachineScaleSetExtensionArgs']]]] = None,
                 extensions_time_budget: Optional[pulumi.Input[_builtins.str]] = None,
                 gallery_applications: Optional[pulumi.Input[Sequence[pulumi.Input['LinuxVirtualMachineScaleSetGalleryApplicationArgs']]]] = None,
                 health_probe_id: Optional[pulumi.Input[_builtins.str]] = None,
                 host_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 identity: Optional[pulumi.Input['LinuxVirtualMachineScaleSetIdentityArgs']] = None,
                 instances: Optional[pulumi.Input[_builtins.int]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 max_bid_price: Optional[pulumi.Input[_builtins.float]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 overprovision: Optional[pulumi.Input[_builtins.bool]] = None,
                 plan: Optional[pulumi.Input['LinuxVirtualMachineScaleSetPlanArgs']] = None,
                 platform_fault_domain_count: Optional[pulumi.Input[_builtins.int]] = None,
                 priority: Optional[pulumi.Input[_builtins.str]] = None,
                 provision_vm_agent: Optional[pulumi.Input[_builtins.bool]] = None,
                 proximity_placement_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 rolling_upgrade_policy: Optional[pulumi.Input['LinuxVirtualMachineScaleSetRollingUpgradePolicyArgs']] = None,
                 scale_in: Optional[pulumi.Input['LinuxVirtualMachineScaleSetScaleInArgs']] = None,
                 secrets: Optional[pulumi.Input[Sequence[pulumi.Input['LinuxVirtualMachineScaleSetSecretArgs']]]] = None,
                 secure_boot_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 single_placement_group: Optional[pulumi.Input[_builtins.bool]] = None,
                 source_image_id: Optional[pulumi.Input[_builtins.str]] = None,
                 source_image_reference: Optional[pulumi.Input['LinuxVirtualMachineScaleSetSourceImageReferenceArgs']] = None,
                 spot_restore: Optional[pulumi.Input['LinuxVirtualMachineScaleSetSpotRestoreArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 termination_notification: Optional[pulumi.Input['LinuxVirtualMachineScaleSetTerminationNotificationArgs']] = None,
                 upgrade_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 user_data: Optional[pulumi.Input[_builtins.str]] = None,
                 vtpm_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 zone_balance: Optional[pulumi.Input[_builtins.bool]] = None,
                 zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a LinuxVirtualMachineScaleSet resource.
        :param pulumi.Input[_builtins.str] admin_username: The username of the local administrator on each Virtual Machine Scale Set instance. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input['LinuxVirtualMachineScaleSetNetworkInterfaceArgs']]] network_interfaces: One or more `network_interface` blocks as defined below.
        :param pulumi.Input['LinuxVirtualMachineScaleSetOsDiskArgs'] os_disk: An `os_disk` block as defined below.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group in which the Linux Virtual Machine Scale Set should be exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] sku: The Virtual Machine SKU for the Scale Set, such as `Standard_F2`.
        :param pulumi.Input['LinuxVirtualMachineScaleSetAdditionalCapabilitiesArgs'] additional_capabilities: An `additional_capabilities` block as defined below.
        :param pulumi.Input[_builtins.str] admin_password: The Password which should be used for the local-administrator on this Virtual Machine. Changing this forces a new resource to be created.
               
               > **Note:** When an `admin_password` is specified `disable_password_authentication` must be set to `false`.
               
               > **Note:** One of either `admin_password` or `admin_ssh_key` must be specified.
        :param pulumi.Input[Sequence[pulumi.Input['LinuxVirtualMachineScaleSetAdminSshKeyArgs']]] admin_ssh_keys: One or more `admin_ssh_key` blocks as defined below.
               
               > **Note:** One of either `admin_password` or `admin_ssh_key` must be specified.
        :param pulumi.Input['LinuxVirtualMachineScaleSetAutomaticInstanceRepairArgs'] automatic_instance_repair: An `automatic_instance_repair` block as defined below. To enable the automatic instance repair, this Virtual Machine Scale Set must have a valid `health_probe_id` or an [Application Health Extension](https://docs.microsoft.com/azure/virtual-machine-scale-sets/virtual-machine-scale-sets-health-extension).
               
               > **Note:** For more information about Automatic Instance Repair, please refer to the [product documentation](https://docs.microsoft.com/azure/virtual-machine-scale-sets/virtual-machine-scale-sets-automatic-instance-repairs).
        :param pulumi.Input['LinuxVirtualMachineScaleSetAutomaticOsUpgradePolicyArgs'] automatic_os_upgrade_policy: An `automatic_os_upgrade_policy` block as defined below. This can only be specified when `upgrade_mode` is set to either `Automatic` or `Rolling`.
        :param pulumi.Input['LinuxVirtualMachineScaleSetBootDiagnosticsArgs'] boot_diagnostics: A `boot_diagnostics` block as defined below.
        :param pulumi.Input[_builtins.str] capacity_reservation_group_id: Specifies the ID of the Capacity Reservation Group which the Virtual Machine Scale Set should be allocated to. Changing this forces a new resource to be created.
               
               > **Note:** `capacity_reservation_group_id` cannot be used with `proximity_placement_group_id`
               
               > **Note:** `single_placement_group` must be set to `false` when `capacity_reservation_group_id` is specified.
        :param pulumi.Input[_builtins.str] computer_name_prefix: The prefix which should be used for the name of the Virtual Machines in this Scale Set. If unspecified this defaults to the value for the `name` field. If the value of the `name` field is not a valid `computer_name_prefix`, then you must specify `computer_name_prefix`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] custom_data: The Base64-Encoded Custom Data which should be used for this Virtual Machine Scale Set.
               
               > **Note:** When Custom Data has been configured, it's not possible to remove it without tainting the Virtual Machine Scale Set, due to a limitation of the Azure API.
        :param pulumi.Input[Sequence[pulumi.Input['LinuxVirtualMachineScaleSetDataDiskArgs']]] data_disks: One or more `data_disk` blocks as defined below.
        :param pulumi.Input[_builtins.bool] disable_password_authentication: Should Password Authentication be disabled on this Virtual Machine Scale Set? Defaults to `true`.
               
               > **Note:** In general we'd recommend using SSH Keys for authentication rather than Passwords - but there's tradeoff's to each - please [see this thread for more information](https://security.stackexchange.com/questions/69407/why-is-using-an-ssh-key-more-secure-than-using-passwords).
               
               > **Note:** When a `admin_password` is specified `disable_password_authentication` must be set to `false`.
        :param pulumi.Input[_builtins.bool] do_not_run_extensions_on_overprovisioned_machines: Should Virtual Machine Extensions be run on Overprovisioned Virtual Machines in the Scale Set? Defaults to `false`.
        :param pulumi.Input[_builtins.str] edge_zone: Specifies the Edge Zone within the Azure Region where this Linux Virtual Machine Scale Set should exist. Changing this forces a new Linux Virtual Machine Scale Set to be created.
        :param pulumi.Input[_builtins.bool] encryption_at_host_enabled: Should all of the disks (including the temp disk) attached to this Virtual Machine be encrypted by enabling Encryption at Host?
        :param pulumi.Input[_builtins.str] eviction_policy: Specifies the eviction policy for Virtual Machines in this Scale Set. Possible values are `Deallocate` and `Delete`. Changing this forces a new resource to be created.
               
               > **Note:** This can only be configured when `priority` is set to `Spot`.
        :param pulumi.Input[_builtins.bool] extension_operations_enabled: Should extension operations be allowed on the Virtual Machine Scale Set? Possible values are `true` or `false`. Defaults to `true`. Changing this forces a new Linux Virtual Machine Scale Set to be created.
               
               > **Note:** `extension_operations_enabled` may only be set to `false` if there are no extensions defined in the `extension` field.
        :param pulumi.Input[Sequence[pulumi.Input['LinuxVirtualMachineScaleSetExtensionArgs']]] extensions: One or more `extension` blocks as defined below
        :param pulumi.Input[_builtins.str] extensions_time_budget: Specifies the duration allocated for all extensions to start. The time duration should be between `15` minutes and `120` minutes (inclusive) and should be specified in ISO 8601 format. Defaults to `PT1H30M`.
        :param pulumi.Input[Sequence[pulumi.Input['LinuxVirtualMachineScaleSetGalleryApplicationArgs']]] gallery_applications: One or more `gallery_application` blocks as defined below.
        :param pulumi.Input[_builtins.str] health_probe_id: The ID of a Load Balancer Probe which should be used to determine the health of an instance. This is Required and can only be specified when `upgrade_mode` is set to `Automatic` or `Rolling`.
        :param pulumi.Input[_builtins.str] host_group_id: Specifies the ID of the dedicated host group that the virtual machine scale set resides in. Changing this forces a new resource to be created.
        :param pulumi.Input['LinuxVirtualMachineScaleSetIdentityArgs'] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.int] instances: The number of Virtual Machines in the Scale Set. Defaults to `0`.
               
               > **NOTE:** If you're using AutoScaling, you may wish to use [`Ignore Changes` functionality](https://www.pulumi.com/docs/intro/concepts/programming-model/#ignorechanges) to ignore changes to this field.
        :param pulumi.Input[_builtins.str] location: The Azure location where the Linux Virtual Machine Scale Set should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.float] max_bid_price: The maximum price you're willing to pay for each Virtual Machine in this Scale Set, in US Dollars; which must be greater than the current spot price. If this bid price falls below the current spot price the Virtual Machines in the Scale Set will be evicted using the `eviction_policy`. Defaults to `-1`, which means that each Virtual Machine in this Scale Set should not be evicted for price reasons.
               
               > **Note:** This can only be configured when `priority` is set to `Spot`.
        :param pulumi.Input[_builtins.str] name: The name of the Linux Virtual Machine Scale Set. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] overprovision: Should Azure over-provision Virtual Machines in this Scale Set? This means that multiple Virtual Machines will be provisioned and Azure will keep the instances which become available first - which improves provisioning success rates and improves deployment time. You're not billed for these over-provisioned VM's and they don't count towards the Subscription Quota. Defaults to `true`.
        :param pulumi.Input['LinuxVirtualMachineScaleSetPlanArgs'] plan: A `plan` block as defined below. Changing this forces a new resource to be created.
               
               > **Note:** When using an image from Azure Marketplace a `plan` must be specified.
        :param pulumi.Input[_builtins.int] platform_fault_domain_count: Specifies the number of fault domains that are used by this Linux Virtual Machine Scale Set. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] priority: The Priority of this Virtual Machine Scale Set. Possible values are `Regular` and `Spot`. Defaults to `Regular`. Changing this value forces a new resource.
               
               > **Note:** When `priority` is set to `Spot` an `eviction_policy` must be specified.
        :param pulumi.Input[_builtins.bool] provision_vm_agent: Should the Azure VM Agent be provisioned on each Virtual Machine in the Scale Set? Defaults to `true`. Changing this value forces a new resource to be created.
        :param pulumi.Input[_builtins.str] proximity_placement_group_id: The ID of the Proximity Placement Group in which the Virtual Machine Scale Set should be assigned to. Changing this forces a new resource to be created.
        :param pulumi.Input['LinuxVirtualMachineScaleSetRollingUpgradePolicyArgs'] rolling_upgrade_policy: A `rolling_upgrade_policy` block as defined below. This is Required and can only be specified when `upgrade_mode` is set to `Automatic` or `Rolling`. Changing this forces a new resource to be created.
        :param pulumi.Input['LinuxVirtualMachineScaleSetScaleInArgs'] scale_in: A `scale_in` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input['LinuxVirtualMachineScaleSetSecretArgs']]] secrets: One or more `secret` blocks as defined below.
        :param pulumi.Input[_builtins.bool] secure_boot_enabled: Specifies whether secure boot should be enabled on the virtual machine. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] single_placement_group: Should this Virtual Machine Scale Set be limited to a Single Placement Group, which means the number of instances will be capped at 100 Virtual Machines. Defaults to `true`.
        :param pulumi.Input[_builtins.str] source_image_id: The ID of an Image which each Virtual Machine in this Scale Set should be based on. Possible Image ID types include `Image ID`, `Shared Image ID`, `Shared Image Version ID`, `Community Gallery Image ID`, `Community Gallery Image Version ID`, `Shared Gallery Image ID` and `Shared Gallery Image Version ID`.
               
               > **Note:** One of either `source_image_id` or `source_image_reference` must be set.
        :param pulumi.Input['LinuxVirtualMachineScaleSetSourceImageReferenceArgs'] source_image_reference: A `source_image_reference` block as defined below.
               
               > **Note:** One of either `source_image_id` or `source_image_reference` must be set.
        :param pulumi.Input['LinuxVirtualMachineScaleSetSpotRestoreArgs'] spot_restore: A `spot_restore` block as defined below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to this Virtual Machine Scale Set.
        :param pulumi.Input['LinuxVirtualMachineScaleSetTerminationNotificationArgs'] termination_notification: A `termination_notification` block as defined below.
        :param pulumi.Input[_builtins.str] user_data: The Base64-Encoded User Data which should be used for this Virtual Machine Scale Set.
        :param pulumi.Input[_builtins.bool] vtpm_enabled: Specifies whether vTPM should be enabled on the virtual machine. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] zone_balance: Should the Virtual Machines in this Scale Set be strictly evenly distributed across Availability Zones? Defaults to `false`. Changing this forces a new resource to be created.
               
               > **Note:** This can only be set to `true` when one or more `zones` are configured.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] zones: Specifies a list of Availability Zones in which this Linux Virtual Machine Scale Set should be located.
               
               > **Note:** Updating `zones` to remove an existing zone forces a new Virtual Machine Scale Set to be created.
        """
        pulumi.set(__self__, "admin_username", admin_username)
        pulumi.set(__self__, "network_interfaces", network_interfaces)
        pulumi.set(__self__, "os_disk", os_disk)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "sku", sku)
        if additional_capabilities is not None:
            pulumi.set(__self__, "additional_capabilities", additional_capabilities)
        if admin_password is not None:
            pulumi.set(__self__, "admin_password", admin_password)
        if admin_ssh_keys is not None:
            pulumi.set(__self__, "admin_ssh_keys", admin_ssh_keys)
        if automatic_instance_repair is not None:
            pulumi.set(__self__, "automatic_instance_repair", automatic_instance_repair)
        if automatic_os_upgrade_policy is not None:
            pulumi.set(__self__, "automatic_os_upgrade_policy", automatic_os_upgrade_policy)
        if boot_diagnostics is not None:
            pulumi.set(__self__, "boot_diagnostics", boot_diagnostics)
        if capacity_reservation_group_id is not None:
            pulumi.set(__self__, "capacity_reservation_group_id", capacity_reservation_group_id)
        if computer_name_prefix is not None:
            pulumi.set(__self__, "computer_name_prefix", computer_name_prefix)
        if custom_data is not None:
            pulumi.set(__self__, "custom_data", custom_data)
        if data_disks is not None:
            pulumi.set(__self__, "data_disks", data_disks)
        if disable_password_authentication is not None:
            pulumi.set(__self__, "disable_password_authentication", disable_password_authentication)
        if do_not_run_extensions_on_overprovisioned_machines is not None:
            pulumi.set(__self__, "do_not_run_extensions_on_overprovisioned_machines", do_not_run_extensions_on_overprovisioned_machines)
        if edge_zone is not None:
            pulumi.set(__self__, "edge_zone", edge_zone)
        if encryption_at_host_enabled is not None:
            pulumi.set(__self__, "encryption_at_host_enabled", encryption_at_host_enabled)
        if eviction_policy is not None:
            pulumi.set(__self__, "eviction_policy", eviction_policy)
        if extension_operations_enabled is not None:
            pulumi.set(__self__, "extension_operations_enabled", extension_operations_enabled)
        if extensions is not None:
            pulumi.set(__self__, "extensions", extensions)
        if extensions_time_budget is not None:
            pulumi.set(__self__, "extensions_time_budget", extensions_time_budget)
        if gallery_applications is not None:
            pulumi.set(__self__, "gallery_applications", gallery_applications)
        if health_probe_id is not None:
            pulumi.set(__self__, "health_probe_id", health_probe_id)
        if host_group_id is not None:
            pulumi.set(__self__, "host_group_id", host_group_id)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if instances is not None:
            pulumi.set(__self__, "instances", instances)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if max_bid_price is not None:
            pulumi.set(__self__, "max_bid_price", max_bid_price)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if overprovision is not None:
            pulumi.set(__self__, "overprovision", overprovision)
        if plan is not None:
            pulumi.set(__self__, "plan", plan)
        if platform_fault_domain_count is not None:
            pulumi.set(__self__, "platform_fault_domain_count", platform_fault_domain_count)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if provision_vm_agent is not None:
            pulumi.set(__self__, "provision_vm_agent", provision_vm_agent)
        if proximity_placement_group_id is not None:
            pulumi.set(__self__, "proximity_placement_group_id", proximity_placement_group_id)
        if rolling_upgrade_policy is not None:
            pulumi.set(__self__, "rolling_upgrade_policy", rolling_upgrade_policy)
        if scale_in is not None:
            pulumi.set(__self__, "scale_in", scale_in)
        if secrets is not None:
            pulumi.set(__self__, "secrets", secrets)
        if secure_boot_enabled is not None:
            pulumi.set(__self__, "secure_boot_enabled", secure_boot_enabled)
        if single_placement_group is not None:
            pulumi.set(__self__, "single_placement_group", single_placement_group)
        if source_image_id is not None:
            pulumi.set(__self__, "source_image_id", source_image_id)
        if source_image_reference is not None:
            pulumi.set(__self__, "source_image_reference", source_image_reference)
        if spot_restore is not None:
            pulumi.set(__self__, "spot_restore", spot_restore)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if termination_notification is not None:
            pulumi.set(__self__, "termination_notification", termination_notification)
        if upgrade_mode is not None:
            pulumi.set(__self__, "upgrade_mode", upgrade_mode)
        if user_data is not None:
            pulumi.set(__self__, "user_data", user_data)
        if vtpm_enabled is not None:
            pulumi.set(__self__, "vtpm_enabled", vtpm_enabled)
        if zone_balance is not None:
            pulumi.set(__self__, "zone_balance", zone_balance)
        if zones is not None:
            pulumi.set(__self__, "zones", zones)

    @_builtins.property
    @pulumi.getter(name="adminUsername")
    def admin_username(self) -> pulumi.Input[_builtins.str]:
        """
        The username of the local administrator on each Virtual Machine Scale Set instance. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "admin_username")

    @admin_username.setter
    def admin_username(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "admin_username", value)

    @_builtins.property
    @pulumi.getter(name="networkInterfaces")
    def network_interfaces(self) -> pulumi.Input[Sequence[pulumi.Input['LinuxVirtualMachineScaleSetNetworkInterfaceArgs']]]:
        """
        One or more `network_interface` blocks as defined below.
        """
        return pulumi.get(self, "network_interfaces")

    @network_interfaces.setter
    def network_interfaces(self, value: pulumi.Input[Sequence[pulumi.Input['LinuxVirtualMachineScaleSetNetworkInterfaceArgs']]]):
        pulumi.set(self, "network_interfaces", value)

    @_builtins.property
    @pulumi.getter(name="osDisk")
    def os_disk(self) -> pulumi.Input['LinuxVirtualMachineScaleSetOsDiskArgs']:
        """
        An `os_disk` block as defined below.
        """
        return pulumi.get(self, "os_disk")

    @os_disk.setter
    def os_disk(self, value: pulumi.Input['LinuxVirtualMachineScaleSetOsDiskArgs']):
        pulumi.set(self, "os_disk", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the Resource Group in which the Linux Virtual Machine Scale Set should be exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter
    def sku(self) -> pulumi.Input[_builtins.str]:
        """
        The Virtual Machine SKU for the Scale Set, such as `Standard_F2`.
        """
        return pulumi.get(self, "sku")

    @sku.setter
    def sku(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "sku", value)

    @_builtins.property
    @pulumi.getter(name="additionalCapabilities")
    def additional_capabilities(self) -> Optional[pulumi.Input['LinuxVirtualMachineScaleSetAdditionalCapabilitiesArgs']]:
        """
        An `additional_capabilities` block as defined below.
        """
        return pulumi.get(self, "additional_capabilities")

    @additional_capabilities.setter
    def additional_capabilities(self, value: Optional[pulumi.Input['LinuxVirtualMachineScaleSetAdditionalCapabilitiesArgs']]):
        pulumi.set(self, "additional_capabilities", value)

    @_builtins.property
    @pulumi.getter(name="adminPassword")
    def admin_password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Password which should be used for the local-administrator on this Virtual Machine. Changing this forces a new resource to be created.

        > **Note:** When an `admin_password` is specified `disable_password_authentication` must be set to `false`.

        > **Note:** One of either `admin_password` or `admin_ssh_key` must be specified.
        """
        return pulumi.get(self, "admin_password")

    @admin_password.setter
    def admin_password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "admin_password", value)

    @_builtins.property
    @pulumi.getter(name="adminSshKeys")
    def admin_ssh_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LinuxVirtualMachineScaleSetAdminSshKeyArgs']]]]:
        """
        One or more `admin_ssh_key` blocks as defined below.

        > **Note:** One of either `admin_password` or `admin_ssh_key` must be specified.
        """
        return pulumi.get(self, "admin_ssh_keys")

    @admin_ssh_keys.setter
    def admin_ssh_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LinuxVirtualMachineScaleSetAdminSshKeyArgs']]]]):
        pulumi.set(self, "admin_ssh_keys", value)

    @_builtins.property
    @pulumi.getter(name="automaticInstanceRepair")
    def automatic_instance_repair(self) -> Optional[pulumi.Input['LinuxVirtualMachineScaleSetAutomaticInstanceRepairArgs']]:
        """
        An `automatic_instance_repair` block as defined below. To enable the automatic instance repair, this Virtual Machine Scale Set must have a valid `health_probe_id` or an [Application Health Extension](https://docs.microsoft.com/azure/virtual-machine-scale-sets/virtual-machine-scale-sets-health-extension).

        > **Note:** For more information about Automatic Instance Repair, please refer to the [product documentation](https://docs.microsoft.com/azure/virtual-machine-scale-sets/virtual-machine-scale-sets-automatic-instance-repairs).
        """
        return pulumi.get(self, "automatic_instance_repair")

    @automatic_instance_repair.setter
    def automatic_instance_repair(self, value: Optional[pulumi.Input['LinuxVirtualMachineScaleSetAutomaticInstanceRepairArgs']]):
        pulumi.set(self, "automatic_instance_repair", value)

    @_builtins.property
    @pulumi.getter(name="automaticOsUpgradePolicy")
    def automatic_os_upgrade_policy(self) -> Optional[pulumi.Input['LinuxVirtualMachineScaleSetAutomaticOsUpgradePolicyArgs']]:
        """
        An `automatic_os_upgrade_policy` block as defined below. This can only be specified when `upgrade_mode` is set to either `Automatic` or `Rolling`.
        """
        return pulumi.get(self, "automatic_os_upgrade_policy")

    @automatic_os_upgrade_policy.setter
    def automatic_os_upgrade_policy(self, value: Optional[pulumi.Input['LinuxVirtualMachineScaleSetAutomaticOsUpgradePolicyArgs']]):
        pulumi.set(self, "automatic_os_upgrade_policy", value)

    @_builtins.property
    @pulumi.getter(name="bootDiagnostics")
    def boot_diagnostics(self) -> Optional[pulumi.Input['LinuxVirtualMachineScaleSetBootDiagnosticsArgs']]:
        """
        A `boot_diagnostics` block as defined below.
        """
        return pulumi.get(self, "boot_diagnostics")

    @boot_diagnostics.setter
    def boot_diagnostics(self, value: Optional[pulumi.Input['LinuxVirtualMachineScaleSetBootDiagnosticsArgs']]):
        pulumi.set(self, "boot_diagnostics", value)

    @_builtins.property
    @pulumi.getter(name="capacityReservationGroupId")
    def capacity_reservation_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ID of the Capacity Reservation Group which the Virtual Machine Scale Set should be allocated to. Changing this forces a new resource to be created.

        > **Note:** `capacity_reservation_group_id` cannot be used with `proximity_placement_group_id`

        > **Note:** `single_placement_group` must be set to `false` when `capacity_reservation_group_id` is specified.
        """
        return pulumi.get(self, "capacity_reservation_group_id")

    @capacity_reservation_group_id.setter
    def capacity_reservation_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "capacity_reservation_group_id", value)

    @_builtins.property
    @pulumi.getter(name="computerNamePrefix")
    def computer_name_prefix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The prefix which should be used for the name of the Virtual Machines in this Scale Set. If unspecified this defaults to the value for the `name` field. If the value of the `name` field is not a valid `computer_name_prefix`, then you must specify `computer_name_prefix`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "computer_name_prefix")

    @computer_name_prefix.setter
    def computer_name_prefix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "computer_name_prefix", value)

    @_builtins.property
    @pulumi.getter(name="customData")
    def custom_data(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Base64-Encoded Custom Data which should be used for this Virtual Machine Scale Set.

        > **Note:** When Custom Data has been configured, it's not possible to remove it without tainting the Virtual Machine Scale Set, due to a limitation of the Azure API.
        """
        return pulumi.get(self, "custom_data")

    @custom_data.setter
    def custom_data(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "custom_data", value)

    @_builtins.property
    @pulumi.getter(name="dataDisks")
    def data_disks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LinuxVirtualMachineScaleSetDataDiskArgs']]]]:
        """
        One or more `data_disk` blocks as defined below.
        """
        return pulumi.get(self, "data_disks")

    @data_disks.setter
    def data_disks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LinuxVirtualMachineScaleSetDataDiskArgs']]]]):
        pulumi.set(self, "data_disks", value)

    @_builtins.property
    @pulumi.getter(name="disablePasswordAuthentication")
    def disable_password_authentication(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should Password Authentication be disabled on this Virtual Machine Scale Set? Defaults to `true`.

        > **Note:** In general we'd recommend using SSH Keys for authentication rather than Passwords - but there's tradeoff's to each - please [see this thread for more information](https://security.stackexchange.com/questions/69407/why-is-using-an-ssh-key-more-secure-than-using-passwords).

        > **Note:** When a `admin_password` is specified `disable_password_authentication` must be set to `false`.
        """
        return pulumi.get(self, "disable_password_authentication")

    @disable_password_authentication.setter
    def disable_password_authentication(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disable_password_authentication", value)

    @_builtins.property
    @pulumi.getter(name="doNotRunExtensionsOnOverprovisionedMachines")
    def do_not_run_extensions_on_overprovisioned_machines(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should Virtual Machine Extensions be run on Overprovisioned Virtual Machines in the Scale Set? Defaults to `false`.
        """
        return pulumi.get(self, "do_not_run_extensions_on_overprovisioned_machines")

    @do_not_run_extensions_on_overprovisioned_machines.setter
    def do_not_run_extensions_on_overprovisioned_machines(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "do_not_run_extensions_on_overprovisioned_machines", value)

    @_builtins.property
    @pulumi.getter(name="edgeZone")
    def edge_zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the Edge Zone within the Azure Region where this Linux Virtual Machine Scale Set should exist. Changing this forces a new Linux Virtual Machine Scale Set to be created.
        """
        return pulumi.get(self, "edge_zone")

    @edge_zone.setter
    def edge_zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "edge_zone", value)

    @_builtins.property
    @pulumi.getter(name="encryptionAtHostEnabled")
    def encryption_at_host_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should all of the disks (including the temp disk) attached to this Virtual Machine be encrypted by enabling Encryption at Host?
        """
        return pulumi.get(self, "encryption_at_host_enabled")

    @encryption_at_host_enabled.setter
    def encryption_at_host_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "encryption_at_host_enabled", value)

    @_builtins.property
    @pulumi.getter(name="evictionPolicy")
    def eviction_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the eviction policy for Virtual Machines in this Scale Set. Possible values are `Deallocate` and `Delete`. Changing this forces a new resource to be created.

        > **Note:** This can only be configured when `priority` is set to `Spot`.
        """
        return pulumi.get(self, "eviction_policy")

    @eviction_policy.setter
    def eviction_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "eviction_policy", value)

    @_builtins.property
    @pulumi.getter(name="extensionOperationsEnabled")
    def extension_operations_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should extension operations be allowed on the Virtual Machine Scale Set? Possible values are `true` or `false`. Defaults to `true`. Changing this forces a new Linux Virtual Machine Scale Set to be created.

        > **Note:** `extension_operations_enabled` may only be set to `false` if there are no extensions defined in the `extension` field.
        """
        return pulumi.get(self, "extension_operations_enabled")

    @extension_operations_enabled.setter
    def extension_operations_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "extension_operations_enabled", value)

    @_builtins.property
    @pulumi.getter
    def extensions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LinuxVirtualMachineScaleSetExtensionArgs']]]]:
        """
        One or more `extension` blocks as defined below
        """
        return pulumi.get(self, "extensions")

    @extensions.setter
    def extensions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LinuxVirtualMachineScaleSetExtensionArgs']]]]):
        pulumi.set(self, "extensions", value)

    @_builtins.property
    @pulumi.getter(name="extensionsTimeBudget")
    def extensions_time_budget(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the duration allocated for all extensions to start. The time duration should be between `15` minutes and `120` minutes (inclusive) and should be specified in ISO 8601 format. Defaults to `PT1H30M`.
        """
        return pulumi.get(self, "extensions_time_budget")

    @extensions_time_budget.setter
    def extensions_time_budget(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "extensions_time_budget", value)

    @_builtins.property
    @pulumi.getter(name="galleryApplications")
    def gallery_applications(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LinuxVirtualMachineScaleSetGalleryApplicationArgs']]]]:
        """
        One or more `gallery_application` blocks as defined below.
        """
        return pulumi.get(self, "gallery_applications")

    @gallery_applications.setter
    def gallery_applications(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LinuxVirtualMachineScaleSetGalleryApplicationArgs']]]]):
        pulumi.set(self, "gallery_applications", value)

    @_builtins.property
    @pulumi.getter(name="healthProbeId")
    def health_probe_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of a Load Balancer Probe which should be used to determine the health of an instance. This is Required and can only be specified when `upgrade_mode` is set to `Automatic` or `Rolling`.
        """
        return pulumi.get(self, "health_probe_id")

    @health_probe_id.setter
    def health_probe_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "health_probe_id", value)

    @_builtins.property
    @pulumi.getter(name="hostGroupId")
    def host_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ID of the dedicated host group that the virtual machine scale set resides in. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "host_group_id")

    @host_group_id.setter
    def host_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "host_group_id", value)

    @_builtins.property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['LinuxVirtualMachineScaleSetIdentityArgs']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['LinuxVirtualMachineScaleSetIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @_builtins.property
    @pulumi.getter
    def instances(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of Virtual Machines in the Scale Set. Defaults to `0`.

        > **NOTE:** If you're using AutoScaling, you may wish to use [`Ignore Changes` functionality](https://www.pulumi.com/docs/intro/concepts/programming-model/#ignorechanges) to ignore changes to this field.
        """
        return pulumi.get(self, "instances")

    @instances.setter
    def instances(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "instances", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Azure location where the Linux Virtual Machine Scale Set should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="maxBidPrice")
    def max_bid_price(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        The maximum price you're willing to pay for each Virtual Machine in this Scale Set, in US Dollars; which must be greater than the current spot price. If this bid price falls below the current spot price the Virtual Machines in the Scale Set will be evicted using the `eviction_policy`. Defaults to `-1`, which means that each Virtual Machine in this Scale Set should not be evicted for price reasons.

        > **Note:** This can only be configured when `priority` is set to `Spot`.
        """
        return pulumi.get(self, "max_bid_price")

    @max_bid_price.setter
    def max_bid_price(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "max_bid_price", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Linux Virtual Machine Scale Set. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def overprovision(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should Azure over-provision Virtual Machines in this Scale Set? This means that multiple Virtual Machines will be provisioned and Azure will keep the instances which become available first - which improves provisioning success rates and improves deployment time. You're not billed for these over-provisioned VM's and they don't count towards the Subscription Quota. Defaults to `true`.
        """
        return pulumi.get(self, "overprovision")

    @overprovision.setter
    def overprovision(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "overprovision", value)

    @_builtins.property
    @pulumi.getter
    def plan(self) -> Optional[pulumi.Input['LinuxVirtualMachineScaleSetPlanArgs']]:
        """
        A `plan` block as defined below. Changing this forces a new resource to be created.

        > **Note:** When using an image from Azure Marketplace a `plan` must be specified.
        """
        return pulumi.get(self, "plan")

    @plan.setter
    def plan(self, value: Optional[pulumi.Input['LinuxVirtualMachineScaleSetPlanArgs']]):
        pulumi.set(self, "plan", value)

    @_builtins.property
    @pulumi.getter(name="platformFaultDomainCount")
    def platform_fault_domain_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the number of fault domains that are used by this Linux Virtual Machine Scale Set. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "platform_fault_domain_count")

    @platform_fault_domain_count.setter
    def platform_fault_domain_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "platform_fault_domain_count", value)

    @_builtins.property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Priority of this Virtual Machine Scale Set. Possible values are `Regular` and `Spot`. Defaults to `Regular`. Changing this value forces a new resource.

        > **Note:** When `priority` is set to `Spot` an `eviction_policy` must be specified.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "priority", value)

    @_builtins.property
    @pulumi.getter(name="provisionVmAgent")
    def provision_vm_agent(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should the Azure VM Agent be provisioned on each Virtual Machine in the Scale Set? Defaults to `true`. Changing this value forces a new resource to be created.
        """
        return pulumi.get(self, "provision_vm_agent")

    @provision_vm_agent.setter
    def provision_vm_agent(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "provision_vm_agent", value)

    @_builtins.property
    @pulumi.getter(name="proximityPlacementGroupId")
    def proximity_placement_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Proximity Placement Group in which the Virtual Machine Scale Set should be assigned to. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "proximity_placement_group_id")

    @proximity_placement_group_id.setter
    def proximity_placement_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "proximity_placement_group_id", value)

    @_builtins.property
    @pulumi.getter(name="rollingUpgradePolicy")
    def rolling_upgrade_policy(self) -> Optional[pulumi.Input['LinuxVirtualMachineScaleSetRollingUpgradePolicyArgs']]:
        """
        A `rolling_upgrade_policy` block as defined below. This is Required and can only be specified when `upgrade_mode` is set to `Automatic` or `Rolling`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "rolling_upgrade_policy")

    @rolling_upgrade_policy.setter
    def rolling_upgrade_policy(self, value: Optional[pulumi.Input['LinuxVirtualMachineScaleSetRollingUpgradePolicyArgs']]):
        pulumi.set(self, "rolling_upgrade_policy", value)

    @_builtins.property
    @pulumi.getter(name="scaleIn")
    def scale_in(self) -> Optional[pulumi.Input['LinuxVirtualMachineScaleSetScaleInArgs']]:
        """
        A `scale_in` block as defined below.
        """
        return pulumi.get(self, "scale_in")

    @scale_in.setter
    def scale_in(self, value: Optional[pulumi.Input['LinuxVirtualMachineScaleSetScaleInArgs']]):
        pulumi.set(self, "scale_in", value)

    @_builtins.property
    @pulumi.getter
    def secrets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LinuxVirtualMachineScaleSetSecretArgs']]]]:
        """
        One or more `secret` blocks as defined below.
        """
        return pulumi.get(self, "secrets")

    @secrets.setter
    def secrets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LinuxVirtualMachineScaleSetSecretArgs']]]]):
        pulumi.set(self, "secrets", value)

    @_builtins.property
    @pulumi.getter(name="secureBootEnabled")
    def secure_boot_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether secure boot should be enabled on the virtual machine. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "secure_boot_enabled")

    @secure_boot_enabled.setter
    def secure_boot_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "secure_boot_enabled", value)

    @_builtins.property
    @pulumi.getter(name="singlePlacementGroup")
    def single_placement_group(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should this Virtual Machine Scale Set be limited to a Single Placement Group, which means the number of instances will be capped at 100 Virtual Machines. Defaults to `true`.
        """
        return pulumi.get(self, "single_placement_group")

    @single_placement_group.setter
    def single_placement_group(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "single_placement_group", value)

    @_builtins.property
    @pulumi.getter(name="sourceImageId")
    def source_image_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of an Image which each Virtual Machine in this Scale Set should be based on. Possible Image ID types include `Image ID`, `Shared Image ID`, `Shared Image Version ID`, `Community Gallery Image ID`, `Community Gallery Image Version ID`, `Shared Gallery Image ID` and `Shared Gallery Image Version ID`.

        > **Note:** One of either `source_image_id` or `source_image_reference` must be set.
        """
        return pulumi.get(self, "source_image_id")

    @source_image_id.setter
    def source_image_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_image_id", value)

    @_builtins.property
    @pulumi.getter(name="sourceImageReference")
    def source_image_reference(self) -> Optional[pulumi.Input['LinuxVirtualMachineScaleSetSourceImageReferenceArgs']]:
        """
        A `source_image_reference` block as defined below.

        > **Note:** One of either `source_image_id` or `source_image_reference` must be set.
        """
        return pulumi.get(self, "source_image_reference")

    @source_image_reference.setter
    def source_image_reference(self, value: Optional[pulumi.Input['LinuxVirtualMachineScaleSetSourceImageReferenceArgs']]):
        pulumi.set(self, "source_image_reference", value)

    @_builtins.property
    @pulumi.getter(name="spotRestore")
    def spot_restore(self) -> Optional[pulumi.Input['LinuxVirtualMachineScaleSetSpotRestoreArgs']]:
        """
        A `spot_restore` block as defined below.
        """
        return pulumi.get(self, "spot_restore")

    @spot_restore.setter
    def spot_restore(self, value: Optional[pulumi.Input['LinuxVirtualMachineScaleSetSpotRestoreArgs']]):
        pulumi.set(self, "spot_restore", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags which should be assigned to this Virtual Machine Scale Set.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="terminationNotification")
    def termination_notification(self) -> Optional[pulumi.Input['LinuxVirtualMachineScaleSetTerminationNotificationArgs']]:
        """
        A `termination_notification` block as defined below.
        """
        return pulumi.get(self, "termination_notification")

    @termination_notification.setter
    def termination_notification(self, value: Optional[pulumi.Input['LinuxVirtualMachineScaleSetTerminationNotificationArgs']]):
        pulumi.set(self, "termination_notification", value)

    @_builtins.property
    @pulumi.getter(name="upgradeMode")
    def upgrade_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "upgrade_mode")

    @upgrade_mode.setter
    def upgrade_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "upgrade_mode", value)

    @_builtins.property
    @pulumi.getter(name="userData")
    def user_data(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Base64-Encoded User Data which should be used for this Virtual Machine Scale Set.
        """
        return pulumi.get(self, "user_data")

    @user_data.setter
    def user_data(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_data", value)

    @_builtins.property
    @pulumi.getter(name="vtpmEnabled")
    def vtpm_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether vTPM should be enabled on the virtual machine. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "vtpm_enabled")

    @vtpm_enabled.setter
    def vtpm_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "vtpm_enabled", value)

    @_builtins.property
    @pulumi.getter(name="zoneBalance")
    def zone_balance(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should the Virtual Machines in this Scale Set be strictly evenly distributed across Availability Zones? Defaults to `false`. Changing this forces a new resource to be created.

        > **Note:** This can only be set to `true` when one or more `zones` are configured.
        """
        return pulumi.get(self, "zone_balance")

    @zone_balance.setter
    def zone_balance(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "zone_balance", value)

    @_builtins.property
    @pulumi.getter
    def zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies a list of Availability Zones in which this Linux Virtual Machine Scale Set should be located.

        > **Note:** Updating `zones` to remove an existing zone forces a new Virtual Machine Scale Set to be created.
        """
        return pulumi.get(self, "zones")

    @zones.setter
    def zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "zones", value)


@pulumi.input_type
class _LinuxVirtualMachineScaleSetState:
    def __init__(__self__, *,
                 additional_capabilities: Optional[pulumi.Input['LinuxVirtualMachineScaleSetAdditionalCapabilitiesArgs']] = None,
                 admin_password: Optional[pulumi.Input[_builtins.str]] = None,
                 admin_ssh_keys: Optional[pulumi.Input[Sequence[pulumi.Input['LinuxVirtualMachineScaleSetAdminSshKeyArgs']]]] = None,
                 admin_username: Optional[pulumi.Input[_builtins.str]] = None,
                 automatic_instance_repair: Optional[pulumi.Input['LinuxVirtualMachineScaleSetAutomaticInstanceRepairArgs']] = None,
                 automatic_os_upgrade_policy: Optional[pulumi.Input['LinuxVirtualMachineScaleSetAutomaticOsUpgradePolicyArgs']] = None,
                 boot_diagnostics: Optional[pulumi.Input['LinuxVirtualMachineScaleSetBootDiagnosticsArgs']] = None,
                 capacity_reservation_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 computer_name_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_data: Optional[pulumi.Input[_builtins.str]] = None,
                 data_disks: Optional[pulumi.Input[Sequence[pulumi.Input['LinuxVirtualMachineScaleSetDataDiskArgs']]]] = None,
                 disable_password_authentication: Optional[pulumi.Input[_builtins.bool]] = None,
                 do_not_run_extensions_on_overprovisioned_machines: Optional[pulumi.Input[_builtins.bool]] = None,
                 edge_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 encryption_at_host_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 eviction_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 extension_operations_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 extensions: Optional[pulumi.Input[Sequence[pulumi.Input['LinuxVirtualMachineScaleSetExtensionArgs']]]] = None,
                 extensions_time_budget: Optional[pulumi.Input[_builtins.str]] = None,
                 gallery_applications: Optional[pulumi.Input[Sequence[pulumi.Input['LinuxVirtualMachineScaleSetGalleryApplicationArgs']]]] = None,
                 health_probe_id: Optional[pulumi.Input[_builtins.str]] = None,
                 host_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 identity: Optional[pulumi.Input['LinuxVirtualMachineScaleSetIdentityArgs']] = None,
                 instances: Optional[pulumi.Input[_builtins.int]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 max_bid_price: Optional[pulumi.Input[_builtins.float]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input['LinuxVirtualMachineScaleSetNetworkInterfaceArgs']]]] = None,
                 os_disk: Optional[pulumi.Input['LinuxVirtualMachineScaleSetOsDiskArgs']] = None,
                 overprovision: Optional[pulumi.Input[_builtins.bool]] = None,
                 plan: Optional[pulumi.Input['LinuxVirtualMachineScaleSetPlanArgs']] = None,
                 platform_fault_domain_count: Optional[pulumi.Input[_builtins.int]] = None,
                 priority: Optional[pulumi.Input[_builtins.str]] = None,
                 provision_vm_agent: Optional[pulumi.Input[_builtins.bool]] = None,
                 proximity_placement_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 rolling_upgrade_policy: Optional[pulumi.Input['LinuxVirtualMachineScaleSetRollingUpgradePolicyArgs']] = None,
                 scale_in: Optional[pulumi.Input['LinuxVirtualMachineScaleSetScaleInArgs']] = None,
                 secrets: Optional[pulumi.Input[Sequence[pulumi.Input['LinuxVirtualMachineScaleSetSecretArgs']]]] = None,
                 secure_boot_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 single_placement_group: Optional[pulumi.Input[_builtins.bool]] = None,
                 sku: Optional[pulumi.Input[_builtins.str]] = None,
                 source_image_id: Optional[pulumi.Input[_builtins.str]] = None,
                 source_image_reference: Optional[pulumi.Input['LinuxVirtualMachineScaleSetSourceImageReferenceArgs']] = None,
                 spot_restore: Optional[pulumi.Input['LinuxVirtualMachineScaleSetSpotRestoreArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 termination_notification: Optional[pulumi.Input['LinuxVirtualMachineScaleSetTerminationNotificationArgs']] = None,
                 unique_id: Optional[pulumi.Input[_builtins.str]] = None,
                 upgrade_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 user_data: Optional[pulumi.Input[_builtins.str]] = None,
                 vtpm_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 zone_balance: Optional[pulumi.Input[_builtins.bool]] = None,
                 zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering LinuxVirtualMachineScaleSet resources.
        :param pulumi.Input['LinuxVirtualMachineScaleSetAdditionalCapabilitiesArgs'] additional_capabilities: An `additional_capabilities` block as defined below.
        :param pulumi.Input[_builtins.str] admin_password: The Password which should be used for the local-administrator on this Virtual Machine. Changing this forces a new resource to be created.
               
               > **Note:** When an `admin_password` is specified `disable_password_authentication` must be set to `false`.
               
               > **Note:** One of either `admin_password` or `admin_ssh_key` must be specified.
        :param pulumi.Input[Sequence[pulumi.Input['LinuxVirtualMachineScaleSetAdminSshKeyArgs']]] admin_ssh_keys: One or more `admin_ssh_key` blocks as defined below.
               
               > **Note:** One of either `admin_password` or `admin_ssh_key` must be specified.
        :param pulumi.Input[_builtins.str] admin_username: The username of the local administrator on each Virtual Machine Scale Set instance. Changing this forces a new resource to be created.
        :param pulumi.Input['LinuxVirtualMachineScaleSetAutomaticInstanceRepairArgs'] automatic_instance_repair: An `automatic_instance_repair` block as defined below. To enable the automatic instance repair, this Virtual Machine Scale Set must have a valid `health_probe_id` or an [Application Health Extension](https://docs.microsoft.com/azure/virtual-machine-scale-sets/virtual-machine-scale-sets-health-extension).
               
               > **Note:** For more information about Automatic Instance Repair, please refer to the [product documentation](https://docs.microsoft.com/azure/virtual-machine-scale-sets/virtual-machine-scale-sets-automatic-instance-repairs).
        :param pulumi.Input['LinuxVirtualMachineScaleSetAutomaticOsUpgradePolicyArgs'] automatic_os_upgrade_policy: An `automatic_os_upgrade_policy` block as defined below. This can only be specified when `upgrade_mode` is set to either `Automatic` or `Rolling`.
        :param pulumi.Input['LinuxVirtualMachineScaleSetBootDiagnosticsArgs'] boot_diagnostics: A `boot_diagnostics` block as defined below.
        :param pulumi.Input[_builtins.str] capacity_reservation_group_id: Specifies the ID of the Capacity Reservation Group which the Virtual Machine Scale Set should be allocated to. Changing this forces a new resource to be created.
               
               > **Note:** `capacity_reservation_group_id` cannot be used with `proximity_placement_group_id`
               
               > **Note:** `single_placement_group` must be set to `false` when `capacity_reservation_group_id` is specified.
        :param pulumi.Input[_builtins.str] computer_name_prefix: The prefix which should be used for the name of the Virtual Machines in this Scale Set. If unspecified this defaults to the value for the `name` field. If the value of the `name` field is not a valid `computer_name_prefix`, then you must specify `computer_name_prefix`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] custom_data: The Base64-Encoded Custom Data which should be used for this Virtual Machine Scale Set.
               
               > **Note:** When Custom Data has been configured, it's not possible to remove it without tainting the Virtual Machine Scale Set, due to a limitation of the Azure API.
        :param pulumi.Input[Sequence[pulumi.Input['LinuxVirtualMachineScaleSetDataDiskArgs']]] data_disks: One or more `data_disk` blocks as defined below.
        :param pulumi.Input[_builtins.bool] disable_password_authentication: Should Password Authentication be disabled on this Virtual Machine Scale Set? Defaults to `true`.
               
               > **Note:** In general we'd recommend using SSH Keys for authentication rather than Passwords - but there's tradeoff's to each - please [see this thread for more information](https://security.stackexchange.com/questions/69407/why-is-using-an-ssh-key-more-secure-than-using-passwords).
               
               > **Note:** When a `admin_password` is specified `disable_password_authentication` must be set to `false`.
        :param pulumi.Input[_builtins.bool] do_not_run_extensions_on_overprovisioned_machines: Should Virtual Machine Extensions be run on Overprovisioned Virtual Machines in the Scale Set? Defaults to `false`.
        :param pulumi.Input[_builtins.str] edge_zone: Specifies the Edge Zone within the Azure Region where this Linux Virtual Machine Scale Set should exist. Changing this forces a new Linux Virtual Machine Scale Set to be created.
        :param pulumi.Input[_builtins.bool] encryption_at_host_enabled: Should all of the disks (including the temp disk) attached to this Virtual Machine be encrypted by enabling Encryption at Host?
        :param pulumi.Input[_builtins.str] eviction_policy: Specifies the eviction policy for Virtual Machines in this Scale Set. Possible values are `Deallocate` and `Delete`. Changing this forces a new resource to be created.
               
               > **Note:** This can only be configured when `priority` is set to `Spot`.
        :param pulumi.Input[_builtins.bool] extension_operations_enabled: Should extension operations be allowed on the Virtual Machine Scale Set? Possible values are `true` or `false`. Defaults to `true`. Changing this forces a new Linux Virtual Machine Scale Set to be created.
               
               > **Note:** `extension_operations_enabled` may only be set to `false` if there are no extensions defined in the `extension` field.
        :param pulumi.Input[Sequence[pulumi.Input['LinuxVirtualMachineScaleSetExtensionArgs']]] extensions: One or more `extension` blocks as defined below
        :param pulumi.Input[_builtins.str] extensions_time_budget: Specifies the duration allocated for all extensions to start. The time duration should be between `15` minutes and `120` minutes (inclusive) and should be specified in ISO 8601 format. Defaults to `PT1H30M`.
        :param pulumi.Input[Sequence[pulumi.Input['LinuxVirtualMachineScaleSetGalleryApplicationArgs']]] gallery_applications: One or more `gallery_application` blocks as defined below.
        :param pulumi.Input[_builtins.str] health_probe_id: The ID of a Load Balancer Probe which should be used to determine the health of an instance. This is Required and can only be specified when `upgrade_mode` is set to `Automatic` or `Rolling`.
        :param pulumi.Input[_builtins.str] host_group_id: Specifies the ID of the dedicated host group that the virtual machine scale set resides in. Changing this forces a new resource to be created.
        :param pulumi.Input['LinuxVirtualMachineScaleSetIdentityArgs'] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.int] instances: The number of Virtual Machines in the Scale Set. Defaults to `0`.
               
               > **NOTE:** If you're using AutoScaling, you may wish to use [`Ignore Changes` functionality](https://www.pulumi.com/docs/intro/concepts/programming-model/#ignorechanges) to ignore changes to this field.
        :param pulumi.Input[_builtins.str] location: The Azure location where the Linux Virtual Machine Scale Set should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.float] max_bid_price: The maximum price you're willing to pay for each Virtual Machine in this Scale Set, in US Dollars; which must be greater than the current spot price. If this bid price falls below the current spot price the Virtual Machines in the Scale Set will be evicted using the `eviction_policy`. Defaults to `-1`, which means that each Virtual Machine in this Scale Set should not be evicted for price reasons.
               
               > **Note:** This can only be configured when `priority` is set to `Spot`.
        :param pulumi.Input[_builtins.str] name: The name of the Linux Virtual Machine Scale Set. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input['LinuxVirtualMachineScaleSetNetworkInterfaceArgs']]] network_interfaces: One or more `network_interface` blocks as defined below.
        :param pulumi.Input['LinuxVirtualMachineScaleSetOsDiskArgs'] os_disk: An `os_disk` block as defined below.
        :param pulumi.Input[_builtins.bool] overprovision: Should Azure over-provision Virtual Machines in this Scale Set? This means that multiple Virtual Machines will be provisioned and Azure will keep the instances which become available first - which improves provisioning success rates and improves deployment time. You're not billed for these over-provisioned VM's and they don't count towards the Subscription Quota. Defaults to `true`.
        :param pulumi.Input['LinuxVirtualMachineScaleSetPlanArgs'] plan: A `plan` block as defined below. Changing this forces a new resource to be created.
               
               > **Note:** When using an image from Azure Marketplace a `plan` must be specified.
        :param pulumi.Input[_builtins.int] platform_fault_domain_count: Specifies the number of fault domains that are used by this Linux Virtual Machine Scale Set. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] priority: The Priority of this Virtual Machine Scale Set. Possible values are `Regular` and `Spot`. Defaults to `Regular`. Changing this value forces a new resource.
               
               > **Note:** When `priority` is set to `Spot` an `eviction_policy` must be specified.
        :param pulumi.Input[_builtins.bool] provision_vm_agent: Should the Azure VM Agent be provisioned on each Virtual Machine in the Scale Set? Defaults to `true`. Changing this value forces a new resource to be created.
        :param pulumi.Input[_builtins.str] proximity_placement_group_id: The ID of the Proximity Placement Group in which the Virtual Machine Scale Set should be assigned to. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group in which the Linux Virtual Machine Scale Set should be exist. Changing this forces a new resource to be created.
        :param pulumi.Input['LinuxVirtualMachineScaleSetRollingUpgradePolicyArgs'] rolling_upgrade_policy: A `rolling_upgrade_policy` block as defined below. This is Required and can only be specified when `upgrade_mode` is set to `Automatic` or `Rolling`. Changing this forces a new resource to be created.
        :param pulumi.Input['LinuxVirtualMachineScaleSetScaleInArgs'] scale_in: A `scale_in` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input['LinuxVirtualMachineScaleSetSecretArgs']]] secrets: One or more `secret` blocks as defined below.
        :param pulumi.Input[_builtins.bool] secure_boot_enabled: Specifies whether secure boot should be enabled on the virtual machine. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] single_placement_group: Should this Virtual Machine Scale Set be limited to a Single Placement Group, which means the number of instances will be capped at 100 Virtual Machines. Defaults to `true`.
        :param pulumi.Input[_builtins.str] sku: The Virtual Machine SKU for the Scale Set, such as `Standard_F2`.
        :param pulumi.Input[_builtins.str] source_image_id: The ID of an Image which each Virtual Machine in this Scale Set should be based on. Possible Image ID types include `Image ID`, `Shared Image ID`, `Shared Image Version ID`, `Community Gallery Image ID`, `Community Gallery Image Version ID`, `Shared Gallery Image ID` and `Shared Gallery Image Version ID`.
               
               > **Note:** One of either `source_image_id` or `source_image_reference` must be set.
        :param pulumi.Input['LinuxVirtualMachineScaleSetSourceImageReferenceArgs'] source_image_reference: A `source_image_reference` block as defined below.
               
               > **Note:** One of either `source_image_id` or `source_image_reference` must be set.
        :param pulumi.Input['LinuxVirtualMachineScaleSetSpotRestoreArgs'] spot_restore: A `spot_restore` block as defined below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to this Virtual Machine Scale Set.
        :param pulumi.Input['LinuxVirtualMachineScaleSetTerminationNotificationArgs'] termination_notification: A `termination_notification` block as defined below.
        :param pulumi.Input[_builtins.str] unique_id: The Unique ID for this Linux Virtual Machine Scale Set.
        :param pulumi.Input[_builtins.str] user_data: The Base64-Encoded User Data which should be used for this Virtual Machine Scale Set.
        :param pulumi.Input[_builtins.bool] vtpm_enabled: Specifies whether vTPM should be enabled on the virtual machine. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] zone_balance: Should the Virtual Machines in this Scale Set be strictly evenly distributed across Availability Zones? Defaults to `false`. Changing this forces a new resource to be created.
               
               > **Note:** This can only be set to `true` when one or more `zones` are configured.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] zones: Specifies a list of Availability Zones in which this Linux Virtual Machine Scale Set should be located.
               
               > **Note:** Updating `zones` to remove an existing zone forces a new Virtual Machine Scale Set to be created.
        """
        if additional_capabilities is not None:
            pulumi.set(__self__, "additional_capabilities", additional_capabilities)
        if admin_password is not None:
            pulumi.set(__self__, "admin_password", admin_password)
        if admin_ssh_keys is not None:
            pulumi.set(__self__, "admin_ssh_keys", admin_ssh_keys)
        if admin_username is not None:
            pulumi.set(__self__, "admin_username", admin_username)
        if automatic_instance_repair is not None:
            pulumi.set(__self__, "automatic_instance_repair", automatic_instance_repair)
        if automatic_os_upgrade_policy is not None:
            pulumi.set(__self__, "automatic_os_upgrade_policy", automatic_os_upgrade_policy)
        if boot_diagnostics is not None:
            pulumi.set(__self__, "boot_diagnostics", boot_diagnostics)
        if capacity_reservation_group_id is not None:
            pulumi.set(__self__, "capacity_reservation_group_id", capacity_reservation_group_id)
        if computer_name_prefix is not None:
            pulumi.set(__self__, "computer_name_prefix", computer_name_prefix)
        if custom_data is not None:
            pulumi.set(__self__, "custom_data", custom_data)
        if data_disks is not None:
            pulumi.set(__self__, "data_disks", data_disks)
        if disable_password_authentication is not None:
            pulumi.set(__self__, "disable_password_authentication", disable_password_authentication)
        if do_not_run_extensions_on_overprovisioned_machines is not None:
            pulumi.set(__self__, "do_not_run_extensions_on_overprovisioned_machines", do_not_run_extensions_on_overprovisioned_machines)
        if edge_zone is not None:
            pulumi.set(__self__, "edge_zone", edge_zone)
        if encryption_at_host_enabled is not None:
            pulumi.set(__self__, "encryption_at_host_enabled", encryption_at_host_enabled)
        if eviction_policy is not None:
            pulumi.set(__self__, "eviction_policy", eviction_policy)
        if extension_operations_enabled is not None:
            pulumi.set(__self__, "extension_operations_enabled", extension_operations_enabled)
        if extensions is not None:
            pulumi.set(__self__, "extensions", extensions)
        if extensions_time_budget is not None:
            pulumi.set(__self__, "extensions_time_budget", extensions_time_budget)
        if gallery_applications is not None:
            pulumi.set(__self__, "gallery_applications", gallery_applications)
        if health_probe_id is not None:
            pulumi.set(__self__, "health_probe_id", health_probe_id)
        if host_group_id is not None:
            pulumi.set(__self__, "host_group_id", host_group_id)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if instances is not None:
            pulumi.set(__self__, "instances", instances)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if max_bid_price is not None:
            pulumi.set(__self__, "max_bid_price", max_bid_price)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_interfaces is not None:
            pulumi.set(__self__, "network_interfaces", network_interfaces)
        if os_disk is not None:
            pulumi.set(__self__, "os_disk", os_disk)
        if overprovision is not None:
            pulumi.set(__self__, "overprovision", overprovision)
        if plan is not None:
            pulumi.set(__self__, "plan", plan)
        if platform_fault_domain_count is not None:
            pulumi.set(__self__, "platform_fault_domain_count", platform_fault_domain_count)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if provision_vm_agent is not None:
            pulumi.set(__self__, "provision_vm_agent", provision_vm_agent)
        if proximity_placement_group_id is not None:
            pulumi.set(__self__, "proximity_placement_group_id", proximity_placement_group_id)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if rolling_upgrade_policy is not None:
            pulumi.set(__self__, "rolling_upgrade_policy", rolling_upgrade_policy)
        if scale_in is not None:
            pulumi.set(__self__, "scale_in", scale_in)
        if secrets is not None:
            pulumi.set(__self__, "secrets", secrets)
        if secure_boot_enabled is not None:
            pulumi.set(__self__, "secure_boot_enabled", secure_boot_enabled)
        if single_placement_group is not None:
            pulumi.set(__self__, "single_placement_group", single_placement_group)
        if sku is not None:
            pulumi.set(__self__, "sku", sku)
        if source_image_id is not None:
            pulumi.set(__self__, "source_image_id", source_image_id)
        if source_image_reference is not None:
            pulumi.set(__self__, "source_image_reference", source_image_reference)
        if spot_restore is not None:
            pulumi.set(__self__, "spot_restore", spot_restore)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if termination_notification is not None:
            pulumi.set(__self__, "termination_notification", termination_notification)
        if unique_id is not None:
            pulumi.set(__self__, "unique_id", unique_id)
        if upgrade_mode is not None:
            pulumi.set(__self__, "upgrade_mode", upgrade_mode)
        if user_data is not None:
            pulumi.set(__self__, "user_data", user_data)
        if vtpm_enabled is not None:
            pulumi.set(__self__, "vtpm_enabled", vtpm_enabled)
        if zone_balance is not None:
            pulumi.set(__self__, "zone_balance", zone_balance)
        if zones is not None:
            pulumi.set(__self__, "zones", zones)

    @_builtins.property
    @pulumi.getter(name="additionalCapabilities")
    def additional_capabilities(self) -> Optional[pulumi.Input['LinuxVirtualMachineScaleSetAdditionalCapabilitiesArgs']]:
        """
        An `additional_capabilities` block as defined below.
        """
        return pulumi.get(self, "additional_capabilities")

    @additional_capabilities.setter
    def additional_capabilities(self, value: Optional[pulumi.Input['LinuxVirtualMachineScaleSetAdditionalCapabilitiesArgs']]):
        pulumi.set(self, "additional_capabilities", value)

    @_builtins.property
    @pulumi.getter(name="adminPassword")
    def admin_password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Password which should be used for the local-administrator on this Virtual Machine. Changing this forces a new resource to be created.

        > **Note:** When an `admin_password` is specified `disable_password_authentication` must be set to `false`.

        > **Note:** One of either `admin_password` or `admin_ssh_key` must be specified.
        """
        return pulumi.get(self, "admin_password")

    @admin_password.setter
    def admin_password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "admin_password", value)

    @_builtins.property
    @pulumi.getter(name="adminSshKeys")
    def admin_ssh_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LinuxVirtualMachineScaleSetAdminSshKeyArgs']]]]:
        """
        One or more `admin_ssh_key` blocks as defined below.

        > **Note:** One of either `admin_password` or `admin_ssh_key` must be specified.
        """
        return pulumi.get(self, "admin_ssh_keys")

    @admin_ssh_keys.setter
    def admin_ssh_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LinuxVirtualMachineScaleSetAdminSshKeyArgs']]]]):
        pulumi.set(self, "admin_ssh_keys", value)

    @_builtins.property
    @pulumi.getter(name="adminUsername")
    def admin_username(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The username of the local administrator on each Virtual Machine Scale Set instance. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "admin_username")

    @admin_username.setter
    def admin_username(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "admin_username", value)

    @_builtins.property
    @pulumi.getter(name="automaticInstanceRepair")
    def automatic_instance_repair(self) -> Optional[pulumi.Input['LinuxVirtualMachineScaleSetAutomaticInstanceRepairArgs']]:
        """
        An `automatic_instance_repair` block as defined below. To enable the automatic instance repair, this Virtual Machine Scale Set must have a valid `health_probe_id` or an [Application Health Extension](https://docs.microsoft.com/azure/virtual-machine-scale-sets/virtual-machine-scale-sets-health-extension).

        > **Note:** For more information about Automatic Instance Repair, please refer to the [product documentation](https://docs.microsoft.com/azure/virtual-machine-scale-sets/virtual-machine-scale-sets-automatic-instance-repairs).
        """
        return pulumi.get(self, "automatic_instance_repair")

    @automatic_instance_repair.setter
    def automatic_instance_repair(self, value: Optional[pulumi.Input['LinuxVirtualMachineScaleSetAutomaticInstanceRepairArgs']]):
        pulumi.set(self, "automatic_instance_repair", value)

    @_builtins.property
    @pulumi.getter(name="automaticOsUpgradePolicy")
    def automatic_os_upgrade_policy(self) -> Optional[pulumi.Input['LinuxVirtualMachineScaleSetAutomaticOsUpgradePolicyArgs']]:
        """
        An `automatic_os_upgrade_policy` block as defined below. This can only be specified when `upgrade_mode` is set to either `Automatic` or `Rolling`.
        """
        return pulumi.get(self, "automatic_os_upgrade_policy")

    @automatic_os_upgrade_policy.setter
    def automatic_os_upgrade_policy(self, value: Optional[pulumi.Input['LinuxVirtualMachineScaleSetAutomaticOsUpgradePolicyArgs']]):
        pulumi.set(self, "automatic_os_upgrade_policy", value)

    @_builtins.property
    @pulumi.getter(name="bootDiagnostics")
    def boot_diagnostics(self) -> Optional[pulumi.Input['LinuxVirtualMachineScaleSetBootDiagnosticsArgs']]:
        """
        A `boot_diagnostics` block as defined below.
        """
        return pulumi.get(self, "boot_diagnostics")

    @boot_diagnostics.setter
    def boot_diagnostics(self, value: Optional[pulumi.Input['LinuxVirtualMachineScaleSetBootDiagnosticsArgs']]):
        pulumi.set(self, "boot_diagnostics", value)

    @_builtins.property
    @pulumi.getter(name="capacityReservationGroupId")
    def capacity_reservation_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ID of the Capacity Reservation Group which the Virtual Machine Scale Set should be allocated to. Changing this forces a new resource to be created.

        > **Note:** `capacity_reservation_group_id` cannot be used with `proximity_placement_group_id`

        > **Note:** `single_placement_group` must be set to `false` when `capacity_reservation_group_id` is specified.
        """
        return pulumi.get(self, "capacity_reservation_group_id")

    @capacity_reservation_group_id.setter
    def capacity_reservation_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "capacity_reservation_group_id", value)

    @_builtins.property
    @pulumi.getter(name="computerNamePrefix")
    def computer_name_prefix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The prefix which should be used for the name of the Virtual Machines in this Scale Set. If unspecified this defaults to the value for the `name` field. If the value of the `name` field is not a valid `computer_name_prefix`, then you must specify `computer_name_prefix`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "computer_name_prefix")

    @computer_name_prefix.setter
    def computer_name_prefix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "computer_name_prefix", value)

    @_builtins.property
    @pulumi.getter(name="customData")
    def custom_data(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Base64-Encoded Custom Data which should be used for this Virtual Machine Scale Set.

        > **Note:** When Custom Data has been configured, it's not possible to remove it without tainting the Virtual Machine Scale Set, due to a limitation of the Azure API.
        """
        return pulumi.get(self, "custom_data")

    @custom_data.setter
    def custom_data(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "custom_data", value)

    @_builtins.property
    @pulumi.getter(name="dataDisks")
    def data_disks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LinuxVirtualMachineScaleSetDataDiskArgs']]]]:
        """
        One or more `data_disk` blocks as defined below.
        """
        return pulumi.get(self, "data_disks")

    @data_disks.setter
    def data_disks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LinuxVirtualMachineScaleSetDataDiskArgs']]]]):
        pulumi.set(self, "data_disks", value)

    @_builtins.property
    @pulumi.getter(name="disablePasswordAuthentication")
    def disable_password_authentication(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should Password Authentication be disabled on this Virtual Machine Scale Set? Defaults to `true`.

        > **Note:** In general we'd recommend using SSH Keys for authentication rather than Passwords - but there's tradeoff's to each - please [see this thread for more information](https://security.stackexchange.com/questions/69407/why-is-using-an-ssh-key-more-secure-than-using-passwords).

        > **Note:** When a `admin_password` is specified `disable_password_authentication` must be set to `false`.
        """
        return pulumi.get(self, "disable_password_authentication")

    @disable_password_authentication.setter
    def disable_password_authentication(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disable_password_authentication", value)

    @_builtins.property
    @pulumi.getter(name="doNotRunExtensionsOnOverprovisionedMachines")
    def do_not_run_extensions_on_overprovisioned_machines(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should Virtual Machine Extensions be run on Overprovisioned Virtual Machines in the Scale Set? Defaults to `false`.
        """
        return pulumi.get(self, "do_not_run_extensions_on_overprovisioned_machines")

    @do_not_run_extensions_on_overprovisioned_machines.setter
    def do_not_run_extensions_on_overprovisioned_machines(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "do_not_run_extensions_on_overprovisioned_machines", value)

    @_builtins.property
    @pulumi.getter(name="edgeZone")
    def edge_zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the Edge Zone within the Azure Region where this Linux Virtual Machine Scale Set should exist. Changing this forces a new Linux Virtual Machine Scale Set to be created.
        """
        return pulumi.get(self, "edge_zone")

    @edge_zone.setter
    def edge_zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "edge_zone", value)

    @_builtins.property
    @pulumi.getter(name="encryptionAtHostEnabled")
    def encryption_at_host_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should all of the disks (including the temp disk) attached to this Virtual Machine be encrypted by enabling Encryption at Host?
        """
        return pulumi.get(self, "encryption_at_host_enabled")

    @encryption_at_host_enabled.setter
    def encryption_at_host_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "encryption_at_host_enabled", value)

    @_builtins.property
    @pulumi.getter(name="evictionPolicy")
    def eviction_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the eviction policy for Virtual Machines in this Scale Set. Possible values are `Deallocate` and `Delete`. Changing this forces a new resource to be created.

        > **Note:** This can only be configured when `priority` is set to `Spot`.
        """
        return pulumi.get(self, "eviction_policy")

    @eviction_policy.setter
    def eviction_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "eviction_policy", value)

    @_builtins.property
    @pulumi.getter(name="extensionOperationsEnabled")
    def extension_operations_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should extension operations be allowed on the Virtual Machine Scale Set? Possible values are `true` or `false`. Defaults to `true`. Changing this forces a new Linux Virtual Machine Scale Set to be created.

        > **Note:** `extension_operations_enabled` may only be set to `false` if there are no extensions defined in the `extension` field.
        """
        return pulumi.get(self, "extension_operations_enabled")

    @extension_operations_enabled.setter
    def extension_operations_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "extension_operations_enabled", value)

    @_builtins.property
    @pulumi.getter
    def extensions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LinuxVirtualMachineScaleSetExtensionArgs']]]]:
        """
        One or more `extension` blocks as defined below
        """
        return pulumi.get(self, "extensions")

    @extensions.setter
    def extensions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LinuxVirtualMachineScaleSetExtensionArgs']]]]):
        pulumi.set(self, "extensions", value)

    @_builtins.property
    @pulumi.getter(name="extensionsTimeBudget")
    def extensions_time_budget(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the duration allocated for all extensions to start. The time duration should be between `15` minutes and `120` minutes (inclusive) and should be specified in ISO 8601 format. Defaults to `PT1H30M`.
        """
        return pulumi.get(self, "extensions_time_budget")

    @extensions_time_budget.setter
    def extensions_time_budget(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "extensions_time_budget", value)

    @_builtins.property
    @pulumi.getter(name="galleryApplications")
    def gallery_applications(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LinuxVirtualMachineScaleSetGalleryApplicationArgs']]]]:
        """
        One or more `gallery_application` blocks as defined below.
        """
        return pulumi.get(self, "gallery_applications")

    @gallery_applications.setter
    def gallery_applications(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LinuxVirtualMachineScaleSetGalleryApplicationArgs']]]]):
        pulumi.set(self, "gallery_applications", value)

    @_builtins.property
    @pulumi.getter(name="healthProbeId")
    def health_probe_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of a Load Balancer Probe which should be used to determine the health of an instance. This is Required and can only be specified when `upgrade_mode` is set to `Automatic` or `Rolling`.
        """
        return pulumi.get(self, "health_probe_id")

    @health_probe_id.setter
    def health_probe_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "health_probe_id", value)

    @_builtins.property
    @pulumi.getter(name="hostGroupId")
    def host_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ID of the dedicated host group that the virtual machine scale set resides in. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "host_group_id")

    @host_group_id.setter
    def host_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "host_group_id", value)

    @_builtins.property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['LinuxVirtualMachineScaleSetIdentityArgs']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['LinuxVirtualMachineScaleSetIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @_builtins.property
    @pulumi.getter
    def instances(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of Virtual Machines in the Scale Set. Defaults to `0`.

        > **NOTE:** If you're using AutoScaling, you may wish to use [`Ignore Changes` functionality](https://www.pulumi.com/docs/intro/concepts/programming-model/#ignorechanges) to ignore changes to this field.
        """
        return pulumi.get(self, "instances")

    @instances.setter
    def instances(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "instances", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Azure location where the Linux Virtual Machine Scale Set should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="maxBidPrice")
    def max_bid_price(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        The maximum price you're willing to pay for each Virtual Machine in this Scale Set, in US Dollars; which must be greater than the current spot price. If this bid price falls below the current spot price the Virtual Machines in the Scale Set will be evicted using the `eviction_policy`. Defaults to `-1`, which means that each Virtual Machine in this Scale Set should not be evicted for price reasons.

        > **Note:** This can only be configured when `priority` is set to `Spot`.
        """
        return pulumi.get(self, "max_bid_price")

    @max_bid_price.setter
    def max_bid_price(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "max_bid_price", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Linux Virtual Machine Scale Set. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="networkInterfaces")
    def network_interfaces(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LinuxVirtualMachineScaleSetNetworkInterfaceArgs']]]]:
        """
        One or more `network_interface` blocks as defined below.
        """
        return pulumi.get(self, "network_interfaces")

    @network_interfaces.setter
    def network_interfaces(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LinuxVirtualMachineScaleSetNetworkInterfaceArgs']]]]):
        pulumi.set(self, "network_interfaces", value)

    @_builtins.property
    @pulumi.getter(name="osDisk")
    def os_disk(self) -> Optional[pulumi.Input['LinuxVirtualMachineScaleSetOsDiskArgs']]:
        """
        An `os_disk` block as defined below.
        """
        return pulumi.get(self, "os_disk")

    @os_disk.setter
    def os_disk(self, value: Optional[pulumi.Input['LinuxVirtualMachineScaleSetOsDiskArgs']]):
        pulumi.set(self, "os_disk", value)

    @_builtins.property
    @pulumi.getter
    def overprovision(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should Azure over-provision Virtual Machines in this Scale Set? This means that multiple Virtual Machines will be provisioned and Azure will keep the instances which become available first - which improves provisioning success rates and improves deployment time. You're not billed for these over-provisioned VM's and they don't count towards the Subscription Quota. Defaults to `true`.
        """
        return pulumi.get(self, "overprovision")

    @overprovision.setter
    def overprovision(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "overprovision", value)

    @_builtins.property
    @pulumi.getter
    def plan(self) -> Optional[pulumi.Input['LinuxVirtualMachineScaleSetPlanArgs']]:
        """
        A `plan` block as defined below. Changing this forces a new resource to be created.

        > **Note:** When using an image from Azure Marketplace a `plan` must be specified.
        """
        return pulumi.get(self, "plan")

    @plan.setter
    def plan(self, value: Optional[pulumi.Input['LinuxVirtualMachineScaleSetPlanArgs']]):
        pulumi.set(self, "plan", value)

    @_builtins.property
    @pulumi.getter(name="platformFaultDomainCount")
    def platform_fault_domain_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the number of fault domains that are used by this Linux Virtual Machine Scale Set. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "platform_fault_domain_count")

    @platform_fault_domain_count.setter
    def platform_fault_domain_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "platform_fault_domain_count", value)

    @_builtins.property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Priority of this Virtual Machine Scale Set. Possible values are `Regular` and `Spot`. Defaults to `Regular`. Changing this value forces a new resource.

        > **Note:** When `priority` is set to `Spot` an `eviction_policy` must be specified.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "priority", value)

    @_builtins.property
    @pulumi.getter(name="provisionVmAgent")
    def provision_vm_agent(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should the Azure VM Agent be provisioned on each Virtual Machine in the Scale Set? Defaults to `true`. Changing this value forces a new resource to be created.
        """
        return pulumi.get(self, "provision_vm_agent")

    @provision_vm_agent.setter
    def provision_vm_agent(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "provision_vm_agent", value)

    @_builtins.property
    @pulumi.getter(name="proximityPlacementGroupId")
    def proximity_placement_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Proximity Placement Group in which the Virtual Machine Scale Set should be assigned to. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "proximity_placement_group_id")

    @proximity_placement_group_id.setter
    def proximity_placement_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "proximity_placement_group_id", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Resource Group in which the Linux Virtual Machine Scale Set should be exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="rollingUpgradePolicy")
    def rolling_upgrade_policy(self) -> Optional[pulumi.Input['LinuxVirtualMachineScaleSetRollingUpgradePolicyArgs']]:
        """
        A `rolling_upgrade_policy` block as defined below. This is Required and can only be specified when `upgrade_mode` is set to `Automatic` or `Rolling`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "rolling_upgrade_policy")

    @rolling_upgrade_policy.setter
    def rolling_upgrade_policy(self, value: Optional[pulumi.Input['LinuxVirtualMachineScaleSetRollingUpgradePolicyArgs']]):
        pulumi.set(self, "rolling_upgrade_policy", value)

    @_builtins.property
    @pulumi.getter(name="scaleIn")
    def scale_in(self) -> Optional[pulumi.Input['LinuxVirtualMachineScaleSetScaleInArgs']]:
        """
        A `scale_in` block as defined below.
        """
        return pulumi.get(self, "scale_in")

    @scale_in.setter
    def scale_in(self, value: Optional[pulumi.Input['LinuxVirtualMachineScaleSetScaleInArgs']]):
        pulumi.set(self, "scale_in", value)

    @_builtins.property
    @pulumi.getter
    def secrets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LinuxVirtualMachineScaleSetSecretArgs']]]]:
        """
        One or more `secret` blocks as defined below.
        """
        return pulumi.get(self, "secrets")

    @secrets.setter
    def secrets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LinuxVirtualMachineScaleSetSecretArgs']]]]):
        pulumi.set(self, "secrets", value)

    @_builtins.property
    @pulumi.getter(name="secureBootEnabled")
    def secure_boot_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether secure boot should be enabled on the virtual machine. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "secure_boot_enabled")

    @secure_boot_enabled.setter
    def secure_boot_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "secure_boot_enabled", value)

    @_builtins.property
    @pulumi.getter(name="singlePlacementGroup")
    def single_placement_group(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should this Virtual Machine Scale Set be limited to a Single Placement Group, which means the number of instances will be capped at 100 Virtual Machines. Defaults to `true`.
        """
        return pulumi.get(self, "single_placement_group")

    @single_placement_group.setter
    def single_placement_group(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "single_placement_group", value)

    @_builtins.property
    @pulumi.getter
    def sku(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Virtual Machine SKU for the Scale Set, such as `Standard_F2`.
        """
        return pulumi.get(self, "sku")

    @sku.setter
    def sku(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sku", value)

    @_builtins.property
    @pulumi.getter(name="sourceImageId")
    def source_image_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of an Image which each Virtual Machine in this Scale Set should be based on. Possible Image ID types include `Image ID`, `Shared Image ID`, `Shared Image Version ID`, `Community Gallery Image ID`, `Community Gallery Image Version ID`, `Shared Gallery Image ID` and `Shared Gallery Image Version ID`.

        > **Note:** One of either `source_image_id` or `source_image_reference` must be set.
        """
        return pulumi.get(self, "source_image_id")

    @source_image_id.setter
    def source_image_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_image_id", value)

    @_builtins.property
    @pulumi.getter(name="sourceImageReference")
    def source_image_reference(self) -> Optional[pulumi.Input['LinuxVirtualMachineScaleSetSourceImageReferenceArgs']]:
        """
        A `source_image_reference` block as defined below.

        > **Note:** One of either `source_image_id` or `source_image_reference` must be set.
        """
        return pulumi.get(self, "source_image_reference")

    @source_image_reference.setter
    def source_image_reference(self, value: Optional[pulumi.Input['LinuxVirtualMachineScaleSetSourceImageReferenceArgs']]):
        pulumi.set(self, "source_image_reference", value)

    @_builtins.property
    @pulumi.getter(name="spotRestore")
    def spot_restore(self) -> Optional[pulumi.Input['LinuxVirtualMachineScaleSetSpotRestoreArgs']]:
        """
        A `spot_restore` block as defined below.
        """
        return pulumi.get(self, "spot_restore")

    @spot_restore.setter
    def spot_restore(self, value: Optional[pulumi.Input['LinuxVirtualMachineScaleSetSpotRestoreArgs']]):
        pulumi.set(self, "spot_restore", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags which should be assigned to this Virtual Machine Scale Set.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="terminationNotification")
    def termination_notification(self) -> Optional[pulumi.Input['LinuxVirtualMachineScaleSetTerminationNotificationArgs']]:
        """
        A `termination_notification` block as defined below.
        """
        return pulumi.get(self, "termination_notification")

    @termination_notification.setter
    def termination_notification(self, value: Optional[pulumi.Input['LinuxVirtualMachineScaleSetTerminationNotificationArgs']]):
        pulumi.set(self, "termination_notification", value)

    @_builtins.property
    @pulumi.getter(name="uniqueId")
    def unique_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Unique ID for this Linux Virtual Machine Scale Set.
        """
        return pulumi.get(self, "unique_id")

    @unique_id.setter
    def unique_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "unique_id", value)

    @_builtins.property
    @pulumi.getter(name="upgradeMode")
    def upgrade_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "upgrade_mode")

    @upgrade_mode.setter
    def upgrade_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "upgrade_mode", value)

    @_builtins.property
    @pulumi.getter(name="userData")
    def user_data(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Base64-Encoded User Data which should be used for this Virtual Machine Scale Set.
        """
        return pulumi.get(self, "user_data")

    @user_data.setter
    def user_data(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_data", value)

    @_builtins.property
    @pulumi.getter(name="vtpmEnabled")
    def vtpm_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether vTPM should be enabled on the virtual machine. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "vtpm_enabled")

    @vtpm_enabled.setter
    def vtpm_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "vtpm_enabled", value)

    @_builtins.property
    @pulumi.getter(name="zoneBalance")
    def zone_balance(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should the Virtual Machines in this Scale Set be strictly evenly distributed across Availability Zones? Defaults to `false`. Changing this forces a new resource to be created.

        > **Note:** This can only be set to `true` when one or more `zones` are configured.
        """
        return pulumi.get(self, "zone_balance")

    @zone_balance.setter
    def zone_balance(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "zone_balance", value)

    @_builtins.property
    @pulumi.getter
    def zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies a list of Availability Zones in which this Linux Virtual Machine Scale Set should be located.

        > **Note:** Updating `zones` to remove an existing zone forces a new Virtual Machine Scale Set to be created.
        """
        return pulumi.get(self, "zones")

    @zones.setter
    def zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "zones", value)


@pulumi.type_token("azure:compute/linuxVirtualMachineScaleSet:LinuxVirtualMachineScaleSet")
class LinuxVirtualMachineScaleSet(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 additional_capabilities: Optional[pulumi.Input[Union['LinuxVirtualMachineScaleSetAdditionalCapabilitiesArgs', 'LinuxVirtualMachineScaleSetAdditionalCapabilitiesArgsDict']]] = None,
                 admin_password: Optional[pulumi.Input[_builtins.str]] = None,
                 admin_ssh_keys: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LinuxVirtualMachineScaleSetAdminSshKeyArgs', 'LinuxVirtualMachineScaleSetAdminSshKeyArgsDict']]]]] = None,
                 admin_username: Optional[pulumi.Input[_builtins.str]] = None,
                 automatic_instance_repair: Optional[pulumi.Input[Union['LinuxVirtualMachineScaleSetAutomaticInstanceRepairArgs', 'LinuxVirtualMachineScaleSetAutomaticInstanceRepairArgsDict']]] = None,
                 automatic_os_upgrade_policy: Optional[pulumi.Input[Union['LinuxVirtualMachineScaleSetAutomaticOsUpgradePolicyArgs', 'LinuxVirtualMachineScaleSetAutomaticOsUpgradePolicyArgsDict']]] = None,
                 boot_diagnostics: Optional[pulumi.Input[Union['LinuxVirtualMachineScaleSetBootDiagnosticsArgs', 'LinuxVirtualMachineScaleSetBootDiagnosticsArgsDict']]] = None,
                 capacity_reservation_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 computer_name_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_data: Optional[pulumi.Input[_builtins.str]] = None,
                 data_disks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LinuxVirtualMachineScaleSetDataDiskArgs', 'LinuxVirtualMachineScaleSetDataDiskArgsDict']]]]] = None,
                 disable_password_authentication: Optional[pulumi.Input[_builtins.bool]] = None,
                 do_not_run_extensions_on_overprovisioned_machines: Optional[pulumi.Input[_builtins.bool]] = None,
                 edge_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 encryption_at_host_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 eviction_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 extension_operations_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 extensions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LinuxVirtualMachineScaleSetExtensionArgs', 'LinuxVirtualMachineScaleSetExtensionArgsDict']]]]] = None,
                 extensions_time_budget: Optional[pulumi.Input[_builtins.str]] = None,
                 gallery_applications: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LinuxVirtualMachineScaleSetGalleryApplicationArgs', 'LinuxVirtualMachineScaleSetGalleryApplicationArgsDict']]]]] = None,
                 health_probe_id: Optional[pulumi.Input[_builtins.str]] = None,
                 host_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 identity: Optional[pulumi.Input[Union['LinuxVirtualMachineScaleSetIdentityArgs', 'LinuxVirtualMachineScaleSetIdentityArgsDict']]] = None,
                 instances: Optional[pulumi.Input[_builtins.int]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 max_bid_price: Optional[pulumi.Input[_builtins.float]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LinuxVirtualMachineScaleSetNetworkInterfaceArgs', 'LinuxVirtualMachineScaleSetNetworkInterfaceArgsDict']]]]] = None,
                 os_disk: Optional[pulumi.Input[Union['LinuxVirtualMachineScaleSetOsDiskArgs', 'LinuxVirtualMachineScaleSetOsDiskArgsDict']]] = None,
                 overprovision: Optional[pulumi.Input[_builtins.bool]] = None,
                 plan: Optional[pulumi.Input[Union['LinuxVirtualMachineScaleSetPlanArgs', 'LinuxVirtualMachineScaleSetPlanArgsDict']]] = None,
                 platform_fault_domain_count: Optional[pulumi.Input[_builtins.int]] = None,
                 priority: Optional[pulumi.Input[_builtins.str]] = None,
                 provision_vm_agent: Optional[pulumi.Input[_builtins.bool]] = None,
                 proximity_placement_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 rolling_upgrade_policy: Optional[pulumi.Input[Union['LinuxVirtualMachineScaleSetRollingUpgradePolicyArgs', 'LinuxVirtualMachineScaleSetRollingUpgradePolicyArgsDict']]] = None,
                 scale_in: Optional[pulumi.Input[Union['LinuxVirtualMachineScaleSetScaleInArgs', 'LinuxVirtualMachineScaleSetScaleInArgsDict']]] = None,
                 secrets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LinuxVirtualMachineScaleSetSecretArgs', 'LinuxVirtualMachineScaleSetSecretArgsDict']]]]] = None,
                 secure_boot_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 single_placement_group: Optional[pulumi.Input[_builtins.bool]] = None,
                 sku: Optional[pulumi.Input[_builtins.str]] = None,
                 source_image_id: Optional[pulumi.Input[_builtins.str]] = None,
                 source_image_reference: Optional[pulumi.Input[Union['LinuxVirtualMachineScaleSetSourceImageReferenceArgs', 'LinuxVirtualMachineScaleSetSourceImageReferenceArgsDict']]] = None,
                 spot_restore: Optional[pulumi.Input[Union['LinuxVirtualMachineScaleSetSpotRestoreArgs', 'LinuxVirtualMachineScaleSetSpotRestoreArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 termination_notification: Optional[pulumi.Input[Union['LinuxVirtualMachineScaleSetTerminationNotificationArgs', 'LinuxVirtualMachineScaleSetTerminationNotificationArgsDict']]] = None,
                 upgrade_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 user_data: Optional[pulumi.Input[_builtins.str]] = None,
                 vtpm_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 zone_balance: Optional[pulumi.Input[_builtins.bool]] = None,
                 zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Manages a Linux Virtual Machine Scale Set.

        ## Disclaimers

        > **Note:** As of the **v2.86.0** (November 19, 2021) release of the provider this resource will only create Virtual Machine Scale Sets with the **Uniform** Orchestration Mode. For Virtual Machine Scale Sets with **Flexible** orchestration mode, use `compute.OrchestratedVirtualMachineScaleSet`. Flexible orchestration mode is recommended for workloads on Azure.
        rraform will automatically update & reimage the nodes in the Scale Set (if Required) during an Update - this behaviour can be configured using the `features` setting within the Provider block.

        ## Example Usage

        This example provisions a basic Linux Virtual Machine Scale Set on an internal network.

        ```python
        import pulumi
        import pulumi_azure as azure

        first_public_key = "ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAABAQC+wWK73dCr+jgQOAxNsHAnNNNMEMWOHYEccp6wJm2gotpr9katuF/ZAdou5AaW1C61slRkHRkpRRX9FA9CYBiitZgvCCz+3nWNN7l/Up54Zps/pHWGZLHNJZRYyAB6j5yVLMVHIHriY49d/GZTZVNB8GoJv9Gakwc/fuEZYYl4YDFiGMBP///TzlI4jhiJzjKnEvqPFki5p2ZRJqcbCiF4pJrxUQR/RXqVFQdbRLZgYfJ8xGB878RENq3yQ39d8dVOkq4edbkzwcUmwwwkYVPIoDGsYLaRHnG+To7FvMeyO7xDVQkMKzopTQV8AuKpyvpqu0a9pWOMaiCyDytO7GGN you@me.com"
        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_virtual_network = azure.network.VirtualNetwork("example",
            name="example-network",
            resource_group_name=example.name,
            location=example.location,
            address_spaces=["10.0.0.0/16"])
        internal = azure.network.Subnet("internal",
            name="internal",
            resource_group_name=example.name,
            virtual_network_name=example_virtual_network.name,
            address_prefixes=["10.0.2.0/24"])
        example_linux_virtual_machine_scale_set = azure.compute.LinuxVirtualMachineScaleSet("example",
            name="example-vmss",
            resource_group_name=example.name,
            location=example.location,
            sku="Standard_F2",
            instances=1,
            admin_username="adminuser",
            admin_ssh_keys=[{
                "username": "adminuser",
                "public_key": first_public_key,
            }],
            source_image_reference={
                "publisher": "Canonical",
                "offer": "0001-com-ubuntu-server-jammy",
                "sku": "22_04-lts",
                "version": "latest",
            },
            os_disk={
                "storage_account_type": "Standard_LRS",
                "caching": "ReadWrite",
            },
            network_interfaces=[{
                "name": "example",
                "primary": True,
                "ip_configurations": [{
                    "name": "internal",
                    "primary": True,
                    "subnet_id": internal.id,
                }],
            }])
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Compute` - 2024-11-01

        ## Import

        Linux Virtual Machine Scale Sets can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:compute/linuxVirtualMachineScaleSet:LinuxVirtualMachineScaleSet example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.Compute/virtualMachineScaleSets/scaleset1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['LinuxVirtualMachineScaleSetAdditionalCapabilitiesArgs', 'LinuxVirtualMachineScaleSetAdditionalCapabilitiesArgsDict']] additional_capabilities: An `additional_capabilities` block as defined below.
        :param pulumi.Input[_builtins.str] admin_password: The Password which should be used for the local-administrator on this Virtual Machine. Changing this forces a new resource to be created.
               
               > **Note:** When an `admin_password` is specified `disable_password_authentication` must be set to `false`.
               
               > **Note:** One of either `admin_password` or `admin_ssh_key` must be specified.
        :param pulumi.Input[Sequence[pulumi.Input[Union['LinuxVirtualMachineScaleSetAdminSshKeyArgs', 'LinuxVirtualMachineScaleSetAdminSshKeyArgsDict']]]] admin_ssh_keys: One or more `admin_ssh_key` blocks as defined below.
               
               > **Note:** One of either `admin_password` or `admin_ssh_key` must be specified.
        :param pulumi.Input[_builtins.str] admin_username: The username of the local administrator on each Virtual Machine Scale Set instance. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['LinuxVirtualMachineScaleSetAutomaticInstanceRepairArgs', 'LinuxVirtualMachineScaleSetAutomaticInstanceRepairArgsDict']] automatic_instance_repair: An `automatic_instance_repair` block as defined below. To enable the automatic instance repair, this Virtual Machine Scale Set must have a valid `health_probe_id` or an [Application Health Extension](https://docs.microsoft.com/azure/virtual-machine-scale-sets/virtual-machine-scale-sets-health-extension).
               
               > **Note:** For more information about Automatic Instance Repair, please refer to the [product documentation](https://docs.microsoft.com/azure/virtual-machine-scale-sets/virtual-machine-scale-sets-automatic-instance-repairs).
        :param pulumi.Input[Union['LinuxVirtualMachineScaleSetAutomaticOsUpgradePolicyArgs', 'LinuxVirtualMachineScaleSetAutomaticOsUpgradePolicyArgsDict']] automatic_os_upgrade_policy: An `automatic_os_upgrade_policy` block as defined below. This can only be specified when `upgrade_mode` is set to either `Automatic` or `Rolling`.
        :param pulumi.Input[Union['LinuxVirtualMachineScaleSetBootDiagnosticsArgs', 'LinuxVirtualMachineScaleSetBootDiagnosticsArgsDict']] boot_diagnostics: A `boot_diagnostics` block as defined below.
        :param pulumi.Input[_builtins.str] capacity_reservation_group_id: Specifies the ID of the Capacity Reservation Group which the Virtual Machine Scale Set should be allocated to. Changing this forces a new resource to be created.
               
               > **Note:** `capacity_reservation_group_id` cannot be used with `proximity_placement_group_id`
               
               > **Note:** `single_placement_group` must be set to `false` when `capacity_reservation_group_id` is specified.
        :param pulumi.Input[_builtins.str] computer_name_prefix: The prefix which should be used for the name of the Virtual Machines in this Scale Set. If unspecified this defaults to the value for the `name` field. If the value of the `name` field is not a valid `computer_name_prefix`, then you must specify `computer_name_prefix`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] custom_data: The Base64-Encoded Custom Data which should be used for this Virtual Machine Scale Set.
               
               > **Note:** When Custom Data has been configured, it's not possible to remove it without tainting the Virtual Machine Scale Set, due to a limitation of the Azure API.
        :param pulumi.Input[Sequence[pulumi.Input[Union['LinuxVirtualMachineScaleSetDataDiskArgs', 'LinuxVirtualMachineScaleSetDataDiskArgsDict']]]] data_disks: One or more `data_disk` blocks as defined below.
        :param pulumi.Input[_builtins.bool] disable_password_authentication: Should Password Authentication be disabled on this Virtual Machine Scale Set? Defaults to `true`.
               
               > **Note:** In general we'd recommend using SSH Keys for authentication rather than Passwords - but there's tradeoff's to each - please [see this thread for more information](https://security.stackexchange.com/questions/69407/why-is-using-an-ssh-key-more-secure-than-using-passwords).
               
               > **Note:** When a `admin_password` is specified `disable_password_authentication` must be set to `false`.
        :param pulumi.Input[_builtins.bool] do_not_run_extensions_on_overprovisioned_machines: Should Virtual Machine Extensions be run on Overprovisioned Virtual Machines in the Scale Set? Defaults to `false`.
        :param pulumi.Input[_builtins.str] edge_zone: Specifies the Edge Zone within the Azure Region where this Linux Virtual Machine Scale Set should exist. Changing this forces a new Linux Virtual Machine Scale Set to be created.
        :param pulumi.Input[_builtins.bool] encryption_at_host_enabled: Should all of the disks (including the temp disk) attached to this Virtual Machine be encrypted by enabling Encryption at Host?
        :param pulumi.Input[_builtins.str] eviction_policy: Specifies the eviction policy for Virtual Machines in this Scale Set. Possible values are `Deallocate` and `Delete`. Changing this forces a new resource to be created.
               
               > **Note:** This can only be configured when `priority` is set to `Spot`.
        :param pulumi.Input[_builtins.bool] extension_operations_enabled: Should extension operations be allowed on the Virtual Machine Scale Set? Possible values are `true` or `false`. Defaults to `true`. Changing this forces a new Linux Virtual Machine Scale Set to be created.
               
               > **Note:** `extension_operations_enabled` may only be set to `false` if there are no extensions defined in the `extension` field.
        :param pulumi.Input[Sequence[pulumi.Input[Union['LinuxVirtualMachineScaleSetExtensionArgs', 'LinuxVirtualMachineScaleSetExtensionArgsDict']]]] extensions: One or more `extension` blocks as defined below
        :param pulumi.Input[_builtins.str] extensions_time_budget: Specifies the duration allocated for all extensions to start. The time duration should be between `15` minutes and `120` minutes (inclusive) and should be specified in ISO 8601 format. Defaults to `PT1H30M`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['LinuxVirtualMachineScaleSetGalleryApplicationArgs', 'LinuxVirtualMachineScaleSetGalleryApplicationArgsDict']]]] gallery_applications: One or more `gallery_application` blocks as defined below.
        :param pulumi.Input[_builtins.str] health_probe_id: The ID of a Load Balancer Probe which should be used to determine the health of an instance. This is Required and can only be specified when `upgrade_mode` is set to `Automatic` or `Rolling`.
        :param pulumi.Input[_builtins.str] host_group_id: Specifies the ID of the dedicated host group that the virtual machine scale set resides in. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['LinuxVirtualMachineScaleSetIdentityArgs', 'LinuxVirtualMachineScaleSetIdentityArgsDict']] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.int] instances: The number of Virtual Machines in the Scale Set. Defaults to `0`.
               
               > **NOTE:** If you're using AutoScaling, you may wish to use [`Ignore Changes` functionality](https://www.pulumi.com/docs/intro/concepts/programming-model/#ignorechanges) to ignore changes to this field.
        :param pulumi.Input[_builtins.str] location: The Azure location where the Linux Virtual Machine Scale Set should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.float] max_bid_price: The maximum price you're willing to pay for each Virtual Machine in this Scale Set, in US Dollars; which must be greater than the current spot price. If this bid price falls below the current spot price the Virtual Machines in the Scale Set will be evicted using the `eviction_policy`. Defaults to `-1`, which means that each Virtual Machine in this Scale Set should not be evicted for price reasons.
               
               > **Note:** This can only be configured when `priority` is set to `Spot`.
        :param pulumi.Input[_builtins.str] name: The name of the Linux Virtual Machine Scale Set. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[Union['LinuxVirtualMachineScaleSetNetworkInterfaceArgs', 'LinuxVirtualMachineScaleSetNetworkInterfaceArgsDict']]]] network_interfaces: One or more `network_interface` blocks as defined below.
        :param pulumi.Input[Union['LinuxVirtualMachineScaleSetOsDiskArgs', 'LinuxVirtualMachineScaleSetOsDiskArgsDict']] os_disk: An `os_disk` block as defined below.
        :param pulumi.Input[_builtins.bool] overprovision: Should Azure over-provision Virtual Machines in this Scale Set? This means that multiple Virtual Machines will be provisioned and Azure will keep the instances which become available first - which improves provisioning success rates and improves deployment time. You're not billed for these over-provisioned VM's and they don't count towards the Subscription Quota. Defaults to `true`.
        :param pulumi.Input[Union['LinuxVirtualMachineScaleSetPlanArgs', 'LinuxVirtualMachineScaleSetPlanArgsDict']] plan: A `plan` block as defined below. Changing this forces a new resource to be created.
               
               > **Note:** When using an image from Azure Marketplace a `plan` must be specified.
        :param pulumi.Input[_builtins.int] platform_fault_domain_count: Specifies the number of fault domains that are used by this Linux Virtual Machine Scale Set. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] priority: The Priority of this Virtual Machine Scale Set. Possible values are `Regular` and `Spot`. Defaults to `Regular`. Changing this value forces a new resource.
               
               > **Note:** When `priority` is set to `Spot` an `eviction_policy` must be specified.
        :param pulumi.Input[_builtins.bool] provision_vm_agent: Should the Azure VM Agent be provisioned on each Virtual Machine in the Scale Set? Defaults to `true`. Changing this value forces a new resource to be created.
        :param pulumi.Input[_builtins.str] proximity_placement_group_id: The ID of the Proximity Placement Group in which the Virtual Machine Scale Set should be assigned to. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group in which the Linux Virtual Machine Scale Set should be exist. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['LinuxVirtualMachineScaleSetRollingUpgradePolicyArgs', 'LinuxVirtualMachineScaleSetRollingUpgradePolicyArgsDict']] rolling_upgrade_policy: A `rolling_upgrade_policy` block as defined below. This is Required and can only be specified when `upgrade_mode` is set to `Automatic` or `Rolling`. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['LinuxVirtualMachineScaleSetScaleInArgs', 'LinuxVirtualMachineScaleSetScaleInArgsDict']] scale_in: A `scale_in` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['LinuxVirtualMachineScaleSetSecretArgs', 'LinuxVirtualMachineScaleSetSecretArgsDict']]]] secrets: One or more `secret` blocks as defined below.
        :param pulumi.Input[_builtins.bool] secure_boot_enabled: Specifies whether secure boot should be enabled on the virtual machine. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] single_placement_group: Should this Virtual Machine Scale Set be limited to a Single Placement Group, which means the number of instances will be capped at 100 Virtual Machines. Defaults to `true`.
        :param pulumi.Input[_builtins.str] sku: The Virtual Machine SKU for the Scale Set, such as `Standard_F2`.
        :param pulumi.Input[_builtins.str] source_image_id: The ID of an Image which each Virtual Machine in this Scale Set should be based on. Possible Image ID types include `Image ID`, `Shared Image ID`, `Shared Image Version ID`, `Community Gallery Image ID`, `Community Gallery Image Version ID`, `Shared Gallery Image ID` and `Shared Gallery Image Version ID`.
               
               > **Note:** One of either `source_image_id` or `source_image_reference` must be set.
        :param pulumi.Input[Union['LinuxVirtualMachineScaleSetSourceImageReferenceArgs', 'LinuxVirtualMachineScaleSetSourceImageReferenceArgsDict']] source_image_reference: A `source_image_reference` block as defined below.
               
               > **Note:** One of either `source_image_id` or `source_image_reference` must be set.
        :param pulumi.Input[Union['LinuxVirtualMachineScaleSetSpotRestoreArgs', 'LinuxVirtualMachineScaleSetSpotRestoreArgsDict']] spot_restore: A `spot_restore` block as defined below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to this Virtual Machine Scale Set.
        :param pulumi.Input[Union['LinuxVirtualMachineScaleSetTerminationNotificationArgs', 'LinuxVirtualMachineScaleSetTerminationNotificationArgsDict']] termination_notification: A `termination_notification` block as defined below.
        :param pulumi.Input[_builtins.str] user_data: The Base64-Encoded User Data which should be used for this Virtual Machine Scale Set.
        :param pulumi.Input[_builtins.bool] vtpm_enabled: Specifies whether vTPM should be enabled on the virtual machine. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] zone_balance: Should the Virtual Machines in this Scale Set be strictly evenly distributed across Availability Zones? Defaults to `false`. Changing this forces a new resource to be created.
               
               > **Note:** This can only be set to `true` when one or more `zones` are configured.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] zones: Specifies a list of Availability Zones in which this Linux Virtual Machine Scale Set should be located.
               
               > **Note:** Updating `zones` to remove an existing zone forces a new Virtual Machine Scale Set to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LinuxVirtualMachineScaleSetArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Linux Virtual Machine Scale Set.

        ## Disclaimers

        > **Note:** As of the **v2.86.0** (November 19, 2021) release of the provider this resource will only create Virtual Machine Scale Sets with the **Uniform** Orchestration Mode. For Virtual Machine Scale Sets with **Flexible** orchestration mode, use `compute.OrchestratedVirtualMachineScaleSet`. Flexible orchestration mode is recommended for workloads on Azure.
        rraform will automatically update & reimage the nodes in the Scale Set (if Required) during an Update - this behaviour can be configured using the `features` setting within the Provider block.

        ## Example Usage

        This example provisions a basic Linux Virtual Machine Scale Set on an internal network.

        ```python
        import pulumi
        import pulumi_azure as azure

        first_public_key = "ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAABAQC+wWK73dCr+jgQOAxNsHAnNNNMEMWOHYEccp6wJm2gotpr9katuF/ZAdou5AaW1C61slRkHRkpRRX9FA9CYBiitZgvCCz+3nWNN7l/Up54Zps/pHWGZLHNJZRYyAB6j5yVLMVHIHriY49d/GZTZVNB8GoJv9Gakwc/fuEZYYl4YDFiGMBP///TzlI4jhiJzjKnEvqPFki5p2ZRJqcbCiF4pJrxUQR/RXqVFQdbRLZgYfJ8xGB878RENq3yQ39d8dVOkq4edbkzwcUmwwwkYVPIoDGsYLaRHnG+To7FvMeyO7xDVQkMKzopTQV8AuKpyvpqu0a9pWOMaiCyDytO7GGN you@me.com"
        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_virtual_network = azure.network.VirtualNetwork("example",
            name="example-network",
            resource_group_name=example.name,
            location=example.location,
            address_spaces=["10.0.0.0/16"])
        internal = azure.network.Subnet("internal",
            name="internal",
            resource_group_name=example.name,
            virtual_network_name=example_virtual_network.name,
            address_prefixes=["10.0.2.0/24"])
        example_linux_virtual_machine_scale_set = azure.compute.LinuxVirtualMachineScaleSet("example",
            name="example-vmss",
            resource_group_name=example.name,
            location=example.location,
            sku="Standard_F2",
            instances=1,
            admin_username="adminuser",
            admin_ssh_keys=[{
                "username": "adminuser",
                "public_key": first_public_key,
            }],
            source_image_reference={
                "publisher": "Canonical",
                "offer": "0001-com-ubuntu-server-jammy",
                "sku": "22_04-lts",
                "version": "latest",
            },
            os_disk={
                "storage_account_type": "Standard_LRS",
                "caching": "ReadWrite",
            },
            network_interfaces=[{
                "name": "example",
                "primary": True,
                "ip_configurations": [{
                    "name": "internal",
                    "primary": True,
                    "subnet_id": internal.id,
                }],
            }])
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Compute` - 2024-11-01

        ## Import

        Linux Virtual Machine Scale Sets can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:compute/linuxVirtualMachineScaleSet:LinuxVirtualMachineScaleSet example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.Compute/virtualMachineScaleSets/scaleset1
        ```

        :param str resource_name: The name of the resource.
        :param LinuxVirtualMachineScaleSetArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LinuxVirtualMachineScaleSetArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 additional_capabilities: Optional[pulumi.Input[Union['LinuxVirtualMachineScaleSetAdditionalCapabilitiesArgs', 'LinuxVirtualMachineScaleSetAdditionalCapabilitiesArgsDict']]] = None,
                 admin_password: Optional[pulumi.Input[_builtins.str]] = None,
                 admin_ssh_keys: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LinuxVirtualMachineScaleSetAdminSshKeyArgs', 'LinuxVirtualMachineScaleSetAdminSshKeyArgsDict']]]]] = None,
                 admin_username: Optional[pulumi.Input[_builtins.str]] = None,
                 automatic_instance_repair: Optional[pulumi.Input[Union['LinuxVirtualMachineScaleSetAutomaticInstanceRepairArgs', 'LinuxVirtualMachineScaleSetAutomaticInstanceRepairArgsDict']]] = None,
                 automatic_os_upgrade_policy: Optional[pulumi.Input[Union['LinuxVirtualMachineScaleSetAutomaticOsUpgradePolicyArgs', 'LinuxVirtualMachineScaleSetAutomaticOsUpgradePolicyArgsDict']]] = None,
                 boot_diagnostics: Optional[pulumi.Input[Union['LinuxVirtualMachineScaleSetBootDiagnosticsArgs', 'LinuxVirtualMachineScaleSetBootDiagnosticsArgsDict']]] = None,
                 capacity_reservation_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 computer_name_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_data: Optional[pulumi.Input[_builtins.str]] = None,
                 data_disks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LinuxVirtualMachineScaleSetDataDiskArgs', 'LinuxVirtualMachineScaleSetDataDiskArgsDict']]]]] = None,
                 disable_password_authentication: Optional[pulumi.Input[_builtins.bool]] = None,
                 do_not_run_extensions_on_overprovisioned_machines: Optional[pulumi.Input[_builtins.bool]] = None,
                 edge_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 encryption_at_host_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 eviction_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 extension_operations_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 extensions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LinuxVirtualMachineScaleSetExtensionArgs', 'LinuxVirtualMachineScaleSetExtensionArgsDict']]]]] = None,
                 extensions_time_budget: Optional[pulumi.Input[_builtins.str]] = None,
                 gallery_applications: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LinuxVirtualMachineScaleSetGalleryApplicationArgs', 'LinuxVirtualMachineScaleSetGalleryApplicationArgsDict']]]]] = None,
                 health_probe_id: Optional[pulumi.Input[_builtins.str]] = None,
                 host_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 identity: Optional[pulumi.Input[Union['LinuxVirtualMachineScaleSetIdentityArgs', 'LinuxVirtualMachineScaleSetIdentityArgsDict']]] = None,
                 instances: Optional[pulumi.Input[_builtins.int]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 max_bid_price: Optional[pulumi.Input[_builtins.float]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LinuxVirtualMachineScaleSetNetworkInterfaceArgs', 'LinuxVirtualMachineScaleSetNetworkInterfaceArgsDict']]]]] = None,
                 os_disk: Optional[pulumi.Input[Union['LinuxVirtualMachineScaleSetOsDiskArgs', 'LinuxVirtualMachineScaleSetOsDiskArgsDict']]] = None,
                 overprovision: Optional[pulumi.Input[_builtins.bool]] = None,
                 plan: Optional[pulumi.Input[Union['LinuxVirtualMachineScaleSetPlanArgs', 'LinuxVirtualMachineScaleSetPlanArgsDict']]] = None,
                 platform_fault_domain_count: Optional[pulumi.Input[_builtins.int]] = None,
                 priority: Optional[pulumi.Input[_builtins.str]] = None,
                 provision_vm_agent: Optional[pulumi.Input[_builtins.bool]] = None,
                 proximity_placement_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 rolling_upgrade_policy: Optional[pulumi.Input[Union['LinuxVirtualMachineScaleSetRollingUpgradePolicyArgs', 'LinuxVirtualMachineScaleSetRollingUpgradePolicyArgsDict']]] = None,
                 scale_in: Optional[pulumi.Input[Union['LinuxVirtualMachineScaleSetScaleInArgs', 'LinuxVirtualMachineScaleSetScaleInArgsDict']]] = None,
                 secrets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LinuxVirtualMachineScaleSetSecretArgs', 'LinuxVirtualMachineScaleSetSecretArgsDict']]]]] = None,
                 secure_boot_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 single_placement_group: Optional[pulumi.Input[_builtins.bool]] = None,
                 sku: Optional[pulumi.Input[_builtins.str]] = None,
                 source_image_id: Optional[pulumi.Input[_builtins.str]] = None,
                 source_image_reference: Optional[pulumi.Input[Union['LinuxVirtualMachineScaleSetSourceImageReferenceArgs', 'LinuxVirtualMachineScaleSetSourceImageReferenceArgsDict']]] = None,
                 spot_restore: Optional[pulumi.Input[Union['LinuxVirtualMachineScaleSetSpotRestoreArgs', 'LinuxVirtualMachineScaleSetSpotRestoreArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 termination_notification: Optional[pulumi.Input[Union['LinuxVirtualMachineScaleSetTerminationNotificationArgs', 'LinuxVirtualMachineScaleSetTerminationNotificationArgsDict']]] = None,
                 upgrade_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 user_data: Optional[pulumi.Input[_builtins.str]] = None,
                 vtpm_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 zone_balance: Optional[pulumi.Input[_builtins.bool]] = None,
                 zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LinuxVirtualMachineScaleSetArgs.__new__(LinuxVirtualMachineScaleSetArgs)

            __props__.__dict__["additional_capabilities"] = additional_capabilities
            __props__.__dict__["admin_password"] = None if admin_password is None else pulumi.Output.secret(admin_password)
            __props__.__dict__["admin_ssh_keys"] = admin_ssh_keys
            if admin_username is None and not opts.urn:
                raise TypeError("Missing required property 'admin_username'")
            __props__.__dict__["admin_username"] = admin_username
            __props__.__dict__["automatic_instance_repair"] = automatic_instance_repair
            __props__.__dict__["automatic_os_upgrade_policy"] = automatic_os_upgrade_policy
            __props__.__dict__["boot_diagnostics"] = boot_diagnostics
            __props__.__dict__["capacity_reservation_group_id"] = capacity_reservation_group_id
            __props__.__dict__["computer_name_prefix"] = computer_name_prefix
            __props__.__dict__["custom_data"] = None if custom_data is None else pulumi.Output.secret(custom_data)
            __props__.__dict__["data_disks"] = data_disks
            __props__.__dict__["disable_password_authentication"] = disable_password_authentication
            __props__.__dict__["do_not_run_extensions_on_overprovisioned_machines"] = do_not_run_extensions_on_overprovisioned_machines
            __props__.__dict__["edge_zone"] = edge_zone
            __props__.__dict__["encryption_at_host_enabled"] = encryption_at_host_enabled
            __props__.__dict__["eviction_policy"] = eviction_policy
            __props__.__dict__["extension_operations_enabled"] = extension_operations_enabled
            __props__.__dict__["extensions"] = extensions
            __props__.__dict__["extensions_time_budget"] = extensions_time_budget
            __props__.__dict__["gallery_applications"] = gallery_applications
            __props__.__dict__["health_probe_id"] = health_probe_id
            __props__.__dict__["host_group_id"] = host_group_id
            __props__.__dict__["identity"] = identity
            __props__.__dict__["instances"] = instances
            __props__.__dict__["location"] = location
            __props__.__dict__["max_bid_price"] = max_bid_price
            __props__.__dict__["name"] = name
            if network_interfaces is None and not opts.urn:
                raise TypeError("Missing required property 'network_interfaces'")
            __props__.__dict__["network_interfaces"] = network_interfaces
            if os_disk is None and not opts.urn:
                raise TypeError("Missing required property 'os_disk'")
            __props__.__dict__["os_disk"] = os_disk
            __props__.__dict__["overprovision"] = overprovision
            __props__.__dict__["plan"] = plan
            __props__.__dict__["platform_fault_domain_count"] = platform_fault_domain_count
            __props__.__dict__["priority"] = priority
            __props__.__dict__["provision_vm_agent"] = provision_vm_agent
            __props__.__dict__["proximity_placement_group_id"] = proximity_placement_group_id
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["rolling_upgrade_policy"] = rolling_upgrade_policy
            __props__.__dict__["scale_in"] = scale_in
            __props__.__dict__["secrets"] = secrets
            __props__.__dict__["secure_boot_enabled"] = secure_boot_enabled
            __props__.__dict__["single_placement_group"] = single_placement_group
            if sku is None and not opts.urn:
                raise TypeError("Missing required property 'sku'")
            __props__.__dict__["sku"] = sku
            __props__.__dict__["source_image_id"] = source_image_id
            __props__.__dict__["source_image_reference"] = source_image_reference
            __props__.__dict__["spot_restore"] = spot_restore
            __props__.__dict__["tags"] = tags
            __props__.__dict__["termination_notification"] = termination_notification
            __props__.__dict__["upgrade_mode"] = upgrade_mode
            __props__.__dict__["user_data"] = user_data
            __props__.__dict__["vtpm_enabled"] = vtpm_enabled
            __props__.__dict__["zone_balance"] = zone_balance
            __props__.__dict__["zones"] = zones
            __props__.__dict__["unique_id"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["adminPassword", "customData"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(LinuxVirtualMachineScaleSet, __self__).__init__(
            'azure:compute/linuxVirtualMachineScaleSet:LinuxVirtualMachineScaleSet',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            additional_capabilities: Optional[pulumi.Input[Union['LinuxVirtualMachineScaleSetAdditionalCapabilitiesArgs', 'LinuxVirtualMachineScaleSetAdditionalCapabilitiesArgsDict']]] = None,
            admin_password: Optional[pulumi.Input[_builtins.str]] = None,
            admin_ssh_keys: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LinuxVirtualMachineScaleSetAdminSshKeyArgs', 'LinuxVirtualMachineScaleSetAdminSshKeyArgsDict']]]]] = None,
            admin_username: Optional[pulumi.Input[_builtins.str]] = None,
            automatic_instance_repair: Optional[pulumi.Input[Union['LinuxVirtualMachineScaleSetAutomaticInstanceRepairArgs', 'LinuxVirtualMachineScaleSetAutomaticInstanceRepairArgsDict']]] = None,
            automatic_os_upgrade_policy: Optional[pulumi.Input[Union['LinuxVirtualMachineScaleSetAutomaticOsUpgradePolicyArgs', 'LinuxVirtualMachineScaleSetAutomaticOsUpgradePolicyArgsDict']]] = None,
            boot_diagnostics: Optional[pulumi.Input[Union['LinuxVirtualMachineScaleSetBootDiagnosticsArgs', 'LinuxVirtualMachineScaleSetBootDiagnosticsArgsDict']]] = None,
            capacity_reservation_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            computer_name_prefix: Optional[pulumi.Input[_builtins.str]] = None,
            custom_data: Optional[pulumi.Input[_builtins.str]] = None,
            data_disks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LinuxVirtualMachineScaleSetDataDiskArgs', 'LinuxVirtualMachineScaleSetDataDiskArgsDict']]]]] = None,
            disable_password_authentication: Optional[pulumi.Input[_builtins.bool]] = None,
            do_not_run_extensions_on_overprovisioned_machines: Optional[pulumi.Input[_builtins.bool]] = None,
            edge_zone: Optional[pulumi.Input[_builtins.str]] = None,
            encryption_at_host_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            eviction_policy: Optional[pulumi.Input[_builtins.str]] = None,
            extension_operations_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            extensions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LinuxVirtualMachineScaleSetExtensionArgs', 'LinuxVirtualMachineScaleSetExtensionArgsDict']]]]] = None,
            extensions_time_budget: Optional[pulumi.Input[_builtins.str]] = None,
            gallery_applications: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LinuxVirtualMachineScaleSetGalleryApplicationArgs', 'LinuxVirtualMachineScaleSetGalleryApplicationArgsDict']]]]] = None,
            health_probe_id: Optional[pulumi.Input[_builtins.str]] = None,
            host_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            identity: Optional[pulumi.Input[Union['LinuxVirtualMachineScaleSetIdentityArgs', 'LinuxVirtualMachineScaleSetIdentityArgsDict']]] = None,
            instances: Optional[pulumi.Input[_builtins.int]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            max_bid_price: Optional[pulumi.Input[_builtins.float]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LinuxVirtualMachineScaleSetNetworkInterfaceArgs', 'LinuxVirtualMachineScaleSetNetworkInterfaceArgsDict']]]]] = None,
            os_disk: Optional[pulumi.Input[Union['LinuxVirtualMachineScaleSetOsDiskArgs', 'LinuxVirtualMachineScaleSetOsDiskArgsDict']]] = None,
            overprovision: Optional[pulumi.Input[_builtins.bool]] = None,
            plan: Optional[pulumi.Input[Union['LinuxVirtualMachineScaleSetPlanArgs', 'LinuxVirtualMachineScaleSetPlanArgsDict']]] = None,
            platform_fault_domain_count: Optional[pulumi.Input[_builtins.int]] = None,
            priority: Optional[pulumi.Input[_builtins.str]] = None,
            provision_vm_agent: Optional[pulumi.Input[_builtins.bool]] = None,
            proximity_placement_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            rolling_upgrade_policy: Optional[pulumi.Input[Union['LinuxVirtualMachineScaleSetRollingUpgradePolicyArgs', 'LinuxVirtualMachineScaleSetRollingUpgradePolicyArgsDict']]] = None,
            scale_in: Optional[pulumi.Input[Union['LinuxVirtualMachineScaleSetScaleInArgs', 'LinuxVirtualMachineScaleSetScaleInArgsDict']]] = None,
            secrets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LinuxVirtualMachineScaleSetSecretArgs', 'LinuxVirtualMachineScaleSetSecretArgsDict']]]]] = None,
            secure_boot_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            single_placement_group: Optional[pulumi.Input[_builtins.bool]] = None,
            sku: Optional[pulumi.Input[_builtins.str]] = None,
            source_image_id: Optional[pulumi.Input[_builtins.str]] = None,
            source_image_reference: Optional[pulumi.Input[Union['LinuxVirtualMachineScaleSetSourceImageReferenceArgs', 'LinuxVirtualMachineScaleSetSourceImageReferenceArgsDict']]] = None,
            spot_restore: Optional[pulumi.Input[Union['LinuxVirtualMachineScaleSetSpotRestoreArgs', 'LinuxVirtualMachineScaleSetSpotRestoreArgsDict']]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            termination_notification: Optional[pulumi.Input[Union['LinuxVirtualMachineScaleSetTerminationNotificationArgs', 'LinuxVirtualMachineScaleSetTerminationNotificationArgsDict']]] = None,
            unique_id: Optional[pulumi.Input[_builtins.str]] = None,
            upgrade_mode: Optional[pulumi.Input[_builtins.str]] = None,
            user_data: Optional[pulumi.Input[_builtins.str]] = None,
            vtpm_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            zone_balance: Optional[pulumi.Input[_builtins.bool]] = None,
            zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None) -> 'LinuxVirtualMachineScaleSet':
        """
        Get an existing LinuxVirtualMachineScaleSet resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['LinuxVirtualMachineScaleSetAdditionalCapabilitiesArgs', 'LinuxVirtualMachineScaleSetAdditionalCapabilitiesArgsDict']] additional_capabilities: An `additional_capabilities` block as defined below.
        :param pulumi.Input[_builtins.str] admin_password: The Password which should be used for the local-administrator on this Virtual Machine. Changing this forces a new resource to be created.
               
               > **Note:** When an `admin_password` is specified `disable_password_authentication` must be set to `false`.
               
               > **Note:** One of either `admin_password` or `admin_ssh_key` must be specified.
        :param pulumi.Input[Sequence[pulumi.Input[Union['LinuxVirtualMachineScaleSetAdminSshKeyArgs', 'LinuxVirtualMachineScaleSetAdminSshKeyArgsDict']]]] admin_ssh_keys: One or more `admin_ssh_key` blocks as defined below.
               
               > **Note:** One of either `admin_password` or `admin_ssh_key` must be specified.
        :param pulumi.Input[_builtins.str] admin_username: The username of the local administrator on each Virtual Machine Scale Set instance. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['LinuxVirtualMachineScaleSetAutomaticInstanceRepairArgs', 'LinuxVirtualMachineScaleSetAutomaticInstanceRepairArgsDict']] automatic_instance_repair: An `automatic_instance_repair` block as defined below. To enable the automatic instance repair, this Virtual Machine Scale Set must have a valid `health_probe_id` or an [Application Health Extension](https://docs.microsoft.com/azure/virtual-machine-scale-sets/virtual-machine-scale-sets-health-extension).
               
               > **Note:** For more information about Automatic Instance Repair, please refer to the [product documentation](https://docs.microsoft.com/azure/virtual-machine-scale-sets/virtual-machine-scale-sets-automatic-instance-repairs).
        :param pulumi.Input[Union['LinuxVirtualMachineScaleSetAutomaticOsUpgradePolicyArgs', 'LinuxVirtualMachineScaleSetAutomaticOsUpgradePolicyArgsDict']] automatic_os_upgrade_policy: An `automatic_os_upgrade_policy` block as defined below. This can only be specified when `upgrade_mode` is set to either `Automatic` or `Rolling`.
        :param pulumi.Input[Union['LinuxVirtualMachineScaleSetBootDiagnosticsArgs', 'LinuxVirtualMachineScaleSetBootDiagnosticsArgsDict']] boot_diagnostics: A `boot_diagnostics` block as defined below.
        :param pulumi.Input[_builtins.str] capacity_reservation_group_id: Specifies the ID of the Capacity Reservation Group which the Virtual Machine Scale Set should be allocated to. Changing this forces a new resource to be created.
               
               > **Note:** `capacity_reservation_group_id` cannot be used with `proximity_placement_group_id`
               
               > **Note:** `single_placement_group` must be set to `false` when `capacity_reservation_group_id` is specified.
        :param pulumi.Input[_builtins.str] computer_name_prefix: The prefix which should be used for the name of the Virtual Machines in this Scale Set. If unspecified this defaults to the value for the `name` field. If the value of the `name` field is not a valid `computer_name_prefix`, then you must specify `computer_name_prefix`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] custom_data: The Base64-Encoded Custom Data which should be used for this Virtual Machine Scale Set.
               
               > **Note:** When Custom Data has been configured, it's not possible to remove it without tainting the Virtual Machine Scale Set, due to a limitation of the Azure API.
        :param pulumi.Input[Sequence[pulumi.Input[Union['LinuxVirtualMachineScaleSetDataDiskArgs', 'LinuxVirtualMachineScaleSetDataDiskArgsDict']]]] data_disks: One or more `data_disk` blocks as defined below.
        :param pulumi.Input[_builtins.bool] disable_password_authentication: Should Password Authentication be disabled on this Virtual Machine Scale Set? Defaults to `true`.
               
               > **Note:** In general we'd recommend using SSH Keys for authentication rather than Passwords - but there's tradeoff's to each - please [see this thread for more information](https://security.stackexchange.com/questions/69407/why-is-using-an-ssh-key-more-secure-than-using-passwords).
               
               > **Note:** When a `admin_password` is specified `disable_password_authentication` must be set to `false`.
        :param pulumi.Input[_builtins.bool] do_not_run_extensions_on_overprovisioned_machines: Should Virtual Machine Extensions be run on Overprovisioned Virtual Machines in the Scale Set? Defaults to `false`.
        :param pulumi.Input[_builtins.str] edge_zone: Specifies the Edge Zone within the Azure Region where this Linux Virtual Machine Scale Set should exist. Changing this forces a new Linux Virtual Machine Scale Set to be created.
        :param pulumi.Input[_builtins.bool] encryption_at_host_enabled: Should all of the disks (including the temp disk) attached to this Virtual Machine be encrypted by enabling Encryption at Host?
        :param pulumi.Input[_builtins.str] eviction_policy: Specifies the eviction policy for Virtual Machines in this Scale Set. Possible values are `Deallocate` and `Delete`. Changing this forces a new resource to be created.
               
               > **Note:** This can only be configured when `priority` is set to `Spot`.
        :param pulumi.Input[_builtins.bool] extension_operations_enabled: Should extension operations be allowed on the Virtual Machine Scale Set? Possible values are `true` or `false`. Defaults to `true`. Changing this forces a new Linux Virtual Machine Scale Set to be created.
               
               > **Note:** `extension_operations_enabled` may only be set to `false` if there are no extensions defined in the `extension` field.
        :param pulumi.Input[Sequence[pulumi.Input[Union['LinuxVirtualMachineScaleSetExtensionArgs', 'LinuxVirtualMachineScaleSetExtensionArgsDict']]]] extensions: One or more `extension` blocks as defined below
        :param pulumi.Input[_builtins.str] extensions_time_budget: Specifies the duration allocated for all extensions to start. The time duration should be between `15` minutes and `120` minutes (inclusive) and should be specified in ISO 8601 format. Defaults to `PT1H30M`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['LinuxVirtualMachineScaleSetGalleryApplicationArgs', 'LinuxVirtualMachineScaleSetGalleryApplicationArgsDict']]]] gallery_applications: One or more `gallery_application` blocks as defined below.
        :param pulumi.Input[_builtins.str] health_probe_id: The ID of a Load Balancer Probe which should be used to determine the health of an instance. This is Required and can only be specified when `upgrade_mode` is set to `Automatic` or `Rolling`.
        :param pulumi.Input[_builtins.str] host_group_id: Specifies the ID of the dedicated host group that the virtual machine scale set resides in. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['LinuxVirtualMachineScaleSetIdentityArgs', 'LinuxVirtualMachineScaleSetIdentityArgsDict']] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.int] instances: The number of Virtual Machines in the Scale Set. Defaults to `0`.
               
               > **NOTE:** If you're using AutoScaling, you may wish to use [`Ignore Changes` functionality](https://www.pulumi.com/docs/intro/concepts/programming-model/#ignorechanges) to ignore changes to this field.
        :param pulumi.Input[_builtins.str] location: The Azure location where the Linux Virtual Machine Scale Set should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.float] max_bid_price: The maximum price you're willing to pay for each Virtual Machine in this Scale Set, in US Dollars; which must be greater than the current spot price. If this bid price falls below the current spot price the Virtual Machines in the Scale Set will be evicted using the `eviction_policy`. Defaults to `-1`, which means that each Virtual Machine in this Scale Set should not be evicted for price reasons.
               
               > **Note:** This can only be configured when `priority` is set to `Spot`.
        :param pulumi.Input[_builtins.str] name: The name of the Linux Virtual Machine Scale Set. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[Union['LinuxVirtualMachineScaleSetNetworkInterfaceArgs', 'LinuxVirtualMachineScaleSetNetworkInterfaceArgsDict']]]] network_interfaces: One or more `network_interface` blocks as defined below.
        :param pulumi.Input[Union['LinuxVirtualMachineScaleSetOsDiskArgs', 'LinuxVirtualMachineScaleSetOsDiskArgsDict']] os_disk: An `os_disk` block as defined below.
        :param pulumi.Input[_builtins.bool] overprovision: Should Azure over-provision Virtual Machines in this Scale Set? This means that multiple Virtual Machines will be provisioned and Azure will keep the instances which become available first - which improves provisioning success rates and improves deployment time. You're not billed for these over-provisioned VM's and they don't count towards the Subscription Quota. Defaults to `true`.
        :param pulumi.Input[Union['LinuxVirtualMachineScaleSetPlanArgs', 'LinuxVirtualMachineScaleSetPlanArgsDict']] plan: A `plan` block as defined below. Changing this forces a new resource to be created.
               
               > **Note:** When using an image from Azure Marketplace a `plan` must be specified.
        :param pulumi.Input[_builtins.int] platform_fault_domain_count: Specifies the number of fault domains that are used by this Linux Virtual Machine Scale Set. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] priority: The Priority of this Virtual Machine Scale Set. Possible values are `Regular` and `Spot`. Defaults to `Regular`. Changing this value forces a new resource.
               
               > **Note:** When `priority` is set to `Spot` an `eviction_policy` must be specified.
        :param pulumi.Input[_builtins.bool] provision_vm_agent: Should the Azure VM Agent be provisioned on each Virtual Machine in the Scale Set? Defaults to `true`. Changing this value forces a new resource to be created.
        :param pulumi.Input[_builtins.str] proximity_placement_group_id: The ID of the Proximity Placement Group in which the Virtual Machine Scale Set should be assigned to. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group in which the Linux Virtual Machine Scale Set should be exist. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['LinuxVirtualMachineScaleSetRollingUpgradePolicyArgs', 'LinuxVirtualMachineScaleSetRollingUpgradePolicyArgsDict']] rolling_upgrade_policy: A `rolling_upgrade_policy` block as defined below. This is Required and can only be specified when `upgrade_mode` is set to `Automatic` or `Rolling`. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['LinuxVirtualMachineScaleSetScaleInArgs', 'LinuxVirtualMachineScaleSetScaleInArgsDict']] scale_in: A `scale_in` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['LinuxVirtualMachineScaleSetSecretArgs', 'LinuxVirtualMachineScaleSetSecretArgsDict']]]] secrets: One or more `secret` blocks as defined below.
        :param pulumi.Input[_builtins.bool] secure_boot_enabled: Specifies whether secure boot should be enabled on the virtual machine. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] single_placement_group: Should this Virtual Machine Scale Set be limited to a Single Placement Group, which means the number of instances will be capped at 100 Virtual Machines. Defaults to `true`.
        :param pulumi.Input[_builtins.str] sku: The Virtual Machine SKU for the Scale Set, such as `Standard_F2`.
        :param pulumi.Input[_builtins.str] source_image_id: The ID of an Image which each Virtual Machine in this Scale Set should be based on. Possible Image ID types include `Image ID`, `Shared Image ID`, `Shared Image Version ID`, `Community Gallery Image ID`, `Community Gallery Image Version ID`, `Shared Gallery Image ID` and `Shared Gallery Image Version ID`.
               
               > **Note:** One of either `source_image_id` or `source_image_reference` must be set.
        :param pulumi.Input[Union['LinuxVirtualMachineScaleSetSourceImageReferenceArgs', 'LinuxVirtualMachineScaleSetSourceImageReferenceArgsDict']] source_image_reference: A `source_image_reference` block as defined below.
               
               > **Note:** One of either `source_image_id` or `source_image_reference` must be set.
        :param pulumi.Input[Union['LinuxVirtualMachineScaleSetSpotRestoreArgs', 'LinuxVirtualMachineScaleSetSpotRestoreArgsDict']] spot_restore: A `spot_restore` block as defined below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to this Virtual Machine Scale Set.
        :param pulumi.Input[Union['LinuxVirtualMachineScaleSetTerminationNotificationArgs', 'LinuxVirtualMachineScaleSetTerminationNotificationArgsDict']] termination_notification: A `termination_notification` block as defined below.
        :param pulumi.Input[_builtins.str] unique_id: The Unique ID for this Linux Virtual Machine Scale Set.
        :param pulumi.Input[_builtins.str] user_data: The Base64-Encoded User Data which should be used for this Virtual Machine Scale Set.
        :param pulumi.Input[_builtins.bool] vtpm_enabled: Specifies whether vTPM should be enabled on the virtual machine. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] zone_balance: Should the Virtual Machines in this Scale Set be strictly evenly distributed across Availability Zones? Defaults to `false`. Changing this forces a new resource to be created.
               
               > **Note:** This can only be set to `true` when one or more `zones` are configured.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] zones: Specifies a list of Availability Zones in which this Linux Virtual Machine Scale Set should be located.
               
               > **Note:** Updating `zones` to remove an existing zone forces a new Virtual Machine Scale Set to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LinuxVirtualMachineScaleSetState.__new__(_LinuxVirtualMachineScaleSetState)

        __props__.__dict__["additional_capabilities"] = additional_capabilities
        __props__.__dict__["admin_password"] = admin_password
        __props__.__dict__["admin_ssh_keys"] = admin_ssh_keys
        __props__.__dict__["admin_username"] = admin_username
        __props__.__dict__["automatic_instance_repair"] = automatic_instance_repair
        __props__.__dict__["automatic_os_upgrade_policy"] = automatic_os_upgrade_policy
        __props__.__dict__["boot_diagnostics"] = boot_diagnostics
        __props__.__dict__["capacity_reservation_group_id"] = capacity_reservation_group_id
        __props__.__dict__["computer_name_prefix"] = computer_name_prefix
        __props__.__dict__["custom_data"] = custom_data
        __props__.__dict__["data_disks"] = data_disks
        __props__.__dict__["disable_password_authentication"] = disable_password_authentication
        __props__.__dict__["do_not_run_extensions_on_overprovisioned_machines"] = do_not_run_extensions_on_overprovisioned_machines
        __props__.__dict__["edge_zone"] = edge_zone
        __props__.__dict__["encryption_at_host_enabled"] = encryption_at_host_enabled
        __props__.__dict__["eviction_policy"] = eviction_policy
        __props__.__dict__["extension_operations_enabled"] = extension_operations_enabled
        __props__.__dict__["extensions"] = extensions
        __props__.__dict__["extensions_time_budget"] = extensions_time_budget
        __props__.__dict__["gallery_applications"] = gallery_applications
        __props__.__dict__["health_probe_id"] = health_probe_id
        __props__.__dict__["host_group_id"] = host_group_id
        __props__.__dict__["identity"] = identity
        __props__.__dict__["instances"] = instances
        __props__.__dict__["location"] = location
        __props__.__dict__["max_bid_price"] = max_bid_price
        __props__.__dict__["name"] = name
        __props__.__dict__["network_interfaces"] = network_interfaces
        __props__.__dict__["os_disk"] = os_disk
        __props__.__dict__["overprovision"] = overprovision
        __props__.__dict__["plan"] = plan
        __props__.__dict__["platform_fault_domain_count"] = platform_fault_domain_count
        __props__.__dict__["priority"] = priority
        __props__.__dict__["provision_vm_agent"] = provision_vm_agent
        __props__.__dict__["proximity_placement_group_id"] = proximity_placement_group_id
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["rolling_upgrade_policy"] = rolling_upgrade_policy
        __props__.__dict__["scale_in"] = scale_in
        __props__.__dict__["secrets"] = secrets
        __props__.__dict__["secure_boot_enabled"] = secure_boot_enabled
        __props__.__dict__["single_placement_group"] = single_placement_group
        __props__.__dict__["sku"] = sku
        __props__.__dict__["source_image_id"] = source_image_id
        __props__.__dict__["source_image_reference"] = source_image_reference
        __props__.__dict__["spot_restore"] = spot_restore
        __props__.__dict__["tags"] = tags
        __props__.__dict__["termination_notification"] = termination_notification
        __props__.__dict__["unique_id"] = unique_id
        __props__.__dict__["upgrade_mode"] = upgrade_mode
        __props__.__dict__["user_data"] = user_data
        __props__.__dict__["vtpm_enabled"] = vtpm_enabled
        __props__.__dict__["zone_balance"] = zone_balance
        __props__.__dict__["zones"] = zones
        return LinuxVirtualMachineScaleSet(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="additionalCapabilities")
    def additional_capabilities(self) -> pulumi.Output[Optional['outputs.LinuxVirtualMachineScaleSetAdditionalCapabilities']]:
        """
        An `additional_capabilities` block as defined below.
        """
        return pulumi.get(self, "additional_capabilities")

    @_builtins.property
    @pulumi.getter(name="adminPassword")
    def admin_password(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The Password which should be used for the local-administrator on this Virtual Machine. Changing this forces a new resource to be created.

        > **Note:** When an `admin_password` is specified `disable_password_authentication` must be set to `false`.

        > **Note:** One of either `admin_password` or `admin_ssh_key` must be specified.
        """
        return pulumi.get(self, "admin_password")

    @_builtins.property
    @pulumi.getter(name="adminSshKeys")
    def admin_ssh_keys(self) -> pulumi.Output[Optional[Sequence['outputs.LinuxVirtualMachineScaleSetAdminSshKey']]]:
        """
        One or more `admin_ssh_key` blocks as defined below.

        > **Note:** One of either `admin_password` or `admin_ssh_key` must be specified.
        """
        return pulumi.get(self, "admin_ssh_keys")

    @_builtins.property
    @pulumi.getter(name="adminUsername")
    def admin_username(self) -> pulumi.Output[_builtins.str]:
        """
        The username of the local administrator on each Virtual Machine Scale Set instance. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "admin_username")

    @_builtins.property
    @pulumi.getter(name="automaticInstanceRepair")
    def automatic_instance_repair(self) -> pulumi.Output['outputs.LinuxVirtualMachineScaleSetAutomaticInstanceRepair']:
        """
        An `automatic_instance_repair` block as defined below. To enable the automatic instance repair, this Virtual Machine Scale Set must have a valid `health_probe_id` or an [Application Health Extension](https://docs.microsoft.com/azure/virtual-machine-scale-sets/virtual-machine-scale-sets-health-extension).

        > **Note:** For more information about Automatic Instance Repair, please refer to the [product documentation](https://docs.microsoft.com/azure/virtual-machine-scale-sets/virtual-machine-scale-sets-automatic-instance-repairs).
        """
        return pulumi.get(self, "automatic_instance_repair")

    @_builtins.property
    @pulumi.getter(name="automaticOsUpgradePolicy")
    def automatic_os_upgrade_policy(self) -> pulumi.Output[Optional['outputs.LinuxVirtualMachineScaleSetAutomaticOsUpgradePolicy']]:
        """
        An `automatic_os_upgrade_policy` block as defined below. This can only be specified when `upgrade_mode` is set to either `Automatic` or `Rolling`.
        """
        return pulumi.get(self, "automatic_os_upgrade_policy")

    @_builtins.property
    @pulumi.getter(name="bootDiagnostics")
    def boot_diagnostics(self) -> pulumi.Output[Optional['outputs.LinuxVirtualMachineScaleSetBootDiagnostics']]:
        """
        A `boot_diagnostics` block as defined below.
        """
        return pulumi.get(self, "boot_diagnostics")

    @_builtins.property
    @pulumi.getter(name="capacityReservationGroupId")
    def capacity_reservation_group_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the ID of the Capacity Reservation Group which the Virtual Machine Scale Set should be allocated to. Changing this forces a new resource to be created.

        > **Note:** `capacity_reservation_group_id` cannot be used with `proximity_placement_group_id`

        > **Note:** `single_placement_group` must be set to `false` when `capacity_reservation_group_id` is specified.
        """
        return pulumi.get(self, "capacity_reservation_group_id")

    @_builtins.property
    @pulumi.getter(name="computerNamePrefix")
    def computer_name_prefix(self) -> pulumi.Output[_builtins.str]:
        """
        The prefix which should be used for the name of the Virtual Machines in this Scale Set. If unspecified this defaults to the value for the `name` field. If the value of the `name` field is not a valid `computer_name_prefix`, then you must specify `computer_name_prefix`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "computer_name_prefix")

    @_builtins.property
    @pulumi.getter(name="customData")
    def custom_data(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The Base64-Encoded Custom Data which should be used for this Virtual Machine Scale Set.

        > **Note:** When Custom Data has been configured, it's not possible to remove it without tainting the Virtual Machine Scale Set, due to a limitation of the Azure API.
        """
        return pulumi.get(self, "custom_data")

    @_builtins.property
    @pulumi.getter(name="dataDisks")
    def data_disks(self) -> pulumi.Output[Optional[Sequence['outputs.LinuxVirtualMachineScaleSetDataDisk']]]:
        """
        One or more `data_disk` blocks as defined below.
        """
        return pulumi.get(self, "data_disks")

    @_builtins.property
    @pulumi.getter(name="disablePasswordAuthentication")
    def disable_password_authentication(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Should Password Authentication be disabled on this Virtual Machine Scale Set? Defaults to `true`.

        > **Note:** In general we'd recommend using SSH Keys for authentication rather than Passwords - but there's tradeoff's to each - please [see this thread for more information](https://security.stackexchange.com/questions/69407/why-is-using-an-ssh-key-more-secure-than-using-passwords).

        > **Note:** When a `admin_password` is specified `disable_password_authentication` must be set to `false`.
        """
        return pulumi.get(self, "disable_password_authentication")

    @_builtins.property
    @pulumi.getter(name="doNotRunExtensionsOnOverprovisionedMachines")
    def do_not_run_extensions_on_overprovisioned_machines(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Should Virtual Machine Extensions be run on Overprovisioned Virtual Machines in the Scale Set? Defaults to `false`.
        """
        return pulumi.get(self, "do_not_run_extensions_on_overprovisioned_machines")

    @_builtins.property
    @pulumi.getter(name="edgeZone")
    def edge_zone(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the Edge Zone within the Azure Region where this Linux Virtual Machine Scale Set should exist. Changing this forces a new Linux Virtual Machine Scale Set to be created.
        """
        return pulumi.get(self, "edge_zone")

    @_builtins.property
    @pulumi.getter(name="encryptionAtHostEnabled")
    def encryption_at_host_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Should all of the disks (including the temp disk) attached to this Virtual Machine be encrypted by enabling Encryption at Host?
        """
        return pulumi.get(self, "encryption_at_host_enabled")

    @_builtins.property
    @pulumi.getter(name="evictionPolicy")
    def eviction_policy(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the eviction policy for Virtual Machines in this Scale Set. Possible values are `Deallocate` and `Delete`. Changing this forces a new resource to be created.

        > **Note:** This can only be configured when `priority` is set to `Spot`.
        """
        return pulumi.get(self, "eviction_policy")

    @_builtins.property
    @pulumi.getter(name="extensionOperationsEnabled")
    def extension_operations_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Should extension operations be allowed on the Virtual Machine Scale Set? Possible values are `true` or `false`. Defaults to `true`. Changing this forces a new Linux Virtual Machine Scale Set to be created.

        > **Note:** `extension_operations_enabled` may only be set to `false` if there are no extensions defined in the `extension` field.
        """
        return pulumi.get(self, "extension_operations_enabled")

    @_builtins.property
    @pulumi.getter
    def extensions(self) -> pulumi.Output[Sequence['outputs.LinuxVirtualMachineScaleSetExtension']]:
        """
        One or more `extension` blocks as defined below
        """
        return pulumi.get(self, "extensions")

    @_builtins.property
    @pulumi.getter(name="extensionsTimeBudget")
    def extensions_time_budget(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the duration allocated for all extensions to start. The time duration should be between `15` minutes and `120` minutes (inclusive) and should be specified in ISO 8601 format. Defaults to `PT1H30M`.
        """
        return pulumi.get(self, "extensions_time_budget")

    @_builtins.property
    @pulumi.getter(name="galleryApplications")
    def gallery_applications(self) -> pulumi.Output[Optional[Sequence['outputs.LinuxVirtualMachineScaleSetGalleryApplication']]]:
        """
        One or more `gallery_application` blocks as defined below.
        """
        return pulumi.get(self, "gallery_applications")

    @_builtins.property
    @pulumi.getter(name="healthProbeId")
    def health_probe_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of a Load Balancer Probe which should be used to determine the health of an instance. This is Required and can only be specified when `upgrade_mode` is set to `Automatic` or `Rolling`.
        """
        return pulumi.get(self, "health_probe_id")

    @_builtins.property
    @pulumi.getter(name="hostGroupId")
    def host_group_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the ID of the dedicated host group that the virtual machine scale set resides in. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "host_group_id")

    @_builtins.property
    @pulumi.getter
    def identity(self) -> pulumi.Output[Optional['outputs.LinuxVirtualMachineScaleSetIdentity']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @_builtins.property
    @pulumi.getter
    def instances(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The number of Virtual Machines in the Scale Set. Defaults to `0`.

        > **NOTE:** If you're using AutoScaling, you may wish to use [`Ignore Changes` functionality](https://www.pulumi.com/docs/intro/concepts/programming-model/#ignorechanges) to ignore changes to this field.
        """
        return pulumi.get(self, "instances")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        The Azure location where the Linux Virtual Machine Scale Set should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter(name="maxBidPrice")
    def max_bid_price(self) -> pulumi.Output[Optional[_builtins.float]]:
        """
        The maximum price you're willing to pay for each Virtual Machine in this Scale Set, in US Dollars; which must be greater than the current spot price. If this bid price falls below the current spot price the Virtual Machines in the Scale Set will be evicted using the `eviction_policy`. Defaults to `-1`, which means that each Virtual Machine in this Scale Set should not be evicted for price reasons.

        > **Note:** This can only be configured when `priority` is set to `Spot`.
        """
        return pulumi.get(self, "max_bid_price")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Linux Virtual Machine Scale Set. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="networkInterfaces")
    def network_interfaces(self) -> pulumi.Output[Sequence['outputs.LinuxVirtualMachineScaleSetNetworkInterface']]:
        """
        One or more `network_interface` blocks as defined below.
        """
        return pulumi.get(self, "network_interfaces")

    @_builtins.property
    @pulumi.getter(name="osDisk")
    def os_disk(self) -> pulumi.Output['outputs.LinuxVirtualMachineScaleSetOsDisk']:
        """
        An `os_disk` block as defined below.
        """
        return pulumi.get(self, "os_disk")

    @_builtins.property
    @pulumi.getter
    def overprovision(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Should Azure over-provision Virtual Machines in this Scale Set? This means that multiple Virtual Machines will be provisioned and Azure will keep the instances which become available first - which improves provisioning success rates and improves deployment time. You're not billed for these over-provisioned VM's and they don't count towards the Subscription Quota. Defaults to `true`.
        """
        return pulumi.get(self, "overprovision")

    @_builtins.property
    @pulumi.getter
    def plan(self) -> pulumi.Output[Optional['outputs.LinuxVirtualMachineScaleSetPlan']]:
        """
        A `plan` block as defined below. Changing this forces a new resource to be created.

        > **Note:** When using an image from Azure Marketplace a `plan` must be specified.
        """
        return pulumi.get(self, "plan")

    @_builtins.property
    @pulumi.getter(name="platformFaultDomainCount")
    def platform_fault_domain_count(self) -> pulumi.Output[_builtins.int]:
        """
        Specifies the number of fault domains that are used by this Linux Virtual Machine Scale Set. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "platform_fault_domain_count")

    @_builtins.property
    @pulumi.getter
    def priority(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The Priority of this Virtual Machine Scale Set. Possible values are `Regular` and `Spot`. Defaults to `Regular`. Changing this value forces a new resource.

        > **Note:** When `priority` is set to `Spot` an `eviction_policy` must be specified.
        """
        return pulumi.get(self, "priority")

    @_builtins.property
    @pulumi.getter(name="provisionVmAgent")
    def provision_vm_agent(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Should the Azure VM Agent be provisioned on each Virtual Machine in the Scale Set? Defaults to `true`. Changing this value forces a new resource to be created.
        """
        return pulumi.get(self, "provision_vm_agent")

    @_builtins.property
    @pulumi.getter(name="proximityPlacementGroupId")
    def proximity_placement_group_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the Proximity Placement Group in which the Virtual Machine Scale Set should be assigned to. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "proximity_placement_group_id")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Resource Group in which the Linux Virtual Machine Scale Set should be exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter(name="rollingUpgradePolicy")
    def rolling_upgrade_policy(self) -> pulumi.Output[Optional['outputs.LinuxVirtualMachineScaleSetRollingUpgradePolicy']]:
        """
        A `rolling_upgrade_policy` block as defined below. This is Required and can only be specified when `upgrade_mode` is set to `Automatic` or `Rolling`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "rolling_upgrade_policy")

    @_builtins.property
    @pulumi.getter(name="scaleIn")
    def scale_in(self) -> pulumi.Output[Optional['outputs.LinuxVirtualMachineScaleSetScaleIn']]:
        """
        A `scale_in` block as defined below.
        """
        return pulumi.get(self, "scale_in")

    @_builtins.property
    @pulumi.getter
    def secrets(self) -> pulumi.Output[Optional[Sequence['outputs.LinuxVirtualMachineScaleSetSecret']]]:
        """
        One or more `secret` blocks as defined below.
        """
        return pulumi.get(self, "secrets")

    @_builtins.property
    @pulumi.getter(name="secureBootEnabled")
    def secure_boot_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether secure boot should be enabled on the virtual machine. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "secure_boot_enabled")

    @_builtins.property
    @pulumi.getter(name="singlePlacementGroup")
    def single_placement_group(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Should this Virtual Machine Scale Set be limited to a Single Placement Group, which means the number of instances will be capped at 100 Virtual Machines. Defaults to `true`.
        """
        return pulumi.get(self, "single_placement_group")

    @_builtins.property
    @pulumi.getter
    def sku(self) -> pulumi.Output[_builtins.str]:
        """
        The Virtual Machine SKU for the Scale Set, such as `Standard_F2`.
        """
        return pulumi.get(self, "sku")

    @_builtins.property
    @pulumi.getter(name="sourceImageId")
    def source_image_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of an Image which each Virtual Machine in this Scale Set should be based on. Possible Image ID types include `Image ID`, `Shared Image ID`, `Shared Image Version ID`, `Community Gallery Image ID`, `Community Gallery Image Version ID`, `Shared Gallery Image ID` and `Shared Gallery Image Version ID`.

        > **Note:** One of either `source_image_id` or `source_image_reference` must be set.
        """
        return pulumi.get(self, "source_image_id")

    @_builtins.property
    @pulumi.getter(name="sourceImageReference")
    def source_image_reference(self) -> pulumi.Output[Optional['outputs.LinuxVirtualMachineScaleSetSourceImageReference']]:
        """
        A `source_image_reference` block as defined below.

        > **Note:** One of either `source_image_id` or `source_image_reference` must be set.
        """
        return pulumi.get(self, "source_image_reference")

    @_builtins.property
    @pulumi.getter(name="spotRestore")
    def spot_restore(self) -> pulumi.Output['outputs.LinuxVirtualMachineScaleSetSpotRestore']:
        """
        A `spot_restore` block as defined below.
        """
        return pulumi.get(self, "spot_restore")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags which should be assigned to this Virtual Machine Scale Set.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="terminationNotification")
    def termination_notification(self) -> pulumi.Output['outputs.LinuxVirtualMachineScaleSetTerminationNotification']:
        """
        A `termination_notification` block as defined below.
        """
        return pulumi.get(self, "termination_notification")

    @_builtins.property
    @pulumi.getter(name="uniqueId")
    def unique_id(self) -> pulumi.Output[_builtins.str]:
        """
        The Unique ID for this Linux Virtual Machine Scale Set.
        """
        return pulumi.get(self, "unique_id")

    @_builtins.property
    @pulumi.getter(name="upgradeMode")
    def upgrade_mode(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "upgrade_mode")

    @_builtins.property
    @pulumi.getter(name="userData")
    def user_data(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The Base64-Encoded User Data which should be used for this Virtual Machine Scale Set.
        """
        return pulumi.get(self, "user_data")

    @_builtins.property
    @pulumi.getter(name="vtpmEnabled")
    def vtpm_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether vTPM should be enabled on the virtual machine. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "vtpm_enabled")

    @_builtins.property
    @pulumi.getter(name="zoneBalance")
    def zone_balance(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Should the Virtual Machines in this Scale Set be strictly evenly distributed across Availability Zones? Defaults to `false`. Changing this forces a new resource to be created.

        > **Note:** This can only be set to `true` when one or more `zones` are configured.
        """
        return pulumi.get(self, "zone_balance")

    @_builtins.property
    @pulumi.getter
    def zones(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Specifies a list of Availability Zones in which this Linux Virtual Machine Scale Set should be located.

        > **Note:** Updating `zones` to remove an existing zone forces a new Virtual Machine Scale Set to be created.
        """
        return pulumi.get(self, "zones")

