# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetApiConnectionResult',
    'AwaitableGetApiConnectionResult',
    'get_api_connection',
    'get_api_connection_output',
]

@pulumi.output_type
class GetApiConnectionResult:
    """
    A collection of values returned by getApiConnection.
    """
    def __init__(__self__, display_name=None, id=None, location=None, managed_api_id=None, name=None, parameter_values=None, resource_group_name=None, tags=None):
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if managed_api_id and not isinstance(managed_api_id, str):
            raise TypeError("Expected argument 'managed_api_id' to be a str")
        pulumi.set(__self__, "managed_api_id", managed_api_id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if parameter_values and not isinstance(parameter_values, dict):
            raise TypeError("Expected argument 'parameter_values' to be a dict")
        pulumi.set(__self__, "parameter_values", parameter_values)
        if resource_group_name and not isinstance(resource_group_name, str):
            raise TypeError("Expected argument 'resource_group_name' to be a str")
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        The display name of the API Connection.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def location(self) -> _builtins.str:
        """
        The Azure Region where the API Connection exists.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter(name="managedApiId")
    def managed_api_id(self) -> _builtins.str:
        """
        The ID of the Managed API that this connection is linked to.
        """
        return pulumi.get(self, "managed_api_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="parameterValues")
    def parameter_values(self) -> Mapping[str, _builtins.str]:
        """
        A mapping of parameter names to their values for the API Connection.
        """
        return pulumi.get(self, "parameter_values")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> _builtins.str:
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        A mapping of tags assigned to the API Connection.
        """
        return pulumi.get(self, "tags")


class AwaitableGetApiConnectionResult(GetApiConnectionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetApiConnectionResult(
            display_name=self.display_name,
            id=self.id,
            location=self.location,
            managed_api_id=self.managed_api_id,
            name=self.name,
            parameter_values=self.parameter_values,
            resource_group_name=self.resource_group_name,
            tags=self.tags)


def get_api_connection(name: Optional[_builtins.str] = None,
                       resource_group_name: Optional[_builtins.str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetApiConnectionResult:
    """
    Use this data source to access information about an existing API Connection.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.connections.get_api_connection(name="example-connection",
        resource_group_name="example-resources")
    pulumi.export("connectionId", example.id)
    pulumi.export("connectionName", example.name)
    pulumi.export("managedApiId", example.managed_api_id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.Web` - 2016-06-01


    :param _builtins.str name: The name of the API Connection.
    :param _builtins.str resource_group_name: The name of the Resource Group where the API Connection exists.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:connections/getApiConnection:getApiConnection', __args__, opts=opts, typ=GetApiConnectionResult).value

    return AwaitableGetApiConnectionResult(
        display_name=pulumi.get(__ret__, 'display_name'),
        id=pulumi.get(__ret__, 'id'),
        location=pulumi.get(__ret__, 'location'),
        managed_api_id=pulumi.get(__ret__, 'managed_api_id'),
        name=pulumi.get(__ret__, 'name'),
        parameter_values=pulumi.get(__ret__, 'parameter_values'),
        resource_group_name=pulumi.get(__ret__, 'resource_group_name'),
        tags=pulumi.get(__ret__, 'tags'))
def get_api_connection_output(name: Optional[pulumi.Input[_builtins.str]] = None,
                              resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetApiConnectionResult]:
    """
    Use this data source to access information about an existing API Connection.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.connections.get_api_connection(name="example-connection",
        resource_group_name="example-resources")
    pulumi.export("connectionId", example.id)
    pulumi.export("connectionName", example.name)
    pulumi.export("managedApiId", example.managed_api_id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.Web` - 2016-06-01


    :param _builtins.str name: The name of the API Connection.
    :param _builtins.str resource_group_name: The name of the Resource Group where the API Connection exists.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:connections/getApiConnection:getApiConnection', __args__, opts=opts, typ=GetApiConnectionResult)
    return __ret__.apply(lambda __response__: GetApiConnectionResult(
        display_name=pulumi.get(__response__, 'display_name'),
        id=pulumi.get(__response__, 'id'),
        location=pulumi.get(__response__, 'location'),
        managed_api_id=pulumi.get(__response__, 'managed_api_id'),
        name=pulumi.get(__response__, 'name'),
        parameter_values=pulumi.get(__response__, 'parameter_values'),
        resource_group_name=pulumi.get(__response__, 'resource_group_name'),
        tags=pulumi.get(__response__, 'tags')))
