# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['EnvironmentArgs', 'Environment']

@pulumi.input_type
class EnvironmentArgs:
    def __init__(__self__, *,
                 resource_group_name: pulumi.Input[_builtins.str],
                 dapr_application_insights_connection_string: Optional[pulumi.Input[_builtins.str]] = None,
                 identity: Optional[pulumi.Input['EnvironmentIdentityArgs']] = None,
                 infrastructure_resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 infrastructure_subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 internal_load_balancer_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 log_analytics_workspace_id: Optional[pulumi.Input[_builtins.str]] = None,
                 logs_destination: Optional[pulumi.Input[_builtins.str]] = None,
                 mutual_tls_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 workload_profiles: Optional[pulumi.Input[Sequence[pulumi.Input['EnvironmentWorkloadProfileArgs']]]] = None,
                 zone_redundancy_enabled: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a Environment resource.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which the Container App Environment is to be created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] dapr_application_insights_connection_string: Application Insights connection string used by Dapr to export Service to Service communication telemetry. Changing this forces a new resource to be created.
        :param pulumi.Input['EnvironmentIdentityArgs'] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.str] infrastructure_resource_group_name: Name of the platform-managed resource group created for the Managed Environment to host infrastructure resources. Changing this forces a new resource to be created.
               
               > **Note:** Only valid if a `workload_profile` is specified. If `infrastructure_subnet_id` is specified, this resource group will be created in the same subscription as `infrastructure_subnet_id`.
        :param pulumi.Input[_builtins.str] infrastructure_subnet_id: The existing Subnet to use for the Container Apps Control Plane. Changing this forces a new resource to be created. 
               
               > **Note:** The Subnet must have a `/21` or larger address space.
        :param pulumi.Input[_builtins.bool] internal_load_balancer_enabled: Should the Container Environment operate in Internal Load Balancing Mode? Defaults to `false`. Changing this forces a new resource to be created.
               
               > **Note:** can only be set to `true` if `infrastructure_subnet_id` is specified.
        :param pulumi.Input[_builtins.str] location: Specifies the supported Azure location where the Container App Environment is to exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] log_analytics_workspace_id: The ID for the Log Analytics Workspace to link this Container Apps Managed Environment to. 
               
               > **Note:** required if `logs_destination` is set to `log-analytics`. Cannot be set if `logs_destination` is set to `azure-monitor`.
        :param pulumi.Input[_builtins.str] logs_destination: Where the application logs will be saved for this Container Apps Managed Environment. Possible values include `log-analytics` and `azure-monitor`. Omitting this value will result in logs being streamed only.
        :param pulumi.Input[_builtins.bool] mutual_tls_enabled: Should mutual transport layer security (mTLS) be enabled? Defaults to `false`.
               
               > **Note:** This feature is in public preview. Enabling mTLS for your applications may increase response latency and reduce maximum throughput in high-load scenarios.
        :param pulumi.Input[_builtins.str] name: The name of the Container Apps Managed Environment. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[Sequence[pulumi.Input['EnvironmentWorkloadProfileArgs']]] workload_profiles: One or more `workload_profile` blocks as defined below.
        :param pulumi.Input[_builtins.bool] zone_redundancy_enabled: Should the Container App Environment be created with Zone Redundancy enabled? Defaults to `false`. Changing this forces a new resource to be created.
               
               > **Note:** can only be set to `true` if `infrastructure_subnet_id` is specified.
        """
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if dapr_application_insights_connection_string is not None:
            pulumi.set(__self__, "dapr_application_insights_connection_string", dapr_application_insights_connection_string)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if infrastructure_resource_group_name is not None:
            pulumi.set(__self__, "infrastructure_resource_group_name", infrastructure_resource_group_name)
        if infrastructure_subnet_id is not None:
            pulumi.set(__self__, "infrastructure_subnet_id", infrastructure_subnet_id)
        if internal_load_balancer_enabled is not None:
            pulumi.set(__self__, "internal_load_balancer_enabled", internal_load_balancer_enabled)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if log_analytics_workspace_id is not None:
            pulumi.set(__self__, "log_analytics_workspace_id", log_analytics_workspace_id)
        if logs_destination is not None:
            pulumi.set(__self__, "logs_destination", logs_destination)
        if mutual_tls_enabled is not None:
            pulumi.set(__self__, "mutual_tls_enabled", mutual_tls_enabled)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if workload_profiles is not None:
            pulumi.set(__self__, "workload_profiles", workload_profiles)
        if zone_redundancy_enabled is not None:
            pulumi.set(__self__, "zone_redundancy_enabled", zone_redundancy_enabled)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the resource group in which the Container App Environment is to be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="daprApplicationInsightsConnectionString")
    def dapr_application_insights_connection_string(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Application Insights connection string used by Dapr to export Service to Service communication telemetry. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "dapr_application_insights_connection_string")

    @dapr_application_insights_connection_string.setter
    def dapr_application_insights_connection_string(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dapr_application_insights_connection_string", value)

    @_builtins.property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['EnvironmentIdentityArgs']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['EnvironmentIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @_builtins.property
    @pulumi.getter(name="infrastructureResourceGroupName")
    def infrastructure_resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the platform-managed resource group created for the Managed Environment to host infrastructure resources. Changing this forces a new resource to be created.

        > **Note:** Only valid if a `workload_profile` is specified. If `infrastructure_subnet_id` is specified, this resource group will be created in the same subscription as `infrastructure_subnet_id`.
        """
        return pulumi.get(self, "infrastructure_resource_group_name")

    @infrastructure_resource_group_name.setter
    def infrastructure_resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "infrastructure_resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="infrastructureSubnetId")
    def infrastructure_subnet_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The existing Subnet to use for the Container Apps Control Plane. Changing this forces a new resource to be created. 

        > **Note:** The Subnet must have a `/21` or larger address space.
        """
        return pulumi.get(self, "infrastructure_subnet_id")

    @infrastructure_subnet_id.setter
    def infrastructure_subnet_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "infrastructure_subnet_id", value)

    @_builtins.property
    @pulumi.getter(name="internalLoadBalancerEnabled")
    def internal_load_balancer_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should the Container Environment operate in Internal Load Balancing Mode? Defaults to `false`. Changing this forces a new resource to be created.

        > **Note:** can only be set to `true` if `infrastructure_subnet_id` is specified.
        """
        return pulumi.get(self, "internal_load_balancer_enabled")

    @internal_load_balancer_enabled.setter
    def internal_load_balancer_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "internal_load_balancer_enabled", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the supported Azure location where the Container App Environment is to exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="logAnalyticsWorkspaceId")
    def log_analytics_workspace_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID for the Log Analytics Workspace to link this Container Apps Managed Environment to. 

        > **Note:** required if `logs_destination` is set to `log-analytics`. Cannot be set if `logs_destination` is set to `azure-monitor`.
        """
        return pulumi.get(self, "log_analytics_workspace_id")

    @log_analytics_workspace_id.setter
    def log_analytics_workspace_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "log_analytics_workspace_id", value)

    @_builtins.property
    @pulumi.getter(name="logsDestination")
    def logs_destination(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Where the application logs will be saved for this Container Apps Managed Environment. Possible values include `log-analytics` and `azure-monitor`. Omitting this value will result in logs being streamed only.
        """
        return pulumi.get(self, "logs_destination")

    @logs_destination.setter
    def logs_destination(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "logs_destination", value)

    @_builtins.property
    @pulumi.getter(name="mutualTlsEnabled")
    def mutual_tls_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should mutual transport layer security (mTLS) be enabled? Defaults to `false`.

        > **Note:** This feature is in public preview. Enabling mTLS for your applications may increase response latency and reduce maximum throughput in high-load scenarios.
        """
        return pulumi.get(self, "mutual_tls_enabled")

    @mutual_tls_enabled.setter
    def mutual_tls_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "mutual_tls_enabled", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Container Apps Managed Environment. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="workloadProfiles")
    def workload_profiles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EnvironmentWorkloadProfileArgs']]]]:
        """
        One or more `workload_profile` blocks as defined below.
        """
        return pulumi.get(self, "workload_profiles")

    @workload_profiles.setter
    def workload_profiles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EnvironmentWorkloadProfileArgs']]]]):
        pulumi.set(self, "workload_profiles", value)

    @_builtins.property
    @pulumi.getter(name="zoneRedundancyEnabled")
    def zone_redundancy_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should the Container App Environment be created with Zone Redundancy enabled? Defaults to `false`. Changing this forces a new resource to be created.

        > **Note:** can only be set to `true` if `infrastructure_subnet_id` is specified.
        """
        return pulumi.get(self, "zone_redundancy_enabled")

    @zone_redundancy_enabled.setter
    def zone_redundancy_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "zone_redundancy_enabled", value)


@pulumi.input_type
class _EnvironmentState:
    def __init__(__self__, *,
                 custom_domain_verification_id: Optional[pulumi.Input[_builtins.str]] = None,
                 dapr_application_insights_connection_string: Optional[pulumi.Input[_builtins.str]] = None,
                 default_domain: Optional[pulumi.Input[_builtins.str]] = None,
                 docker_bridge_cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 identity: Optional[pulumi.Input['EnvironmentIdentityArgs']] = None,
                 infrastructure_resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 infrastructure_subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 internal_load_balancer_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 log_analytics_workspace_id: Optional[pulumi.Input[_builtins.str]] = None,
                 logs_destination: Optional[pulumi.Input[_builtins.str]] = None,
                 mutual_tls_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 platform_reserved_cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 platform_reserved_dns_ip_address: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 static_ip_address: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 workload_profiles: Optional[pulumi.Input[Sequence[pulumi.Input['EnvironmentWorkloadProfileArgs']]]] = None,
                 zone_redundancy_enabled: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        Input properties used for looking up and filtering Environment resources.
        :param pulumi.Input[_builtins.str] custom_domain_verification_id: The ID of the Custom Domain Verification for this Container App Environment.
        :param pulumi.Input[_builtins.str] dapr_application_insights_connection_string: Application Insights connection string used by Dapr to export Service to Service communication telemetry. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] default_domain: The default, publicly resolvable, name of this Container App Environment.
        :param pulumi.Input[_builtins.str] docker_bridge_cidr: The network addressing in which the Container Apps in this Container App Environment will reside in CIDR notation.
        :param pulumi.Input['EnvironmentIdentityArgs'] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.str] infrastructure_resource_group_name: Name of the platform-managed resource group created for the Managed Environment to host infrastructure resources. Changing this forces a new resource to be created.
               
               > **Note:** Only valid if a `workload_profile` is specified. If `infrastructure_subnet_id` is specified, this resource group will be created in the same subscription as `infrastructure_subnet_id`.
        :param pulumi.Input[_builtins.str] infrastructure_subnet_id: The existing Subnet to use for the Container Apps Control Plane. Changing this forces a new resource to be created. 
               
               > **Note:** The Subnet must have a `/21` or larger address space.
        :param pulumi.Input[_builtins.bool] internal_load_balancer_enabled: Should the Container Environment operate in Internal Load Balancing Mode? Defaults to `false`. Changing this forces a new resource to be created.
               
               > **Note:** can only be set to `true` if `infrastructure_subnet_id` is specified.
        :param pulumi.Input[_builtins.str] location: Specifies the supported Azure location where the Container App Environment is to exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] log_analytics_workspace_id: The ID for the Log Analytics Workspace to link this Container Apps Managed Environment to. 
               
               > **Note:** required if `logs_destination` is set to `log-analytics`. Cannot be set if `logs_destination` is set to `azure-monitor`.
        :param pulumi.Input[_builtins.str] logs_destination: Where the application logs will be saved for this Container Apps Managed Environment. Possible values include `log-analytics` and `azure-monitor`. Omitting this value will result in logs being streamed only.
        :param pulumi.Input[_builtins.bool] mutual_tls_enabled: Should mutual transport layer security (mTLS) be enabled? Defaults to `false`.
               
               > **Note:** This feature is in public preview. Enabling mTLS for your applications may increase response latency and reduce maximum throughput in high-load scenarios.
        :param pulumi.Input[_builtins.str] name: The name of the Container Apps Managed Environment. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] platform_reserved_cidr: The IP range, in CIDR notation, that is reserved for environment infrastructure IP addresses.
        :param pulumi.Input[_builtins.str] platform_reserved_dns_ip_address: The IP address from the IP range defined by `platform_reserved_cidr` that is reserved for the internal DNS server.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which the Container App Environment is to be created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] static_ip_address: The Static IP address of the Environment.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[Sequence[pulumi.Input['EnvironmentWorkloadProfileArgs']]] workload_profiles: One or more `workload_profile` blocks as defined below.
        :param pulumi.Input[_builtins.bool] zone_redundancy_enabled: Should the Container App Environment be created with Zone Redundancy enabled? Defaults to `false`. Changing this forces a new resource to be created.
               
               > **Note:** can only be set to `true` if `infrastructure_subnet_id` is specified.
        """
        if custom_domain_verification_id is not None:
            pulumi.set(__self__, "custom_domain_verification_id", custom_domain_verification_id)
        if dapr_application_insights_connection_string is not None:
            pulumi.set(__self__, "dapr_application_insights_connection_string", dapr_application_insights_connection_string)
        if default_domain is not None:
            pulumi.set(__self__, "default_domain", default_domain)
        if docker_bridge_cidr is not None:
            pulumi.set(__self__, "docker_bridge_cidr", docker_bridge_cidr)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if infrastructure_resource_group_name is not None:
            pulumi.set(__self__, "infrastructure_resource_group_name", infrastructure_resource_group_name)
        if infrastructure_subnet_id is not None:
            pulumi.set(__self__, "infrastructure_subnet_id", infrastructure_subnet_id)
        if internal_load_balancer_enabled is not None:
            pulumi.set(__self__, "internal_load_balancer_enabled", internal_load_balancer_enabled)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if log_analytics_workspace_id is not None:
            pulumi.set(__self__, "log_analytics_workspace_id", log_analytics_workspace_id)
        if logs_destination is not None:
            pulumi.set(__self__, "logs_destination", logs_destination)
        if mutual_tls_enabled is not None:
            pulumi.set(__self__, "mutual_tls_enabled", mutual_tls_enabled)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if platform_reserved_cidr is not None:
            pulumi.set(__self__, "platform_reserved_cidr", platform_reserved_cidr)
        if platform_reserved_dns_ip_address is not None:
            pulumi.set(__self__, "platform_reserved_dns_ip_address", platform_reserved_dns_ip_address)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if static_ip_address is not None:
            pulumi.set(__self__, "static_ip_address", static_ip_address)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if workload_profiles is not None:
            pulumi.set(__self__, "workload_profiles", workload_profiles)
        if zone_redundancy_enabled is not None:
            pulumi.set(__self__, "zone_redundancy_enabled", zone_redundancy_enabled)

    @_builtins.property
    @pulumi.getter(name="customDomainVerificationId")
    def custom_domain_verification_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Custom Domain Verification for this Container App Environment.
        """
        return pulumi.get(self, "custom_domain_verification_id")

    @custom_domain_verification_id.setter
    def custom_domain_verification_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "custom_domain_verification_id", value)

    @_builtins.property
    @pulumi.getter(name="daprApplicationInsightsConnectionString")
    def dapr_application_insights_connection_string(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Application Insights connection string used by Dapr to export Service to Service communication telemetry. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "dapr_application_insights_connection_string")

    @dapr_application_insights_connection_string.setter
    def dapr_application_insights_connection_string(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dapr_application_insights_connection_string", value)

    @_builtins.property
    @pulumi.getter(name="defaultDomain")
    def default_domain(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The default, publicly resolvable, name of this Container App Environment.
        """
        return pulumi.get(self, "default_domain")

    @default_domain.setter
    def default_domain(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_domain", value)

    @_builtins.property
    @pulumi.getter(name="dockerBridgeCidr")
    def docker_bridge_cidr(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The network addressing in which the Container Apps in this Container App Environment will reside in CIDR notation.
        """
        return pulumi.get(self, "docker_bridge_cidr")

    @docker_bridge_cidr.setter
    def docker_bridge_cidr(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "docker_bridge_cidr", value)

    @_builtins.property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['EnvironmentIdentityArgs']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['EnvironmentIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @_builtins.property
    @pulumi.getter(name="infrastructureResourceGroupName")
    def infrastructure_resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the platform-managed resource group created for the Managed Environment to host infrastructure resources. Changing this forces a new resource to be created.

        > **Note:** Only valid if a `workload_profile` is specified. If `infrastructure_subnet_id` is specified, this resource group will be created in the same subscription as `infrastructure_subnet_id`.
        """
        return pulumi.get(self, "infrastructure_resource_group_name")

    @infrastructure_resource_group_name.setter
    def infrastructure_resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "infrastructure_resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="infrastructureSubnetId")
    def infrastructure_subnet_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The existing Subnet to use for the Container Apps Control Plane. Changing this forces a new resource to be created. 

        > **Note:** The Subnet must have a `/21` or larger address space.
        """
        return pulumi.get(self, "infrastructure_subnet_id")

    @infrastructure_subnet_id.setter
    def infrastructure_subnet_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "infrastructure_subnet_id", value)

    @_builtins.property
    @pulumi.getter(name="internalLoadBalancerEnabled")
    def internal_load_balancer_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should the Container Environment operate in Internal Load Balancing Mode? Defaults to `false`. Changing this forces a new resource to be created.

        > **Note:** can only be set to `true` if `infrastructure_subnet_id` is specified.
        """
        return pulumi.get(self, "internal_load_balancer_enabled")

    @internal_load_balancer_enabled.setter
    def internal_load_balancer_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "internal_load_balancer_enabled", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the supported Azure location where the Container App Environment is to exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="logAnalyticsWorkspaceId")
    def log_analytics_workspace_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID for the Log Analytics Workspace to link this Container Apps Managed Environment to. 

        > **Note:** required if `logs_destination` is set to `log-analytics`. Cannot be set if `logs_destination` is set to `azure-monitor`.
        """
        return pulumi.get(self, "log_analytics_workspace_id")

    @log_analytics_workspace_id.setter
    def log_analytics_workspace_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "log_analytics_workspace_id", value)

    @_builtins.property
    @pulumi.getter(name="logsDestination")
    def logs_destination(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Where the application logs will be saved for this Container Apps Managed Environment. Possible values include `log-analytics` and `azure-monitor`. Omitting this value will result in logs being streamed only.
        """
        return pulumi.get(self, "logs_destination")

    @logs_destination.setter
    def logs_destination(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "logs_destination", value)

    @_builtins.property
    @pulumi.getter(name="mutualTlsEnabled")
    def mutual_tls_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should mutual transport layer security (mTLS) be enabled? Defaults to `false`.

        > **Note:** This feature is in public preview. Enabling mTLS for your applications may increase response latency and reduce maximum throughput in high-load scenarios.
        """
        return pulumi.get(self, "mutual_tls_enabled")

    @mutual_tls_enabled.setter
    def mutual_tls_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "mutual_tls_enabled", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Container Apps Managed Environment. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="platformReservedCidr")
    def platform_reserved_cidr(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IP range, in CIDR notation, that is reserved for environment infrastructure IP addresses.
        """
        return pulumi.get(self, "platform_reserved_cidr")

    @platform_reserved_cidr.setter
    def platform_reserved_cidr(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "platform_reserved_cidr", value)

    @_builtins.property
    @pulumi.getter(name="platformReservedDnsIpAddress")
    def platform_reserved_dns_ip_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IP address from the IP range defined by `platform_reserved_cidr` that is reserved for the internal DNS server.
        """
        return pulumi.get(self, "platform_reserved_dns_ip_address")

    @platform_reserved_dns_ip_address.setter
    def platform_reserved_dns_ip_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "platform_reserved_dns_ip_address", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the resource group in which the Container App Environment is to be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="staticIpAddress")
    def static_ip_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Static IP address of the Environment.
        """
        return pulumi.get(self, "static_ip_address")

    @static_ip_address.setter
    def static_ip_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "static_ip_address", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="workloadProfiles")
    def workload_profiles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EnvironmentWorkloadProfileArgs']]]]:
        """
        One or more `workload_profile` blocks as defined below.
        """
        return pulumi.get(self, "workload_profiles")

    @workload_profiles.setter
    def workload_profiles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EnvironmentWorkloadProfileArgs']]]]):
        pulumi.set(self, "workload_profiles", value)

    @_builtins.property
    @pulumi.getter(name="zoneRedundancyEnabled")
    def zone_redundancy_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should the Container App Environment be created with Zone Redundancy enabled? Defaults to `false`. Changing this forces a new resource to be created.

        > **Note:** can only be set to `true` if `infrastructure_subnet_id` is specified.
        """
        return pulumi.get(self, "zone_redundancy_enabled")

    @zone_redundancy_enabled.setter
    def zone_redundancy_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "zone_redundancy_enabled", value)


@pulumi.type_token("azure:containerapp/environment:Environment")
class Environment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 dapr_application_insights_connection_string: Optional[pulumi.Input[_builtins.str]] = None,
                 identity: Optional[pulumi.Input[Union['EnvironmentIdentityArgs', 'EnvironmentIdentityArgsDict']]] = None,
                 infrastructure_resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 infrastructure_subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 internal_load_balancer_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 log_analytics_workspace_id: Optional[pulumi.Input[_builtins.str]] = None,
                 logs_destination: Optional[pulumi.Input[_builtins.str]] = None,
                 mutual_tls_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 workload_profiles: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EnvironmentWorkloadProfileArgs', 'EnvironmentWorkloadProfileArgsDict']]]]] = None,
                 zone_redundancy_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        Manages a Container App Environment.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_analytics_workspace = azure.operationalinsights.AnalyticsWorkspace("example",
            name="example-workspace",
            location=example.location,
            resource_group_name=example.name,
            sku="PerGB2018",
            retention_in_days=30)
        example_environment = azure.containerapp.Environment("example",
            name="my-environment",
            location=example.location,
            resource_group_name=example.name,
            logs_destination="log-analytics",
            log_analytics_workspace_id=example_analytics_workspace.id)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.App` - 2025-01-01

        * `Microsoft.OperationalInsights` - 2020-08-01

        ## Import

        A Container App Environment can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:containerapp/environment:Environment example "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resGroup1/providers/Microsoft.App/managedEnvironments/myEnvironment"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] dapr_application_insights_connection_string: Application Insights connection string used by Dapr to export Service to Service communication telemetry. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['EnvironmentIdentityArgs', 'EnvironmentIdentityArgsDict']] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.str] infrastructure_resource_group_name: Name of the platform-managed resource group created for the Managed Environment to host infrastructure resources. Changing this forces a new resource to be created.
               
               > **Note:** Only valid if a `workload_profile` is specified. If `infrastructure_subnet_id` is specified, this resource group will be created in the same subscription as `infrastructure_subnet_id`.
        :param pulumi.Input[_builtins.str] infrastructure_subnet_id: The existing Subnet to use for the Container Apps Control Plane. Changing this forces a new resource to be created. 
               
               > **Note:** The Subnet must have a `/21` or larger address space.
        :param pulumi.Input[_builtins.bool] internal_load_balancer_enabled: Should the Container Environment operate in Internal Load Balancing Mode? Defaults to `false`. Changing this forces a new resource to be created.
               
               > **Note:** can only be set to `true` if `infrastructure_subnet_id` is specified.
        :param pulumi.Input[_builtins.str] location: Specifies the supported Azure location where the Container App Environment is to exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] log_analytics_workspace_id: The ID for the Log Analytics Workspace to link this Container Apps Managed Environment to. 
               
               > **Note:** required if `logs_destination` is set to `log-analytics`. Cannot be set if `logs_destination` is set to `azure-monitor`.
        :param pulumi.Input[_builtins.str] logs_destination: Where the application logs will be saved for this Container Apps Managed Environment. Possible values include `log-analytics` and `azure-monitor`. Omitting this value will result in logs being streamed only.
        :param pulumi.Input[_builtins.bool] mutual_tls_enabled: Should mutual transport layer security (mTLS) be enabled? Defaults to `false`.
               
               > **Note:** This feature is in public preview. Enabling mTLS for your applications may increase response latency and reduce maximum throughput in high-load scenarios.
        :param pulumi.Input[_builtins.str] name: The name of the Container Apps Managed Environment. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which the Container App Environment is to be created. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['EnvironmentWorkloadProfileArgs', 'EnvironmentWorkloadProfileArgsDict']]]] workload_profiles: One or more `workload_profile` blocks as defined below.
        :param pulumi.Input[_builtins.bool] zone_redundancy_enabled: Should the Container App Environment be created with Zone Redundancy enabled? Defaults to `false`. Changing this forces a new resource to be created.
               
               > **Note:** can only be set to `true` if `infrastructure_subnet_id` is specified.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EnvironmentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Container App Environment.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_analytics_workspace = azure.operationalinsights.AnalyticsWorkspace("example",
            name="example-workspace",
            location=example.location,
            resource_group_name=example.name,
            sku="PerGB2018",
            retention_in_days=30)
        example_environment = azure.containerapp.Environment("example",
            name="my-environment",
            location=example.location,
            resource_group_name=example.name,
            logs_destination="log-analytics",
            log_analytics_workspace_id=example_analytics_workspace.id)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.App` - 2025-01-01

        * `Microsoft.OperationalInsights` - 2020-08-01

        ## Import

        A Container App Environment can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:containerapp/environment:Environment example "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resGroup1/providers/Microsoft.App/managedEnvironments/myEnvironment"
        ```

        :param str resource_name: The name of the resource.
        :param EnvironmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EnvironmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 dapr_application_insights_connection_string: Optional[pulumi.Input[_builtins.str]] = None,
                 identity: Optional[pulumi.Input[Union['EnvironmentIdentityArgs', 'EnvironmentIdentityArgsDict']]] = None,
                 infrastructure_resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 infrastructure_subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 internal_load_balancer_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 log_analytics_workspace_id: Optional[pulumi.Input[_builtins.str]] = None,
                 logs_destination: Optional[pulumi.Input[_builtins.str]] = None,
                 mutual_tls_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 workload_profiles: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EnvironmentWorkloadProfileArgs', 'EnvironmentWorkloadProfileArgsDict']]]]] = None,
                 zone_redundancy_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EnvironmentArgs.__new__(EnvironmentArgs)

            __props__.__dict__["dapr_application_insights_connection_string"] = None if dapr_application_insights_connection_string is None else pulumi.Output.secret(dapr_application_insights_connection_string)
            __props__.__dict__["identity"] = identity
            __props__.__dict__["infrastructure_resource_group_name"] = infrastructure_resource_group_name
            __props__.__dict__["infrastructure_subnet_id"] = infrastructure_subnet_id
            __props__.__dict__["internal_load_balancer_enabled"] = internal_load_balancer_enabled
            __props__.__dict__["location"] = location
            __props__.__dict__["log_analytics_workspace_id"] = log_analytics_workspace_id
            __props__.__dict__["logs_destination"] = logs_destination
            __props__.__dict__["mutual_tls_enabled"] = mutual_tls_enabled
            __props__.__dict__["name"] = name
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["tags"] = tags
            __props__.__dict__["workload_profiles"] = workload_profiles
            __props__.__dict__["zone_redundancy_enabled"] = zone_redundancy_enabled
            __props__.__dict__["custom_domain_verification_id"] = None
            __props__.__dict__["default_domain"] = None
            __props__.__dict__["docker_bridge_cidr"] = None
            __props__.__dict__["platform_reserved_cidr"] = None
            __props__.__dict__["platform_reserved_dns_ip_address"] = None
            __props__.__dict__["static_ip_address"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["daprApplicationInsightsConnectionString"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Environment, __self__).__init__(
            'azure:containerapp/environment:Environment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            custom_domain_verification_id: Optional[pulumi.Input[_builtins.str]] = None,
            dapr_application_insights_connection_string: Optional[pulumi.Input[_builtins.str]] = None,
            default_domain: Optional[pulumi.Input[_builtins.str]] = None,
            docker_bridge_cidr: Optional[pulumi.Input[_builtins.str]] = None,
            identity: Optional[pulumi.Input[Union['EnvironmentIdentityArgs', 'EnvironmentIdentityArgsDict']]] = None,
            infrastructure_resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            infrastructure_subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
            internal_load_balancer_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            log_analytics_workspace_id: Optional[pulumi.Input[_builtins.str]] = None,
            logs_destination: Optional[pulumi.Input[_builtins.str]] = None,
            mutual_tls_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            platform_reserved_cidr: Optional[pulumi.Input[_builtins.str]] = None,
            platform_reserved_dns_ip_address: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            static_ip_address: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            workload_profiles: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EnvironmentWorkloadProfileArgs', 'EnvironmentWorkloadProfileArgsDict']]]]] = None,
            zone_redundancy_enabled: Optional[pulumi.Input[_builtins.bool]] = None) -> 'Environment':
        """
        Get an existing Environment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] custom_domain_verification_id: The ID of the Custom Domain Verification for this Container App Environment.
        :param pulumi.Input[_builtins.str] dapr_application_insights_connection_string: Application Insights connection string used by Dapr to export Service to Service communication telemetry. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] default_domain: The default, publicly resolvable, name of this Container App Environment.
        :param pulumi.Input[_builtins.str] docker_bridge_cidr: The network addressing in which the Container Apps in this Container App Environment will reside in CIDR notation.
        :param pulumi.Input[Union['EnvironmentIdentityArgs', 'EnvironmentIdentityArgsDict']] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.str] infrastructure_resource_group_name: Name of the platform-managed resource group created for the Managed Environment to host infrastructure resources. Changing this forces a new resource to be created.
               
               > **Note:** Only valid if a `workload_profile` is specified. If `infrastructure_subnet_id` is specified, this resource group will be created in the same subscription as `infrastructure_subnet_id`.
        :param pulumi.Input[_builtins.str] infrastructure_subnet_id: The existing Subnet to use for the Container Apps Control Plane. Changing this forces a new resource to be created. 
               
               > **Note:** The Subnet must have a `/21` or larger address space.
        :param pulumi.Input[_builtins.bool] internal_load_balancer_enabled: Should the Container Environment operate in Internal Load Balancing Mode? Defaults to `false`. Changing this forces a new resource to be created.
               
               > **Note:** can only be set to `true` if `infrastructure_subnet_id` is specified.
        :param pulumi.Input[_builtins.str] location: Specifies the supported Azure location where the Container App Environment is to exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] log_analytics_workspace_id: The ID for the Log Analytics Workspace to link this Container Apps Managed Environment to. 
               
               > **Note:** required if `logs_destination` is set to `log-analytics`. Cannot be set if `logs_destination` is set to `azure-monitor`.
        :param pulumi.Input[_builtins.str] logs_destination: Where the application logs will be saved for this Container Apps Managed Environment. Possible values include `log-analytics` and `azure-monitor`. Omitting this value will result in logs being streamed only.
        :param pulumi.Input[_builtins.bool] mutual_tls_enabled: Should mutual transport layer security (mTLS) be enabled? Defaults to `false`.
               
               > **Note:** This feature is in public preview. Enabling mTLS for your applications may increase response latency and reduce maximum throughput in high-load scenarios.
        :param pulumi.Input[_builtins.str] name: The name of the Container Apps Managed Environment. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] platform_reserved_cidr: The IP range, in CIDR notation, that is reserved for environment infrastructure IP addresses.
        :param pulumi.Input[_builtins.str] platform_reserved_dns_ip_address: The IP address from the IP range defined by `platform_reserved_cidr` that is reserved for the internal DNS server.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which the Container App Environment is to be created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] static_ip_address: The Static IP address of the Environment.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['EnvironmentWorkloadProfileArgs', 'EnvironmentWorkloadProfileArgsDict']]]] workload_profiles: One or more `workload_profile` blocks as defined below.
        :param pulumi.Input[_builtins.bool] zone_redundancy_enabled: Should the Container App Environment be created with Zone Redundancy enabled? Defaults to `false`. Changing this forces a new resource to be created.
               
               > **Note:** can only be set to `true` if `infrastructure_subnet_id` is specified.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EnvironmentState.__new__(_EnvironmentState)

        __props__.__dict__["custom_domain_verification_id"] = custom_domain_verification_id
        __props__.__dict__["dapr_application_insights_connection_string"] = dapr_application_insights_connection_string
        __props__.__dict__["default_domain"] = default_domain
        __props__.__dict__["docker_bridge_cidr"] = docker_bridge_cidr
        __props__.__dict__["identity"] = identity
        __props__.__dict__["infrastructure_resource_group_name"] = infrastructure_resource_group_name
        __props__.__dict__["infrastructure_subnet_id"] = infrastructure_subnet_id
        __props__.__dict__["internal_load_balancer_enabled"] = internal_load_balancer_enabled
        __props__.__dict__["location"] = location
        __props__.__dict__["log_analytics_workspace_id"] = log_analytics_workspace_id
        __props__.__dict__["logs_destination"] = logs_destination
        __props__.__dict__["mutual_tls_enabled"] = mutual_tls_enabled
        __props__.__dict__["name"] = name
        __props__.__dict__["platform_reserved_cidr"] = platform_reserved_cidr
        __props__.__dict__["platform_reserved_dns_ip_address"] = platform_reserved_dns_ip_address
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["static_ip_address"] = static_ip_address
        __props__.__dict__["tags"] = tags
        __props__.__dict__["workload_profiles"] = workload_profiles
        __props__.__dict__["zone_redundancy_enabled"] = zone_redundancy_enabled
        return Environment(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="customDomainVerificationId")
    def custom_domain_verification_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Custom Domain Verification for this Container App Environment.
        """
        return pulumi.get(self, "custom_domain_verification_id")

    @_builtins.property
    @pulumi.getter(name="daprApplicationInsightsConnectionString")
    def dapr_application_insights_connection_string(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Application Insights connection string used by Dapr to export Service to Service communication telemetry. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "dapr_application_insights_connection_string")

    @_builtins.property
    @pulumi.getter(name="defaultDomain")
    def default_domain(self) -> pulumi.Output[_builtins.str]:
        """
        The default, publicly resolvable, name of this Container App Environment.
        """
        return pulumi.get(self, "default_domain")

    @_builtins.property
    @pulumi.getter(name="dockerBridgeCidr")
    def docker_bridge_cidr(self) -> pulumi.Output[_builtins.str]:
        """
        The network addressing in which the Container Apps in this Container App Environment will reside in CIDR notation.
        """
        return pulumi.get(self, "docker_bridge_cidr")

    @_builtins.property
    @pulumi.getter
    def identity(self) -> pulumi.Output[Optional['outputs.EnvironmentIdentity']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @_builtins.property
    @pulumi.getter(name="infrastructureResourceGroupName")
    def infrastructure_resource_group_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Name of the platform-managed resource group created for the Managed Environment to host infrastructure resources. Changing this forces a new resource to be created.

        > **Note:** Only valid if a `workload_profile` is specified. If `infrastructure_subnet_id` is specified, this resource group will be created in the same subscription as `infrastructure_subnet_id`.
        """
        return pulumi.get(self, "infrastructure_resource_group_name")

    @_builtins.property
    @pulumi.getter(name="infrastructureSubnetId")
    def infrastructure_subnet_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The existing Subnet to use for the Container Apps Control Plane. Changing this forces a new resource to be created. 

        > **Note:** The Subnet must have a `/21` or larger address space.
        """
        return pulumi.get(self, "infrastructure_subnet_id")

    @_builtins.property
    @pulumi.getter(name="internalLoadBalancerEnabled")
    def internal_load_balancer_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Should the Container Environment operate in Internal Load Balancing Mode? Defaults to `false`. Changing this forces a new resource to be created.

        > **Note:** can only be set to `true` if `infrastructure_subnet_id` is specified.
        """
        return pulumi.get(self, "internal_load_balancer_enabled")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the supported Azure location where the Container App Environment is to exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter(name="logAnalyticsWorkspaceId")
    def log_analytics_workspace_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID for the Log Analytics Workspace to link this Container Apps Managed Environment to. 

        > **Note:** required if `logs_destination` is set to `log-analytics`. Cannot be set if `logs_destination` is set to `azure-monitor`.
        """
        return pulumi.get(self, "log_analytics_workspace_id")

    @_builtins.property
    @pulumi.getter(name="logsDestination")
    def logs_destination(self) -> pulumi.Output[_builtins.str]:
        """
        Where the application logs will be saved for this Container Apps Managed Environment. Possible values include `log-analytics` and `azure-monitor`. Omitting this value will result in logs being streamed only.
        """
        return pulumi.get(self, "logs_destination")

    @_builtins.property
    @pulumi.getter(name="mutualTlsEnabled")
    def mutual_tls_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Should mutual transport layer security (mTLS) be enabled? Defaults to `false`.

        > **Note:** This feature is in public preview. Enabling mTLS for your applications may increase response latency and reduce maximum throughput in high-load scenarios.
        """
        return pulumi.get(self, "mutual_tls_enabled")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Container Apps Managed Environment. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="platformReservedCidr")
    def platform_reserved_cidr(self) -> pulumi.Output[_builtins.str]:
        """
        The IP range, in CIDR notation, that is reserved for environment infrastructure IP addresses.
        """
        return pulumi.get(self, "platform_reserved_cidr")

    @_builtins.property
    @pulumi.getter(name="platformReservedDnsIpAddress")
    def platform_reserved_dns_ip_address(self) -> pulumi.Output[_builtins.str]:
        """
        The IP address from the IP range defined by `platform_reserved_cidr` that is reserved for the internal DNS server.
        """
        return pulumi.get(self, "platform_reserved_dns_ip_address")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the resource group in which the Container App Environment is to be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter(name="staticIpAddress")
    def static_ip_address(self) -> pulumi.Output[_builtins.str]:
        """
        The Static IP address of the Environment.
        """
        return pulumi.get(self, "static_ip_address")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="workloadProfiles")
    def workload_profiles(self) -> pulumi.Output[Optional[Sequence['outputs.EnvironmentWorkloadProfile']]]:
        """
        One or more `workload_profile` blocks as defined below.
        """
        return pulumi.get(self, "workload_profiles")

    @_builtins.property
    @pulumi.getter(name="zoneRedundancyEnabled")
    def zone_redundancy_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Should the Container App Environment be created with Zone Redundancy enabled? Defaults to `false`. Changing this forces a new resource to be created.

        > **Note:** can only be set to `true` if `infrastructure_subnet_id` is specified.
        """
        return pulumi.get(self, "zone_redundancy_enabled")

