# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['RegistryArgs', 'Registry']

@pulumi.input_type
class RegistryArgs:
    def __init__(__self__, *,
                 resource_group_name: pulumi.Input[_builtins.str],
                 sku: pulumi.Input[_builtins.str],
                 admin_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 anonymous_pull_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 data_endpoint_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 encryption: Optional[pulumi.Input['RegistryEncryptionArgs']] = None,
                 export_policy_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 georeplications: Optional[pulumi.Input[Sequence[pulumi.Input['RegistryGeoreplicationArgs']]]] = None,
                 identity: Optional[pulumi.Input['RegistryIdentityArgs']] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_rule_bypass_option: Optional[pulumi.Input[_builtins.str]] = None,
                 network_rule_set: Optional[pulumi.Input['RegistryNetworkRuleSetArgs']] = None,
                 public_network_access_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 quarantine_policy_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 retention_policy_in_days: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 trust_policy_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 zone_redundancy_enabled: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a Registry resource.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which to create the Container Registry. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] sku: The SKU name of the container registry. Possible values are `Basic`, `Standard` and `Premium`.
        :param pulumi.Input[_builtins.bool] admin_enabled: Specifies whether the admin user is enabled. Defaults to `false`.
        :param pulumi.Input[_builtins.bool] anonymous_pull_enabled: Whether to allow anonymous (unauthenticated) pull access to this Container Registry. This is only supported on resources with the `Standard` or `Premium` SKU.
        :param pulumi.Input[_builtins.bool] data_endpoint_enabled: Whether to enable dedicated data endpoints for this Container Registry? This is only supported on resources with the `Premium` SKU.
        :param pulumi.Input['RegistryEncryptionArgs'] encryption: An `encryption` block as documented below.
        :param pulumi.Input[_builtins.bool] export_policy_enabled: Boolean value that indicates whether export policy is enabled. Defaults to `true`. In order to set it to `false`, make sure the `public_network_access_enabled` is also set to `false`.
               
               > **Note:** `quarantine_policy_enabled`, `retention_policy_in_days`, `trust_policy_enabled`, `export_policy_enabled` and `zone_redundancy_enabled` are only supported on resources with the `Premium` SKU.
        :param pulumi.Input[Sequence[pulumi.Input['RegistryGeoreplicationArgs']]] georeplications: One or more `georeplications` blocks as documented below.
               
               > **Note:** The `georeplications` is only supported on new resources with the `Premium` SKU.
               
               > **Note:** The `georeplications` list cannot contain the location where the Container Registry exists.
               
               > **Note:** If more than one `georeplications` block is specified, they are expected to follow the alphabetic order on the `location` property.
        :param pulumi.Input['RegistryIdentityArgs'] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.str] location: Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Container Registry. Only Alphanumeric characters allowed. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] network_rule_bypass_option: Whether to allow trusted Azure services to access a network-restricted Container Registry? Possible values are `None` and `AzureServices`. Defaults to `AzureServices`.
        :param pulumi.Input['RegistryNetworkRuleSetArgs'] network_rule_set: A `network_rule_set` block as documented below.
        :param pulumi.Input[_builtins.bool] public_network_access_enabled: Whether public network access is allowed for the container registry. Defaults to `true`.
        :param pulumi.Input[_builtins.bool] quarantine_policy_enabled: Boolean value that indicates whether quarantine policy is enabled.
        :param pulumi.Input[_builtins.int] retention_policy_in_days: The number of days to retain and untagged manifest after which it gets purged. Defaults to `7`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.bool] trust_policy_enabled: Boolean value that indicated whether trust policy is enabled. Defaults to `false`.
        :param pulumi.Input[_builtins.bool] zone_redundancy_enabled: Whether zone redundancy is enabled for this Container Registry? Changing this forces a new resource to be created. Defaults to `false`.
        """
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "sku", sku)
        if admin_enabled is not None:
            pulumi.set(__self__, "admin_enabled", admin_enabled)
        if anonymous_pull_enabled is not None:
            pulumi.set(__self__, "anonymous_pull_enabled", anonymous_pull_enabled)
        if data_endpoint_enabled is not None:
            pulumi.set(__self__, "data_endpoint_enabled", data_endpoint_enabled)
        if encryption is not None:
            pulumi.set(__self__, "encryption", encryption)
        if export_policy_enabled is not None:
            pulumi.set(__self__, "export_policy_enabled", export_policy_enabled)
        if georeplications is not None:
            pulumi.set(__self__, "georeplications", georeplications)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_rule_bypass_option is not None:
            pulumi.set(__self__, "network_rule_bypass_option", network_rule_bypass_option)
        if network_rule_set is not None:
            pulumi.set(__self__, "network_rule_set", network_rule_set)
        if public_network_access_enabled is not None:
            pulumi.set(__self__, "public_network_access_enabled", public_network_access_enabled)
        if quarantine_policy_enabled is not None:
            pulumi.set(__self__, "quarantine_policy_enabled", quarantine_policy_enabled)
        if retention_policy_in_days is not None:
            pulumi.set(__self__, "retention_policy_in_days", retention_policy_in_days)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if trust_policy_enabled is not None:
            pulumi.set(__self__, "trust_policy_enabled", trust_policy_enabled)
        if zone_redundancy_enabled is not None:
            pulumi.set(__self__, "zone_redundancy_enabled", zone_redundancy_enabled)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the resource group in which to create the Container Registry. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter
    def sku(self) -> pulumi.Input[_builtins.str]:
        """
        The SKU name of the container registry. Possible values are `Basic`, `Standard` and `Premium`.
        """
        return pulumi.get(self, "sku")

    @sku.setter
    def sku(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "sku", value)

    @_builtins.property
    @pulumi.getter(name="adminEnabled")
    def admin_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether the admin user is enabled. Defaults to `false`.
        """
        return pulumi.get(self, "admin_enabled")

    @admin_enabled.setter
    def admin_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "admin_enabled", value)

    @_builtins.property
    @pulumi.getter(name="anonymousPullEnabled")
    def anonymous_pull_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to allow anonymous (unauthenticated) pull access to this Container Registry. This is only supported on resources with the `Standard` or `Premium` SKU.
        """
        return pulumi.get(self, "anonymous_pull_enabled")

    @anonymous_pull_enabled.setter
    def anonymous_pull_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "anonymous_pull_enabled", value)

    @_builtins.property
    @pulumi.getter(name="dataEndpointEnabled")
    def data_endpoint_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable dedicated data endpoints for this Container Registry? This is only supported on resources with the `Premium` SKU.
        """
        return pulumi.get(self, "data_endpoint_enabled")

    @data_endpoint_enabled.setter
    def data_endpoint_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "data_endpoint_enabled", value)

    @_builtins.property
    @pulumi.getter
    def encryption(self) -> Optional[pulumi.Input['RegistryEncryptionArgs']]:
        """
        An `encryption` block as documented below.
        """
        return pulumi.get(self, "encryption")

    @encryption.setter
    def encryption(self, value: Optional[pulumi.Input['RegistryEncryptionArgs']]):
        pulumi.set(self, "encryption", value)

    @_builtins.property
    @pulumi.getter(name="exportPolicyEnabled")
    def export_policy_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean value that indicates whether export policy is enabled. Defaults to `true`. In order to set it to `false`, make sure the `public_network_access_enabled` is also set to `false`.

        > **Note:** `quarantine_policy_enabled`, `retention_policy_in_days`, `trust_policy_enabled`, `export_policy_enabled` and `zone_redundancy_enabled` are only supported on resources with the `Premium` SKU.
        """
        return pulumi.get(self, "export_policy_enabled")

    @export_policy_enabled.setter
    def export_policy_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "export_policy_enabled", value)

    @_builtins.property
    @pulumi.getter
    def georeplications(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RegistryGeoreplicationArgs']]]]:
        """
        One or more `georeplications` blocks as documented below.

        > **Note:** The `georeplications` is only supported on new resources with the `Premium` SKU.

        > **Note:** The `georeplications` list cannot contain the location where the Container Registry exists.

        > **Note:** If more than one `georeplications` block is specified, they are expected to follow the alphabetic order on the `location` property.
        """
        return pulumi.get(self, "georeplications")

    @georeplications.setter
    def georeplications(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RegistryGeoreplicationArgs']]]]):
        pulumi.set(self, "georeplications", value)

    @_builtins.property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['RegistryIdentityArgs']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['RegistryIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the Container Registry. Only Alphanumeric characters allowed. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="networkRuleBypassOption")
    def network_rule_bypass_option(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether to allow trusted Azure services to access a network-restricted Container Registry? Possible values are `None` and `AzureServices`. Defaults to `AzureServices`.
        """
        return pulumi.get(self, "network_rule_bypass_option")

    @network_rule_bypass_option.setter
    def network_rule_bypass_option(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network_rule_bypass_option", value)

    @_builtins.property
    @pulumi.getter(name="networkRuleSet")
    def network_rule_set(self) -> Optional[pulumi.Input['RegistryNetworkRuleSetArgs']]:
        """
        A `network_rule_set` block as documented below.
        """
        return pulumi.get(self, "network_rule_set")

    @network_rule_set.setter
    def network_rule_set(self, value: Optional[pulumi.Input['RegistryNetworkRuleSetArgs']]):
        pulumi.set(self, "network_rule_set", value)

    @_builtins.property
    @pulumi.getter(name="publicNetworkAccessEnabled")
    def public_network_access_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether public network access is allowed for the container registry. Defaults to `true`.
        """
        return pulumi.get(self, "public_network_access_enabled")

    @public_network_access_enabled.setter
    def public_network_access_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "public_network_access_enabled", value)

    @_builtins.property
    @pulumi.getter(name="quarantinePolicyEnabled")
    def quarantine_policy_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean value that indicates whether quarantine policy is enabled.
        """
        return pulumi.get(self, "quarantine_policy_enabled")

    @quarantine_policy_enabled.setter
    def quarantine_policy_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "quarantine_policy_enabled", value)

    @_builtins.property
    @pulumi.getter(name="retentionPolicyInDays")
    def retention_policy_in_days(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of days to retain and untagged manifest after which it gets purged. Defaults to `7`.
        """
        return pulumi.get(self, "retention_policy_in_days")

    @retention_policy_in_days.setter
    def retention_policy_in_days(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "retention_policy_in_days", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="trustPolicyEnabled")
    def trust_policy_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean value that indicated whether trust policy is enabled. Defaults to `false`.
        """
        return pulumi.get(self, "trust_policy_enabled")

    @trust_policy_enabled.setter
    def trust_policy_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "trust_policy_enabled", value)

    @_builtins.property
    @pulumi.getter(name="zoneRedundancyEnabled")
    def zone_redundancy_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether zone redundancy is enabled for this Container Registry? Changing this forces a new resource to be created. Defaults to `false`.
        """
        return pulumi.get(self, "zone_redundancy_enabled")

    @zone_redundancy_enabled.setter
    def zone_redundancy_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "zone_redundancy_enabled", value)


@pulumi.input_type
class _RegistryState:
    def __init__(__self__, *,
                 admin_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 admin_password: Optional[pulumi.Input[_builtins.str]] = None,
                 admin_username: Optional[pulumi.Input[_builtins.str]] = None,
                 anonymous_pull_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 data_endpoint_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 data_endpoint_host_names: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 encryption: Optional[pulumi.Input['RegistryEncryptionArgs']] = None,
                 export_policy_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 georeplications: Optional[pulumi.Input[Sequence[pulumi.Input['RegistryGeoreplicationArgs']]]] = None,
                 identity: Optional[pulumi.Input['RegistryIdentityArgs']] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 login_server: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_rule_bypass_option: Optional[pulumi.Input[_builtins.str]] = None,
                 network_rule_set: Optional[pulumi.Input['RegistryNetworkRuleSetArgs']] = None,
                 public_network_access_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 quarantine_policy_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 retention_policy_in_days: Optional[pulumi.Input[_builtins.int]] = None,
                 sku: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 trust_policy_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 zone_redundancy_enabled: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        Input properties used for looking up and filtering Registry resources.
        :param pulumi.Input[_builtins.bool] admin_enabled: Specifies whether the admin user is enabled. Defaults to `false`.
        :param pulumi.Input[_builtins.str] admin_password: The Password associated with the Container Registry Admin account - if the admin account is enabled.
        :param pulumi.Input[_builtins.str] admin_username: The Username associated with the Container Registry Admin account - if the admin account is enabled.
        :param pulumi.Input[_builtins.bool] anonymous_pull_enabled: Whether to allow anonymous (unauthenticated) pull access to this Container Registry. This is only supported on resources with the `Standard` or `Premium` SKU.
        :param pulumi.Input[_builtins.bool] data_endpoint_enabled: Whether to enable dedicated data endpoints for this Container Registry? This is only supported on resources with the `Premium` SKU.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] data_endpoint_host_names: A set of data endpoint hostnames associated with the container registry if data endpoints are enabled.
        :param pulumi.Input['RegistryEncryptionArgs'] encryption: An `encryption` block as documented below.
        :param pulumi.Input[_builtins.bool] export_policy_enabled: Boolean value that indicates whether export policy is enabled. Defaults to `true`. In order to set it to `false`, make sure the `public_network_access_enabled` is also set to `false`.
               
               > **Note:** `quarantine_policy_enabled`, `retention_policy_in_days`, `trust_policy_enabled`, `export_policy_enabled` and `zone_redundancy_enabled` are only supported on resources with the `Premium` SKU.
        :param pulumi.Input[Sequence[pulumi.Input['RegistryGeoreplicationArgs']]] georeplications: One or more `georeplications` blocks as documented below.
               
               > **Note:** The `georeplications` is only supported on new resources with the `Premium` SKU.
               
               > **Note:** The `georeplications` list cannot contain the location where the Container Registry exists.
               
               > **Note:** If more than one `georeplications` block is specified, they are expected to follow the alphabetic order on the `location` property.
        :param pulumi.Input['RegistryIdentityArgs'] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.str] location: Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] login_server: The URL that can be used to log into the container registry.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Container Registry. Only Alphanumeric characters allowed. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] network_rule_bypass_option: Whether to allow trusted Azure services to access a network-restricted Container Registry? Possible values are `None` and `AzureServices`. Defaults to `AzureServices`.
        :param pulumi.Input['RegistryNetworkRuleSetArgs'] network_rule_set: A `network_rule_set` block as documented below.
        :param pulumi.Input[_builtins.bool] public_network_access_enabled: Whether public network access is allowed for the container registry. Defaults to `true`.
        :param pulumi.Input[_builtins.bool] quarantine_policy_enabled: Boolean value that indicates whether quarantine policy is enabled.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which to create the Container Registry. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] retention_policy_in_days: The number of days to retain and untagged manifest after which it gets purged. Defaults to `7`.
        :param pulumi.Input[_builtins.str] sku: The SKU name of the container registry. Possible values are `Basic`, `Standard` and `Premium`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.bool] trust_policy_enabled: Boolean value that indicated whether trust policy is enabled. Defaults to `false`.
        :param pulumi.Input[_builtins.bool] zone_redundancy_enabled: Whether zone redundancy is enabled for this Container Registry? Changing this forces a new resource to be created. Defaults to `false`.
        """
        if admin_enabled is not None:
            pulumi.set(__self__, "admin_enabled", admin_enabled)
        if admin_password is not None:
            pulumi.set(__self__, "admin_password", admin_password)
        if admin_username is not None:
            pulumi.set(__self__, "admin_username", admin_username)
        if anonymous_pull_enabled is not None:
            pulumi.set(__self__, "anonymous_pull_enabled", anonymous_pull_enabled)
        if data_endpoint_enabled is not None:
            pulumi.set(__self__, "data_endpoint_enabled", data_endpoint_enabled)
        if data_endpoint_host_names is not None:
            pulumi.set(__self__, "data_endpoint_host_names", data_endpoint_host_names)
        if encryption is not None:
            pulumi.set(__self__, "encryption", encryption)
        if export_policy_enabled is not None:
            pulumi.set(__self__, "export_policy_enabled", export_policy_enabled)
        if georeplications is not None:
            pulumi.set(__self__, "georeplications", georeplications)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if login_server is not None:
            pulumi.set(__self__, "login_server", login_server)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_rule_bypass_option is not None:
            pulumi.set(__self__, "network_rule_bypass_option", network_rule_bypass_option)
        if network_rule_set is not None:
            pulumi.set(__self__, "network_rule_set", network_rule_set)
        if public_network_access_enabled is not None:
            pulumi.set(__self__, "public_network_access_enabled", public_network_access_enabled)
        if quarantine_policy_enabled is not None:
            pulumi.set(__self__, "quarantine_policy_enabled", quarantine_policy_enabled)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if retention_policy_in_days is not None:
            pulumi.set(__self__, "retention_policy_in_days", retention_policy_in_days)
        if sku is not None:
            pulumi.set(__self__, "sku", sku)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if trust_policy_enabled is not None:
            pulumi.set(__self__, "trust_policy_enabled", trust_policy_enabled)
        if zone_redundancy_enabled is not None:
            pulumi.set(__self__, "zone_redundancy_enabled", zone_redundancy_enabled)

    @_builtins.property
    @pulumi.getter(name="adminEnabled")
    def admin_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether the admin user is enabled. Defaults to `false`.
        """
        return pulumi.get(self, "admin_enabled")

    @admin_enabled.setter
    def admin_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "admin_enabled", value)

    @_builtins.property
    @pulumi.getter(name="adminPassword")
    def admin_password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Password associated with the Container Registry Admin account - if the admin account is enabled.
        """
        return pulumi.get(self, "admin_password")

    @admin_password.setter
    def admin_password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "admin_password", value)

    @_builtins.property
    @pulumi.getter(name="adminUsername")
    def admin_username(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Username associated with the Container Registry Admin account - if the admin account is enabled.
        """
        return pulumi.get(self, "admin_username")

    @admin_username.setter
    def admin_username(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "admin_username", value)

    @_builtins.property
    @pulumi.getter(name="anonymousPullEnabled")
    def anonymous_pull_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to allow anonymous (unauthenticated) pull access to this Container Registry. This is only supported on resources with the `Standard` or `Premium` SKU.
        """
        return pulumi.get(self, "anonymous_pull_enabled")

    @anonymous_pull_enabled.setter
    def anonymous_pull_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "anonymous_pull_enabled", value)

    @_builtins.property
    @pulumi.getter(name="dataEndpointEnabled")
    def data_endpoint_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable dedicated data endpoints for this Container Registry? This is only supported on resources with the `Premium` SKU.
        """
        return pulumi.get(self, "data_endpoint_enabled")

    @data_endpoint_enabled.setter
    def data_endpoint_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "data_endpoint_enabled", value)

    @_builtins.property
    @pulumi.getter(name="dataEndpointHostNames")
    def data_endpoint_host_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A set of data endpoint hostnames associated with the container registry if data endpoints are enabled.
        """
        return pulumi.get(self, "data_endpoint_host_names")

    @data_endpoint_host_names.setter
    def data_endpoint_host_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "data_endpoint_host_names", value)

    @_builtins.property
    @pulumi.getter
    def encryption(self) -> Optional[pulumi.Input['RegistryEncryptionArgs']]:
        """
        An `encryption` block as documented below.
        """
        return pulumi.get(self, "encryption")

    @encryption.setter
    def encryption(self, value: Optional[pulumi.Input['RegistryEncryptionArgs']]):
        pulumi.set(self, "encryption", value)

    @_builtins.property
    @pulumi.getter(name="exportPolicyEnabled")
    def export_policy_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean value that indicates whether export policy is enabled. Defaults to `true`. In order to set it to `false`, make sure the `public_network_access_enabled` is also set to `false`.

        > **Note:** `quarantine_policy_enabled`, `retention_policy_in_days`, `trust_policy_enabled`, `export_policy_enabled` and `zone_redundancy_enabled` are only supported on resources with the `Premium` SKU.
        """
        return pulumi.get(self, "export_policy_enabled")

    @export_policy_enabled.setter
    def export_policy_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "export_policy_enabled", value)

    @_builtins.property
    @pulumi.getter
    def georeplications(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RegistryGeoreplicationArgs']]]]:
        """
        One or more `georeplications` blocks as documented below.

        > **Note:** The `georeplications` is only supported on new resources with the `Premium` SKU.

        > **Note:** The `georeplications` list cannot contain the location where the Container Registry exists.

        > **Note:** If more than one `georeplications` block is specified, they are expected to follow the alphabetic order on the `location` property.
        """
        return pulumi.get(self, "georeplications")

    @georeplications.setter
    def georeplications(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RegistryGeoreplicationArgs']]]]):
        pulumi.set(self, "georeplications", value)

    @_builtins.property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['RegistryIdentityArgs']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['RegistryIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="loginServer")
    def login_server(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The URL that can be used to log into the container registry.
        """
        return pulumi.get(self, "login_server")

    @login_server.setter
    def login_server(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "login_server", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the Container Registry. Only Alphanumeric characters allowed. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="networkRuleBypassOption")
    def network_rule_bypass_option(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether to allow trusted Azure services to access a network-restricted Container Registry? Possible values are `None` and `AzureServices`. Defaults to `AzureServices`.
        """
        return pulumi.get(self, "network_rule_bypass_option")

    @network_rule_bypass_option.setter
    def network_rule_bypass_option(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network_rule_bypass_option", value)

    @_builtins.property
    @pulumi.getter(name="networkRuleSet")
    def network_rule_set(self) -> Optional[pulumi.Input['RegistryNetworkRuleSetArgs']]:
        """
        A `network_rule_set` block as documented below.
        """
        return pulumi.get(self, "network_rule_set")

    @network_rule_set.setter
    def network_rule_set(self, value: Optional[pulumi.Input['RegistryNetworkRuleSetArgs']]):
        pulumi.set(self, "network_rule_set", value)

    @_builtins.property
    @pulumi.getter(name="publicNetworkAccessEnabled")
    def public_network_access_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether public network access is allowed for the container registry. Defaults to `true`.
        """
        return pulumi.get(self, "public_network_access_enabled")

    @public_network_access_enabled.setter
    def public_network_access_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "public_network_access_enabled", value)

    @_builtins.property
    @pulumi.getter(name="quarantinePolicyEnabled")
    def quarantine_policy_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean value that indicates whether quarantine policy is enabled.
        """
        return pulumi.get(self, "quarantine_policy_enabled")

    @quarantine_policy_enabled.setter
    def quarantine_policy_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "quarantine_policy_enabled", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the resource group in which to create the Container Registry. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="retentionPolicyInDays")
    def retention_policy_in_days(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of days to retain and untagged manifest after which it gets purged. Defaults to `7`.
        """
        return pulumi.get(self, "retention_policy_in_days")

    @retention_policy_in_days.setter
    def retention_policy_in_days(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "retention_policy_in_days", value)

    @_builtins.property
    @pulumi.getter
    def sku(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The SKU name of the container registry. Possible values are `Basic`, `Standard` and `Premium`.
        """
        return pulumi.get(self, "sku")

    @sku.setter
    def sku(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sku", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="trustPolicyEnabled")
    def trust_policy_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean value that indicated whether trust policy is enabled. Defaults to `false`.
        """
        return pulumi.get(self, "trust_policy_enabled")

    @trust_policy_enabled.setter
    def trust_policy_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "trust_policy_enabled", value)

    @_builtins.property
    @pulumi.getter(name="zoneRedundancyEnabled")
    def zone_redundancy_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether zone redundancy is enabled for this Container Registry? Changing this forces a new resource to be created. Defaults to `false`.
        """
        return pulumi.get(self, "zone_redundancy_enabled")

    @zone_redundancy_enabled.setter
    def zone_redundancy_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "zone_redundancy_enabled", value)


@pulumi.type_token("azure:containerservice/registry:Registry")
class Registry(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 admin_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 anonymous_pull_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 data_endpoint_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 encryption: Optional[pulumi.Input[Union['RegistryEncryptionArgs', 'RegistryEncryptionArgsDict']]] = None,
                 export_policy_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 georeplications: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RegistryGeoreplicationArgs', 'RegistryGeoreplicationArgsDict']]]]] = None,
                 identity: Optional[pulumi.Input[Union['RegistryIdentityArgs', 'RegistryIdentityArgsDict']]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_rule_bypass_option: Optional[pulumi.Input[_builtins.str]] = None,
                 network_rule_set: Optional[pulumi.Input[Union['RegistryNetworkRuleSetArgs', 'RegistryNetworkRuleSetArgsDict']]] = None,
                 public_network_access_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 quarantine_policy_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 retention_policy_in_days: Optional[pulumi.Input[_builtins.int]] = None,
                 sku: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 trust_policy_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 zone_redundancy_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        Manages an Azure Container Registry.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        acr = azure.containerservice.Registry("acr",
            name="containerRegistry1",
            resource_group_name=example.name,
            location=example.location,
            sku="Premium",
            admin_enabled=False,
            georeplications=[
                {
                    "location": "East US",
                    "zone_redundancy_enabled": True,
                    "tags": {},
                },
                {
                    "location": "North Europe",
                    "zone_redundancy_enabled": True,
                    "tags": {},
                },
            ])
        ```

        ### Encryption)

        ```python
        import pulumi
        import pulumi_azure as azure

        example_resource_group = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_user_assigned_identity = azure.authorization.UserAssignedIdentity("example",
            resource_group_name=example_resource_group.name,
            location=example_resource_group.location,
            name="registry-uai")
        example = azure.keyvault.get_key(name="super-secret",
            key_vault_id=existing["id"])
        acr = azure.containerservice.Registry("acr",
            name="containerRegistry1",
            resource_group_name=example_resource_group.name,
            location=example_resource_group.location,
            sku="Premium",
            identity={
                "type": "UserAssigned",
                "identity_ids": [example_user_assigned_identity.id],
            },
            encryption={
                "key_vault_key_id": example.id,
                "identity_client_id": example_user_assigned_identity.client_id,
            })
        ```

        ### Attaching A Container Registry To A Kubernetes Cluster)

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_registry = azure.containerservice.Registry("example",
            name="containerRegistry1",
            resource_group_name=example.name,
            location=example.location,
            sku="Premium")
        example_kubernetes_cluster = azure.containerservice.KubernetesCluster("example",
            name="example-aks1",
            location=example.location,
            resource_group_name=example.name,
            dns_prefix="exampleaks1",
            default_node_pool={
                "name": "default",
                "node_count": 1,
                "vm_size": "Standard_D2_v2",
            },
            identity={
                "type": "SystemAssigned",
            },
            tags={
                "Environment": "Production",
            })
        example_assignment = azure.authorization.Assignment("example",
            principal_id=example_kubernetes_cluster.kubelet_identity.object_id,
            role_definition_name="AcrPull",
            scope=example_registry.id,
            skip_service_principal_aad_check=True)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.ContainerRegistry` - 2023-11-01-preview

        ## Import

        Container Registries can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:containerservice/registry:Registry example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.ContainerRegistry/registries/myregistry1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] admin_enabled: Specifies whether the admin user is enabled. Defaults to `false`.
        :param pulumi.Input[_builtins.bool] anonymous_pull_enabled: Whether to allow anonymous (unauthenticated) pull access to this Container Registry. This is only supported on resources with the `Standard` or `Premium` SKU.
        :param pulumi.Input[_builtins.bool] data_endpoint_enabled: Whether to enable dedicated data endpoints for this Container Registry? This is only supported on resources with the `Premium` SKU.
        :param pulumi.Input[Union['RegistryEncryptionArgs', 'RegistryEncryptionArgsDict']] encryption: An `encryption` block as documented below.
        :param pulumi.Input[_builtins.bool] export_policy_enabled: Boolean value that indicates whether export policy is enabled. Defaults to `true`. In order to set it to `false`, make sure the `public_network_access_enabled` is also set to `false`.
               
               > **Note:** `quarantine_policy_enabled`, `retention_policy_in_days`, `trust_policy_enabled`, `export_policy_enabled` and `zone_redundancy_enabled` are only supported on resources with the `Premium` SKU.
        :param pulumi.Input[Sequence[pulumi.Input[Union['RegistryGeoreplicationArgs', 'RegistryGeoreplicationArgsDict']]]] georeplications: One or more `georeplications` blocks as documented below.
               
               > **Note:** The `georeplications` is only supported on new resources with the `Premium` SKU.
               
               > **Note:** The `georeplications` list cannot contain the location where the Container Registry exists.
               
               > **Note:** If more than one `georeplications` block is specified, they are expected to follow the alphabetic order on the `location` property.
        :param pulumi.Input[Union['RegistryIdentityArgs', 'RegistryIdentityArgsDict']] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.str] location: Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Container Registry. Only Alphanumeric characters allowed. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] network_rule_bypass_option: Whether to allow trusted Azure services to access a network-restricted Container Registry? Possible values are `None` and `AzureServices`. Defaults to `AzureServices`.
        :param pulumi.Input[Union['RegistryNetworkRuleSetArgs', 'RegistryNetworkRuleSetArgsDict']] network_rule_set: A `network_rule_set` block as documented below.
        :param pulumi.Input[_builtins.bool] public_network_access_enabled: Whether public network access is allowed for the container registry. Defaults to `true`.
        :param pulumi.Input[_builtins.bool] quarantine_policy_enabled: Boolean value that indicates whether quarantine policy is enabled.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which to create the Container Registry. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] retention_policy_in_days: The number of days to retain and untagged manifest after which it gets purged. Defaults to `7`.
        :param pulumi.Input[_builtins.str] sku: The SKU name of the container registry. Possible values are `Basic`, `Standard` and `Premium`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.bool] trust_policy_enabled: Boolean value that indicated whether trust policy is enabled. Defaults to `false`.
        :param pulumi.Input[_builtins.bool] zone_redundancy_enabled: Whether zone redundancy is enabled for this Container Registry? Changing this forces a new resource to be created. Defaults to `false`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RegistryArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an Azure Container Registry.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        acr = azure.containerservice.Registry("acr",
            name="containerRegistry1",
            resource_group_name=example.name,
            location=example.location,
            sku="Premium",
            admin_enabled=False,
            georeplications=[
                {
                    "location": "East US",
                    "zone_redundancy_enabled": True,
                    "tags": {},
                },
                {
                    "location": "North Europe",
                    "zone_redundancy_enabled": True,
                    "tags": {},
                },
            ])
        ```

        ### Encryption)

        ```python
        import pulumi
        import pulumi_azure as azure

        example_resource_group = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_user_assigned_identity = azure.authorization.UserAssignedIdentity("example",
            resource_group_name=example_resource_group.name,
            location=example_resource_group.location,
            name="registry-uai")
        example = azure.keyvault.get_key(name="super-secret",
            key_vault_id=existing["id"])
        acr = azure.containerservice.Registry("acr",
            name="containerRegistry1",
            resource_group_name=example_resource_group.name,
            location=example_resource_group.location,
            sku="Premium",
            identity={
                "type": "UserAssigned",
                "identity_ids": [example_user_assigned_identity.id],
            },
            encryption={
                "key_vault_key_id": example.id,
                "identity_client_id": example_user_assigned_identity.client_id,
            })
        ```

        ### Attaching A Container Registry To A Kubernetes Cluster)

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_registry = azure.containerservice.Registry("example",
            name="containerRegistry1",
            resource_group_name=example.name,
            location=example.location,
            sku="Premium")
        example_kubernetes_cluster = azure.containerservice.KubernetesCluster("example",
            name="example-aks1",
            location=example.location,
            resource_group_name=example.name,
            dns_prefix="exampleaks1",
            default_node_pool={
                "name": "default",
                "node_count": 1,
                "vm_size": "Standard_D2_v2",
            },
            identity={
                "type": "SystemAssigned",
            },
            tags={
                "Environment": "Production",
            })
        example_assignment = azure.authorization.Assignment("example",
            principal_id=example_kubernetes_cluster.kubelet_identity.object_id,
            role_definition_name="AcrPull",
            scope=example_registry.id,
            skip_service_principal_aad_check=True)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.ContainerRegistry` - 2023-11-01-preview

        ## Import

        Container Registries can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:containerservice/registry:Registry example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.ContainerRegistry/registries/myregistry1
        ```

        :param str resource_name: The name of the resource.
        :param RegistryArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RegistryArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 admin_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 anonymous_pull_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 data_endpoint_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 encryption: Optional[pulumi.Input[Union['RegistryEncryptionArgs', 'RegistryEncryptionArgsDict']]] = None,
                 export_policy_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 georeplications: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RegistryGeoreplicationArgs', 'RegistryGeoreplicationArgsDict']]]]] = None,
                 identity: Optional[pulumi.Input[Union['RegistryIdentityArgs', 'RegistryIdentityArgsDict']]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_rule_bypass_option: Optional[pulumi.Input[_builtins.str]] = None,
                 network_rule_set: Optional[pulumi.Input[Union['RegistryNetworkRuleSetArgs', 'RegistryNetworkRuleSetArgsDict']]] = None,
                 public_network_access_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 quarantine_policy_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 retention_policy_in_days: Optional[pulumi.Input[_builtins.int]] = None,
                 sku: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 trust_policy_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 zone_redundancy_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RegistryArgs.__new__(RegistryArgs)

            __props__.__dict__["admin_enabled"] = admin_enabled
            __props__.__dict__["anonymous_pull_enabled"] = anonymous_pull_enabled
            __props__.__dict__["data_endpoint_enabled"] = data_endpoint_enabled
            __props__.__dict__["encryption"] = encryption
            __props__.__dict__["export_policy_enabled"] = export_policy_enabled
            __props__.__dict__["georeplications"] = georeplications
            __props__.__dict__["identity"] = identity
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            __props__.__dict__["network_rule_bypass_option"] = network_rule_bypass_option
            __props__.__dict__["network_rule_set"] = network_rule_set
            __props__.__dict__["public_network_access_enabled"] = public_network_access_enabled
            __props__.__dict__["quarantine_policy_enabled"] = quarantine_policy_enabled
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["retention_policy_in_days"] = retention_policy_in_days
            if sku is None and not opts.urn:
                raise TypeError("Missing required property 'sku'")
            __props__.__dict__["sku"] = sku
            __props__.__dict__["tags"] = tags
            __props__.__dict__["trust_policy_enabled"] = trust_policy_enabled
            __props__.__dict__["zone_redundancy_enabled"] = zone_redundancy_enabled
            __props__.__dict__["admin_password"] = None
            __props__.__dict__["admin_username"] = None
            __props__.__dict__["data_endpoint_host_names"] = None
            __props__.__dict__["login_server"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["adminPassword"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Registry, __self__).__init__(
            'azure:containerservice/registry:Registry',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            admin_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            admin_password: Optional[pulumi.Input[_builtins.str]] = None,
            admin_username: Optional[pulumi.Input[_builtins.str]] = None,
            anonymous_pull_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            data_endpoint_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            data_endpoint_host_names: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            encryption: Optional[pulumi.Input[Union['RegistryEncryptionArgs', 'RegistryEncryptionArgsDict']]] = None,
            export_policy_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            georeplications: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RegistryGeoreplicationArgs', 'RegistryGeoreplicationArgsDict']]]]] = None,
            identity: Optional[pulumi.Input[Union['RegistryIdentityArgs', 'RegistryIdentityArgsDict']]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            login_server: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            network_rule_bypass_option: Optional[pulumi.Input[_builtins.str]] = None,
            network_rule_set: Optional[pulumi.Input[Union['RegistryNetworkRuleSetArgs', 'RegistryNetworkRuleSetArgsDict']]] = None,
            public_network_access_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            quarantine_policy_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            retention_policy_in_days: Optional[pulumi.Input[_builtins.int]] = None,
            sku: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            trust_policy_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            zone_redundancy_enabled: Optional[pulumi.Input[_builtins.bool]] = None) -> 'Registry':
        """
        Get an existing Registry resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] admin_enabled: Specifies whether the admin user is enabled. Defaults to `false`.
        :param pulumi.Input[_builtins.str] admin_password: The Password associated with the Container Registry Admin account - if the admin account is enabled.
        :param pulumi.Input[_builtins.str] admin_username: The Username associated with the Container Registry Admin account - if the admin account is enabled.
        :param pulumi.Input[_builtins.bool] anonymous_pull_enabled: Whether to allow anonymous (unauthenticated) pull access to this Container Registry. This is only supported on resources with the `Standard` or `Premium` SKU.
        :param pulumi.Input[_builtins.bool] data_endpoint_enabled: Whether to enable dedicated data endpoints for this Container Registry? This is only supported on resources with the `Premium` SKU.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] data_endpoint_host_names: A set of data endpoint hostnames associated with the container registry if data endpoints are enabled.
        :param pulumi.Input[Union['RegistryEncryptionArgs', 'RegistryEncryptionArgsDict']] encryption: An `encryption` block as documented below.
        :param pulumi.Input[_builtins.bool] export_policy_enabled: Boolean value that indicates whether export policy is enabled. Defaults to `true`. In order to set it to `false`, make sure the `public_network_access_enabled` is also set to `false`.
               
               > **Note:** `quarantine_policy_enabled`, `retention_policy_in_days`, `trust_policy_enabled`, `export_policy_enabled` and `zone_redundancy_enabled` are only supported on resources with the `Premium` SKU.
        :param pulumi.Input[Sequence[pulumi.Input[Union['RegistryGeoreplicationArgs', 'RegistryGeoreplicationArgsDict']]]] georeplications: One or more `georeplications` blocks as documented below.
               
               > **Note:** The `georeplications` is only supported on new resources with the `Premium` SKU.
               
               > **Note:** The `georeplications` list cannot contain the location where the Container Registry exists.
               
               > **Note:** If more than one `georeplications` block is specified, they are expected to follow the alphabetic order on the `location` property.
        :param pulumi.Input[Union['RegistryIdentityArgs', 'RegistryIdentityArgsDict']] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.str] location: Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] login_server: The URL that can be used to log into the container registry.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Container Registry. Only Alphanumeric characters allowed. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] network_rule_bypass_option: Whether to allow trusted Azure services to access a network-restricted Container Registry? Possible values are `None` and `AzureServices`. Defaults to `AzureServices`.
        :param pulumi.Input[Union['RegistryNetworkRuleSetArgs', 'RegistryNetworkRuleSetArgsDict']] network_rule_set: A `network_rule_set` block as documented below.
        :param pulumi.Input[_builtins.bool] public_network_access_enabled: Whether public network access is allowed for the container registry. Defaults to `true`.
        :param pulumi.Input[_builtins.bool] quarantine_policy_enabled: Boolean value that indicates whether quarantine policy is enabled.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which to create the Container Registry. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] retention_policy_in_days: The number of days to retain and untagged manifest after which it gets purged. Defaults to `7`.
        :param pulumi.Input[_builtins.str] sku: The SKU name of the container registry. Possible values are `Basic`, `Standard` and `Premium`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.bool] trust_policy_enabled: Boolean value that indicated whether trust policy is enabled. Defaults to `false`.
        :param pulumi.Input[_builtins.bool] zone_redundancy_enabled: Whether zone redundancy is enabled for this Container Registry? Changing this forces a new resource to be created. Defaults to `false`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RegistryState.__new__(_RegistryState)

        __props__.__dict__["admin_enabled"] = admin_enabled
        __props__.__dict__["admin_password"] = admin_password
        __props__.__dict__["admin_username"] = admin_username
        __props__.__dict__["anonymous_pull_enabled"] = anonymous_pull_enabled
        __props__.__dict__["data_endpoint_enabled"] = data_endpoint_enabled
        __props__.__dict__["data_endpoint_host_names"] = data_endpoint_host_names
        __props__.__dict__["encryption"] = encryption
        __props__.__dict__["export_policy_enabled"] = export_policy_enabled
        __props__.__dict__["georeplications"] = georeplications
        __props__.__dict__["identity"] = identity
        __props__.__dict__["location"] = location
        __props__.__dict__["login_server"] = login_server
        __props__.__dict__["name"] = name
        __props__.__dict__["network_rule_bypass_option"] = network_rule_bypass_option
        __props__.__dict__["network_rule_set"] = network_rule_set
        __props__.__dict__["public_network_access_enabled"] = public_network_access_enabled
        __props__.__dict__["quarantine_policy_enabled"] = quarantine_policy_enabled
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["retention_policy_in_days"] = retention_policy_in_days
        __props__.__dict__["sku"] = sku
        __props__.__dict__["tags"] = tags
        __props__.__dict__["trust_policy_enabled"] = trust_policy_enabled
        __props__.__dict__["zone_redundancy_enabled"] = zone_redundancy_enabled
        return Registry(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="adminEnabled")
    def admin_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether the admin user is enabled. Defaults to `false`.
        """
        return pulumi.get(self, "admin_enabled")

    @_builtins.property
    @pulumi.getter(name="adminPassword")
    def admin_password(self) -> pulumi.Output[_builtins.str]:
        """
        The Password associated with the Container Registry Admin account - if the admin account is enabled.
        """
        return pulumi.get(self, "admin_password")

    @_builtins.property
    @pulumi.getter(name="adminUsername")
    def admin_username(self) -> pulumi.Output[_builtins.str]:
        """
        The Username associated with the Container Registry Admin account - if the admin account is enabled.
        """
        return pulumi.get(self, "admin_username")

    @_builtins.property
    @pulumi.getter(name="anonymousPullEnabled")
    def anonymous_pull_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to allow anonymous (unauthenticated) pull access to this Container Registry. This is only supported on resources with the `Standard` or `Premium` SKU.
        """
        return pulumi.get(self, "anonymous_pull_enabled")

    @_builtins.property
    @pulumi.getter(name="dataEndpointEnabled")
    def data_endpoint_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to enable dedicated data endpoints for this Container Registry? This is only supported on resources with the `Premium` SKU.
        """
        return pulumi.get(self, "data_endpoint_enabled")

    @_builtins.property
    @pulumi.getter(name="dataEndpointHostNames")
    def data_endpoint_host_names(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        A set of data endpoint hostnames associated with the container registry if data endpoints are enabled.
        """
        return pulumi.get(self, "data_endpoint_host_names")

    @_builtins.property
    @pulumi.getter
    def encryption(self) -> pulumi.Output['outputs.RegistryEncryption']:
        """
        An `encryption` block as documented below.
        """
        return pulumi.get(self, "encryption")

    @_builtins.property
    @pulumi.getter(name="exportPolicyEnabled")
    def export_policy_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Boolean value that indicates whether export policy is enabled. Defaults to `true`. In order to set it to `false`, make sure the `public_network_access_enabled` is also set to `false`.

        > **Note:** `quarantine_policy_enabled`, `retention_policy_in_days`, `trust_policy_enabled`, `export_policy_enabled` and `zone_redundancy_enabled` are only supported on resources with the `Premium` SKU.
        """
        return pulumi.get(self, "export_policy_enabled")

    @_builtins.property
    @pulumi.getter
    def georeplications(self) -> pulumi.Output[Optional[Sequence['outputs.RegistryGeoreplication']]]:
        """
        One or more `georeplications` blocks as documented below.

        > **Note:** The `georeplications` is only supported on new resources with the `Premium` SKU.

        > **Note:** The `georeplications` list cannot contain the location where the Container Registry exists.

        > **Note:** If more than one `georeplications` block is specified, they are expected to follow the alphabetic order on the `location` property.
        """
        return pulumi.get(self, "georeplications")

    @_builtins.property
    @pulumi.getter
    def identity(self) -> pulumi.Output[Optional['outputs.RegistryIdentity']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter(name="loginServer")
    def login_server(self) -> pulumi.Output[_builtins.str]:
        """
        The URL that can be used to log into the container registry.
        """
        return pulumi.get(self, "login_server")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of the Container Registry. Only Alphanumeric characters allowed. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="networkRuleBypassOption")
    def network_rule_bypass_option(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Whether to allow trusted Azure services to access a network-restricted Container Registry? Possible values are `None` and `AzureServices`. Defaults to `AzureServices`.
        """
        return pulumi.get(self, "network_rule_bypass_option")

    @_builtins.property
    @pulumi.getter(name="networkRuleSet")
    def network_rule_set(self) -> pulumi.Output['outputs.RegistryNetworkRuleSet']:
        """
        A `network_rule_set` block as documented below.
        """
        return pulumi.get(self, "network_rule_set")

    @_builtins.property
    @pulumi.getter(name="publicNetworkAccessEnabled")
    def public_network_access_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether public network access is allowed for the container registry. Defaults to `true`.
        """
        return pulumi.get(self, "public_network_access_enabled")

    @_builtins.property
    @pulumi.getter(name="quarantinePolicyEnabled")
    def quarantine_policy_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Boolean value that indicates whether quarantine policy is enabled.
        """
        return pulumi.get(self, "quarantine_policy_enabled")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the resource group in which to create the Container Registry. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter(name="retentionPolicyInDays")
    def retention_policy_in_days(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The number of days to retain and untagged manifest after which it gets purged. Defaults to `7`.
        """
        return pulumi.get(self, "retention_policy_in_days")

    @_builtins.property
    @pulumi.getter
    def sku(self) -> pulumi.Output[_builtins.str]:
        """
        The SKU name of the container registry. Possible values are `Basic`, `Standard` and `Premium`.
        """
        return pulumi.get(self, "sku")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="trustPolicyEnabled")
    def trust_policy_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Boolean value that indicated whether trust policy is enabled. Defaults to `false`.
        """
        return pulumi.get(self, "trust_policy_enabled")

    @_builtins.property
    @pulumi.getter(name="zoneRedundancyEnabled")
    def zone_redundancy_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether zone redundancy is enabled for this Container Registry? Changing this forces a new resource to be created. Defaults to `false`.
        """
        return pulumi.get(self, "zone_redundancy_enabled")

