# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['CustomerManagedKeyArgs', 'CustomerManagedKey']

@pulumi.input_type
class CustomerManagedKeyArgs:
    def __init__(__self__, *,
                 customer_managed_key_id: pulumi.Input[_builtins.str],
                 data_factory_id: pulumi.Input[_builtins.str],
                 user_assigned_identity_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a CustomerManagedKey resource.
        :param pulumi.Input[_builtins.str] customer_managed_key_id: The ID the of the Customer Managed Key to associate with the Data Factory.
        :param pulumi.Input[_builtins.str] data_factory_id: The ID of the Data Factory Resource the Customer Managed Key will be associated with. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] user_assigned_identity_id: The User Assigned Identity ID that will be used to access Key Vaults that contain the encryption keys.
        """
        pulumi.set(__self__, "customer_managed_key_id", customer_managed_key_id)
        pulumi.set(__self__, "data_factory_id", data_factory_id)
        if user_assigned_identity_id is not None:
            pulumi.set(__self__, "user_assigned_identity_id", user_assigned_identity_id)

    @_builtins.property
    @pulumi.getter(name="customerManagedKeyId")
    def customer_managed_key_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID the of the Customer Managed Key to associate with the Data Factory.
        """
        return pulumi.get(self, "customer_managed_key_id")

    @customer_managed_key_id.setter
    def customer_managed_key_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "customer_managed_key_id", value)

    @_builtins.property
    @pulumi.getter(name="dataFactoryId")
    def data_factory_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Data Factory Resource the Customer Managed Key will be associated with. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "data_factory_id")

    @data_factory_id.setter
    def data_factory_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "data_factory_id", value)

    @_builtins.property
    @pulumi.getter(name="userAssignedIdentityId")
    def user_assigned_identity_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The User Assigned Identity ID that will be used to access Key Vaults that contain the encryption keys.
        """
        return pulumi.get(self, "user_assigned_identity_id")

    @user_assigned_identity_id.setter
    def user_assigned_identity_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_assigned_identity_id", value)


@pulumi.input_type
class _CustomerManagedKeyState:
    def __init__(__self__, *,
                 customer_managed_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 data_factory_id: Optional[pulumi.Input[_builtins.str]] = None,
                 user_assigned_identity_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering CustomerManagedKey resources.
        :param pulumi.Input[_builtins.str] customer_managed_key_id: The ID the of the Customer Managed Key to associate with the Data Factory.
        :param pulumi.Input[_builtins.str] data_factory_id: The ID of the Data Factory Resource the Customer Managed Key will be associated with. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] user_assigned_identity_id: The User Assigned Identity ID that will be used to access Key Vaults that contain the encryption keys.
        """
        if customer_managed_key_id is not None:
            pulumi.set(__self__, "customer_managed_key_id", customer_managed_key_id)
        if data_factory_id is not None:
            pulumi.set(__self__, "data_factory_id", data_factory_id)
        if user_assigned_identity_id is not None:
            pulumi.set(__self__, "user_assigned_identity_id", user_assigned_identity_id)

    @_builtins.property
    @pulumi.getter(name="customerManagedKeyId")
    def customer_managed_key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID the of the Customer Managed Key to associate with the Data Factory.
        """
        return pulumi.get(self, "customer_managed_key_id")

    @customer_managed_key_id.setter
    def customer_managed_key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "customer_managed_key_id", value)

    @_builtins.property
    @pulumi.getter(name="dataFactoryId")
    def data_factory_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Data Factory Resource the Customer Managed Key will be associated with. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "data_factory_id")

    @data_factory_id.setter
    def data_factory_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "data_factory_id", value)

    @_builtins.property
    @pulumi.getter(name="userAssignedIdentityId")
    def user_assigned_identity_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The User Assigned Identity ID that will be used to access Key Vaults that contain the encryption keys.
        """
        return pulumi.get(self, "user_assigned_identity_id")

    @user_assigned_identity_id.setter
    def user_assigned_identity_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_assigned_identity_id", value)


@pulumi.type_token("azure:datafactory/customerManagedKey:CustomerManagedKey")
class CustomerManagedKey(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 customer_managed_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 data_factory_id: Optional[pulumi.Input[_builtins.str]] = None,
                 user_assigned_identity_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a Customer Managed Key for a Data Factory.

        > **Note:** The Customer Managed Key cannot be removed from the Data Factory once added. To remove the Customer Managed Key delete and recreate the parent Data Factory.

        ## Example Usage

        ### With System Assigned Identity

        ```python
        import pulumi
        import pulumi_azure as azure

        current = azure.core.get_client_config()
        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_key_vault = azure.keyvault.KeyVault("example",
            name="example-key-vault",
            location=example.location,
            resource_group_name=example.name,
            tenant_id=current.tenant_id,
            sku_name="standard",
            purge_protection_enabled=True)
        example_key = azure.keyvault.Key("example",
            name="examplekey",
            key_vault_id=example_key_vault.id,
            key_type="RSA",
            key_size=2048,
            key_opts=[
                "unwrapKey",
                "wrapKey",
            ])
        current_client_policy = azure.keyvault.AccessPolicy("current_client_policy",
            key_vault_id=example_key_vault.id,
            tenant_id=current.tenant_id,
            object_id=current.object_id,
            key_permissions=[
                "Create",
                "Delete",
                "Get",
                "Purge",
                "Recover",
                "Update",
                "GetRotationPolicy",
            ],
            secret_permissions=[
                "Delete",
                "Get",
                "Set",
            ])
        example_factory = azure.datafactory.Factory("example",
            name="example_data_factory",
            location=example.location,
            resource_group_name=example.name,
            identity={
                "type": "SystemAssigned",
                "identity_ids": [example_azurerm_user_assigned_identity["id"]],
            })
        datafactory = azure.keyvault.AccessPolicy("datafactory",
            key_vault_id=example_key_vault.id,
            tenant_id=example_factory.identity.tenant_id,
            object_id=example_factory.identity.principal_id,
            key_permissions=[
                "Create",
                "Delete",
                "Get",
                "Purge",
                "Recover",
                "Update",
                "GetRotationPolicy",
                "WrapKey",
                "UnwrapKey",
            ],
            secret_permissions=[
                "Delete",
                "Get",
                "Set",
            ])
        example_customer_managed_key = azure.datafactory.CustomerManagedKey("example",
            data_factory_id=example_factory.id,
            customer_managed_key_id=example_key.id)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.DataFactory` - 2018-06-01

        ## Import

        Data Factory Customer Managed Keys can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:datafactory/customerManagedKey:CustomerManagedKey example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/example/providers/Microsoft.DataFactory/factories/example
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] customer_managed_key_id: The ID the of the Customer Managed Key to associate with the Data Factory.
        :param pulumi.Input[_builtins.str] data_factory_id: The ID of the Data Factory Resource the Customer Managed Key will be associated with. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] user_assigned_identity_id: The User Assigned Identity ID that will be used to access Key Vaults that contain the encryption keys.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CustomerManagedKeyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Customer Managed Key for a Data Factory.

        > **Note:** The Customer Managed Key cannot be removed from the Data Factory once added. To remove the Customer Managed Key delete and recreate the parent Data Factory.

        ## Example Usage

        ### With System Assigned Identity

        ```python
        import pulumi
        import pulumi_azure as azure

        current = azure.core.get_client_config()
        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_key_vault = azure.keyvault.KeyVault("example",
            name="example-key-vault",
            location=example.location,
            resource_group_name=example.name,
            tenant_id=current.tenant_id,
            sku_name="standard",
            purge_protection_enabled=True)
        example_key = azure.keyvault.Key("example",
            name="examplekey",
            key_vault_id=example_key_vault.id,
            key_type="RSA",
            key_size=2048,
            key_opts=[
                "unwrapKey",
                "wrapKey",
            ])
        current_client_policy = azure.keyvault.AccessPolicy("current_client_policy",
            key_vault_id=example_key_vault.id,
            tenant_id=current.tenant_id,
            object_id=current.object_id,
            key_permissions=[
                "Create",
                "Delete",
                "Get",
                "Purge",
                "Recover",
                "Update",
                "GetRotationPolicy",
            ],
            secret_permissions=[
                "Delete",
                "Get",
                "Set",
            ])
        example_factory = azure.datafactory.Factory("example",
            name="example_data_factory",
            location=example.location,
            resource_group_name=example.name,
            identity={
                "type": "SystemAssigned",
                "identity_ids": [example_azurerm_user_assigned_identity["id"]],
            })
        datafactory = azure.keyvault.AccessPolicy("datafactory",
            key_vault_id=example_key_vault.id,
            tenant_id=example_factory.identity.tenant_id,
            object_id=example_factory.identity.principal_id,
            key_permissions=[
                "Create",
                "Delete",
                "Get",
                "Purge",
                "Recover",
                "Update",
                "GetRotationPolicy",
                "WrapKey",
                "UnwrapKey",
            ],
            secret_permissions=[
                "Delete",
                "Get",
                "Set",
            ])
        example_customer_managed_key = azure.datafactory.CustomerManagedKey("example",
            data_factory_id=example_factory.id,
            customer_managed_key_id=example_key.id)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.DataFactory` - 2018-06-01

        ## Import

        Data Factory Customer Managed Keys can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:datafactory/customerManagedKey:CustomerManagedKey example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/example/providers/Microsoft.DataFactory/factories/example
        ```

        :param str resource_name: The name of the resource.
        :param CustomerManagedKeyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CustomerManagedKeyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 customer_managed_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 data_factory_id: Optional[pulumi.Input[_builtins.str]] = None,
                 user_assigned_identity_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CustomerManagedKeyArgs.__new__(CustomerManagedKeyArgs)

            if customer_managed_key_id is None and not opts.urn:
                raise TypeError("Missing required property 'customer_managed_key_id'")
            __props__.__dict__["customer_managed_key_id"] = customer_managed_key_id
            if data_factory_id is None and not opts.urn:
                raise TypeError("Missing required property 'data_factory_id'")
            __props__.__dict__["data_factory_id"] = data_factory_id
            __props__.__dict__["user_assigned_identity_id"] = user_assigned_identity_id
        super(CustomerManagedKey, __self__).__init__(
            'azure:datafactory/customerManagedKey:CustomerManagedKey',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            customer_managed_key_id: Optional[pulumi.Input[_builtins.str]] = None,
            data_factory_id: Optional[pulumi.Input[_builtins.str]] = None,
            user_assigned_identity_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'CustomerManagedKey':
        """
        Get an existing CustomerManagedKey resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] customer_managed_key_id: The ID the of the Customer Managed Key to associate with the Data Factory.
        :param pulumi.Input[_builtins.str] data_factory_id: The ID of the Data Factory Resource the Customer Managed Key will be associated with. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] user_assigned_identity_id: The User Assigned Identity ID that will be used to access Key Vaults that contain the encryption keys.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CustomerManagedKeyState.__new__(_CustomerManagedKeyState)

        __props__.__dict__["customer_managed_key_id"] = customer_managed_key_id
        __props__.__dict__["data_factory_id"] = data_factory_id
        __props__.__dict__["user_assigned_identity_id"] = user_assigned_identity_id
        return CustomerManagedKey(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="customerManagedKeyId")
    def customer_managed_key_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID the of the Customer Managed Key to associate with the Data Factory.
        """
        return pulumi.get(self, "customer_managed_key_id")

    @_builtins.property
    @pulumi.getter(name="dataFactoryId")
    def data_factory_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Data Factory Resource the Customer Managed Key will be associated with. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "data_factory_id")

    @_builtins.property
    @pulumi.getter(name="userAssignedIdentityId")
    def user_assigned_identity_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The User Assigned Identity ID that will be used to access Key Vaults that contain the encryption keys.
        """
        return pulumi.get(self, "user_assigned_identity_id")

