# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['BackupInstanceKubernetesClusterArgs', 'BackupInstanceKubernetesCluster']

@pulumi.input_type
class BackupInstanceKubernetesClusterArgs:
    def __init__(__self__, *,
                 backup_policy_id: pulumi.Input[_builtins.str],
                 kubernetes_cluster_id: pulumi.Input[_builtins.str],
                 snapshot_resource_group_name: pulumi.Input[_builtins.str],
                 vault_id: pulumi.Input[_builtins.str],
                 backup_datasource_parameters: Optional[pulumi.Input['BackupInstanceKubernetesClusterBackupDatasourceParametersArgs']] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a BackupInstanceKubernetesCluster resource.
        :param pulumi.Input[_builtins.str] backup_policy_id: The ID of the Backup Policy. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] kubernetes_cluster_id: The ID of the Kubernetes Cluster. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] snapshot_resource_group_name: The name of the Resource Group where snapshots are stored. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] vault_id: The ID of the Backup Vault within which the Backup Instance Kubernetes Cluster should exist. Changing this forces a new resource to be created.
        :param pulumi.Input['BackupInstanceKubernetesClusterBackupDatasourceParametersArgs'] backup_datasource_parameters: A `backup_datasource_parameters` block as defined below.
        :param pulumi.Input[_builtins.str] location: The location of the Backup Instance Kubernetes Cluster. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Backup Instance Kubernetes Cluster. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "backup_policy_id", backup_policy_id)
        pulumi.set(__self__, "kubernetes_cluster_id", kubernetes_cluster_id)
        pulumi.set(__self__, "snapshot_resource_group_name", snapshot_resource_group_name)
        pulumi.set(__self__, "vault_id", vault_id)
        if backup_datasource_parameters is not None:
            pulumi.set(__self__, "backup_datasource_parameters", backup_datasource_parameters)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="backupPolicyId")
    def backup_policy_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Backup Policy. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "backup_policy_id")

    @backup_policy_id.setter
    def backup_policy_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "backup_policy_id", value)

    @_builtins.property
    @pulumi.getter(name="kubernetesClusterId")
    def kubernetes_cluster_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Kubernetes Cluster. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "kubernetes_cluster_id")

    @kubernetes_cluster_id.setter
    def kubernetes_cluster_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "kubernetes_cluster_id", value)

    @_builtins.property
    @pulumi.getter(name="snapshotResourceGroupName")
    def snapshot_resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the Resource Group where snapshots are stored. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "snapshot_resource_group_name")

    @snapshot_resource_group_name.setter
    def snapshot_resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "snapshot_resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="vaultId")
    def vault_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Backup Vault within which the Backup Instance Kubernetes Cluster should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "vault_id")

    @vault_id.setter
    def vault_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "vault_id", value)

    @_builtins.property
    @pulumi.getter(name="backupDatasourceParameters")
    def backup_datasource_parameters(self) -> Optional[pulumi.Input['BackupInstanceKubernetesClusterBackupDatasourceParametersArgs']]:
        """
        A `backup_datasource_parameters` block as defined below.
        """
        return pulumi.get(self, "backup_datasource_parameters")

    @backup_datasource_parameters.setter
    def backup_datasource_parameters(self, value: Optional[pulumi.Input['BackupInstanceKubernetesClusterBackupDatasourceParametersArgs']]):
        pulumi.set(self, "backup_datasource_parameters", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The location of the Backup Instance Kubernetes Cluster. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Backup Instance Kubernetes Cluster. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _BackupInstanceKubernetesClusterState:
    def __init__(__self__, *,
                 backup_datasource_parameters: Optional[pulumi.Input['BackupInstanceKubernetesClusterBackupDatasourceParametersArgs']] = None,
                 backup_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 kubernetes_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 snapshot_resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 vault_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering BackupInstanceKubernetesCluster resources.
        :param pulumi.Input['BackupInstanceKubernetesClusterBackupDatasourceParametersArgs'] backup_datasource_parameters: A `backup_datasource_parameters` block as defined below.
        :param pulumi.Input[_builtins.str] backup_policy_id: The ID of the Backup Policy. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] kubernetes_cluster_id: The ID of the Kubernetes Cluster. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] location: The location of the Backup Instance Kubernetes Cluster. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Backup Instance Kubernetes Cluster. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] snapshot_resource_group_name: The name of the Resource Group where snapshots are stored. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] vault_id: The ID of the Backup Vault within which the Backup Instance Kubernetes Cluster should exist. Changing this forces a new resource to be created.
        """
        if backup_datasource_parameters is not None:
            pulumi.set(__self__, "backup_datasource_parameters", backup_datasource_parameters)
        if backup_policy_id is not None:
            pulumi.set(__self__, "backup_policy_id", backup_policy_id)
        if kubernetes_cluster_id is not None:
            pulumi.set(__self__, "kubernetes_cluster_id", kubernetes_cluster_id)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if snapshot_resource_group_name is not None:
            pulumi.set(__self__, "snapshot_resource_group_name", snapshot_resource_group_name)
        if vault_id is not None:
            pulumi.set(__self__, "vault_id", vault_id)

    @_builtins.property
    @pulumi.getter(name="backupDatasourceParameters")
    def backup_datasource_parameters(self) -> Optional[pulumi.Input['BackupInstanceKubernetesClusterBackupDatasourceParametersArgs']]:
        """
        A `backup_datasource_parameters` block as defined below.
        """
        return pulumi.get(self, "backup_datasource_parameters")

    @backup_datasource_parameters.setter
    def backup_datasource_parameters(self, value: Optional[pulumi.Input['BackupInstanceKubernetesClusterBackupDatasourceParametersArgs']]):
        pulumi.set(self, "backup_datasource_parameters", value)

    @_builtins.property
    @pulumi.getter(name="backupPolicyId")
    def backup_policy_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Backup Policy. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "backup_policy_id")

    @backup_policy_id.setter
    def backup_policy_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backup_policy_id", value)

    @_builtins.property
    @pulumi.getter(name="kubernetesClusterId")
    def kubernetes_cluster_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Kubernetes Cluster. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "kubernetes_cluster_id")

    @kubernetes_cluster_id.setter
    def kubernetes_cluster_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kubernetes_cluster_id", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The location of the Backup Instance Kubernetes Cluster. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Backup Instance Kubernetes Cluster. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="snapshotResourceGroupName")
    def snapshot_resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Resource Group where snapshots are stored. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "snapshot_resource_group_name")

    @snapshot_resource_group_name.setter
    def snapshot_resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "snapshot_resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="vaultId")
    def vault_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Backup Vault within which the Backup Instance Kubernetes Cluster should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "vault_id")

    @vault_id.setter
    def vault_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vault_id", value)


@pulumi.type_token("azure:dataprotection/backupInstanceKubernetesCluster:BackupInstanceKubernetesCluster")
class BackupInstanceKubernetesCluster(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backup_datasource_parameters: Optional[pulumi.Input[Union['BackupInstanceKubernetesClusterBackupDatasourceParametersArgs', 'BackupInstanceKubernetesClusterBackupDatasourceParametersArgsDict']]] = None,
                 backup_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 kubernetes_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 snapshot_resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 vault_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a Backup Instance to back up a Kubernetes Cluster.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        current = azure.core.get_client_config()
        example = azure.core.ResourceGroup("example",
            name="example",
            location="West Europe")
        snap = azure.core.ResourceGroup("snap",
            name="example-snap",
            location="West Europe")
        example_backup_vault = azure.dataprotection.BackupVault("example",
            name="example",
            resource_group_name=example.name,
            location=example.location,
            datastore_type="VaultStore",
            redundancy="LocallyRedundant",
            identity={
                "type": "SystemAssigned",
            })
        example_kubernetes_cluster = azure.containerservice.KubernetesCluster("example",
            name="example",
            location=example.location,
            resource_group_name=example.name,
            dns_prefix="dns",
            default_node_pool={
                "name": "default",
                "node_count": 1,
                "vm_size": "Standard_DS2_v2",
                "host_encryption_enabled": True,
            },
            identity={
                "type": "SystemAssigned",
            })
        aks_cluster_trusted_access = azure.containerservice.ClusterTrustedAccessRoleBinding("aks_cluster_trusted_access",
            kubernetes_cluster_id=example_kubernetes_cluster.id,
            name="example",
            roles=["Microsoft.DataProtection/backupVaults/backup-operator"],
            source_resource_id=example_backup_vault.id)
        example_account = azure.storage.Account("example",
            name="example",
            resource_group_name=example.name,
            location=example.location,
            account_tier="Standard",
            account_replication_type="LRS")
        example_container = azure.storage.Container("example",
            name="example",
            storage_account_name=example_account.name,
            container_access_type="private")
        example_kubernetes_cluster_extension = azure.containerservice.KubernetesClusterExtension("example",
            name="example",
            cluster_id=example_kubernetes_cluster.id,
            extension_type="Microsoft.DataProtection.Kubernetes",
            release_train="stable",
            release_namespace="dataprotection-microsoft",
            configuration_settings={
                "configuration.backupStorageLocation.bucket": example_container.name,
                "configuration.backupStorageLocation.config.resourceGroup": example.name,
                "configuration.backupStorageLocation.config.storageAccount": example_account.name,
                "configuration.backupStorageLocation.config.subscriptionId": current.subscription_id,
                "credentials.tenantId": current.tenant_id,
            })
        test_extension_and_storage_account_permission = azure.authorization.Assignment("test_extension_and_storage_account_permission",
            scope=example_account.id,
            role_definition_name="Storage Account Contributor",
            principal_id=example_kubernetes_cluster_extension.aks_assigned_identities[0].principal_id)
        test_vault_msi_read_on_cluster = azure.authorization.Assignment("test_vault_msi_read_on_cluster",
            scope=example_kubernetes_cluster.id,
            role_definition_name="Reader",
            principal_id=example_backup_vault.identity.principal_id)
        test_vault_msi_read_on_snap_rg = azure.authorization.Assignment("test_vault_msi_read_on_snap_rg",
            scope=snap.id,
            role_definition_name="Reader",
            principal_id=example_backup_vault.identity.principal_id)
        test_vault_msi_snapshot_contributor_on_snap_rg = azure.authorization.Assignment("test_vault_msi_snapshot_contributor_on_snap_rg",
            scope=snap.id,
            role_definition_name="Disk Snapshot Contributor",
            principal_id=example_backup_vault.identity.principal_id)
        test_vault_data_operator_on_snap_rg = azure.authorization.Assignment("test_vault_data_operator_on_snap_rg",
            scope=snap.id,
            role_definition_name="Data Operator for Managed Disks",
            principal_id=example_backup_vault.identity.principal_id)
        test_vault_data_contributor_on_storage = azure.authorization.Assignment("test_vault_data_contributor_on_storage",
            scope=example_account.id,
            role_definition_name="Storage Blob Data Contributor",
            principal_id=example_backup_vault.identity.principal_id)
        test_cluster_msi_contributor_on_snap_rg = azure.authorization.Assignment("test_cluster_msi_contributor_on_snap_rg",
            scope=snap.id,
            role_definition_name="Contributor",
            principal_id=example_kubernetes_cluster.identity.principal_id)
        example_backup_policy_kubernetes_cluster = azure.dataprotection.BackupPolicyKubernetesCluster("example",
            name="example",
            resource_group_name=example.name,
            vault_name=example_backup_vault.name,
            backup_repeating_time_intervals=["R/2023-05-23T02:30:00+00:00/P1W"],
            retention_rules=[{
                "name": "Daily",
                "priority": 25,
                "life_cycles": [{
                    "duration": "P84D",
                    "data_store_type": "OperationalStore",
                }],
                "criteria": {
                    "days_of_weeks": ["Thursday"],
                    "months_of_years": ["November"],
                    "weeks_of_months": ["First"],
                    "scheduled_backup_times": ["2023-05-23T02:30:00Z"],
                },
            }],
            default_retention_rule={
                "life_cycles": [{
                    "duration": "P14D",
                    "data_store_type": "OperationalStore",
                }],
            })
        example_backup_instance_kubernetes_cluster = azure.dataprotection.BackupInstanceKubernetesCluster("example",
            name="example",
            location=example.location,
            vault_id=example_backup_vault.id,
            kubernetes_cluster_id=example_kubernetes_cluster.id,
            snapshot_resource_group_name=snap.name,
            backup_policy_id=example_backup_policy_kubernetes_cluster.id,
            backup_datasource_parameters={
                "excluded_namespaces": ["test-excluded-namespaces"],
                "excluded_resource_types": ["exvolumesnapshotcontents.snapshot.storage.k8s.io"],
                "cluster_scoped_resources_enabled": True,
                "included_namespaces": ["test-included-namespaces"],
                "included_resource_types": ["involumesnapshotcontents.snapshot.storage.k8s.io"],
                "label_selectors": ["kubernetes.io/metadata.name:test"],
                "volume_snapshot_enabled": True,
            },
            opts = pulumi.ResourceOptions(depends_on=[
                    test_extension_and_storage_account_permission,
                    test_vault_msi_read_on_cluster,
                    test_vault_msi_read_on_snap_rg,
                    test_cluster_msi_contributor_on_snap_rg,
                    test_vault_msi_snapshot_contributor_on_snap_rg,
                    test_vault_data_operator_on_snap_rg,
                    test_vault_data_contributor_on_storage,
                ]))
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.DataProtection` - 2024-04-01

        ## Import

        Backup Instance Kubernetes Cluster can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:dataprotection/backupInstanceKubernetesCluster:BackupInstanceKubernetesCluster example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.DataProtection/backupVaults/vault1/backupInstances/backupInstance1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['BackupInstanceKubernetesClusterBackupDatasourceParametersArgs', 'BackupInstanceKubernetesClusterBackupDatasourceParametersArgsDict']] backup_datasource_parameters: A `backup_datasource_parameters` block as defined below.
        :param pulumi.Input[_builtins.str] backup_policy_id: The ID of the Backup Policy. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] kubernetes_cluster_id: The ID of the Kubernetes Cluster. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] location: The location of the Backup Instance Kubernetes Cluster. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Backup Instance Kubernetes Cluster. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] snapshot_resource_group_name: The name of the Resource Group where snapshots are stored. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] vault_id: The ID of the Backup Vault within which the Backup Instance Kubernetes Cluster should exist. Changing this forces a new resource to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: BackupInstanceKubernetesClusterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Backup Instance to back up a Kubernetes Cluster.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        current = azure.core.get_client_config()
        example = azure.core.ResourceGroup("example",
            name="example",
            location="West Europe")
        snap = azure.core.ResourceGroup("snap",
            name="example-snap",
            location="West Europe")
        example_backup_vault = azure.dataprotection.BackupVault("example",
            name="example",
            resource_group_name=example.name,
            location=example.location,
            datastore_type="VaultStore",
            redundancy="LocallyRedundant",
            identity={
                "type": "SystemAssigned",
            })
        example_kubernetes_cluster = azure.containerservice.KubernetesCluster("example",
            name="example",
            location=example.location,
            resource_group_name=example.name,
            dns_prefix="dns",
            default_node_pool={
                "name": "default",
                "node_count": 1,
                "vm_size": "Standard_DS2_v2",
                "host_encryption_enabled": True,
            },
            identity={
                "type": "SystemAssigned",
            })
        aks_cluster_trusted_access = azure.containerservice.ClusterTrustedAccessRoleBinding("aks_cluster_trusted_access",
            kubernetes_cluster_id=example_kubernetes_cluster.id,
            name="example",
            roles=["Microsoft.DataProtection/backupVaults/backup-operator"],
            source_resource_id=example_backup_vault.id)
        example_account = azure.storage.Account("example",
            name="example",
            resource_group_name=example.name,
            location=example.location,
            account_tier="Standard",
            account_replication_type="LRS")
        example_container = azure.storage.Container("example",
            name="example",
            storage_account_name=example_account.name,
            container_access_type="private")
        example_kubernetes_cluster_extension = azure.containerservice.KubernetesClusterExtension("example",
            name="example",
            cluster_id=example_kubernetes_cluster.id,
            extension_type="Microsoft.DataProtection.Kubernetes",
            release_train="stable",
            release_namespace="dataprotection-microsoft",
            configuration_settings={
                "configuration.backupStorageLocation.bucket": example_container.name,
                "configuration.backupStorageLocation.config.resourceGroup": example.name,
                "configuration.backupStorageLocation.config.storageAccount": example_account.name,
                "configuration.backupStorageLocation.config.subscriptionId": current.subscription_id,
                "credentials.tenantId": current.tenant_id,
            })
        test_extension_and_storage_account_permission = azure.authorization.Assignment("test_extension_and_storage_account_permission",
            scope=example_account.id,
            role_definition_name="Storage Account Contributor",
            principal_id=example_kubernetes_cluster_extension.aks_assigned_identities[0].principal_id)
        test_vault_msi_read_on_cluster = azure.authorization.Assignment("test_vault_msi_read_on_cluster",
            scope=example_kubernetes_cluster.id,
            role_definition_name="Reader",
            principal_id=example_backup_vault.identity.principal_id)
        test_vault_msi_read_on_snap_rg = azure.authorization.Assignment("test_vault_msi_read_on_snap_rg",
            scope=snap.id,
            role_definition_name="Reader",
            principal_id=example_backup_vault.identity.principal_id)
        test_vault_msi_snapshot_contributor_on_snap_rg = azure.authorization.Assignment("test_vault_msi_snapshot_contributor_on_snap_rg",
            scope=snap.id,
            role_definition_name="Disk Snapshot Contributor",
            principal_id=example_backup_vault.identity.principal_id)
        test_vault_data_operator_on_snap_rg = azure.authorization.Assignment("test_vault_data_operator_on_snap_rg",
            scope=snap.id,
            role_definition_name="Data Operator for Managed Disks",
            principal_id=example_backup_vault.identity.principal_id)
        test_vault_data_contributor_on_storage = azure.authorization.Assignment("test_vault_data_contributor_on_storage",
            scope=example_account.id,
            role_definition_name="Storage Blob Data Contributor",
            principal_id=example_backup_vault.identity.principal_id)
        test_cluster_msi_contributor_on_snap_rg = azure.authorization.Assignment("test_cluster_msi_contributor_on_snap_rg",
            scope=snap.id,
            role_definition_name="Contributor",
            principal_id=example_kubernetes_cluster.identity.principal_id)
        example_backup_policy_kubernetes_cluster = azure.dataprotection.BackupPolicyKubernetesCluster("example",
            name="example",
            resource_group_name=example.name,
            vault_name=example_backup_vault.name,
            backup_repeating_time_intervals=["R/2023-05-23T02:30:00+00:00/P1W"],
            retention_rules=[{
                "name": "Daily",
                "priority": 25,
                "life_cycles": [{
                    "duration": "P84D",
                    "data_store_type": "OperationalStore",
                }],
                "criteria": {
                    "days_of_weeks": ["Thursday"],
                    "months_of_years": ["November"],
                    "weeks_of_months": ["First"],
                    "scheduled_backup_times": ["2023-05-23T02:30:00Z"],
                },
            }],
            default_retention_rule={
                "life_cycles": [{
                    "duration": "P14D",
                    "data_store_type": "OperationalStore",
                }],
            })
        example_backup_instance_kubernetes_cluster = azure.dataprotection.BackupInstanceKubernetesCluster("example",
            name="example",
            location=example.location,
            vault_id=example_backup_vault.id,
            kubernetes_cluster_id=example_kubernetes_cluster.id,
            snapshot_resource_group_name=snap.name,
            backup_policy_id=example_backup_policy_kubernetes_cluster.id,
            backup_datasource_parameters={
                "excluded_namespaces": ["test-excluded-namespaces"],
                "excluded_resource_types": ["exvolumesnapshotcontents.snapshot.storage.k8s.io"],
                "cluster_scoped_resources_enabled": True,
                "included_namespaces": ["test-included-namespaces"],
                "included_resource_types": ["involumesnapshotcontents.snapshot.storage.k8s.io"],
                "label_selectors": ["kubernetes.io/metadata.name:test"],
                "volume_snapshot_enabled": True,
            },
            opts = pulumi.ResourceOptions(depends_on=[
                    test_extension_and_storage_account_permission,
                    test_vault_msi_read_on_cluster,
                    test_vault_msi_read_on_snap_rg,
                    test_cluster_msi_contributor_on_snap_rg,
                    test_vault_msi_snapshot_contributor_on_snap_rg,
                    test_vault_data_operator_on_snap_rg,
                    test_vault_data_contributor_on_storage,
                ]))
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.DataProtection` - 2024-04-01

        ## Import

        Backup Instance Kubernetes Cluster can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:dataprotection/backupInstanceKubernetesCluster:BackupInstanceKubernetesCluster example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.DataProtection/backupVaults/vault1/backupInstances/backupInstance1
        ```

        :param str resource_name: The name of the resource.
        :param BackupInstanceKubernetesClusterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BackupInstanceKubernetesClusterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backup_datasource_parameters: Optional[pulumi.Input[Union['BackupInstanceKubernetesClusterBackupDatasourceParametersArgs', 'BackupInstanceKubernetesClusterBackupDatasourceParametersArgsDict']]] = None,
                 backup_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 kubernetes_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 snapshot_resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 vault_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BackupInstanceKubernetesClusterArgs.__new__(BackupInstanceKubernetesClusterArgs)

            __props__.__dict__["backup_datasource_parameters"] = backup_datasource_parameters
            if backup_policy_id is None and not opts.urn:
                raise TypeError("Missing required property 'backup_policy_id'")
            __props__.__dict__["backup_policy_id"] = backup_policy_id
            if kubernetes_cluster_id is None and not opts.urn:
                raise TypeError("Missing required property 'kubernetes_cluster_id'")
            __props__.__dict__["kubernetes_cluster_id"] = kubernetes_cluster_id
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            if snapshot_resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'snapshot_resource_group_name'")
            __props__.__dict__["snapshot_resource_group_name"] = snapshot_resource_group_name
            if vault_id is None and not opts.urn:
                raise TypeError("Missing required property 'vault_id'")
            __props__.__dict__["vault_id"] = vault_id
        super(BackupInstanceKubernetesCluster, __self__).__init__(
            'azure:dataprotection/backupInstanceKubernetesCluster:BackupInstanceKubernetesCluster',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            backup_datasource_parameters: Optional[pulumi.Input[Union['BackupInstanceKubernetesClusterBackupDatasourceParametersArgs', 'BackupInstanceKubernetesClusterBackupDatasourceParametersArgsDict']]] = None,
            backup_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
            kubernetes_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            snapshot_resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            vault_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'BackupInstanceKubernetesCluster':
        """
        Get an existing BackupInstanceKubernetesCluster resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['BackupInstanceKubernetesClusterBackupDatasourceParametersArgs', 'BackupInstanceKubernetesClusterBackupDatasourceParametersArgsDict']] backup_datasource_parameters: A `backup_datasource_parameters` block as defined below.
        :param pulumi.Input[_builtins.str] backup_policy_id: The ID of the Backup Policy. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] kubernetes_cluster_id: The ID of the Kubernetes Cluster. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] location: The location of the Backup Instance Kubernetes Cluster. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Backup Instance Kubernetes Cluster. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] snapshot_resource_group_name: The name of the Resource Group where snapshots are stored. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] vault_id: The ID of the Backup Vault within which the Backup Instance Kubernetes Cluster should exist. Changing this forces a new resource to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _BackupInstanceKubernetesClusterState.__new__(_BackupInstanceKubernetesClusterState)

        __props__.__dict__["backup_datasource_parameters"] = backup_datasource_parameters
        __props__.__dict__["backup_policy_id"] = backup_policy_id
        __props__.__dict__["kubernetes_cluster_id"] = kubernetes_cluster_id
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["snapshot_resource_group_name"] = snapshot_resource_group_name
        __props__.__dict__["vault_id"] = vault_id
        return BackupInstanceKubernetesCluster(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="backupDatasourceParameters")
    def backup_datasource_parameters(self) -> pulumi.Output[Optional['outputs.BackupInstanceKubernetesClusterBackupDatasourceParameters']]:
        """
        A `backup_datasource_parameters` block as defined below.
        """
        return pulumi.get(self, "backup_datasource_parameters")

    @_builtins.property
    @pulumi.getter(name="backupPolicyId")
    def backup_policy_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Backup Policy. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "backup_policy_id")

    @_builtins.property
    @pulumi.getter(name="kubernetesClusterId")
    def kubernetes_cluster_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Kubernetes Cluster. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "kubernetes_cluster_id")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        The location of the Backup Instance Kubernetes Cluster. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name which should be used for this Backup Instance Kubernetes Cluster. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="snapshotResourceGroupName")
    def snapshot_resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Resource Group where snapshots are stored. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "snapshot_resource_group_name")

    @_builtins.property
    @pulumi.getter(name="vaultId")
    def vault_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Backup Vault within which the Backup Instance Kubernetes Cluster should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "vault_id")

