# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['BackupInstancePostgresqlFlexibleServerArgs', 'BackupInstancePostgresqlFlexibleServer']

@pulumi.input_type
class BackupInstancePostgresqlFlexibleServerArgs:
    def __init__(__self__, *,
                 backup_policy_id: pulumi.Input[_builtins.str],
                 server_id: pulumi.Input[_builtins.str],
                 vault_id: pulumi.Input[_builtins.str],
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a BackupInstancePostgresqlFlexibleServer resource.
        :param pulumi.Input[_builtins.str] backup_policy_id: The ID of the Backup Policy.
        :param pulumi.Input[_builtins.str] server_id: The ID of the source server. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] vault_id: The ID of the Backup Vault within which the PostgreSQL Flexible Server Backup Instance should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] location: The location of the source database. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Backup Instance for the PostgreSQL Flexible Server. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "backup_policy_id", backup_policy_id)
        pulumi.set(__self__, "server_id", server_id)
        pulumi.set(__self__, "vault_id", vault_id)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="backupPolicyId")
    def backup_policy_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Backup Policy.
        """
        return pulumi.get(self, "backup_policy_id")

    @backup_policy_id.setter
    def backup_policy_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "backup_policy_id", value)

    @_builtins.property
    @pulumi.getter(name="serverId")
    def server_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the source server. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "server_id")

    @server_id.setter
    def server_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "server_id", value)

    @_builtins.property
    @pulumi.getter(name="vaultId")
    def vault_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Backup Vault within which the PostgreSQL Flexible Server Backup Instance should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "vault_id")

    @vault_id.setter
    def vault_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "vault_id", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The location of the source database. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the Backup Instance for the PostgreSQL Flexible Server. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _BackupInstancePostgresqlFlexibleServerState:
    def __init__(__self__, *,
                 backup_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 server_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vault_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering BackupInstancePostgresqlFlexibleServer resources.
        :param pulumi.Input[_builtins.str] backup_policy_id: The ID of the Backup Policy.
        :param pulumi.Input[_builtins.str] location: The location of the source database. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Backup Instance for the PostgreSQL Flexible Server. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] server_id: The ID of the source server. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] vault_id: The ID of the Backup Vault within which the PostgreSQL Flexible Server Backup Instance should exist. Changing this forces a new resource to be created.
        """
        if backup_policy_id is not None:
            pulumi.set(__self__, "backup_policy_id", backup_policy_id)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if server_id is not None:
            pulumi.set(__self__, "server_id", server_id)
        if vault_id is not None:
            pulumi.set(__self__, "vault_id", vault_id)

    @_builtins.property
    @pulumi.getter(name="backupPolicyId")
    def backup_policy_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Backup Policy.
        """
        return pulumi.get(self, "backup_policy_id")

    @backup_policy_id.setter
    def backup_policy_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backup_policy_id", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The location of the source database. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the Backup Instance for the PostgreSQL Flexible Server. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="serverId")
    def server_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the source server. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "server_id")

    @server_id.setter
    def server_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "server_id", value)

    @_builtins.property
    @pulumi.getter(name="vaultId")
    def vault_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Backup Vault within which the PostgreSQL Flexible Server Backup Instance should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "vault_id")

    @vault_id.setter
    def vault_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vault_id", value)


@pulumi.type_token("azure:dataprotection/backupInstancePostgresqlFlexibleServer:BackupInstancePostgresqlFlexibleServer")
class BackupInstancePostgresqlFlexibleServer(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backup_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 server_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vault_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a Backup Instance to back up PostgreSQL Flexible Server.

        > **Note:** Before using this resource, there are some prerequisite permissions for configure backup and restore. See more details from <https://learn.microsoft.com/azure/backup/backup-azure-database-postgresql-flex-overview>.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_flexible_server = azure.postgresql.FlexibleServer("example",
            name="example-postgresqlfs",
            resource_group_name=example.name,
            location=example.location,
            administrator_login="adminTerraform",
            administrator_password="QAZwsx123",
            storage_mb=32768,
            version="12",
            sku_name="GP_Standard_D4s_v3",
            zone="2")
        example_backup_vault = azure.dataprotection.BackupVault("example",
            name="example-backupvault",
            resource_group_name=example.name,
            location=example.location,
            datastore_type="VaultStore",
            redundancy="LocallyRedundant",
            soft_delete="Off",
            identity={
                "type": "SystemAssigned",
            })
        example_assignment = azure.authorization.Assignment("example",
            scope=example.id,
            role_definition_name="Reader",
            principal_id=example_backup_vault.identity.principal_id)
        example2 = azure.authorization.Assignment("example2",
            scope=example_flexible_server.id,
            role_definition_name="PostgreSQL Flexible Server Long Term Retention Backup Role",
            principal_id=example_backup_vault.identity.principal_id)
        example_backup_policy_postgresql_flexible_server = azure.dataprotection.BackupPolicyPostgresqlFlexibleServer("example",
            name="example-dp",
            vault_id=example_backup_vault.id,
            backup_repeating_time_intervals=["R/2021-05-23T02:30:00+00:00/P1W"],
            default_retention_rule={
                "life_cycles": [{
                    "duration": "P4M",
                    "data_store_type": "VaultStore",
                }],
            },
            opts = pulumi.ResourceOptions(depends_on=[
                    example_assignment,
                    example2,
                ]))
        example_backup_instance_postgresql_flexible_server = azure.dataprotection.BackupInstancePostgresqlFlexibleServer("example",
            name="example-dbi",
            location=example.location,
            vault_id=example_backup_vault.id,
            server_id=example_flexible_server.id,
            backup_policy_id=example_backup_policy_postgresql_flexible_server.id)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.DataProtection` - 2024-04-01

        ## Import

        Backup Instance PostgreSQL Flexible Servers can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:dataprotection/backupInstancePostgresqlFlexibleServer:BackupInstancePostgresqlFlexibleServer example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.DataProtection/backupVaults/vault1/backupInstances/backupInstance1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] backup_policy_id: The ID of the Backup Policy.
        :param pulumi.Input[_builtins.str] location: The location of the source database. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Backup Instance for the PostgreSQL Flexible Server. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] server_id: The ID of the source server. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] vault_id: The ID of the Backup Vault within which the PostgreSQL Flexible Server Backup Instance should exist. Changing this forces a new resource to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: BackupInstancePostgresqlFlexibleServerArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Backup Instance to back up PostgreSQL Flexible Server.

        > **Note:** Before using this resource, there are some prerequisite permissions for configure backup and restore. See more details from <https://learn.microsoft.com/azure/backup/backup-azure-database-postgresql-flex-overview>.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_flexible_server = azure.postgresql.FlexibleServer("example",
            name="example-postgresqlfs",
            resource_group_name=example.name,
            location=example.location,
            administrator_login="adminTerraform",
            administrator_password="QAZwsx123",
            storage_mb=32768,
            version="12",
            sku_name="GP_Standard_D4s_v3",
            zone="2")
        example_backup_vault = azure.dataprotection.BackupVault("example",
            name="example-backupvault",
            resource_group_name=example.name,
            location=example.location,
            datastore_type="VaultStore",
            redundancy="LocallyRedundant",
            soft_delete="Off",
            identity={
                "type": "SystemAssigned",
            })
        example_assignment = azure.authorization.Assignment("example",
            scope=example.id,
            role_definition_name="Reader",
            principal_id=example_backup_vault.identity.principal_id)
        example2 = azure.authorization.Assignment("example2",
            scope=example_flexible_server.id,
            role_definition_name="PostgreSQL Flexible Server Long Term Retention Backup Role",
            principal_id=example_backup_vault.identity.principal_id)
        example_backup_policy_postgresql_flexible_server = azure.dataprotection.BackupPolicyPostgresqlFlexibleServer("example",
            name="example-dp",
            vault_id=example_backup_vault.id,
            backup_repeating_time_intervals=["R/2021-05-23T02:30:00+00:00/P1W"],
            default_retention_rule={
                "life_cycles": [{
                    "duration": "P4M",
                    "data_store_type": "VaultStore",
                }],
            },
            opts = pulumi.ResourceOptions(depends_on=[
                    example_assignment,
                    example2,
                ]))
        example_backup_instance_postgresql_flexible_server = azure.dataprotection.BackupInstancePostgresqlFlexibleServer("example",
            name="example-dbi",
            location=example.location,
            vault_id=example_backup_vault.id,
            server_id=example_flexible_server.id,
            backup_policy_id=example_backup_policy_postgresql_flexible_server.id)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.DataProtection` - 2024-04-01

        ## Import

        Backup Instance PostgreSQL Flexible Servers can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:dataprotection/backupInstancePostgresqlFlexibleServer:BackupInstancePostgresqlFlexibleServer example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.DataProtection/backupVaults/vault1/backupInstances/backupInstance1
        ```

        :param str resource_name: The name of the resource.
        :param BackupInstancePostgresqlFlexibleServerArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BackupInstancePostgresqlFlexibleServerArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backup_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 server_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vault_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BackupInstancePostgresqlFlexibleServerArgs.__new__(BackupInstancePostgresqlFlexibleServerArgs)

            if backup_policy_id is None and not opts.urn:
                raise TypeError("Missing required property 'backup_policy_id'")
            __props__.__dict__["backup_policy_id"] = backup_policy_id
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            if server_id is None and not opts.urn:
                raise TypeError("Missing required property 'server_id'")
            __props__.__dict__["server_id"] = server_id
            if vault_id is None and not opts.urn:
                raise TypeError("Missing required property 'vault_id'")
            __props__.__dict__["vault_id"] = vault_id
        super(BackupInstancePostgresqlFlexibleServer, __self__).__init__(
            'azure:dataprotection/backupInstancePostgresqlFlexibleServer:BackupInstancePostgresqlFlexibleServer',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            backup_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            server_id: Optional[pulumi.Input[_builtins.str]] = None,
            vault_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'BackupInstancePostgresqlFlexibleServer':
        """
        Get an existing BackupInstancePostgresqlFlexibleServer resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] backup_policy_id: The ID of the Backup Policy.
        :param pulumi.Input[_builtins.str] location: The location of the source database. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Backup Instance for the PostgreSQL Flexible Server. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] server_id: The ID of the source server. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] vault_id: The ID of the Backup Vault within which the PostgreSQL Flexible Server Backup Instance should exist. Changing this forces a new resource to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _BackupInstancePostgresqlFlexibleServerState.__new__(_BackupInstancePostgresqlFlexibleServerState)

        __props__.__dict__["backup_policy_id"] = backup_policy_id
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["server_id"] = server_id
        __props__.__dict__["vault_id"] = vault_id
        return BackupInstancePostgresqlFlexibleServer(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="backupPolicyId")
    def backup_policy_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Backup Policy.
        """
        return pulumi.get(self, "backup_policy_id")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        The location of the source database. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of the Backup Instance for the PostgreSQL Flexible Server. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="serverId")
    def server_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the source server. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "server_id")

    @_builtins.property
    @pulumi.getter(name="vaultId")
    def vault_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Backup Vault within which the PostgreSQL Flexible Server Backup Instance should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "vault_id")

