# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['BackupVaultArgs', 'BackupVault']

@pulumi.input_type
class BackupVaultArgs:
    def __init__(__self__, *,
                 datastore_type: pulumi.Input[_builtins.str],
                 redundancy: pulumi.Input[_builtins.str],
                 resource_group_name: pulumi.Input[_builtins.str],
                 cross_region_restore_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 identity: Optional[pulumi.Input['BackupVaultIdentityArgs']] = None,
                 immutability: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 retention_duration_in_days: Optional[pulumi.Input[_builtins.float]] = None,
                 soft_delete: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a BackupVault resource.
        :param pulumi.Input[_builtins.str] datastore_type: Specifies the type of the data store. Possible values are `ArchiveStore`, `OperationalStore`, `SnapshotStore` and `VaultStore`. Changing this forces a new resource to be created.
               
               > **Note:** The `SnapshotStore` will be removed in version 4.0 as it has been replaced by `OperationalStore`.
        :param pulumi.Input[_builtins.str] redundancy: Specifies the backup storage redundancy. Possible values are `GeoRedundant`, `LocallyRedundant` and `ZoneRedundant`. Changing this forces a new Backup Vault to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the Backup Vault should exist. Changing this forces a new Backup Vault to be created.
        :param pulumi.Input[_builtins.bool] cross_region_restore_enabled: Whether to enable cross-region restore for the Backup Vault.
               
               > **Note:** The `cross_region_restore_enabled` can only be specified when `redundancy` is specified for `GeoRedundant`. Once `cross_region_restore_enabled` is enabled, it cannot be disabled.
        :param pulumi.Input['BackupVaultIdentityArgs'] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.str] immutability: The state of immutability for this Backup Vault. Possible values are `Disabled`, `Locked`, and `Unlocked`. Defaults to `Disabled`. Changing this from `Locked` to anything else forces a new Backup Vault to be created.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Backup Vault should exist. Changing this forces a new Backup Vault to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Backup Vault. Changing this forces a new Backup Vault to be created.
        :param pulumi.Input[_builtins.float] retention_duration_in_days: The soft delete retention duration for this Backup Vault. Possible values are between `14` and `180`. Defaults to `14`.
               
               > **Note:** The `retention_duration_in_days` is the number of days for which deleted data is retained before being permanently deleted. Retention period till 14 days are free of cost, however, retention beyond 14 days may incur additional charges. The `retention_duration_in_days` is required when the `soft_delete` is set to `On`.
        :param pulumi.Input[_builtins.str] soft_delete: The state of soft delete for this Backup Vault. Possible values are `AlwaysOn`, `Off`, and `On`. Defaults to `On`.
               
               > **Note:** Once the `soft_delete` is set to `AlwaysOn`, the setting cannot be changed.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Backup Vault.
        """
        pulumi.set(__self__, "datastore_type", datastore_type)
        pulumi.set(__self__, "redundancy", redundancy)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if cross_region_restore_enabled is not None:
            pulumi.set(__self__, "cross_region_restore_enabled", cross_region_restore_enabled)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if immutability is not None:
            pulumi.set(__self__, "immutability", immutability)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if retention_duration_in_days is not None:
            pulumi.set(__self__, "retention_duration_in_days", retention_duration_in_days)
        if soft_delete is not None:
            pulumi.set(__self__, "soft_delete", soft_delete)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="datastoreType")
    def datastore_type(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the type of the data store. Possible values are `ArchiveStore`, `OperationalStore`, `SnapshotStore` and `VaultStore`. Changing this forces a new resource to be created.

        > **Note:** The `SnapshotStore` will be removed in version 4.0 as it has been replaced by `OperationalStore`.
        """
        return pulumi.get(self, "datastore_type")

    @datastore_type.setter
    def datastore_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "datastore_type", value)

    @_builtins.property
    @pulumi.getter
    def redundancy(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the backup storage redundancy. Possible values are `GeoRedundant`, `LocallyRedundant` and `ZoneRedundant`. Changing this forces a new Backup Vault to be created.
        """
        return pulumi.get(self, "redundancy")

    @redundancy.setter
    def redundancy(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "redundancy", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the Resource Group where the Backup Vault should exist. Changing this forces a new Backup Vault to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="crossRegionRestoreEnabled")
    def cross_region_restore_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable cross-region restore for the Backup Vault.

        > **Note:** The `cross_region_restore_enabled` can only be specified when `redundancy` is specified for `GeoRedundant`. Once `cross_region_restore_enabled` is enabled, it cannot be disabled.
        """
        return pulumi.get(self, "cross_region_restore_enabled")

    @cross_region_restore_enabled.setter
    def cross_region_restore_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "cross_region_restore_enabled", value)

    @_builtins.property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['BackupVaultIdentityArgs']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['BackupVaultIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @_builtins.property
    @pulumi.getter
    def immutability(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The state of immutability for this Backup Vault. Possible values are `Disabled`, `Locked`, and `Unlocked`. Defaults to `Disabled`. Changing this from `Locked` to anything else forces a new Backup Vault to be created.
        """
        return pulumi.get(self, "immutability")

    @immutability.setter
    def immutability(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "immutability", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Azure Region where the Backup Vault should exist. Changing this forces a new Backup Vault to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the Backup Vault. Changing this forces a new Backup Vault to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="retentionDurationInDays")
    def retention_duration_in_days(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        The soft delete retention duration for this Backup Vault. Possible values are between `14` and `180`. Defaults to `14`.

        > **Note:** The `retention_duration_in_days` is the number of days for which deleted data is retained before being permanently deleted. Retention period till 14 days are free of cost, however, retention beyond 14 days may incur additional charges. The `retention_duration_in_days` is required when the `soft_delete` is set to `On`.
        """
        return pulumi.get(self, "retention_duration_in_days")

    @retention_duration_in_days.setter
    def retention_duration_in_days(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "retention_duration_in_days", value)

    @_builtins.property
    @pulumi.getter(name="softDelete")
    def soft_delete(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The state of soft delete for this Backup Vault. Possible values are `AlwaysOn`, `Off`, and `On`. Defaults to `On`.

        > **Note:** Once the `soft_delete` is set to `AlwaysOn`, the setting cannot be changed.
        """
        return pulumi.get(self, "soft_delete")

    @soft_delete.setter
    def soft_delete(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "soft_delete", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the Backup Vault.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _BackupVaultState:
    def __init__(__self__, *,
                 cross_region_restore_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 datastore_type: Optional[pulumi.Input[_builtins.str]] = None,
                 identity: Optional[pulumi.Input['BackupVaultIdentityArgs']] = None,
                 immutability: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 redundancy: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 retention_duration_in_days: Optional[pulumi.Input[_builtins.float]] = None,
                 soft_delete: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering BackupVault resources.
        :param pulumi.Input[_builtins.bool] cross_region_restore_enabled: Whether to enable cross-region restore for the Backup Vault.
               
               > **Note:** The `cross_region_restore_enabled` can only be specified when `redundancy` is specified for `GeoRedundant`. Once `cross_region_restore_enabled` is enabled, it cannot be disabled.
        :param pulumi.Input[_builtins.str] datastore_type: Specifies the type of the data store. Possible values are `ArchiveStore`, `OperationalStore`, `SnapshotStore` and `VaultStore`. Changing this forces a new resource to be created.
               
               > **Note:** The `SnapshotStore` will be removed in version 4.0 as it has been replaced by `OperationalStore`.
        :param pulumi.Input['BackupVaultIdentityArgs'] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.str] immutability: The state of immutability for this Backup Vault. Possible values are `Disabled`, `Locked`, and `Unlocked`. Defaults to `Disabled`. Changing this from `Locked` to anything else forces a new Backup Vault to be created.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Backup Vault should exist. Changing this forces a new Backup Vault to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Backup Vault. Changing this forces a new Backup Vault to be created.
        :param pulumi.Input[_builtins.str] redundancy: Specifies the backup storage redundancy. Possible values are `GeoRedundant`, `LocallyRedundant` and `ZoneRedundant`. Changing this forces a new Backup Vault to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the Backup Vault should exist. Changing this forces a new Backup Vault to be created.
        :param pulumi.Input[_builtins.float] retention_duration_in_days: The soft delete retention duration for this Backup Vault. Possible values are between `14` and `180`. Defaults to `14`.
               
               > **Note:** The `retention_duration_in_days` is the number of days for which deleted data is retained before being permanently deleted. Retention period till 14 days are free of cost, however, retention beyond 14 days may incur additional charges. The `retention_duration_in_days` is required when the `soft_delete` is set to `On`.
        :param pulumi.Input[_builtins.str] soft_delete: The state of soft delete for this Backup Vault. Possible values are `AlwaysOn`, `Off`, and `On`. Defaults to `On`.
               
               > **Note:** Once the `soft_delete` is set to `AlwaysOn`, the setting cannot be changed.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Backup Vault.
        """
        if cross_region_restore_enabled is not None:
            pulumi.set(__self__, "cross_region_restore_enabled", cross_region_restore_enabled)
        if datastore_type is not None:
            pulumi.set(__self__, "datastore_type", datastore_type)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if immutability is not None:
            pulumi.set(__self__, "immutability", immutability)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if redundancy is not None:
            pulumi.set(__self__, "redundancy", redundancy)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if retention_duration_in_days is not None:
            pulumi.set(__self__, "retention_duration_in_days", retention_duration_in_days)
        if soft_delete is not None:
            pulumi.set(__self__, "soft_delete", soft_delete)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="crossRegionRestoreEnabled")
    def cross_region_restore_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable cross-region restore for the Backup Vault.

        > **Note:** The `cross_region_restore_enabled` can only be specified when `redundancy` is specified for `GeoRedundant`. Once `cross_region_restore_enabled` is enabled, it cannot be disabled.
        """
        return pulumi.get(self, "cross_region_restore_enabled")

    @cross_region_restore_enabled.setter
    def cross_region_restore_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "cross_region_restore_enabled", value)

    @_builtins.property
    @pulumi.getter(name="datastoreType")
    def datastore_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the type of the data store. Possible values are `ArchiveStore`, `OperationalStore`, `SnapshotStore` and `VaultStore`. Changing this forces a new resource to be created.

        > **Note:** The `SnapshotStore` will be removed in version 4.0 as it has been replaced by `OperationalStore`.
        """
        return pulumi.get(self, "datastore_type")

    @datastore_type.setter
    def datastore_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "datastore_type", value)

    @_builtins.property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['BackupVaultIdentityArgs']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['BackupVaultIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @_builtins.property
    @pulumi.getter
    def immutability(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The state of immutability for this Backup Vault. Possible values are `Disabled`, `Locked`, and `Unlocked`. Defaults to `Disabled`. Changing this from `Locked` to anything else forces a new Backup Vault to be created.
        """
        return pulumi.get(self, "immutability")

    @immutability.setter
    def immutability(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "immutability", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Azure Region where the Backup Vault should exist. Changing this forces a new Backup Vault to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the Backup Vault. Changing this forces a new Backup Vault to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def redundancy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the backup storage redundancy. Possible values are `GeoRedundant`, `LocallyRedundant` and `ZoneRedundant`. Changing this forces a new Backup Vault to be created.
        """
        return pulumi.get(self, "redundancy")

    @redundancy.setter
    def redundancy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "redundancy", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Resource Group where the Backup Vault should exist. Changing this forces a new Backup Vault to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="retentionDurationInDays")
    def retention_duration_in_days(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        The soft delete retention duration for this Backup Vault. Possible values are between `14` and `180`. Defaults to `14`.

        > **Note:** The `retention_duration_in_days` is the number of days for which deleted data is retained before being permanently deleted. Retention period till 14 days are free of cost, however, retention beyond 14 days may incur additional charges. The `retention_duration_in_days` is required when the `soft_delete` is set to `On`.
        """
        return pulumi.get(self, "retention_duration_in_days")

    @retention_duration_in_days.setter
    def retention_duration_in_days(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "retention_duration_in_days", value)

    @_builtins.property
    @pulumi.getter(name="softDelete")
    def soft_delete(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The state of soft delete for this Backup Vault. Possible values are `AlwaysOn`, `Off`, and `On`. Defaults to `On`.

        > **Note:** Once the `soft_delete` is set to `AlwaysOn`, the setting cannot be changed.
        """
        return pulumi.get(self, "soft_delete")

    @soft_delete.setter
    def soft_delete(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "soft_delete", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the Backup Vault.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("azure:dataprotection/backupVault:BackupVault")
class BackupVault(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cross_region_restore_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 datastore_type: Optional[pulumi.Input[_builtins.str]] = None,
                 identity: Optional[pulumi.Input[Union['BackupVaultIdentityArgs', 'BackupVaultIdentityArgsDict']]] = None,
                 immutability: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 redundancy: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 retention_duration_in_days: Optional[pulumi.Input[_builtins.float]] = None,
                 soft_delete: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Manages a Backup Vault.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_backup_vault = azure.dataprotection.BackupVault("example",
            name="example-backup-vault",
            resource_group_name=example.name,
            location=example.location,
            datastore_type="VaultStore",
            redundancy="LocallyRedundant")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.DataProtection` - 2024-04-01

        ## Import

        Backup Vaults can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:dataprotection/backupVault:BackupVault example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.DataProtection/backupVaults/vault1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] cross_region_restore_enabled: Whether to enable cross-region restore for the Backup Vault.
               
               > **Note:** The `cross_region_restore_enabled` can only be specified when `redundancy` is specified for `GeoRedundant`. Once `cross_region_restore_enabled` is enabled, it cannot be disabled.
        :param pulumi.Input[_builtins.str] datastore_type: Specifies the type of the data store. Possible values are `ArchiveStore`, `OperationalStore`, `SnapshotStore` and `VaultStore`. Changing this forces a new resource to be created.
               
               > **Note:** The `SnapshotStore` will be removed in version 4.0 as it has been replaced by `OperationalStore`.
        :param pulumi.Input[Union['BackupVaultIdentityArgs', 'BackupVaultIdentityArgsDict']] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.str] immutability: The state of immutability for this Backup Vault. Possible values are `Disabled`, `Locked`, and `Unlocked`. Defaults to `Disabled`. Changing this from `Locked` to anything else forces a new Backup Vault to be created.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Backup Vault should exist. Changing this forces a new Backup Vault to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Backup Vault. Changing this forces a new Backup Vault to be created.
        :param pulumi.Input[_builtins.str] redundancy: Specifies the backup storage redundancy. Possible values are `GeoRedundant`, `LocallyRedundant` and `ZoneRedundant`. Changing this forces a new Backup Vault to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the Backup Vault should exist. Changing this forces a new Backup Vault to be created.
        :param pulumi.Input[_builtins.float] retention_duration_in_days: The soft delete retention duration for this Backup Vault. Possible values are between `14` and `180`. Defaults to `14`.
               
               > **Note:** The `retention_duration_in_days` is the number of days for which deleted data is retained before being permanently deleted. Retention period till 14 days are free of cost, however, retention beyond 14 days may incur additional charges. The `retention_duration_in_days` is required when the `soft_delete` is set to `On`.
        :param pulumi.Input[_builtins.str] soft_delete: The state of soft delete for this Backup Vault. Possible values are `AlwaysOn`, `Off`, and `On`. Defaults to `On`.
               
               > **Note:** Once the `soft_delete` is set to `AlwaysOn`, the setting cannot be changed.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Backup Vault.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: BackupVaultArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Backup Vault.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_backup_vault = azure.dataprotection.BackupVault("example",
            name="example-backup-vault",
            resource_group_name=example.name,
            location=example.location,
            datastore_type="VaultStore",
            redundancy="LocallyRedundant")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.DataProtection` - 2024-04-01

        ## Import

        Backup Vaults can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:dataprotection/backupVault:BackupVault example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.DataProtection/backupVaults/vault1
        ```

        :param str resource_name: The name of the resource.
        :param BackupVaultArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BackupVaultArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cross_region_restore_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 datastore_type: Optional[pulumi.Input[_builtins.str]] = None,
                 identity: Optional[pulumi.Input[Union['BackupVaultIdentityArgs', 'BackupVaultIdentityArgsDict']]] = None,
                 immutability: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 redundancy: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 retention_duration_in_days: Optional[pulumi.Input[_builtins.float]] = None,
                 soft_delete: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BackupVaultArgs.__new__(BackupVaultArgs)

            __props__.__dict__["cross_region_restore_enabled"] = cross_region_restore_enabled
            if datastore_type is None and not opts.urn:
                raise TypeError("Missing required property 'datastore_type'")
            __props__.__dict__["datastore_type"] = datastore_type
            __props__.__dict__["identity"] = identity
            __props__.__dict__["immutability"] = immutability
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            if redundancy is None and not opts.urn:
                raise TypeError("Missing required property 'redundancy'")
            __props__.__dict__["redundancy"] = redundancy
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["retention_duration_in_days"] = retention_duration_in_days
            __props__.__dict__["soft_delete"] = soft_delete
            __props__.__dict__["tags"] = tags
        super(BackupVault, __self__).__init__(
            'azure:dataprotection/backupVault:BackupVault',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cross_region_restore_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            datastore_type: Optional[pulumi.Input[_builtins.str]] = None,
            identity: Optional[pulumi.Input[Union['BackupVaultIdentityArgs', 'BackupVaultIdentityArgsDict']]] = None,
            immutability: Optional[pulumi.Input[_builtins.str]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            redundancy: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            retention_duration_in_days: Optional[pulumi.Input[_builtins.float]] = None,
            soft_delete: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None) -> 'BackupVault':
        """
        Get an existing BackupVault resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] cross_region_restore_enabled: Whether to enable cross-region restore for the Backup Vault.
               
               > **Note:** The `cross_region_restore_enabled` can only be specified when `redundancy` is specified for `GeoRedundant`. Once `cross_region_restore_enabled` is enabled, it cannot be disabled.
        :param pulumi.Input[_builtins.str] datastore_type: Specifies the type of the data store. Possible values are `ArchiveStore`, `OperationalStore`, `SnapshotStore` and `VaultStore`. Changing this forces a new resource to be created.
               
               > **Note:** The `SnapshotStore` will be removed in version 4.0 as it has been replaced by `OperationalStore`.
        :param pulumi.Input[Union['BackupVaultIdentityArgs', 'BackupVaultIdentityArgsDict']] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.str] immutability: The state of immutability for this Backup Vault. Possible values are `Disabled`, `Locked`, and `Unlocked`. Defaults to `Disabled`. Changing this from `Locked` to anything else forces a new Backup Vault to be created.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Backup Vault should exist. Changing this forces a new Backup Vault to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Backup Vault. Changing this forces a new Backup Vault to be created.
        :param pulumi.Input[_builtins.str] redundancy: Specifies the backup storage redundancy. Possible values are `GeoRedundant`, `LocallyRedundant` and `ZoneRedundant`. Changing this forces a new Backup Vault to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the Backup Vault should exist. Changing this forces a new Backup Vault to be created.
        :param pulumi.Input[_builtins.float] retention_duration_in_days: The soft delete retention duration for this Backup Vault. Possible values are between `14` and `180`. Defaults to `14`.
               
               > **Note:** The `retention_duration_in_days` is the number of days for which deleted data is retained before being permanently deleted. Retention period till 14 days are free of cost, however, retention beyond 14 days may incur additional charges. The `retention_duration_in_days` is required when the `soft_delete` is set to `On`.
        :param pulumi.Input[_builtins.str] soft_delete: The state of soft delete for this Backup Vault. Possible values are `AlwaysOn`, `Off`, and `On`. Defaults to `On`.
               
               > **Note:** Once the `soft_delete` is set to `AlwaysOn`, the setting cannot be changed.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Backup Vault.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _BackupVaultState.__new__(_BackupVaultState)

        __props__.__dict__["cross_region_restore_enabled"] = cross_region_restore_enabled
        __props__.__dict__["datastore_type"] = datastore_type
        __props__.__dict__["identity"] = identity
        __props__.__dict__["immutability"] = immutability
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["redundancy"] = redundancy
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["retention_duration_in_days"] = retention_duration_in_days
        __props__.__dict__["soft_delete"] = soft_delete
        __props__.__dict__["tags"] = tags
        return BackupVault(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="crossRegionRestoreEnabled")
    def cross_region_restore_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to enable cross-region restore for the Backup Vault.

        > **Note:** The `cross_region_restore_enabled` can only be specified when `redundancy` is specified for `GeoRedundant`. Once `cross_region_restore_enabled` is enabled, it cannot be disabled.
        """
        return pulumi.get(self, "cross_region_restore_enabled")

    @_builtins.property
    @pulumi.getter(name="datastoreType")
    def datastore_type(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the type of the data store. Possible values are `ArchiveStore`, `OperationalStore`, `SnapshotStore` and `VaultStore`. Changing this forces a new resource to be created.

        > **Note:** The `SnapshotStore` will be removed in version 4.0 as it has been replaced by `OperationalStore`.
        """
        return pulumi.get(self, "datastore_type")

    @_builtins.property
    @pulumi.getter
    def identity(self) -> pulumi.Output[Optional['outputs.BackupVaultIdentity']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @_builtins.property
    @pulumi.getter
    def immutability(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The state of immutability for this Backup Vault. Possible values are `Disabled`, `Locked`, and `Unlocked`. Defaults to `Disabled`. Changing this from `Locked` to anything else forces a new Backup Vault to be created.
        """
        return pulumi.get(self, "immutability")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        The Azure Region where the Backup Vault should exist. Changing this forces a new Backup Vault to be created.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of the Backup Vault. Changing this forces a new Backup Vault to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def redundancy(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the backup storage redundancy. Possible values are `GeoRedundant`, `LocallyRedundant` and `ZoneRedundant`. Changing this forces a new Backup Vault to be created.
        """
        return pulumi.get(self, "redundancy")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Resource Group where the Backup Vault should exist. Changing this forces a new Backup Vault to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter(name="retentionDurationInDays")
    def retention_duration_in_days(self) -> pulumi.Output[Optional[_builtins.float]]:
        """
        The soft delete retention duration for this Backup Vault. Possible values are between `14` and `180`. Defaults to `14`.

        > **Note:** The `retention_duration_in_days` is the number of days for which deleted data is retained before being permanently deleted. Retention period till 14 days are free of cost, however, retention beyond 14 days may incur additional charges. The `retention_duration_in_days` is required when the `soft_delete` is set to `On`.
        """
        return pulumi.get(self, "retention_duration_in_days")

    @_builtins.property
    @pulumi.getter(name="softDelete")
    def soft_delete(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The state of soft delete for this Backup Vault. Possible values are `AlwaysOn`, `Off`, and `On`. Defaults to `On`.

        > **Note:** Once the `soft_delete` is set to `AlwaysOn`, the setting cannot be changed.
        """
        return pulumi.get(self, "soft_delete")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags which should be assigned to the Backup Vault.
        """
        return pulumi.get(self, "tags")

