# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetHostPoolResult',
    'AwaitableGetHostPoolResult',
    'get_host_pool',
    'get_host_pool_output',
]

@pulumi.output_type
class GetHostPoolResult:
    """
    A collection of values returned by getHostPool.
    """
    def __init__(__self__, custom_rdp_properties=None, description=None, friendly_name=None, id=None, load_balancer_type=None, location=None, maximum_sessions_allowed=None, name=None, personal_desktop_assignment_type=None, preferred_app_group_type=None, resource_group_name=None, scheduled_agent_updates=None, start_vm_on_connect=None, tags=None, type=None, validate_environment=None):
        if custom_rdp_properties and not isinstance(custom_rdp_properties, str):
            raise TypeError("Expected argument 'custom_rdp_properties' to be a str")
        pulumi.set(__self__, "custom_rdp_properties", custom_rdp_properties)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if friendly_name and not isinstance(friendly_name, str):
            raise TypeError("Expected argument 'friendly_name' to be a str")
        pulumi.set(__self__, "friendly_name", friendly_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if load_balancer_type and not isinstance(load_balancer_type, str):
            raise TypeError("Expected argument 'load_balancer_type' to be a str")
        pulumi.set(__self__, "load_balancer_type", load_balancer_type)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if maximum_sessions_allowed and not isinstance(maximum_sessions_allowed, int):
            raise TypeError("Expected argument 'maximum_sessions_allowed' to be a int")
        pulumi.set(__self__, "maximum_sessions_allowed", maximum_sessions_allowed)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if personal_desktop_assignment_type and not isinstance(personal_desktop_assignment_type, str):
            raise TypeError("Expected argument 'personal_desktop_assignment_type' to be a str")
        pulumi.set(__self__, "personal_desktop_assignment_type", personal_desktop_assignment_type)
        if preferred_app_group_type and not isinstance(preferred_app_group_type, str):
            raise TypeError("Expected argument 'preferred_app_group_type' to be a str")
        pulumi.set(__self__, "preferred_app_group_type", preferred_app_group_type)
        if resource_group_name and not isinstance(resource_group_name, str):
            raise TypeError("Expected argument 'resource_group_name' to be a str")
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if scheduled_agent_updates and not isinstance(scheduled_agent_updates, list):
            raise TypeError("Expected argument 'scheduled_agent_updates' to be a list")
        pulumi.set(__self__, "scheduled_agent_updates", scheduled_agent_updates)
        if start_vm_on_connect and not isinstance(start_vm_on_connect, bool):
            raise TypeError("Expected argument 'start_vm_on_connect' to be a bool")
        pulumi.set(__self__, "start_vm_on_connect", start_vm_on_connect)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if validate_environment and not isinstance(validate_environment, bool):
            raise TypeError("Expected argument 'validate_environment' to be a bool")
        pulumi.set(__self__, "validate_environment", validate_environment)

    @_builtins.property
    @pulumi.getter(name="customRdpProperties")
    def custom_rdp_properties(self) -> _builtins.str:
        """
        The custom RDP properties string for the Virtual Desktop Host Pool.
        """
        return pulumi.get(self, "custom_rdp_properties")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description for the Virtual Desktop Host Pool.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> _builtins.str:
        """
        The friendly name for the Virtual Desktop Host Pool.
        """
        return pulumi.get(self, "friendly_name")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="loadBalancerType")
    def load_balancer_type(self) -> _builtins.str:
        """
        The type of load balancing performed by the Host Pool
        """
        return pulumi.get(self, "load_balancer_type")

    @_builtins.property
    @pulumi.getter
    def location(self) -> _builtins.str:
        """
        The location/region where the Virtual Desktop Host Pool is located.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter(name="maximumSessionsAllowed")
    def maximum_sessions_allowed(self) -> _builtins.int:
        """
        The maximum number of users that can have concurrent sessions on a session host.
        """
        return pulumi.get(self, "maximum_sessions_allowed")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="personalDesktopAssignmentType")
    def personal_desktop_assignment_type(self) -> _builtins.str:
        """
        The type of personal desktop assignment in use by the Host Pool
        """
        return pulumi.get(self, "personal_desktop_assignment_type")

    @_builtins.property
    @pulumi.getter(name="preferredAppGroupType")
    def preferred_app_group_type(self) -> _builtins.str:
        """
        The preferred Application Group type for the Virtual Desktop Host Pool.
        """
        return pulumi.get(self, "preferred_app_group_type")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> _builtins.str:
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter(name="scheduledAgentUpdates")
    def scheduled_agent_updates(self) -> Sequence['outputs.GetHostPoolScheduledAgentUpdateResult']:
        """
        A `scheduled_agent_updates` block as defined below.
        """
        return pulumi.get(self, "scheduled_agent_updates")

    @_builtins.property
    @pulumi.getter(name="startVmOnConnect")
    def start_vm_on_connect(self) -> _builtins.bool:
        """
        Returns `true` if the Start VM on Connection Feature is enabled.
        """
        return pulumi.get(self, "start_vm_on_connect")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of the Virtual Desktop Host Pool.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="validateEnvironment")
    def validate_environment(self) -> _builtins.bool:
        """
        Returns `true` if the Host Pool is in Validation mode.
        """
        return pulumi.get(self, "validate_environment")


class AwaitableGetHostPoolResult(GetHostPoolResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetHostPoolResult(
            custom_rdp_properties=self.custom_rdp_properties,
            description=self.description,
            friendly_name=self.friendly_name,
            id=self.id,
            load_balancer_type=self.load_balancer_type,
            location=self.location,
            maximum_sessions_allowed=self.maximum_sessions_allowed,
            name=self.name,
            personal_desktop_assignment_type=self.personal_desktop_assignment_type,
            preferred_app_group_type=self.preferred_app_group_type,
            resource_group_name=self.resource_group_name,
            scheduled_agent_updates=self.scheduled_agent_updates,
            start_vm_on_connect=self.start_vm_on_connect,
            tags=self.tags,
            type=self.type,
            validate_environment=self.validate_environment)


def get_host_pool(name: Optional[_builtins.str] = None,
                  resource_group_name: Optional[_builtins.str] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetHostPoolResult:
    """
    Use this data source to access information about an existing Virtual Desktop Host Pool.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.desktopvirtualization.get_host_pool(name="example-pool",
        resource_group_name="example-resources")
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.DesktopVirtualization` - 2024-04-03


    :param _builtins.str name: The name of the Virtual Desktop Host Pool to retrieve.
    :param _builtins.str resource_group_name: The name of the resource group where the Virtual Desktop Host Pool exists.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:desktopvirtualization/getHostPool:getHostPool', __args__, opts=opts, typ=GetHostPoolResult).value

    return AwaitableGetHostPoolResult(
        custom_rdp_properties=pulumi.get(__ret__, 'custom_rdp_properties'),
        description=pulumi.get(__ret__, 'description'),
        friendly_name=pulumi.get(__ret__, 'friendly_name'),
        id=pulumi.get(__ret__, 'id'),
        load_balancer_type=pulumi.get(__ret__, 'load_balancer_type'),
        location=pulumi.get(__ret__, 'location'),
        maximum_sessions_allowed=pulumi.get(__ret__, 'maximum_sessions_allowed'),
        name=pulumi.get(__ret__, 'name'),
        personal_desktop_assignment_type=pulumi.get(__ret__, 'personal_desktop_assignment_type'),
        preferred_app_group_type=pulumi.get(__ret__, 'preferred_app_group_type'),
        resource_group_name=pulumi.get(__ret__, 'resource_group_name'),
        scheduled_agent_updates=pulumi.get(__ret__, 'scheduled_agent_updates'),
        start_vm_on_connect=pulumi.get(__ret__, 'start_vm_on_connect'),
        tags=pulumi.get(__ret__, 'tags'),
        type=pulumi.get(__ret__, 'type'),
        validate_environment=pulumi.get(__ret__, 'validate_environment'))
def get_host_pool_output(name: Optional[pulumi.Input[_builtins.str]] = None,
                         resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetHostPoolResult]:
    """
    Use this data source to access information about an existing Virtual Desktop Host Pool.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.desktopvirtualization.get_host_pool(name="example-pool",
        resource_group_name="example-resources")
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.DesktopVirtualization` - 2024-04-03


    :param _builtins.str name: The name of the Virtual Desktop Host Pool to retrieve.
    :param _builtins.str resource_group_name: The name of the resource group where the Virtual Desktop Host Pool exists.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:desktopvirtualization/getHostPool:getHostPool', __args__, opts=opts, typ=GetHostPoolResult)
    return __ret__.apply(lambda __response__: GetHostPoolResult(
        custom_rdp_properties=pulumi.get(__response__, 'custom_rdp_properties'),
        description=pulumi.get(__response__, 'description'),
        friendly_name=pulumi.get(__response__, 'friendly_name'),
        id=pulumi.get(__response__, 'id'),
        load_balancer_type=pulumi.get(__response__, 'load_balancer_type'),
        location=pulumi.get(__response__, 'location'),
        maximum_sessions_allowed=pulumi.get(__response__, 'maximum_sessions_allowed'),
        name=pulumi.get(__response__, 'name'),
        personal_desktop_assignment_type=pulumi.get(__response__, 'personal_desktop_assignment_type'),
        preferred_app_group_type=pulumi.get(__response__, 'preferred_app_group_type'),
        resource_group_name=pulumi.get(__response__, 'resource_group_name'),
        scheduled_agent_updates=pulumi.get(__response__, 'scheduled_agent_updates'),
        start_vm_on_connect=pulumi.get(__response__, 'start_vm_on_connect'),
        tags=pulumi.get(__response__, 'tags'),
        type=pulumi.get(__response__, 'type'),
        validate_environment=pulumi.get(__response__, 'validate_environment')))
