# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ScheduleArgs', 'Schedule']

@pulumi.input_type
class ScheduleArgs:
    def __init__(__self__, *,
                 lab_name: pulumi.Input[_builtins.str],
                 notification_settings: pulumi.Input['ScheduleNotificationSettingsArgs'],
                 resource_group_name: pulumi.Input[_builtins.str],
                 task_type: pulumi.Input[_builtins.str],
                 time_zone_id: pulumi.Input[_builtins.str],
                 daily_recurrence: Optional[pulumi.Input['ScheduleDailyRecurrenceArgs']] = None,
                 hourly_recurrence: Optional[pulumi.Input['ScheduleHourlyRecurrenceArgs']] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 weekly_recurrence: Optional[pulumi.Input['ScheduleWeeklyRecurrenceArgs']] = None):
        """
        The set of arguments for constructing a Schedule resource.
        :param pulumi.Input[_builtins.str] lab_name: The name of the dev test lab. Changing this forces a new resource to be created.
        :param pulumi.Input['ScheduleNotificationSettingsArgs'] notification_settings: The notification setting of a schedule. A `notification_settings` block as defined below.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which to create the dev test lab schedule. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] task_type: The task type of the schedule. Possible values include `LabVmsShutdownTask` and `LabVmAutoStart`.
        :param pulumi.Input[_builtins.str] time_zone_id: The time zone ID (e.g. Pacific Standard time).
        :param pulumi.Input['ScheduleDailyRecurrenceArgs'] daily_recurrence: The properties of a daily schedule. If the schedule occurs once each day of the week, specify the daily recurrence. A `daily_recurrence` block as defined below.
        :param pulumi.Input['ScheduleHourlyRecurrenceArgs'] hourly_recurrence: The properties of an hourly schedule. If the schedule occurs multiple times a day, specify the hourly recurrence. A `hourly_recurrence` block as defined below.
        :param pulumi.Input[_builtins.str] location: The location where the schedule is created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name of the dev test lab schedule. Valid value for name depends on the `task_type`. For instance for task_type `LabVmsStartupTask` the name needs to be `LabVmAutoStart`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] status: The status of this schedule. Possible values are `Enabled` and `Disabled`. Defaults to `Disabled`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input['ScheduleWeeklyRecurrenceArgs'] weekly_recurrence: The properties of a weekly schedule. If the schedule occurs only some days of the week, specify the weekly recurrence. A `weekly_recurrence` block as defined below.
        """
        pulumi.set(__self__, "lab_name", lab_name)
        pulumi.set(__self__, "notification_settings", notification_settings)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "task_type", task_type)
        pulumi.set(__self__, "time_zone_id", time_zone_id)
        if daily_recurrence is not None:
            pulumi.set(__self__, "daily_recurrence", daily_recurrence)
        if hourly_recurrence is not None:
            pulumi.set(__self__, "hourly_recurrence", hourly_recurrence)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if weekly_recurrence is not None:
            pulumi.set(__self__, "weekly_recurrence", weekly_recurrence)

    @_builtins.property
    @pulumi.getter(name="labName")
    def lab_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the dev test lab. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "lab_name")

    @lab_name.setter
    def lab_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "lab_name", value)

    @_builtins.property
    @pulumi.getter(name="notificationSettings")
    def notification_settings(self) -> pulumi.Input['ScheduleNotificationSettingsArgs']:
        """
        The notification setting of a schedule. A `notification_settings` block as defined below.
        """
        return pulumi.get(self, "notification_settings")

    @notification_settings.setter
    def notification_settings(self, value: pulumi.Input['ScheduleNotificationSettingsArgs']):
        pulumi.set(self, "notification_settings", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the resource group in which to create the dev test lab schedule. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="taskType")
    def task_type(self) -> pulumi.Input[_builtins.str]:
        """
        The task type of the schedule. Possible values include `LabVmsShutdownTask` and `LabVmAutoStart`.
        """
        return pulumi.get(self, "task_type")

    @task_type.setter
    def task_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "task_type", value)

    @_builtins.property
    @pulumi.getter(name="timeZoneId")
    def time_zone_id(self) -> pulumi.Input[_builtins.str]:
        """
        The time zone ID (e.g. Pacific Standard time).
        """
        return pulumi.get(self, "time_zone_id")

    @time_zone_id.setter
    def time_zone_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "time_zone_id", value)

    @_builtins.property
    @pulumi.getter(name="dailyRecurrence")
    def daily_recurrence(self) -> Optional[pulumi.Input['ScheduleDailyRecurrenceArgs']]:
        """
        The properties of a daily schedule. If the schedule occurs once each day of the week, specify the daily recurrence. A `daily_recurrence` block as defined below.
        """
        return pulumi.get(self, "daily_recurrence")

    @daily_recurrence.setter
    def daily_recurrence(self, value: Optional[pulumi.Input['ScheduleDailyRecurrenceArgs']]):
        pulumi.set(self, "daily_recurrence", value)

    @_builtins.property
    @pulumi.getter(name="hourlyRecurrence")
    def hourly_recurrence(self) -> Optional[pulumi.Input['ScheduleHourlyRecurrenceArgs']]:
        """
        The properties of an hourly schedule. If the schedule occurs multiple times a day, specify the hourly recurrence. A `hourly_recurrence` block as defined below.
        """
        return pulumi.get(self, "hourly_recurrence")

    @hourly_recurrence.setter
    def hourly_recurrence(self, value: Optional[pulumi.Input['ScheduleHourlyRecurrenceArgs']]):
        pulumi.set(self, "hourly_recurrence", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The location where the schedule is created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the dev test lab schedule. Valid value for name depends on the `task_type`. For instance for task_type `LabVmsStartupTask` the name needs to be `LabVmAutoStart`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of this schedule. Possible values are `Enabled` and `Disabled`. Defaults to `Disabled`.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="weeklyRecurrence")
    def weekly_recurrence(self) -> Optional[pulumi.Input['ScheduleWeeklyRecurrenceArgs']]:
        """
        The properties of a weekly schedule. If the schedule occurs only some days of the week, specify the weekly recurrence. A `weekly_recurrence` block as defined below.
        """
        return pulumi.get(self, "weekly_recurrence")

    @weekly_recurrence.setter
    def weekly_recurrence(self, value: Optional[pulumi.Input['ScheduleWeeklyRecurrenceArgs']]):
        pulumi.set(self, "weekly_recurrence", value)


@pulumi.input_type
class _ScheduleState:
    def __init__(__self__, *,
                 daily_recurrence: Optional[pulumi.Input['ScheduleDailyRecurrenceArgs']] = None,
                 hourly_recurrence: Optional[pulumi.Input['ScheduleHourlyRecurrenceArgs']] = None,
                 lab_name: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 notification_settings: Optional[pulumi.Input['ScheduleNotificationSettingsArgs']] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 task_type: Optional[pulumi.Input[_builtins.str]] = None,
                 time_zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 weekly_recurrence: Optional[pulumi.Input['ScheduleWeeklyRecurrenceArgs']] = None):
        """
        Input properties used for looking up and filtering Schedule resources.
        :param pulumi.Input['ScheduleDailyRecurrenceArgs'] daily_recurrence: The properties of a daily schedule. If the schedule occurs once each day of the week, specify the daily recurrence. A `daily_recurrence` block as defined below.
        :param pulumi.Input['ScheduleHourlyRecurrenceArgs'] hourly_recurrence: The properties of an hourly schedule. If the schedule occurs multiple times a day, specify the hourly recurrence. A `hourly_recurrence` block as defined below.
        :param pulumi.Input[_builtins.str] lab_name: The name of the dev test lab. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] location: The location where the schedule is created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name of the dev test lab schedule. Valid value for name depends on the `task_type`. For instance for task_type `LabVmsStartupTask` the name needs to be `LabVmAutoStart`. Changing this forces a new resource to be created.
        :param pulumi.Input['ScheduleNotificationSettingsArgs'] notification_settings: The notification setting of a schedule. A `notification_settings` block as defined below.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which to create the dev test lab schedule. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] status: The status of this schedule. Possible values are `Enabled` and `Disabled`. Defaults to `Disabled`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.str] task_type: The task type of the schedule. Possible values include `LabVmsShutdownTask` and `LabVmAutoStart`.
        :param pulumi.Input[_builtins.str] time_zone_id: The time zone ID (e.g. Pacific Standard time).
        :param pulumi.Input['ScheduleWeeklyRecurrenceArgs'] weekly_recurrence: The properties of a weekly schedule. If the schedule occurs only some days of the week, specify the weekly recurrence. A `weekly_recurrence` block as defined below.
        """
        if daily_recurrence is not None:
            pulumi.set(__self__, "daily_recurrence", daily_recurrence)
        if hourly_recurrence is not None:
            pulumi.set(__self__, "hourly_recurrence", hourly_recurrence)
        if lab_name is not None:
            pulumi.set(__self__, "lab_name", lab_name)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if notification_settings is not None:
            pulumi.set(__self__, "notification_settings", notification_settings)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if task_type is not None:
            pulumi.set(__self__, "task_type", task_type)
        if time_zone_id is not None:
            pulumi.set(__self__, "time_zone_id", time_zone_id)
        if weekly_recurrence is not None:
            pulumi.set(__self__, "weekly_recurrence", weekly_recurrence)

    @_builtins.property
    @pulumi.getter(name="dailyRecurrence")
    def daily_recurrence(self) -> Optional[pulumi.Input['ScheduleDailyRecurrenceArgs']]:
        """
        The properties of a daily schedule. If the schedule occurs once each day of the week, specify the daily recurrence. A `daily_recurrence` block as defined below.
        """
        return pulumi.get(self, "daily_recurrence")

    @daily_recurrence.setter
    def daily_recurrence(self, value: Optional[pulumi.Input['ScheduleDailyRecurrenceArgs']]):
        pulumi.set(self, "daily_recurrence", value)

    @_builtins.property
    @pulumi.getter(name="hourlyRecurrence")
    def hourly_recurrence(self) -> Optional[pulumi.Input['ScheduleHourlyRecurrenceArgs']]:
        """
        The properties of an hourly schedule. If the schedule occurs multiple times a day, specify the hourly recurrence. A `hourly_recurrence` block as defined below.
        """
        return pulumi.get(self, "hourly_recurrence")

    @hourly_recurrence.setter
    def hourly_recurrence(self, value: Optional[pulumi.Input['ScheduleHourlyRecurrenceArgs']]):
        pulumi.set(self, "hourly_recurrence", value)

    @_builtins.property
    @pulumi.getter(name="labName")
    def lab_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the dev test lab. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "lab_name")

    @lab_name.setter
    def lab_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lab_name", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The location where the schedule is created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the dev test lab schedule. Valid value for name depends on the `task_type`. For instance for task_type `LabVmsStartupTask` the name needs to be `LabVmAutoStart`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="notificationSettings")
    def notification_settings(self) -> Optional[pulumi.Input['ScheduleNotificationSettingsArgs']]:
        """
        The notification setting of a schedule. A `notification_settings` block as defined below.
        """
        return pulumi.get(self, "notification_settings")

    @notification_settings.setter
    def notification_settings(self, value: Optional[pulumi.Input['ScheduleNotificationSettingsArgs']]):
        pulumi.set(self, "notification_settings", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the resource group in which to create the dev test lab schedule. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of this schedule. Possible values are `Enabled` and `Disabled`. Defaults to `Disabled`.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="taskType")
    def task_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The task type of the schedule. Possible values include `LabVmsShutdownTask` and `LabVmAutoStart`.
        """
        return pulumi.get(self, "task_type")

    @task_type.setter
    def task_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "task_type", value)

    @_builtins.property
    @pulumi.getter(name="timeZoneId")
    def time_zone_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time zone ID (e.g. Pacific Standard time).
        """
        return pulumi.get(self, "time_zone_id")

    @time_zone_id.setter
    def time_zone_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_zone_id", value)

    @_builtins.property
    @pulumi.getter(name="weeklyRecurrence")
    def weekly_recurrence(self) -> Optional[pulumi.Input['ScheduleWeeklyRecurrenceArgs']]:
        """
        The properties of a weekly schedule. If the schedule occurs only some days of the week, specify the weekly recurrence. A `weekly_recurrence` block as defined below.
        """
        return pulumi.get(self, "weekly_recurrence")

    @weekly_recurrence.setter
    def weekly_recurrence(self, value: Optional[pulumi.Input['ScheduleWeeklyRecurrenceArgs']]):
        pulumi.set(self, "weekly_recurrence", value)


@pulumi.type_token("azure:devtest/schedule:Schedule")
class Schedule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 daily_recurrence: Optional[pulumi.Input[Union['ScheduleDailyRecurrenceArgs', 'ScheduleDailyRecurrenceArgsDict']]] = None,
                 hourly_recurrence: Optional[pulumi.Input[Union['ScheduleHourlyRecurrenceArgs', 'ScheduleHourlyRecurrenceArgsDict']]] = None,
                 lab_name: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 notification_settings: Optional[pulumi.Input[Union['ScheduleNotificationSettingsArgs', 'ScheduleNotificationSettingsArgsDict']]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 task_type: Optional[pulumi.Input[_builtins.str]] = None,
                 time_zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 weekly_recurrence: Optional[pulumi.Input[Union['ScheduleWeeklyRecurrenceArgs', 'ScheduleWeeklyRecurrenceArgsDict']]] = None,
                 __props__=None):
        """
        Manages automated startup and shutdown schedules for Azure Dev Test Lab.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_lab = azure.devtest.Lab("example",
            name="YourDevTestLab",
            location=example.location,
            resource_group_name=example.name)
        example_schedule = azure.devtest.Schedule("example",
            name="LabVmAutoStart",
            location=example.location,
            resource_group_name=example.name,
            lab_name=example_lab.name,
            status="Enabled",
            weekly_recurrence={
                "time": "1100",
                "week_days": [
                    "Monday",
                    "Tuesday",
                ],
            },
            time_zone_id="Pacific Standard Time",
            task_type="LabVmsStartupTask",
            notification_settings={},
            tags={
                "environment": "Production",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.DevTestLab` - 2018-09-15

        ## Import

        DevTest Schedule's can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:devtest/schedule:Schedule example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.DevTestLab/labs/myDevTestLab/schedules/labvmautostart
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ScheduleDailyRecurrenceArgs', 'ScheduleDailyRecurrenceArgsDict']] daily_recurrence: The properties of a daily schedule. If the schedule occurs once each day of the week, specify the daily recurrence. A `daily_recurrence` block as defined below.
        :param pulumi.Input[Union['ScheduleHourlyRecurrenceArgs', 'ScheduleHourlyRecurrenceArgsDict']] hourly_recurrence: The properties of an hourly schedule. If the schedule occurs multiple times a day, specify the hourly recurrence. A `hourly_recurrence` block as defined below.
        :param pulumi.Input[_builtins.str] lab_name: The name of the dev test lab. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] location: The location where the schedule is created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name of the dev test lab schedule. Valid value for name depends on the `task_type`. For instance for task_type `LabVmsStartupTask` the name needs to be `LabVmAutoStart`. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['ScheduleNotificationSettingsArgs', 'ScheduleNotificationSettingsArgsDict']] notification_settings: The notification setting of a schedule. A `notification_settings` block as defined below.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which to create the dev test lab schedule. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] status: The status of this schedule. Possible values are `Enabled` and `Disabled`. Defaults to `Disabled`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.str] task_type: The task type of the schedule. Possible values include `LabVmsShutdownTask` and `LabVmAutoStart`.
        :param pulumi.Input[_builtins.str] time_zone_id: The time zone ID (e.g. Pacific Standard time).
        :param pulumi.Input[Union['ScheduleWeeklyRecurrenceArgs', 'ScheduleWeeklyRecurrenceArgsDict']] weekly_recurrence: The properties of a weekly schedule. If the schedule occurs only some days of the week, specify the weekly recurrence. A `weekly_recurrence` block as defined below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ScheduleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages automated startup and shutdown schedules for Azure Dev Test Lab.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_lab = azure.devtest.Lab("example",
            name="YourDevTestLab",
            location=example.location,
            resource_group_name=example.name)
        example_schedule = azure.devtest.Schedule("example",
            name="LabVmAutoStart",
            location=example.location,
            resource_group_name=example.name,
            lab_name=example_lab.name,
            status="Enabled",
            weekly_recurrence={
                "time": "1100",
                "week_days": [
                    "Monday",
                    "Tuesday",
                ],
            },
            time_zone_id="Pacific Standard Time",
            task_type="LabVmsStartupTask",
            notification_settings={},
            tags={
                "environment": "Production",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.DevTestLab` - 2018-09-15

        ## Import

        DevTest Schedule's can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:devtest/schedule:Schedule example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.DevTestLab/labs/myDevTestLab/schedules/labvmautostart
        ```

        :param str resource_name: The name of the resource.
        :param ScheduleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ScheduleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 daily_recurrence: Optional[pulumi.Input[Union['ScheduleDailyRecurrenceArgs', 'ScheduleDailyRecurrenceArgsDict']]] = None,
                 hourly_recurrence: Optional[pulumi.Input[Union['ScheduleHourlyRecurrenceArgs', 'ScheduleHourlyRecurrenceArgsDict']]] = None,
                 lab_name: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 notification_settings: Optional[pulumi.Input[Union['ScheduleNotificationSettingsArgs', 'ScheduleNotificationSettingsArgsDict']]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 task_type: Optional[pulumi.Input[_builtins.str]] = None,
                 time_zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 weekly_recurrence: Optional[pulumi.Input[Union['ScheduleWeeklyRecurrenceArgs', 'ScheduleWeeklyRecurrenceArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ScheduleArgs.__new__(ScheduleArgs)

            __props__.__dict__["daily_recurrence"] = daily_recurrence
            __props__.__dict__["hourly_recurrence"] = hourly_recurrence
            if lab_name is None and not opts.urn:
                raise TypeError("Missing required property 'lab_name'")
            __props__.__dict__["lab_name"] = lab_name
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            if notification_settings is None and not opts.urn:
                raise TypeError("Missing required property 'notification_settings'")
            __props__.__dict__["notification_settings"] = notification_settings
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["status"] = status
            __props__.__dict__["tags"] = tags
            if task_type is None and not opts.urn:
                raise TypeError("Missing required property 'task_type'")
            __props__.__dict__["task_type"] = task_type
            if time_zone_id is None and not opts.urn:
                raise TypeError("Missing required property 'time_zone_id'")
            __props__.__dict__["time_zone_id"] = time_zone_id
            __props__.__dict__["weekly_recurrence"] = weekly_recurrence
        super(Schedule, __self__).__init__(
            'azure:devtest/schedule:Schedule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            daily_recurrence: Optional[pulumi.Input[Union['ScheduleDailyRecurrenceArgs', 'ScheduleDailyRecurrenceArgsDict']]] = None,
            hourly_recurrence: Optional[pulumi.Input[Union['ScheduleHourlyRecurrenceArgs', 'ScheduleHourlyRecurrenceArgsDict']]] = None,
            lab_name: Optional[pulumi.Input[_builtins.str]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            notification_settings: Optional[pulumi.Input[Union['ScheduleNotificationSettingsArgs', 'ScheduleNotificationSettingsArgsDict']]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            task_type: Optional[pulumi.Input[_builtins.str]] = None,
            time_zone_id: Optional[pulumi.Input[_builtins.str]] = None,
            weekly_recurrence: Optional[pulumi.Input[Union['ScheduleWeeklyRecurrenceArgs', 'ScheduleWeeklyRecurrenceArgsDict']]] = None) -> 'Schedule':
        """
        Get an existing Schedule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ScheduleDailyRecurrenceArgs', 'ScheduleDailyRecurrenceArgsDict']] daily_recurrence: The properties of a daily schedule. If the schedule occurs once each day of the week, specify the daily recurrence. A `daily_recurrence` block as defined below.
        :param pulumi.Input[Union['ScheduleHourlyRecurrenceArgs', 'ScheduleHourlyRecurrenceArgsDict']] hourly_recurrence: The properties of an hourly schedule. If the schedule occurs multiple times a day, specify the hourly recurrence. A `hourly_recurrence` block as defined below.
        :param pulumi.Input[_builtins.str] lab_name: The name of the dev test lab. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] location: The location where the schedule is created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name of the dev test lab schedule. Valid value for name depends on the `task_type`. For instance for task_type `LabVmsStartupTask` the name needs to be `LabVmAutoStart`. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['ScheduleNotificationSettingsArgs', 'ScheduleNotificationSettingsArgsDict']] notification_settings: The notification setting of a schedule. A `notification_settings` block as defined below.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which to create the dev test lab schedule. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] status: The status of this schedule. Possible values are `Enabled` and `Disabled`. Defaults to `Disabled`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.str] task_type: The task type of the schedule. Possible values include `LabVmsShutdownTask` and `LabVmAutoStart`.
        :param pulumi.Input[_builtins.str] time_zone_id: The time zone ID (e.g. Pacific Standard time).
        :param pulumi.Input[Union['ScheduleWeeklyRecurrenceArgs', 'ScheduleWeeklyRecurrenceArgsDict']] weekly_recurrence: The properties of a weekly schedule. If the schedule occurs only some days of the week, specify the weekly recurrence. A `weekly_recurrence` block as defined below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ScheduleState.__new__(_ScheduleState)

        __props__.__dict__["daily_recurrence"] = daily_recurrence
        __props__.__dict__["hourly_recurrence"] = hourly_recurrence
        __props__.__dict__["lab_name"] = lab_name
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["notification_settings"] = notification_settings
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        __props__.__dict__["task_type"] = task_type
        __props__.__dict__["time_zone_id"] = time_zone_id
        __props__.__dict__["weekly_recurrence"] = weekly_recurrence
        return Schedule(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="dailyRecurrence")
    def daily_recurrence(self) -> pulumi.Output[Optional['outputs.ScheduleDailyRecurrence']]:
        """
        The properties of a daily schedule. If the schedule occurs once each day of the week, specify the daily recurrence. A `daily_recurrence` block as defined below.
        """
        return pulumi.get(self, "daily_recurrence")

    @_builtins.property
    @pulumi.getter(name="hourlyRecurrence")
    def hourly_recurrence(self) -> pulumi.Output[Optional['outputs.ScheduleHourlyRecurrence']]:
        """
        The properties of an hourly schedule. If the schedule occurs multiple times a day, specify the hourly recurrence. A `hourly_recurrence` block as defined below.
        """
        return pulumi.get(self, "hourly_recurrence")

    @_builtins.property
    @pulumi.getter(name="labName")
    def lab_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the dev test lab. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "lab_name")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        The location where the schedule is created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the dev test lab schedule. Valid value for name depends on the `task_type`. For instance for task_type `LabVmsStartupTask` the name needs to be `LabVmAutoStart`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="notificationSettings")
    def notification_settings(self) -> pulumi.Output['outputs.ScheduleNotificationSettings']:
        """
        The notification setting of a schedule. A `notification_settings` block as defined below.
        """
        return pulumi.get(self, "notification_settings")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the resource group in which to create the dev test lab schedule. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The status of this schedule. Possible values are `Enabled` and `Disabled`. Defaults to `Disabled`.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="taskType")
    def task_type(self) -> pulumi.Output[_builtins.str]:
        """
        The task type of the schedule. Possible values include `LabVmsShutdownTask` and `LabVmAutoStart`.
        """
        return pulumi.get(self, "task_type")

    @_builtins.property
    @pulumi.getter(name="timeZoneId")
    def time_zone_id(self) -> pulumi.Output[_builtins.str]:
        """
        The time zone ID (e.g. Pacific Standard time).
        """
        return pulumi.get(self, "time_zone_id")

    @_builtins.property
    @pulumi.getter(name="weeklyRecurrence")
    def weekly_recurrence(self) -> pulumi.Output[Optional['outputs.ScheduleWeeklyRecurrence']]:
        """
        The properties of a weekly schedule. If the schedule occurs only some days of the week, specify the weekly recurrence. A `weekly_recurrence` block as defined below.
        """
        return pulumi.get(self, "weekly_recurrence")

