# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ServiceTrustArgs', 'ServiceTrust']

@pulumi.input_type
class ServiceTrustArgs:
    def __init__(__self__, *,
                 domain_service_id: pulumi.Input[_builtins.str],
                 password: pulumi.Input[_builtins.str],
                 trusted_domain_dns_ips: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 trusted_domain_fqdn: pulumi.Input[_builtins.str],
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ServiceTrust resource.
        :param pulumi.Input[_builtins.str] domain_service_id: The ID of the Active Directory Domain Service. Changing this forces a new Active Directory Domain Service Trust to be created.
        :param pulumi.Input[_builtins.str] password: The password of the inbound trust set in the on-premise Active Directory Domain Service.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] trusted_domain_dns_ips: Specifies a list of DNS IPs that are used to resolve the on-premise Active Directory Domain Service.
        :param pulumi.Input[_builtins.str] trusted_domain_fqdn: The FQDN of the on-premise Active Directory Domain Service.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Active Directory Domain Service Trust. Changing this forces a new Active Directory Domain Service Trust to be created.
        """
        pulumi.set(__self__, "domain_service_id", domain_service_id)
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "trusted_domain_dns_ips", trusted_domain_dns_ips)
        pulumi.set(__self__, "trusted_domain_fqdn", trusted_domain_fqdn)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="domainServiceId")
    def domain_service_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Active Directory Domain Service. Changing this forces a new Active Directory Domain Service Trust to be created.
        """
        return pulumi.get(self, "domain_service_id")

    @domain_service_id.setter
    def domain_service_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "domain_service_id", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> pulumi.Input[_builtins.str]:
        """
        The password of the inbound trust set in the on-premise Active Directory Domain Service.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter(name="trustedDomainDnsIps")
    def trusted_domain_dns_ips(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        Specifies a list of DNS IPs that are used to resolve the on-premise Active Directory Domain Service.
        """
        return pulumi.get(self, "trusted_domain_dns_ips")

    @trusted_domain_dns_ips.setter
    def trusted_domain_dns_ips(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "trusted_domain_dns_ips", value)

    @_builtins.property
    @pulumi.getter(name="trustedDomainFqdn")
    def trusted_domain_fqdn(self) -> pulumi.Input[_builtins.str]:
        """
        The FQDN of the on-premise Active Directory Domain Service.
        """
        return pulumi.get(self, "trusted_domain_fqdn")

    @trusted_domain_fqdn.setter
    def trusted_domain_fqdn(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "trusted_domain_fqdn", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Active Directory Domain Service Trust. Changing this forces a new Active Directory Domain Service Trust to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _ServiceTrustState:
    def __init__(__self__, *,
                 domain_service_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 trusted_domain_dns_ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 trusted_domain_fqdn: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ServiceTrust resources.
        :param pulumi.Input[_builtins.str] domain_service_id: The ID of the Active Directory Domain Service. Changing this forces a new Active Directory Domain Service Trust to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Active Directory Domain Service Trust. Changing this forces a new Active Directory Domain Service Trust to be created.
        :param pulumi.Input[_builtins.str] password: The password of the inbound trust set in the on-premise Active Directory Domain Service.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] trusted_domain_dns_ips: Specifies a list of DNS IPs that are used to resolve the on-premise Active Directory Domain Service.
        :param pulumi.Input[_builtins.str] trusted_domain_fqdn: The FQDN of the on-premise Active Directory Domain Service.
        """
        if domain_service_id is not None:
            pulumi.set(__self__, "domain_service_id", domain_service_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if trusted_domain_dns_ips is not None:
            pulumi.set(__self__, "trusted_domain_dns_ips", trusted_domain_dns_ips)
        if trusted_domain_fqdn is not None:
            pulumi.set(__self__, "trusted_domain_fqdn", trusted_domain_fqdn)

    @_builtins.property
    @pulumi.getter(name="domainServiceId")
    def domain_service_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Active Directory Domain Service. Changing this forces a new Active Directory Domain Service Trust to be created.
        """
        return pulumi.get(self, "domain_service_id")

    @domain_service_id.setter
    def domain_service_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "domain_service_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Active Directory Domain Service Trust. Changing this forces a new Active Directory Domain Service Trust to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The password of the inbound trust set in the on-premise Active Directory Domain Service.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter(name="trustedDomainDnsIps")
    def trusted_domain_dns_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies a list of DNS IPs that are used to resolve the on-premise Active Directory Domain Service.
        """
        return pulumi.get(self, "trusted_domain_dns_ips")

    @trusted_domain_dns_ips.setter
    def trusted_domain_dns_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "trusted_domain_dns_ips", value)

    @_builtins.property
    @pulumi.getter(name="trustedDomainFqdn")
    def trusted_domain_fqdn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The FQDN of the on-premise Active Directory Domain Service.
        """
        return pulumi.get(self, "trusted_domain_fqdn")

    @trusted_domain_fqdn.setter
    def trusted_domain_fqdn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "trusted_domain_fqdn", value)


@pulumi.type_token("azure:domainservices/serviceTrust:ServiceTrust")
class ServiceTrust(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 domain_service_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 trusted_domain_dns_ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 trusted_domain_fqdn: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a Active Directory Domain Service Trust.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.domainservices.get_service(name="example-ds",
            resource_group_name="example-rg")
        example_service_trust = azure.domainservices.ServiceTrust("example",
            name="example-trust",
            domain_service_id=example.id,
            trusted_domain_fqdn="example.com",
            trusted_domain_dns_ips=[
                "10.1.0.3",
                "10.1.0.4",
            ],
            password="Password123")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.AAD` - 2021-05-01

        ## Import

        Active Directory Domain Service Trusts can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:domainservices/serviceTrust:ServiceTrust example /subscriptions/12345678-1234-9876-4563-123456789012/resourceGroups/resGroup1/providers/Microsoft.AAD/domainServices/DomainService1/trusts/trust1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] domain_service_id: The ID of the Active Directory Domain Service. Changing this forces a new Active Directory Domain Service Trust to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Active Directory Domain Service Trust. Changing this forces a new Active Directory Domain Service Trust to be created.
        :param pulumi.Input[_builtins.str] password: The password of the inbound trust set in the on-premise Active Directory Domain Service.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] trusted_domain_dns_ips: Specifies a list of DNS IPs that are used to resolve the on-premise Active Directory Domain Service.
        :param pulumi.Input[_builtins.str] trusted_domain_fqdn: The FQDN of the on-premise Active Directory Domain Service.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ServiceTrustArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Active Directory Domain Service Trust.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.domainservices.get_service(name="example-ds",
            resource_group_name="example-rg")
        example_service_trust = azure.domainservices.ServiceTrust("example",
            name="example-trust",
            domain_service_id=example.id,
            trusted_domain_fqdn="example.com",
            trusted_domain_dns_ips=[
                "10.1.0.3",
                "10.1.0.4",
            ],
            password="Password123")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.AAD` - 2021-05-01

        ## Import

        Active Directory Domain Service Trusts can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:domainservices/serviceTrust:ServiceTrust example /subscriptions/12345678-1234-9876-4563-123456789012/resourceGroups/resGroup1/providers/Microsoft.AAD/domainServices/DomainService1/trusts/trust1
        ```

        :param str resource_name: The name of the resource.
        :param ServiceTrustArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ServiceTrustArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 domain_service_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 trusted_domain_dns_ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 trusted_domain_fqdn: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ServiceTrustArgs.__new__(ServiceTrustArgs)

            if domain_service_id is None and not opts.urn:
                raise TypeError("Missing required property 'domain_service_id'")
            __props__.__dict__["domain_service_id"] = domain_service_id
            __props__.__dict__["name"] = name
            if password is None and not opts.urn:
                raise TypeError("Missing required property 'password'")
            __props__.__dict__["password"] = None if password is None else pulumi.Output.secret(password)
            if trusted_domain_dns_ips is None and not opts.urn:
                raise TypeError("Missing required property 'trusted_domain_dns_ips'")
            __props__.__dict__["trusted_domain_dns_ips"] = trusted_domain_dns_ips
            if trusted_domain_fqdn is None and not opts.urn:
                raise TypeError("Missing required property 'trusted_domain_fqdn'")
            __props__.__dict__["trusted_domain_fqdn"] = trusted_domain_fqdn
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["password"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(ServiceTrust, __self__).__init__(
            'azure:domainservices/serviceTrust:ServiceTrust',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            domain_service_id: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            password: Optional[pulumi.Input[_builtins.str]] = None,
            trusted_domain_dns_ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            trusted_domain_fqdn: Optional[pulumi.Input[_builtins.str]] = None) -> 'ServiceTrust':
        """
        Get an existing ServiceTrust resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] domain_service_id: The ID of the Active Directory Domain Service. Changing this forces a new Active Directory Domain Service Trust to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Active Directory Domain Service Trust. Changing this forces a new Active Directory Domain Service Trust to be created.
        :param pulumi.Input[_builtins.str] password: The password of the inbound trust set in the on-premise Active Directory Domain Service.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] trusted_domain_dns_ips: Specifies a list of DNS IPs that are used to resolve the on-premise Active Directory Domain Service.
        :param pulumi.Input[_builtins.str] trusted_domain_fqdn: The FQDN of the on-premise Active Directory Domain Service.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ServiceTrustState.__new__(_ServiceTrustState)

        __props__.__dict__["domain_service_id"] = domain_service_id
        __props__.__dict__["name"] = name
        __props__.__dict__["password"] = password
        __props__.__dict__["trusted_domain_dns_ips"] = trusted_domain_dns_ips
        __props__.__dict__["trusted_domain_fqdn"] = trusted_domain_fqdn
        return ServiceTrust(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="domainServiceId")
    def domain_service_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Active Directory Domain Service. Changing this forces a new Active Directory Domain Service Trust to be created.
        """
        return pulumi.get(self, "domain_service_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name which should be used for this Active Directory Domain Service Trust. Changing this forces a new Active Directory Domain Service Trust to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def password(self) -> pulumi.Output[_builtins.str]:
        """
        The password of the inbound trust set in the on-premise Active Directory Domain Service.
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter(name="trustedDomainDnsIps")
    def trusted_domain_dns_ips(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Specifies a list of DNS IPs that are used to resolve the on-premise Active Directory Domain Service.
        """
        return pulumi.get(self, "trusted_domain_dns_ips")

    @_builtins.property
    @pulumi.getter(name="trustedDomainFqdn")
    def trusted_domain_fqdn(self) -> pulumi.Output[_builtins.str]:
        """
        The FQDN of the on-premise Active Directory Domain Service.
        """
        return pulumi.get(self, "trusted_domain_fqdn")

