# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetPartnerNamespaceResult',
    'AwaitableGetPartnerNamespaceResult',
    'get_partner_namespace',
    'get_partner_namespace_output',
]

@pulumi.output_type
class GetPartnerNamespaceResult:
    """
    A collection of values returned by getPartnerNamespace.
    """
    def __init__(__self__, endpoint=None, id=None, inbound_ip_rules=None, local_authentication_enabled=None, location=None, name=None, partner_registration_id=None, partner_topic_routing_mode=None, public_network_access=None, resource_group_name=None, tags=None):
        if endpoint and not isinstance(endpoint, str):
            raise TypeError("Expected argument 'endpoint' to be a str")
        pulumi.set(__self__, "endpoint", endpoint)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if inbound_ip_rules and not isinstance(inbound_ip_rules, list):
            raise TypeError("Expected argument 'inbound_ip_rules' to be a list")
        pulumi.set(__self__, "inbound_ip_rules", inbound_ip_rules)
        if local_authentication_enabled and not isinstance(local_authentication_enabled, bool):
            raise TypeError("Expected argument 'local_authentication_enabled' to be a bool")
        pulumi.set(__self__, "local_authentication_enabled", local_authentication_enabled)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if partner_registration_id and not isinstance(partner_registration_id, str):
            raise TypeError("Expected argument 'partner_registration_id' to be a str")
        pulumi.set(__self__, "partner_registration_id", partner_registration_id)
        if partner_topic_routing_mode and not isinstance(partner_topic_routing_mode, str):
            raise TypeError("Expected argument 'partner_topic_routing_mode' to be a str")
        pulumi.set(__self__, "partner_topic_routing_mode", partner_topic_routing_mode)
        if public_network_access and not isinstance(public_network_access, str):
            raise TypeError("Expected argument 'public_network_access' to be a str")
        pulumi.set(__self__, "public_network_access", public_network_access)
        if resource_group_name and not isinstance(resource_group_name, str):
            raise TypeError("Expected argument 'resource_group_name' to be a str")
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def endpoint(self) -> _builtins.str:
        """
        The endpoint for the Event Grid Partner Namespace.
        """
        return pulumi.get(self, "endpoint")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="inboundIpRules")
    def inbound_ip_rules(self) -> Sequence['outputs.GetPartnerNamespaceInboundIpRuleResult']:
        """
        One or more `inbound_ip_rule` blocks as defined below.
        """
        return pulumi.get(self, "inbound_ip_rules")

    @_builtins.property
    @pulumi.getter(name="localAuthenticationEnabled")
    def local_authentication_enabled(self) -> _builtins.bool:
        """
        Whether local authentication methods are enabled for the Event Grid Partner Namespace.
        """
        return pulumi.get(self, "local_authentication_enabled")

    @_builtins.property
    @pulumi.getter
    def location(self) -> _builtins.str:
        """
        The Azure Region where the Event Grid Partner Namespace exists.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="partnerRegistrationId")
    def partner_registration_id(self) -> _builtins.str:
        """
        The resource Id of the partner registration associated with this Event Grid Partner Namespace.
        """
        return pulumi.get(self, "partner_registration_id")

    @_builtins.property
    @pulumi.getter(name="partnerTopicRoutingMode")
    def partner_topic_routing_mode(self) -> _builtins.str:
        """
        The partner topic routing mode.
        """
        return pulumi.get(self, "partner_topic_routing_mode")

    @_builtins.property
    @pulumi.getter(name="publicNetworkAccess")
    def public_network_access(self) -> _builtins.str:
        """
        Whether or not public network access is allowed for this server.
        """
        return pulumi.get(self, "public_network_access")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> _builtins.str:
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        A mapping of tags which are assigned to the Event Grid Partner Namespace.
        """
        return pulumi.get(self, "tags")


class AwaitableGetPartnerNamespaceResult(GetPartnerNamespaceResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPartnerNamespaceResult(
            endpoint=self.endpoint,
            id=self.id,
            inbound_ip_rules=self.inbound_ip_rules,
            local_authentication_enabled=self.local_authentication_enabled,
            location=self.location,
            name=self.name,
            partner_registration_id=self.partner_registration_id,
            partner_topic_routing_mode=self.partner_topic_routing_mode,
            public_network_access=self.public_network_access,
            resource_group_name=self.resource_group_name,
            tags=self.tags)


def get_partner_namespace(name: Optional[_builtins.str] = None,
                          resource_group_name: Optional[_builtins.str] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPartnerNamespaceResult:
    """
    Use this data source to access information about an existing Event Grid Partner Namespace

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.eventgrid.get_partner_namespace(name="my-eventgrid-partner-namespace",
        resource_group_name="example-resources")
    pulumi.export("eventgridPartnerNamespaceEndpoint", example.endpoint)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.EventGrid` - 2025-02-15


    :param _builtins.str name: The name of the Event Grid Partner Namespace resource.
    :param _builtins.str resource_group_name: The name of the resource group in which the Event Grid Partner Namespace exists.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:eventgrid/getPartnerNamespace:getPartnerNamespace', __args__, opts=opts, typ=GetPartnerNamespaceResult).value

    return AwaitableGetPartnerNamespaceResult(
        endpoint=pulumi.get(__ret__, 'endpoint'),
        id=pulumi.get(__ret__, 'id'),
        inbound_ip_rules=pulumi.get(__ret__, 'inbound_ip_rules'),
        local_authentication_enabled=pulumi.get(__ret__, 'local_authentication_enabled'),
        location=pulumi.get(__ret__, 'location'),
        name=pulumi.get(__ret__, 'name'),
        partner_registration_id=pulumi.get(__ret__, 'partner_registration_id'),
        partner_topic_routing_mode=pulumi.get(__ret__, 'partner_topic_routing_mode'),
        public_network_access=pulumi.get(__ret__, 'public_network_access'),
        resource_group_name=pulumi.get(__ret__, 'resource_group_name'),
        tags=pulumi.get(__ret__, 'tags'))
def get_partner_namespace_output(name: Optional[pulumi.Input[_builtins.str]] = None,
                                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                                 opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetPartnerNamespaceResult]:
    """
    Use this data source to access information about an existing Event Grid Partner Namespace

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.eventgrid.get_partner_namespace(name="my-eventgrid-partner-namespace",
        resource_group_name="example-resources")
    pulumi.export("eventgridPartnerNamespaceEndpoint", example.endpoint)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.EventGrid` - 2025-02-15


    :param _builtins.str name: The name of the Event Grid Partner Namespace resource.
    :param _builtins.str resource_group_name: The name of the resource group in which the Event Grid Partner Namespace exists.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:eventgrid/getPartnerNamespace:getPartnerNamespace', __args__, opts=opts, typ=GetPartnerNamespaceResult)
    return __ret__.apply(lambda __response__: GetPartnerNamespaceResult(
        endpoint=pulumi.get(__response__, 'endpoint'),
        id=pulumi.get(__response__, 'id'),
        inbound_ip_rules=pulumi.get(__response__, 'inbound_ip_rules'),
        local_authentication_enabled=pulumi.get(__response__, 'local_authentication_enabled'),
        location=pulumi.get(__response__, 'location'),
        name=pulumi.get(__response__, 'name'),
        partner_registration_id=pulumi.get(__response__, 'partner_registration_id'),
        partner_topic_routing_mode=pulumi.get(__response__, 'partner_topic_routing_mode'),
        public_network_access=pulumi.get(__response__, 'public_network_access'),
        resource_group_name=pulumi.get(__response__, 'resource_group_name'),
        tags=pulumi.get(__response__, 'tags')))
