# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetPartnerRegistrationResult',
    'AwaitableGetPartnerRegistrationResult',
    'get_partner_registration',
    'get_partner_registration_output',
]

@pulumi.output_type
class GetPartnerRegistrationResult:
    """
    A collection of values returned by getPartnerRegistration.
    """
    def __init__(__self__, id=None, name=None, partner_registration_id=None, resource_group_name=None, tags=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if partner_registration_id and not isinstance(partner_registration_id, str):
            raise TypeError("Expected argument 'partner_registration_id' to be a str")
        pulumi.set(__self__, "partner_registration_id", partner_registration_id)
        if resource_group_name and not isinstance(resource_group_name, str):
            raise TypeError("Expected argument 'resource_group_name' to be a str")
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="partnerRegistrationId")
    def partner_registration_id(self) -> _builtins.str:
        """
        The immutable id of the corresponding partner registration.
        """
        return pulumi.get(self, "partner_registration_id")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> _builtins.str:
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        A mapping of tags which are assigned to the EventGrid Partner Registration.
        """
        return pulumi.get(self, "tags")


class AwaitableGetPartnerRegistrationResult(GetPartnerRegistrationResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPartnerRegistrationResult(
            id=self.id,
            name=self.name,
            partner_registration_id=self.partner_registration_id,
            resource_group_name=self.resource_group_name,
            tags=self.tags)


def get_partner_registration(name: Optional[_builtins.str] = None,
                             resource_group_name: Optional[_builtins.str] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPartnerRegistrationResult:
    """
    Use this data source to access information about an existing EventGrid Partner Registration

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.eventgrid.get_partner_registration(name="my-eventgrid-partner-registration",
        resource_group_name="example-resources")
    pulumi.export("eventgridPartnerRegistrationId", example.partner_registration_id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.EventGrid` - 2025-02-15


    :param _builtins.str name: The name of the EventGrid Partner Registration resource.
    :param _builtins.str resource_group_name: The name of the resource group in which the EventGrid Partner Registration exists.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:eventgrid/getPartnerRegistration:getPartnerRegistration', __args__, opts=opts, typ=GetPartnerRegistrationResult).value

    return AwaitableGetPartnerRegistrationResult(
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        partner_registration_id=pulumi.get(__ret__, 'partner_registration_id'),
        resource_group_name=pulumi.get(__ret__, 'resource_group_name'),
        tags=pulumi.get(__ret__, 'tags'))
def get_partner_registration_output(name: Optional[pulumi.Input[_builtins.str]] = None,
                                    resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetPartnerRegistrationResult]:
    """
    Use this data source to access information about an existing EventGrid Partner Registration

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.eventgrid.get_partner_registration(name="my-eventgrid-partner-registration",
        resource_group_name="example-resources")
    pulumi.export("eventgridPartnerRegistrationId", example.partner_registration_id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.EventGrid` - 2025-02-15


    :param _builtins.str name: The name of the EventGrid Partner Registration resource.
    :param _builtins.str resource_group_name: The name of the resource group in which the EventGrid Partner Registration exists.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:eventgrid/getPartnerRegistration:getPartnerRegistration', __args__, opts=opts, typ=GetPartnerRegistrationResult)
    return __ret__.apply(lambda __response__: GetPartnerRegistrationResult(
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        partner_registration_id=pulumi.get(__response__, 'partner_registration_id'),
        resource_group_name=pulumi.get(__response__, 'resource_group_name'),
        tags=pulumi.get(__response__, 'tags')))
