# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SystemTopicEventSubscriptionArgs', 'SystemTopicEventSubscription']

@pulumi.input_type
class SystemTopicEventSubscriptionArgs:
    def __init__(__self__, *,
                 resource_group_name: pulumi.Input[_builtins.str],
                 system_topic: pulumi.Input[_builtins.str],
                 advanced_filter: Optional[pulumi.Input['SystemTopicEventSubscriptionAdvancedFilterArgs']] = None,
                 advanced_filtering_on_arrays_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 azure_function_endpoint: Optional[pulumi.Input['SystemTopicEventSubscriptionAzureFunctionEndpointArgs']] = None,
                 dead_letter_identity: Optional[pulumi.Input['SystemTopicEventSubscriptionDeadLetterIdentityArgs']] = None,
                 delivery_identity: Optional[pulumi.Input['SystemTopicEventSubscriptionDeliveryIdentityArgs']] = None,
                 delivery_properties: Optional[pulumi.Input[Sequence[pulumi.Input['SystemTopicEventSubscriptionDeliveryPropertyArgs']]]] = None,
                 event_delivery_schema: Optional[pulumi.Input[_builtins.str]] = None,
                 eventhub_endpoint_id: Optional[pulumi.Input[_builtins.str]] = None,
                 expiration_time_utc: Optional[pulumi.Input[_builtins.str]] = None,
                 hybrid_connection_endpoint_id: Optional[pulumi.Input[_builtins.str]] = None,
                 included_event_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 labels: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 retry_policy: Optional[pulumi.Input['SystemTopicEventSubscriptionRetryPolicyArgs']] = None,
                 service_bus_queue_endpoint_id: Optional[pulumi.Input[_builtins.str]] = None,
                 service_bus_topic_endpoint_id: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_blob_dead_letter_destination: Optional[pulumi.Input['SystemTopicEventSubscriptionStorageBlobDeadLetterDestinationArgs']] = None,
                 storage_queue_endpoint: Optional[pulumi.Input['SystemTopicEventSubscriptionStorageQueueEndpointArgs']] = None,
                 subject_filter: Optional[pulumi.Input['SystemTopicEventSubscriptionSubjectFilterArgs']] = None,
                 webhook_endpoint: Optional[pulumi.Input['SystemTopicEventSubscriptionWebhookEndpointArgs']] = None):
        """
        The set of arguments for constructing a SystemTopicEventSubscription resource.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the System Topic exists. Changing this forces a new Event Subscription to be created.
        :param pulumi.Input[_builtins.str] system_topic: The System Topic where the Event Subscription should be created in. Changing this forces a new Event Subscription to be created.
        :param pulumi.Input['SystemTopicEventSubscriptionAdvancedFilterArgs'] advanced_filter: A `advanced_filter` block as defined below.
        :param pulumi.Input[_builtins.bool] advanced_filtering_on_arrays_enabled: Specifies whether advanced filters should be evaluated against an array of values instead of expecting a singular value. Defaults to `false`.
        :param pulumi.Input['SystemTopicEventSubscriptionAzureFunctionEndpointArgs'] azure_function_endpoint: An `azure_function_endpoint` block as defined below.
        :param pulumi.Input['SystemTopicEventSubscriptionDeadLetterIdentityArgs'] dead_letter_identity: A `dead_letter_identity` block as defined below.
               
               > **Note:** `storage_blob_dead_letter_destination` must be specified when a `dead_letter_identity` is specified
        :param pulumi.Input['SystemTopicEventSubscriptionDeliveryIdentityArgs'] delivery_identity: A `delivery_identity` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input['SystemTopicEventSubscriptionDeliveryPropertyArgs']]] delivery_properties: One or more `delivery_property` blocks as defined below.
        :param pulumi.Input[_builtins.str] event_delivery_schema: Specifies the event delivery schema for the event subscription. Possible values include: `EventGridSchema`, `CloudEventSchemaV1_0`, `CustomInputSchema`. Defaults to `EventGridSchema`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] eventhub_endpoint_id: Specifies the id where the Event Hub is located.
        :param pulumi.Input[_builtins.str] expiration_time_utc: Specifies the expiration time of the event subscription (Datetime Format `RFC 3339`).
        :param pulumi.Input[_builtins.str] hybrid_connection_endpoint_id: Specifies the id where the Hybrid Connection is located.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] included_event_types: A list of applicable event types that need to be part of the event subscription.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] labels: A list of labels to assign to the event subscription.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Event Subscription. Changing this forces a new Event Subscription to be created.
        :param pulumi.Input['SystemTopicEventSubscriptionRetryPolicyArgs'] retry_policy: A `retry_policy` block as defined below.
        :param pulumi.Input[_builtins.str] service_bus_queue_endpoint_id: Specifies the id where the Service Bus Queue is located.
        :param pulumi.Input[_builtins.str] service_bus_topic_endpoint_id: Specifies the id where the Service Bus Topic is located.
        :param pulumi.Input['SystemTopicEventSubscriptionStorageBlobDeadLetterDestinationArgs'] storage_blob_dead_letter_destination: A `storage_blob_dead_letter_destination` block as defined below.
        :param pulumi.Input['SystemTopicEventSubscriptionStorageQueueEndpointArgs'] storage_queue_endpoint: A `storage_queue_endpoint` block as defined below.
        :param pulumi.Input['SystemTopicEventSubscriptionSubjectFilterArgs'] subject_filter: A `subject_filter` block as defined below.
        :param pulumi.Input['SystemTopicEventSubscriptionWebhookEndpointArgs'] webhook_endpoint: A `webhook_endpoint` block as defined below.
               
               > **Note:** One of `azure_function_endpoint`, `eventhub_endpoint_id`, `hybrid_connection_endpoint`, `hybrid_connection_endpoint_id`, `service_bus_queue_endpoint_id`, `service_bus_topic_endpoint_id`, `storage_queue_endpoint` or `webhook_endpoint` must be specified.
        """
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "system_topic", system_topic)
        if advanced_filter is not None:
            pulumi.set(__self__, "advanced_filter", advanced_filter)
        if advanced_filtering_on_arrays_enabled is not None:
            pulumi.set(__self__, "advanced_filtering_on_arrays_enabled", advanced_filtering_on_arrays_enabled)
        if azure_function_endpoint is not None:
            pulumi.set(__self__, "azure_function_endpoint", azure_function_endpoint)
        if dead_letter_identity is not None:
            pulumi.set(__self__, "dead_letter_identity", dead_letter_identity)
        if delivery_identity is not None:
            pulumi.set(__self__, "delivery_identity", delivery_identity)
        if delivery_properties is not None:
            pulumi.set(__self__, "delivery_properties", delivery_properties)
        if event_delivery_schema is not None:
            pulumi.set(__self__, "event_delivery_schema", event_delivery_schema)
        if eventhub_endpoint_id is not None:
            pulumi.set(__self__, "eventhub_endpoint_id", eventhub_endpoint_id)
        if expiration_time_utc is not None:
            pulumi.set(__self__, "expiration_time_utc", expiration_time_utc)
        if hybrid_connection_endpoint_id is not None:
            pulumi.set(__self__, "hybrid_connection_endpoint_id", hybrid_connection_endpoint_id)
        if included_event_types is not None:
            pulumi.set(__self__, "included_event_types", included_event_types)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if retry_policy is not None:
            pulumi.set(__self__, "retry_policy", retry_policy)
        if service_bus_queue_endpoint_id is not None:
            pulumi.set(__self__, "service_bus_queue_endpoint_id", service_bus_queue_endpoint_id)
        if service_bus_topic_endpoint_id is not None:
            pulumi.set(__self__, "service_bus_topic_endpoint_id", service_bus_topic_endpoint_id)
        if storage_blob_dead_letter_destination is not None:
            pulumi.set(__self__, "storage_blob_dead_letter_destination", storage_blob_dead_letter_destination)
        if storage_queue_endpoint is not None:
            pulumi.set(__self__, "storage_queue_endpoint", storage_queue_endpoint)
        if subject_filter is not None:
            pulumi.set(__self__, "subject_filter", subject_filter)
        if webhook_endpoint is not None:
            pulumi.set(__self__, "webhook_endpoint", webhook_endpoint)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the Resource Group where the System Topic exists. Changing this forces a new Event Subscription to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="systemTopic")
    def system_topic(self) -> pulumi.Input[_builtins.str]:
        """
        The System Topic where the Event Subscription should be created in. Changing this forces a new Event Subscription to be created.
        """
        return pulumi.get(self, "system_topic")

    @system_topic.setter
    def system_topic(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "system_topic", value)

    @_builtins.property
    @pulumi.getter(name="advancedFilter")
    def advanced_filter(self) -> Optional[pulumi.Input['SystemTopicEventSubscriptionAdvancedFilterArgs']]:
        """
        A `advanced_filter` block as defined below.
        """
        return pulumi.get(self, "advanced_filter")

    @advanced_filter.setter
    def advanced_filter(self, value: Optional[pulumi.Input['SystemTopicEventSubscriptionAdvancedFilterArgs']]):
        pulumi.set(self, "advanced_filter", value)

    @_builtins.property
    @pulumi.getter(name="advancedFilteringOnArraysEnabled")
    def advanced_filtering_on_arrays_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether advanced filters should be evaluated against an array of values instead of expecting a singular value. Defaults to `false`.
        """
        return pulumi.get(self, "advanced_filtering_on_arrays_enabled")

    @advanced_filtering_on_arrays_enabled.setter
    def advanced_filtering_on_arrays_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "advanced_filtering_on_arrays_enabled", value)

    @_builtins.property
    @pulumi.getter(name="azureFunctionEndpoint")
    def azure_function_endpoint(self) -> Optional[pulumi.Input['SystemTopicEventSubscriptionAzureFunctionEndpointArgs']]:
        """
        An `azure_function_endpoint` block as defined below.
        """
        return pulumi.get(self, "azure_function_endpoint")

    @azure_function_endpoint.setter
    def azure_function_endpoint(self, value: Optional[pulumi.Input['SystemTopicEventSubscriptionAzureFunctionEndpointArgs']]):
        pulumi.set(self, "azure_function_endpoint", value)

    @_builtins.property
    @pulumi.getter(name="deadLetterIdentity")
    def dead_letter_identity(self) -> Optional[pulumi.Input['SystemTopicEventSubscriptionDeadLetterIdentityArgs']]:
        """
        A `dead_letter_identity` block as defined below.

        > **Note:** `storage_blob_dead_letter_destination` must be specified when a `dead_letter_identity` is specified
        """
        return pulumi.get(self, "dead_letter_identity")

    @dead_letter_identity.setter
    def dead_letter_identity(self, value: Optional[pulumi.Input['SystemTopicEventSubscriptionDeadLetterIdentityArgs']]):
        pulumi.set(self, "dead_letter_identity", value)

    @_builtins.property
    @pulumi.getter(name="deliveryIdentity")
    def delivery_identity(self) -> Optional[pulumi.Input['SystemTopicEventSubscriptionDeliveryIdentityArgs']]:
        """
        A `delivery_identity` block as defined below.
        """
        return pulumi.get(self, "delivery_identity")

    @delivery_identity.setter
    def delivery_identity(self, value: Optional[pulumi.Input['SystemTopicEventSubscriptionDeliveryIdentityArgs']]):
        pulumi.set(self, "delivery_identity", value)

    @_builtins.property
    @pulumi.getter(name="deliveryProperties")
    def delivery_properties(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SystemTopicEventSubscriptionDeliveryPropertyArgs']]]]:
        """
        One or more `delivery_property` blocks as defined below.
        """
        return pulumi.get(self, "delivery_properties")

    @delivery_properties.setter
    def delivery_properties(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SystemTopicEventSubscriptionDeliveryPropertyArgs']]]]):
        pulumi.set(self, "delivery_properties", value)

    @_builtins.property
    @pulumi.getter(name="eventDeliverySchema")
    def event_delivery_schema(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the event delivery schema for the event subscription. Possible values include: `EventGridSchema`, `CloudEventSchemaV1_0`, `CustomInputSchema`. Defaults to `EventGridSchema`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "event_delivery_schema")

    @event_delivery_schema.setter
    def event_delivery_schema(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "event_delivery_schema", value)

    @_builtins.property
    @pulumi.getter(name="eventhubEndpointId")
    def eventhub_endpoint_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the id where the Event Hub is located.
        """
        return pulumi.get(self, "eventhub_endpoint_id")

    @eventhub_endpoint_id.setter
    def eventhub_endpoint_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "eventhub_endpoint_id", value)

    @_builtins.property
    @pulumi.getter(name="expirationTimeUtc")
    def expiration_time_utc(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the expiration time of the event subscription (Datetime Format `RFC 3339`).
        """
        return pulumi.get(self, "expiration_time_utc")

    @expiration_time_utc.setter
    def expiration_time_utc(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "expiration_time_utc", value)

    @_builtins.property
    @pulumi.getter(name="hybridConnectionEndpointId")
    def hybrid_connection_endpoint_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the id where the Hybrid Connection is located.
        """
        return pulumi.get(self, "hybrid_connection_endpoint_id")

    @hybrid_connection_endpoint_id.setter
    def hybrid_connection_endpoint_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "hybrid_connection_endpoint_id", value)

    @_builtins.property
    @pulumi.getter(name="includedEventTypes")
    def included_event_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of applicable event types that need to be part of the event subscription.
        """
        return pulumi.get(self, "included_event_types")

    @included_event_types.setter
    def included_event_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "included_event_types", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of labels to assign to the event subscription.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Event Subscription. Changing this forces a new Event Subscription to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="retryPolicy")
    def retry_policy(self) -> Optional[pulumi.Input['SystemTopicEventSubscriptionRetryPolicyArgs']]:
        """
        A `retry_policy` block as defined below.
        """
        return pulumi.get(self, "retry_policy")

    @retry_policy.setter
    def retry_policy(self, value: Optional[pulumi.Input['SystemTopicEventSubscriptionRetryPolicyArgs']]):
        pulumi.set(self, "retry_policy", value)

    @_builtins.property
    @pulumi.getter(name="serviceBusQueueEndpointId")
    def service_bus_queue_endpoint_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the id where the Service Bus Queue is located.
        """
        return pulumi.get(self, "service_bus_queue_endpoint_id")

    @service_bus_queue_endpoint_id.setter
    def service_bus_queue_endpoint_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_bus_queue_endpoint_id", value)

    @_builtins.property
    @pulumi.getter(name="serviceBusTopicEndpointId")
    def service_bus_topic_endpoint_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the id where the Service Bus Topic is located.
        """
        return pulumi.get(self, "service_bus_topic_endpoint_id")

    @service_bus_topic_endpoint_id.setter
    def service_bus_topic_endpoint_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_bus_topic_endpoint_id", value)

    @_builtins.property
    @pulumi.getter(name="storageBlobDeadLetterDestination")
    def storage_blob_dead_letter_destination(self) -> Optional[pulumi.Input['SystemTopicEventSubscriptionStorageBlobDeadLetterDestinationArgs']]:
        """
        A `storage_blob_dead_letter_destination` block as defined below.
        """
        return pulumi.get(self, "storage_blob_dead_letter_destination")

    @storage_blob_dead_letter_destination.setter
    def storage_blob_dead_letter_destination(self, value: Optional[pulumi.Input['SystemTopicEventSubscriptionStorageBlobDeadLetterDestinationArgs']]):
        pulumi.set(self, "storage_blob_dead_letter_destination", value)

    @_builtins.property
    @pulumi.getter(name="storageQueueEndpoint")
    def storage_queue_endpoint(self) -> Optional[pulumi.Input['SystemTopicEventSubscriptionStorageQueueEndpointArgs']]:
        """
        A `storage_queue_endpoint` block as defined below.
        """
        return pulumi.get(self, "storage_queue_endpoint")

    @storage_queue_endpoint.setter
    def storage_queue_endpoint(self, value: Optional[pulumi.Input['SystemTopicEventSubscriptionStorageQueueEndpointArgs']]):
        pulumi.set(self, "storage_queue_endpoint", value)

    @_builtins.property
    @pulumi.getter(name="subjectFilter")
    def subject_filter(self) -> Optional[pulumi.Input['SystemTopicEventSubscriptionSubjectFilterArgs']]:
        """
        A `subject_filter` block as defined below.
        """
        return pulumi.get(self, "subject_filter")

    @subject_filter.setter
    def subject_filter(self, value: Optional[pulumi.Input['SystemTopicEventSubscriptionSubjectFilterArgs']]):
        pulumi.set(self, "subject_filter", value)

    @_builtins.property
    @pulumi.getter(name="webhookEndpoint")
    def webhook_endpoint(self) -> Optional[pulumi.Input['SystemTopicEventSubscriptionWebhookEndpointArgs']]:
        """
        A `webhook_endpoint` block as defined below.

        > **Note:** One of `azure_function_endpoint`, `eventhub_endpoint_id`, `hybrid_connection_endpoint`, `hybrid_connection_endpoint_id`, `service_bus_queue_endpoint_id`, `service_bus_topic_endpoint_id`, `storage_queue_endpoint` or `webhook_endpoint` must be specified.
        """
        return pulumi.get(self, "webhook_endpoint")

    @webhook_endpoint.setter
    def webhook_endpoint(self, value: Optional[pulumi.Input['SystemTopicEventSubscriptionWebhookEndpointArgs']]):
        pulumi.set(self, "webhook_endpoint", value)


@pulumi.input_type
class _SystemTopicEventSubscriptionState:
    def __init__(__self__, *,
                 advanced_filter: Optional[pulumi.Input['SystemTopicEventSubscriptionAdvancedFilterArgs']] = None,
                 advanced_filtering_on_arrays_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 azure_function_endpoint: Optional[pulumi.Input['SystemTopicEventSubscriptionAzureFunctionEndpointArgs']] = None,
                 dead_letter_identity: Optional[pulumi.Input['SystemTopicEventSubscriptionDeadLetterIdentityArgs']] = None,
                 delivery_identity: Optional[pulumi.Input['SystemTopicEventSubscriptionDeliveryIdentityArgs']] = None,
                 delivery_properties: Optional[pulumi.Input[Sequence[pulumi.Input['SystemTopicEventSubscriptionDeliveryPropertyArgs']]]] = None,
                 event_delivery_schema: Optional[pulumi.Input[_builtins.str]] = None,
                 eventhub_endpoint_id: Optional[pulumi.Input[_builtins.str]] = None,
                 expiration_time_utc: Optional[pulumi.Input[_builtins.str]] = None,
                 hybrid_connection_endpoint_id: Optional[pulumi.Input[_builtins.str]] = None,
                 included_event_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 labels: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 retry_policy: Optional[pulumi.Input['SystemTopicEventSubscriptionRetryPolicyArgs']] = None,
                 service_bus_queue_endpoint_id: Optional[pulumi.Input[_builtins.str]] = None,
                 service_bus_topic_endpoint_id: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_blob_dead_letter_destination: Optional[pulumi.Input['SystemTopicEventSubscriptionStorageBlobDeadLetterDestinationArgs']] = None,
                 storage_queue_endpoint: Optional[pulumi.Input['SystemTopicEventSubscriptionStorageQueueEndpointArgs']] = None,
                 subject_filter: Optional[pulumi.Input['SystemTopicEventSubscriptionSubjectFilterArgs']] = None,
                 system_topic: Optional[pulumi.Input[_builtins.str]] = None,
                 webhook_endpoint: Optional[pulumi.Input['SystemTopicEventSubscriptionWebhookEndpointArgs']] = None):
        """
        Input properties used for looking up and filtering SystemTopicEventSubscription resources.
        :param pulumi.Input['SystemTopicEventSubscriptionAdvancedFilterArgs'] advanced_filter: A `advanced_filter` block as defined below.
        :param pulumi.Input[_builtins.bool] advanced_filtering_on_arrays_enabled: Specifies whether advanced filters should be evaluated against an array of values instead of expecting a singular value. Defaults to `false`.
        :param pulumi.Input['SystemTopicEventSubscriptionAzureFunctionEndpointArgs'] azure_function_endpoint: An `azure_function_endpoint` block as defined below.
        :param pulumi.Input['SystemTopicEventSubscriptionDeadLetterIdentityArgs'] dead_letter_identity: A `dead_letter_identity` block as defined below.
               
               > **Note:** `storage_blob_dead_letter_destination` must be specified when a `dead_letter_identity` is specified
        :param pulumi.Input['SystemTopicEventSubscriptionDeliveryIdentityArgs'] delivery_identity: A `delivery_identity` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input['SystemTopicEventSubscriptionDeliveryPropertyArgs']]] delivery_properties: One or more `delivery_property` blocks as defined below.
        :param pulumi.Input[_builtins.str] event_delivery_schema: Specifies the event delivery schema for the event subscription. Possible values include: `EventGridSchema`, `CloudEventSchemaV1_0`, `CustomInputSchema`. Defaults to `EventGridSchema`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] eventhub_endpoint_id: Specifies the id where the Event Hub is located.
        :param pulumi.Input[_builtins.str] expiration_time_utc: Specifies the expiration time of the event subscription (Datetime Format `RFC 3339`).
        :param pulumi.Input[_builtins.str] hybrid_connection_endpoint_id: Specifies the id where the Hybrid Connection is located.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] included_event_types: A list of applicable event types that need to be part of the event subscription.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] labels: A list of labels to assign to the event subscription.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Event Subscription. Changing this forces a new Event Subscription to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the System Topic exists. Changing this forces a new Event Subscription to be created.
        :param pulumi.Input['SystemTopicEventSubscriptionRetryPolicyArgs'] retry_policy: A `retry_policy` block as defined below.
        :param pulumi.Input[_builtins.str] service_bus_queue_endpoint_id: Specifies the id where the Service Bus Queue is located.
        :param pulumi.Input[_builtins.str] service_bus_topic_endpoint_id: Specifies the id where the Service Bus Topic is located.
        :param pulumi.Input['SystemTopicEventSubscriptionStorageBlobDeadLetterDestinationArgs'] storage_blob_dead_letter_destination: A `storage_blob_dead_letter_destination` block as defined below.
        :param pulumi.Input['SystemTopicEventSubscriptionStorageQueueEndpointArgs'] storage_queue_endpoint: A `storage_queue_endpoint` block as defined below.
        :param pulumi.Input['SystemTopicEventSubscriptionSubjectFilterArgs'] subject_filter: A `subject_filter` block as defined below.
        :param pulumi.Input[_builtins.str] system_topic: The System Topic where the Event Subscription should be created in. Changing this forces a new Event Subscription to be created.
        :param pulumi.Input['SystemTopicEventSubscriptionWebhookEndpointArgs'] webhook_endpoint: A `webhook_endpoint` block as defined below.
               
               > **Note:** One of `azure_function_endpoint`, `eventhub_endpoint_id`, `hybrid_connection_endpoint`, `hybrid_connection_endpoint_id`, `service_bus_queue_endpoint_id`, `service_bus_topic_endpoint_id`, `storage_queue_endpoint` or `webhook_endpoint` must be specified.
        """
        if advanced_filter is not None:
            pulumi.set(__self__, "advanced_filter", advanced_filter)
        if advanced_filtering_on_arrays_enabled is not None:
            pulumi.set(__self__, "advanced_filtering_on_arrays_enabled", advanced_filtering_on_arrays_enabled)
        if azure_function_endpoint is not None:
            pulumi.set(__self__, "azure_function_endpoint", azure_function_endpoint)
        if dead_letter_identity is not None:
            pulumi.set(__self__, "dead_letter_identity", dead_letter_identity)
        if delivery_identity is not None:
            pulumi.set(__self__, "delivery_identity", delivery_identity)
        if delivery_properties is not None:
            pulumi.set(__self__, "delivery_properties", delivery_properties)
        if event_delivery_schema is not None:
            pulumi.set(__self__, "event_delivery_schema", event_delivery_schema)
        if eventhub_endpoint_id is not None:
            pulumi.set(__self__, "eventhub_endpoint_id", eventhub_endpoint_id)
        if expiration_time_utc is not None:
            pulumi.set(__self__, "expiration_time_utc", expiration_time_utc)
        if hybrid_connection_endpoint_id is not None:
            pulumi.set(__self__, "hybrid_connection_endpoint_id", hybrid_connection_endpoint_id)
        if included_event_types is not None:
            pulumi.set(__self__, "included_event_types", included_event_types)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if retry_policy is not None:
            pulumi.set(__self__, "retry_policy", retry_policy)
        if service_bus_queue_endpoint_id is not None:
            pulumi.set(__self__, "service_bus_queue_endpoint_id", service_bus_queue_endpoint_id)
        if service_bus_topic_endpoint_id is not None:
            pulumi.set(__self__, "service_bus_topic_endpoint_id", service_bus_topic_endpoint_id)
        if storage_blob_dead_letter_destination is not None:
            pulumi.set(__self__, "storage_blob_dead_letter_destination", storage_blob_dead_letter_destination)
        if storage_queue_endpoint is not None:
            pulumi.set(__self__, "storage_queue_endpoint", storage_queue_endpoint)
        if subject_filter is not None:
            pulumi.set(__self__, "subject_filter", subject_filter)
        if system_topic is not None:
            pulumi.set(__self__, "system_topic", system_topic)
        if webhook_endpoint is not None:
            pulumi.set(__self__, "webhook_endpoint", webhook_endpoint)

    @_builtins.property
    @pulumi.getter(name="advancedFilter")
    def advanced_filter(self) -> Optional[pulumi.Input['SystemTopicEventSubscriptionAdvancedFilterArgs']]:
        """
        A `advanced_filter` block as defined below.
        """
        return pulumi.get(self, "advanced_filter")

    @advanced_filter.setter
    def advanced_filter(self, value: Optional[pulumi.Input['SystemTopicEventSubscriptionAdvancedFilterArgs']]):
        pulumi.set(self, "advanced_filter", value)

    @_builtins.property
    @pulumi.getter(name="advancedFilteringOnArraysEnabled")
    def advanced_filtering_on_arrays_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether advanced filters should be evaluated against an array of values instead of expecting a singular value. Defaults to `false`.
        """
        return pulumi.get(self, "advanced_filtering_on_arrays_enabled")

    @advanced_filtering_on_arrays_enabled.setter
    def advanced_filtering_on_arrays_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "advanced_filtering_on_arrays_enabled", value)

    @_builtins.property
    @pulumi.getter(name="azureFunctionEndpoint")
    def azure_function_endpoint(self) -> Optional[pulumi.Input['SystemTopicEventSubscriptionAzureFunctionEndpointArgs']]:
        """
        An `azure_function_endpoint` block as defined below.
        """
        return pulumi.get(self, "azure_function_endpoint")

    @azure_function_endpoint.setter
    def azure_function_endpoint(self, value: Optional[pulumi.Input['SystemTopicEventSubscriptionAzureFunctionEndpointArgs']]):
        pulumi.set(self, "azure_function_endpoint", value)

    @_builtins.property
    @pulumi.getter(name="deadLetterIdentity")
    def dead_letter_identity(self) -> Optional[pulumi.Input['SystemTopicEventSubscriptionDeadLetterIdentityArgs']]:
        """
        A `dead_letter_identity` block as defined below.

        > **Note:** `storage_blob_dead_letter_destination` must be specified when a `dead_letter_identity` is specified
        """
        return pulumi.get(self, "dead_letter_identity")

    @dead_letter_identity.setter
    def dead_letter_identity(self, value: Optional[pulumi.Input['SystemTopicEventSubscriptionDeadLetterIdentityArgs']]):
        pulumi.set(self, "dead_letter_identity", value)

    @_builtins.property
    @pulumi.getter(name="deliveryIdentity")
    def delivery_identity(self) -> Optional[pulumi.Input['SystemTopicEventSubscriptionDeliveryIdentityArgs']]:
        """
        A `delivery_identity` block as defined below.
        """
        return pulumi.get(self, "delivery_identity")

    @delivery_identity.setter
    def delivery_identity(self, value: Optional[pulumi.Input['SystemTopicEventSubscriptionDeliveryIdentityArgs']]):
        pulumi.set(self, "delivery_identity", value)

    @_builtins.property
    @pulumi.getter(name="deliveryProperties")
    def delivery_properties(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SystemTopicEventSubscriptionDeliveryPropertyArgs']]]]:
        """
        One or more `delivery_property` blocks as defined below.
        """
        return pulumi.get(self, "delivery_properties")

    @delivery_properties.setter
    def delivery_properties(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SystemTopicEventSubscriptionDeliveryPropertyArgs']]]]):
        pulumi.set(self, "delivery_properties", value)

    @_builtins.property
    @pulumi.getter(name="eventDeliverySchema")
    def event_delivery_schema(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the event delivery schema for the event subscription. Possible values include: `EventGridSchema`, `CloudEventSchemaV1_0`, `CustomInputSchema`. Defaults to `EventGridSchema`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "event_delivery_schema")

    @event_delivery_schema.setter
    def event_delivery_schema(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "event_delivery_schema", value)

    @_builtins.property
    @pulumi.getter(name="eventhubEndpointId")
    def eventhub_endpoint_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the id where the Event Hub is located.
        """
        return pulumi.get(self, "eventhub_endpoint_id")

    @eventhub_endpoint_id.setter
    def eventhub_endpoint_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "eventhub_endpoint_id", value)

    @_builtins.property
    @pulumi.getter(name="expirationTimeUtc")
    def expiration_time_utc(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the expiration time of the event subscription (Datetime Format `RFC 3339`).
        """
        return pulumi.get(self, "expiration_time_utc")

    @expiration_time_utc.setter
    def expiration_time_utc(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "expiration_time_utc", value)

    @_builtins.property
    @pulumi.getter(name="hybridConnectionEndpointId")
    def hybrid_connection_endpoint_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the id where the Hybrid Connection is located.
        """
        return pulumi.get(self, "hybrid_connection_endpoint_id")

    @hybrid_connection_endpoint_id.setter
    def hybrid_connection_endpoint_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "hybrid_connection_endpoint_id", value)

    @_builtins.property
    @pulumi.getter(name="includedEventTypes")
    def included_event_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of applicable event types that need to be part of the event subscription.
        """
        return pulumi.get(self, "included_event_types")

    @included_event_types.setter
    def included_event_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "included_event_types", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of labels to assign to the event subscription.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Event Subscription. Changing this forces a new Event Subscription to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Resource Group where the System Topic exists. Changing this forces a new Event Subscription to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="retryPolicy")
    def retry_policy(self) -> Optional[pulumi.Input['SystemTopicEventSubscriptionRetryPolicyArgs']]:
        """
        A `retry_policy` block as defined below.
        """
        return pulumi.get(self, "retry_policy")

    @retry_policy.setter
    def retry_policy(self, value: Optional[pulumi.Input['SystemTopicEventSubscriptionRetryPolicyArgs']]):
        pulumi.set(self, "retry_policy", value)

    @_builtins.property
    @pulumi.getter(name="serviceBusQueueEndpointId")
    def service_bus_queue_endpoint_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the id where the Service Bus Queue is located.
        """
        return pulumi.get(self, "service_bus_queue_endpoint_id")

    @service_bus_queue_endpoint_id.setter
    def service_bus_queue_endpoint_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_bus_queue_endpoint_id", value)

    @_builtins.property
    @pulumi.getter(name="serviceBusTopicEndpointId")
    def service_bus_topic_endpoint_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the id where the Service Bus Topic is located.
        """
        return pulumi.get(self, "service_bus_topic_endpoint_id")

    @service_bus_topic_endpoint_id.setter
    def service_bus_topic_endpoint_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_bus_topic_endpoint_id", value)

    @_builtins.property
    @pulumi.getter(name="storageBlobDeadLetterDestination")
    def storage_blob_dead_letter_destination(self) -> Optional[pulumi.Input['SystemTopicEventSubscriptionStorageBlobDeadLetterDestinationArgs']]:
        """
        A `storage_blob_dead_letter_destination` block as defined below.
        """
        return pulumi.get(self, "storage_blob_dead_letter_destination")

    @storage_blob_dead_letter_destination.setter
    def storage_blob_dead_letter_destination(self, value: Optional[pulumi.Input['SystemTopicEventSubscriptionStorageBlobDeadLetterDestinationArgs']]):
        pulumi.set(self, "storage_blob_dead_letter_destination", value)

    @_builtins.property
    @pulumi.getter(name="storageQueueEndpoint")
    def storage_queue_endpoint(self) -> Optional[pulumi.Input['SystemTopicEventSubscriptionStorageQueueEndpointArgs']]:
        """
        A `storage_queue_endpoint` block as defined below.
        """
        return pulumi.get(self, "storage_queue_endpoint")

    @storage_queue_endpoint.setter
    def storage_queue_endpoint(self, value: Optional[pulumi.Input['SystemTopicEventSubscriptionStorageQueueEndpointArgs']]):
        pulumi.set(self, "storage_queue_endpoint", value)

    @_builtins.property
    @pulumi.getter(name="subjectFilter")
    def subject_filter(self) -> Optional[pulumi.Input['SystemTopicEventSubscriptionSubjectFilterArgs']]:
        """
        A `subject_filter` block as defined below.
        """
        return pulumi.get(self, "subject_filter")

    @subject_filter.setter
    def subject_filter(self, value: Optional[pulumi.Input['SystemTopicEventSubscriptionSubjectFilterArgs']]):
        pulumi.set(self, "subject_filter", value)

    @_builtins.property
    @pulumi.getter(name="systemTopic")
    def system_topic(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The System Topic where the Event Subscription should be created in. Changing this forces a new Event Subscription to be created.
        """
        return pulumi.get(self, "system_topic")

    @system_topic.setter
    def system_topic(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "system_topic", value)

    @_builtins.property
    @pulumi.getter(name="webhookEndpoint")
    def webhook_endpoint(self) -> Optional[pulumi.Input['SystemTopicEventSubscriptionWebhookEndpointArgs']]:
        """
        A `webhook_endpoint` block as defined below.

        > **Note:** One of `azure_function_endpoint`, `eventhub_endpoint_id`, `hybrid_connection_endpoint`, `hybrid_connection_endpoint_id`, `service_bus_queue_endpoint_id`, `service_bus_topic_endpoint_id`, `storage_queue_endpoint` or `webhook_endpoint` must be specified.
        """
        return pulumi.get(self, "webhook_endpoint")

    @webhook_endpoint.setter
    def webhook_endpoint(self, value: Optional[pulumi.Input['SystemTopicEventSubscriptionWebhookEndpointArgs']]):
        pulumi.set(self, "webhook_endpoint", value)


@pulumi.type_token("azure:eventgrid/systemTopicEventSubscription:SystemTopicEventSubscription")
class SystemTopicEventSubscription(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 advanced_filter: Optional[pulumi.Input[Union['SystemTopicEventSubscriptionAdvancedFilterArgs', 'SystemTopicEventSubscriptionAdvancedFilterArgsDict']]] = None,
                 advanced_filtering_on_arrays_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 azure_function_endpoint: Optional[pulumi.Input[Union['SystemTopicEventSubscriptionAzureFunctionEndpointArgs', 'SystemTopicEventSubscriptionAzureFunctionEndpointArgsDict']]] = None,
                 dead_letter_identity: Optional[pulumi.Input[Union['SystemTopicEventSubscriptionDeadLetterIdentityArgs', 'SystemTopicEventSubscriptionDeadLetterIdentityArgsDict']]] = None,
                 delivery_identity: Optional[pulumi.Input[Union['SystemTopicEventSubscriptionDeliveryIdentityArgs', 'SystemTopicEventSubscriptionDeliveryIdentityArgsDict']]] = None,
                 delivery_properties: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SystemTopicEventSubscriptionDeliveryPropertyArgs', 'SystemTopicEventSubscriptionDeliveryPropertyArgsDict']]]]] = None,
                 event_delivery_schema: Optional[pulumi.Input[_builtins.str]] = None,
                 eventhub_endpoint_id: Optional[pulumi.Input[_builtins.str]] = None,
                 expiration_time_utc: Optional[pulumi.Input[_builtins.str]] = None,
                 hybrid_connection_endpoint_id: Optional[pulumi.Input[_builtins.str]] = None,
                 included_event_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 labels: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 retry_policy: Optional[pulumi.Input[Union['SystemTopicEventSubscriptionRetryPolicyArgs', 'SystemTopicEventSubscriptionRetryPolicyArgsDict']]] = None,
                 service_bus_queue_endpoint_id: Optional[pulumi.Input[_builtins.str]] = None,
                 service_bus_topic_endpoint_id: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_blob_dead_letter_destination: Optional[pulumi.Input[Union['SystemTopicEventSubscriptionStorageBlobDeadLetterDestinationArgs', 'SystemTopicEventSubscriptionStorageBlobDeadLetterDestinationArgsDict']]] = None,
                 storage_queue_endpoint: Optional[pulumi.Input[Union['SystemTopicEventSubscriptionStorageQueueEndpointArgs', 'SystemTopicEventSubscriptionStorageQueueEndpointArgsDict']]] = None,
                 subject_filter: Optional[pulumi.Input[Union['SystemTopicEventSubscriptionSubjectFilterArgs', 'SystemTopicEventSubscriptionSubjectFilterArgsDict']]] = None,
                 system_topic: Optional[pulumi.Input[_builtins.str]] = None,
                 webhook_endpoint: Optional[pulumi.Input[Union['SystemTopicEventSubscriptionWebhookEndpointArgs', 'SystemTopicEventSubscriptionWebhookEndpointArgsDict']]] = None,
                 __props__=None):
        """
        Manages an EventGrid System Topic Event Subscription.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-rg",
            location="West Europe")
        example_account = azure.storage.Account("example",
            name="examplestorageaccount",
            resource_group_name=example.name,
            location=example.location,
            account_tier="Standard",
            account_replication_type="LRS",
            tags={
                "environment": "staging",
            })
        example_queue = azure.storage.Queue("example",
            name="examplestoragequeue",
            storage_account_name=example_account.name)
        example_system_topic = azure.eventgrid.SystemTopic("example",
            name="example-system-topic",
            location="Global",
            resource_group_name=example.name,
            source_resource_id=example.id,
            topic_type="Microsoft.Resources.ResourceGroups")
        example_system_topic_event_subscription = azure.eventgrid.SystemTopicEventSubscription("example",
            name="example-event-subscription",
            system_topic=example_system_topic.name,
            resource_group_name=example.name,
            storage_queue_endpoint={
                "storage_account_id": example_account.id,
                "queue_name": example_queue.name,
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.EventGrid` - 2025-02-15

        ## Import

        EventGrid System Topic Event Subscriptions can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:eventgrid/systemTopicEventSubscription:SystemTopicEventSubscription example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.EventGrid/systemTopics/topic1/eventSubscriptions/subscription1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['SystemTopicEventSubscriptionAdvancedFilterArgs', 'SystemTopicEventSubscriptionAdvancedFilterArgsDict']] advanced_filter: A `advanced_filter` block as defined below.
        :param pulumi.Input[_builtins.bool] advanced_filtering_on_arrays_enabled: Specifies whether advanced filters should be evaluated against an array of values instead of expecting a singular value. Defaults to `false`.
        :param pulumi.Input[Union['SystemTopicEventSubscriptionAzureFunctionEndpointArgs', 'SystemTopicEventSubscriptionAzureFunctionEndpointArgsDict']] azure_function_endpoint: An `azure_function_endpoint` block as defined below.
        :param pulumi.Input[Union['SystemTopicEventSubscriptionDeadLetterIdentityArgs', 'SystemTopicEventSubscriptionDeadLetterIdentityArgsDict']] dead_letter_identity: A `dead_letter_identity` block as defined below.
               
               > **Note:** `storage_blob_dead_letter_destination` must be specified when a `dead_letter_identity` is specified
        :param pulumi.Input[Union['SystemTopicEventSubscriptionDeliveryIdentityArgs', 'SystemTopicEventSubscriptionDeliveryIdentityArgsDict']] delivery_identity: A `delivery_identity` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SystemTopicEventSubscriptionDeliveryPropertyArgs', 'SystemTopicEventSubscriptionDeliveryPropertyArgsDict']]]] delivery_properties: One or more `delivery_property` blocks as defined below.
        :param pulumi.Input[_builtins.str] event_delivery_schema: Specifies the event delivery schema for the event subscription. Possible values include: `EventGridSchema`, `CloudEventSchemaV1_0`, `CustomInputSchema`. Defaults to `EventGridSchema`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] eventhub_endpoint_id: Specifies the id where the Event Hub is located.
        :param pulumi.Input[_builtins.str] expiration_time_utc: Specifies the expiration time of the event subscription (Datetime Format `RFC 3339`).
        :param pulumi.Input[_builtins.str] hybrid_connection_endpoint_id: Specifies the id where the Hybrid Connection is located.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] included_event_types: A list of applicable event types that need to be part of the event subscription.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] labels: A list of labels to assign to the event subscription.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Event Subscription. Changing this forces a new Event Subscription to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the System Topic exists. Changing this forces a new Event Subscription to be created.
        :param pulumi.Input[Union['SystemTopicEventSubscriptionRetryPolicyArgs', 'SystemTopicEventSubscriptionRetryPolicyArgsDict']] retry_policy: A `retry_policy` block as defined below.
        :param pulumi.Input[_builtins.str] service_bus_queue_endpoint_id: Specifies the id where the Service Bus Queue is located.
        :param pulumi.Input[_builtins.str] service_bus_topic_endpoint_id: Specifies the id where the Service Bus Topic is located.
        :param pulumi.Input[Union['SystemTopicEventSubscriptionStorageBlobDeadLetterDestinationArgs', 'SystemTopicEventSubscriptionStorageBlobDeadLetterDestinationArgsDict']] storage_blob_dead_letter_destination: A `storage_blob_dead_letter_destination` block as defined below.
        :param pulumi.Input[Union['SystemTopicEventSubscriptionStorageQueueEndpointArgs', 'SystemTopicEventSubscriptionStorageQueueEndpointArgsDict']] storage_queue_endpoint: A `storage_queue_endpoint` block as defined below.
        :param pulumi.Input[Union['SystemTopicEventSubscriptionSubjectFilterArgs', 'SystemTopicEventSubscriptionSubjectFilterArgsDict']] subject_filter: A `subject_filter` block as defined below.
        :param pulumi.Input[_builtins.str] system_topic: The System Topic where the Event Subscription should be created in. Changing this forces a new Event Subscription to be created.
        :param pulumi.Input[Union['SystemTopicEventSubscriptionWebhookEndpointArgs', 'SystemTopicEventSubscriptionWebhookEndpointArgsDict']] webhook_endpoint: A `webhook_endpoint` block as defined below.
               
               > **Note:** One of `azure_function_endpoint`, `eventhub_endpoint_id`, `hybrid_connection_endpoint`, `hybrid_connection_endpoint_id`, `service_bus_queue_endpoint_id`, `service_bus_topic_endpoint_id`, `storage_queue_endpoint` or `webhook_endpoint` must be specified.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SystemTopicEventSubscriptionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an EventGrid System Topic Event Subscription.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-rg",
            location="West Europe")
        example_account = azure.storage.Account("example",
            name="examplestorageaccount",
            resource_group_name=example.name,
            location=example.location,
            account_tier="Standard",
            account_replication_type="LRS",
            tags={
                "environment": "staging",
            })
        example_queue = azure.storage.Queue("example",
            name="examplestoragequeue",
            storage_account_name=example_account.name)
        example_system_topic = azure.eventgrid.SystemTopic("example",
            name="example-system-topic",
            location="Global",
            resource_group_name=example.name,
            source_resource_id=example.id,
            topic_type="Microsoft.Resources.ResourceGroups")
        example_system_topic_event_subscription = azure.eventgrid.SystemTopicEventSubscription("example",
            name="example-event-subscription",
            system_topic=example_system_topic.name,
            resource_group_name=example.name,
            storage_queue_endpoint={
                "storage_account_id": example_account.id,
                "queue_name": example_queue.name,
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.EventGrid` - 2025-02-15

        ## Import

        EventGrid System Topic Event Subscriptions can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:eventgrid/systemTopicEventSubscription:SystemTopicEventSubscription example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.EventGrid/systemTopics/topic1/eventSubscriptions/subscription1
        ```

        :param str resource_name: The name of the resource.
        :param SystemTopicEventSubscriptionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SystemTopicEventSubscriptionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 advanced_filter: Optional[pulumi.Input[Union['SystemTopicEventSubscriptionAdvancedFilterArgs', 'SystemTopicEventSubscriptionAdvancedFilterArgsDict']]] = None,
                 advanced_filtering_on_arrays_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 azure_function_endpoint: Optional[pulumi.Input[Union['SystemTopicEventSubscriptionAzureFunctionEndpointArgs', 'SystemTopicEventSubscriptionAzureFunctionEndpointArgsDict']]] = None,
                 dead_letter_identity: Optional[pulumi.Input[Union['SystemTopicEventSubscriptionDeadLetterIdentityArgs', 'SystemTopicEventSubscriptionDeadLetterIdentityArgsDict']]] = None,
                 delivery_identity: Optional[pulumi.Input[Union['SystemTopicEventSubscriptionDeliveryIdentityArgs', 'SystemTopicEventSubscriptionDeliveryIdentityArgsDict']]] = None,
                 delivery_properties: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SystemTopicEventSubscriptionDeliveryPropertyArgs', 'SystemTopicEventSubscriptionDeliveryPropertyArgsDict']]]]] = None,
                 event_delivery_schema: Optional[pulumi.Input[_builtins.str]] = None,
                 eventhub_endpoint_id: Optional[pulumi.Input[_builtins.str]] = None,
                 expiration_time_utc: Optional[pulumi.Input[_builtins.str]] = None,
                 hybrid_connection_endpoint_id: Optional[pulumi.Input[_builtins.str]] = None,
                 included_event_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 labels: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 retry_policy: Optional[pulumi.Input[Union['SystemTopicEventSubscriptionRetryPolicyArgs', 'SystemTopicEventSubscriptionRetryPolicyArgsDict']]] = None,
                 service_bus_queue_endpoint_id: Optional[pulumi.Input[_builtins.str]] = None,
                 service_bus_topic_endpoint_id: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_blob_dead_letter_destination: Optional[pulumi.Input[Union['SystemTopicEventSubscriptionStorageBlobDeadLetterDestinationArgs', 'SystemTopicEventSubscriptionStorageBlobDeadLetterDestinationArgsDict']]] = None,
                 storage_queue_endpoint: Optional[pulumi.Input[Union['SystemTopicEventSubscriptionStorageQueueEndpointArgs', 'SystemTopicEventSubscriptionStorageQueueEndpointArgsDict']]] = None,
                 subject_filter: Optional[pulumi.Input[Union['SystemTopicEventSubscriptionSubjectFilterArgs', 'SystemTopicEventSubscriptionSubjectFilterArgsDict']]] = None,
                 system_topic: Optional[pulumi.Input[_builtins.str]] = None,
                 webhook_endpoint: Optional[pulumi.Input[Union['SystemTopicEventSubscriptionWebhookEndpointArgs', 'SystemTopicEventSubscriptionWebhookEndpointArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SystemTopicEventSubscriptionArgs.__new__(SystemTopicEventSubscriptionArgs)

            __props__.__dict__["advanced_filter"] = advanced_filter
            __props__.__dict__["advanced_filtering_on_arrays_enabled"] = advanced_filtering_on_arrays_enabled
            __props__.__dict__["azure_function_endpoint"] = azure_function_endpoint
            __props__.__dict__["dead_letter_identity"] = dead_letter_identity
            __props__.__dict__["delivery_identity"] = delivery_identity
            __props__.__dict__["delivery_properties"] = delivery_properties
            __props__.__dict__["event_delivery_schema"] = event_delivery_schema
            __props__.__dict__["eventhub_endpoint_id"] = eventhub_endpoint_id
            __props__.__dict__["expiration_time_utc"] = expiration_time_utc
            __props__.__dict__["hybrid_connection_endpoint_id"] = hybrid_connection_endpoint_id
            __props__.__dict__["included_event_types"] = included_event_types
            __props__.__dict__["labels"] = labels
            __props__.__dict__["name"] = name
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["retry_policy"] = retry_policy
            __props__.__dict__["service_bus_queue_endpoint_id"] = service_bus_queue_endpoint_id
            __props__.__dict__["service_bus_topic_endpoint_id"] = service_bus_topic_endpoint_id
            __props__.__dict__["storage_blob_dead_letter_destination"] = storage_blob_dead_letter_destination
            __props__.__dict__["storage_queue_endpoint"] = storage_queue_endpoint
            __props__.__dict__["subject_filter"] = subject_filter
            if system_topic is None and not opts.urn:
                raise TypeError("Missing required property 'system_topic'")
            __props__.__dict__["system_topic"] = system_topic
            __props__.__dict__["webhook_endpoint"] = webhook_endpoint
        super(SystemTopicEventSubscription, __self__).__init__(
            'azure:eventgrid/systemTopicEventSubscription:SystemTopicEventSubscription',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            advanced_filter: Optional[pulumi.Input[Union['SystemTopicEventSubscriptionAdvancedFilterArgs', 'SystemTopicEventSubscriptionAdvancedFilterArgsDict']]] = None,
            advanced_filtering_on_arrays_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            azure_function_endpoint: Optional[pulumi.Input[Union['SystemTopicEventSubscriptionAzureFunctionEndpointArgs', 'SystemTopicEventSubscriptionAzureFunctionEndpointArgsDict']]] = None,
            dead_letter_identity: Optional[pulumi.Input[Union['SystemTopicEventSubscriptionDeadLetterIdentityArgs', 'SystemTopicEventSubscriptionDeadLetterIdentityArgsDict']]] = None,
            delivery_identity: Optional[pulumi.Input[Union['SystemTopicEventSubscriptionDeliveryIdentityArgs', 'SystemTopicEventSubscriptionDeliveryIdentityArgsDict']]] = None,
            delivery_properties: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SystemTopicEventSubscriptionDeliveryPropertyArgs', 'SystemTopicEventSubscriptionDeliveryPropertyArgsDict']]]]] = None,
            event_delivery_schema: Optional[pulumi.Input[_builtins.str]] = None,
            eventhub_endpoint_id: Optional[pulumi.Input[_builtins.str]] = None,
            expiration_time_utc: Optional[pulumi.Input[_builtins.str]] = None,
            hybrid_connection_endpoint_id: Optional[pulumi.Input[_builtins.str]] = None,
            included_event_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            labels: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            retry_policy: Optional[pulumi.Input[Union['SystemTopicEventSubscriptionRetryPolicyArgs', 'SystemTopicEventSubscriptionRetryPolicyArgsDict']]] = None,
            service_bus_queue_endpoint_id: Optional[pulumi.Input[_builtins.str]] = None,
            service_bus_topic_endpoint_id: Optional[pulumi.Input[_builtins.str]] = None,
            storage_blob_dead_letter_destination: Optional[pulumi.Input[Union['SystemTopicEventSubscriptionStorageBlobDeadLetterDestinationArgs', 'SystemTopicEventSubscriptionStorageBlobDeadLetterDestinationArgsDict']]] = None,
            storage_queue_endpoint: Optional[pulumi.Input[Union['SystemTopicEventSubscriptionStorageQueueEndpointArgs', 'SystemTopicEventSubscriptionStorageQueueEndpointArgsDict']]] = None,
            subject_filter: Optional[pulumi.Input[Union['SystemTopicEventSubscriptionSubjectFilterArgs', 'SystemTopicEventSubscriptionSubjectFilterArgsDict']]] = None,
            system_topic: Optional[pulumi.Input[_builtins.str]] = None,
            webhook_endpoint: Optional[pulumi.Input[Union['SystemTopicEventSubscriptionWebhookEndpointArgs', 'SystemTopicEventSubscriptionWebhookEndpointArgsDict']]] = None) -> 'SystemTopicEventSubscription':
        """
        Get an existing SystemTopicEventSubscription resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['SystemTopicEventSubscriptionAdvancedFilterArgs', 'SystemTopicEventSubscriptionAdvancedFilterArgsDict']] advanced_filter: A `advanced_filter` block as defined below.
        :param pulumi.Input[_builtins.bool] advanced_filtering_on_arrays_enabled: Specifies whether advanced filters should be evaluated against an array of values instead of expecting a singular value. Defaults to `false`.
        :param pulumi.Input[Union['SystemTopicEventSubscriptionAzureFunctionEndpointArgs', 'SystemTopicEventSubscriptionAzureFunctionEndpointArgsDict']] azure_function_endpoint: An `azure_function_endpoint` block as defined below.
        :param pulumi.Input[Union['SystemTopicEventSubscriptionDeadLetterIdentityArgs', 'SystemTopicEventSubscriptionDeadLetterIdentityArgsDict']] dead_letter_identity: A `dead_letter_identity` block as defined below.
               
               > **Note:** `storage_blob_dead_letter_destination` must be specified when a `dead_letter_identity` is specified
        :param pulumi.Input[Union['SystemTopicEventSubscriptionDeliveryIdentityArgs', 'SystemTopicEventSubscriptionDeliveryIdentityArgsDict']] delivery_identity: A `delivery_identity` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SystemTopicEventSubscriptionDeliveryPropertyArgs', 'SystemTopicEventSubscriptionDeliveryPropertyArgsDict']]]] delivery_properties: One or more `delivery_property` blocks as defined below.
        :param pulumi.Input[_builtins.str] event_delivery_schema: Specifies the event delivery schema for the event subscription. Possible values include: `EventGridSchema`, `CloudEventSchemaV1_0`, `CustomInputSchema`. Defaults to `EventGridSchema`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] eventhub_endpoint_id: Specifies the id where the Event Hub is located.
        :param pulumi.Input[_builtins.str] expiration_time_utc: Specifies the expiration time of the event subscription (Datetime Format `RFC 3339`).
        :param pulumi.Input[_builtins.str] hybrid_connection_endpoint_id: Specifies the id where the Hybrid Connection is located.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] included_event_types: A list of applicable event types that need to be part of the event subscription.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] labels: A list of labels to assign to the event subscription.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Event Subscription. Changing this forces a new Event Subscription to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the System Topic exists. Changing this forces a new Event Subscription to be created.
        :param pulumi.Input[Union['SystemTopicEventSubscriptionRetryPolicyArgs', 'SystemTopicEventSubscriptionRetryPolicyArgsDict']] retry_policy: A `retry_policy` block as defined below.
        :param pulumi.Input[_builtins.str] service_bus_queue_endpoint_id: Specifies the id where the Service Bus Queue is located.
        :param pulumi.Input[_builtins.str] service_bus_topic_endpoint_id: Specifies the id where the Service Bus Topic is located.
        :param pulumi.Input[Union['SystemTopicEventSubscriptionStorageBlobDeadLetterDestinationArgs', 'SystemTopicEventSubscriptionStorageBlobDeadLetterDestinationArgsDict']] storage_blob_dead_letter_destination: A `storage_blob_dead_letter_destination` block as defined below.
        :param pulumi.Input[Union['SystemTopicEventSubscriptionStorageQueueEndpointArgs', 'SystemTopicEventSubscriptionStorageQueueEndpointArgsDict']] storage_queue_endpoint: A `storage_queue_endpoint` block as defined below.
        :param pulumi.Input[Union['SystemTopicEventSubscriptionSubjectFilterArgs', 'SystemTopicEventSubscriptionSubjectFilterArgsDict']] subject_filter: A `subject_filter` block as defined below.
        :param pulumi.Input[_builtins.str] system_topic: The System Topic where the Event Subscription should be created in. Changing this forces a new Event Subscription to be created.
        :param pulumi.Input[Union['SystemTopicEventSubscriptionWebhookEndpointArgs', 'SystemTopicEventSubscriptionWebhookEndpointArgsDict']] webhook_endpoint: A `webhook_endpoint` block as defined below.
               
               > **Note:** One of `azure_function_endpoint`, `eventhub_endpoint_id`, `hybrid_connection_endpoint`, `hybrid_connection_endpoint_id`, `service_bus_queue_endpoint_id`, `service_bus_topic_endpoint_id`, `storage_queue_endpoint` or `webhook_endpoint` must be specified.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SystemTopicEventSubscriptionState.__new__(_SystemTopicEventSubscriptionState)

        __props__.__dict__["advanced_filter"] = advanced_filter
        __props__.__dict__["advanced_filtering_on_arrays_enabled"] = advanced_filtering_on_arrays_enabled
        __props__.__dict__["azure_function_endpoint"] = azure_function_endpoint
        __props__.__dict__["dead_letter_identity"] = dead_letter_identity
        __props__.__dict__["delivery_identity"] = delivery_identity
        __props__.__dict__["delivery_properties"] = delivery_properties
        __props__.__dict__["event_delivery_schema"] = event_delivery_schema
        __props__.__dict__["eventhub_endpoint_id"] = eventhub_endpoint_id
        __props__.__dict__["expiration_time_utc"] = expiration_time_utc
        __props__.__dict__["hybrid_connection_endpoint_id"] = hybrid_connection_endpoint_id
        __props__.__dict__["included_event_types"] = included_event_types
        __props__.__dict__["labels"] = labels
        __props__.__dict__["name"] = name
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["retry_policy"] = retry_policy
        __props__.__dict__["service_bus_queue_endpoint_id"] = service_bus_queue_endpoint_id
        __props__.__dict__["service_bus_topic_endpoint_id"] = service_bus_topic_endpoint_id
        __props__.__dict__["storage_blob_dead_letter_destination"] = storage_blob_dead_letter_destination
        __props__.__dict__["storage_queue_endpoint"] = storage_queue_endpoint
        __props__.__dict__["subject_filter"] = subject_filter
        __props__.__dict__["system_topic"] = system_topic
        __props__.__dict__["webhook_endpoint"] = webhook_endpoint
        return SystemTopicEventSubscription(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="advancedFilter")
    def advanced_filter(self) -> pulumi.Output[Optional['outputs.SystemTopicEventSubscriptionAdvancedFilter']]:
        """
        A `advanced_filter` block as defined below.
        """
        return pulumi.get(self, "advanced_filter")

    @_builtins.property
    @pulumi.getter(name="advancedFilteringOnArraysEnabled")
    def advanced_filtering_on_arrays_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether advanced filters should be evaluated against an array of values instead of expecting a singular value. Defaults to `false`.
        """
        return pulumi.get(self, "advanced_filtering_on_arrays_enabled")

    @_builtins.property
    @pulumi.getter(name="azureFunctionEndpoint")
    def azure_function_endpoint(self) -> pulumi.Output[Optional['outputs.SystemTopicEventSubscriptionAzureFunctionEndpoint']]:
        """
        An `azure_function_endpoint` block as defined below.
        """
        return pulumi.get(self, "azure_function_endpoint")

    @_builtins.property
    @pulumi.getter(name="deadLetterIdentity")
    def dead_letter_identity(self) -> pulumi.Output[Optional['outputs.SystemTopicEventSubscriptionDeadLetterIdentity']]:
        """
        A `dead_letter_identity` block as defined below.

        > **Note:** `storage_blob_dead_letter_destination` must be specified when a `dead_letter_identity` is specified
        """
        return pulumi.get(self, "dead_letter_identity")

    @_builtins.property
    @pulumi.getter(name="deliveryIdentity")
    def delivery_identity(self) -> pulumi.Output[Optional['outputs.SystemTopicEventSubscriptionDeliveryIdentity']]:
        """
        A `delivery_identity` block as defined below.
        """
        return pulumi.get(self, "delivery_identity")

    @_builtins.property
    @pulumi.getter(name="deliveryProperties")
    def delivery_properties(self) -> pulumi.Output[Optional[Sequence['outputs.SystemTopicEventSubscriptionDeliveryProperty']]]:
        """
        One or more `delivery_property` blocks as defined below.
        """
        return pulumi.get(self, "delivery_properties")

    @_builtins.property
    @pulumi.getter(name="eventDeliverySchema")
    def event_delivery_schema(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the event delivery schema for the event subscription. Possible values include: `EventGridSchema`, `CloudEventSchemaV1_0`, `CustomInputSchema`. Defaults to `EventGridSchema`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "event_delivery_schema")

    @_builtins.property
    @pulumi.getter(name="eventhubEndpointId")
    def eventhub_endpoint_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the id where the Event Hub is located.
        """
        return pulumi.get(self, "eventhub_endpoint_id")

    @_builtins.property
    @pulumi.getter(name="expirationTimeUtc")
    def expiration_time_utc(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the expiration time of the event subscription (Datetime Format `RFC 3339`).
        """
        return pulumi.get(self, "expiration_time_utc")

    @_builtins.property
    @pulumi.getter(name="hybridConnectionEndpointId")
    def hybrid_connection_endpoint_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the id where the Hybrid Connection is located.
        """
        return pulumi.get(self, "hybrid_connection_endpoint_id")

    @_builtins.property
    @pulumi.getter(name="includedEventTypes")
    def included_event_types(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        A list of applicable event types that need to be part of the event subscription.
        """
        return pulumi.get(self, "included_event_types")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        A list of labels to assign to the event subscription.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name which should be used for this Event Subscription. Changing this forces a new Event Subscription to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Resource Group where the System Topic exists. Changing this forces a new Event Subscription to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter(name="retryPolicy")
    def retry_policy(self) -> pulumi.Output['outputs.SystemTopicEventSubscriptionRetryPolicy']:
        """
        A `retry_policy` block as defined below.
        """
        return pulumi.get(self, "retry_policy")

    @_builtins.property
    @pulumi.getter(name="serviceBusQueueEndpointId")
    def service_bus_queue_endpoint_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the id where the Service Bus Queue is located.
        """
        return pulumi.get(self, "service_bus_queue_endpoint_id")

    @_builtins.property
    @pulumi.getter(name="serviceBusTopicEndpointId")
    def service_bus_topic_endpoint_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the id where the Service Bus Topic is located.
        """
        return pulumi.get(self, "service_bus_topic_endpoint_id")

    @_builtins.property
    @pulumi.getter(name="storageBlobDeadLetterDestination")
    def storage_blob_dead_letter_destination(self) -> pulumi.Output[Optional['outputs.SystemTopicEventSubscriptionStorageBlobDeadLetterDestination']]:
        """
        A `storage_blob_dead_letter_destination` block as defined below.
        """
        return pulumi.get(self, "storage_blob_dead_letter_destination")

    @_builtins.property
    @pulumi.getter(name="storageQueueEndpoint")
    def storage_queue_endpoint(self) -> pulumi.Output[Optional['outputs.SystemTopicEventSubscriptionStorageQueueEndpoint']]:
        """
        A `storage_queue_endpoint` block as defined below.
        """
        return pulumi.get(self, "storage_queue_endpoint")

    @_builtins.property
    @pulumi.getter(name="subjectFilter")
    def subject_filter(self) -> pulumi.Output[Optional['outputs.SystemTopicEventSubscriptionSubjectFilter']]:
        """
        A `subject_filter` block as defined below.
        """
        return pulumi.get(self, "subject_filter")

    @_builtins.property
    @pulumi.getter(name="systemTopic")
    def system_topic(self) -> pulumi.Output[_builtins.str]:
        """
        The System Topic where the Event Subscription should be created in. Changing this forces a new Event Subscription to be created.
        """
        return pulumi.get(self, "system_topic")

    @_builtins.property
    @pulumi.getter(name="webhookEndpoint")
    def webhook_endpoint(self) -> pulumi.Output[Optional['outputs.SystemTopicEventSubscriptionWebhookEndpoint']]:
        """
        A `webhook_endpoint` block as defined below.

        > **Note:** One of `azure_function_endpoint`, `eventhub_endpoint_id`, `hybrid_connection_endpoint`, `hybrid_connection_endpoint_id`, `service_bus_queue_endpoint_id`, `service_bus_topic_endpoint_id`, `storage_queue_endpoint` or `webhook_endpoint` must be specified.
        """
        return pulumi.get(self, "webhook_endpoint")

