# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['EndpointStorageContainerArgs', 'EndpointStorageContainer']

@pulumi.input_type
class EndpointStorageContainerArgs:
    def __init__(__self__, *,
                 container_name: pulumi.Input[_builtins.str],
                 iothub_id: pulumi.Input[_builtins.str],
                 resource_group_name: pulumi.Input[_builtins.str],
                 authentication_type: Optional[pulumi.Input[_builtins.str]] = None,
                 batch_frequency_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 connection_string: Optional[pulumi.Input[_builtins.str]] = None,
                 encoding: Optional[pulumi.Input[_builtins.str]] = None,
                 endpoint_uri: Optional[pulumi.Input[_builtins.str]] = None,
                 file_name_format: Optional[pulumi.Input[_builtins.str]] = None,
                 identity_id: Optional[pulumi.Input[_builtins.str]] = None,
                 max_chunk_size_in_bytes: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 subscription_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a EndpointStorageContainer resource.
        :param pulumi.Input[_builtins.str] container_name: The name of storage container in the storage account.
        :param pulumi.Input[_builtins.str] iothub_id: The IoTHub ID for the endpoint. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group under which the Storage Container has been created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] authentication_type: Type used to authenticate against the storage endpoint. Possible values are `keyBased` and `identityBased`. Defaults to `keyBased`.
        :param pulumi.Input[_builtins.int] batch_frequency_in_seconds: Time interval at which blobs are written to storage. Value should be between 60 and 720 seconds. Default value is 300 seconds.
        :param pulumi.Input[_builtins.str] connection_string: The connection string for the endpoint. This attribute can only be specified and is mandatory when `authentication_type` is `keyBased`.
        :param pulumi.Input[_builtins.str] encoding: Encoding that is used to serialize messages to blobs. Supported values are `Avro`, `AvroDeflate` and `JSON`. Default value is `Avro`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] endpoint_uri: URI of the Storage Container endpoint. This corresponds to the `primary_blob_endpoint` of the parent storage account. This attribute can only be specified and is mandatory when `authentication_type` is `identityBased`.
        :param pulumi.Input[_builtins.str] file_name_format: File name format for the blob. All parameters are mandatory but can be reordered. Defaults to `{iothub}/{partition}/{YYYY}/{MM}/{DD}/{HH}/{mm}`.
        :param pulumi.Input[_builtins.str] identity_id: ID of the User Managed Identity used to authenticate against the storage endpoint.
               
               > **Note:** `identity_id` can only be specified when `authentication_type` is `identityBased`. It must be one of the `identity_ids` of the Iot Hub. If not specified when `authentication_type` is `identityBased`, System Assigned Managed Identity of the Iot Hub will be used.
        :param pulumi.Input[_builtins.int] max_chunk_size_in_bytes: Maximum number of bytes for each blob written to storage. Value should be between 10485760(10MB) and 524288000(500MB). Default value is 314572800(300MB).
        :param pulumi.Input[_builtins.str] name: The name of the endpoint. The name must be unique across endpoint types. The following names are reserved: `events`, `operationsMonitoringEvents`, `fileNotifications` and `$default`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] subscription_id: The subscription ID for the endpoint.
               
               > **Note:** When `subscription_id` isn't specified it will be set to the subscription ID of the IoT Hub resource.
        """
        pulumi.set(__self__, "container_name", container_name)
        pulumi.set(__self__, "iothub_id", iothub_id)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if authentication_type is not None:
            pulumi.set(__self__, "authentication_type", authentication_type)
        if batch_frequency_in_seconds is not None:
            pulumi.set(__self__, "batch_frequency_in_seconds", batch_frequency_in_seconds)
        if connection_string is not None:
            pulumi.set(__self__, "connection_string", connection_string)
        if encoding is not None:
            pulumi.set(__self__, "encoding", encoding)
        if endpoint_uri is not None:
            pulumi.set(__self__, "endpoint_uri", endpoint_uri)
        if file_name_format is not None:
            pulumi.set(__self__, "file_name_format", file_name_format)
        if identity_id is not None:
            pulumi.set(__self__, "identity_id", identity_id)
        if max_chunk_size_in_bytes is not None:
            pulumi.set(__self__, "max_chunk_size_in_bytes", max_chunk_size_in_bytes)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if subscription_id is not None:
            pulumi.set(__self__, "subscription_id", subscription_id)

    @_builtins.property
    @pulumi.getter(name="containerName")
    def container_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of storage container in the storage account.
        """
        return pulumi.get(self, "container_name")

    @container_name.setter
    def container_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "container_name", value)

    @_builtins.property
    @pulumi.getter(name="iothubId")
    def iothub_id(self) -> pulumi.Input[_builtins.str]:
        """
        The IoTHub ID for the endpoint. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "iothub_id")

    @iothub_id.setter
    def iothub_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "iothub_id", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the resource group under which the Storage Container has been created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="authenticationType")
    def authentication_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Type used to authenticate against the storage endpoint. Possible values are `keyBased` and `identityBased`. Defaults to `keyBased`.
        """
        return pulumi.get(self, "authentication_type")

    @authentication_type.setter
    def authentication_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "authentication_type", value)

    @_builtins.property
    @pulumi.getter(name="batchFrequencyInSeconds")
    def batch_frequency_in_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Time interval at which blobs are written to storage. Value should be between 60 and 720 seconds. Default value is 300 seconds.
        """
        return pulumi.get(self, "batch_frequency_in_seconds")

    @batch_frequency_in_seconds.setter
    def batch_frequency_in_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "batch_frequency_in_seconds", value)

    @_builtins.property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The connection string for the endpoint. This attribute can only be specified and is mandatory when `authentication_type` is `keyBased`.
        """
        return pulumi.get(self, "connection_string")

    @connection_string.setter
    def connection_string(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "connection_string", value)

    @_builtins.property
    @pulumi.getter
    def encoding(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Encoding that is used to serialize messages to blobs. Supported values are `Avro`, `AvroDeflate` and `JSON`. Default value is `Avro`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "encoding")

    @encoding.setter
    def encoding(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "encoding", value)

    @_builtins.property
    @pulumi.getter(name="endpointUri")
    def endpoint_uri(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        URI of the Storage Container endpoint. This corresponds to the `primary_blob_endpoint` of the parent storage account. This attribute can only be specified and is mandatory when `authentication_type` is `identityBased`.
        """
        return pulumi.get(self, "endpoint_uri")

    @endpoint_uri.setter
    def endpoint_uri(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "endpoint_uri", value)

    @_builtins.property
    @pulumi.getter(name="fileNameFormat")
    def file_name_format(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        File name format for the blob. All parameters are mandatory but can be reordered. Defaults to `{iothub}/{partition}/{YYYY}/{MM}/{DD}/{HH}/{mm}`.
        """
        return pulumi.get(self, "file_name_format")

    @file_name_format.setter
    def file_name_format(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "file_name_format", value)

    @_builtins.property
    @pulumi.getter(name="identityId")
    def identity_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the User Managed Identity used to authenticate against the storage endpoint.

        > **Note:** `identity_id` can only be specified when `authentication_type` is `identityBased`. It must be one of the `identity_ids` of the Iot Hub. If not specified when `authentication_type` is `identityBased`, System Assigned Managed Identity of the Iot Hub will be used.
        """
        return pulumi.get(self, "identity_id")

    @identity_id.setter
    def identity_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "identity_id", value)

    @_builtins.property
    @pulumi.getter(name="maxChunkSizeInBytes")
    def max_chunk_size_in_bytes(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Maximum number of bytes for each blob written to storage. Value should be between 10485760(10MB) and 524288000(500MB). Default value is 314572800(300MB).
        """
        return pulumi.get(self, "max_chunk_size_in_bytes")

    @max_chunk_size_in_bytes.setter
    def max_chunk_size_in_bytes(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_chunk_size_in_bytes", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the endpoint. The name must be unique across endpoint types. The following names are reserved: `events`, `operationsMonitoringEvents`, `fileNotifications` and `$default`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The subscription ID for the endpoint.

        > **Note:** When `subscription_id` isn't specified it will be set to the subscription ID of the IoT Hub resource.
        """
        return pulumi.get(self, "subscription_id")

    @subscription_id.setter
    def subscription_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subscription_id", value)


@pulumi.input_type
class _EndpointStorageContainerState:
    def __init__(__self__, *,
                 authentication_type: Optional[pulumi.Input[_builtins.str]] = None,
                 batch_frequency_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 connection_string: Optional[pulumi.Input[_builtins.str]] = None,
                 container_name: Optional[pulumi.Input[_builtins.str]] = None,
                 encoding: Optional[pulumi.Input[_builtins.str]] = None,
                 endpoint_uri: Optional[pulumi.Input[_builtins.str]] = None,
                 file_name_format: Optional[pulumi.Input[_builtins.str]] = None,
                 identity_id: Optional[pulumi.Input[_builtins.str]] = None,
                 iothub_id: Optional[pulumi.Input[_builtins.str]] = None,
                 max_chunk_size_in_bytes: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 subscription_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering EndpointStorageContainer resources.
        :param pulumi.Input[_builtins.str] authentication_type: Type used to authenticate against the storage endpoint. Possible values are `keyBased` and `identityBased`. Defaults to `keyBased`.
        :param pulumi.Input[_builtins.int] batch_frequency_in_seconds: Time interval at which blobs are written to storage. Value should be between 60 and 720 seconds. Default value is 300 seconds.
        :param pulumi.Input[_builtins.str] connection_string: The connection string for the endpoint. This attribute can only be specified and is mandatory when `authentication_type` is `keyBased`.
        :param pulumi.Input[_builtins.str] container_name: The name of storage container in the storage account.
        :param pulumi.Input[_builtins.str] encoding: Encoding that is used to serialize messages to blobs. Supported values are `Avro`, `AvroDeflate` and `JSON`. Default value is `Avro`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] endpoint_uri: URI of the Storage Container endpoint. This corresponds to the `primary_blob_endpoint` of the parent storage account. This attribute can only be specified and is mandatory when `authentication_type` is `identityBased`.
        :param pulumi.Input[_builtins.str] file_name_format: File name format for the blob. All parameters are mandatory but can be reordered. Defaults to `{iothub}/{partition}/{YYYY}/{MM}/{DD}/{HH}/{mm}`.
        :param pulumi.Input[_builtins.str] identity_id: ID of the User Managed Identity used to authenticate against the storage endpoint.
               
               > **Note:** `identity_id` can only be specified when `authentication_type` is `identityBased`. It must be one of the `identity_ids` of the Iot Hub. If not specified when `authentication_type` is `identityBased`, System Assigned Managed Identity of the Iot Hub will be used.
        :param pulumi.Input[_builtins.str] iothub_id: The IoTHub ID for the endpoint. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] max_chunk_size_in_bytes: Maximum number of bytes for each blob written to storage. Value should be between 10485760(10MB) and 524288000(500MB). Default value is 314572800(300MB).
        :param pulumi.Input[_builtins.str] name: The name of the endpoint. The name must be unique across endpoint types. The following names are reserved: `events`, `operationsMonitoringEvents`, `fileNotifications` and `$default`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group under which the Storage Container has been created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] subscription_id: The subscription ID for the endpoint.
               
               > **Note:** When `subscription_id` isn't specified it will be set to the subscription ID of the IoT Hub resource.
        """
        if authentication_type is not None:
            pulumi.set(__self__, "authentication_type", authentication_type)
        if batch_frequency_in_seconds is not None:
            pulumi.set(__self__, "batch_frequency_in_seconds", batch_frequency_in_seconds)
        if connection_string is not None:
            pulumi.set(__self__, "connection_string", connection_string)
        if container_name is not None:
            pulumi.set(__self__, "container_name", container_name)
        if encoding is not None:
            pulumi.set(__self__, "encoding", encoding)
        if endpoint_uri is not None:
            pulumi.set(__self__, "endpoint_uri", endpoint_uri)
        if file_name_format is not None:
            pulumi.set(__self__, "file_name_format", file_name_format)
        if identity_id is not None:
            pulumi.set(__self__, "identity_id", identity_id)
        if iothub_id is not None:
            pulumi.set(__self__, "iothub_id", iothub_id)
        if max_chunk_size_in_bytes is not None:
            pulumi.set(__self__, "max_chunk_size_in_bytes", max_chunk_size_in_bytes)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if subscription_id is not None:
            pulumi.set(__self__, "subscription_id", subscription_id)

    @_builtins.property
    @pulumi.getter(name="authenticationType")
    def authentication_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Type used to authenticate against the storage endpoint. Possible values are `keyBased` and `identityBased`. Defaults to `keyBased`.
        """
        return pulumi.get(self, "authentication_type")

    @authentication_type.setter
    def authentication_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "authentication_type", value)

    @_builtins.property
    @pulumi.getter(name="batchFrequencyInSeconds")
    def batch_frequency_in_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Time interval at which blobs are written to storage. Value should be between 60 and 720 seconds. Default value is 300 seconds.
        """
        return pulumi.get(self, "batch_frequency_in_seconds")

    @batch_frequency_in_seconds.setter
    def batch_frequency_in_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "batch_frequency_in_seconds", value)

    @_builtins.property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The connection string for the endpoint. This attribute can only be specified and is mandatory when `authentication_type` is `keyBased`.
        """
        return pulumi.get(self, "connection_string")

    @connection_string.setter
    def connection_string(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "connection_string", value)

    @_builtins.property
    @pulumi.getter(name="containerName")
    def container_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of storage container in the storage account.
        """
        return pulumi.get(self, "container_name")

    @container_name.setter
    def container_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "container_name", value)

    @_builtins.property
    @pulumi.getter
    def encoding(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Encoding that is used to serialize messages to blobs. Supported values are `Avro`, `AvroDeflate` and `JSON`. Default value is `Avro`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "encoding")

    @encoding.setter
    def encoding(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "encoding", value)

    @_builtins.property
    @pulumi.getter(name="endpointUri")
    def endpoint_uri(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        URI of the Storage Container endpoint. This corresponds to the `primary_blob_endpoint` of the parent storage account. This attribute can only be specified and is mandatory when `authentication_type` is `identityBased`.
        """
        return pulumi.get(self, "endpoint_uri")

    @endpoint_uri.setter
    def endpoint_uri(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "endpoint_uri", value)

    @_builtins.property
    @pulumi.getter(name="fileNameFormat")
    def file_name_format(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        File name format for the blob. All parameters are mandatory but can be reordered. Defaults to `{iothub}/{partition}/{YYYY}/{MM}/{DD}/{HH}/{mm}`.
        """
        return pulumi.get(self, "file_name_format")

    @file_name_format.setter
    def file_name_format(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "file_name_format", value)

    @_builtins.property
    @pulumi.getter(name="identityId")
    def identity_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the User Managed Identity used to authenticate against the storage endpoint.

        > **Note:** `identity_id` can only be specified when `authentication_type` is `identityBased`. It must be one of the `identity_ids` of the Iot Hub. If not specified when `authentication_type` is `identityBased`, System Assigned Managed Identity of the Iot Hub will be used.
        """
        return pulumi.get(self, "identity_id")

    @identity_id.setter
    def identity_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "identity_id", value)

    @_builtins.property
    @pulumi.getter(name="iothubId")
    def iothub_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IoTHub ID for the endpoint. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "iothub_id")

    @iothub_id.setter
    def iothub_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "iothub_id", value)

    @_builtins.property
    @pulumi.getter(name="maxChunkSizeInBytes")
    def max_chunk_size_in_bytes(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Maximum number of bytes for each blob written to storage. Value should be between 10485760(10MB) and 524288000(500MB). Default value is 314572800(300MB).
        """
        return pulumi.get(self, "max_chunk_size_in_bytes")

    @max_chunk_size_in_bytes.setter
    def max_chunk_size_in_bytes(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_chunk_size_in_bytes", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the endpoint. The name must be unique across endpoint types. The following names are reserved: `events`, `operationsMonitoringEvents`, `fileNotifications` and `$default`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the resource group under which the Storage Container has been created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The subscription ID for the endpoint.

        > **Note:** When `subscription_id` isn't specified it will be set to the subscription ID of the IoT Hub resource.
        """
        return pulumi.get(self, "subscription_id")

    @subscription_id.setter
    def subscription_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subscription_id", value)


@pulumi.type_token("azure:iot/endpointStorageContainer:EndpointStorageContainer")
class EndpointStorageContainer(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authentication_type: Optional[pulumi.Input[_builtins.str]] = None,
                 batch_frequency_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 connection_string: Optional[pulumi.Input[_builtins.str]] = None,
                 container_name: Optional[pulumi.Input[_builtins.str]] = None,
                 encoding: Optional[pulumi.Input[_builtins.str]] = None,
                 endpoint_uri: Optional[pulumi.Input[_builtins.str]] = None,
                 file_name_format: Optional[pulumi.Input[_builtins.str]] = None,
                 identity_id: Optional[pulumi.Input[_builtins.str]] = None,
                 iothub_id: Optional[pulumi.Input[_builtins.str]] = None,
                 max_chunk_size_in_bytes: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 subscription_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages an IotHub Storage Container Endpoint

        > **Note:** Endpoints can be defined either directly on the `iot.IoTHub` resource, or using the `azurerm_iothub_endpoint_*` resources - but the two ways of defining the endpoints cannot be used together. If both are used against the same IoTHub, spurious changes will occur. Also, defining a `azurerm_iothub_endpoint_*` resource and another endpoint of a different type directly on the `iot.IoTHub` resource is not supported.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_account = azure.storage.Account("example",
            name="example",
            resource_group_name=example.name,
            location=example.location,
            account_tier="Standard",
            account_replication_type="LRS")
        example_container = azure.storage.Container("example",
            name="acctestcont",
            storage_account_name=example_account.name,
            container_access_type="private")
        example_io_t_hub = azure.iot.IoTHub("example",
            name="example",
            resource_group_name=example.name,
            location=example.location,
            sku={
                "name": "S1",
                "capacity": 1,
            })
        example_endpoint_storage_container = azure.iot.EndpointStorageContainer("example",
            resource_group_name=example.name,
            iothub_id=example_io_t_hub.id,
            name="acctest",
            container_name="acctestcont",
            connection_string=example_account.primary_blob_connection_string,
            file_name_format="{iothub}/{partition}_{YYYY}_{MM}_{DD}_{HH}_{mm}",
            batch_frequency_in_seconds=60,
            max_chunk_size_in_bytes=10485760,
            encoding="JSON")
        ```

        ## Import

        IoTHub Storage Container Endpoint can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:iot/endpointStorageContainer:EndpointStorageContainer storage_container1 /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.Devices/iotHubs/hub1/endpoints/storage_container_endpoint1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] authentication_type: Type used to authenticate against the storage endpoint. Possible values are `keyBased` and `identityBased`. Defaults to `keyBased`.
        :param pulumi.Input[_builtins.int] batch_frequency_in_seconds: Time interval at which blobs are written to storage. Value should be between 60 and 720 seconds. Default value is 300 seconds.
        :param pulumi.Input[_builtins.str] connection_string: The connection string for the endpoint. This attribute can only be specified and is mandatory when `authentication_type` is `keyBased`.
        :param pulumi.Input[_builtins.str] container_name: The name of storage container in the storage account.
        :param pulumi.Input[_builtins.str] encoding: Encoding that is used to serialize messages to blobs. Supported values are `Avro`, `AvroDeflate` and `JSON`. Default value is `Avro`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] endpoint_uri: URI of the Storage Container endpoint. This corresponds to the `primary_blob_endpoint` of the parent storage account. This attribute can only be specified and is mandatory when `authentication_type` is `identityBased`.
        :param pulumi.Input[_builtins.str] file_name_format: File name format for the blob. All parameters are mandatory but can be reordered. Defaults to `{iothub}/{partition}/{YYYY}/{MM}/{DD}/{HH}/{mm}`.
        :param pulumi.Input[_builtins.str] identity_id: ID of the User Managed Identity used to authenticate against the storage endpoint.
               
               > **Note:** `identity_id` can only be specified when `authentication_type` is `identityBased`. It must be one of the `identity_ids` of the Iot Hub. If not specified when `authentication_type` is `identityBased`, System Assigned Managed Identity of the Iot Hub will be used.
        :param pulumi.Input[_builtins.str] iothub_id: The IoTHub ID for the endpoint. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] max_chunk_size_in_bytes: Maximum number of bytes for each blob written to storage. Value should be between 10485760(10MB) and 524288000(500MB). Default value is 314572800(300MB).
        :param pulumi.Input[_builtins.str] name: The name of the endpoint. The name must be unique across endpoint types. The following names are reserved: `events`, `operationsMonitoringEvents`, `fileNotifications` and `$default`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group under which the Storage Container has been created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] subscription_id: The subscription ID for the endpoint.
               
               > **Note:** When `subscription_id` isn't specified it will be set to the subscription ID of the IoT Hub resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EndpointStorageContainerArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an IotHub Storage Container Endpoint

        > **Note:** Endpoints can be defined either directly on the `iot.IoTHub` resource, or using the `azurerm_iothub_endpoint_*` resources - but the two ways of defining the endpoints cannot be used together. If both are used against the same IoTHub, spurious changes will occur. Also, defining a `azurerm_iothub_endpoint_*` resource and another endpoint of a different type directly on the `iot.IoTHub` resource is not supported.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_account = azure.storage.Account("example",
            name="example",
            resource_group_name=example.name,
            location=example.location,
            account_tier="Standard",
            account_replication_type="LRS")
        example_container = azure.storage.Container("example",
            name="acctestcont",
            storage_account_name=example_account.name,
            container_access_type="private")
        example_io_t_hub = azure.iot.IoTHub("example",
            name="example",
            resource_group_name=example.name,
            location=example.location,
            sku={
                "name": "S1",
                "capacity": 1,
            })
        example_endpoint_storage_container = azure.iot.EndpointStorageContainer("example",
            resource_group_name=example.name,
            iothub_id=example_io_t_hub.id,
            name="acctest",
            container_name="acctestcont",
            connection_string=example_account.primary_blob_connection_string,
            file_name_format="{iothub}/{partition}_{YYYY}_{MM}_{DD}_{HH}_{mm}",
            batch_frequency_in_seconds=60,
            max_chunk_size_in_bytes=10485760,
            encoding="JSON")
        ```

        ## Import

        IoTHub Storage Container Endpoint can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:iot/endpointStorageContainer:EndpointStorageContainer storage_container1 /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.Devices/iotHubs/hub1/endpoints/storage_container_endpoint1
        ```

        :param str resource_name: The name of the resource.
        :param EndpointStorageContainerArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EndpointStorageContainerArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authentication_type: Optional[pulumi.Input[_builtins.str]] = None,
                 batch_frequency_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 connection_string: Optional[pulumi.Input[_builtins.str]] = None,
                 container_name: Optional[pulumi.Input[_builtins.str]] = None,
                 encoding: Optional[pulumi.Input[_builtins.str]] = None,
                 endpoint_uri: Optional[pulumi.Input[_builtins.str]] = None,
                 file_name_format: Optional[pulumi.Input[_builtins.str]] = None,
                 identity_id: Optional[pulumi.Input[_builtins.str]] = None,
                 iothub_id: Optional[pulumi.Input[_builtins.str]] = None,
                 max_chunk_size_in_bytes: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 subscription_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EndpointStorageContainerArgs.__new__(EndpointStorageContainerArgs)

            __props__.__dict__["authentication_type"] = authentication_type
            __props__.__dict__["batch_frequency_in_seconds"] = batch_frequency_in_seconds
            __props__.__dict__["connection_string"] = None if connection_string is None else pulumi.Output.secret(connection_string)
            if container_name is None and not opts.urn:
                raise TypeError("Missing required property 'container_name'")
            __props__.__dict__["container_name"] = container_name
            __props__.__dict__["encoding"] = encoding
            __props__.__dict__["endpoint_uri"] = endpoint_uri
            __props__.__dict__["file_name_format"] = file_name_format
            __props__.__dict__["identity_id"] = identity_id
            if iothub_id is None and not opts.urn:
                raise TypeError("Missing required property 'iothub_id'")
            __props__.__dict__["iothub_id"] = iothub_id
            __props__.__dict__["max_chunk_size_in_bytes"] = max_chunk_size_in_bytes
            __props__.__dict__["name"] = name
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["subscription_id"] = subscription_id
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["connectionString"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(EndpointStorageContainer, __self__).__init__(
            'azure:iot/endpointStorageContainer:EndpointStorageContainer',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            authentication_type: Optional[pulumi.Input[_builtins.str]] = None,
            batch_frequency_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
            connection_string: Optional[pulumi.Input[_builtins.str]] = None,
            container_name: Optional[pulumi.Input[_builtins.str]] = None,
            encoding: Optional[pulumi.Input[_builtins.str]] = None,
            endpoint_uri: Optional[pulumi.Input[_builtins.str]] = None,
            file_name_format: Optional[pulumi.Input[_builtins.str]] = None,
            identity_id: Optional[pulumi.Input[_builtins.str]] = None,
            iothub_id: Optional[pulumi.Input[_builtins.str]] = None,
            max_chunk_size_in_bytes: Optional[pulumi.Input[_builtins.int]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            subscription_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'EndpointStorageContainer':
        """
        Get an existing EndpointStorageContainer resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] authentication_type: Type used to authenticate against the storage endpoint. Possible values are `keyBased` and `identityBased`. Defaults to `keyBased`.
        :param pulumi.Input[_builtins.int] batch_frequency_in_seconds: Time interval at which blobs are written to storage. Value should be between 60 and 720 seconds. Default value is 300 seconds.
        :param pulumi.Input[_builtins.str] connection_string: The connection string for the endpoint. This attribute can only be specified and is mandatory when `authentication_type` is `keyBased`.
        :param pulumi.Input[_builtins.str] container_name: The name of storage container in the storage account.
        :param pulumi.Input[_builtins.str] encoding: Encoding that is used to serialize messages to blobs. Supported values are `Avro`, `AvroDeflate` and `JSON`. Default value is `Avro`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] endpoint_uri: URI of the Storage Container endpoint. This corresponds to the `primary_blob_endpoint` of the parent storage account. This attribute can only be specified and is mandatory when `authentication_type` is `identityBased`.
        :param pulumi.Input[_builtins.str] file_name_format: File name format for the blob. All parameters are mandatory but can be reordered. Defaults to `{iothub}/{partition}/{YYYY}/{MM}/{DD}/{HH}/{mm}`.
        :param pulumi.Input[_builtins.str] identity_id: ID of the User Managed Identity used to authenticate against the storage endpoint.
               
               > **Note:** `identity_id` can only be specified when `authentication_type` is `identityBased`. It must be one of the `identity_ids` of the Iot Hub. If not specified when `authentication_type` is `identityBased`, System Assigned Managed Identity of the Iot Hub will be used.
        :param pulumi.Input[_builtins.str] iothub_id: The IoTHub ID for the endpoint. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] max_chunk_size_in_bytes: Maximum number of bytes for each blob written to storage. Value should be between 10485760(10MB) and 524288000(500MB). Default value is 314572800(300MB).
        :param pulumi.Input[_builtins.str] name: The name of the endpoint. The name must be unique across endpoint types. The following names are reserved: `events`, `operationsMonitoringEvents`, `fileNotifications` and `$default`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group under which the Storage Container has been created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] subscription_id: The subscription ID for the endpoint.
               
               > **Note:** When `subscription_id` isn't specified it will be set to the subscription ID of the IoT Hub resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EndpointStorageContainerState.__new__(_EndpointStorageContainerState)

        __props__.__dict__["authentication_type"] = authentication_type
        __props__.__dict__["batch_frequency_in_seconds"] = batch_frequency_in_seconds
        __props__.__dict__["connection_string"] = connection_string
        __props__.__dict__["container_name"] = container_name
        __props__.__dict__["encoding"] = encoding
        __props__.__dict__["endpoint_uri"] = endpoint_uri
        __props__.__dict__["file_name_format"] = file_name_format
        __props__.__dict__["identity_id"] = identity_id
        __props__.__dict__["iothub_id"] = iothub_id
        __props__.__dict__["max_chunk_size_in_bytes"] = max_chunk_size_in_bytes
        __props__.__dict__["name"] = name
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["subscription_id"] = subscription_id
        return EndpointStorageContainer(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="authenticationType")
    def authentication_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Type used to authenticate against the storage endpoint. Possible values are `keyBased` and `identityBased`. Defaults to `keyBased`.
        """
        return pulumi.get(self, "authentication_type")

    @_builtins.property
    @pulumi.getter(name="batchFrequencyInSeconds")
    def batch_frequency_in_seconds(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Time interval at which blobs are written to storage. Value should be between 60 and 720 seconds. Default value is 300 seconds.
        """
        return pulumi.get(self, "batch_frequency_in_seconds")

    @_builtins.property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The connection string for the endpoint. This attribute can only be specified and is mandatory when `authentication_type` is `keyBased`.
        """
        return pulumi.get(self, "connection_string")

    @_builtins.property
    @pulumi.getter(name="containerName")
    def container_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of storage container in the storage account.
        """
        return pulumi.get(self, "container_name")

    @_builtins.property
    @pulumi.getter
    def encoding(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Encoding that is used to serialize messages to blobs. Supported values are `Avro`, `AvroDeflate` and `JSON`. Default value is `Avro`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "encoding")

    @_builtins.property
    @pulumi.getter(name="endpointUri")
    def endpoint_uri(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        URI of the Storage Container endpoint. This corresponds to the `primary_blob_endpoint` of the parent storage account. This attribute can only be specified and is mandatory when `authentication_type` is `identityBased`.
        """
        return pulumi.get(self, "endpoint_uri")

    @_builtins.property
    @pulumi.getter(name="fileNameFormat")
    def file_name_format(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        File name format for the blob. All parameters are mandatory but can be reordered. Defaults to `{iothub}/{partition}/{YYYY}/{MM}/{DD}/{HH}/{mm}`.
        """
        return pulumi.get(self, "file_name_format")

    @_builtins.property
    @pulumi.getter(name="identityId")
    def identity_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        ID of the User Managed Identity used to authenticate against the storage endpoint.

        > **Note:** `identity_id` can only be specified when `authentication_type` is `identityBased`. It must be one of the `identity_ids` of the Iot Hub. If not specified when `authentication_type` is `identityBased`, System Assigned Managed Identity of the Iot Hub will be used.
        """
        return pulumi.get(self, "identity_id")

    @_builtins.property
    @pulumi.getter(name="iothubId")
    def iothub_id(self) -> pulumi.Output[_builtins.str]:
        """
        The IoTHub ID for the endpoint. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "iothub_id")

    @_builtins.property
    @pulumi.getter(name="maxChunkSizeInBytes")
    def max_chunk_size_in_bytes(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Maximum number of bytes for each blob written to storage. Value should be between 10485760(10MB) and 524288000(500MB). Default value is 314572800(300MB).
        """
        return pulumi.get(self, "max_chunk_size_in_bytes")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the endpoint. The name must be unique across endpoint types. The following names are reserved: `events`, `operationsMonitoringEvents`, `fileNotifications` and `$default`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the resource group under which the Storage Container has been created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> pulumi.Output[_builtins.str]:
        """
        The subscription ID for the endpoint.

        > **Note:** When `subscription_id` isn't specified it will be set to the subscription ID of the IoT Hub resource.
        """
        return pulumi.get(self, "subscription_id")

