# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'CertifiateCertificate',
    'CertifiateCertificateAttribute',
    'CertifiateCertificatePolicy',
    'CertifiateCertificatePolicyIssuerParameters',
    'CertifiateCertificatePolicyKeyProperties',
    'CertifiateCertificatePolicyLifetimeAction',
    'CertifiateCertificatePolicyLifetimeActionAction',
    'CertifiateCertificatePolicyLifetimeActionTrigger',
    'CertifiateCertificatePolicySecretProperties',
    'CertifiateCertificatePolicyX509CertificateProperties',
    'CertifiateCertificatePolicyX509CertificatePropertiesSubjectAlternativeNames',
    'CertificateCertificate',
    'CertificateCertificateAttribute',
    'CertificateCertificatePolicy',
    'CertificateCertificatePolicyIssuerParameters',
    'CertificateCertificatePolicyKeyProperties',
    'CertificateCertificatePolicyLifetimeAction',
    'CertificateCertificatePolicyLifetimeActionAction',
    'CertificateCertificatePolicyLifetimeActionTrigger',
    'CertificateCertificatePolicySecretProperties',
    'CertificateCertificatePolicyX509CertificateProperties',
    'CertificateCertificatePolicyX509CertificatePropertiesSubjectAlternativeNames',
    'CertificateContactsContact',
    'CertificateIssuerAdmin',
    'KeyRotationPolicy',
    'KeyRotationPolicyAutomatic',
    'KeyVaultAccessPolicy',
    'KeyVaultContact',
    'KeyVaultNetworkAcls',
    'ManagedHardwareSecurityModuleNetworkAcls',
    'ManagedHardwareSecurityModuleRoleDefinitionPermission',
    'GetCertificateCertificatePolicyResult',
    'GetCertificateCertificatePolicyIssuerParameterResult',
    'GetCertificateCertificatePolicyKeyPropertyResult',
    'GetCertificateCertificatePolicyLifetimeActionResult',
    'GetCertificateCertificatePolicyLifetimeActionActionResult',
    'GetCertificateCertificatePolicyLifetimeActionTriggerResult',
    'GetCertificateCertificatePolicySecretPropertyResult',
    'GetCertificateCertificatePolicyX509CertificatePropertyResult',
    'GetCertificateCertificatePolicyX509CertificatePropertySubjectAlternativeNameResult',
    'GetCertificateIssuerAdminResult',
    'GetCertificatesCertificateResult',
    'GetKeyVaultAccessPolicyResult',
    'GetKeyVaultNetworkAclResult',
    'GetManagedHardwareSecurityModuleRoleDefinitionPermissionResult',
    'GetSecretsSecretResult',
]

@pulumi.output_type
class CertifiateCertificate(dict):
    def __init__(__self__, *,
                 contents: _builtins.str,
                 password: Optional[_builtins.str] = None):
        """
        :param _builtins.str contents: The base64-encoded certificate contents.
        :param _builtins.str password: The password associated with the certificate.
               
               > **NOTE:** A PEM certificate is already base64 encoded. To successfully import, the `contents` property should include a PEM encoded X509 certificate and a private_key in pkcs8 format. There should only be linux style `\\n` line endings and the whole block should have the PEM begin/end blocks around the certificate data and the private key data.
               
               To convert a private key to pkcs8 format with openssl use:
               ```shell
               openssl pkcs8 -topk8 -nocrypt -in private_key.pem > private_key_pk8.pem
               ```
               
               The PEM content should look something like:
               ```text
               -----BEGIN CERTIFICATE-----
               aGVsbG8KaGVsbG8KaGVsbG8KaGVsbG8KaGVsbG8KaGVsbG8KaGVsbG8KaGVsbG8K
               :
               aGVsbG8KaGVsbG8KaGVsbG8KaGVsbG8KaGVsbG8KaGVsbG8KaGVsbG8KaGVsbG8K
               -----END CERTIFICATE-----
               -----BEGIN PRIVATE KEY-----
               d29ybGQKd29ybGQKd29ybGQKd29ybGQKd29ybGQKd29ybGQKd29ybGQKd29ybGQK
               :
               d29ybGQKd29ybGQKd29ybGQKd29ybGQKd29ybGQKd29ybGQKd29ybGQKd29ybGQK
               -----END PRIVATE KEY-----
               ```
        """
        pulumi.set(__self__, "contents", contents)
        if password is not None:
            pulumi.set(__self__, "password", password)

    @_builtins.property
    @pulumi.getter
    def contents(self) -> _builtins.str:
        """
        The base64-encoded certificate contents.
        """
        return pulumi.get(self, "contents")

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[_builtins.str]:
        """
        The password associated with the certificate.

        > **NOTE:** A PEM certificate is already base64 encoded. To successfully import, the `contents` property should include a PEM encoded X509 certificate and a private_key in pkcs8 format. There should only be linux style `\\n` line endings and the whole block should have the PEM begin/end blocks around the certificate data and the private key data.

        To convert a private key to pkcs8 format with openssl use:
        ```shell
        openssl pkcs8 -topk8 -nocrypt -in private_key.pem > private_key_pk8.pem
        ```

        The PEM content should look something like:
        ```text
        -----BEGIN CERTIFICATE-----
        aGVsbG8KaGVsbG8KaGVsbG8KaGVsbG8KaGVsbG8KaGVsbG8KaGVsbG8KaGVsbG8K
        :
        aGVsbG8KaGVsbG8KaGVsbG8KaGVsbG8KaGVsbG8KaGVsbG8KaGVsbG8KaGVsbG8K
        -----END CERTIFICATE-----
        -----BEGIN PRIVATE KEY-----
        d29ybGQKd29ybGQKd29ybGQKd29ybGQKd29ybGQKd29ybGQKd29ybGQKd29ybGQK
        :
        d29ybGQKd29ybGQKd29ybGQKd29ybGQKd29ybGQKd29ybGQKd29ybGQKd29ybGQK
        -----END PRIVATE KEY-----
        ```
        """
        return pulumi.get(self, "password")


@pulumi.output_type
class CertifiateCertificateAttribute(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "notBefore":
            suggest = "not_before"
        elif key == "recoveryLevel":
            suggest = "recovery_level"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertifiateCertificateAttribute. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertifiateCertificateAttribute.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertifiateCertificateAttribute.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 created: Optional[_builtins.str] = None,
                 enabled: Optional[_builtins.bool] = None,
                 expires: Optional[_builtins.str] = None,
                 not_before: Optional[_builtins.str] = None,
                 recovery_level: Optional[_builtins.str] = None,
                 updated: Optional[_builtins.str] = None):
        """
        :param _builtins.str created: The create time of the Key Vault Certificate.
        :param _builtins.bool enabled: whether the Key Vault Certificate is enabled.
        :param _builtins.str expires: The expires time of the Key Vault Certificate.
        :param _builtins.str not_before: The not before valid time of the Key Vault Certificate.
        :param _builtins.str recovery_level: The deletion recovery level of the Key Vault Certificate.
        :param _builtins.str updated: The recent update time of the Key Vault Certificate.
        """
        if created is not None:
            pulumi.set(__self__, "created", created)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if expires is not None:
            pulumi.set(__self__, "expires", expires)
        if not_before is not None:
            pulumi.set(__self__, "not_before", not_before)
        if recovery_level is not None:
            pulumi.set(__self__, "recovery_level", recovery_level)
        if updated is not None:
            pulumi.set(__self__, "updated", updated)

    @_builtins.property
    @pulumi.getter
    def created(self) -> Optional[_builtins.str]:
        """
        The create time of the Key Vault Certificate.
        """
        return pulumi.get(self, "created")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[_builtins.bool]:
        """
        whether the Key Vault Certificate is enabled.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter
    def expires(self) -> Optional[_builtins.str]:
        """
        The expires time of the Key Vault Certificate.
        """
        return pulumi.get(self, "expires")

    @_builtins.property
    @pulumi.getter(name="notBefore")
    def not_before(self) -> Optional[_builtins.str]:
        """
        The not before valid time of the Key Vault Certificate.
        """
        return pulumi.get(self, "not_before")

    @_builtins.property
    @pulumi.getter(name="recoveryLevel")
    def recovery_level(self) -> Optional[_builtins.str]:
        """
        The deletion recovery level of the Key Vault Certificate.
        """
        return pulumi.get(self, "recovery_level")

    @_builtins.property
    @pulumi.getter
    def updated(self) -> Optional[_builtins.str]:
        """
        The recent update time of the Key Vault Certificate.
        """
        return pulumi.get(self, "updated")


@pulumi.output_type
class CertifiateCertificatePolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "issuerParameters":
            suggest = "issuer_parameters"
        elif key == "keyProperties":
            suggest = "key_properties"
        elif key == "secretProperties":
            suggest = "secret_properties"
        elif key == "lifetimeActions":
            suggest = "lifetime_actions"
        elif key == "x509CertificateProperties":
            suggest = "x509_certificate_properties"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertifiateCertificatePolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertifiateCertificatePolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertifiateCertificatePolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 issuer_parameters: 'outputs.CertifiateCertificatePolicyIssuerParameters',
                 key_properties: 'outputs.CertifiateCertificatePolicyKeyProperties',
                 secret_properties: 'outputs.CertifiateCertificatePolicySecretProperties',
                 lifetime_actions: Optional[Sequence['outputs.CertifiateCertificatePolicyLifetimeAction']] = None,
                 x509_certificate_properties: Optional['outputs.CertifiateCertificatePolicyX509CertificateProperties'] = None):
        """
        :param 'CertifiateCertificatePolicyIssuerParametersArgs' issuer_parameters: A `issuer_parameters` block as defined below.
        :param 'CertifiateCertificatePolicyKeyPropertiesArgs' key_properties: A `key_properties` block as defined below.
        :param 'CertifiateCertificatePolicySecretPropertiesArgs' secret_properties: A `secret_properties` block as defined below.
        :param Sequence['CertifiateCertificatePolicyLifetimeActionArgs'] lifetime_actions: A `lifetime_action` block as defined below.
        :param 'CertifiateCertificatePolicyX509CertificatePropertiesArgs' x509_certificate_properties: A `x509_certificate_properties` block as defined below. Required when `certificate` block is not specified.
        """
        pulumi.set(__self__, "issuer_parameters", issuer_parameters)
        pulumi.set(__self__, "key_properties", key_properties)
        pulumi.set(__self__, "secret_properties", secret_properties)
        if lifetime_actions is not None:
            pulumi.set(__self__, "lifetime_actions", lifetime_actions)
        if x509_certificate_properties is not None:
            pulumi.set(__self__, "x509_certificate_properties", x509_certificate_properties)

    @_builtins.property
    @pulumi.getter(name="issuerParameters")
    def issuer_parameters(self) -> 'outputs.CertifiateCertificatePolicyIssuerParameters':
        """
        A `issuer_parameters` block as defined below.
        """
        return pulumi.get(self, "issuer_parameters")

    @_builtins.property
    @pulumi.getter(name="keyProperties")
    def key_properties(self) -> 'outputs.CertifiateCertificatePolicyKeyProperties':
        """
        A `key_properties` block as defined below.
        """
        return pulumi.get(self, "key_properties")

    @_builtins.property
    @pulumi.getter(name="secretProperties")
    def secret_properties(self) -> 'outputs.CertifiateCertificatePolicySecretProperties':
        """
        A `secret_properties` block as defined below.
        """
        return pulumi.get(self, "secret_properties")

    @_builtins.property
    @pulumi.getter(name="lifetimeActions")
    def lifetime_actions(self) -> Optional[Sequence['outputs.CertifiateCertificatePolicyLifetimeAction']]:
        """
        A `lifetime_action` block as defined below.
        """
        return pulumi.get(self, "lifetime_actions")

    @_builtins.property
    @pulumi.getter(name="x509CertificateProperties")
    def x509_certificate_properties(self) -> Optional['outputs.CertifiateCertificatePolicyX509CertificateProperties']:
        """
        A `x509_certificate_properties` block as defined below. Required when `certificate` block is not specified.
        """
        return pulumi.get(self, "x509_certificate_properties")


@pulumi.output_type
class CertifiateCertificatePolicyIssuerParameters(dict):
    def __init__(__self__, *,
                 name: _builtins.str):
        """
        :param _builtins.str name: The name of the Certificate Issuer. Possible values include `Self` (for self-signed certificate), or `Unknown` (for a certificate issuing authority like `Let's Encrypt` and Azure direct supported ones).
        """
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the Certificate Issuer. Possible values include `Self` (for self-signed certificate), or `Unknown` (for a certificate issuing authority like `Let's Encrypt` and Azure direct supported ones).
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class CertifiateCertificatePolicyKeyProperties(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keyType":
            suggest = "key_type"
        elif key == "reuseKey":
            suggest = "reuse_key"
        elif key == "keySize":
            suggest = "key_size"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertifiateCertificatePolicyKeyProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertifiateCertificatePolicyKeyProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertifiateCertificatePolicyKeyProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 exportable: _builtins.bool,
                 key_type: _builtins.str,
                 reuse_key: _builtins.bool,
                 curve: Optional[_builtins.str] = None,
                 key_size: Optional[_builtins.int] = None):
        """
        :param _builtins.bool exportable: Is this certificate exportable?
        :param _builtins.str key_type: Specifies the type of key. Possible values are `EC`, `EC-HSM`, `RSA`, `RSA-HSM` and `oct`.
        :param _builtins.bool reuse_key: Is the key reusable?
        :param _builtins.str curve: Specifies the curve to use when creating an `EC` key. Possible values are `P-256`, `P-256K`, `P-384`, and `P-521`. This field will be required in a future release if `key_type` is `EC` or `EC-HSM`.
        :param _builtins.int key_size: The size of the key used in the certificate. Possible values include `2048`, `3072`, and `4096` for `RSA` keys, or `256`, `384`, and `521` for `EC` keys. This property is required when using RSA keys.
        """
        pulumi.set(__self__, "exportable", exportable)
        pulumi.set(__self__, "key_type", key_type)
        pulumi.set(__self__, "reuse_key", reuse_key)
        if curve is not None:
            pulumi.set(__self__, "curve", curve)
        if key_size is not None:
            pulumi.set(__self__, "key_size", key_size)

    @_builtins.property
    @pulumi.getter
    def exportable(self) -> _builtins.bool:
        """
        Is this certificate exportable?
        """
        return pulumi.get(self, "exportable")

    @_builtins.property
    @pulumi.getter(name="keyType")
    def key_type(self) -> _builtins.str:
        """
        Specifies the type of key. Possible values are `EC`, `EC-HSM`, `RSA`, `RSA-HSM` and `oct`.
        """
        return pulumi.get(self, "key_type")

    @_builtins.property
    @pulumi.getter(name="reuseKey")
    def reuse_key(self) -> _builtins.bool:
        """
        Is the key reusable?
        """
        return pulumi.get(self, "reuse_key")

    @_builtins.property
    @pulumi.getter
    def curve(self) -> Optional[_builtins.str]:
        """
        Specifies the curve to use when creating an `EC` key. Possible values are `P-256`, `P-256K`, `P-384`, and `P-521`. This field will be required in a future release if `key_type` is `EC` or `EC-HSM`.
        """
        return pulumi.get(self, "curve")

    @_builtins.property
    @pulumi.getter(name="keySize")
    def key_size(self) -> Optional[_builtins.int]:
        """
        The size of the key used in the certificate. Possible values include `2048`, `3072`, and `4096` for `RSA` keys, or `256`, `384`, and `521` for `EC` keys. This property is required when using RSA keys.
        """
        return pulumi.get(self, "key_size")


@pulumi.output_type
class CertifiateCertificatePolicyLifetimeAction(dict):
    def __init__(__self__, *,
                 action: 'outputs.CertifiateCertificatePolicyLifetimeActionAction',
                 trigger: 'outputs.CertifiateCertificatePolicyLifetimeActionTrigger'):
        """
        :param 'CertifiateCertificatePolicyLifetimeActionActionArgs' action: A `action` block as defined below.
        :param 'CertifiateCertificatePolicyLifetimeActionTriggerArgs' trigger: A `trigger` block as defined below.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "trigger", trigger)

    @_builtins.property
    @pulumi.getter
    def action(self) -> 'outputs.CertifiateCertificatePolicyLifetimeActionAction':
        """
        A `action` block as defined below.
        """
        return pulumi.get(self, "action")

    @_builtins.property
    @pulumi.getter
    def trigger(self) -> 'outputs.CertifiateCertificatePolicyLifetimeActionTrigger':
        """
        A `trigger` block as defined below.
        """
        return pulumi.get(self, "trigger")


@pulumi.output_type
class CertifiateCertificatePolicyLifetimeActionAction(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "actionType":
            suggest = "action_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertifiateCertificatePolicyLifetimeActionAction. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertifiateCertificatePolicyLifetimeActionAction.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertifiateCertificatePolicyLifetimeActionAction.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action_type: _builtins.str):
        """
        :param _builtins.str action_type: The Type of action to be performed when the lifetime trigger is triggerec. Possible values include `AutoRenew` and `EmailContacts`.
        """
        pulumi.set(__self__, "action_type", action_type)

    @_builtins.property
    @pulumi.getter(name="actionType")
    def action_type(self) -> _builtins.str:
        """
        The Type of action to be performed when the lifetime trigger is triggerec. Possible values include `AutoRenew` and `EmailContacts`.
        """
        return pulumi.get(self, "action_type")


@pulumi.output_type
class CertifiateCertificatePolicyLifetimeActionTrigger(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "daysBeforeExpiry":
            suggest = "days_before_expiry"
        elif key == "lifetimePercentage":
            suggest = "lifetime_percentage"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertifiateCertificatePolicyLifetimeActionTrigger. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertifiateCertificatePolicyLifetimeActionTrigger.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertifiateCertificatePolicyLifetimeActionTrigger.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 days_before_expiry: Optional[_builtins.int] = None,
                 lifetime_percentage: Optional[_builtins.int] = None):
        """
        :param _builtins.int days_before_expiry: The number of days before the Certificate expires that the action associated with this Trigger should run. Conflicts with `lifetime_percentage`.
        :param _builtins.int lifetime_percentage: The percentage at which during the Certificates Lifetime the action associated with this Trigger should run. Conflicts with `days_before_expiry`.
        """
        if days_before_expiry is not None:
            pulumi.set(__self__, "days_before_expiry", days_before_expiry)
        if lifetime_percentage is not None:
            pulumi.set(__self__, "lifetime_percentage", lifetime_percentage)

    @_builtins.property
    @pulumi.getter(name="daysBeforeExpiry")
    def days_before_expiry(self) -> Optional[_builtins.int]:
        """
        The number of days before the Certificate expires that the action associated with this Trigger should run. Conflicts with `lifetime_percentage`.
        """
        return pulumi.get(self, "days_before_expiry")

    @_builtins.property
    @pulumi.getter(name="lifetimePercentage")
    def lifetime_percentage(self) -> Optional[_builtins.int]:
        """
        The percentage at which during the Certificates Lifetime the action associated with this Trigger should run. Conflicts with `days_before_expiry`.
        """
        return pulumi.get(self, "lifetime_percentage")


@pulumi.output_type
class CertifiateCertificatePolicySecretProperties(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "contentType":
            suggest = "content_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertifiateCertificatePolicySecretProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertifiateCertificatePolicySecretProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertifiateCertificatePolicySecretProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 content_type: _builtins.str):
        """
        :param _builtins.str content_type: The Content-Type of the Certificate, such as `application/x-pkcs12` for a PFX or `application/x-pem-file` for a PEM.
        """
        pulumi.set(__self__, "content_type", content_type)

    @_builtins.property
    @pulumi.getter(name="contentType")
    def content_type(self) -> _builtins.str:
        """
        The Content-Type of the Certificate, such as `application/x-pkcs12` for a PFX or `application/x-pem-file` for a PEM.
        """
        return pulumi.get(self, "content_type")


@pulumi.output_type
class CertifiateCertificatePolicyX509CertificateProperties(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keyUsages":
            suggest = "key_usages"
        elif key == "validityInMonths":
            suggest = "validity_in_months"
        elif key == "extendedKeyUsages":
            suggest = "extended_key_usages"
        elif key == "subjectAlternativeNames":
            suggest = "subject_alternative_names"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertifiateCertificatePolicyX509CertificateProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertifiateCertificatePolicyX509CertificateProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertifiateCertificatePolicyX509CertificateProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key_usages: Sequence[_builtins.str],
                 subject: _builtins.str,
                 validity_in_months: _builtins.int,
                 extended_key_usages: Optional[Sequence[_builtins.str]] = None,
                 subject_alternative_names: Optional['outputs.CertifiateCertificatePolicyX509CertificatePropertiesSubjectAlternativeNames'] = None):
        """
        :param Sequence[_builtins.str] key_usages: A list of uses associated with this Key. Possible values include `cRLSign`, `dataEncipherment`, `decipherOnly`, `digitalSignature`, `encipherOnly`, `keyAgreement`, `keyCertSign`, `keyEncipherment` and `nonRepudiation` and are case-sensitive.
        :param _builtins.str subject: The Certificate's Subject.
        :param _builtins.int validity_in_months: The Certificates Validity Period in Months.
        :param Sequence[_builtins.str] extended_key_usages: A list of Extended/Enhanced Key Usages.
        :param 'CertifiateCertificatePolicyX509CertificatePropertiesSubjectAlternativeNamesArgs' subject_alternative_names: A `subject_alternative_names` block as defined below.
        """
        pulumi.set(__self__, "key_usages", key_usages)
        pulumi.set(__self__, "subject", subject)
        pulumi.set(__self__, "validity_in_months", validity_in_months)
        if extended_key_usages is not None:
            pulumi.set(__self__, "extended_key_usages", extended_key_usages)
        if subject_alternative_names is not None:
            pulumi.set(__self__, "subject_alternative_names", subject_alternative_names)

    @_builtins.property
    @pulumi.getter(name="keyUsages")
    def key_usages(self) -> Sequence[_builtins.str]:
        """
        A list of uses associated with this Key. Possible values include `cRLSign`, `dataEncipherment`, `decipherOnly`, `digitalSignature`, `encipherOnly`, `keyAgreement`, `keyCertSign`, `keyEncipherment` and `nonRepudiation` and are case-sensitive.
        """
        return pulumi.get(self, "key_usages")

    @_builtins.property
    @pulumi.getter
    def subject(self) -> _builtins.str:
        """
        The Certificate's Subject.
        """
        return pulumi.get(self, "subject")

    @_builtins.property
    @pulumi.getter(name="validityInMonths")
    def validity_in_months(self) -> _builtins.int:
        """
        The Certificates Validity Period in Months.
        """
        return pulumi.get(self, "validity_in_months")

    @_builtins.property
    @pulumi.getter(name="extendedKeyUsages")
    def extended_key_usages(self) -> Optional[Sequence[_builtins.str]]:
        """
        A list of Extended/Enhanced Key Usages.
        """
        return pulumi.get(self, "extended_key_usages")

    @_builtins.property
    @pulumi.getter(name="subjectAlternativeNames")
    def subject_alternative_names(self) -> Optional['outputs.CertifiateCertificatePolicyX509CertificatePropertiesSubjectAlternativeNames']:
        """
        A `subject_alternative_names` block as defined below.
        """
        return pulumi.get(self, "subject_alternative_names")


@pulumi.output_type
class CertifiateCertificatePolicyX509CertificatePropertiesSubjectAlternativeNames(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dnsNames":
            suggest = "dns_names"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertifiateCertificatePolicyX509CertificatePropertiesSubjectAlternativeNames. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertifiateCertificatePolicyX509CertificatePropertiesSubjectAlternativeNames.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertifiateCertificatePolicyX509CertificatePropertiesSubjectAlternativeNames.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dns_names: Optional[Sequence[_builtins.str]] = None,
                 emails: Optional[Sequence[_builtins.str]] = None,
                 upns: Optional[Sequence[_builtins.str]] = None):
        """
        :param Sequence[_builtins.str] dns_names: A list of alternative DNS names (FQDNs) identified by the Certificate.
        :param Sequence[_builtins.str] emails: A list of email addresses identified by this Certificate.
        :param Sequence[_builtins.str] upns: A list of User Principal Names identified by the Certificate.
        """
        if dns_names is not None:
            pulumi.set(__self__, "dns_names", dns_names)
        if emails is not None:
            pulumi.set(__self__, "emails", emails)
        if upns is not None:
            pulumi.set(__self__, "upns", upns)

    @_builtins.property
    @pulumi.getter(name="dnsNames")
    def dns_names(self) -> Optional[Sequence[_builtins.str]]:
        """
        A list of alternative DNS names (FQDNs) identified by the Certificate.
        """
        return pulumi.get(self, "dns_names")

    @_builtins.property
    @pulumi.getter
    def emails(self) -> Optional[Sequence[_builtins.str]]:
        """
        A list of email addresses identified by this Certificate.
        """
        return pulumi.get(self, "emails")

    @_builtins.property
    @pulumi.getter
    def upns(self) -> Optional[Sequence[_builtins.str]]:
        """
        A list of User Principal Names identified by the Certificate.
        """
        return pulumi.get(self, "upns")


@pulumi.output_type
class CertificateCertificate(dict):
    def __init__(__self__, *,
                 contents: _builtins.str,
                 password: Optional[_builtins.str] = None):
        """
        :param _builtins.str contents: The base64-encoded certificate contents.
        :param _builtins.str password: The password associated with the certificate.
               
               > **NOTE:** A PEM certificate is already base64 encoded. To successfully import, the `contents` property should include a PEM encoded X509 certificate and a private_key in pkcs8 format. There should only be linux style `\\n` line endings and the whole block should have the PEM begin/end blocks around the certificate data and the private key data.
               
               To convert a private key to pkcs8 format with openssl use:
               ```shell
               openssl pkcs8 -topk8 -nocrypt -in private_key.pem > private_key_pk8.pem
               ```
               
               The PEM content should look something like:
               ```text
               -----BEGIN CERTIFICATE-----
               aGVsbG8KaGVsbG8KaGVsbG8KaGVsbG8KaGVsbG8KaGVsbG8KaGVsbG8KaGVsbG8K
               :
               aGVsbG8KaGVsbG8KaGVsbG8KaGVsbG8KaGVsbG8KaGVsbG8KaGVsbG8KaGVsbG8K
               -----END CERTIFICATE-----
               -----BEGIN PRIVATE KEY-----
               d29ybGQKd29ybGQKd29ybGQKd29ybGQKd29ybGQKd29ybGQKd29ybGQKd29ybGQK
               :
               d29ybGQKd29ybGQKd29ybGQKd29ybGQKd29ybGQKd29ybGQKd29ybGQKd29ybGQK
               -----END PRIVATE KEY-----
               ```
        """
        pulumi.set(__self__, "contents", contents)
        if password is not None:
            pulumi.set(__self__, "password", password)

    @_builtins.property
    @pulumi.getter
    def contents(self) -> _builtins.str:
        """
        The base64-encoded certificate contents.
        """
        return pulumi.get(self, "contents")

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[_builtins.str]:
        """
        The password associated with the certificate.

        > **NOTE:** A PEM certificate is already base64 encoded. To successfully import, the `contents` property should include a PEM encoded X509 certificate and a private_key in pkcs8 format. There should only be linux style `\\n` line endings and the whole block should have the PEM begin/end blocks around the certificate data and the private key data.

        To convert a private key to pkcs8 format with openssl use:
        ```shell
        openssl pkcs8 -topk8 -nocrypt -in private_key.pem > private_key_pk8.pem
        ```

        The PEM content should look something like:
        ```text
        -----BEGIN CERTIFICATE-----
        aGVsbG8KaGVsbG8KaGVsbG8KaGVsbG8KaGVsbG8KaGVsbG8KaGVsbG8KaGVsbG8K
        :
        aGVsbG8KaGVsbG8KaGVsbG8KaGVsbG8KaGVsbG8KaGVsbG8KaGVsbG8KaGVsbG8K
        -----END CERTIFICATE-----
        -----BEGIN PRIVATE KEY-----
        d29ybGQKd29ybGQKd29ybGQKd29ybGQKd29ybGQKd29ybGQKd29ybGQKd29ybGQK
        :
        d29ybGQKd29ybGQKd29ybGQKd29ybGQKd29ybGQKd29ybGQKd29ybGQKd29ybGQK
        -----END PRIVATE KEY-----
        ```
        """
        return pulumi.get(self, "password")


@pulumi.output_type
class CertificateCertificateAttribute(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "notBefore":
            suggest = "not_before"
        elif key == "recoveryLevel":
            suggest = "recovery_level"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateCertificateAttribute. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateCertificateAttribute.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateCertificateAttribute.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 created: Optional[_builtins.str] = None,
                 enabled: Optional[_builtins.bool] = None,
                 expires: Optional[_builtins.str] = None,
                 not_before: Optional[_builtins.str] = None,
                 recovery_level: Optional[_builtins.str] = None,
                 updated: Optional[_builtins.str] = None):
        """
        :param _builtins.str created: The create time of the Key Vault Certificate.
        :param _builtins.bool enabled: whether the Key Vault Certificate is enabled.
        :param _builtins.str expires: The expires time of the Key Vault Certificate.
        :param _builtins.str not_before: The not before valid time of the Key Vault Certificate.
        :param _builtins.str recovery_level: The deletion recovery level of the Key Vault Certificate.
        :param _builtins.str updated: The recent update time of the Key Vault Certificate.
        """
        if created is not None:
            pulumi.set(__self__, "created", created)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if expires is not None:
            pulumi.set(__self__, "expires", expires)
        if not_before is not None:
            pulumi.set(__self__, "not_before", not_before)
        if recovery_level is not None:
            pulumi.set(__self__, "recovery_level", recovery_level)
        if updated is not None:
            pulumi.set(__self__, "updated", updated)

    @_builtins.property
    @pulumi.getter
    def created(self) -> Optional[_builtins.str]:
        """
        The create time of the Key Vault Certificate.
        """
        return pulumi.get(self, "created")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[_builtins.bool]:
        """
        whether the Key Vault Certificate is enabled.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter
    def expires(self) -> Optional[_builtins.str]:
        """
        The expires time of the Key Vault Certificate.
        """
        return pulumi.get(self, "expires")

    @_builtins.property
    @pulumi.getter(name="notBefore")
    def not_before(self) -> Optional[_builtins.str]:
        """
        The not before valid time of the Key Vault Certificate.
        """
        return pulumi.get(self, "not_before")

    @_builtins.property
    @pulumi.getter(name="recoveryLevel")
    def recovery_level(self) -> Optional[_builtins.str]:
        """
        The deletion recovery level of the Key Vault Certificate.
        """
        return pulumi.get(self, "recovery_level")

    @_builtins.property
    @pulumi.getter
    def updated(self) -> Optional[_builtins.str]:
        """
        The recent update time of the Key Vault Certificate.
        """
        return pulumi.get(self, "updated")


@pulumi.output_type
class CertificateCertificatePolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "issuerParameters":
            suggest = "issuer_parameters"
        elif key == "keyProperties":
            suggest = "key_properties"
        elif key == "secretProperties":
            suggest = "secret_properties"
        elif key == "lifetimeActions":
            suggest = "lifetime_actions"
        elif key == "x509CertificateProperties":
            suggest = "x509_certificate_properties"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateCertificatePolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateCertificatePolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateCertificatePolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 issuer_parameters: 'outputs.CertificateCertificatePolicyIssuerParameters',
                 key_properties: 'outputs.CertificateCertificatePolicyKeyProperties',
                 secret_properties: 'outputs.CertificateCertificatePolicySecretProperties',
                 lifetime_actions: Optional[Sequence['outputs.CertificateCertificatePolicyLifetimeAction']] = None,
                 x509_certificate_properties: Optional['outputs.CertificateCertificatePolicyX509CertificateProperties'] = None):
        """
        :param 'CertificateCertificatePolicyIssuerParametersArgs' issuer_parameters: A `issuer_parameters` block as defined below.
        :param 'CertificateCertificatePolicyKeyPropertiesArgs' key_properties: A `key_properties` block as defined below.
        :param 'CertificateCertificatePolicySecretPropertiesArgs' secret_properties: A `secret_properties` block as defined below.
        :param Sequence['CertificateCertificatePolicyLifetimeActionArgs'] lifetime_actions: A `lifetime_action` block as defined below.
        :param 'CertificateCertificatePolicyX509CertificatePropertiesArgs' x509_certificate_properties: A `x509_certificate_properties` block as defined below. Required when `certificate` block is not specified.
        """
        pulumi.set(__self__, "issuer_parameters", issuer_parameters)
        pulumi.set(__self__, "key_properties", key_properties)
        pulumi.set(__self__, "secret_properties", secret_properties)
        if lifetime_actions is not None:
            pulumi.set(__self__, "lifetime_actions", lifetime_actions)
        if x509_certificate_properties is not None:
            pulumi.set(__self__, "x509_certificate_properties", x509_certificate_properties)

    @_builtins.property
    @pulumi.getter(name="issuerParameters")
    def issuer_parameters(self) -> 'outputs.CertificateCertificatePolicyIssuerParameters':
        """
        A `issuer_parameters` block as defined below.
        """
        return pulumi.get(self, "issuer_parameters")

    @_builtins.property
    @pulumi.getter(name="keyProperties")
    def key_properties(self) -> 'outputs.CertificateCertificatePolicyKeyProperties':
        """
        A `key_properties` block as defined below.
        """
        return pulumi.get(self, "key_properties")

    @_builtins.property
    @pulumi.getter(name="secretProperties")
    def secret_properties(self) -> 'outputs.CertificateCertificatePolicySecretProperties':
        """
        A `secret_properties` block as defined below.
        """
        return pulumi.get(self, "secret_properties")

    @_builtins.property
    @pulumi.getter(name="lifetimeActions")
    def lifetime_actions(self) -> Optional[Sequence['outputs.CertificateCertificatePolicyLifetimeAction']]:
        """
        A `lifetime_action` block as defined below.
        """
        return pulumi.get(self, "lifetime_actions")

    @_builtins.property
    @pulumi.getter(name="x509CertificateProperties")
    def x509_certificate_properties(self) -> Optional['outputs.CertificateCertificatePolicyX509CertificateProperties']:
        """
        A `x509_certificate_properties` block as defined below. Required when `certificate` block is not specified.
        """
        return pulumi.get(self, "x509_certificate_properties")


@pulumi.output_type
class CertificateCertificatePolicyIssuerParameters(dict):
    def __init__(__self__, *,
                 name: _builtins.str):
        """
        :param _builtins.str name: The name of the Certificate Issuer. Possible values include `Self` (for self-signed certificate), or `Unknown` (for a certificate issuing authority like `Let's Encrypt` and Azure direct supported ones).
        """
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the Certificate Issuer. Possible values include `Self` (for self-signed certificate), or `Unknown` (for a certificate issuing authority like `Let's Encrypt` and Azure direct supported ones).
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class CertificateCertificatePolicyKeyProperties(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keyType":
            suggest = "key_type"
        elif key == "reuseKey":
            suggest = "reuse_key"
        elif key == "keySize":
            suggest = "key_size"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateCertificatePolicyKeyProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateCertificatePolicyKeyProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateCertificatePolicyKeyProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 exportable: _builtins.bool,
                 key_type: _builtins.str,
                 reuse_key: _builtins.bool,
                 curve: Optional[_builtins.str] = None,
                 key_size: Optional[_builtins.int] = None):
        """
        :param _builtins.bool exportable: Is this certificate exportable?
        :param _builtins.str key_type: Specifies the type of key. Possible values are `EC`, `EC-HSM`, `RSA`, `RSA-HSM` and `oct`.
        :param _builtins.bool reuse_key: Is the key reusable?
        :param _builtins.str curve: Specifies the curve to use when creating an `EC` key. Possible values are `P-256`, `P-256K`, `P-384`, and `P-521`. This field will be required in a future release if `key_type` is `EC` or `EC-HSM`.
        :param _builtins.int key_size: The size of the key used in the certificate. Possible values include `2048`, `3072`, and `4096` for `RSA` keys, or `256`, `384`, and `521` for `EC` keys. This property is required when using RSA keys.
        """
        pulumi.set(__self__, "exportable", exportable)
        pulumi.set(__self__, "key_type", key_type)
        pulumi.set(__self__, "reuse_key", reuse_key)
        if curve is not None:
            pulumi.set(__self__, "curve", curve)
        if key_size is not None:
            pulumi.set(__self__, "key_size", key_size)

    @_builtins.property
    @pulumi.getter
    def exportable(self) -> _builtins.bool:
        """
        Is this certificate exportable?
        """
        return pulumi.get(self, "exportable")

    @_builtins.property
    @pulumi.getter(name="keyType")
    def key_type(self) -> _builtins.str:
        """
        Specifies the type of key. Possible values are `EC`, `EC-HSM`, `RSA`, `RSA-HSM` and `oct`.
        """
        return pulumi.get(self, "key_type")

    @_builtins.property
    @pulumi.getter(name="reuseKey")
    def reuse_key(self) -> _builtins.bool:
        """
        Is the key reusable?
        """
        return pulumi.get(self, "reuse_key")

    @_builtins.property
    @pulumi.getter
    def curve(self) -> Optional[_builtins.str]:
        """
        Specifies the curve to use when creating an `EC` key. Possible values are `P-256`, `P-256K`, `P-384`, and `P-521`. This field will be required in a future release if `key_type` is `EC` or `EC-HSM`.
        """
        return pulumi.get(self, "curve")

    @_builtins.property
    @pulumi.getter(name="keySize")
    def key_size(self) -> Optional[_builtins.int]:
        """
        The size of the key used in the certificate. Possible values include `2048`, `3072`, and `4096` for `RSA` keys, or `256`, `384`, and `521` for `EC` keys. This property is required when using RSA keys.
        """
        return pulumi.get(self, "key_size")


@pulumi.output_type
class CertificateCertificatePolicyLifetimeAction(dict):
    def __init__(__self__, *,
                 action: 'outputs.CertificateCertificatePolicyLifetimeActionAction',
                 trigger: 'outputs.CertificateCertificatePolicyLifetimeActionTrigger'):
        """
        :param 'CertificateCertificatePolicyLifetimeActionActionArgs' action: A `action` block as defined below.
        :param 'CertificateCertificatePolicyLifetimeActionTriggerArgs' trigger: A `trigger` block as defined below.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "trigger", trigger)

    @_builtins.property
    @pulumi.getter
    def action(self) -> 'outputs.CertificateCertificatePolicyLifetimeActionAction':
        """
        A `action` block as defined below.
        """
        return pulumi.get(self, "action")

    @_builtins.property
    @pulumi.getter
    def trigger(self) -> 'outputs.CertificateCertificatePolicyLifetimeActionTrigger':
        """
        A `trigger` block as defined below.
        """
        return pulumi.get(self, "trigger")


@pulumi.output_type
class CertificateCertificatePolicyLifetimeActionAction(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "actionType":
            suggest = "action_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateCertificatePolicyLifetimeActionAction. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateCertificatePolicyLifetimeActionAction.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateCertificatePolicyLifetimeActionAction.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action_type: _builtins.str):
        """
        :param _builtins.str action_type: The Type of action to be performed when the lifetime trigger is triggerec. Possible values include `AutoRenew` and `EmailContacts`.
        """
        pulumi.set(__self__, "action_type", action_type)

    @_builtins.property
    @pulumi.getter(name="actionType")
    def action_type(self) -> _builtins.str:
        """
        The Type of action to be performed when the lifetime trigger is triggerec. Possible values include `AutoRenew` and `EmailContacts`.
        """
        return pulumi.get(self, "action_type")


@pulumi.output_type
class CertificateCertificatePolicyLifetimeActionTrigger(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "daysBeforeExpiry":
            suggest = "days_before_expiry"
        elif key == "lifetimePercentage":
            suggest = "lifetime_percentage"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateCertificatePolicyLifetimeActionTrigger. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateCertificatePolicyLifetimeActionTrigger.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateCertificatePolicyLifetimeActionTrigger.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 days_before_expiry: Optional[_builtins.int] = None,
                 lifetime_percentage: Optional[_builtins.int] = None):
        """
        :param _builtins.int days_before_expiry: The number of days before the Certificate expires that the action associated with this Trigger should run. Conflicts with `lifetime_percentage`.
        :param _builtins.int lifetime_percentage: The percentage at which during the Certificates Lifetime the action associated with this Trigger should run. Conflicts with `days_before_expiry`.
        """
        if days_before_expiry is not None:
            pulumi.set(__self__, "days_before_expiry", days_before_expiry)
        if lifetime_percentage is not None:
            pulumi.set(__self__, "lifetime_percentage", lifetime_percentage)

    @_builtins.property
    @pulumi.getter(name="daysBeforeExpiry")
    def days_before_expiry(self) -> Optional[_builtins.int]:
        """
        The number of days before the Certificate expires that the action associated with this Trigger should run. Conflicts with `lifetime_percentage`.
        """
        return pulumi.get(self, "days_before_expiry")

    @_builtins.property
    @pulumi.getter(name="lifetimePercentage")
    def lifetime_percentage(self) -> Optional[_builtins.int]:
        """
        The percentage at which during the Certificates Lifetime the action associated with this Trigger should run. Conflicts with `days_before_expiry`.
        """
        return pulumi.get(self, "lifetime_percentage")


@pulumi.output_type
class CertificateCertificatePolicySecretProperties(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "contentType":
            suggest = "content_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateCertificatePolicySecretProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateCertificatePolicySecretProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateCertificatePolicySecretProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 content_type: _builtins.str):
        """
        :param _builtins.str content_type: The Content-Type of the Certificate, such as `application/x-pkcs12` for a PFX or `application/x-pem-file` for a PEM.
        """
        pulumi.set(__self__, "content_type", content_type)

    @_builtins.property
    @pulumi.getter(name="contentType")
    def content_type(self) -> _builtins.str:
        """
        The Content-Type of the Certificate, such as `application/x-pkcs12` for a PFX or `application/x-pem-file` for a PEM.
        """
        return pulumi.get(self, "content_type")


@pulumi.output_type
class CertificateCertificatePolicyX509CertificateProperties(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keyUsages":
            suggest = "key_usages"
        elif key == "validityInMonths":
            suggest = "validity_in_months"
        elif key == "extendedKeyUsages":
            suggest = "extended_key_usages"
        elif key == "subjectAlternativeNames":
            suggest = "subject_alternative_names"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateCertificatePolicyX509CertificateProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateCertificatePolicyX509CertificateProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateCertificatePolicyX509CertificateProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key_usages: Sequence[_builtins.str],
                 subject: _builtins.str,
                 validity_in_months: _builtins.int,
                 extended_key_usages: Optional[Sequence[_builtins.str]] = None,
                 subject_alternative_names: Optional['outputs.CertificateCertificatePolicyX509CertificatePropertiesSubjectAlternativeNames'] = None):
        """
        :param Sequence[_builtins.str] key_usages: A list of uses associated with this Key. Possible values include `cRLSign`, `dataEncipherment`, `decipherOnly`, `digitalSignature`, `encipherOnly`, `keyAgreement`, `keyCertSign`, `keyEncipherment` and `nonRepudiation` and are case-sensitive.
        :param _builtins.str subject: The Certificate's Subject.
        :param _builtins.int validity_in_months: The Certificates Validity Period in Months.
        :param Sequence[_builtins.str] extended_key_usages: A list of Extended/Enhanced Key Usages.
        :param 'CertificateCertificatePolicyX509CertificatePropertiesSubjectAlternativeNamesArgs' subject_alternative_names: A `subject_alternative_names` block as defined below.
        """
        pulumi.set(__self__, "key_usages", key_usages)
        pulumi.set(__self__, "subject", subject)
        pulumi.set(__self__, "validity_in_months", validity_in_months)
        if extended_key_usages is not None:
            pulumi.set(__self__, "extended_key_usages", extended_key_usages)
        if subject_alternative_names is not None:
            pulumi.set(__self__, "subject_alternative_names", subject_alternative_names)

    @_builtins.property
    @pulumi.getter(name="keyUsages")
    def key_usages(self) -> Sequence[_builtins.str]:
        """
        A list of uses associated with this Key. Possible values include `cRLSign`, `dataEncipherment`, `decipherOnly`, `digitalSignature`, `encipherOnly`, `keyAgreement`, `keyCertSign`, `keyEncipherment` and `nonRepudiation` and are case-sensitive.
        """
        return pulumi.get(self, "key_usages")

    @_builtins.property
    @pulumi.getter
    def subject(self) -> _builtins.str:
        """
        The Certificate's Subject.
        """
        return pulumi.get(self, "subject")

    @_builtins.property
    @pulumi.getter(name="validityInMonths")
    def validity_in_months(self) -> _builtins.int:
        """
        The Certificates Validity Period in Months.
        """
        return pulumi.get(self, "validity_in_months")

    @_builtins.property
    @pulumi.getter(name="extendedKeyUsages")
    def extended_key_usages(self) -> Optional[Sequence[_builtins.str]]:
        """
        A list of Extended/Enhanced Key Usages.
        """
        return pulumi.get(self, "extended_key_usages")

    @_builtins.property
    @pulumi.getter(name="subjectAlternativeNames")
    def subject_alternative_names(self) -> Optional['outputs.CertificateCertificatePolicyX509CertificatePropertiesSubjectAlternativeNames']:
        """
        A `subject_alternative_names` block as defined below.
        """
        return pulumi.get(self, "subject_alternative_names")


@pulumi.output_type
class CertificateCertificatePolicyX509CertificatePropertiesSubjectAlternativeNames(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dnsNames":
            suggest = "dns_names"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateCertificatePolicyX509CertificatePropertiesSubjectAlternativeNames. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateCertificatePolicyX509CertificatePropertiesSubjectAlternativeNames.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateCertificatePolicyX509CertificatePropertiesSubjectAlternativeNames.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dns_names: Optional[Sequence[_builtins.str]] = None,
                 emails: Optional[Sequence[_builtins.str]] = None,
                 upns: Optional[Sequence[_builtins.str]] = None):
        """
        :param Sequence[_builtins.str] dns_names: A list of alternative DNS names (FQDNs) identified by the Certificate.
        :param Sequence[_builtins.str] emails: A list of email addresses identified by this Certificate.
        :param Sequence[_builtins.str] upns: A list of User Principal Names identified by the Certificate.
        """
        if dns_names is not None:
            pulumi.set(__self__, "dns_names", dns_names)
        if emails is not None:
            pulumi.set(__self__, "emails", emails)
        if upns is not None:
            pulumi.set(__self__, "upns", upns)

    @_builtins.property
    @pulumi.getter(name="dnsNames")
    def dns_names(self) -> Optional[Sequence[_builtins.str]]:
        """
        A list of alternative DNS names (FQDNs) identified by the Certificate.
        """
        return pulumi.get(self, "dns_names")

    @_builtins.property
    @pulumi.getter
    def emails(self) -> Optional[Sequence[_builtins.str]]:
        """
        A list of email addresses identified by this Certificate.
        """
        return pulumi.get(self, "emails")

    @_builtins.property
    @pulumi.getter
    def upns(self) -> Optional[Sequence[_builtins.str]]:
        """
        A list of User Principal Names identified by the Certificate.
        """
        return pulumi.get(self, "upns")


@pulumi.output_type
class CertificateContactsContact(dict):
    def __init__(__self__, *,
                 email: _builtins.str,
                 name: Optional[_builtins.str] = None,
                 phone: Optional[_builtins.str] = None):
        """
        :param _builtins.str email: E-mail address of the contact.
        :param _builtins.str name: Name of the contact.
        :param _builtins.str phone: Phone number of the contact.
        """
        pulumi.set(__self__, "email", email)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if phone is not None:
            pulumi.set(__self__, "phone", phone)

    @_builtins.property
    @pulumi.getter
    def email(self) -> _builtins.str:
        """
        E-mail address of the contact.
        """
        return pulumi.get(self, "email")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        Name of the contact.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def phone(self) -> Optional[_builtins.str]:
        """
        Phone number of the contact.
        """
        return pulumi.get(self, "phone")


@pulumi.output_type
class CertificateIssuerAdmin(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "emailAddress":
            suggest = "email_address"
        elif key == "firstName":
            suggest = "first_name"
        elif key == "lastName":
            suggest = "last_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateIssuerAdmin. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateIssuerAdmin.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateIssuerAdmin.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 email_address: _builtins.str,
                 first_name: Optional[_builtins.str] = None,
                 last_name: Optional[_builtins.str] = None,
                 phone: Optional[_builtins.str] = None):
        """
        :param _builtins.str email_address: E-mail address of the admin.
        :param _builtins.str first_name: First name of the admin.
        :param _builtins.str last_name: Last name of the admin.
        :param _builtins.str phone: Phone number of the admin.
        """
        pulumi.set(__self__, "email_address", email_address)
        if first_name is not None:
            pulumi.set(__self__, "first_name", first_name)
        if last_name is not None:
            pulumi.set(__self__, "last_name", last_name)
        if phone is not None:
            pulumi.set(__self__, "phone", phone)

    @_builtins.property
    @pulumi.getter(name="emailAddress")
    def email_address(self) -> _builtins.str:
        """
        E-mail address of the admin.
        """
        return pulumi.get(self, "email_address")

    @_builtins.property
    @pulumi.getter(name="firstName")
    def first_name(self) -> Optional[_builtins.str]:
        """
        First name of the admin.
        """
        return pulumi.get(self, "first_name")

    @_builtins.property
    @pulumi.getter(name="lastName")
    def last_name(self) -> Optional[_builtins.str]:
        """
        Last name of the admin.
        """
        return pulumi.get(self, "last_name")

    @_builtins.property
    @pulumi.getter
    def phone(self) -> Optional[_builtins.str]:
        """
        Phone number of the admin.
        """
        return pulumi.get(self, "phone")


@pulumi.output_type
class KeyRotationPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "expireAfter":
            suggest = "expire_after"
        elif key == "notifyBeforeExpiry":
            suggest = "notify_before_expiry"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KeyRotationPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KeyRotationPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KeyRotationPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 automatic: Optional['outputs.KeyRotationPolicyAutomatic'] = None,
                 expire_after: Optional[_builtins.str] = None,
                 notify_before_expiry: Optional[_builtins.str] = None):
        """
        :param 'KeyRotationPolicyAutomaticArgs' automatic: An `automatic` block as defined below.
        :param _builtins.str expire_after: Expire a Key Vault Key after given duration as an [ISO 8601 duration](https://en.wikipedia.org/wiki/ISO_8601#Durations).
        :param _builtins.str notify_before_expiry: Notify at a given duration before expiry as an [ISO 8601 duration](https://en.wikipedia.org/wiki/ISO_8601#Durations).
        """
        if automatic is not None:
            pulumi.set(__self__, "automatic", automatic)
        if expire_after is not None:
            pulumi.set(__self__, "expire_after", expire_after)
        if notify_before_expiry is not None:
            pulumi.set(__self__, "notify_before_expiry", notify_before_expiry)

    @_builtins.property
    @pulumi.getter
    def automatic(self) -> Optional['outputs.KeyRotationPolicyAutomatic']:
        """
        An `automatic` block as defined below.
        """
        return pulumi.get(self, "automatic")

    @_builtins.property
    @pulumi.getter(name="expireAfter")
    def expire_after(self) -> Optional[_builtins.str]:
        """
        Expire a Key Vault Key after given duration as an [ISO 8601 duration](https://en.wikipedia.org/wiki/ISO_8601#Durations).
        """
        return pulumi.get(self, "expire_after")

    @_builtins.property
    @pulumi.getter(name="notifyBeforeExpiry")
    def notify_before_expiry(self) -> Optional[_builtins.str]:
        """
        Notify at a given duration before expiry as an [ISO 8601 duration](https://en.wikipedia.org/wiki/ISO_8601#Durations).
        """
        return pulumi.get(self, "notify_before_expiry")


@pulumi.output_type
class KeyRotationPolicyAutomatic(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "timeAfterCreation":
            suggest = "time_after_creation"
        elif key == "timeBeforeExpiry":
            suggest = "time_before_expiry"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KeyRotationPolicyAutomatic. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KeyRotationPolicyAutomatic.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KeyRotationPolicyAutomatic.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 time_after_creation: Optional[_builtins.str] = None,
                 time_before_expiry: Optional[_builtins.str] = None):
        """
        :param _builtins.str time_after_creation: Rotate automatically at a duration after create as an [ISO 8601 duration](https://en.wikipedia.org/wiki/ISO_8601#Durations).
        :param _builtins.str time_before_expiry: Rotate automatically at a duration before expiry as an [ISO 8601 duration](https://en.wikipedia.org/wiki/ISO_8601#Durations).
        """
        if time_after_creation is not None:
            pulumi.set(__self__, "time_after_creation", time_after_creation)
        if time_before_expiry is not None:
            pulumi.set(__self__, "time_before_expiry", time_before_expiry)

    @_builtins.property
    @pulumi.getter(name="timeAfterCreation")
    def time_after_creation(self) -> Optional[_builtins.str]:
        """
        Rotate automatically at a duration after create as an [ISO 8601 duration](https://en.wikipedia.org/wiki/ISO_8601#Durations).
        """
        return pulumi.get(self, "time_after_creation")

    @_builtins.property
    @pulumi.getter(name="timeBeforeExpiry")
    def time_before_expiry(self) -> Optional[_builtins.str]:
        """
        Rotate automatically at a duration before expiry as an [ISO 8601 duration](https://en.wikipedia.org/wiki/ISO_8601#Durations).
        """
        return pulumi.get(self, "time_before_expiry")


@pulumi.output_type
class KeyVaultAccessPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "objectId":
            suggest = "object_id"
        elif key == "tenantId":
            suggest = "tenant_id"
        elif key == "applicationId":
            suggest = "application_id"
        elif key == "certificatePermissions":
            suggest = "certificate_permissions"
        elif key == "keyPermissions":
            suggest = "key_permissions"
        elif key == "secretPermissions":
            suggest = "secret_permissions"
        elif key == "storagePermissions":
            suggest = "storage_permissions"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KeyVaultAccessPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KeyVaultAccessPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KeyVaultAccessPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 object_id: _builtins.str,
                 tenant_id: _builtins.str,
                 application_id: Optional[_builtins.str] = None,
                 certificate_permissions: Optional[Sequence[_builtins.str]] = None,
                 key_permissions: Optional[Sequence[_builtins.str]] = None,
                 secret_permissions: Optional[Sequence[_builtins.str]] = None,
                 storage_permissions: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.str object_id: The object ID of a user, service principal or security group in the Azure Active Directory tenant for the vault. The object ID must be unique for the list of access policies.
        :param _builtins.str tenant_id: The Azure Active Directory tenant ID that should be used for authenticating requests to the key vault. Must match the `tenant_id` used above.
        :param _builtins.str application_id: The object ID of an Application in Azure Active Directory.
        :param Sequence[_builtins.str] certificate_permissions: List of certificate permissions, must be one or more from the following: `Backup`, `Create`, `Delete`, `DeleteIssuers`, `Get`, `GetIssuers`, `Import`, `List`, `ListIssuers`, `ManageContacts`, `ManageIssuers`, `Purge`, `Recover`, `Restore`, `SetIssuers` and `Update`.
        :param Sequence[_builtins.str] key_permissions: List of key permissions. Possible values are `Backup`, `Create`, `Decrypt`, `Delete`, `Encrypt`, `Get`, `Import`, `List`, `Purge`, `Recover`, `Restore`, `Sign`, `UnwrapKey`, `Update`, `Verify`, `WrapKey`, `Release`, `Rotate`, `GetRotationPolicy` and `SetRotationPolicy`.
        :param Sequence[_builtins.str] secret_permissions: List of secret permissions, must be one or more from the following: `Backup`, `Delete`, `Get`, `List`, `Purge`, `Recover`, `Restore` and `Set`.
        :param Sequence[_builtins.str] storage_permissions: List of storage permissions, must be one or more from the following: `Backup`, `Delete`, `DeleteSAS`, `Get`, `GetSAS`, `List`, `ListSAS`, `Purge`, `Recover`, `RegenerateKey`, `Restore`, `Set`, `SetSAS` and `Update`.
        """
        pulumi.set(__self__, "object_id", object_id)
        pulumi.set(__self__, "tenant_id", tenant_id)
        if application_id is not None:
            pulumi.set(__self__, "application_id", application_id)
        if certificate_permissions is not None:
            pulumi.set(__self__, "certificate_permissions", certificate_permissions)
        if key_permissions is not None:
            pulumi.set(__self__, "key_permissions", key_permissions)
        if secret_permissions is not None:
            pulumi.set(__self__, "secret_permissions", secret_permissions)
        if storage_permissions is not None:
            pulumi.set(__self__, "storage_permissions", storage_permissions)

    @_builtins.property
    @pulumi.getter(name="objectId")
    def object_id(self) -> _builtins.str:
        """
        The object ID of a user, service principal or security group in the Azure Active Directory tenant for the vault. The object ID must be unique for the list of access policies.
        """
        return pulumi.get(self, "object_id")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> _builtins.str:
        """
        The Azure Active Directory tenant ID that should be used for authenticating requests to the key vault. Must match the `tenant_id` used above.
        """
        return pulumi.get(self, "tenant_id")

    @_builtins.property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> Optional[_builtins.str]:
        """
        The object ID of an Application in Azure Active Directory.
        """
        return pulumi.get(self, "application_id")

    @_builtins.property
    @pulumi.getter(name="certificatePermissions")
    def certificate_permissions(self) -> Optional[Sequence[_builtins.str]]:
        """
        List of certificate permissions, must be one or more from the following: `Backup`, `Create`, `Delete`, `DeleteIssuers`, `Get`, `GetIssuers`, `Import`, `List`, `ListIssuers`, `ManageContacts`, `ManageIssuers`, `Purge`, `Recover`, `Restore`, `SetIssuers` and `Update`.
        """
        return pulumi.get(self, "certificate_permissions")

    @_builtins.property
    @pulumi.getter(name="keyPermissions")
    def key_permissions(self) -> Optional[Sequence[_builtins.str]]:
        """
        List of key permissions. Possible values are `Backup`, `Create`, `Decrypt`, `Delete`, `Encrypt`, `Get`, `Import`, `List`, `Purge`, `Recover`, `Restore`, `Sign`, `UnwrapKey`, `Update`, `Verify`, `WrapKey`, `Release`, `Rotate`, `GetRotationPolicy` and `SetRotationPolicy`.
        """
        return pulumi.get(self, "key_permissions")

    @_builtins.property
    @pulumi.getter(name="secretPermissions")
    def secret_permissions(self) -> Optional[Sequence[_builtins.str]]:
        """
        List of secret permissions, must be one or more from the following: `Backup`, `Delete`, `Get`, `List`, `Purge`, `Recover`, `Restore` and `Set`.
        """
        return pulumi.get(self, "secret_permissions")

    @_builtins.property
    @pulumi.getter(name="storagePermissions")
    def storage_permissions(self) -> Optional[Sequence[_builtins.str]]:
        """
        List of storage permissions, must be one or more from the following: `Backup`, `Delete`, `DeleteSAS`, `Get`, `GetSAS`, `List`, `ListSAS`, `Purge`, `Recover`, `RegenerateKey`, `Restore`, `Set`, `SetSAS` and `Update`.
        """
        return pulumi.get(self, "storage_permissions")


@pulumi.output_type
class KeyVaultContact(dict):
    def __init__(__self__, *,
                 email: _builtins.str,
                 name: Optional[_builtins.str] = None,
                 phone: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: Specifies the name of the Key Vault. Changing this forces a new resource to be created. The name must be globally unique. If the vault is in a recoverable state then the vault will need to be purged before reusing the name.
        """
        pulumi.set(__self__, "email", email)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if phone is not None:
            pulumi.set(__self__, "phone", phone)

    @_builtins.property
    @pulumi.getter
    def email(self) -> _builtins.str:
        return pulumi.get(self, "email")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        Specifies the name of the Key Vault. Changing this forces a new resource to be created. The name must be globally unique. If the vault is in a recoverable state then the vault will need to be purged before reusing the name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def phone(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "phone")


@pulumi.output_type
class KeyVaultNetworkAcls(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultAction":
            suggest = "default_action"
        elif key == "ipRules":
            suggest = "ip_rules"
        elif key == "virtualNetworkSubnetIds":
            suggest = "virtual_network_subnet_ids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KeyVaultNetworkAcls. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KeyVaultNetworkAcls.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KeyVaultNetworkAcls.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bypass: _builtins.str,
                 default_action: _builtins.str,
                 ip_rules: Optional[Sequence[_builtins.str]] = None,
                 virtual_network_subnet_ids: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.str bypass: Specifies which traffic can bypass the network rules. Possible values are `AzureServices` and `None`.
        :param _builtins.str default_action: The Default Action to use when no rules match from `ip_rules` / `virtual_network_subnet_ids`. Possible values are `Allow` and `Deny`.
        :param Sequence[_builtins.str] ip_rules: One or more IP Addresses, or CIDR Blocks which should be able to access the Key Vault.
        :param Sequence[_builtins.str] virtual_network_subnet_ids: One or more Subnet IDs which should be able to access this Key Vault.
        """
        pulumi.set(__self__, "bypass", bypass)
        pulumi.set(__self__, "default_action", default_action)
        if ip_rules is not None:
            pulumi.set(__self__, "ip_rules", ip_rules)
        if virtual_network_subnet_ids is not None:
            pulumi.set(__self__, "virtual_network_subnet_ids", virtual_network_subnet_ids)

    @_builtins.property
    @pulumi.getter
    def bypass(self) -> _builtins.str:
        """
        Specifies which traffic can bypass the network rules. Possible values are `AzureServices` and `None`.
        """
        return pulumi.get(self, "bypass")

    @_builtins.property
    @pulumi.getter(name="defaultAction")
    def default_action(self) -> _builtins.str:
        """
        The Default Action to use when no rules match from `ip_rules` / `virtual_network_subnet_ids`. Possible values are `Allow` and `Deny`.
        """
        return pulumi.get(self, "default_action")

    @_builtins.property
    @pulumi.getter(name="ipRules")
    def ip_rules(self) -> Optional[Sequence[_builtins.str]]:
        """
        One or more IP Addresses, or CIDR Blocks which should be able to access the Key Vault.
        """
        return pulumi.get(self, "ip_rules")

    @_builtins.property
    @pulumi.getter(name="virtualNetworkSubnetIds")
    def virtual_network_subnet_ids(self) -> Optional[Sequence[_builtins.str]]:
        """
        One or more Subnet IDs which should be able to access this Key Vault.
        """
        return pulumi.get(self, "virtual_network_subnet_ids")


@pulumi.output_type
class ManagedHardwareSecurityModuleNetworkAcls(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultAction":
            suggest = "default_action"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagedHardwareSecurityModuleNetworkAcls. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagedHardwareSecurityModuleNetworkAcls.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagedHardwareSecurityModuleNetworkAcls.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bypass: _builtins.str,
                 default_action: _builtins.str):
        """
        :param _builtins.str bypass: Specifies which traffic can bypass the network rules. Possible values are `AzureServices` and `None`.
        :param _builtins.str default_action: The Default Action to use. Possible values are `Allow` and `Deny`.
        """
        pulumi.set(__self__, "bypass", bypass)
        pulumi.set(__self__, "default_action", default_action)

    @_builtins.property
    @pulumi.getter
    def bypass(self) -> _builtins.str:
        """
        Specifies which traffic can bypass the network rules. Possible values are `AzureServices` and `None`.
        """
        return pulumi.get(self, "bypass")

    @_builtins.property
    @pulumi.getter(name="defaultAction")
    def default_action(self) -> _builtins.str:
        """
        The Default Action to use. Possible values are `Allow` and `Deny`.
        """
        return pulumi.get(self, "default_action")


@pulumi.output_type
class ManagedHardwareSecurityModuleRoleDefinitionPermission(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataActions":
            suggest = "data_actions"
        elif key == "notActions":
            suggest = "not_actions"
        elif key == "notDataActions":
            suggest = "not_data_actions"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagedHardwareSecurityModuleRoleDefinitionPermission. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagedHardwareSecurityModuleRoleDefinitionPermission.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagedHardwareSecurityModuleRoleDefinitionPermission.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 actions: Optional[Sequence[_builtins.str]] = None,
                 data_actions: Optional[Sequence[_builtins.str]] = None,
                 not_actions: Optional[Sequence[_builtins.str]] = None,
                 not_data_actions: Optional[Sequence[_builtins.str]] = None):
        """
        :param Sequence[_builtins.str] actions: One or more Allowed Actions, such as `*`, `Microsoft.Resources/subscriptions/resourceGroups/read`. See ['Azure Resource Manager resource provider operations'](https://docs.microsoft.com/azure/role-based-access-control/resource-provider-operations) for details.
        :param Sequence[_builtins.str] data_actions: Specifies a list of data action permission to grant. Possible values are `Microsoft.KeyVault/managedHsm/keys/read/action`, `Microsoft.KeyVault/managedHsm/keys/write/action`, `Microsoft.KeyVault/managedHsm/keys/deletedKeys/read/action`, `Microsoft.KeyVault/managedHsm/keys/deletedKeys/recover/action`, `Microsoft.KeyVault/managedHsm/keys/backup/action`, `Microsoft.KeyVault/managedHsm/keys/restore/action`, `Microsoft.KeyVault/managedHsm/roleAssignments/delete/action`, `Microsoft.KeyVault/managedHsm/roleAssignments/read/action`, `Microsoft.KeyVault/managedHsm/roleAssignments/write/action`, `Microsoft.KeyVault/managedHsm/roleDefinitions/read/action`, `Microsoft.KeyVault/managedHsm/roleDefinitions/write/action`, `Microsoft.KeyVault/managedHsm/roleDefinitions/delete/action`, `Microsoft.KeyVault/managedHsm/keys/encrypt/action`, `Microsoft.KeyVault/managedHsm/keys/decrypt/action`, `Microsoft.KeyVault/managedHsm/keys/wrap/action`, `Microsoft.KeyVault/managedHsm/keys/unwrap/action`, `Microsoft.KeyVault/managedHsm/keys/sign/action`, `Microsoft.KeyVault/managedHsm/keys/verify/action`, `Microsoft.KeyVault/managedHsm/keys/create`, `Microsoft.KeyVault/managedHsm/keys/delete`, `Microsoft.KeyVault/managedHsm/keys/export/action`, `Microsoft.KeyVault/managedHsm/keys/release/action`, `Microsoft.KeyVault/managedHsm/keys/import/action`, `Microsoft.KeyVault/managedHsm/keys/deletedKeys/delete`, `Microsoft.KeyVault/managedHsm/securitydomain/download/action`, `Microsoft.KeyVault/managedHsm/securitydomain/download/read`, `Microsoft.KeyVault/managedHsm/securitydomain/upload/action`, `Microsoft.KeyVault/managedHsm/securitydomain/upload/read`, `Microsoft.KeyVault/managedHsm/securitydomain/transferkey/read`, `Microsoft.KeyVault/managedHsm/backup/start/action`, `Microsoft.KeyVault/managedHsm/restore/start/action`, `Microsoft.KeyVault/managedHsm/backup/status/action`, `Microsoft.KeyVault/managedHsm/restore/status/action` and `Microsoft.KeyVault/managedHsm/rng/action`.
        :param Sequence[_builtins.str] not_actions: One or more Disallowed Actions, such as `*`, `Microsoft.Resources/subscriptions/resourceGroups/read`. See ['Azure Resource Manager resource provider operations'](https://docs.microsoft.com/azure/role-based-access-control/resource-provider-operations) for details.
        :param Sequence[_builtins.str] not_data_actions: Specifies a list of data action permission not to grant. Possible values are `Microsoft.KeyVault/managedHsm/keys/read/action`, `Microsoft.KeyVault/managedHsm/keys/write/action`, `Microsoft.KeyVault/managedHsm/keys/deletedKeys/read/action`, `Microsoft.KeyVault/managedHsm/keys/deletedKeys/recover/action`, `Microsoft.KeyVault/managedHsm/keys/backup/action`, `Microsoft.KeyVault/managedHsm/keys/restore/action`, `Microsoft.KeyVault/managedHsm/roleAssignments/delete/action`, `Microsoft.KeyVault/managedHsm/roleAssignments/read/action`, `Microsoft.KeyVault/managedHsm/roleAssignments/write/action`, `Microsoft.KeyVault/managedHsm/roleDefinitions/read/action`, `Microsoft.KeyVault/managedHsm/roleDefinitions/write/action`, `Microsoft.KeyVault/managedHsm/roleDefinitions/delete/action`, `Microsoft.KeyVault/managedHsm/keys/encrypt/action`, `Microsoft.KeyVault/managedHsm/keys/decrypt/action`, `Microsoft.KeyVault/managedHsm/keys/wrap/action`, `Microsoft.KeyVault/managedHsm/keys/unwrap/action`, `Microsoft.KeyVault/managedHsm/keys/sign/action`, `Microsoft.KeyVault/managedHsm/keys/verify/action`, `Microsoft.KeyVault/managedHsm/keys/create`, `Microsoft.KeyVault/managedHsm/keys/delete`, `Microsoft.KeyVault/managedHsm/keys/export/action`, `Microsoft.KeyVault/managedHsm/keys/release/action`, `Microsoft.KeyVault/managedHsm/keys/import/action`, `Microsoft.KeyVault/managedHsm/keys/deletedKeys/delete`, `Microsoft.KeyVault/managedHsm/securitydomain/download/action`, `Microsoft.KeyVault/managedHsm/securitydomain/download/read`, `Microsoft.KeyVault/managedHsm/securitydomain/upload/action`, `Microsoft.KeyVault/managedHsm/securitydomain/upload/read`, `Microsoft.KeyVault/managedHsm/securitydomain/transferkey/read`, `Microsoft.KeyVault/managedHsm/backup/start/action`, `Microsoft.KeyVault/managedHsm/restore/start/action`, `Microsoft.KeyVault/managedHsm/backup/status/action`, `Microsoft.KeyVault/managedHsm/restore/status/action` and `Microsoft.KeyVault/managedHsm/rng/action`.
        """
        if actions is not None:
            pulumi.set(__self__, "actions", actions)
        if data_actions is not None:
            pulumi.set(__self__, "data_actions", data_actions)
        if not_actions is not None:
            pulumi.set(__self__, "not_actions", not_actions)
        if not_data_actions is not None:
            pulumi.set(__self__, "not_data_actions", not_data_actions)

    @_builtins.property
    @pulumi.getter
    def actions(self) -> Optional[Sequence[_builtins.str]]:
        """
        One or more Allowed Actions, such as `*`, `Microsoft.Resources/subscriptions/resourceGroups/read`. See ['Azure Resource Manager resource provider operations'](https://docs.microsoft.com/azure/role-based-access-control/resource-provider-operations) for details.
        """
        return pulumi.get(self, "actions")

    @_builtins.property
    @pulumi.getter(name="dataActions")
    def data_actions(self) -> Optional[Sequence[_builtins.str]]:
        """
        Specifies a list of data action permission to grant. Possible values are `Microsoft.KeyVault/managedHsm/keys/read/action`, `Microsoft.KeyVault/managedHsm/keys/write/action`, `Microsoft.KeyVault/managedHsm/keys/deletedKeys/read/action`, `Microsoft.KeyVault/managedHsm/keys/deletedKeys/recover/action`, `Microsoft.KeyVault/managedHsm/keys/backup/action`, `Microsoft.KeyVault/managedHsm/keys/restore/action`, `Microsoft.KeyVault/managedHsm/roleAssignments/delete/action`, `Microsoft.KeyVault/managedHsm/roleAssignments/read/action`, `Microsoft.KeyVault/managedHsm/roleAssignments/write/action`, `Microsoft.KeyVault/managedHsm/roleDefinitions/read/action`, `Microsoft.KeyVault/managedHsm/roleDefinitions/write/action`, `Microsoft.KeyVault/managedHsm/roleDefinitions/delete/action`, `Microsoft.KeyVault/managedHsm/keys/encrypt/action`, `Microsoft.KeyVault/managedHsm/keys/decrypt/action`, `Microsoft.KeyVault/managedHsm/keys/wrap/action`, `Microsoft.KeyVault/managedHsm/keys/unwrap/action`, `Microsoft.KeyVault/managedHsm/keys/sign/action`, `Microsoft.KeyVault/managedHsm/keys/verify/action`, `Microsoft.KeyVault/managedHsm/keys/create`, `Microsoft.KeyVault/managedHsm/keys/delete`, `Microsoft.KeyVault/managedHsm/keys/export/action`, `Microsoft.KeyVault/managedHsm/keys/release/action`, `Microsoft.KeyVault/managedHsm/keys/import/action`, `Microsoft.KeyVault/managedHsm/keys/deletedKeys/delete`, `Microsoft.KeyVault/managedHsm/securitydomain/download/action`, `Microsoft.KeyVault/managedHsm/securitydomain/download/read`, `Microsoft.KeyVault/managedHsm/securitydomain/upload/action`, `Microsoft.KeyVault/managedHsm/securitydomain/upload/read`, `Microsoft.KeyVault/managedHsm/securitydomain/transferkey/read`, `Microsoft.KeyVault/managedHsm/backup/start/action`, `Microsoft.KeyVault/managedHsm/restore/start/action`, `Microsoft.KeyVault/managedHsm/backup/status/action`, `Microsoft.KeyVault/managedHsm/restore/status/action` and `Microsoft.KeyVault/managedHsm/rng/action`.
        """
        return pulumi.get(self, "data_actions")

    @_builtins.property
    @pulumi.getter(name="notActions")
    def not_actions(self) -> Optional[Sequence[_builtins.str]]:
        """
        One or more Disallowed Actions, such as `*`, `Microsoft.Resources/subscriptions/resourceGroups/read`. See ['Azure Resource Manager resource provider operations'](https://docs.microsoft.com/azure/role-based-access-control/resource-provider-operations) for details.
        """
        return pulumi.get(self, "not_actions")

    @_builtins.property
    @pulumi.getter(name="notDataActions")
    def not_data_actions(self) -> Optional[Sequence[_builtins.str]]:
        """
        Specifies a list of data action permission not to grant. Possible values are `Microsoft.KeyVault/managedHsm/keys/read/action`, `Microsoft.KeyVault/managedHsm/keys/write/action`, `Microsoft.KeyVault/managedHsm/keys/deletedKeys/read/action`, `Microsoft.KeyVault/managedHsm/keys/deletedKeys/recover/action`, `Microsoft.KeyVault/managedHsm/keys/backup/action`, `Microsoft.KeyVault/managedHsm/keys/restore/action`, `Microsoft.KeyVault/managedHsm/roleAssignments/delete/action`, `Microsoft.KeyVault/managedHsm/roleAssignments/read/action`, `Microsoft.KeyVault/managedHsm/roleAssignments/write/action`, `Microsoft.KeyVault/managedHsm/roleDefinitions/read/action`, `Microsoft.KeyVault/managedHsm/roleDefinitions/write/action`, `Microsoft.KeyVault/managedHsm/roleDefinitions/delete/action`, `Microsoft.KeyVault/managedHsm/keys/encrypt/action`, `Microsoft.KeyVault/managedHsm/keys/decrypt/action`, `Microsoft.KeyVault/managedHsm/keys/wrap/action`, `Microsoft.KeyVault/managedHsm/keys/unwrap/action`, `Microsoft.KeyVault/managedHsm/keys/sign/action`, `Microsoft.KeyVault/managedHsm/keys/verify/action`, `Microsoft.KeyVault/managedHsm/keys/create`, `Microsoft.KeyVault/managedHsm/keys/delete`, `Microsoft.KeyVault/managedHsm/keys/export/action`, `Microsoft.KeyVault/managedHsm/keys/release/action`, `Microsoft.KeyVault/managedHsm/keys/import/action`, `Microsoft.KeyVault/managedHsm/keys/deletedKeys/delete`, `Microsoft.KeyVault/managedHsm/securitydomain/download/action`, `Microsoft.KeyVault/managedHsm/securitydomain/download/read`, `Microsoft.KeyVault/managedHsm/securitydomain/upload/action`, `Microsoft.KeyVault/managedHsm/securitydomain/upload/read`, `Microsoft.KeyVault/managedHsm/securitydomain/transferkey/read`, `Microsoft.KeyVault/managedHsm/backup/start/action`, `Microsoft.KeyVault/managedHsm/restore/start/action`, `Microsoft.KeyVault/managedHsm/backup/status/action`, `Microsoft.KeyVault/managedHsm/restore/status/action` and `Microsoft.KeyVault/managedHsm/rng/action`.
        """
        return pulumi.get(self, "not_data_actions")


@pulumi.output_type
class GetCertificateCertificatePolicyResult(dict):
    def __init__(__self__, *,
                 issuer_parameters: Sequence['outputs.GetCertificateCertificatePolicyIssuerParameterResult'],
                 key_properties: Sequence['outputs.GetCertificateCertificatePolicyKeyPropertyResult'],
                 lifetime_actions: Sequence['outputs.GetCertificateCertificatePolicyLifetimeActionResult'],
                 secret_properties: Sequence['outputs.GetCertificateCertificatePolicySecretPropertyResult'],
                 x509_certificate_properties: Sequence['outputs.GetCertificateCertificatePolicyX509CertificatePropertyResult']):
        """
        :param Sequence['GetCertificateCertificatePolicyIssuerParameterArgs'] issuer_parameters: A `issuer_parameters` block as defined below.
        :param Sequence['GetCertificateCertificatePolicyKeyPropertyArgs'] key_properties: A `key_properties` block as defined below.
        :param Sequence['GetCertificateCertificatePolicyLifetimeActionArgs'] lifetime_actions: A `lifetime_action` block as defined below.
        :param Sequence['GetCertificateCertificatePolicySecretPropertyArgs'] secret_properties: A `secret_properties` block as defined below.
        :param Sequence['GetCertificateCertificatePolicyX509CertificatePropertyArgs'] x509_certificate_properties: An `x509_certificate_properties` block as defined below.
        """
        pulumi.set(__self__, "issuer_parameters", issuer_parameters)
        pulumi.set(__self__, "key_properties", key_properties)
        pulumi.set(__self__, "lifetime_actions", lifetime_actions)
        pulumi.set(__self__, "secret_properties", secret_properties)
        pulumi.set(__self__, "x509_certificate_properties", x509_certificate_properties)

    @_builtins.property
    @pulumi.getter(name="issuerParameters")
    def issuer_parameters(self) -> Sequence['outputs.GetCertificateCertificatePolicyIssuerParameterResult']:
        """
        A `issuer_parameters` block as defined below.
        """
        return pulumi.get(self, "issuer_parameters")

    @_builtins.property
    @pulumi.getter(name="keyProperties")
    def key_properties(self) -> Sequence['outputs.GetCertificateCertificatePolicyKeyPropertyResult']:
        """
        A `key_properties` block as defined below.
        """
        return pulumi.get(self, "key_properties")

    @_builtins.property
    @pulumi.getter(name="lifetimeActions")
    def lifetime_actions(self) -> Sequence['outputs.GetCertificateCertificatePolicyLifetimeActionResult']:
        """
        A `lifetime_action` block as defined below.
        """
        return pulumi.get(self, "lifetime_actions")

    @_builtins.property
    @pulumi.getter(name="secretProperties")
    def secret_properties(self) -> Sequence['outputs.GetCertificateCertificatePolicySecretPropertyResult']:
        """
        A `secret_properties` block as defined below.
        """
        return pulumi.get(self, "secret_properties")

    @_builtins.property
    @pulumi.getter(name="x509CertificateProperties")
    def x509_certificate_properties(self) -> Sequence['outputs.GetCertificateCertificatePolicyX509CertificatePropertyResult']:
        """
        An `x509_certificate_properties` block as defined below.
        """
        return pulumi.get(self, "x509_certificate_properties")


@pulumi.output_type
class GetCertificateCertificatePolicyIssuerParameterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str):
        """
        :param _builtins.str name: Specifies the name of the Key Vault Certificate.
        """
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Specifies the name of the Key Vault Certificate.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetCertificateCertificatePolicyKeyPropertyResult(dict):
    def __init__(__self__, *,
                 curve: _builtins.str,
                 exportable: _builtins.bool,
                 key_size: _builtins.int,
                 key_type: _builtins.str,
                 reuse_key: _builtins.bool):
        """
        :param _builtins.bool exportable: Is this Certificate Exportable?
        :param _builtins.int key_size: The size of the Key used in the Certificate.
        :param _builtins.str key_type: Specifies the Type of Key, for example `RSA`.
        :param _builtins.bool reuse_key: Is the key reusable?
        """
        pulumi.set(__self__, "curve", curve)
        pulumi.set(__self__, "exportable", exportable)
        pulumi.set(__self__, "key_size", key_size)
        pulumi.set(__self__, "key_type", key_type)
        pulumi.set(__self__, "reuse_key", reuse_key)

    @_builtins.property
    @pulumi.getter
    def curve(self) -> _builtins.str:
        return pulumi.get(self, "curve")

    @_builtins.property
    @pulumi.getter
    def exportable(self) -> _builtins.bool:
        """
        Is this Certificate Exportable?
        """
        return pulumi.get(self, "exportable")

    @_builtins.property
    @pulumi.getter(name="keySize")
    def key_size(self) -> _builtins.int:
        """
        The size of the Key used in the Certificate.
        """
        return pulumi.get(self, "key_size")

    @_builtins.property
    @pulumi.getter(name="keyType")
    def key_type(self) -> _builtins.str:
        """
        Specifies the Type of Key, for example `RSA`.
        """
        return pulumi.get(self, "key_type")

    @_builtins.property
    @pulumi.getter(name="reuseKey")
    def reuse_key(self) -> _builtins.bool:
        """
        Is the key reusable?
        """
        return pulumi.get(self, "reuse_key")


@pulumi.output_type
class GetCertificateCertificatePolicyLifetimeActionResult(dict):
    def __init__(__self__, *,
                 actions: Sequence['outputs.GetCertificateCertificatePolicyLifetimeActionActionResult'],
                 triggers: Sequence['outputs.GetCertificateCertificatePolicyLifetimeActionTriggerResult']):
        """
        :param Sequence['GetCertificateCertificatePolicyLifetimeActionActionArgs'] actions: A `action` block as defined below.
        :param Sequence['GetCertificateCertificatePolicyLifetimeActionTriggerArgs'] triggers: A `trigger` block as defined below.
        """
        pulumi.set(__self__, "actions", actions)
        pulumi.set(__self__, "triggers", triggers)

    @_builtins.property
    @pulumi.getter
    def actions(self) -> Sequence['outputs.GetCertificateCertificatePolicyLifetimeActionActionResult']:
        """
        A `action` block as defined below.
        """
        return pulumi.get(self, "actions")

    @_builtins.property
    @pulumi.getter
    def triggers(self) -> Sequence['outputs.GetCertificateCertificatePolicyLifetimeActionTriggerResult']:
        """
        A `trigger` block as defined below.
        """
        return pulumi.get(self, "triggers")


@pulumi.output_type
class GetCertificateCertificatePolicyLifetimeActionActionResult(dict):
    def __init__(__self__, *,
                 action_type: _builtins.str):
        """
        :param _builtins.str action_type: The Type of action to be performed when the lifetime trigger is triggerec.
        """
        pulumi.set(__self__, "action_type", action_type)

    @_builtins.property
    @pulumi.getter(name="actionType")
    def action_type(self) -> _builtins.str:
        """
        The Type of action to be performed when the lifetime trigger is triggerec.
        """
        return pulumi.get(self, "action_type")


@pulumi.output_type
class GetCertificateCertificatePolicyLifetimeActionTriggerResult(dict):
    def __init__(__self__, *,
                 days_before_expiry: _builtins.int,
                 lifetime_percentage: _builtins.int):
        """
        :param _builtins.int days_before_expiry: The number of days before the Certificate expires that the action associated with this Trigger should run.
        :param _builtins.int lifetime_percentage: The percentage at which during the Certificates Lifetime the action associated with this Trigger should run.
        """
        pulumi.set(__self__, "days_before_expiry", days_before_expiry)
        pulumi.set(__self__, "lifetime_percentage", lifetime_percentage)

    @_builtins.property
    @pulumi.getter(name="daysBeforeExpiry")
    def days_before_expiry(self) -> _builtins.int:
        """
        The number of days before the Certificate expires that the action associated with this Trigger should run.
        """
        return pulumi.get(self, "days_before_expiry")

    @_builtins.property
    @pulumi.getter(name="lifetimePercentage")
    def lifetime_percentage(self) -> _builtins.int:
        """
        The percentage at which during the Certificates Lifetime the action associated with this Trigger should run.
        """
        return pulumi.get(self, "lifetime_percentage")


@pulumi.output_type
class GetCertificateCertificatePolicySecretPropertyResult(dict):
    def __init__(__self__, *,
                 content_type: _builtins.str):
        """
        :param _builtins.str content_type: The Content-Type of the Certificate, for example `application/x-pkcs12` for a PFX or `application/x-pem-file` for a PEM.
        """
        pulumi.set(__self__, "content_type", content_type)

    @_builtins.property
    @pulumi.getter(name="contentType")
    def content_type(self) -> _builtins.str:
        """
        The Content-Type of the Certificate, for example `application/x-pkcs12` for a PFX or `application/x-pem-file` for a PEM.
        """
        return pulumi.get(self, "content_type")


@pulumi.output_type
class GetCertificateCertificatePolicyX509CertificatePropertyResult(dict):
    def __init__(__self__, *,
                 extended_key_usages: Sequence[_builtins.str],
                 key_usages: Sequence[_builtins.str],
                 subject: _builtins.str,
                 subject_alternative_names: Sequence['outputs.GetCertificateCertificatePolicyX509CertificatePropertySubjectAlternativeNameResult'],
                 validity_in_months: _builtins.int):
        """
        :param Sequence[_builtins.str] extended_key_usages: A list of Extended/Enhanced Key Usages.
        :param Sequence[_builtins.str] key_usages: A list of uses associated with this Key.
        :param _builtins.str subject: The Certificate's Subject.
        :param Sequence['GetCertificateCertificatePolicyX509CertificatePropertySubjectAlternativeNameArgs'] subject_alternative_names: A `subject_alternative_names` block as defined below.
        :param _builtins.int validity_in_months: The Certificates Validity Period in Months.
        """
        pulumi.set(__self__, "extended_key_usages", extended_key_usages)
        pulumi.set(__self__, "key_usages", key_usages)
        pulumi.set(__self__, "subject", subject)
        pulumi.set(__self__, "subject_alternative_names", subject_alternative_names)
        pulumi.set(__self__, "validity_in_months", validity_in_months)

    @_builtins.property
    @pulumi.getter(name="extendedKeyUsages")
    def extended_key_usages(self) -> Sequence[_builtins.str]:
        """
        A list of Extended/Enhanced Key Usages.
        """
        return pulumi.get(self, "extended_key_usages")

    @_builtins.property
    @pulumi.getter(name="keyUsages")
    def key_usages(self) -> Sequence[_builtins.str]:
        """
        A list of uses associated with this Key.
        """
        return pulumi.get(self, "key_usages")

    @_builtins.property
    @pulumi.getter
    def subject(self) -> _builtins.str:
        """
        The Certificate's Subject.
        """
        return pulumi.get(self, "subject")

    @_builtins.property
    @pulumi.getter(name="subjectAlternativeNames")
    def subject_alternative_names(self) -> Sequence['outputs.GetCertificateCertificatePolicyX509CertificatePropertySubjectAlternativeNameResult']:
        """
        A `subject_alternative_names` block as defined below.
        """
        return pulumi.get(self, "subject_alternative_names")

    @_builtins.property
    @pulumi.getter(name="validityInMonths")
    def validity_in_months(self) -> _builtins.int:
        """
        The Certificates Validity Period in Months.
        """
        return pulumi.get(self, "validity_in_months")


@pulumi.output_type
class GetCertificateCertificatePolicyX509CertificatePropertySubjectAlternativeNameResult(dict):
    def __init__(__self__, *,
                 dns_names: Sequence[_builtins.str],
                 emails: Sequence[_builtins.str],
                 upns: Sequence[_builtins.str]):
        """
        :param Sequence[_builtins.str] dns_names: A list of alternative DNS names (FQDNs) identified by the Certificate.
        :param Sequence[_builtins.str] emails: A list of email addresses identified by this Certificate.
        :param Sequence[_builtins.str] upns: A list of User Principal Names identified by the Certificate.
        """
        pulumi.set(__self__, "dns_names", dns_names)
        pulumi.set(__self__, "emails", emails)
        pulumi.set(__self__, "upns", upns)

    @_builtins.property
    @pulumi.getter(name="dnsNames")
    def dns_names(self) -> Sequence[_builtins.str]:
        """
        A list of alternative DNS names (FQDNs) identified by the Certificate.
        """
        return pulumi.get(self, "dns_names")

    @_builtins.property
    @pulumi.getter
    def emails(self) -> Sequence[_builtins.str]:
        """
        A list of email addresses identified by this Certificate.
        """
        return pulumi.get(self, "emails")

    @_builtins.property
    @pulumi.getter
    def upns(self) -> Sequence[_builtins.str]:
        """
        A list of User Principal Names identified by the Certificate.
        """
        return pulumi.get(self, "upns")


@pulumi.output_type
class GetCertificateIssuerAdminResult(dict):
    def __init__(__self__, *,
                 email_address: _builtins.str,
                 first_name: _builtins.str,
                 last_name: _builtins.str,
                 phone: _builtins.str):
        """
        :param _builtins.str email_address: E-mail address of the admin.
        :param _builtins.str first_name: First name of the admin.
        :param _builtins.str last_name: Last name of the admin.
        :param _builtins.str phone: Phone number of the admin.
        """
        pulumi.set(__self__, "email_address", email_address)
        pulumi.set(__self__, "first_name", first_name)
        pulumi.set(__self__, "last_name", last_name)
        pulumi.set(__self__, "phone", phone)

    @_builtins.property
    @pulumi.getter(name="emailAddress")
    def email_address(self) -> _builtins.str:
        """
        E-mail address of the admin.
        """
        return pulumi.get(self, "email_address")

    @_builtins.property
    @pulumi.getter(name="firstName")
    def first_name(self) -> _builtins.str:
        """
        First name of the admin.
        """
        return pulumi.get(self, "first_name")

    @_builtins.property
    @pulumi.getter(name="lastName")
    def last_name(self) -> _builtins.str:
        """
        Last name of the admin.
        """
        return pulumi.get(self, "last_name")

    @_builtins.property
    @pulumi.getter
    def phone(self) -> _builtins.str:
        """
        Phone number of the admin.
        """
        return pulumi.get(self, "phone")


@pulumi.output_type
class GetCertificatesCertificateResult(dict):
    def __init__(__self__, *,
                 enabled: _builtins.bool,
                 id: _builtins.str,
                 name: _builtins.str,
                 tags: Mapping[str, _builtins.str]):
        """
        :param _builtins.bool enabled: Whether this certificate is enabled.
        :param _builtins.str id: The ID of this certificate.
        :param _builtins.str name: The name of certificate.
        :param Mapping[str, _builtins.str] tags: The tags of this certificate.
        """
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        """
        Whether this certificate is enabled.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of this certificate.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of certificate.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        The tags of this certificate.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class GetKeyVaultAccessPolicyResult(dict):
    def __init__(__self__, *,
                 application_id: _builtins.str,
                 certificate_permissions: Sequence[_builtins.str],
                 key_permissions: Sequence[_builtins.str],
                 object_id: _builtins.str,
                 secret_permissions: Sequence[_builtins.str],
                 storage_permissions: Sequence[_builtins.str],
                 tenant_id: _builtins.str):
        """
        :param _builtins.str application_id: The Object ID of a Azure Active Directory Application.
        :param Sequence[_builtins.str] certificate_permissions: A list of certificate permissions applicable to this Access Policy.
        :param Sequence[_builtins.str] key_permissions: A list of key permissions applicable to this Access Policy.
        :param _builtins.str object_id: An Object ID of a User, Service Principal or Security Group.
        :param Sequence[_builtins.str] secret_permissions: A list of secret permissions applicable to this Access Policy.
        :param Sequence[_builtins.str] storage_permissions: A list of storage permissions applicable to this Access Policy.
        :param _builtins.str tenant_id: The Azure Active Directory Tenant ID used to authenticate requests for this Key Vault.
        """
        pulumi.set(__self__, "application_id", application_id)
        pulumi.set(__self__, "certificate_permissions", certificate_permissions)
        pulumi.set(__self__, "key_permissions", key_permissions)
        pulumi.set(__self__, "object_id", object_id)
        pulumi.set(__self__, "secret_permissions", secret_permissions)
        pulumi.set(__self__, "storage_permissions", storage_permissions)
        pulumi.set(__self__, "tenant_id", tenant_id)

    @_builtins.property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> _builtins.str:
        """
        The Object ID of a Azure Active Directory Application.
        """
        return pulumi.get(self, "application_id")

    @_builtins.property
    @pulumi.getter(name="certificatePermissions")
    def certificate_permissions(self) -> Sequence[_builtins.str]:
        """
        A list of certificate permissions applicable to this Access Policy.
        """
        return pulumi.get(self, "certificate_permissions")

    @_builtins.property
    @pulumi.getter(name="keyPermissions")
    def key_permissions(self) -> Sequence[_builtins.str]:
        """
        A list of key permissions applicable to this Access Policy.
        """
        return pulumi.get(self, "key_permissions")

    @_builtins.property
    @pulumi.getter(name="objectId")
    def object_id(self) -> _builtins.str:
        """
        An Object ID of a User, Service Principal or Security Group.
        """
        return pulumi.get(self, "object_id")

    @_builtins.property
    @pulumi.getter(name="secretPermissions")
    def secret_permissions(self) -> Sequence[_builtins.str]:
        """
        A list of secret permissions applicable to this Access Policy.
        """
        return pulumi.get(self, "secret_permissions")

    @_builtins.property
    @pulumi.getter(name="storagePermissions")
    def storage_permissions(self) -> Sequence[_builtins.str]:
        """
        A list of storage permissions applicable to this Access Policy.
        """
        return pulumi.get(self, "storage_permissions")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> _builtins.str:
        """
        The Azure Active Directory Tenant ID used to authenticate requests for this Key Vault.
        """
        return pulumi.get(self, "tenant_id")


@pulumi.output_type
class GetKeyVaultNetworkAclResult(dict):
    def __init__(__self__, *,
                 bypass: _builtins.str,
                 default_action: _builtins.str,
                 ip_rules: Sequence[_builtins.str],
                 virtual_network_subnet_ids: Sequence[_builtins.str]):
        pulumi.set(__self__, "bypass", bypass)
        pulumi.set(__self__, "default_action", default_action)
        pulumi.set(__self__, "ip_rules", ip_rules)
        pulumi.set(__self__, "virtual_network_subnet_ids", virtual_network_subnet_ids)

    @_builtins.property
    @pulumi.getter
    def bypass(self) -> _builtins.str:
        return pulumi.get(self, "bypass")

    @_builtins.property
    @pulumi.getter(name="defaultAction")
    def default_action(self) -> _builtins.str:
        return pulumi.get(self, "default_action")

    @_builtins.property
    @pulumi.getter(name="ipRules")
    def ip_rules(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "ip_rules")

    @_builtins.property
    @pulumi.getter(name="virtualNetworkSubnetIds")
    def virtual_network_subnet_ids(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "virtual_network_subnet_ids")


@pulumi.output_type
class GetManagedHardwareSecurityModuleRoleDefinitionPermissionResult(dict):
    def __init__(__self__, *,
                 actions: Sequence[_builtins.str],
                 data_actions: Sequence[_builtins.str],
                 not_actions: Sequence[_builtins.str],
                 not_data_actions: Sequence[_builtins.str]):
        """
        :param Sequence[_builtins.str] actions: A list of action permission granted.
        :param Sequence[_builtins.str] data_actions: A list of data action permission granted.
        :param Sequence[_builtins.str] not_actions: A list of action permission excluded (but not denied).
        :param Sequence[_builtins.str] not_data_actions: A list of data action permission granted.
        """
        pulumi.set(__self__, "actions", actions)
        pulumi.set(__self__, "data_actions", data_actions)
        pulumi.set(__self__, "not_actions", not_actions)
        pulumi.set(__self__, "not_data_actions", not_data_actions)

    @_builtins.property
    @pulumi.getter
    def actions(self) -> Sequence[_builtins.str]:
        """
        A list of action permission granted.
        """
        return pulumi.get(self, "actions")

    @_builtins.property
    @pulumi.getter(name="dataActions")
    def data_actions(self) -> Sequence[_builtins.str]:
        """
        A list of data action permission granted.
        """
        return pulumi.get(self, "data_actions")

    @_builtins.property
    @pulumi.getter(name="notActions")
    def not_actions(self) -> Sequence[_builtins.str]:
        """
        A list of action permission excluded (but not denied).
        """
        return pulumi.get(self, "not_actions")

    @_builtins.property
    @pulumi.getter(name="notDataActions")
    def not_data_actions(self) -> Sequence[_builtins.str]:
        """
        A list of data action permission granted.
        """
        return pulumi.get(self, "not_data_actions")


@pulumi.output_type
class GetSecretsSecretResult(dict):
    def __init__(__self__, *,
                 enabled: _builtins.bool,
                 id: _builtins.str,
                 name: _builtins.str,
                 tags: Mapping[str, _builtins.str]):
        """
        :param _builtins.bool enabled: Whether this secret is enabled.
        :param _builtins.str id: The ID of this secret.
        :param _builtins.str name: The name of secret.
        :param Mapping[str, _builtins.str] tags: The tags of this secret.
        """
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        """
        Whether this secret is enabled.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of this secret.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of secret.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        The tags of this secret.
        """
        return pulumi.get(self, "tags")


